'use strict';
define(()=> {
    let HtmlUtils = function() {

      let addSignet = (elem, found, value)=>{
        if (found && angular.isDefined(value)) {
          if (value.indexOf("[$index]") > -1){
            let parentDivWithDataIndex = $(elem).closest("[data-index]");
            if (parentDivWithDataIndex.length > 0){
              let index = parentDivWithDataIndex.data("index");
              if (!isNaN(index)) {
                value = value.replace("[$index]", "[" + index + "]");
              }
            }
          }
          $(elem).before(
            $('<div/>', {
              html:
                "<span class='feederKey label label-info' title='"
                + value
                + "'> ... </span>",
            })
          );
        }
      };

      let feedInputSignet = (elem)=> {
        let value = '';
        let model = '';
        let found = false;
        if ($(elem).attr('data-ng-model') !== undefined) {
          model = $(elem).attr('data-ng-model');
        }
        else {
          if ($(elem).attr('ng-model') !== undefined) {
            model = $(elem).attr('ng-model');
          }
          else {
            if ($(elem).attr('fieldModel') !== undefined
              && $(elem).attr('fieldAttribute') !== undefined) {
              model = $(elem).attr('fieldModel') + '.'
                + $(elem).attr('fieldAttribute');
            }
          }
        }

        if (angular.isUndefined(model)) return;
        if(model.includes("currentCahier.properties")) return;
        if(model.includes("vdata.vidangeur")) return;

        if(model.includes('currentReport.properties')){
          model = model.replace('currentReport.properties', 'dossier');
          found = true;
        }

        if (model.split('.')[0] === 'res') {
          let prevElem = $(elem).prev();
          model = prevElem.attr('data-for');
          if(model !== undefined &&  model.indexOf('.') === 0){
            model = 'dossier' + model;
          }
          found = true;

        }
        else {
          if ( model.split('.')[1] === 'res') {
            let prevElem = $(elem).prev();
            model = prevElem.attr('data-for');
            if(model !== undefined && model.indexOf('.') === 0){
              model = 'dossier' + model;
            }
            found = true;
          }
        }

        if (model === 'result[att.name]') {
          let date = $(elem).closest('div[javautildate]');
          model = date.attr('data-ng-model');
          if(model === undefined && date.attr('result') && date.attr('gcatt')
            && date.attr('result') !== 'res'){
            model = date.attr('result') + '.' +
              date.attr('gcatt').split(':')[1]
              .replace(/'/g, '')
              .replace(/}/g, '')
              .replace(/{/g, '');
          }

          if(model !== undefined){
            found = true;
          }
        }

        if ($(elem).attr('fieldModel') !== undefined
          && $(elem).attr('fieldAttribute') !== undefined) {
          model = $(elem).attr('fieldModel') +'.'
            + $(elem).attr('fieldAttribute');
          found = true;
        }
        if (angular.isUndefined(model)) return;

        if ($(elem).attr('type') === 'text' || $(elem).attr('type') === 'number') {
          value = '#{' + model + '}';
          found = true;
        }

        if ($(elem).attr('type') === 'checkbox') {
          value = '#{' + model + '-CB-1}';
          found = true;
        }

        if ($(elem).attr('type') === 'radio') {
          let valueRadio = $(elem).attr('value');
          value = '#{' + model + '-CB-' + valueRadio + '}';
          found = true;
        }

        if(model.includes('demande.properties')){
          model = model.replace('demande.properties', 'demande');
          value = '#{' + model + '}';
          found = true;
        }

        if(model.includes('currentReport.properties')){
          model = model.replace('currentReport.properties', 'dossier');
          value = '#{' + model + '}';
          found = true;
        }
        if(model.includes("newCahier")) return;
        if(model.includes("newVidange")) return;
        if(model.includes("currentRelationProprio")) return;
        addSignet(elem, found, value);
      };

      let feedTextareaSignet = (elem)=>{
        let value = '';
        let model = '';
        if ($(elem).attr('data-ng-model') !== undefined) {
          model = $(elem).attr('data-ng-model');
        }
        else {
          if ($(elem).attr('ng-model') !== undefined) {
            model = $(elem).attr('ng-model');
          }
          else {
            if ($(elem).attr('fieldModel') !== undefined && $(elem).attr('fieldAttribute') !== undefined) {
              model = $(elem).attr('fieldModel') + '.'
                + $(elem).attr('fieldAttribute');
            }
          }
        }
        if(model.includes('currentReport.properties')){
          model = model.replace('currentReport.properties', 'dossier');
        }
        if(model.includes('dossier.properties')){
          model = model.replace('dossier.properties', 'dossier');
        }
        if (model === 'result[att.name]') {
          let date = $(elem).closest('div[javautildate]');
          model = date.attr('data-ng-model');
        }
        if (angular.isUndefined(model)) return;
        if (model.split('.')[0] === 'res') {
          let prevElem = $(elem).prev();
          model = prevElem.attr('data-for');
          if(model !== undefined &&  model.indexOf('.') === 0){
            model = 'dossier' + model;
          }
        }
        else {
          if ( model.split('.')[1] === 'res') {
            let prevElem = $(elem).prev();
            model = prevElem.attr('data-for');
            if(model !== undefined && model.indexOf('.') === 0){
              model = 'dossier' + model;
            }
          }
        }
        if(model !== undefined && model.includes('demande.properties')){
          model = model.replace('demande.properties', 'demande');
        }
        value = '#{' + model + '}';
        addSignet(elem, true, value);
      };

      let feedSelectFormControlSignet = (elem)=> {
        let value = '';
        let model = $(elem).attr('ng-model');
        if(model === 'action.selectedAction') return;
        if(model === 'newCtrlType.value') return;
        if (angular.isDefined(model) && model.split('[')[0] === 'res') {
          let findFormField = $(elem).closest('div[form-field]');
          let attrsFindFormField = {};
          if(findFormField !== undefined && findFormField[0] !== undefined){
            $.each( findFormField[0].attributes, ( index, attribute )=> {
              attrsFindFormField[attribute.name] = attribute.value;
            });
          }
          if(Object.keys(attrsFindFormField).includes('res')
            && Object.keys(attrsFindFormField).includes('attname')){
            model = attrsFindFormField.res + '.' + attrsFindFormField.attname.replace(/'/g, '');
            if(attrsFindFormField.attname === 'attr.name'
            && findFormField !== undefined){
              let prevElem = findFormField.prev();
              if( prevElem.attr('data-for') !== undefined){
                model = prevElem.attr('data-for');
              }
            }
          }
          value = '#{' + model + '}';
        }
        else {
          if (angular.isDefined(model) && model.split('[')[1] === 'res') {
            let findFormField = $(elem).closest('div[form-field]');
            let attrsFindFormField = {};
            if (findFormField !== undefined && findFormField[0] !== undefined) {
              $.each(findFormField[0].attributes, (index, attribute)=> {
                attrsFindFormField[attribute.name] = attribute.value;
              });
            }
            if (Object.keys(attrsFindFormField).includes('res')
              && Object.keys(attrsFindFormField).includes('attname')) {
              model = attrsFindFormField.res + '.'
                + attrsFindFormField.attname.replace(/'/g, '');
              if (attrsFindFormField.attname === 'attr.name') {
                let prevElem = findFormField.prev();
                if (prevElem.attr('data-for') !== undefined) {
                  model = prevElem.attr('data-for');
                }
              }
            }
            value = '#{' + model + '}';
          }
        }
        if (angular.isUndefined(model)) return;
        if(model.includes('currentReport.properties')){
          model = model.replace('currentReport.properties', 'dossier');
          value = '#{' + model + '}';
        }
        if (angular.isUndefined(model)) return;
        if (angular.isDefined(model) && model.split('.')[0] === 'res') {
          let prevElem = $(elem.previousElementSibling);
          model = prevElem.attr('data-for');
          if(model !== undefined &&  model.indexOf('.') === 0){
            model = 'dossier' + model;
          }
          value = '#{' + model + '}';
        }
        else {
          if(angular.isDefined(model) && model.split('.')[1] === 'res'){
            let prevElem = $(elem.previousElementSibling);
            model = prevElem.attr('data-for');
            if(model !== undefined &&  model.indexOf('.') === 0){
              model = 'dossier' + model;
            }
            value = '#{' + model + '}';
          }
        }

        if (angular.isUndefined(model)) {
          model = $(elem)
          .closest('anc-civilite')
          .attr('res');
          if(angular.isUndefined(model)) return;
          model = model.substring(6, model.length);
          value = '#{' + model + '}';
        }
        if(model.includes('demande.properties')){
          model = model.replace('demande.properties', 'demande');
          value = '#{' + model + '}';
        }
        value = '#{' + model + '}';
        if (model !== undefined) {
          addSignet(elem, true, value);
        }
      };

      let feedSelectOtherSignet = (elem)=> {
        let value = '';
        let model = $(elem).attr('ng-model');
        if(model === 'action.selectedAction') return;
        if(model === 'newCtrlType.value') return;
        if(model === 'criterias[att.name].value') return;
        if(model === 'criterias[att.name].symbol') return;
        if(model === 'criterias[select_filter_values_extra[att.name].key].value') return;
        if(model === 'criterias[select_filter_values_extra[att.name].key].symbolExtra') return;
        if(model === 'currentSearchMode.v') return;

        if (angular.isDefined(model) && model.split('[')[0] === 'res') {
          let findFormField = $(elem).closest('div[form-field]');
          let attrsFindFormField = {};
          if(findFormField !== undefined && findFormField[0] !== undefined){
            $.each( findFormField[0].attributes, ( index, attribute )=> {
              attrsFindFormField[attribute.name] = attribute.value;
            });
          }
          if(Object.keys(attrsFindFormField).includes('res')
            && Object.keys(attrsFindFormField).includes('attname')){
            model = attrsFindFormField.res + '.' + attrsFindFormField.attname.replace(/'/g, '');
            if(attrsFindFormField.attname === 'attr.name'
            && findFormField !== undefined){
              let prevElem = findFormField.prev();
              if( prevElem.attr('data-for') !== undefined){
                model = prevElem.attr('data-for');
              }
            }
          }
          value = '#{' + model + '}';
        }
        if (angular.isUndefined(model)) return;
        if (angular.isDefined(model) && model.split('.')[0] === 'res') {
          let prevElem = $(elem.previousElementSibling);
          model = prevElem.attr('data-for');
          value = '#{' + model + '}';
        }
        else {
          if ( model.split('.')[1] === 'res') {
            let prevElem = $(elem).prev();
            model = prevElem.attr('data-for');
          }

          if(model !== undefined &&  model.indexOf('.') === 0){
            model = 'dossier' + model;
          }
          value = '#{' + model + '}';
        }
        if (angular.isUndefined(model)) {
          model = $(elem)
          .closest('anc-civilite')
          .attr('res');
          if (angular.isUndefined(model)) return;

          model = model.substring(6, model.length);
          value = '#{' + model + '}';
        }
        if(model.includes('currentReport.properties')){
          model = model.replace('currentReport.properties', 'dossier');
          value = '#{' + model + '}';
        }
        if(model.includes('demande.properties')){
          model = model.replace('demande.properties', 'demande');
          value = '#{' + model + '}';
        }
        if (model !== undefined) {
          addSignet(elem, true, value);
        }
      };

      let feedFormControlSignet = (elem)=> {
        let value = '';
        let model = '';
        if ($(elem).attr('data-ng-model') !== undefined) {
          model = $(elem).attr('data-ng-model');
        }
        else {
          if ($(elem).attr('ng-model') !== undefined) {
            model = $(elem).attr('ng-model');
          }
          else {
            if ($(elem).attr('fieldModel') !== undefined
              && $(elem).attr('fieldAttribute') !== undefined  ) {
              model = $(elem).attr('fieldModel') + '.'
                + $(elem).attr('fieldAttribute');
            }
          }
        }
        if (angular.isUndefined(model)) return;
        let findFormField = $(elem).closest('div[form-field]');
        let attrsFindFormField = {};
        if(findFormField !== undefined && findFormField[0] !== undefined) {
          $.each(findFormField[0].attributes, (index, attribute) => {
            attrsFindFormField[attribute.name] = attribute.value;
          });
        }
        if(Object.keys(attrsFindFormField).includes('res')
          && Object.keys(attrsFindFormField).includes('attname')){
          model = attrsFindFormField.res + '.'
            + attrsFindFormField.attname.replace(/'/g, '');
          let prevElem = findFormField.prev();
          let attrs = {};
          if(prevElem !== undefined && prevElem[0] !== undefined ){
            $.each( prevElem[0].attributes, ( index, attribute )=> {
              attrs[attribute.name] = attribute.value;
            });
            if(Object.keys(attrs).includes('res')
              && Object.keys(attrs).includes('attname')) {
              model = attrs.res + '.' + attrs.attname.replace(/'/g, '');
              if(attrs.attname === 'attr.name'){
                let prevElem = findFormField.prev();
                if( prevElem.attr('data-for') !== undefined){
                  model = prevElem.attr('data-for');
                }
              }
            }
          }
          if( prevElem.attr('data-for') !== undefined){
            model = prevElem.attr('data-for');
          }
        }
        if(model.includes('model.') && model.indexOf('model.') === 0){
          model = model.replace('model', 'dossier');
        }
        if(model.includes('currentReport.properties')){
          model = model.replace('currentReport.properties', 'dossier');
        }
        if(model.includes('demande.properties')){
          model = model.replace('demande.properties', 'demande');
        }
        value = '#{' + model + '}';
        addSignet(elem, true, value);
      };

      let copyToClipboard = (value)=> {
        let dummy = document.createElement('input');
        document.body.appendChild(dummy);
        dummy.setAttribute('value', value);
        dummy.select();
        document.execCommand('copy');
        document.body.removeChild(dummy);
        require('toastr').success('Copie de ' + value, '', {
          positionClass: 'toast-bottom-left',
        });
      };

      let copyToClipboardImageLabelSignet = (image ,imageLabel)=> {
        let dummy = document.createElement('input');
        document.body.appendChild(dummy);
        dummy.setAttribute('value', image + imageLabel);
        dummy.select();
        document.execCommand('copy');
        document.body.removeChild(dummy);
        require('toastr').success('Copie de <br>' +
        image +  '<br>' + imageLabel, '', {
          positionClass: 'toast-bottom-left',
        });
      };

      let clickOnFeederKey = (elem)=>{
        let toCopy = $(elem).attr('title');
        copyToClipboard(toCopy);
      };

      return {
        addSignet: addSignet,
        feedInputSignet: feedInputSignet,
        feedTextareaSignet: feedTextareaSignet,
        feedSelectFormControlSignet: feedSelectFormControlSignet,
        feedSelectOtherSignet: feedSelectOtherSignet,
        feedFormControlSignet: feedFormControlSignet,
        copyToClipboard: copyToClipboard,
        copyToClipboardImageLabelSignet , copyToClipboardImageLabelSignet,
        clickOnFeederKey: clickOnFeederKey
      };
    };
    return HtmlUtils;
  }
);
