'use strict';

define(function() {
  var ficheDCtrl = function(
    $scope,
    AncAppFactory,
    ngDialog,
    FeatureTypeFactory,
    EditFactory,
    UsersFactory,
    $timeout
  ) {
    // prefill info spanc
    $scope.refreshSpancInfo = function() {
      if (AncAppFactory.appCfg.main.infosSpanc) {
        $scope.infosSpanc = AncAppFactory.appCfg.main.infosSpanc;
        if (angular.isDefined($scope.infosSpanc.adresse_num_rue))
          $scope.cdata.general.reference_spanc =
            $scope.infosSpanc.adresse_num_rue + ' ';
        if (angular.isDefined($scope.infosSpanc.adresse_rue))
          $scope.cdata.general.reference_spanc +=
            $scope.infosSpanc.adresse_rue + ' ';
        if (angular.isDefined($scope.infosSpanc.adresse_ville))
          $scope.cdata.general.reference_spanc +=
            $scope.infosSpanc.adresse_ville + ' ';
        if (angular.isDefined($scope.infosSpanc.adresse_pays))
          $scope.cdata.general.reference_spanc +=
            $scope.infosSpanc.adresse_pays;
      } else {
        require('toastr').error(
          "Aucune information n'a pu être retrouvée automatiquement"
        );
      }
    };

    $scope.formDTabs = [
      {
        title: 'Fiche déclarative',
        content: 'js/XG/widgets/ancapp/main/views/controle/Fiche_D/d1.html',
      },
      {
        title: 'Fiche contrôle',
        content: 'js/XG/widgets/ancapp/main/views/controle/Fiche_D/d2.html',
      },
    ];
    $scope.formDTabs.activeTab = 0;

    $scope.ctrl_clos = false;
    $scope.$watch('currentControle', function(cc) {
      if (angular.isDefined(cc)) {
        $scope.ctrl_clos = cc.properties.etat == 'clos';
      }
    });
  };

  ficheDCtrl.$inject = [
    '$scope',
    'AncAppFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'EditFactory',
    'UsersFactory',
    '$timeout',
  ];
  return ficheDCtrl;
});
