'use strict';
define(function() {
  var AncAppFactory = function(
    $http,
    $location,
    ConfigFactory,
    $q,
    FeatureTypeFactory,
    gaUrlUtils,
    $rootScope,
    QueryFactory,
    $filter,
    gaDomUtils,
    BacAppFactory,
    gaJsUtils,
    $sce,
    UsersFactory,
    CommonFactory,
    PortalsFactory
  ) {

    var AncAppFactory = {};
    var appCfg = {};

    /*----------------------------------------------------------------
         initdatabase
         ----------------------------------------------------------------*/
    function initappCfg(cfg) {
      appCfg = cfg;
    }
    /**
     * Function: initdatabase
     */
    function initdatabase(appname) {
      var promise = $http.get(
        '/services/{portalid}/ancapp/{appname}/initDatabase?f=json' +
          '&appname=' +
          appname
      );

      return promise;
    }
    
    const createJsonbFieldInTableControle = (datastoreName, appType) => {
      return $http.get(
        '/services/{portalid}/ancapp/{appname}/createJsonbFieldInTableControle?f=json' +
        '&datastoreName=' + datastoreName +
        '&appType=' + appType
      )
    }

    /**
     * Function: checkancappdata
     */

    function checkancappdata() {
      var promise = $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/checkAncAppData?f=json'
      );

      return promise;
    }

    // correct infosControles
    function correctInfosDossier(dossier) {
      var promise = $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/correctInfosDossier?f=json', dossier
      );

      return promise;
    }

    /*----------------------------------------------------------------
         dossier
         ----------------------------------------------------------------*/
    var getDossierCanceler = $q.defer();
    var getDossierResolved = false;
    var getDossierCancel = function() {
      getDossierCanceler.resolve('http call aborted');
    };
    /**
     * Function: getdossiers
     */
    function getdossiers(
      filtre_controle,
      where,
      crs,
      page,
      count,
      liaison_filter,
      case_sensitive,
      sort,
      restrict_ids,
      isExport
    ) {
      if (getDossierResolved) getDossierCancel();

      getDossierCanceler = $q.defer();
      getDossierResolved = isExport !== true;
      var dateNow = Date.now();

      // edit filtre alerte
      var myRegexp = /alerte ILIKE '%(.*?)%'/g;
      var match = myRegexp.exec(where);
      dateNow = $filter('date')(dateNow, 'yyyy-MM-ddT00:00:00.000Z');
      if (match != null) {
        var toReplace;
        var needUpdate = false;
        switch (match[1]) {
          case 'sans':
            toReplace = "alerte IS NULL OR alerte = '' ";
            needUpdate = true;
            break;
          case 'alerte':
            toReplace =
              "alerte IS NOT NULL AND alerte <> '' AND alerte_echeance IS NULL";
            needUpdate = true;
            break;
          case 'echeance':
            toReplace = 'alerte_echeance IS NOT NULL';
            needUpdate = true;
            break;
          case 'alerte_verte':
            toReplace =
              'alerte_echeance IS NOT NULL AND alerte_echeance AFTER ' +
              $filter('date')(
                gaJsUtils.addDays(dateNow, appCfg.main.dossierCfg.alerte.green),
                'yyyy-MM-ddT00:00:00.sssZ'
              ) +
              '';
            needUpdate = true;
            break;
          case 'alerte_jaune':
            toReplace =
              'alerte_echeance IS NOT NULL AND alerte_echeance AFTER ' +
              $filter('date')(
                gaJsUtils.addDays(dateNow, appCfg.main.dossierCfg.alerte.red),
                'yyyy-MM-ddTHH:mm:ss.sssZ'
              ) +
              ' AND alerte_echeance BEFORE ' +
              $filter('date')(
                gaJsUtils.addDays(dateNow, appCfg.main.dossierCfg.alerte.green),
                'yyyy-MM-ddTHH:mm:ss.sssZ'
              ) +
              '';
            needUpdate = true;
            break;
          case 'alerte_rouge':
            toReplace =
              'alerte_echeance IS NOT NULL AND alerte_echeance BEFORE ' +
              $filter('date')(
                gaJsUtils.addDays(dateNow, appCfg.main.dossierCfg.alerte.red),
                'yyyy-MM-ddTHH:mm:ss.sssZ'
              ) +
              '';
            needUpdate = true;
            break;
        }
        if (needUpdate) where = where.replace(match[0], toReplace);
      }

      where = gaUrlUtils.encodeUriQuery(where || '');
      sort = sort || '';
      restrict_ids = restrict_ids || '';
      if (liaison_filter === '{}') liaison_filter = '';
      if (typeof ancAppAndroid !== 'undefined') {
        ancAppAndroid.getDossiers(
          'anc',
          filtre_controle,
          where,
          crs,
          page,
          count,
          liaison_filter,
          case_sensitive,
          sort,
          restrict_ids
        );
        return getDossierCanceler.promise;
      } else {
        liaison_filter = encodeURI(liaison_filter);
        let promise = $http({
          method: 'GET',
          url:
            '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getDossiers?f=json&filtre_controle=' +
            filtre_controle +
            '&where=' +
            where +
            '&crs=' +
            crs +
            '&page=' +
            page +
            '&count=' +
            count +
            '&liaison_filter=' +
            liaison_filter +
            '&case_sensitive=' +
            case_sensitive +
            '&sort=' +
            sort +
            '&restrict_ids=' +
            restrict_ids +
            '&isExport=' +
            (isExport === true),
          timeout: getDossierCanceler.promise,
        });
        promise.then(function(res) {
          getDossierResolved = false;
        });
        return promise;
      }
    }

    function sendResultBackDossiers(result) {
      var res = {
        data: undefined,
      };
      if (result) {
        try {
          res.data = JSON.parse(result);
        } catch (e) {
          console.log(result);
          e.stack;
        }
        getDossierCanceler.resolve(res);
      } else {
        getDossierCanceler.resolve(res);
      }
    }

    /**
     * Function: getdossier_villes
     */
    function getdossier_villes() {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getDossier_villes(int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getDossier_villes?f=json'
        );
        return promise;
      }
    }

    function parseResultFromExternalApi(apiData) {
      var coms = [];
      apiData.forEach(ville => {
        angular.forEach(ville.codesPostaux, function(key) {
          let item = {
            cp: key,
            value: ville.nom,
            pays: 'France',
            gere_spanc: false,
            style:
              "<div class='color--black-italic'>" +
              ville.nom +
              ' ' +
              key +
              '</div>',
          };
          coms.push(item);
        });
      });
      return coms;
    }

    function callExternalApi(url) {
      var allCommunes = [];
      var defer = $q.defer();

      $http
        .get(url)
        .then(function(res) {
          allCommunes = parseResultFromExternalApi(res.data);
          defer.resolve(allCommunes);
        })
        .catch(function(err) {
          console.log('ERROR' + err);
          defer.reject();
        });
      return defer.promise;
    }

    /**
     * Function: getdossier
     */
    function getdossier(id_dossier) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getDossier(id_dossier, int);
        return defer.promise;
      } else {
        if (angular.isArray(id_dossier)) id_dossier = id_dossier.split(',');
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getDossier?f=json&id_dossier=' +
            id_dossier
        );
        return promise;
      }
    }

    /**
     * Function: getdossierbycontroleid
     */
    function getdossierbycontroleid(id_controle) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getDossierByControleId(id_controle, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getDossierByControleId?f=json&id_controle=' +
            id_controle
        );
        return promise;
      }
    }

    /**
     * Function: adddossier
     */
    function adddossier(senddata) {
      var promise = $http.post(
        '/services/{portalid}/ancapp/' + appCfg.appname + '/addDossier?f=json',
        senddata
      )

      return promise;
    }

    /**
     * Function: updatedossier
     */
    function updatedossier(senddata) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.updateDossier(JSON.stringify(senddata), int);
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/updateDossier?f=json',
          senddata
        );
        return promise;
      }
    }
    
    /**
     * Function: updatestatutdossiers
     */
    function updatestatutdossiers(id_dossiers, statut, date_racc) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.updateStatutDossiers(id_dossiers, statut, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/updateStatutDossiers?f=json&id_dossiers=' +
            id_dossiers +
            '&statut=' +
            statut +
            '&date_raccordement=' +
            date_racc
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /*----------------------------------------------------------------
         Personnes
         ----------------------------------------------------------------*/
    /**
     * Function: getpersonnes
     */
    function getpersonnes(appname, where) {
      /**/
      where = where || '1=1';
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getPersonnes(int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getPersonnes?f=json' +
            '&appname=' +
            appname +
            '&where=' +
            where
        );
        return promise;
      }
    }
    /**
     * Function: getpersonne
     */
    function getpersonne(id_personne) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getPersonne(id_personne, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getPersonne?f=json&id_personne=' +
            id_personne +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '')
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }
    /**
     * Function: addpersonne
     */
    function addpersonne(senddata,type,idDossier,UpdateOrCreate) {
      // @BACAPP
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: undefined,
        };
        var value;
        var val = ancAppAndroid.addPersonne(JSON.stringify(senddata));
        try {
          value = JSON.parse(val);
        } catch (e) {
          e.stack;
          value = val;
        }
        response.data = value;
        defer.resolve(response);
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addPersonne?f=json&bacapp=' +
            (BacAppFactory.appCfg.appname || '') + '&type=' + type + '&idDossier=' + idDossier + '&UpdateOrCreate='+ UpdateOrCreate,
          senddata
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

        /**
     *
     * @param {*} id_personne
     * @param {*} senddata
     */
    function updateOrCreatePersonneOmega(
      idPersonne,
      senddata
    ) {
      var promise = $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/updateOrCreatePersonneOmegas?f=json&idPersonne=' +
          idPersonne,
        senddata
      );
      promise.then(function (res) {});
      return promise;
    }


    /**
     * Update Historique des personnes Omega
     *      
     * @param {String} idDossier reférence de dossier
     * @param {FeatureCollection} senddata les données de l'historique des personnes
     * @param {String} type proprietaire ou locataire
     * 
     * @returns promise La liste des fids des  personnes rajoutés
     */
     function updateHistoriquePersonnesOmega(idDossier, type, senddata) {
       return $http.post(
         '/services/{portalid}/ancapp/' +
           appCfg.appname +
           '/updateHistoriquePersonnesOmega?f=json&idDossier=' +
           idDossier +
           '&type=' +
           type,
         senddata
       );
     }

    /**
     * Function: updatepersonne
     */
    function updatepersonne(senddata) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: undefined,
        };
        var value;
        var val = ancAppAndroid.updatePersonne(JSON.stringify(senddata));
        try {
          value = JSON.parse(val);
        } catch (e) {
          e.stack;
          value = val;
        }
        response.data = value;
        defer.resolve(response);
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/updatePersonne?f=json&bacapp=' +
            (BacAppFactory.appCfg.appname || ''),
          senddata
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /*----------------------------------------------------------------
         Parcelles
         ----------------------------------------------------------------*/
    /**
     * Function: getparcelles
     */
    function getparcelles(appname, where) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getParcelles(int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getParcelles?f=json' +
            '&appname=' +
            appname +
            '&where=' +
            where
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: getparcelle
     */
    function getparcelle(id_parcelle) {
      // @BACAPP
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getParcelle(id_parcelle, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getParcelle?f=json&id_parcelle=' +
            id_parcelle +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '')
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }
    /**
     * Function: addparcelle
     */
    function addparcelle(senddata, appName) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addParcelle(JSON.stringify(senddata), int);
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appName +
            '/addParcelle?f=json&bacapp=' +
            (BacAppFactory.appCfg.appname || ''),
          senddata
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: updateparcelle
     */
    function updateparcelle(senddata) {
      // @BACAPP
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.updateParcelle(JSON.stringify(senddata), int);
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/updateParcelle?f=json&bacapp=' +
            (BacAppFactory.appCfg.appname || ''),
          senddata
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: checkparcellealreadyused
     */
    function checkparcellealreadyused(type, ref_dossier, id_parcelle) {
      // @BACAPP
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.checkParcelleAlreadyUsed(
          type,
          ref_dossier,
          id_parcelle,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/checkParcelleAlreadyUsed?f=json&type=' +
            type +
            '&ref_dossier=' +
            ref_dossier +
            '&id_parcelle=' +
            id_parcelle +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '')
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: addparcelletodossier
     */
    function addparcelletodossier(type, ref_dossier, id_parcelle) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addParcelleToDossier(type, ref_dossier, id_parcelle, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addParcelleToDossier?f=json&type=' +
            type +
            '&ref_dossier=' +
            ref_dossier +
            '&id_parcelle=' +
            id_parcelle +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '')
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: removeparcellefromdossier
     */
    function removeparcellefromdossier(type, ref_dossier, id_parcelle) {
      // @BACAPP

      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.removeParcelleFromDossier(
          type,
          ref_dossier,
          id_parcelle,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/removeParcelleFromDossier?f=json&type=' +
            type +
            '&ref_dossier=' +
            ref_dossier +
            '&id_parcelle=' +
            id_parcelle +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '')
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /*----------------------------------------------------------------
         Dossiers <-> Personnes
         ----------------------------------------------------------------*/

    /**
     * Function: addpersonnetodossier
     */
    function addpersonnetodossier(
      type,
      ref_dossier,
      id_personne,
      dateDebutProprietaire,
      typeProp,
      facturationType,
      fin
    ) {
      // @BACAPP
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addPersonneToDossier(type, ref_dossier, id_personne, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addPersonneToDossier?f=json' +
            '&type=' +
            type +
            '&ref_dossier=' +
            ref_dossier +
            '&id_personne=' +
            id_personne +
            (dateDebutProprietaire?
              '&dateDebutProprietaire=' +
              dateDebutProprietaire:'')+
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '' + '&typeProp=' + typeProp) + '&facturationType=' + facturationType + '&fin=' + fin
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: removepersonneencoursfromdossier
     */
    function removepersonneencoursfromdossier(
      type,
      ref_dossier,
      id_personne,
      date_fin,
      debut
    ) {
      date_fin = date_fin || '';
      // @BACAPP
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.removePersonneEnCoursFromDossier(
          type,
          ref_dossier,
          id_personne,
          date_fin,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/removePersonneEnCoursFromDossier?f=json&type=' +
            type +
            '&ref_dossier=' +
            ref_dossier +
            '&id_personne=' +
            id_personne +
            '&date_fin=' +
            date_fin +
            '&debut=' +
            debut +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '')
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: getancpersonne
     */
    function getancpersonne(id_personne) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: undefined,
        };
        var value;
        var val = ancAppAndroid.getAncPersonne(id_personne);
        try {
          value = JSON.parse(val);
        } catch (e) {
          e.stack;
          value = val;
        }
        response.data = value;
        defer.resolve(response);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getAncPersonne?f=json' +
            '&id_personne=' +
            id_personne
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

 /**
     * Function: gethistopersonnesdossier
     */
  function gethistopersonnesdossier(type, ref_dossier, filterHisto) {
    // @BACPAPP
    if (typeof ancAppAndroid !== 'undefined') {
      var defer = $q.defer();
      var int = createDefer(defer);
      ancAppAndroid.getHistoPersonnesDossier(type, ref_dossier, '', int);
      return defer.promise;
    } else {
      var promise = $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getHistoPersonnesDossier?f=json&type=' +
          type,
          ref_dossier
      );
      promise.then(function (res) {
        // service level logic if any
      });
      return promise;
    }
  }

    /*----------------------------------------------------------------
         Filieres
         ----------------------------------------------------------------*/

    /**
     * Function: addfiliere
     */
    function addfiliere(ref_dossier, nom, newFiliere) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addFiliere(ref_dossier, nom, newFiliere.identifiant, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addFiliere?f=json&ref_dossier=' +
            ref_dossier +
            '&nom=' +
            nom +
            '&identifiant=' +
            newFiliere.identifiant +
            '&volume_eh=' +
            newFiliere.volume_eh
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: getfiliere
     */
    function getFiliere(id_filiere) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: undefined,
        };
        var value;
        var val = cfgandroid.getFiliereByid(id_filiere);
        try {
          value = JSON.parse(val);
        } catch (e) {
          e.stack;
          value = val;
        }
        response.data = value;

        if (response.data.collection && response.data.collection.features)
          response.data.collection.features.map(function(x) {
            var g = x.geometry;
            try {
              x.geometry = JSON.parse(x.geometry);
            } catch (e) {
              e.stack;
              x.geometry = g;
            }
          });

        defer.resolve(response);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getFiliere?f=json&id_filiere=' +
            id_filiere
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: addFiliereByid
     */
    function addFiliereByid(id_filiere, sendata) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: undefined,
        };
        var value;
        var val = cfgandroid.addFiliereByid(id_filiere, sendata);
        try {
          value = JSON.parse(val);
        } catch (e) {
          e.stack;
          value = val;
        }
        response.data = value;
        defer.resolve(response);
        return defer.promise;
      }
    }

    /**
     * Function: addelementtofiliere
     */
    function addelementtofiliere(id_filiere, feature_uid, feature_id) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addElementToFiliere(
          id_filiere,
          feature_uid,
          feature_id,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addElementToFiliere?f=json&id_filiere=' +
            id_filiere +
            '&feature_uid=' +
            feature_uid +
            '&feature_id=' +
            feature_id
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: updateelementfiliere
     */
    function updateelementfiliere(
      id_relation,
      nom_table_element_filiere,
      id_element_filiere,
      id_filiere
    ) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.updateElementFiliere(
          id_relation,
          nom_table_element_filiere,
          id_element_filiere,
          id_filiere,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/updateElementFiliere?f=json' +
            '&id_relation=' +
            id_relation +
            '&nom_table_element_filiere=' +
            nom_table_element_filiere +
            '&id_element_filiere=' +
            id_element_filiere +
            '&id_filiere=' +
            id_filiere
        );

        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: removeelementfromfiliere
     */
    function removeelementfromfiliere(
      id_relation,
      nom_table_element_filiere,
      id_element_filiere
    ) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.removeElementFromFiliere(
          id_relation,
          nom_table_element_filiere,
          id_element_filiere,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/removeElementFromFiliere?f=json&id_relation=' +
            id_relation +
            '&nom_table_element_filiere=' +
            nom_table_element_filiere +
            '&id_element_filiere=' +
            id_element_filiere
        );
        promise.then(function(res) {
          require('toastr').success('Élément de filière supprimé.');

          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: resetfiliere
     */
    function resetfiliere(id_filiere) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.resetFiliere(id_filiere, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/resetFiliere?f=json' +
            '&appname=' +
            appCfg.appname +
            '&id_filiere=' +
            id_filiere
        );
        promise.then(function(res) {
          // service level logic if any
          require('toastr').success('Filière réinitialisée.');
        });
        return promise;
      }
    }

    /**
     * Function: getfilierenm1
     */
    function copyselectedfiliere(id_filiere, id_selected_filiere, id_dossier) {
      var promise = $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/copyselectedfiliere?f=json' +
          '&appname=' +
          appCfg.appname +
          '&id_dossier=' +
          id_dossier +
          '&id_filiere=' +
          id_filiere +
          '&id_selected_filiere=' +
          id_selected_filiere
      );
      promise.then(function(res) {
        // service level logic if any
        require('toastr').success('Copie de la filière effectuée avec succès.');
      });
      return promise;
    }

    // @TODO ITS A MESS
    var listeElementsfiliere;
    function setListeElementsFiliere() {
      var promise = getElementFiliereData('*');
      promise.then(function(res) {
        listeElementsfiliere = res.data.features;
      });
      return promise;
    }
    function getListeElementsFiliere() {
      return listeElementsfiliere;
    }

    /**
     * traitementOuPretraitement
     *
     * @param lib
     * @returns {*}
     */
    var traitementOuPretraitement = function(lib) {
      var ef = getListeElementsFiliere().filter(function(e) {
        return e.properties.identifiant.replace('kis_anc_ef_', '') == lib;
      })[0];
      if (angular.isDefined(ef)) {
        if (ef.properties.id_type == 'kis_anc_element_filiere_type.1')
          lib = 'pretraitement';
        if (ef.properties.id_type == 'kis_anc_element_filiere_type.2')
          lib = 'traitement';
      }

      return lib;
    };

    /**
     * sort les elements de filiere partant du haut de la collecte des eaux
     * usées au rejet
     *
     * @param elements
     * @param emplacement
     */
    function sortElementsFiliere(elements, emplacement) {
      var ordre = [
        'regard_collecte',
        'pretraitement',
        'bac_a_graisse',
        'pre_filtre',
        'ventilation',
        'traitement',
        'micro_station',
        'filtre_compact',
        'filtre_plante',
        'regard_repartition',
        'regard_bouclage',
        'regard_visite',
        'regard_controle',
        'poste_relevage',
        'rejet',
        'non_classifie',
      ];

      // récuperation des elements de filière
      // do sort
      var tmp_elements = [];
      elements.forEach(function(el, index) {
        var lib;

        if (emplacement == 'dossier')
          lib = el.properties.feature_uid.replace('kis_anc_ef_', '');
        if (emplacement == 'representation')
          lib = el.feature.id.replace('kis_anc_ef_', '').split('.')[0];
        if (emplacement == 'controle')
          lib = el.data.id.replace('kis_anc_ef_', '').split('.')[0];

        if (ordre.indexOf(lib) == -1) {
          lib = traitementOuPretraitement(lib);
          // toujours pas retrouve, autre element de filiere pas dans
          // la liste, on le met à la fin
          if (ordre.indexOf(lib) == -1) {
            lib = 'non_classifie';
          }
        }

        if (!angular.isDefined(tmp_elements[lib])) {
          tmp_elements[lib] = [];
        }
        tmp_elements[lib].push(el);
      });

      var sorted_selement = [];
      ordre.forEach(function(lib) {
        if (angular.isDefined(tmp_elements[lib])) {
          // au sein d'une meme categorie, sort par fid histoire
          // d'avoir tjrs le meme ordre
          var x = '';
          var y = '';
          if (tmp_elements[lib].length > 1) {
            tmp_elements[lib] = tmp_elements[lib].sort(function(a, b) {
              if (emplacement == 'dossier') {
                x = parseInt(a.id.split('.')[1]);
                y = parseInt(b.id.split('.')[1]);
              }
              if (emplacement == 'representation') {
                x = parseInt(a.feature.id.split('.')[1]);
                y = parseInt(b.feature.id.split('.')[1]);
              }
              if (emplacement == 'controle') {
                x = parseInt(a.data.id.split('.')[1]);
                y = parseInt(b.data.id.split('.')[1]);
              }
              return x < y ? -1 : x > y ? 1 : 0;
            });
          }

          tmp_elements[lib].forEach(function(x) {
            sorted_selement.push(x);
          });
        }
      });
      return sorted_selement;
    }

    /**
     * Function: base64topng
     */
    function base64topng(senddata, fid) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/base64toPng?f=json' +
          '&fid=' +
          fid,
        senddata
      );
    }

    function getElementFiliereData(type) {
      var table;
      switch (type) {
        case 'groupe':
          table = 'kis_anc_element_filiere_groupe';
          break;
        case 'type':
          table = 'kis_anc_element_filiere_type';
          break;
        default:
          table = 'kis_anc_element_filiere';
          break;
      }
      var fti = FeatureTypeFactory.getFeatureByNameAndDatastore(
        appCfg.main.datastore,
        table
      );
      var promise = QueryFactory.data(fti.uid, '', '', '', '');

      return promise;
    }

    /*----------------------------------------------------------------
         Contrôles
         ----------------------------------------------------------------*/

    var QueryDataDefers = [];
    /**
     * Function: getcontroles
     */
    function getcontroles(dossier) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getControles(dossier, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getControles?f=json&dossier=' +
            dossier
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    function createDefer(defer) {
      var int = Math.round(Math.random() * 10e7);
      QueryDataDefers.push({
        idx: int,
        defer: defer,
      });
      return int;
    }

    function dataResultAndroid(res, int) {
      var defer;
      try {
        var index;
        for (var i = 0; i < QueryDataDefers.length; i++) {
          var d = QueryDataDefers[i];
          if (d.idx === int) {
            defer = d.defer;
            index = i;
            break;
          }
        }

        var response = {
          data: res,
        };
        try {
          if (response.data && typeof response.data == 'string')
            response.data = JSON.parse(response.data);
        } catch (e) {
          console.log(response.data);
          e.stack;
        }
        defer.resolve(response);
      } catch (e) {
        e.stack;
        defer.reject();
      }
      QueryDataDefers.splice(index, 1);
    }
    /**
     * Function: addcontrole
     */
    function addcontrole(senddata, dossier, filiere_id) {
      filiere_id = filiere_id || '';
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addControle(
          dossier,
          filiere_id,
          JSON.stringify(senddata),
          int
        );
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addControle?' +
            'dossier=' +
            dossier +
            '&filiere_id=' +
            filiere_id,
          senddata
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: updatecontrole
     */
    function updatecontrole(senddata) {
      if (angular.isDefined(senddata.features[0])) {
        if (
          angular.isUndefined(
            senddata.features[0].properties.date_saisie_controle
          ) ||
          senddata.features[0].properties.date_saisie_controle == ''
        )
          senddata.features[0].properties.date_saisie_controle = null;
        if (
          angular.isUndefined(senddata.features[0].properties.date_avis) ||
          senddata.features[0].properties.date_avis == ''
        )
          senddata.features[0].properties.date_avis = null;
        if (
          angular.isUndefined(senddata.features[0].properties.date_passage) ||
          senddata.features[0].properties.date_passage == ''
        )
          senddata.features[0].properties.date_passage = null;
        if (
          angular.isUndefined(
            senddata.features[0].properties.date_passage_rdv
          ) ||
          senddata.features[0].properties.date_passage_rdv == ''
        )
          senddata.features[0].properties.date_passage_rdv = null;
        if (
          angular.isUndefined(
            senddata.features[0].properties.date_avis_agent
          ) ||
          senddata.features[0].properties.date_avis_agent == ''
        )
          senddata.features[0].properties.date_avis_agent = null;
        if (
          angular.isUndefined(
            senddata.features[0].properties.caj_id_controle
          ) ||
          senddata.features[0].properties.caj_id_controle == ''
        )
          senddata.features[0].properties.caj_id_controle = null;
        if (
          angular.isUndefined(
            senddata.features[0].properties.caj_ordre_controle
          ) ||
          senddata.features[0].properties.caj_ordre_controle == ''
        )
          senddata.features[0].properties.caj_ordre_controle = null;
        if (
          angular.isUndefined(
            senddata.features[0].properties.id_facture_logiciel_facturation
          ) ||
          senddata.features[0].properties.id_facture_logiciel_facturation == ''
        )
          senddata.features[0].properties.id_facture_logiciel_facturation = null;

        delete senddata.features[0].attachmentsNo;
      }

      if (
        angular.isDefined(senddata.features[0]) &&
        senddata.features[0].properties.date_saisie_controle == ''
      )
        senddata.features[0].properties.date_avis = null;

      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.updateControle(JSON.stringify(senddata), int);
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/updateControle?f=json',
          senddata
        );
        return promise;
      }
    }

    /**
     * Function: removecontrole
     */
    function removecontrole(dossier, controle, controle_type) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.removeControle(dossier, controle, controle_type, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/removeControle?f=json' +
            '&dossier=' +
            dossier +
            '&controle=' +
            controle +
            '&controle_type=' +
            controle_type
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: addcontroledetail
     */
    function addcontroledetail(senddata, dossiers, controle) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addControleDetail(
          JSON.stringify(senddata),
          dossiers,
          controle,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addControleDetail?f=json' +
            '&dossiers=' +
            dossiers +
            '&controle=' +
            controle +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || ''),
          senddata
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }
    /**
     * Function: getcontroledetail
     */
    function getcontroledetail(dossier, controle) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getControleDetail(dossier, controle, '', int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getControleDetail?f=json&dossier=' +
            dossier +
            '&controle=' +
            controle +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '')
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: getcontroledetailexterne
     */
    function getcontroledetailexterne(type) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getControleDetailExterne(type, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getControleDetailExterne?f=json&type=' +
            type
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }
    /**
     * Function: removecontroleexternedetail
     */
    function changeControleExterneDetail(
      filename,
      type,
      id_dossier,
      id_controle
    ) {
      id_dossier = id_dossier || '';
      id_controle = id_controle || '';
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.changeControleExterneDetail(
          filename,
          type,
          id_dossier,
          id_controle,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/changeControleExterneDetail?f=json&filename=' +
            filename +
            '&type=' +
            type +
            '&id_dossier=' +
            id_dossier +
            '&id_controle=' +
            id_controle
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }
    /**
     * Function: activecontroledetailexterne
     */
    function activecontroledetailexterne(filename) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.activeControleDetailExterne(filename, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/activeControleDetailExterne?f=json&filename=' +
            filename
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    function getCtrlFormCfg(ctrlType) {
      return ConfigFactory.get(
        'main',
        'ancFormCfg_' + ctrlType,
        appCfg.appname
      );
    }

    function getAllCtrlFormCfg() {
      return ConfigFactory.getAllFormCfg('anc', appCfg.appname);
    }

    /*----------------------------------------------------------------
         Factures
         ----------------------------------------------------------------*/

    /**
     * Function: generatefacturesdolibarr
     */
    function generatefacturesdolibarr(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/generateFacturesDolibarr?f=json',
        senddata
      );
    }

    /**
     * Function: getlisteexportsjvs
     */
    function getlisteexportsjvs() {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getListeExportsJVS?f=json'
      );
    }

    /**
     * Function: getmontantfactures
     */
    function getmontantfactures(id_relation) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getMontantFactures?f=json&id_relation=' +
          id_relation +
          '&bacapp=' +
          (BacAppFactory.appCfg.appname || '')
      );
    }

    /**
     * Function: changestatutfactures
     */
    function changestatutfactures(factures, statut) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/changeStatutFactures?f=json&factures=' +
          factures +
          '&statut=' +
          statut
      );
    }
    /**
     * Function: uploaddashboarddoc
     */
    function uploaddashboarddoc(senddata, type) {
      return $http.post(
        '/services/{portalid}/ancapp//uploaddashboarddoc?f=json' +
          '&type=' +
          type,
        senddata
      );
    }
    /**
     * Function: removedashboarddoc
     */
    function removedashboarddoc(type, fileName) {
      return $http.get(
        '/services/{portalid}/ancapp/removedashboarddoc?f=json' +
          '&type=' +
          type +
          '&fileName=' +
          fileName +
          '&bacapp=' +
          (BacAppFactory.appCfg.appname || '')
      );
    }

    /**
     * Function: listdashboarddocs
     */
    function listdashboarddocs(type) {
      return $http.get(
        '/services/{portalid}/ancapp/listdashboarddocs?f=json' +
          '&type=' +
          type +
          '&bacapp=' +
          (BacAppFactory.appCfg.appname || '')
      );
    }

    /**
     * Function: downloaddashboarddoc
     */
    function downloaddashboarddoc(type, name) {
      return $http.get(
        '/services/{portalid}/ancapp/downloaddashboarddoc?f=json' +
          '&type=' +
          type +
          '&name=' +
          name +
          '&bacapp=' +
          (BacAppFactory.appCfg.appname || '')
      );
    }

    /**
     * Function: updatepersonhistory
     */
    function updatepersonhistory(senddata, type) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/updatePersonHistory?f=json&type=' +
          type +
          '&bacapp=' +
          (BacAppFactory.appCfg.appname || ''),
        senddata
      );
    }

    /**
     * Request the report generation and the export in pdf and jpeg
     *
     * @param {type}
     *            jasperFileName
     * @param {type}
     *            jsonParameters
     * @returns {unresolved}
     */
    function generatereport(jasperFileName, jsonParameters) {
      return $http.post(
        '/services/{portalid}/ancapp/generatereport' +
          '?jasperFileName=' +
          jasperFileName +
          '&dataStoreName=' +
          appCfg.main.datastore,
        '' + JSON.stringify(jsonParameters)
      );
    }

    /**
     * Function: getreportpdf
     */
    function getreportpdf(filename) {
      return $http.get(
        '/services/{portalid}/ancapp/getreportpdf?f=json' +
          '&filename=' +
          filename
      );
    }

    /**
     * Function: imprimerfactures
     */
    function imprimerfactures(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/imprimerFactures?f=json',
        senddata
      );
    }

    /**
     * Function: synchropersonnesdolibarr
     */
    function synchropersonnesdolibarr(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/synchroPersonnesDolibarr?f=json',
        senddata
      );
    }

    /**
     * Function: getfacturespdf
     */
    function getfacturespdf(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getFacturesPDF?f=json',
        senddata
      );
    }

    /**
     * getControlesHTML
     */
    function getControlesHTML(ctrlName, apptype) {
      var g = $q.defer();
      var baseurl =
        $location.absUrl().split('#')[0] +
        'js/XG/widgets/ancapp/main/views/controle/';
      if (apptype == 'bac') {
        baseurl =
          $location.absUrl().split('#')[0] +
          'js/XG/widgets/bacapp/main/views/controle/';
      }

      var promise = $http.get(baseurl + ctrlName + '/files.json');
      promise.then(
        function(res) {
          var files = res.data.files;
          for (var i in files)
            files[i].template = ctrlName + '/' + files[i].template;

          var mainLabel = ctrlName == 'Fiche_D' ? 'Contrôle' : 'Validation';
          files.push({
            template: ctrlName + '.html',
            label: mainLabel,
          });

          // retrieve all html
          var requests = [];
          for (var i in files) {
            requests.push(
              $http.get(baseurl + files[i].template, {
                cache: false,
              })
            );
          }

          $q.all(requests).then(
            function(res) {
              for (var x in res) {
                files[x].data = res[x].data;
                delete files[x].template;
              }
              g.resolve({ files: files });
            },
            function(x) {
              g.reject(files);
            }
          );
        },
        function() {
          g.reject();
        }
      );

      return g.promise;
    }

    /**
     * Function: getextractedjsondata
     */
    function getextractedjsondata(filename) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getExtractedJsonData(filename, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getExtractedJsonData?f=json&filename=' +
            filename
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }
    // return the url for the previous function, cause this is all we need
    // to use it in docfeeder
    var getextractedjsondataurl = function(filename, apptype) {
      return (
        '/services/' +
        PortalsFactory.getPortalId() +
        '/ancapp/' +
        appCfg.appname +
        '/getExtractedJsonData?f=json&filename=' +
        filename +
        '&bacapp=' +
        '&token=' +
        gaUrlUtils.encodeUriQuery(localStorage.getItem('auth_token'))
      );
    };

    /**
     * Function: htmlformtojson
     */
    function htmlformtojson(senddata, name) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/htmlformtojson?f=json' +
          '&name=' +
          name +
          '&bacapp=' +
          (BacAppFactory.appCfg.appname || ''),
        senddata
      );
    }

    /**
     * Function: create_controle_json_mapping_file
     */
    function create_controle_json_mapping_file(appname) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/create_controle_json_mapping_file?f=json'
      );
    }

    /**
     * Function: htmlformtoangular2
     */
    function htmlformtoangular2(senddata, name) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/htmlformtoangular2?f=json' +
          '&name=' +
          name +
          '&bacapp=' +
          (BacAppFactory.appCfg.appname || ''),
        senddata
      );
    }

    /**
     * Function: getmobileforms
     */
    function getmobileforms() {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getMobileForms?f=json' +
          '&bacapp=' +
          (BacAppFactory.appCfg.appname || '')
      );
    }

    /**
     * Function: getngincludeduhtml
     */
    function getngincludeduhtml(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getNgIncludeDuHtml?f=json',
        senddata
      );
    }

    /**
     * Function: getzipdocumentstypes
     */
    function getZipDocumentsTypes(list_ids, list_names, pdf) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getZipDocumentsTypes?f=json&list_ids=' +
          list_ids +
          '&list_names=' +
          list_names +
          '&bacapp=' +
          (BacAppFactory.appCfg.appname || '') +
          '&pdf=' +
          pdf
      );
    }

    /**
     * Function: refreshnationalreglementaire
     */
    function refreshnationalreglementaire(appname) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/refreshNationalReglementaire?f=json' +
          '&appname=' +
          appname
      );
    }

    /**
     * Function: getreglementaire
     */
    function getreglementaire(filename) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getReglementaire(filename, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getReglementaire?f=json&filename=' +
            filename
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: addreglementaire
     */
    function addreglementaire(senddata, filename, removeindex) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/addReglementaire?f=json' +
          '&filename=' +
          filename +
          '&removeindex=' +
          removeindex,
        senddata
      );
    }

    /**
     * Function: removereglementaire
     */
    function removereglementaire(filename, removeindex) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/removeReglementaire?f=json&filename=' +
          filename +
          '&removeindex=' +
          removeindex
      );
    }

    /**
     * Function: setindexation
     */
    function setindexation(appname) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/setIndexation?f=json'
      );
    }

    /**
     * Function: indexcontroles
     */
    function indexcontroles(appname) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/indexControles?f=json'
      );
    }

    /**
     * Function: getvidangesdossier
     */
    function getvidangesdossier(id_dossier) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getVidangesDossier(id_dossier, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getVidangesDossier?f=json&id_dossier=' +
            id_dossier
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: addvidangetoelementfiliere
     */
    function addvidangetoelementfiliere(senddata) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addVidangeToElementFiliere(JSON.stringify(senddata), int);
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addVidangeToElementFiliere?f=json' +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || ''),
          senddata
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: removevidangefromelementfiliere
     */
    function removevidangefromelementfiliere(relationid, vidangeid) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.removeVidangeFromElementFiliere(
          relationid,
          vidangeid,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/removeVidangeFromElementFiliere?f=json&relationid=' +
            relationid +
            '&vidangeid=' +
            vidangeid
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: updatevidangeelementfiliere
     */
    function updatevidangeelementfiliere(senddata) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.updateVidangeElementFiliere(
          JSON.stringify(senddata),
          int
        );
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/updateVidangeElementFiliere?f=json',
          senddata
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: addtournee
     */
    function addtournee(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' + appCfg.appname + '/addTournee?f=json',
        senddata
      );
    }

    /**
     * Function: gettournee
     */
    function gettournee(agent) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getTournee?f=json&agent=' +
          agent
      );
    }

    /**
     * Function: getMobileTournee
     */
    function getMobileTournee(agent, tournee) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getMobileTournee?f=json&agent=' +
          agent +
          '&tournee=' +
          tournee
      );
    }

    /**
     * Function: getMobileTournee
     */
    function getMobileTourneeProgression(agent, tournee) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getMobileTourneeProgression?f=json&agent=' +
          agent +
          '&tournee=' +
          tournee
      );
    }

    /**
     * Function: getqrcodetournee
     */
    function getqrcodetournee(agent) {
      var url_base =
          $location.protocol() +
          '://' +
          $location.host() +
          '/services/' +
          PortalsFactory.getPortalId() +
          '/ancapp/' +
          appCfg.appname,
        add_token =
          '&token=' +
          gaUrlUtils.encodeUriQuery(localStorage.getItem('auth_token')),
        url_forms =
          url_base +
          encodeURIComponent(
            '/getMobileForms?f=json&bacapp=' +
              (BacAppFactory.appCfg.appname || '')
          ),
        url_filieres =
          url_base +
          encodeURIComponent(
            '/getMobileFilieres?f=json&bacapp=' +
              (BacAppFactory.appCfg.appname || '')
          ),
        url_personnes =
          url_base +
          encodeURIComponent(
            '/getMobilePersonnes?f=json&bacapp=' +
              (BacAppFactory.appCfg.appname || '')
          ),
        url_mbtiles =
          url_base +
          encodeURIComponent(
            '/getMobileMbTiles?f=json&bacapp=' +
              (BacAppFactory.appCfg.appname || '')
          ),
        url_tournee =
          url_base +
          encodeURIComponent(
            '/getTournee?f=json' + add_token + '&agent=' + agent
          );

      console.log('url forms : ' + decodeURIComponent(url_forms));
      console.log('url filieres : ' + decodeURIComponent(url_filieres));
      console.log('url tiles : ' + decodeURIComponent(url_mbtiles));
      console.log('url personnes : ' + decodeURIComponent(url_personnes));
      console.log('url tournee : ' + decodeURIComponent(url_tournee));

      return (
        url_base +
        '/getQrCodeTournee?f=json' +
        add_token +
        '&url_forms=' +
        url_forms +
        '&url_filieres=' +
        url_filieres +
        '&url_mbtiles=' +
        url_mbtiles +
        '&url_tournee=' +
        url_tournee
      );
    }

    /**
     * Retourne la configuration des elements de template qui peut se trouver
     * dans un autre fichier
     */
    function getElementsFiliereTemplates() {
      return angular.isDefined(appCfg.elementsFiliereTemplates)
        ? appCfg.elementsFiliereTemplates
        : appCfg.main.properties.elementsFiliereTemplates;
    }

    /**
     * getBuildedFakeCtrlReponseFtiForElasticSearch Retourne le fakeFti deja
     * builde
     *
     * @param {*}
     *            obj
     * @param {*}
     *            type
     */
    function getBuildedFakeCtrlReponseFtiForElasticSearch(type) {
      var g = $q.defer();
      g.resolve(extractedFormHtmlJsonData[type].fakeFti);
      return g.promise;
    }

    /**
     * buildFakeCtrlReponseFtiForElasticSearch
     *
     * @param {*}
     *            obj
     * @param {*}
     *            res
     */
    function buildFakeCtrlReponseFtiForElasticSearch(obj, res) {
      var fakeCtrlReponseFti = {
        name: 'kis_anc_dossier_controle_reponse',
        alias: obj.label_court,
        ctrlType: obj.type,
        isCtrlReponse: true,
        attributes: [],
      };

      if (res.data.parts && res.data.parts.length > 0) {
        res.data.parts.map(function(part) {
          if (part.data && part.data.length > 0) {
            part.data.map(function(x) {
              if (
                Object.keys(x).indexOf('description') !== -1 &&
                x.description
              ) {
                var _type = 'java.lang.String';
                if (x.type == 'date') _type = 'java.sql.Timestamp';
                if (x.type == 'number') _type = 'java.lang.Integer';
                if (x.type == 'checkbox') _type = 'java.lang.Boolean';

                fakeCtrlReponseFti.attributes.push({
                  alias: x.description,
                  name: x.key.replace('cdata.', ''),
                  type: _type,
                  category: part.label,
                  prefixedAlias:
                    translateKeyForRecherche(x.key.replace('cdata.', '')) +
                    x.description,
                });
              }
            });
          }
        });
      }

      return fakeCtrlReponseFti;
    }

    var extractedFormHtmlJsonData = {};

    /**
     * getAllExtractedJsonData permet de ne requeter qu'une fois le contenu des
     * fichiers html
     */
    var getAllExtractedJsonData = function() {
      var g = $q.defer();
      var controlesTypes = appCfg.main.controleCfg.map(function(x) {
        return x.type;
      });

      var getData = [];
      for (var i in controlesTypes) {
        getData.push(
          $http.get(getextractedjsondataurl(controlesTypes[i]), {
            cache: false,
          })
        );
      }

      $q.all(getData).then(
        function(res) {
          for (var i in appCfg.main.controleCfg) {
            extractedFormHtmlJsonData[appCfg.main.controleCfg[i].type] = {
              data: res[i],
              fakeFti: buildFakeCtrlReponseFtiForElasticSearch(
                appCfg.main.controleCfg[i],
                res[i]
              ),
            };
          }
          g.resolve();
        },
        function() {
          if ($rootScope.xgos.isroot) {
            require('toastr').warning(
              'Erreur lors de la récupération des contenus html des formulaires (getAllExtractedJsonData)',
              '',
              {
                positionClass: 'toast-bottom-left',
              }
            );
          }
          g.resolve();
        }
      );

      return g.promise;
    };

    /**
     * getAppCfg
     *
     * @param cfgPromise
     * @param simpleGet -
     *            get the cfg only and no other check/redirection occurs
     * @param appname -
     *            specific appname
     */
    var watchUser;
    var ancDataChecked = false;
    var controlePanancCfg, controleStandardCfg;
    function getAppCfg(cfgPromise, simpleGet, appname) {
      appCfg.appname = appname ? appname : $location.search().app;
      var cfgPromise = cfgPromise || $q.defer();

      if (!simpleGet) {
        if (
          !~$location.path().indexOf('/anc/') ||
          !angular.isDefined($location.search().app)
        ) {
          $location.path('/404');
          cfgPromise.reject();
          return cfgPromise.promise;
        }
      }

      // be sure that auth is finished and user set before proceeding
      if (angular.isUndefined($rootScope.xgos.user)) {
        watchUser = $rootScope.$watch('xgos.user', function(u) {
          if (angular.isDefined(u)) {
            watchUser();
            return getAppCfg(cfgPromise);
          }
        });
      } else {
        // load only once
        if (angular.isDefined(appCfg.main)) {
          // console.log('cfg already loaded');
          // @TODO RB stop here when in prod
          // return false;
        }

        var promise = ConfigFactory.get(
          'main',
          'mainConfig',
          appCfg.appname
        ).then(function(res) {
          // si la proprieté billingQuery n'est pas présente dans la config, alors on la créé
          if (!res.data.properties.billingQuery) {
            res.data.properties.billingQuery = '';
          }
          appCfg.main = res.data;
          if (res.data && res.data.code == 403) {
            require('toastr').error(
              'Erreur lors de la récupération de la configuration, le nom de l application est [' +
                appCfg.appname +
                ']',
              '',
              {
                positionClass: 'toast-bottom-left',
              }
            );
            return;
          }

          var needToUpdateCfg = false;
          // compatibilité ascendante
          if (angular.isDefined(appCfg.main.dashboardCfg)) {
            for (var i in appCfg.main.dashboardCfg) {
              if (!angular.isDefined(appCfg.main.dashboardCfg[i].type)) {
                appCfg.main.dashboardCfg[i].type = 'modele';
              }
            }
            needToUpdateCfg = 1;
          }

          if (!simpleGet) {
            if (appCfg.main == '') {
              $location.path('/anc/nocfg');
              $rootScope.$broadcast('resetAncNavigation');
              cfgPromise.resolve();
              return cfgPromise.promise;
            }

            // configuring parcelles is mandatory
            if (!appCfg.main.parcellesCfg || !appCfg.main.entreprisesCfg) {
              if ($location.path() != '/anc/admin/') {
                $location.path('/anc/admin');
                $rootScope.$broadcast('resetAncNavigation');
              }
            } else if (!appCfg.main.infosSpanc) {
              if ($location.path() != '/anc/admin') {
                $location.hash('spanc');
                $location.path('/anc/admin/');
                $rootScope.$broadcast('resetAncNavigation');
              }
            }

            if (
              appCfg.main.infosSpancListeVillesCfg &&
              appCfg.main.infosSpancListeVillesCfg.length
            ) {
              var configVille = angular.copy(
                appCfg.main.infosSpancListeVillesCfg
              );
              appCfg.main.infosSpancListeVillesCfg = [];
              for (var i = 0; i < configVille.length; i++) {
                if (typeof configVille[i] == 'string') {
                  appCfg.main.infosSpancListeVillesCfg.push({
                    value: configVille[i],
                    cp: [],
                    pays: '',
                  });
                } else {
                  appCfg.main.infosSpancListeVillesCfg.push(configVille[i]);
                }
              }
            }

            if (!appCfg.main.infosSpancListeVillesCfg) {
              appCfg.main.infosSpancListeVillesCfg = [];
              needToUpdateCfg = 1;
            }

            if (!angular.isDefined(appCfg.main.properties)) {
              appCfg.main.properties = {};
              needToUpdateCfg = 1;
            }

            if (
              !angular.isDefined(
                appCfg.main.properties.setDateDebutPropObligatoire
              )
            ) {
              appCfg.main.properties.setDateDebutPropObligatoire = true;
              needToUpdateCfg = 1;
            }
            if (!angular.isDefined(appCfg.main.properties.activePanancGrille)) {
              appCfg.main.properties.activePanancGrille = false;
              needToUpdateCfg = 1;
            }
            if (
              !angular.isDefined(appCfg.main.properties.subventionnableDossier)
            ) {
              appCfg.main.properties.subventionnableDossier = false;
              needToUpdateCfg = 1;
            }
            if (
              !angular.isDefined(
                appCfg.main.properties.elementsFiliereTemplates
              )
            ) {
              appCfg.main.properties.elementsFiliereTemplates = {};
              needToUpdateCfg = 1;
            }
            if (!angular.isDefined(appCfg.main.properties.gestionCivilites)) {
              appCfg.main.properties.gestionCivilites = false;
              needToUpdateCfg = 1;
            }

            if (!angular.isDefined(appCfg.main.properties.configCanas)) {
              appCfg.main.properties.configCanas = { liste: [] };
              needToUpdateCfg = 1;
            }

            if (
              !angular.isDefined(appCfg.main.properties.isOpenedFolderActive)
            ) {
              appCfg.main.properties.isOpenedFolderActive = true;
              needToUpdateCfg = 1;
            }

            if (!angular.isDefined(appCfg.main.properties.dolibarr)) {
              // true, l'ancienne n'est plus fonctionelle
              appCfg.main.properties.dolibarr = {
                active: true,
              };
              needToUpdateCfg = 1;
            }

            // interface avec JVS ou
            if (
              !angular.isDefined(
                appCfg.main.properties.dolibarr.facturationTierce
              )
            ) {
              appCfg.main.properties.dolibarr.facturationTierce = {
                active: false,
                interface: {
                  type: '',
                },
              };
              needToUpdateCfg = 1;
            }

            if (!angular.isDefined(appCfg.main.properties.civilites)) {
              appCfg.main.properties.civilites = {
                liste: ['Monsieur', 'Madame'],
              };
              needToUpdateCfg = 1;
            }
            if (!appCfg.main.properties.extraFormFields) {
              // exemple fields
              var fields = [
                {
                  // attribut simple de type date
                  controles: ['FO0', 'FO1'],
                  model: 'cdata.extraFormFields',
                  attribute: 'test1',
                  label: 'Test FO0 et FO1',
                  type: 'date', // date, entier ou chaine (par défaut)
                },
                {
                  // attribut simple de type entier
                  controles: ['FO0', 'FO1'],
                  model: 'cdata.bim.bam',
                  attribute: 'test2',
                  label: 'Test FO0 et FO1',
                  type: 'entier',
                },
                {
                  // attribut simple de type chaine (de caracteres)
                  controles: ['FO0', 'FO1'],
                  model: 'cdata.bim.bam',
                  attribute: 'test3',
                  label: 'Test FO0 et FO1',
                  type: 'chaine',
                },
                {
                  // attribut existant, ici depuis liste deroulante anc
                  controles: ['FO3', 'FO3_mutation'], // les controles
                  // concernes
                  model: 'cdata.extraFormFields', // l'endroit où
                  // enregistrer la donnée (de préférence laisser dans
                  // extraFormFields)
                  label: 'Priorite Rehab', // le label qui va s'afficher au
                  // dessus du champ dans le controle
                  origine: 'kis_anc_listes_deroulantes_controles', // le
                  // feature type info dans lequel aller chercher la
                  // valeur (facultatif)
                  attribute: 'priorite_rehab', // l'attribut à
                  // aller chercher / alimenter
                },
              ];

              appCfg.main.properties.extraFormFields = {
                fields: [],
              };
              needToUpdateCfg = 1;
            }

            if (!angular.isDefined(appCfg.main.properties.vidangesCfg)) {
              appCfg.main.properties.vidangesCfg = {
                formulaires: ['FO3', 'FO4'],
                elements_filiere: [
                  'kis_anc_ef_autre_pretraitement',
                  'kis_anc_ef_fosse_septique',
                  'kis_anc_ef_toilette_seche',
                  'kis_anc_ef_fosse_etanche',
                  'kis_anc_ef_fosse_toutes_eaux',
                  'kis_anc_ef_epuration_biologie_boues_activees',
                  'kis_anc_ef_fosse_accumulation',
                  'kis_anc_ef_cuve_decantation',
                  'kis_anc_ef_fosse_chimique',
                  'kis_anc_ef_micro_station',
                  'kis_anc_ef_filtre_compact',
                  'kis_anc_ef_filtre_plante',
                ],
              };
              needToUpdateCfg = 1;
            }

            controlePanancCfg = [
              {
                type: 'CTRLBC',
                label: 'Contrôle de conception',
                label_court: 'Conception',
                template: 'Fiche_A.html',
                document_types: [
                  {
                    label: 'Fiche A',
                    fichier: 'fiche_a.docx',
                    detail: 'Version .docx du formulaire de contrôle',
                  },
                  {
                    label: 'Attestation de conformité',
                    fichier: 'fiche_b.docx',
                    detail:
                      "Document attestant de la conformité du projet d'installation d'assainissement non collectif",
                  },
                ],
              },
              {
                type: 'CTRLBE',
                label: 'Bonne éxécution',
                label_court: 'Bonne éxécution',
                template: 'Fiche_C.html',
                document_types: [
                  {
                    label: 'Fiche C',
                    fichier: 'fiche_c.docx',
                    detail: 'Version .docx du formulaire de contrôle',
                  },
                  {
                    label: 'Attestation de conformité',
                    fichier: 'fiche_b.docx',
                    detail:
                      "Document attestant de la conformité du projet d'installation d'assainissement non collectif",
                  },
                ],
              },
              {
                type: 'CTRLBF',
                label: 'Contrôle de bon fonctionnement',
                label_court: 'Bon fonctionnement',
                template: 'Fiche_D.html',
                document_types: [
                  {
                    label: 'Fiches D1',
                    fichier: 'fiche_d1.docx',
                    detail: "Vérification de fonctionnement et d'entretien 1",
                  },
                  {
                    label: 'Fiches D2',
                    fichier: 'fiche_d2.docx',
                    detail: "Vérification de fonctionnement et d'entretien 2",
                  },
                  {
                    label: 'Attestation de conformité',
                    fichier: 'fiche_b.docx',
                    detail:
                      "Document attestant de la conformité du projet d'installation d'assainissement non collectif",
                  },
                ],
              },
            ];

            controleStandardCfg = [
              {
                type: 'FO0',
                label: 'Contrôle de réception',
                label_court: 'Réception FO0',
                template: 'FO0.html',
                document_types: [
                  {
                    label: 'FO0',
                    fichier: 'fiche_fo0.docx',
                    detail: 'Version .docx du formulaire de contrôle',
                  },
                ],
              },
              {
                type: 'FO1',
                label: 'Contrôle de conception',
                label_court: 'Conception FO1',
                template: 'FO1.html',
                document_types: [
                  {
                    label: 'FO1',
                    fichier: 'fiche_fo1.docx',
                    detail: 'Version .docx du formulaire de contrôle',
                  },
                  {
                    label: 'Attestation de conformité',
                    fichier: 'fiche_b.docx',
                    detail:
                      "Document attestant de la conformité du projet d'installation d'assainissement non collectif",
                  },
                ],
              },
              {
                type: 'FO2',
                label: 'Contrôle de réalisation',
                label_court: 'Réalisation FO2',
                template: 'FO2.html',
                document_types: [
                  {
                    label: 'FO2',
                    fichier: 'fiche_fo2.docx',
                    detail: 'Version .docx du formulaire de contrôle',
                  },
                  {
                    label: 'Attestation de conformité',
                    fichier: 'fiche_b.docx',
                    detail:
                      "Document attestant de la conformité du projet d'installation d'assainissement non collectif",
                  },
                ],
              },
              {
                type: 'FO3',
                label: "Diagnostic de l'existant",
                label_court: 'Existant FO3',
                template: 'FO3.html',
                document_types: [
                  {
                    label: 'FO3',
                    fichier: 'fiche_fo3.docx',
                    detail: 'Version .docx du formulaire de diagnostic',
                  },
                  {
                    label: 'Attestation de conformité',
                    fichier: 'fiche_b.docx',
                    detail:
                      "Document attestant de la conformité du projet d'installation d'assainissement non collectif",
                  },
                ],
              },
              {
                type: 'FO4',
                label: 'Contrôle de bon fonctionnement',
                label_court: 'Périodique FO4',
                template: 'FO4.html',
                document_types: [
                  {
                    label: 'FO4',
                    fichier: 'fiche_fo4.docx',
                    detail: 'Version .docx du formulaire de diagnostic',
                  },
                  {
                    label: 'Attestation de conformité',
                    fichier: 'fiche_b.docx',
                    detail:
                      "Document attestant de la conformité du projet d'installation d'assainissement non collectif",
                  },
                ],
              },
              {
                type: 'Ponctuel',
                label: 'Contrôle ponctuel',
                label_court: 'Ponctuel',
                template: 'ponctuel.html',
                document_types: [
                  {
                    label: 'Formulaire de contrôle ponctuel',
                    fichier: 'formulaire_controle_ponctuel.docx',
                    detail: 'Version .docx du formulaire de contrôle',
                  },
                ],
              },
              {
                type: 'FO3_mutation',
                label: 'Vente (F03)',
                label_court: 'Vente (F03)',
                template: 'FO3.html',
                document_types: [
                  {
                    label: 'FO3',
                    fichier: 'fiche_fo3.docx',
                    detail: 'Version .docx du formulaire de diagnostic',
                  },
                  {
                    label: 'Attestation de conformité',
                    fichier: 'fiche_b.docx',
                    detail:
                      "Document attestant de la conformité du projet d'installation d'assainissement non collectif",
                  },
                ],
              },
              {
                type: 'FO4_mutation',
                label: 'Vente (F04)',
                label_court: 'Vente (F04)',
                template: 'FO4.html',
                document_types: [
                  {
                    label: 'FO4',
                    fichier: 'fiche_fo4.docx',
                    detail: 'Version .docx du formulaire de diagnostic',
                  },
                  {
                    label: 'Attestation de conformité',
                    fichier: 'fiche_b.docx',
                    detail:
                      "Document attestant de la conformité du projet d'installation d'assainissement non collectif",
                  },
                ],
              },
            ];

            // @FRT
            // configuring parcelles is mandatory
            if (!appCfg.main.controleCfg) {
              appCfg.main.controleCfg = controleStandardCfg;
              needToUpdateCfg = 1;
            }
            ConfigFactory.checkDocumentsForConfig(appCfg.main.controleCfg).then(
              function(res) {
                appCfg.main.controleCfg = res.data;
              }
            );

            if (!appCfg.main.controleWorkflowCfg) {
              appCfg.main.controleWorkflowCfg = [];
              needToUpdateCfg = 1;
            }

            /*
             * facturationPeriodeCfg
             */
            if (!appCfg.main.periodesCfg) {
              appCfg.main.periodesCfg = {
                periodes: [],
                tarification: [],
              };
              needToUpdateCfg = 1;
            } else {
              if (appCfg.main.periodesCfg.periodes) {
                for (
                  var i = 0;
                  i < appCfg.main.periodesCfg.periodes.length;
                  i++
                ) {
                  if (
                    !appCfg.main.periodesCfg.periodes[i].nom ||
                    appCfg.main.periodesCfg.periodes[i].nom == ''
                  ) {
                    appCfg.main.periodesCfg.periodes[i].nom = 'défaut';
                    needToUpdateCfg = 1;
                  }
                }
              }
            }

            // default map configuration
            if (!appCfg.main.mapConfiguration) {
              appCfg.main.mapConfiguration = {
                bbox: [
                  -703637.6010015747,
                  5258148.272161824,
                  1130851.0778426554,
                  6481140.724724644,
                ],
                featuresConfig: {
                  kis_anc_dossier: '1-1',
                },
              };
              needToUpdateCfg = 1;
            }

            if (!appCfg.main.mapConfiguration.featCana) {
              appCfg.main.mapConfiguration.featCana = {};
              needToUpdateCfg = 1;
            }

            if (!appCfg.main.mapConfiguration.canaVectorielle) {
              appCfg.main.mapConfiguration.canaVectorielle = false;
              needToUpdateCfg = 1;
            }

            if (appCfg.main.entreprisesCfg) {
              if (
                !angular.isDefined(appCfg.main.entreprisesCfg.fields['actif'])
              ) {
                appCfg.main.entreprisesCfg.fields['actif'] = 'actif';
              }
              if (
                !angular.isDefined(appCfg.main.entreprisesCfg.fields['agree'])
              ) {
                appCfg.main.entreprisesCfg.fields['agree'] = 'agree';
              }

              var oldAddressField = false;
              for (var i in appCfg.main.entreprisesCfg.fields) {
                if (i == 'adresse') oldAddressField = true;
              }
              if (
                oldAddressField &&
                appCfg.main.entreprisesCfg.emplacement == 'kis_anc_entreprise'
              ) {
                delete appCfg.main.entreprisesCfg.fields['adresse'];
                [
                  'fax',
                  'adresse_num_rue',
                  'adresse_num_rue_extra',
                  'adresse_rue',
                  'adresse_ville',
                  'adresse_cp',
                  'adresse_bp',
                  'adresse_pays',
                  'adresse_batiment',
                  'adresse_appt',
                  'adresse_etage',
                  'adresse_escalier',
                  'adresse_complement',
                ].forEach(function(x) {
                  appCfg.main.entreprisesCfg.fields[x] = x;
                });
                needToUpdateCfg = 1;
              }
              if (
                oldAddressField &&
                appCfg.main.entreprisesCfg.emplacement != 'kis_anc_entreprise'
              ) {
                delete appCfg.main.entreprisesCfg;
                needToUpdateCfg = 1;
              }
            }

            // Dossier
            if (!appCfg.main.dossierCfg) {
              appCfg.main.dossierCfg = {
                avisControles: [],
                numerotation: {
                  auto: false,
                  separator: '_',
                  parts: [
                    {
                      key: 'date',
                      format: 'ddMMyyyy',
                    },
                    {
                      key: 'index',
                    },
                    {
                      key: 'string',
                      format: 'dossier',
                    },
                  ],
                },
                templates: [
                  {
                    label: 'Avis de Passage',
                    fichier: 'avis_passage.docx',
                    detail:
                      'Avis de passage pour la visite de votre installation d’assainissement',
                  },
                ],
                extraColonne : {
                  active: false,
                  name: 'affectation_construction',
                },
              };

              needToUpdateCfg = 1;
            }
            if (!appCfg.main.dossierCfg.extraColonne) {
              appCfg.main.dossierCfg.extraColonne =  {
                  active: false,
                  name: 'affectation_construction',
                }
                needToUpdateCfg = 1;
            }

            if (!appCfg.main.dossierCfg.avisControles) {
              appCfg.main.dossierCfg.avisControles = [
                {
                  key: 'favorable',
                  label: 'Favorable',
                  label_initial: 'Favorable',
                  default: true,
                },
                {
                  key: 'defavorable',
                  label: 'Défavorable',
                  label_initial: 'Défavorable',
                  default: true,
                },
                {
                  key: 'refus',
                  label: 'Refus de visite',
                  label_initial: 'Refus de visite',
                  default: true,
                },
                {
                  key: 'absent',
                  label: 'Absent',
                  label_initial: 'Absent',
                  default: true,
                },
              ];
            }
          }

          if (angular.isUndefined(appCfg.main.dossierCfg.alerte)) {
            appCfg.main.dossierCfg.alerte = {
              green: 31,
              red: 5,
            };
            needToUpdateCfg = 1;
          }

          // triControleCaj
          // par défaut prends 'caj_id_controle' copmme valeur sinon et pour Bethun , ca prends ca 'caj_ordre_controle'
          if (!angular.isDefined(appCfg.main.properties.triControleCaj)) {
            appCfg.main.properties.triControleCaj = {
              name: 'caj_id_controle',
            };
            needToUpdateCfg = 1;
          }

          // documents à la CCSB
          if (!angular.isDefined(appCfg.main.properties.filemanager)) {
            appCfg.main.properties.filemanager = {
              active: false,
              folder: '',
            };
            needToUpdateCfg = 1;
          }

          if (!angular.isDefined(appCfg.main.properties.requests)) {
            appCfg.main.properties.requests = {
              active: false,
              list: [
                {
                  label: 'Label précis de la requete',
                  name: 'nom_de_la_requete',
                  active: false,
                },
              ],
            };
            needToUpdateCfg = 1;
          }

          if (
            !angular.isDefined(appCfg.main.properties.gestionListesDeroulantes)
          ) {
            appCfg.main.properties.gestionListesDeroulantes = false;
            needToUpdateCfg = 1;
          }

          if (!angular.isDefined(appCfg.main.properties.vidangeDocumentsCfg)) {
            appCfg.main.properties.vidangeDocumentsCfg = {
              document_types: [],
            };
            needToUpdateCfg = 1;
          }
          if (
            !angular.isDefined(appCfg.main.properties.subventionDocumentsCfg)
          ) {
            appCfg.main.properties.subventionDocumentsCfg = {
              document_types: [],
            };
            needToUpdateCfg = 1;
          }

          if (!appCfg.main.properties.geocoder) {
            appCfg.main.properties.geocoder = [];
            var geocoders = angular.copy(
              $rootScope.xgos.portal.parameters.kisgeocodage
            );
            var googleExist = false;

            if (angular.isDefined(geocoders)) {
              geocoders.forEach(function(geocoder) {
                appCfg.main.properties.geocoder.push({
                  id: geocoder.id,
                  active: false,
                  label: geocoder.label,
                });
                if (geocoder.id == 'google') googleExist = true;
              });
            }

            if (!googleExist) {
              appCfg.main.properties.geocoder.push({
                id: 'google',
                active: true,
                label: 'Google',
              });
            }

            needToUpdateCfg = 1;
          }

          if (!angular.isDefined(appCfg.main.properties.geocoderActive)) {
            appCfg.main.properties.geocoderActive = false;
            needToUpdateCfg = 1;
          }

          if (!appCfg.main.properties.serviceLocalisationDossier) {
            appCfg.main.properties.serviceLocalisationDossier = {
              url: false,
              type: 'ban',
            };
            needToUpdateCfg = 1;
          }

          // si on ne veut pas utiliser le reverse geocoder spécifié
          // dans serviceLocalisationDossier, seulement le geocodage
          // direct par ex l'api d'ESRI qui ne renvoie pas les données
          // suffisamment bien formatées
          if (
            !appCfg.main.properties.serviceLocalisationDossier
              .defaultReverseGeocoder
          ) {
            appCfg.main.properties.serviceLocalisationDossier.defaultReverseGeocoder = false;
            needToUpdateCfg = 1;
          }

          if (!angular.isDefined(appCfg.main.properties.formVidange)) {
            appCfg.main.properties.formVidange = false;
            needToUpdateCfg = 1;
          }
          /**
           * Ajout de nouvelle properties , gcDataTableCount 
           * (nombre des lignes a afficher dans le tableau de la liste des dossiers)
          */
          if (!angular.isDefined(appCfg.main.properties.gcDataTableCount)) {
            appCfg.main.properties.gcDataTableCount = 10;
            needToUpdateCfg = 1;
          }

          if (!angular.isDefined(appCfg.main.properties.priseRdv)) {
            appCfg.main.properties.priseRdv = {
              active: true,
            };
            needToUpdateCfg = 1;
          }

          // parametres supplementaires sur les formulaires
          if (!angular.isDefined(appCfg.main.properties.cfgFormulaires)) {
            appCfg.main.properties.cfgFormulaires = {
              agent_valideur: false,
              parties_cachees: {
                siphon_disconnecteur: false,
              },
            };
            needToUpdateCfg = 1;
          }

          // Dessin filiere v2
          if (!angular.isDefined(appCfg.main.properties.filieresVectorielles)) {
            appCfg.main.properties.filieresVectorielles = {
              active: false,
              categories: [
                {
                  title: 'Prétraitement',
                  elements: [
                    'kis_anc_bibliotheque_ef.10',
                    'kis_anc_bibliotheque_ef.11',
                    'kis_anc_bibliotheque_ef.13',
                    'kis_anc_bibliotheque_ef.14',
                    'kis_anc_bibliotheque_ef.16',
                    'kis_anc_bibliotheque_ef.20',
                    'kis_anc_bibliotheque_ef.23',
                    'kis_anc_bibliotheque_ef.25',
                    'kis_anc_bibliotheque_ef.26',
                    'kis_anc_bibliotheque_ef.27',
                    'kis_anc_bibliotheque_ef.3',
                    'kis_anc_bibliotheque_ef.32',
                    'kis_anc_bibliotheque_ef.36',
                    'kis_anc_bibliotheque_ef.38',
                    'kis_anc_bibliotheque_ef.4',
                    'kis_anc_bibliotheque_ef.44',
                    'kis_anc_bibliotheque_ef.45',
                    'kis_anc_bibliotheque_ef.51',
                    'kis_anc_bibliotheque_ef.52',
                    'kis_anc_bibliotheque_ef.53',
                    'kis_anc_bibliotheque_ef.54',
                    'kis_anc_bibliotheque_ef.59',
                    'kis_anc_bibliotheque_ef.60',
                    'kis_anc_bibliotheque_ef.61',
                    'kis_anc_bibliotheque_ef.63',
                    'kis_anc_bibliotheque_ef.66',
                    'kis_anc_bibliotheque_ef.69',
                    'kis_anc_bibliotheque_ef.75',
                    'kis_anc_bibliotheque_ef.76',
                    'kis_anc_bibliotheque_ef.79',
                    'kis_anc_bibliotheque_ef.8',
                    'kis_anc_bibliotheque_ef.70',
                    'kis_anc_bibliotheque_ef.55',
                  ],
                },
                {
                  title: 'Traitement',
                  elements: [
                    'kis_anc_bibliotheque_ef.5',
                    'kis_anc_bibliotheque_ef.18',
                    'kis_anc_bibliotheque_ef.24',
                    'kis_anc_bibliotheque_ef.7',
                    'kis_anc_bibliotheque_ef.42',
                    'kis_anc_bibliotheque_ef.58',
                    'kis_anc_bibliotheque_ef.6',
                    'kis_anc_bibliotheque_ef.34',
                    'kis_anc_bibliotheque_ef.9',
                    'kis_anc_bibliotheque_ef.81',
                    'kis_anc_bibliotheque_ef.64',
                    'kis_anc_bibliotheque_ef.17',
                    'kis_anc_bibliotheque_ef.33',
                    'kis_anc_bibliotheque_ef.15',
                    'kis_anc_bibliotheque_ef.73',
                    'kis_anc_bibliotheque_ef.41',
                    'kis_anc_bibliotheque_ef.2',
                    'kis_anc_bibliotheque_ef.50',
                    'kis_anc_bibliotheque_ef.62',
                    'kis_anc_bibliotheque_ef.46',
                    'kis_anc_bibliotheque_ef.57',
                    'kis_anc_bibliotheque_ef.47',
                    'kis_anc_bibliotheque_ef.29',
                    'kis_anc_bibliotheque_ef.49',
                    'kis_anc_bibliotheque_ef.43',
                    'kis_anc_bibliotheque_ef.30',
                    'kis_anc_bibliotheque_ef.74',
                    'kis_anc_bibliotheque_ef.68',
                    'kis_anc_bibliotheque_ef.1',
                    'kis_anc_bibliotheque_ef.12',
                    'kis_anc_bibliotheque_ef.83',
                    'kis_anc_bibliotheque_ef.84',
                    'kis_anc_bibliotheque_ef.85',
                    'kis_anc_bibliotheque_ef.86',
                  ],
                },
                {
                  title: 'Autre',
                  elements: [
                    'kis_anc_bibliotheque_ef.77',
                    'kis_anc_bibliotheque_ef.37',
                    'kis_anc_bibliotheque_ef.48',
                    'kis_anc_bibliotheque_ef.35',
                    'kis_anc_bibliotheque_ef.39',
                    'kis_anc_bibliotheque_ef.78',
                    'kis_anc_bibliotheque_ef.72',
                    'kis_anc_bibliotheque_ef.80',
                    'kis_anc_bibliotheque_ef.22',
                    'kis_anc_bibliotheque_ef.21',
                  ],
                },
                {
                  title: 'Filières agréées',
                  elements: [
                    'kis_anc_bibliotheque_ef.67',
                    'kis_anc_bibliotheque_ef.65',
                    'kis_anc_bibliotheque_ef.71',
                    'kis_anc_bibliotheque_ef.31',
                    'kis_anc_bibliotheque_ef.56',
                    'kis_anc_bibliotheque_ef.40',
                    'kis_anc_bibliotheque_ef.19',
                    'kis_anc_bibliotheque_ef.82',
                    'kis_anc_bibliotheque_ef.28',
                  ],
                },
              ],
            };
            needToUpdateCfg = 1;
          }
          if (
            !angular.isDefined(
              appCfg.main.properties.filieresVectorielles.categories
            )
          ) {
            appCfg.main.properties.filieresVectorielles.categories = [
              {
                title: 'test',
                elements: [],
              },
            ];
            needToUpdateCfg = 1;
          }
          /*******************************************************************
           * Paramétrage des services des checks
           *******************************************************************/
           if (!angular.isDefined(appCfg.main.properties.servicesChecks)) {
            let dateNow = $filter('date')(new Date(), 'yyyy-MM-dd');
            appCfg.main.properties.servicesChecks = 
              [
                {
                  name: 'checkPortalData',
                  dateDernierLancement: dateNow,
                  forcerLancement : false
                },
                {
                  name: 'checkAncAppData',
                  dateDernierLancement: dateNow,
                  forcerLancement : false
                }
              ];
            needToUpdateCfg = 1;
          }
          // UPDATE CFG
          if (needToUpdateCfg) {
            updateAppCfg(1);
          }
          appCfg.allowedtoopenbac = false
          // is anc admin
          appCfg.isAdmin = $rootScope.xgos.isadmin;
          appCfg.hasAccess = {
            facturation: angular.copy($rootScope.xgos.isadmin),
            mapApp: angular.copy($rootScope.xgos.isadmin)
          };
          $rootScope.hasnotExtra = true;
          $rootScope.hasExtra = false;
          if (angular.isArray($rootScope.xgos.user.roles)) {
            for (var i in $rootScope.xgos.user.roles) {
              if ($rootScope.xgos.user.roles[i].name == 'ANCadmin') {
                appCfg.isAdmin = true;
                appCfg.hasAccess.mapApp = true;
              } else if ($rootScope.xgos.user.roles[i].name == 'ANC_facturation') {
                appCfg.hasAccess.facturation = true;
               } else if($rootScope.xgos.user.roles[i].name == 'consultation' || $rootScope.xgos.user.roles[i].name == 'ANC_agent'){
                appCfg.hasAccess.mapApp = true
               }

               if ($rootScope.xgos.user.roles[i].name == 'BAC_admin' || $rootScope.xgos.user.roles[i].name == 'BAC_agent' || $rootScope.xgos.user.roles[i].name == 'BAC_responsable'){
                appCfg.allowedtoopenbac = true;
               }
            }
            // mise à jour de la config
            updateAppCfg(1);
          }

          // needed data
          var neededData = [
            FeatureTypeFactory.get(),
            getAllExtractedJsonData(),
          ];

          // toujours push ca en dernier
          if (appCfg.main.properties.elementFiliereAPart) {
            neededData.push(
              ConfigFactory.get(
                'main',
                'elementsFiliereTemplates',
                appCfg.appname
              )
            );
          }

          $q.all(neededData).then(function(res) {
            if (appCfg.main.properties.elementFiliereAPart) {
              appCfg.elementsFiliereTemplates = res[res.length - 1].data;
            }

            // check anc data (equivalent to check portal data) only
            // once per browser instance
            if (!ancDataChecked) {
              gaDomUtils.showGlobalLoader();
              if (!simpleGet) extractModelFromForm();
              /**
               * Vérification pour lancer ou non le service de check,selon la configuration
               */
              if (getAppCfgServicesChecksExecuteOrNot('checkAncAppData')) {
                checkancappdata().then(
                  function (res) {
                    ancDataChecked = true;
                    /**
                     * Maj de la configuration des services Checks
                     */
                    majAppCfgServicesChecks('checkAncAppData');
                  }
                );
              }
            }
            gaDomUtils.hideGlobalLoader();
            cfgPromise.resolve();
            $rootScope.$broadcast('AncAppCfgSet', {
              cfg: appCfg,
            });          
          });
        });
      }

      return cfgPromise.promise;
    }
    /**************************************************************************************************
    * Gestion de la configuration des services Checks
    ***************************************************************************************************/
    /**
     * Récupération de la configuration des servicesChecks + Verification de lancement du service
     * 
     * @param {String} serviceCheck 
     * 
     * @returns {boolean} lance ou pas le service
     */
    const getAppCfgServicesChecksExecuteOrNot = (serviceCheck) => {
      if (
        appCfg &&
        appCfg.main &&
        appCfg.main.properties.servicesChecks &&
        angular.isArray(appCfg.main.properties.servicesChecks)
      ) {
        for (let service of appCfg.main.properties.servicesChecks) {
          if (service.name && service.name === serviceCheck) {
            let dateNow = $filter('date')(new Date(), 'yyyy-MM-dd');
            let dateDernierLancementCheck = false;
            if (service.dateDernierLancement) {
              const dateDernierLancement = new Date(
                service.dateDernierLancement
              );
              dateDernierLancementCheck = dateDernierLancement.getTime() < new Date(dateNow).getTime();
            }
            return dateDernierLancementCheck || service.forcerLancement;
          }
        }
      }
      return false;
    };
     
    
    /**
     * maj de la configuration des servicesChecks
     * 
     * @param {String} serviceCheck 
     */
     const majAppCfgServicesChecks = (serviceCheck) => {
      ConfigFactory.get('main', 'mainConfig', appCfg.appname).then(function (
        res
      ) {
        if (res && res.data) {
          let appCfgCheck = res.data;
          if (
            appCfgCheck &&
            appCfgCheck.properties &&
            appCfgCheck.properties.servicesChecks &&
            angular.isArray(appCfgCheck.properties.servicesChecks)
          ) {
            for (let indice in appCfgCheck.properties.servicesChecks) {
              let service = appCfgCheck.properties.servicesChecks[indice];
              let dateNow = $filter('date')(new Date(), 'yyyy-MM-dd');
              if (service.name && service.name === serviceCheck) {
                service.forcerLancement = false;
                service.dateDernierLancement = dateNow;
                appCfgCheck.properties.servicesChecks[indice] = service;
              }
            }
            updateAppCfg(1,appCfgCheck)
          }
        }
      });
    };

    /**
     * @param silent
     */
    var updateAppCfg = function(silent,appCfgCheck) {
      var toSave = appCfgCheck ? angular.copy(appCfgCheck) : angular.copy(appCfg.main);
      // ajout : on sauvegarde aussi, chaque jour, une version temporaire
      var sauveGardes = [
        ConfigFactory.add(toSave, 'main', 'mainConfig', appCfg.appname),
        ConfigFactory.add(
          toSave,
          'main',
          'mainConfig_' + moment(new Date()).format('DD_MM_YYYY'),
          appCfg.appname
        ),
      ];

      var promise = $q.all(sauveGardes).then(function() {
        if (!silent)
          require('toastr').success(
            "Configuration de l'application mise à jour",
            '',
            {
              positionClass: 'toast-bottom-left',
            }
          );
      });

      return promise;
    };

    /**
     * Function: updateCanalGeoServerStyle
     */
    function updateCanalGeoServerStyle(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/updateCanalGeoServerStyle?f=json',
        senddata
      );
    }

    /**
     * Update des elements de filieres qui se trouvent dans un fichier à part si
     * la config le précise
     *
     * @param {*}
     *            silent
     */
    var updateElementFiliereAppCfg = function(silent) {
      var sauveGardes = [
        ConfigFactory.add(
          appCfg.elementsFiliereTemplates,
          'main',
          'elementsFiliereTemplates',
          appCfg.appname
        ),
        ConfigFactory.add(
          appCfg.elementsFiliereTemplates,
          'main',
          'elementsFiliereTemplates_' + moment(new Date()).format('DD_MM_YYYY'),
          appCfg.appname
        ),
      ];
      var promise = $q.all(sauveGardes).then(function() {
        if (!silent)
          require('toastr').success(
            "Configuration de l'application (modèles des éléments de filière) mise à jour",
            '',
            {
              positionClass: 'toast-bottom-left',
            }
          );
      });
      return promise;
    };

    /**
     * Returen controle Display name
     *
     * @param type
     *            string
     * @param date_creation
     *            date
     * @returns {string}
     */
    var getControleName = function(type, date_creation, shortname) {
      var label = '';
      shortname = shortname || 1;

      appCfg.main.controleCfg.forEach(function(x) {
        if (x.type == type) {
          label = shortname ? x.label_court : x.label;
        }
      });

      if (angular.equals({}, date_creation)) date_creation = false;

      return (
        label +
        ' ' +
        (date_creation
          ? ' - ' + $filter('date')(date_creation, 'dd.MM.yy')
          : '')
      );
    };

    /**
     * Génération du numéro auto de dossier
     *
     * @param id
     * @param numerotation
     */
    var getNumeroAuto = function(id, numerotation) {
      var partsPreview = [];
      if (!numerotation) numerotation = appCfg.main.dossierCfg.numerotation;

      numerotation.parts.forEach(function(p) {
        var displayValue = id;
        if (p.key != 'index') {
          if (p.key == 'string') displayValue = p.format;
          if (p.key == 'date')
            displayValue = $filter('date')(new Date(), p.format);
        }
        partsPreview.push(displayValue);
      });
      return partsPreview.join(numerotation.separator);
    };

    

    /**
     * transform ancDossier to Dossier feature in order to submit it to the
     * server
     */
    var ancDossierToDossier = function(ancdossier, tmpReference) {
      var dossier = angular.copy(ancdossier);

      if (tmpReference) {
        dossier.properties.ref_dossier = tmpReference;
      }

      delete dossier.properties.proprietaires;
      delete dossier.properties.locataires;
      delete dossier.properties.demandeurs;
      delete dossier.properties.parcelleHabitation;
      delete dossier.properties.parcelleFiliere;
      delete dossier.properties.parcelleHabitation_numero;
      delete dossier.properties.parcelleHabitation_section;
      delete dossier.properties.adresse;
      delete dossier.properties.dernierControle;
      delete dossier.properties.infosProchainControle;
      delete dossier.properties.agent_prochain_rdv;
      delete dossier.properties.infosFilieres;
      delete dossier.properties.adresse_rue_complement;

      // transforme la geometrie en multipoints si pas deja le cas
      if (angular.isDefined(dossier.geometry) && dossier.geometry !== null) {
        if (dossier.geometry.type == 'Point') {
          dossier.geometry.type = 'MultiPoint';
          dossier.geometry.coordinates = [
            angular.copy(dossier.geometry.coordinates),
          ];
        }
      }

      return dossier;
    };

    var getPanancCfg = function() {
      return controlePanancCfg;
    };

    var getStandardCfg = function() {
      return controleStandardCfg;
    };

    /**
     * getNewControleData
     *
     * @param id_dossier
     * @param controlesDuDossier
     * @param newCtrlType
     */
    var getNewControleData = function(
      id_dossier,
      controlesDuDossier,
      newCtrlType,
      forceId
    ) {
      var newCtrlData = {};
      var g = $q.defer();
      if (!controlesDuDossier.length) {
        g.resolve(false);
      } else {
        var dernierCtrl = controlesDuDossier[0],
          prevCtrlType = dernierCtrl.properties.type,
          commonKeys = [];

        // get both json extractions
        var requests;
        if (typeof ancAppAndroid !== 'undefined') {
          requests = [
            getextractedjsondata(prevCtrlType),
            getextractedjsondata(newCtrlType),
          ];
        } else {
          requests = [
            $http.get(getextractedjsondataurl(prevCtrlType), {
              cache: false,
            }),
            $http.get(getextractedjsondataurl(newCtrlType), {
              cache: false,
            }),
          ];
        }

        // get all data
        $q.all(requests).then(
          function(res) {
            // unique list of keys
            var extractKeys = function(uns) {
                var arrKeys = uns.data.parts.map(function(x) {
                  return x.data.map(function(xx) {
                    return xx.key;
                  });
                });
                return Array.prototype.concat
                  .apply([], arrKeys)
                  .filter(function(label) {
                    return angular.isDefined(label);
                  });
              },
              // both arrays
              prevModel = extractKeys(res[0]),
              newModel = extractKeys(res[1]);

            if (newModel.length) {
              newModel.forEach(function(newKey) {
                if (~prevModel.indexOf(newKey))
                  commonKeys.push(newKey.replace('cdata.', ''));
              });
            }

            getcontroledetail(
              id_dossier,
              angular.isDefined(forceId) ? forceId : dernierCtrl.id
            ).then(
              function(res) {
                // reset des informations qui ne doivent pas etre récupérées
                if (angular.isDefined(res.data.conformite))
                  delete res.data.conformite;

                var oldCtrlData = res.data;
                for (var i in commonKeys) {
                  var oldvalue = gaJsUtils.checkNestedProperty(
                    commonKeys[i],
                    oldCtrlData
                  );
                  if (oldvalue !== false) {
                    gaJsUtils.setNestedProperty(
                      commonKeys[i],
                      newCtrlData,
                      oldvalue
                    );
                  }
                }

                if (gaJsUtils.checkNestedProperty('conformite', newCtrlData))
                  delete newCtrlData.conformite;
                if (
                  gaJsUtils.checkNestedProperty(
                    'general.statut_rdv',
                    newCtrlData
                  )
                )
                  delete newCtrlData.general.statut_rdv;
                if (
                  gaJsUtils.checkNestedProperty(
                    'datesDossier.date_demande',
                    newCtrlData
                  )
                )
                  delete newCtrlData.datesDossier.date_demande;
                if (
                  gaJsUtils.checkNestedProperty(
                    'datesDossier.date_controle',
                    newCtrlData
                  )
                )
                  delete newCtrlData.datesDossier.date_controle;
                if (
                  gaJsUtils.checkNestedProperty(
                    'datesDossier.date_avis',
                    newCtrlData
                  )
                )
                  delete newCtrlData.datesDossier.date_avis;
                if (
                  gaJsUtils.checkNestedProperty(
                    'datesDossier.date_avis_controleur',
                    newCtrlData
                  )
                )
                  delete newCtrlData.datesDossier.date_avis_controleur;
                if (
                  gaJsUtils.checkNestedProperty(
                    'datesDossier.date_passage',
                    newCtrlData
                  )
                )
                  delete newCtrlData.datesDossier.date_passage;
                if (
                  gaJsUtils.checkNestedProperty(
                    'datesDossier.date_controle_rdv',
                    newCtrlData
                  )
                )
                  delete newCtrlData.datesDossier.date_controle_rdv;

                g.resolve(newCtrlData);
              },
              function() {
                g.resolve(false);
              }
            );
          },
          function(x) {
            g.resolve(false);
          }
        );
      }

      return g.promise;
    };

    /**
     * extract ngmodels from html forms and create files _extract
     *
     * @param ctrl
     */
    var _extract = function(ctrl) {
      var p = $q.defer();

      // get ctrl main file
      var ctrlName = ctrl.template.replace('.html', '');
      getControlesHTML(ctrlName).then(
        function(res) {
          htmlformtojson(res, ctrl.type).then(
            function(r) {
              p.resolve();
            },
            function() {
              p.reject();
            }
          );
        },
        function() {
          console.log(
            "Une erreur s'est produite lors de la récupération données du formulaire " +
              ctrlName +
              '.'
          );
          p.reject();
        }
      );

      return p.promise;
    };

    /**
     * extractModelFromForm recursive _extract (launched once per session,
     *
     * @TODO handle it better)
     * @param idx
     */
    var extractModelFromForm = function(idx) {
      if (!idx) idx = 0;

      if (angular.isDefined(appCfg.main.controleCfg[idx])) {
        _extract(appCfg.main.controleCfg[idx]).then(function() {
          extractModelFromForm(idx + 1);
        });
      } else {
        // extraction des vidanges
        if (appCfg.main.properties.formVidange == true) {
          _extract({
            type: 'vidange_formulaire',
            template: 'vidange.html',
          });
        }
        // @TODO donnees communes a tous les formulaires
      }
    };
    /**
     * Function: synchrotournee
     */
    function synchrotournee(tournee, id) {
      var promise = $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/synchroTournee?f=json&tournee=' +
          tournee +
          '&id=' +
          id
      );

      return promise;
    }

    /**
     * Function: synchrotournee
     */
    function synchroTourneeProgression(uid) {
      var promise = $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/synchroTourneeProgression?f=json&uid=' +
          uid
      );

      return promise;
    }

    /**
     * Function: removetournee
     */
    function removetournee(idtournee) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/removeTournee?f=json&idtournee=' +
          idtournee
      );
    }

    /**
     * Function: debloquetournee
     */
    function debloquetournee(idtournee, bool) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/debloqueTournee?f=json&idtournee=' +
          idtournee +
          '&bool=' +
          bool
      );
    }

    /**
     * Function: gettournees
     */
    function gettournees(agent) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getTournees?f=json&agent=' +
          agent
      );
    }

    /**
     * Function: gettournees
     */
    function getAllTournees(agent) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getAllTournees?f=json&agent=' +
          agent
      );
    }

    /**
     * Function: gettournees
     */
    function getDossiersTournee(id) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getDossiersTournee?f=json&id=' +
          id
      );
    }

    /**
     * translateKeyForRecherche permet de prefixer les attributs des ctrl avec
     * une sous-categorie (proprietaire, occupant, demandeur, service...) pour
     * les select de recherche elastic
     *
     * @param {*}
     *            key
     */
    var translateKeyForRecherche = function(key) {
      var t = '';

      // in case of cdata.cdata.
      key = key.replace('cdata.', '');
      if (!key.indexOf('info_generales.dossier.')) t = 'Dossier';
      if (!key.indexOf('info_generales.parcelleHabitation.'))
        t = 'Parcelle habitation';
      if (!key.indexOf('info_generales.parcelleFiliere.'))
        t = 'Parcelle filière';
      if (!key.indexOf('info_generales.proprietaire.')) t = 'Propriétaire';
      if (!key.indexOf('info_generales.locataire.')) t = 'Occupant';
      if (!key.indexOf('info_generales.demandeur.')) t = 'Demandeur';
      if (!key.indexOf('service_controle.')) t = 'Service de contrôle';
      if (!key.indexOf('conformite.')) t = 'Bloc avis';
      if (!key.indexOf('caracteristiques_hab.')) t = 'Habitation';

      if (!key.indexOf('general.concepteur.')) t = 'Concepteur';
      if (!key.indexOf('caracteristiques_terrain.')) t = 'Terrain';
      if (!key.indexOf('caracteristique_terrain.')) t = 'Terrain';
      if (!key.indexOf('pedo.')) t = 'Pédologie';
      if (!key.indexOf('etudes_doc.')) t = 'Etude de définition';
      if (!key.indexOf('caracteristiques_install.')) t = 'Installation';
      if (!key.indexOf('impact_filiere.')) t = 'Impact Filière';
      if (!key.indexOf('conc.')) t = 'Filière conforme ?';
      if (!key.indexOf('grille.')) t = 'Grille de conformité';

      if (!key.indexOf('donnee_controle.')) t = 'Général';
      if (!key.indexOf('general.')) t = 'Général';
      if (!key.indexOf('donnees_gen.')) t = 'Général';
      if (!key.indexOf('donnee_generale.')) t = 'Général';
      if (!key.indexOf('implant.')) t = 'Implantation';
      if (!key.indexOf('controle_implantation.')) t = 'Implantation';
      if (!key.indexOf('datesDossier.')) t = 'Date';
      if (!key.indexOf('avis_controle.')) t = 'Avis Contrôle';
      if (!key.indexOf('ponc.')) t = 'Ponctuel';
      if (!key.indexOf('modif.')) t = 'Modification';
      if (!key.indexOf('general.installateur.')) t = 'Installateur';

      if (t != '') t += ' > ';

      return t;
    };

    /**
     * Function: addcahierdevie
     */
    function addcahierdevie(ref_dossier, nom, identifiant) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addCahierDeVie(ref_dossier, nom, identifiant, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addCahierDeVie?f=json&ref_dossier=' +
            ref_dossier +
            '&nom=' +
            nom +
            '&identifiant=' +
            identifiant
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    var getChoixStatutRDV = function() {
      return [
        {
          value: 'absent',
          label: 'Absent',
        },
        {
          value: 'refus',
          label: 'Refus de visite',
        },
        {
          value: 'npai',
          label: "N'habite pas à l'adresse indiquée",
        },
        {
          value: 'present',
          label: 'Présent',
        },
        {
          value: 'reporte',
          label: 'Reporté',
        },
        {
          value: 'annule',
          label: 'Annulé',
        },
      ];
    };

    function getFilterRenderForAlerte() {
      return [
        {
          key: 'sans',
          label: 'Sans',
        },
        {
          key: 'alerte',
          label: 'Alerte sans échéance',
        },
        {
          key: 'alerte_verte',
          label: 'Alerte verte',
          type: 'date',
        },
        {
          key: 'alerte_jaune',
          label: 'Alerte jaune',
          type: 'date',
        },
        {
          key: 'alerte_rouge',
          label: 'Alerte rouge',
          type: 'date',
        },
        {
          key: 'echeance',
          label: 'Alerte avec échéance',
        },
      ];
    }

    function getFilterRenderForEtatDossier() {
      return [
        {
          key: '',
          label: 'Tous états confondus',
        },
        {
          key: 'ouvert',
          label: 'Ouvert',
        },
        {
          key: 'en_cours',
          label: 'En cours',
        },
        {
          key: 'sans_suite',
          label: 'Sans suite',
        },
        {
          key: 'archive',
          label: 'Archivé',
        },
      ];
    }

    function getFilterRender(
      copyAvisCtrl,
      controle_filter,
      liste_ville_filter,
      liste_volume_filter,
      liste_type_proprio_filter,
      controleFilterProchain
    ) {
      //-- Quand on choisi le type du dernier contrôle
      //-- il faut limiter les possibilités de la liste
      //-- des avis du dernier controle à ceux des types
      //-- de dernier controle choisi.
      let typeDerCtrlFilter = angular.copy(controle_filter);
      typeDerCtrlFilter.cfg.dependency = {
        field: 'avis_dernier_controle',
        thisDepField: 'key',
        otherDepField: 'type_controle',
        showAnyWay: [
          {
            field: 'type_controle',
            value: 'Statut du RDV',
          },
        ],
      };

      return {
        alerte: getFilterRenderForAlerte(),
        etat_dossier: getFilterRenderForEtatDossier(),
        avis_dernier_controle: {
          liste: copyAvisCtrl,
          groupBy: 'type_controle',
          cfg: {
            multiSelect: true,
          },
        },
        prochain_controle: {
          liste: controleFilterProchain,
          groupBy: 'controle_en_cours',
          cfg: {
            multiSelect: true,
          },
        },
        type_dernier_controle: typeDerCtrlFilter,
        adresse_ville: liste_ville_filter,
        volumeFiliere: liste_volume_filter,
        typeProprietaire: liste_type_proprio_filter,
      };
    }
    /**
     * getListeDossiersCfg Retourne divers parametres utilises dans la datatable
     * principale de l'appli qui est utilisée a plusieurs endroits
     * (listeDossiers, publipostage,...)
     */
    var getListeDossiersCfg = function(dossierFti) {
      // attributes
      var dossierAttributes = [
        {
          name: 'proprietaires',
          type: 'ObjectsArray',
          key: 'nomComplet',
          filterType: 'liaison',
        },
        {
          name: 'locataires',
          type: 'ObjectsArray',
          key: 'nomComplet',
          filterType: 'liaison',
        },
        {
          type: 'java.lang.String',
          name: 'parcelleHabitation_numero',
          filterType: 'liaison',
        },
        {
          type: 'java.lang.String',
          name: 'parcelleHabitation_section',
          filterType: 'liaison',
        },

        {
          type: 'java.lang.String',
          name: 'adresse_cp',
        },
        {
          type: 'java.lang.String',
          name: 'adresse_ville',
        },
      ];

      var dossierAttributesRaccordes = angular.copy(dossierAttributes);
      let positionDecalage = 0 ;

      if (dossierFti.attributes) {
        dossierFti.attributes.forEach(function(att) {
          if (
            ~[
              'alerte',
              'ref_dossier',
              'adresse_num_rue',
              'adresse_rue',
              'type_dernier_controle',
              'date_dernier_controle',
              'avis_dernier_controle',
              'date_prochain_controle',
              'prochain_controle',
              'dernierControle',
              'date_prochain_controle_preconise',
              'affectation_construction'
            ].indexOf(att.name)
          ) {
            if (att.name === 'ref_dossier') {
              dossierAttributes.splice(0, 0, att);
            } else if (att.name === 'alerte') {
              dossierAttributes.splice(0, 0, att);
            } else if (
              appCfg.main.dossierCfg.extraColonne.active == true &&
              att.name === 'affectation_construction'
            ) {
              dossierAttributes.splice(2, 0, att);
              positionDecalage = positionDecalage +1 ;
            } else if (att.name === 'adresse_num_rue') {
              dossierAttributes.splice(5+positionDecalage, 0, att);
            } else if (att.name === 'adresse_rue') {
              let rueComplement = {
                type: att.type,
                name: 'adresse_rue_complement',
                alias: att.alias,
              };
              dossierAttributes.splice(6+positionDecalage, 0, rueComplement);
            } else if (att.name === 'type_dernier_controle') {
              dossierAttributes.push(att);
            } else if (att.name !== 'affectation_construction') {
              dossierAttributes.push(att);
            }
          }
        });
      }

      var serviceControle = {
        type: 'java.lang.String',
        name: 'serviceControle',
        filterType: 'liaison',
        alias: 'Service du contrôle',
      };
      dossierAttributes.splice(12+positionDecalage, 0, serviceControle);

      var volumeFiliere = {
        type: 'java.lang.String',
        name: 'volumeFiliere',
        filterType: 'liaison',
        alias: 'Volume de la filière',
      };
      dossierAttributes.splice(17+positionDecalage, 0, volumeFiliere);

      const numRueProprietaire = {
        type: 'java.lang.Integer',
        name: 'numRueProprietaire',
        alias: 'N° rue propriétaire',
        filterType: 'liaison',
        csvValueInfo:['numRue', 'numRueExtra'],
        parentPropertyName:'proprietaires'
      };
      dossierAttributes.splice(18+positionDecalage, 0, numRueProprietaire);

      const rueProprietaire = {
        type: 'java.lang.String',
        name: 'rueProprietaire',
        alias: 'Rue',
        filterType: 'liaison',
        csvValueInfo:['rue'],
        parentPropertyName:'proprietaires'
      };
      dossierAttributes.splice(19+positionDecalage, 0, rueProprietaire);

      const villeProprietaire = {
        type: 'java.lang.String',
        name: 'villeProprietaire',
        alias: 'Ville ',
        filterType: 'liaison',
        csvValueInfo:['ville'],
        parentPropertyName:'proprietaires'
      };
      dossierAttributes.splice(20+positionDecalage, 0, villeProprietaire);

      const cpProprietaire = {
        type: 'java.lang.String',
        name: 'cpProprietaire',
        alias: 'CP ',
        filterType: 'liaison',
        csvValueInfo:['cp'],
        parentPropertyName:'proprietaires'
      };
      dossierAttributes.splice(21+positionDecalage, 0, cpProprietaire);

      const paysProprietaire = {
        type: 'java.lang.String',
        name: 'paysProprietaire',
        alias: 'Pays',
        filterType: 'liaison',
        csvValueInfo:['pays'],
        parentPropertyName:'proprietaires'
      };
      dossierAttributes.splice(22+positionDecalage, 0, paysProprietaire);

      const typeProprietaire = {
        type: 'java.lang.String',
        name: 'typeProprietaire',
        alias: 'Type',
        filterType: 'liaison',
        csvValueInfo:['typeProprietaire'],
        parentPropertyName:'proprietaires'
      };
      dossierAttributes.splice(23+positionDecalage, 0, typeProprietaire);

      var dossierAttributesRaccordes = angular.copy(dossierAttributes);
      if (Array.isArray(dossierFti.attributes)) {
        dossierFti.attributes.forEach(function(att) {
          // dossiers raccordes ont une colonne en plus
          if (att.name == 'date_raccordement') {
            dossierAttributesRaccordes.splice(2, 0, att);
          }
        });
      }



      var controle_filter = {
        cfg: {
          multiSelect: true,
        },
        liste: [],
      };

      appCfg.main.controleCfg.forEach(function(item) {
        controle_filter.liste.push({
          key: item.type,
          label: item.label_court,
        });
      });

      /**
       * Nouveau Filtre sur les Contrôles
       */
      let controleFilterProchain = [];
      appCfg.main.controleCfg.forEach(function(item) {
        controleFilterProchain.push({
          label: item.label_court,
          key: item.type+ "en-cours",
          typeControle: item.type,
          controle_en_cours: "Contrôles en cours",
        });
        controleFilterProchain.push({
          label: item.label_court,
          key: item.type+ "a-creer",
          typeControle: item.type,
          controle_en_cours: "Contrôles à créer",
        });
      });


      var liste_ville_filter = [];
      getdossier_villes().then(function(res) {
        res.data.forEach(function(v) {
          var v_upper = v.charAt(0).toUpperCase() + v.slice(1);
          liste_ville_filter.push({
            key: v,
            label: v_upper,
          });
        });
        liste_ville_filter.unshift({
          key: '',
          label: 'Toutes villes confondues',
        });
      });

      var liste_volume_filter = [];
      liste_volume_filter.push({
        key: '0',
        label: 'Volume inférieur ou égal à 20 EH',
      });
      liste_volume_filter.push({
        key: '1',
        label: 'Volume compris entre 21 et 200 EH',
      });
      liste_volume_filter.push({
        key: '2',
        label: 'Volume supérieur à 200 EH',
      });

      liste_volume_filter.push({
        key: '',
        label: 'Tous volumes confondus',
      });

      var liste_type_proprio_filter = [];
      liste_type_proprio_filter.push({
        key: '1',
        label: 'Entreprise',
      });
      liste_type_proprio_filter.push({
        key: '2',
        label: 'Particulier',
      });
      liste_type_proprio_filter.push({
        key: '3',
        label: 'Sociéte',
      });
      liste_type_proprio_filter.push({
        key: '99',
        label: 'Autre',
      });
      liste_type_proprio_filter.push({
        key: '',
        label: 'Tous types confondus',
      });

      // prepare filtre sur les statuts/avis
      var copyAvisCtrl = [];
      var choixTmp = getChoixStatutRDV();
      for (var i in choixTmp) {
        copyAvisCtrl.push({
          label: choixTmp[i].label,
          type_controle: 'Statut du RDV',
        });
      }
      let inactiveAvis = [];
      for (let j in appCfg.main.dossierCfg.avisControles) {
        let avisControle = appCfg.main.dossierCfg.avisControles[j];
        if (
          angular.isDefined(avisControle.type_controle) ||
          avisControle.actif === true
        ) {
          copyAvisCtrl.push(avisControle);
        } else {
          let avisControleCopy = angular.copy(avisControle);
          avisControleCopy.type_controle = 'Avis inactifs';
          inactiveAvis.push(avisControleCopy);
        }
      }
      copyAvisCtrl.unshift({
        key: '',
        label: 'Tous avis confondus',
      });
      if (inactiveAvis.length) {
        inactiveAvis.forEach(avisControle => copyAvisCtrl.push(avisControle));
      }

      // liste des agents
      var agentsPortail = [];
      UsersFactory.getactiveuserslight().then(function(res) {
        var gusers = res.data,
          _users;
        if (typeof userAndroid !== 'undefined') {
          _users = gusers;
        } else {
          _users = gusers.filter(function(u) {
            return ['ANC_agent'].filter(function(n) {
              return (
                u.roles
                  .map(function(g) {
                    return g.name;
                  })
                  .indexOf(n) !== -1
              );
            }).length;
          });
        }
        for (var i in _users) {
          agentsPortail.push({
            key: _users[i].login,
            label: _users[i].login,
          });
        }
        agentsPortail.unshift({
          key: null,
          label: 'Tous agents confondus',
        });
      });

      const tableNextControlNameAndAgentANC = (controlType, dossier, notHtml) => {
        const controlHtml = CommonFactory.replaceControlName(
          dossier.properties.prochain_controle,
          false,
          appCfg.main.controleCfg
        );
        let controlName = controlHtml
          ? controlHtml
          :  CommonFactory.replaceControlName(
            dossier.properties.type_prochain_controle_preconise,
            dossier.properties.infosProchainControle.id !== 'undefined',
            appCfg.main.controleCfg
          );

        if (!controlName) {
          controlName = '';
        } else {
          if (typeof ancAppAndroid !== 'undefined') {
            controlType =
              controlHtml != null
                ? '<span class="listeDossierCtrlType" ng-click="actionFromDatatable({fn:\'openAncControle\',data:{dossierId: \'' +
                dossier.id +
                '\'}})">' +
                controlType +
                ' ' +
                '</span>'
                : '<span class="listeDossierCtrlType">' +
                controlName +
                ' ' +
                '</span>';
          } else {
            controlName =
              controlHtml != null && dossier.properties.infosProchainControle.id
                ? '<span class="listeDossierCtrlType" ng-click="actionFromDatatable({fn:\'openAncControle\',data:{dossierId: \'' +
                dossier.id +
                "', controleId: '" +
                dossier.properties.infosProchainControle.id +
                '\'}})">' +
                controlName +
                ' ' +
                '</span>'
                : '<span class="listeDossierCtrlType">' +
                controlName +
                ' ' +
                '</span>';
          }
        }

        let agent = '';
        if (
          gaJsUtils.checkNestedProperty(
            'properties.agent_prochain_rdv',
            dossier
          ) &&
          controlType != ''
        ) {
          agent =
            '<span class="text-muted"><i class="fa fa-user"></i><small> ' +
            dossier.properties.agent_prochain_rdv +
            '</small></span></span>';
        }

        return notHtml
          ? CommonFactory.findControlTypeLabel(controlType, appCfg.main.controleCfg)
            + ' ' + (dossier.properties.dernierControle.agent || '')
          : $sce.trustAsHtml(controlName + ' ' + agent);
      };

      const tableControlAndAgentForLastControlANC = (controle, dossier, notHtml) => {
        let controlName = CommonFactory.replaceControlName(controle,
          false, appCfg.main.controleCfg);
        let htmlValue = '';
        if (typeof ancAppAndroid !== 'undefined') {
          htmlValue =
            '<span class="listeDossierCtrlType" ng-click="actionFromDatatable({fn:\'openAncControle\',data:{dossierId: \'' +
            dossier.id +
            '\'}})">' +
            controlName +
            ' ' +
            '</span>';
        } else {
          htmlValue =
            '<span class="listeDossierCtrlType" ng-click="actionFromDatatable({fn:\'openAncControle\',data:{dossierId: \'' +
            dossier.id +
            "', controleId: '" +
            dossier.properties.dernierControle.id +
            '\'}})">' +
            controlName +
            ' ' +
            '</span>';
        }
        let agent = '';
        if (
          gaJsUtils.checkNestedProperty(
            'properties.dernierControle.agent',
            dossier
          )
        ) {
          agent = '<span class="text-muted"><i class="fa fa-user"></i><small> '
            + (dossier.properties.dernierControle.agent || '')
            + '</small></span></span>';
        }

        return (notHtml
          ? CommonFactory.findControlTypeLabel(controle, appCfg.main.controleCfg)
          + ' ' + (dossier.properties.dernierControle.agent || '')
          : $sce.trustAsHtml(htmlValue + ' ' + agent));
      };

      const date_prochain_controle_preconise = (
        crudValue,
        dossier,
        notHtml
      ) => {
        let value = crudValue;


        let newValueToDetermine ='<div class="tableTdWrapperPickDate"><span class="spanEtatDossierDate spanEtatDossierNoDatePreconisee '
          + ' datePrecoDatePicker"><div class="spanEtatDosssierDate-inner"> '
          + '<i class="fa fa-edit"></i> <input title="Cliquer pour'
          + ' éditer" type="text"  ng-model="obj.properties[att.name]"'
          + ' data-autoclose="1" name="date" date-type="string" data-date-format="dd/MM/yyyy" model-date-format="yyyy-MM-ddTHH:mm:ss.sssZ" autocomplete="off"'
          + ' ng-change="actionFromDatatable({fn:\'updateDatePreconiseeAnc\',data:{obj: obj}})" bs-datepicker>'
          + '</div></span>'
          + '</div>';

          newValueToDetermine = $sce.trustAsHtml(newValueToDetermine);

        if (value) {
          value = new Date(value);
          let today = new Date();
          let ndays = Math.round(
            (value.valueOf() - today.valueOf()) / 1000 / 86400 - 0.5
          );
          value = $filter('date')(value, 'dd-MM-yyyy');
          let _xclass;
          if (ndays < 0) {
            _xclass = 'spanEtatDossierAlert';
          } else if (ndays < 30 && ndays >= 0) {
            _xclass = 'spanEtatDossierWarning';
          } else {
            _xclass = 'spanEtatDossierValid';
          }
          value = notHtml
            ? value
            : '<div class="tableTdWrapperPickDate"><span class="spanEtatDossierDate '
            + _xclass
            + ' datePrecoDatePicker"><div class="spanEtatDosssierDate-inner"> '
            + '<i class="fa fa-edit"></i> <input title="Cliquer pour'
            + ' éditer" type="text"  ng-model="obj.properties[att.name]"'
            + ' data-autoclose="1" name="date" data-type="date"'
            + ' ng-change="actionFromDatatable({fn:\'updateDatePreconiseeAnc\',data:{obj: obj}})" bs-datepicker>'
            + '</div></span>'
            + '</div>';

          value = $sce.trustAsHtml(value);
        }
        return value || newValueToDetermine;
      };

      const date_raccordement = (dateRaccordement, notHtml) => {
        let value = dateRaccordement;

        if (value) {
          value = $filter('date')(new Date(value), 'dd-MM-yyyy');

          value = notHtml
            ? value
            : $sce.trustAsHtml(
              '<div class="tableTdWrapper"><span class="spanEtatDossier dateRaccordementDatePicker">'
              + '<i class="fa fa-edit"></i> <input title="Cliquer pour éditer" type="text"  ng-model="obj.properties[att.name]" data-autoclose="1" name="date" data-type="date" ng-change="actionFromDatatable({fn:\'updateDateRaccordementAnc\',data:{obj: obj}})" bs-datepicker>'
              + '</span>'
              + '</div>'
            );
        }
        return value;
      };

      return {
        attributes: dossierAttributes,
        attributes_raccordes: dossierAttributesRaccordes,
        renduTitleColonneDossier: {
          avis_dernier_controle: (v, notHtml)=> {
            if (notHtml){
              return 'Avis/Statut';
            } else {
              const str = '<span>Avis/Statut</span>';
              return v ? $sce.trustAsHtml(str) : v;
            }
          },
          serviceControle: (v)=> {
            return v ? $sce.trustAsHtml('Service du contrôle') : v;
          },
          date_dernier_controle: (v)=> {
            return v ? $sce.trustAsHtml('Date du contrôle') : v;
          },
          volumeFiliere: (v)=> {
            return v ? $sce.trustAsHtml('Volume de la filière') : v;
          },
          numRueProprietaire: (v)=> {
            return v ? $sce.trustAsHtml('N° rue propriétaire') : v;
          },
          rueProprietaire: (v)=> {
            return v ? $sce.trustAsHtml('Rue') : v;
          },
          villeProprietaire: (v)=> {
            return v ? $sce.trustAsHtml('Ville') : v;
          },
          cpProprietaire: (v)=> {
            return v ? $sce.trustAsHtml('CP') : v;
          },
          paysProprietaire: (v)=> {
            return v ? $sce.trustAsHtml('Pays') : v;
          },
          adresse_cp: (v)=> {
            return 'CP';
          },
          adresse_num_rue: (v)=> {
            return 'N° rue';
          },
          date_prochain_controle: (v)=> {
            return v ? $sce.trustAsHtml('Date de rendez-vous') : v;
          },
          date_prochain_controle_preconise: (v)=> {
            return v ? $sce.trustAsHtml('Date préconisée') : v;
          },
        },
        renduColonnesEtatDossier: {
          alerte: (crudValue, dossier, notHtml) => CommonFactory.tableAlert(crudValue, dossier, notHtml, appCfg.main.dossierCfg.alerte),
          etat_dossier: CommonFactory.tableStatus,
          adresse_num_rue: CommonFactory.tableAddressNumber,
          affectation_construction: CommonFactory.affectationConstruction,
          prochain_controle: tableNextControlNameAndAgentANC,
          type_dernier_controle: tableControlAndAgentForLastControlANC,
          avis_dernier_controle: CommonFactory.lastControlAvis,
          serviceControle: CommonFactory.controlServiceName,
          numRueProprietaire: CommonFactory.numRueProprietaire,
          villeProprietaire: CommonFactory.villeProprietaire,
          paysProprietaire: CommonFactory.paysProprietaire,
          rueProprietaire: CommonFactory.rueProprietaire,
          cpProprietaire: CommonFactory.cpProprietaire,
          typeProprietaire: CommonFactory.typeProprietaire,
          volumeFiliere: CommonFactory.volumeFiliere,
          date_prochain_controle: CommonFactory.date_prochain_controle,
          date_dernier_controle: CommonFactory.date_dernier_controle,
          date_prochain_controle_preconise: date_prochain_controle_preconise,
          date_raccordement: date_raccordement,
        },
        filterRender: getFilterRender(
          copyAvisCtrl,
          controle_filter,
          liste_ville_filter,
          liste_volume_filter,
          liste_type_proprio_filter,
          controleFilterProchain
        ),
        extraFilterRender: {
          type_dernier_controle: {
            liste: agentsPortail,
            key: 'agent_dernier_controle',
          },
          alerte: {
            key: 'alerte_search',
            type: 'string_search',
            symbol: '',
          },
          prochain_controle: {
            liste: agentsPortail,
            key: 'agent_rdv',
          },
        },
        editButton: [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: 'Editer le dossier',
            },
          },
        ],
      };
    };

    const getAlerteColorClass = (dateEcheance) => CommonFactory.getAlerteColorClass(dateEcheance, appCfg.main.dossierCfg.alerte);

    /**
     * Function: debloquetournee
     */
    function debloqueDossier(id) {
      var promise = $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/debloqueDossier?f=json&id=' +
          id
      );
      promise.then(
        function(res) {
          // service level logic if any
        },
        function() {}
      );
      return promise;
    }

    /**
     * Function: removecahier
     */
    function removecahier(id_cahier) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.removecahier(id_cahier, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/removeCahier?f=json' +
            '&id_cahier=' +
            id_cahier
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: removecahier
     */
    function getLastControle(idDossier) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getLastControle?f=json' +
          '&idDossier=' +
          idDossier
      );
    }

    /**
     * Function: removecahier
     */
    function getActifsControles(ids) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getActifsControles?f=json' +
          '&ids=' +
          ids
      );
    }

    /**
     * Function: adddossier
     */
    function updateDatesDossier(idControle) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/updateDatesDossier?f=json' +
          '&idControle=' +
          idControle
      );
    }

    /**
     * Function: activatevectoriel
     */
    function activatevectoriel(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/activateVectoriel?f=json',
        senddata
      );
    }

    /**
     * Function: addbiblief
     */
    function addbiblief(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' + appCfg.appname + '/addBibliEf?f=json',
        senddata
      );
    }

    /**
     * Function: getrepresentationfilierejson
     */
    function getrepresentationfilierejson(name) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getRepresentationFiliereJson?f=json' +
          '&name=' +
          name
      );
    }

    /**
     * Function: addrepresentationfilierejson
     */
    function addrepresentationfilierejson(senddata, name) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/addRepresentationFiliereJson?f=json' +
          '&name=' +
          name,
        senddata
      );
    }

    /**
     * Function: addvidangedetail
     */
    function addvidangedetail(senddata, dossiers, vidange) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addVidangeDetail(
          JSON.stringify(senddata),
          dossiers,
          vidange,
          int
        );
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addVidangeDetail?f=json' +
            '&dossiers=' +
            dossiers +
            '&vidange=' +
            vidange +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || ''),
          senddata
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: removeformvidange
     */
    function removeformvidange(dossier, vidange) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.removeFormVidange(vidange, dossier, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/removeFormVidange?f=json&dossier=' +
            dossier +
            '&vidange=' +
            vidange +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '')
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: addformvidange
     */
    function addformvidange(ref_dossier, identifiant) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addFormVidange(ref_dossier, identifiant, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addFormVidange?f=json' +
            '&ref_dossier=' +
            ref_dossier +
            '&identifiant=' +
            identifiant +
            ''
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: getvidanges
     */
    function getvidanges(dossier) {
      /**/
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getControles(dossier, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getVidanges?f=json&dossier=' +
            dossier
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: getvidangedetail
     */
    function getvidangedetail(dossier, vidange) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.getVidangeDetail(dossier, vidange, '', int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/getVidangeDetail?f=json&dossier=' +
            dossier +
            '&vidange=' +
            vidange +
            '&bacapp=' +
            (BacAppFactory.appCfg.appname || '')
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: getdossier_villes
     */
    function indexDossierExists(id_dossier) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/indexDossierExists?f=json&id_dossier=' +
          id_dossier
      );
    }

    /**
     * Function: getEtatAllIndexByType
     */
    function getEtatAllIndexByType() {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/etatIndexationGeneral?f=json'
      );
    }

    /**
     * Function: setusertimeout
     */
    function setusertimeout(id, user) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/setUserTimeOut?f=json' +
          '&id=' +
          id +
          '&user=' +
          user
      );
    }

    /**
     * Function: setrepresentationcanavectorielle
     */
    function setrepresentationcanavectorielle(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/setRepresentationCanaVectorielle?f=json',
        senddata
      );
    }

    /**
     * Function: checkrestrictiononcomponent
     */
    function checkrestrictiononcomponent(componentName, attributeName) {
      return $http.get(
        '/services/{portalid}/ancapp/{appname}/checkRestrictionOnComponent?f=json' +
          '&componentName=' +
          componentName +
          '&attributeName=' +
          attributeName
      );
    }

    /**
     * Function: updaterestrictionvalueoncomponent
     */
    function updaterestrictionvalueoncomponent(
      componentName,
      attributeName,
      valueId,
      newId
    ) {
      return $http.get(
        '/services/{portalid}/ancapp/{appname}/updateRestrictionValueOnComponent?f=json' +
          '&componentName=' +
          componentName +
          '&attributeName=' +
          attributeName +
          '&valueId=' +
          valueId +
          '&newId=' +
          newId
      );
    }
    
   /**
     * Function: setNullGeomElementfiliere
     */
    function setNullGeomElementfiliere(id_element_filiere, nom_table_element_filiere) {
      var promise = $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/setNullGeomElementfiliere?f=json' +
          '&nom_table_element_filiere=' +
          nom_table_element_filiere +
          '&id_element_filiere=' +
          id_element_filiere
      );
      return promise;
    }


    /**
     * Function: getinstalltabdetail
     */
    function getinstalltabdetail(id_filiere) {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getInstallTabDetail?f=json' +
          '&id_filiere=' +
          id_filiere
      );
    }
    /**
     * Function: addSubventionDossier
     */
    function addSubventionDossier(ref_dossier, date) {
      if (typeof ancAppAndroid !== 'undefined') {
        //to do
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.addSubventionDossier(ref_dossier, identifiant, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/addSubventionDossier?f=json' +
            '&ref_dossier=' +
            ref_dossier +
            '&date=' +
            date +
            ''
        );
        return promise;
      }
    }

    /**
     * Function: removeSubvention
     */
    function removeSubvention(dossier, subvention) {
      if (typeof ancAppAndroid !== 'undefined') {
        // to do
        var defer = $q.defer();
        var int = createDefer(defer);
        ancAppAndroid.removeSubvention(vidange, dossier, int);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/removeSubvention?f=json&dossier=' +
            dossier +
            '&subvention=' +
            subvention
        );
        return promise;
      }
    }
    /**
     * Function: updateSubvention
     */
    function updateSubvention(senddata) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        //to do mobilite
        ancAppAndroid.updateSubvention(JSON.stringify(senddata), int);
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/ancapp/' +
            appCfg.appname +
            '/updateSubvention?f=json',
          senddata
        );
        return promise;
      }
    }
    

    /**
     * Arreter la facturation des controles dans le mm dossier , suite à la création
     * d'un nouveau
     * 
     * @param {*} senddata
     * @returns
     */
    function updateControlesArreterFacturationAnnuelle(senddata) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/updateControlesArreterFacturationAnnuelle?f=json',
        senddata
      );
    }

    /**
     * Function: reinitialiser la Configuration des Symboles
     */
     const reinitialiserConfigurationSymboles = () => {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/reinitialiserConfigurationSymboles?f=json'
      );
    };

    /**
     * Function: Récupération des données de la facturation annuelle pour un dossier
     */
    function getControlesFacturationAnnuelleData(idDossier) {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
          '/getControlesFacturationAnnuelleData?f=json&idDossier=' +
          idDossier
      );
    }
    /**
     * Function: Supprimer une écheance de la facturation annuelle
     */
     const removeLinkWithAnnualInvoice = (controleFactureAnnuelle , idDossier) => {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
            '/removeLinkWithAnnualInvoice?f=json&idDossier=' +
            idDossier +
            '&referenceControle=' +
            controleFactureAnnuelle.referenceControle +
            '&numeroEcheance=' +
            controleFactureAnnuelle.numeroEcheance 
      );
    }
     /**
     * Function: recherche des ctrls facturables
     */
     const getControleFacturableAvecFacturationAnnuelle = () => {
        return $http.post(
            '/services/{portalid}/ancapp/' +
              appCfg.appname +
                '/getControleFacturableAvecFacturationAnnuelle?f=json'
        );
      }
    const addNewCommuneToData = (data, newCommune) => {
      data.infosSpancListeVillesCfg.push(newCommune);
      return data;
    };
    /**
     * Function : get the id of the last personne added
     */
    const getIdLastPersonneAdded = (adresse_pays, nom, civilite, adresse_cp, adresse_rue, adresse_ville,prenom) => {
      return  $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
            '/getIdLastPersonneAdded?f=json'
          + '&adresse_pays='+ encodeURIComponent(adresse_pays) 
          + '&nom=' + encodeURIComponent(nom) 
          + '&civilite=' + encodeURIComponent(civilite) 
          + '&adresse_cp=' + encodeURIComponent(adresse_cp)
          + '&adresse_rue=' + encodeURIComponent(adresse_rue) 
          + '&adresse_ville=' + encodeURIComponent(adresse_ville) 
          + '&prenom=' + encodeURIComponent(prenom)
      ).catch(
          (error) => {
            if (error.data && typeof error.data === 'string') {
              console.error(error.data);
            }
          }
      );
    };

  /**
    * Function : check if the new personne is already in the database
  */
      const checkIfPersonneAlreadyInTheDatabase = (id_tiers_omega) => {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
            '/checkIfPersonneAlreadyInTheDatabase?f=json&id_tiers_omega=' + id_tiers_omega
      ); 
    }
    /**
     * Function: getPeronneId
    */
    const getPersonneId = (id_tiers_omega) => {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
            '/getPersonneId?f=json&id_tiers_omega=' + id_tiers_omega
      ); 
    }

    /**
     * Function: getIdCurrentPersonneCourant
    */
     const getIdCurrentPersonneCourant = (idDossier,type) => {
      return $http.post(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
            '/getIdCurrentPersonneCourant?f=json&idDossier=' + idDossier + '&type=' + type
      ); 
    }
    /**
     * Get infos locataires or proprietaire
     */
    const getInfosLocataireOrProprio = (idDossier, idPersonne, typePersonne) => {
      return $http.get(
        '/services/{portalid}/ancapp/' +
          appCfg.appname +
            '/getInfosLocataireOrProprio?f=json&idDossier=' + idDossier + '&typePersonne=' + typePersonne + '&idPersonne=' + idPersonne
      ); 
    }

    

    return {
      AncAppFactory: AncAppFactory,
      getdossiers: getdossiers,
      sendResultBackDossiers: sendResultBackDossiers,
      getdossier: getdossier,
      getdossier_villes: getdossier_villes,
      callExternalApi: callExternalApi,
      parseResultFromExternalApi: parseResultFromExternalApi,
      initdatabase: initdatabase,
      checkancappdata: checkancappdata,
      adddossier: adddossier,
      updatedossier: updatedossier,
      getpersonnes: getpersonnes,
      getpersonne: getpersonne,
      addpersonne: addpersonne,
      updatepersonne: updatepersonne,
      getparcelles: getparcelles,
      getparcelle: getparcelle,
      addparcelle: addparcelle,
      updateparcelle: updateparcelle,
      checkparcellealreadyused: checkparcellealreadyused,
      addpersonnetodossier: addpersonnetodossier,
      removepersonneencoursfromdossier: removepersonneencoursfromdossier,
      getancpersonne: getancpersonne,
      gethistopersonnesdossier: gethistopersonnesdossier,
      addparcelletodossier: addparcelletodossier,
      removeparcellefromdossier: removeparcellefromdossier,
      updatestatutdossiers: updatestatutdossiers,
      getdossierbycontroleid: getdossierbycontroleid,
      getcontroledetailexterne: getcontroledetailexterne,
      changeControleExterneDetail: changeControleExterneDetail,
      activecontroledetailexterne: activecontroledetailexterne,
      updateOrCreatePersonneOmega: updateOrCreatePersonneOmega,
      updateHistoriquePersonnesOmega: updateHistoriquePersonnesOmega,
      ancDossierToDossier: ancDossierToDossier,

      /* filieres */
      addfiliere: addfiliere,
      getFiliere: getFiliere,
      addFiliereByid: addFiliereByid,
      getElementFiliereData: getElementFiliereData,
      addelementtofiliere: addelementtofiliere,
      updateelementfiliere: updateelementfiliere,
      removeelementfromfiliere: removeelementfromfiliere,
      resetfiliere: resetfiliere,
      setListeElementsFiliere: setListeElementsFiliere,
      sortElementsFiliere: sortElementsFiliere,
      copyselectedfiliere: copyselectedfiliere,
      getElementsFiliereTemplates: getElementsFiliereTemplates,
      checkrestrictiononcomponent: checkrestrictiononcomponent,
      updaterestrictionvalueoncomponent: updaterestrictionvalueoncomponent,
      setNullGeomElementfiliere:setNullGeomElementfiliere,

      /* cahier de vie */
      addcahierdevie: addcahierdevie,
      removecahier: removecahier,
      /* controles */
      getcontroles: getcontroles,
      removecontrole: removecontrole,
      addcontrole: addcontrole,
      updatecontrole: updatecontrole,
      addcontroledetail: addcontroledetail,
      getcontroledetail: getcontroledetail,
      getCtrlFormCfg: getCtrlFormCfg,
      getAllCtrlFormCfg: getAllCtrlFormCfg,
      getNewControleData: getNewControleData,
      getinstalltabdetail: getinstalltabdetail,
      /* vidanges */
      getvidangesdossier: getvidangesdossier,
      addvidangetoelementfiliere: addvidangetoelementfiliere,
      removevidangefromelementfiliere: removevidangefromelementfiliere,
      updatevidangeelementfiliere: updatevidangeelementfiliere,
      /* factures */
      generatefacturesdolibarr: generatefacturesdolibarr,
      getmontantfactures: getmontantfactures,
      changestatutfactures: changestatutfactures,
      imprimerfactures: imprimerfactures,
      /* factures dolibarr */
      synchropersonnesdolibarr: synchropersonnesdolibarr,
      getlisteexportsjvs: getlisteexportsjvs,
      /* docs */
      uploaddashboarddoc: uploaddashboarddoc,
      removedashboarddoc: removedashboarddoc,
      listdashboarddocs: listdashboarddocs,
      downloaddashboarddoc: downloaddashboarddoc,
      generatereport: generatereport,
      getreportpdf: getreportpdf,
      /* cfg */
      appCfg: appCfg,
      getAppCfg: getAppCfg,
      updateAppCfg: updateAppCfg,
      updateCanalGeoServerStyle: updateCanalGeoServerStyle,
      updateElementFiliereAppCfg: updateElementFiliereAppCfg,
      /* misc */
      getControleName: getControleName,
      getNumeroAuto: getNumeroAuto,
      base64topng: base64topng,
      getZipDocumentsTypes: getZipDocumentsTypes,
      updatepersonhistory: updatepersonhistory,
      /** extract html * */
      extractModelFromForm: extractModelFromForm,
      getngincludeduhtml: getngincludeduhtml,
      htmlformtojson: htmlformtojson,
      create_controle_json_mapping_file: create_controle_json_mapping_file,
      getControlesHTML: getControlesHTML,
      getextractedjsondata: getextractedjsondata,
      getextractedjsondataurl: getextractedjsondataurl,
      /** reglementaire * */
      refreshnationalreglementaire: refreshnationalreglementaire,
      getreglementaire: getreglementaire,
      addreglementaire: addreglementaire,
      removereglementaire: removereglementaire,
      /** recherche * */
      setindexation: setindexation,
      indexcontroles: indexcontroles,
      getfacturespdf: getfacturespdf,
      getPanancCfg: getPanancCfg,
      getStandardCfg: getStandardCfg,
      /* mobile */
      htmlformtoangular2: htmlformtoangular2,
      getmobileforms: getmobileforms,
      addtournee: addtournee,
      getqrcodetournee: getqrcodetournee,
      gettournee: gettournee,
      getMobileTournee: getMobileTournee,
      getMobileTourneeProgression: getMobileTourneeProgression,
      gettournees: gettournees,
      getAllTournees: getAllTournees,
      synchrotournee: synchrotournee,
      synchroTourneeProgression: synchroTourneeProgression,
      removetournee: removetournee,
      debloquetournee: debloquetournee,
      initappCfg: initappCfg,
      buildFakeCtrlReponseFtiForElasticSearch: buildFakeCtrlReponseFtiForElasticSearch,
      getBuildedFakeCtrlReponseFtiForElasticSearch: getBuildedFakeCtrlReponseFtiForElasticSearch,
      dataResultAndroid: dataResultAndroid,
      getDossiersTournee: getDossiersTournee,
      // divers
      getListeDossiersCfg: getListeDossiersCfg,
      getLastControle: getLastControle,
      getActifsControles: getActifsControles,
      updateDatesDossier: updateDatesDossier,
      getChoixStatutRDV: getChoixStatutRDV,
      debloqueDossier: debloqueDossier,
      // formulaire vidange
      removeformvidange: removeformvidange,
      getvidanges: getvidanges,
      addformvidange: addformvidange,
      getvidangedetail: getvidangedetail,
      addvidangedetail: addvidangedetail,
      setusertimeout: setusertimeout,
      indexDossierExists: indexDossierExists,
      getEtatAllIndexByType: getEtatAllIndexByType,

      // activation des elements de filiere vectoriel
      activatevectoriel: activatevectoriel,
      addbiblief: addbiblief,
      getrepresentationfilierejson: getrepresentationfilierejson,
      addrepresentationfilierejson: addrepresentationfilierejson,
      setrepresentationcanavectorielle: setrepresentationcanavectorielle,
      reinitialiserConfigurationSymboles:reinitialiserConfigurationSymboles,
      //subvention dossier
      addSubventionDossier: addSubventionDossier,
      removeSubvention: removeSubvention,
      updateSubvention: updateSubvention,
      addNewCommuneToData: addNewCommuneToData,
      getAlerteColorClass: getAlerteColorClass,
      //Annualisation Facturation 
      updateControlesArreterFacturationAnnuelle :updateControlesArreterFacturationAnnuelle,
      getControlesFacturationAnnuelleData : getControlesFacturationAnnuelleData,
      removeLinkWithAnnualInvoice : removeLinkWithAnnualInvoice,
      getControleFacturableAvecFacturationAnnuelle:getControleFacturableAvecFacturationAnnuelle,
      //Gestion Services checks:
      getAppCfgServicesChecksExecuteOrNot:getAppCfgServicesChecksExecuteOrNot,
      majAppCfgServicesChecks:majAppCfgServicesChecks,
      createJsonbFieldInTableControle: createJsonbFieldInTableControle,
      getIdLastPersonneAdded: getIdLastPersonneAdded,
      correctInfosDossier: correctInfosDossier,
      checkIfPersonneAlreadyInTheDatabase:checkIfPersonneAlreadyInTheDatabase,
      getPersonneId:getPersonneId,
      getIdCurrentPersonneCourant:getIdCurrentPersonneCourant,
      getInfosLocataireOrProprio: getInfosLocataireOrProprio
    };
  };
  AncAppFactory.$inject = [
    '$http',
    '$location',
    'ConfigFactory',
    '$q',
    'FeatureTypeFactory',
    'gaUrlUtils',
    '$rootScope',
    'QueryFactory',
    '$filter',
    'gaDomUtils',
    'BacAppFactory',
    'gaJsUtils',
    '$sce',
    'UsersFactory',
    'CommonFactory',
    'PortalsFactory'
  ];
  return AncAppFactory;
});
