'use strict';
define(function() {
  var representationFiliere = function(
    QueryFactory,
    FeatureTypeFactory,
    EditFactory,
    gaDomUtils,
    $timeout,
    ConfigFactory,
    AncAppFactory,
    $rootScope,
    $q,
    gcWMS,
    ngDialog,
    $interval
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/representation_filiere_mobile.html',
      restrict: 'EA',
      scope: {
        filiere: '=',
        elements: '=',
        positionDossier: '=?',
        displayLayers: '=?', // array of fti to display
        hasFiliereGeometry: '=?',
      },
      link: function(scope, elt) {
        // init
        scope.configCanas = angular.copy(
          AncAppFactory.appCfg.main.properties.configCanas
        );
        var sortConfigCanas = {};
        if (angular.isDefined(scope.configCanas) && scope.configCanas.liste) {
          scope.configCanas.liste.map(function(x) {
            sortConfigCanas[x.lib] = x.color;
          });
        }

        if (typeof AppAndroid !== 'undefined') scope.AppAndroid = AppAndroid;

        scope.isSlidable = false;

        // -----------------------------------------------
        // MOUSE / PROJECTION
        // -----------------------------------------------
        var mousePositionControl = new ol.control.MousePosition({
          coordinateFormat: ol.coordinate.createStringXY(4),
          projection: 'EPSG:3857',
          className: 'custom-mouse-position',
          target: document.getElementById('mouse-position'),
          undefinedHTML: '&nbsp;',
        });

        var projectionSelect = document.getElementById('projection');
        if (projectionSelect)
          projectionSelect.addEventListener('change', function(event) {
            mousePositionControl.setProjection(ol.proj.get(event.target.value));
          });

        // -----------------------------------------------
        // SOURCES
        // -----------------------------------------------

        var sourceDessin = new ol.source.Vector({ wrapX: false });
        //LAYER DU DESSIN AVEC UN STYLE
        var layerDessin = new ol.layer.Vector({
          source: sourceDessin,
          style: new ol.style.Style({
            fill: new ol.style.Fill({
              color: 'rgba(255, 255, 255, 0.2)',
            }),
            stroke: new ol.style.Stroke({
              color: 'yellow',
              width: 2,
            }),
            image: new ol.style.Circle({
              radius: 2,
              fill: new ol.style.Fill({
                color: 'yellow',
              }),
            }),
          }),
        });

        var draw,
          modify,
          // filiere fti
          filiereFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_dossier_filiere'
          ),
          formatter = new ol.format.GeoJSON(),
          // default draw style
          drawStyle = new ol.style.Style({
            fill: new ol.style.Fill({
              color: 'rgba(255, 255, 255, 0.5)',
            }),
            stroke: new ol.style.Stroke({
              color: '#3498db',
              width: 2,
            }),
            image: new ol.style.Circle({
              radius: 7,
              fill: new ol.style.Fill({
                color: '#3498db',
              }),
            }),
          }),
          // filiere
          filiereStyle = new ol.style.Style({
            image: new ol.style.Icon({
              src: 'img/common/map_directive_picker.png',
            }),
            text: new ol.style.Text({
              textAlign: 'center',
              textBaseline: 'middle',
              font: 'Normal 12px Arial',
              text: '',
              fill: new ol.style.Fill({
                color: '#000000',
              }),
              stroke: new ol.style.Stroke({
                color: '#FFFFFF',
                width: 2,
              }),
              offsetY: 20,
            }),
          }),
          displayStyle = new ol.style.Style({
            fill: new ol.style.Fill({
              color: 'rgba(255, 255, 255, 0.5)',
            }),
            stroke: new ol.style.Stroke({
              color: '#16a085',
              width: 2,
            }),
            image: new ol.style.Circle({
              radius: 7,
              fill: new ol.style.Fill({
                color: '#16a085',
              }),
            }),
            text: new ol.style.Text({
              textAlign: 'center',
              textBaseline: 'middle',
              font: 'Normal 12px Arial',
              text: '',
              fill: new ol.style.Fill({
                color: '#000000',
              }),
              stroke: new ol.style.Stroke({
                color: '#FFFFFF',
                width: 2,
              }),
              offsetY: 20,
            }),
          });

        /**
         * return elementFiliereStyle
         * @param img
         */
        var getElementFiliereStyle = function(img) {
          var scale = 1;
          // svg fix size
          if (~img.indexOf('.svg')) scale = 0.05;

          if (typeof AppAndroid !== 'undefined')
            return new ol.style.Style({
              image: new ol.style.Icon({
                src: img.replace(
                  '/geoserver/styles/kis/common/images/',
                  'img/'
                ),
                scale: scale,
              }),
              text: new ol.style.Text({
                textAlign: 'center',
                textBaseline: 'middle',
                font: 'Normal 12px Arial',
                text: '',
                fill: new ol.style.Fill({
                  color: '#000000',
                }),
                stroke: new ol.style.Stroke({
                  color: '#FFFFFF',
                  width: 2,
                }),
                offsetY: 20,
              }),
            });
          else
            return new ol.style.Style({
              image: new ol.style.Icon({
                src: img,
                scale: scale,
              }),
              text: new ol.style.Text({
                textAlign: 'center',
                textBaseline: 'middle',
                font: 'Normal 12px Arial',
                text: '',
                fill: new ol.style.Fill({
                  color: '#000000',
                }),
                stroke: new ol.style.Stroke({
                  color: '#FFFFFF',
                  width: 2,
                }),
                offsetY: 20,
              }),
            });
        };

        // actual geometries layer
        var elementsSource = new ol.source.Vector();
        var elementsLayer = new ol.layer.Vector({
          source: elementsSource,
          style: displayStyle,
        });

        // feature collection used to draw new geometries
        var features = new ol.Collection();

        var collection = new ol.Collection();
        var featureOverlay = new ol.layer.Vector({
          map: map,
          source: new ol.source.Vector({
            features: collection,
            useSpatialIndex: false, // optional, might improve performance
          }),
          style: drawStyle,
          updateWhileAnimating: true, // optional, for instant visual feedback
          updateWhileInteracting: true, // optional, for instant visual feedback
        });

        // -----------------------------------------------
        // MAP INIT
        // -----------------------------------------------
        var map = new ol.Map({
            controls: ol.control
              .defaults({
                attribution: false,
                attributionOptions: { collapsible: false },
              })
              .extend([
                mousePositionControl,
                new ol.control.ScaleLine({
                  className: 'ol-scale-line',
                  target: document.getElementById('scale-line'),
                }),
              ]),
            layers: [elementsLayer, layerDessin],
            target: 'rf_map',
            view: new ol.View({
              projection: 'EPSG:3857',
              center: [213606.73842054035, 5869644.498443234],
              minResolution: 0.03732276771737122,
              zoom: 6,
            }),
          }),
          // retrieve srid
          srid = map
            .getView()
            .getProjection()
            .getCode();

        var OSMLayer = new ol.layer.Tile({
          source: new ol.source.OSM(),
        });
        if (typeof AppAndroid === 'undefined')
          map.getLayers().insertAt(0, OSMLayer);

        /* if (angular.isDefined(scope.displayLayers)) {
                 console.log(scope.displayLayers);
                 scope.displayLayers.forEach(function (f) {
                 var l = gcWMS.getOlLayerFromFeaturetypeInfo(f);
                 map.addLayer(l);
                 });
                 }*/

        if (
          angular.isDefined(scope.positionDossier) &&
          scope.positionDossier != null
        ) {
          if (typeof scope.positionDossier === 'string')
            scope.positionDossier = JSON.parse(scope.positionDossier);

          var posDossier = angular.copy(scope.positionDossier);
          if (typeof posDossier == 'string')
            posDossier = JSON.parse(posDossier);

          var dossierCoords = angular.copy(posDossier.coordinates);

          //if(angular.isDefined(dossierCoords) && angular.isArray(dossierCoords[0])) dossierCoords = dossierCoords[0];

          // rajoute icon dossier
          var iconFeature = new ol.Feature({
              geometry: new ol.geom.MultiPoint(dossierCoords),
              population: 4000,
              rainfall: 500,
            }),
            iconStyle = new ol.style.Style({
              image: new ol.style.Icon({
                src: 'img/anc/dossier.png',
                scale: 1,
              }),
            });

          iconFeature.setStyle(iconStyle);

          var positionVectorLayer = new ol.layer.Vector({
            source: new ol.source.Vector({
              features: [iconFeature],
            }),
          });

          map.addLayer(positionVectorLayer);

          var center = angular.copy(dossierCoords);
          if (scope.positionDossier.type === 'MultiPoint') {
            map.getView().setCenter(center[0]);
          } else {
            map.getView().setCenter(center);
          }

          map.getView().setZoom(18);
        } else {
          if (
            angular.isDefined(AncAppFactory.appCfg.main.mapConfiguration.bbox)
          ) {
            map
              .getView()
              .fit(
                AncAppFactory.appCfg.main.mapConfiguration.bbox,
                map.getSize()
              );
          }
        }

        featureOverlay.setMap(map);

        // -----------------------------------------------
        // LOGIC
        // -----------------------------------------------

        /**
         * getFeatureStyle
         * @param id
         * @returns ol.style
         */

        var getFeatureStyle = function(feature) {
          var id = feature.getId();
          var tmp = id.split('.');
          var style = displayStyle;

          var foundFeature,
            img_url,
            displayName = '';

          for (var category in scope.displayElements) {
            if (scope.displayElements[category].length) {
              scope.displayElements[category].forEach(function(e) {
                if (e.feature.id == id) {
                  foundFeature = e;
                  /* if (foundFeature.nom == 'Canalisations') {
                                     foundFeature.nom =  e.feature.id.split('_')[2];
                                     }*/

                  console.log(foundFeature);
                  console.log(id);

                  if (foundFeature.typeInfo == 'Annotation') {
                    if (e.feature.properties && e.feature.properties.label)
                      displayName = e.feature.properties.label;
                  }

                  if (foundFeature.typeInfo == 'Image') {
                    displayName = foundFeature.nom;
                    img_url = e.feature.properties.url;
                  }

                  if (id.indexOf('Canalisation_cotation') == 0) {
                    if (e.feature.properties && e.feature.properties.label)
                      displayName = e.feature.properties.label;
                  }

                  if (e.feature.properties && e.feature.properties.url) {
                    img_url = e.feature.properties.url;
                  }
                }
              });
            }
          }

          if (id.indexOf('Canalisation') == 0) {
            var color = sortConfigCanas[foundFeature.feature.properties.type];

            var tuyauxStyle = new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: color,
                width: 2,
              }),
              text: new ol.style.Text({
                textAlign: 'center',
                textBaseline: 'middle',
                font: 'Normal 12px Arial',
                text: foundFeature.feature.properties.type,
                fill: new ol.style.Fill({
                  color: '#000000',
                }),
                stroke: new ol.style.Stroke({
                  color: '#FFFFFF',
                  width: 2,
                }),
                offsetY: 20,
              }),
            });

            if (id.indexOf('Canalisation_cotation') == 0) {
              tuyauxStyle = new ol.style.Style({
                fill: new ol.style.Fill({
                  color: 'rgba(255, 255, 255, 0.2)',
                }),
                stroke: new ol.style.Stroke({
                  color: 'rgba(0, 0, 0, 0.5)',
                  lineDash: [10, 10],
                  width: 2,
                }),
                text: new ol.style.Text({
                  textAlign: 'center',
                  textBaseline: 'middle',
                  font: 'Normal 12px Arial',
                  text: displayName,
                  fill: new ol.style.Fill({
                    color: '#000000',
                  }),
                  stroke: new ol.style.Stroke({
                    color: '#FFFFFF',
                    width: 2,
                  }),
                  offsetY: 20,
                }),
              });
            }

            style = tuyauxStyle;
          } else if (id.indexOf('Annotation') == 0) {
            var AnnotationStyle = new ol.style.Style({
              fill: new ol.style.Fill({
                color: 'rgba(255, 255, 255, 0.5)',
              }),
              stroke: new ol.style.Stroke({
                color: '#16a085',
                width: 2,
              }),
              image: new ol.style.Circle({
                radius: 3,
                fill: new ol.style.Fill({
                  color: 'red',
                }),
              }),
              text: new ol.style.Text({
                textAlign: 'center',
                textBaseline: 'middle',
                font: 'Normal 16px Arial bold',
                text: displayName,
                fill: new ol.style.Fill({
                  color: '#000000',
                }),
                stroke: new ol.style.Stroke({
                  color: '#FFFFFF',
                  width: 6,
                }),
                scale: 0.8,
                offsetY: 15,
              }),
            });
            style = AnnotationStyle;
          } else if (~id.indexOf('kis_anc_dossier_filiere')) {
            if (styleFeatures) {
              var img = filiereStyle.getImage();
              var keys = Object.keys(styleFeatures);
              keys.forEach(function(key) {
                if (key == id) {
                  img.setScale(Math.abs(styleFeatures[key].scale));
                  img.setRotation(styleFeatures[key].rotate * (Math.PI / 180));
                }
              });
            }

            style = filiereStyle;
          } else if (~id.indexOf('Accessoire')) {
            console.log('ici');
            style = getElementFiliereStyle(img_url);
            console.log(style);
          } else {
            if (
              angular.isDefined(infosStyleElements[tmp[0]]) &&
              infosStyleElements[tmp[0]] != ''
            ) {
              if (img_url && img_url != '') {
                style = getElementFiliereStyle(img_url);
              } else {
                style = getElementFiliereStyle(
                  infosStyleElements[tmp[0]].split(';')[0]
                );
              }

              if (styleFeatures) {
                var img = style.getImage();

                var keys = Object.keys(styleFeatures);
                keys.forEach(function(key) {
                  if (key == id) {
                    img.setScale(Math.abs(styleFeatures[key].scale));
                    img.setRotation(
                      styleFeatures[key].rotate * (Math.PI / 180)
                    );
                  }
                });
              }
            }
          }

          // text layer
          if (style.getText()) {
            if (!foundFeature.nom) foundFeature.nom = '';
            if (
              foundFeature.nom != 'Canalisations' &&
              foundFeature.nom.indexOf('Annotation') != 0 &&
              foundFeature.nom != 'Image'
            ) {
              style.getText().setText(displayName);
            }
          }

          return style;
        };

        /**
         * letsDraw
         * @param type
         * @param element
         */
        function drawFeature(type, element) {
          draw = new ol.interaction.Draw({
            features: features,
            type: type,
            style: drawStyle,
          });
          map.addInteraction(draw);

          map.getLayers().insertAt(9999, elementsLayer);
          map.getLayers().insertAt(9999, layerDessin);

          draw.on('drawend', function(e) {
            console.log(element.feature.id);
            if (element.feature.id.indexOf('Annotation') == 0) {
              scope.openAnnotationDialog(element);
            } else if (
              element.feature.id.indexOf('Canalisation_cotation') == 0
            ) {
              scope.openAnnotationDialog(element);
            } else if (element.feature.id.indexOf('Accessoire') == 0) {
              scope.openImageDialog(element);
            } else {
              if (
                element.feature.id.indexOf('Canalisation') != 0 &&
                element.feature.id.indexOf('kis_anc_dossier_filiere') != 0 &&
                angular.isDefined(infosStyleElements)
              ) {
                var tmp = element.feature.id.split('.');
                if (
                  angular.isDefined(infosStyleElements[tmp[0]]) &&
                  infosStyleElements[tmp[0]] != ''
                ) {
                  var urls = infosStyleElements[tmp[0]].split(';');
                  if (urls.length > 1) {
                    scope.openFiliereRepresentationImagesDialog(element);
                  }
                }
              }
            }

            $timeout(function() {
              // retrieve and format the geometry of the drawn element
              var formatted_drawn_feature = formatter.writeFeatureObject(
                e.feature
              );
              element.feature.geometry = formatted_drawn_feature.geometry;

              e.feature.setId(element.feature.id);
              e.feature.setProperties(element.feature.properties);

              if (styleFeatures) {
                styleFeatures[e.feature.getId()] = {
                  scale: 1,
                  rotate: 0,
                };
              }

              e.feature.setStyle(getFeatureStyle(e.feature));
              elementsSource.addFeature(e.feature);
              console.log(elementsSource);
              map.removeInteraction(draw);
              resetScale();
              scope.currentlyEditedFeature = -1;
              scope.currentEditMode = false;
            });
          });
        }

        /**
         * newFeature
         * @param element
         */
        scope.newFeature = function(element) {
          map.removeInteraction(modify);
          if (
            element &&
            element.feature &&
            element.feature.id &&
            scope.currentlyEditedFeature !== element.feature.id
          )
            scope.currentlyEditedFeature = element.feature.id;
          else if (
            element &&
            element.feature &&
            element.feature.id &&
            scope.currentlyEditedFeature === element.feature.id
          ) {
            scope.currentlyEditedFeature = -1;
            scope.currentEditMode = false;
            map.removeInteraction(draw);
            return;
          } else {
            scope.currentlyEditedFeature = -1;
          }
          scope.currentEditMode = false;

          var currentDrawTypeInfo;
          switch (element.typeInfo) {
            case 'LINE':
              currentDrawTypeInfo = 'LineString';
              break;
            case 'POLYGON':
              currentDrawTypeInfo = 'Polygon';
              break;
            default:
              currentDrawTypeInfo = 'Point';
              break;
          }

          map.removeInteraction(draw);

          drawFeature(currentDrawTypeInfo, element);
        };

        scope.currentlyEditedFeature = -1;
        scope.currentEditMode = false;

        scope.setEditMode = function(mode) {
          if (scope.currentEditMode == mode) {
            scope.currentEditMode = false;
            return false;
          }
          scope.currentEditMode = mode;
        };

        /**
         * editFeature
         * @param element
         */
        scope.editFeature = function(element) {
          scope.goToFeature(element);
          map.removeInteraction(modify);

          if (scope.currentlyEditedFeature == element.feature.id) {
            scope.currentlyEditedFeature = -1;
            scope.currentEditMode = false;
            return;
          }

          var subFeatures = new ol.Collection();
          // modify layer with correct id
          elementsSource.getFeatures().forEach(function(f) {
            if (f.getId() == element.feature.id) {
              subFeatures.push(f);
            }
          });

          modify = new ol.interaction.Modify({
            features: subFeatures,
          });
          scope.currentlyEditedFeature = element.feature.id;

          // alimenter avec styleFeatures[id]

          scope.featureParams = {};

          if (styleFeatures) {
            //   console.log(styleFeatures);
            var keys = Object.keys(styleFeatures);
            keys.forEach(function(key) {
              if (key == element.feature.id) {
                scope.featureParams.rotate = styleFeatures[key].rotate;
                scope.featureParams.scale = -Math.abs(styleFeatures[key].scale);
              }
            });
          } else {
            scope.featureParams = { rotate: 0, scale: -1 };
          }

          map.addInteraction(modify);
        };

        /**
         * reset Scale of image and text
         */
        var resetScale = function() {
          var zoom = map.getView().getZoom();
          var scale = zoom / 10 - 1.4;
          if (scale < 0.2) {
            scale = 0.2;
          }
          elementsSource.getFeatures().forEach(function(f) {
            var style = getFeatureStyle(f);
            var image = style.getImage();
            if (image) {
              //scale of image
              if (zoom >= 21) {
                if (styleFeatures) {
                  if (styleFeatures[f.getId()]) {
                    if (styleFeatures[f.getId()].scale) {
                      image.setScale(Math.abs(styleFeatures[f.getId()].scale));
                    }
                  }
                }
              } else {
                image.setScale(Math.abs(scale));
              }
              //scale of text
              if (scale > 1) {
                if (f.getId().indexOf('Annotation') == 0) {
                  style.getText().setScale(2);
                } else {
                  style.getText().setScale(1);
                }
              } else {
                style.getText().setScale(scale + 0.2);
              }

              if (
                f.getProperties() &&
                f.getProperties().url &&
                ~f.getProperties().url.indexOf('.svg')
              ) {
                image.setScale(0.05);
              }
            } else {
              //Set Canalisations' text scale
              if (scale > 1) scale = 1;
              style.getText().setScale(scale + 0.2);
            }

            if (zoom < 10) {
              style.getText().setScale(0);
            } else if (style.getText()) {
              style.getText().setScale(scope.displayTextStyle ? 1 : 0);
            }

            f.setStyle(style);
            elementsSource.changed();
          });
        };

        // listen zoom changed
        map.getView().on('propertychange', function(e) {
          switch (e.key) {
            case 'resolution':
              resetScale();
              break;
          }
        });

        scope.$watch(
          'featureParams',
          function(fp) {
            if (scope.currentlyEditedFeature == -1) {
              return false;
            }

            if (scope.currentlyEditedFeature.indexOf('Canalisation') == 0) {
              return false;
            }

            elementsSource.getFeatures().forEach(function(f) {
              if (f.getId() == scope.currentlyEditedFeature) {
                var style = getFeatureStyle(f);
                var image = style.getImage();

                image.setScale(Math.abs(fp.scale));
                image.setRotation(fp.rotate * (Math.PI / 180));

                f.setStyle(style);
                elementsSource.changed();
                if (!styleFeatures) {
                  styleFeatures = {};
                }

                styleFeatures[f.getId()] = {
                  scale: Math.abs(fp.scale),
                  rotate: fp.rotate,
                };
              }
            });
          },
          1
        );

        /**
         * goToFeature
         * @param element
         */
        scope.goToFeature = function(element) {
          var ft = null;
          elementsSource.getFeatures().forEach(function(f) {
            if (f.getId() == element.feature.id) {
              ft = f;
            }
          });
          var extent = ft.getGeometry().getExtent();
          var zoom = map.getView().getZoom();

          map.getView().fit(extent, map.getSize());
          map.getView().setZoom(20);
          if (zoom >= 18) map.getView().setZoom(zoom);
        };

        /**
         * removeFeatureGeometry
         * @param category
         * @param element
         * @param index
         */
        scope.removeFeatureGeometry = function(category, element, index) {
          map.removeInteraction(modify);
          scope.currentlyEditedFeature = -1;

          var ans = confirm('Effacer la géométrie de cet élément ?');
          if (ans) {
            if (
              element.nom == 'Canalisations' ||
              element.nom == 'Annotation' ||
              element.nom == 'Image'
            ) {
              scope.displayElements[category].splice(index, 1);
            }

            elementsSource.getFeatures().forEach(function(f) {
              if (f.getId() == element.feature.id) {
                elementsSource.removeFeature(f);
                delete element.feature.geometry;
              }
            });
            map.removeInteraction(draw);
          }
        };

        /**
         * saveElementsFeatures
         */
        scope.saveElementsFeatures = function() {
          var positionFiliereSet = false;
          var geojsonFiliere = {
            type: 'FeatureCollection',
            features: [],
          };

          var currentFiliereFeature = false;
          elementsSource.getFeatures().forEach(function(f) {
            var ft = formatter.writeFeatureObject(f);
            if (f.getId() == scope.filiere.id) {
              currentFiliereFeature = ft;
            }

            geojsonFiliere.features.push(ft);
          });

          // mandatory
          if (!currentFiliereFeature) {
            require('toastr').error(
              'Veuillez renseigner la position de la filière',
              '',
              {
                positionClass: 'toast-bottom-left',
              }
            );
            return;
          }

          // no need for loader I guess, it's fast enough....
          //gaDomUtils.showLocalLoader('.representation_filiere');
          var savedFiliere = false,
            savedGeoJson = false;

          // MAJ POSITION FILIERE
          if (currentFiliereFeature) {
            EditFactory.update(
              filiereFti.uid,
              {
                type: 'FeatureCollection',
                features: [currentFiliereFeature],
              },
              srid
            ).then(function(res) {
              // apply it to current filiere object
              scope.filiere.geometry = currentFiliereFeature.geometry;
              savedFiliere = true;
              //if(savedGeoJson){   gaDomUtils.removeLocalLoader('.representation_filiere'); }
            });
          }

          currentGeoJsonData = geojsonFiliere;

          var bbox = map.getView().calculateExtent(map.getSize());

          var sendata = {
            collection: geojsonFiliere,
            style: styleFeatures,
            bbox: bbox,
          };

          if (typeof ancAppAndroid !== 'undefined')
            var promise = AncAppFactory.addFiliereByid(
              scope.filiere.id,
              JSON.stringify(sendata)
            );
          else
            var promise = ConfigFactory.add(
              sendata,
              '../../../BIZ/ANC/FILIERES_GEOJSON/' + scope.filiere.id,
              'filiere.json',
              AncAppFactory.appCfg.appname
            );

          // SAVE GEOJSON
          promise.then(function() {
            savedGeoJson = true;
            // if(savedFiliere){   gaDomUtils.removeLocalLoader('.representation_filiere'); }

            //require('toastr').success("Geométrie de la filière enregistrée");
            require('toastr').success(
              'Geométrie de la filière enregistrée',
              '',
              {
                positionClass: 'toast-bottom-left',
              }
            );

            // recup base 64 et save png
            map.once('postcompose', function(event) {
              var canvas = event.context.canvas;
              var image = canvas.toDataURL('image/png');

              AncAppFactory.base64topng(image, scope.filiere.id).then(
                function() {
                  //  require('toastr').success("Représentation enregistrée dans les documents liés.");
                  require('toastr').success(
                    'Représentation enregistrée dans les documents liés.',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                }
              );

              //  refreshAll();
              //  resetScale();
            });
            map.renderSync();
          });
        };

        /**
         * addDisplayElement
         * @param item
         * @param groupe
         * @param insertFirst
         */
        var addDisplayElement = function(item, groupe, insertFirst) {
          var tmpGroup = angular.copy(scope.displayElements);

          if (!angular.isDefined(tmpGroup)) tmpGroup = {};
          if (!angular.isDefined(tmpGroup[groupe])) tmpGroup[groupe] = [];

          if (insertFirst) {
            tmpGroup[groupe].splice(1, 0, item);
          } else {
            tmpGroup[groupe].push(item);
          }

          // sort
          if (
            angular.isDefined(tmpGroup['element_filiere']) &&
            tmpGroup['element_filiere'].length > 1
          ) {
            tmpGroup['element_filiere'] = AncAppFactory.sortElementsFiliere(
              tmpGroup['element_filiere'],
              'representation'
            );
          }

          // reaffect
          scope.displayElements = tmpGroup;
        };

        // get_keys pour trier la liste des catégories
        scope.get_keys = function(obj) {
          if (obj) return Object.keys(obj);
        };
        /**
         * orderCategories
         * @param category
         * @returns {number}
         */
        scope.orderCategories = function(category) {
          if (category == 'filiere') return 10;
          if (category == 'element_filiere') return 20;
          if (category == 'canalisations') return 30;
          return 100;
        };
        scope.renderCategoryName = function(category) {
          if (category == 'filiere') return 'Filière';
          if (category == 'element_filiere') return 'Eléments de filière';
          if (category == 'canalisations') return 'Canalisations';
          if (category == 'annotations') return 'Annotations';
          if (category == 'images') return 'Accessoires';
          return category;
        };
        /**
         * refresh the full elements list and layers
         */
        var panToPositionOnOpen = true;
        var currentGeoJsonData;
        var elementFiliereDesc = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_element_filiere'
        );
        var infosStyleElements = {};
        var styleFeatures;

        var refreshAll = function(saveAfterSet) {
          scope.displayElements = {};

          elementsSource.clear();
          // used when an element is removed from the filiere
          var needToSave = false;

          if (typeof ancAppAndroid !== 'undefined')
            gaDomUtils.showGlobalLoader();

          QueryFactory.data(elementFiliereDesc.uid).then(
            function(res) {
              for (var i in res.data.features) {
                infosStyleElements[
                  res.data.features[i].properties.identifiant
                ] = res.data.features[i].properties.representation;
              }

              addDisplayElement(
                {
                  nom: 'Filière',
                  typeInfo: 'POINT',
                  feature: scope.filiere,
                },
                'filiere'
              );

              // retrieve the geojson data
              if (typeof ancAppAndroid !== 'undefined')
                var promise = AncAppFactory.getFiliere(scope.filiere.id);
              else
                var promise = ConfigFactory.get(
                  '../../../BIZ/ANC/FILIERES_GEOJSON/' + scope.filiere.id,
                  'filiere.json',
                  AncAppFactory.appCfg.appname
                );

              if (typeof ancAppAndroid !== 'undefined')
                gaDomUtils.showGlobalLoader();

              promise.then(
                function(res) {
                  currentGeoJsonData = res.data.collection;
                  styleFeatures = res.data.style;
                  if (res.data.bbox) {
                    map.getView().fit(res.data.bbox, map.getSize());
                    resetScale();
                  }
                  // got some
                  if (
                    currentGeoJsonData != '' &&
                    currentGeoJsonData &&
                    angular.isDefined(currentGeoJsonData.features)
                  ) {
                    currentGeoJsonData.features.forEach(function(cf) {
                      if (!~cf.id.indexOf('kis_anc_dossier_filiere')) {
                        if (cf.id.indexOf('Annotation') == 0) {
                          addDisplayElement(
                            {
                              nom: cf.id,
                              typeInfo: 'Annotation',
                              feature: cf,
                            },
                            'annotations'
                          );
                        } else if (cf.id.indexOf('Accessoire') == 0) {
                          addDisplayElement(
                            {
                              nom: 'Image',
                              typeInfo: 'Image',
                              feature: cf,
                            },
                            'images'
                          );
                        } else if (cf.id.indexOf('Canalisation') == 0) {
                          addDisplayElement(
                            {
                              nom: 'Canalisations',
                              typeInfo: 'LINE',
                              feature: cf,
                            },
                            'canalisations'
                          );
                        } else {
                          // ONLY IF STILL PART OF FILIERE ELEMENTS !
                          var ftinfo = FeatureTypeFactory.getFeatureByNameAndDatastore(
                            AncAppFactory.appCfg.main.datastore,
                            cf.id.split('.')[0]
                          );
                          var stillPartOfFiliere = false;

                          scope.elements.forEach(function(e) {
                            if (e.properties.feature_id == cf.id)
                              stillPartOfFiliere = true;
                          });
                          if (scope.elements.length && !stillPartOfFiliere)
                            needToSave = true;

                          if (stillPartOfFiliere) {
                            addDisplayElement(
                              {
                                nom: ftinfo.alias,
                                typeInfo: ftinfo.typeInfo,
                                feature: cf,
                              },
                              'element_filiere',
                              1
                            );
                          }
                        }
                      }
                    });
                  }

                  for (var category in scope.displayElements) {
                    if (scope.displayElements[category].length) {
                      scope.displayElements[category].forEach(function(e) {
                        if (e.feature.geometry) {
                          var olFt = formatter.readFeature(e.feature);
                          olFt.setStyle(getFeatureStyle(olFt));
                          elementsSource.addFeature(olFt);
                        }
                      });
                    }
                  }

                  resetScale();

                  // only once
                  if (panToPositionOnOpen) {
                    var view = map.getView();
                    view.animate({
                      duration: 500,
                      source: view.getCenter(),
                    });

                    panToPositionOnOpen = false;
                  }

                  if (needToSave) {
                    scope.saveElementsFeatures();
                  }

                  // adding new elements
                  if (!angular.isUndefined(scope.elements)) {
                    var displayIds = {};

                    for (category in scope.displayElements) {
                      if (scope.displayElements[category].length) {
                        scope.displayElements[category].forEach(function(de) {
                          displayIds[de.feature.id] = category;
                        });
                      }
                    }

                    scope.elements.forEach(function(e) {
                      // new element indeed ! ~~

                      if (
                        !~Object.keys(displayIds).indexOf(
                          e.properties.feature_id
                        )
                      ) {
                        // insert before tuyaux that is always last
                        addDisplayElement(
                          {
                            nom: FeatureTypeFactory.getFeatureByUid(
                              e.properties.feature_uid
                            ).alias,
                            typeInfo: e.properties.geometrie,
                            feature: {
                              properties: [],
                              id: e.properties.feature_id,
                            },
                          },
                          'element_filiere'
                        );
                      }
                    });
                  }

                  if (typeof ancAppAndroid !== 'undefined')
                    gaDomUtils.hideGlobalLoader();
                },
                function() {
                  if (typeof ancAppAndroid !== 'undefined')
                    gaDomUtils.hideGlobalLoader();
                }
              );
            },
            function() {
              if (typeof ancAppAndroid !== 'undefined')
                gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * Whenever elements are changed
         */
        refreshAll();
        scope.$watch('elements', function(elements) {
          if (angular.isUndefined(scope.filiere)) return false;
          // refreshAll();
        });

        var maj_representation_filiere = $rootScope.$on(
          'maj_representation_filiere',
          function(event, data) {
            if (data.fid == scope.filiere.id) {
              refreshAll();
              resetScale();
            }
          }
        );
        scope.$watch('filiere.id', function(id, previd) {
          // refresh when the same partial is loaded for a different filiere
          if (
            angular.isDefined(id) &&
            angular.isDefined(previd) &&
            id != previd
          )
            refreshAll();
        });

        /**
         * afficher et cacher la description du icon
         */
        scope.displayTextStyle = false;
        scope.toggleText = function() {
          scope.displayTextStyle = !scope.displayTextStyle;

          elementsSource.getFeatures().forEach(function(f) {
            var style = getFeatureStyle(f);

            if (style.getText()) {
              style.getText().setScale(scope.displayTextStyle ? 1 : 0);
              f.setStyle(style);
              elementsSource.changed();
            }
          });
        };

        /**
         * retrieveLastid
         * @param type
         * @returns {number}
         */
        var retrieveLastid = function(type) {
          var tableau = [];
          var id = 0;

          if (angular.isDefined(scope.displayElements[type])) {
            scope.displayElements[type].forEach(function(e) {
              tableau = e.feature.id.split('_');
              if (parseInt(tableau[1]) > id) {
                id = parseInt(tableau[1]);
              }
            });
          }

          id++;
          return id;
        };

        /**
         * add Canalisations
         */
        scope.addCanalisationv2 = function(type) {
          var id_canalisation =
            'Canalisation_' + retrieveLastid('canalisations');

          var elem = {
            nom: 'Canalisations',
            typeInfo: 'LINE',
            feature: {
              id: id_canalisation,
              properties: {
                type: type,
              },
            },
          };

          addDisplayElement(elem, 'canalisations');
          scope.newFeature(elem);
        };

        /**
         * add Annotation
         */
        scope.addAnnotation = function() {
          scope.currentAnnotation = {};
          var id_annotation = 'Annotation_' + retrieveLastid('annotations');

          var elem = {
            nom: id_annotation,
            typeInfo: 'Annotation',
            feature: {
              properties: {
                label: scope.currentAnnotation.text,
              },
              id: id_annotation,
            },
          };

          addDisplayElement(elem, 'annotations');
          // scope.displayElements["annotations"].push(elem);
          scope.newFeature(elem);
        };

        /**
         * addImage
         */
        scope.addImage = function() {
          var id_image = 'Accessoire_' + retrieveLastid('images');
          var elem = {
            nom: id_image,
            typeInfo: 'Image',
            feature: {
              properties: {
                url: '',
              },
              id: id_image,
            },
          };
          addDisplayElement(elem, 'images');
          scope.newFeature(elem);
        };

        scope.renderTypeFeature = function(currentlyEditedFeature) {
          if (currentlyEditedFeature != -1) {
            if (
              currentlyEditedFeature.indexOf('Canalisation') != 0 &&
              currentlyEditedFeature.indexOf('Annotation') != 0
            ) {
              return true;
            }
          }
        };

        /**
         * renderNameCanalisations
         * @param element
         * @returns {string}
         */
        scope.renderNameCanalisations = function(element) {
          var id = element.feature.id;
          var value = id.split('_');

          if (value[2] && value[2].indexOf('cotation') == 0) {
            var name = value[2].split('.');
            return 'Cotation_' + name[1];
          } else {
            return element.feature.properties.type;
          }
        };

        /**
         * renderNameAnnotations
         * @param elem
         * @returns {string}
         */
        /*scope.renderNameAnnotations = function (elem) {
                 var value = elem.feature.id.split('.');
                 return 'Annotation_' + value[1];
                 };*/

        /*   scope.renderNameImages = function (id) {
                 var value = id.split('.');
                 return 'Image_' + value[1];
                 };*/

        /**
         * faire un dessin de polygon pour supprimer canalisations selectionnees
         */
        scope.featuresSelectionnees = [];
        scope.select_features = false;
        var draw_select, nouveauSource, nouveauLayer, lastSource;
        scope.selectCanalisattions = function() {
          map.removeInteraction(draw_select);
          nouveauSource = new ol.source.Vector({});
          remove_source_dessin();
          if (scope.select_features == true) {
            scope.featuresSelectionnees = [];
            scope.select_features = false;
            return false;
          }
          scope.select_features = true;

          draw_select = new ol.interaction.Draw({
            source: sourceDessin,
            type: 'Polygon',
          });

          map.addInteraction(draw_select);

          draw_select.on('drawend', function(evt) {
            remove_source_dessin();
            scope.featuresSelectionnees = [];

            var extent = evt.feature.getGeometry().getExtent();

            elementsSource.forEachFeatureIntersectingExtent(extent, function(
              feature
            ) {
              if (feature.getId().indexOf('kis_anc') == -1) {
                scope.featuresSelectionnees.push(feature);
              }
              //AJOUTER TOUS LES FEATURES DANS LA SOURCE
              var geometry = feature.getGeometry();
              var coordinates = geometry.getCoordinates();

              // console.log(feature.getId());
              var nouveau_feature;
              if (feature.getId().indexOf('Annotation') == 0) {
                nouveau_feature = new ol.Feature({
                  geometry: new ol.geom.Point(coordinates),
                });
              } else {
                nouveau_feature = new ol.Feature({
                  geometry: new ol.geom.LineString(coordinates),
                });
              }
              console.log(nouveau_feature);
              nouveauSource.addFeature(nouveau_feature);
            });

            //CREER UN NOUVEAU LAYER POUR LES FEATURES CHOISIES
            nouveauLayer = new ol.layer.Vector({
              source: nouveauSource,
              style: new ol.style.Style({
                fill: new ol.style.Fill({
                  color: 'yellow',
                }),
                stroke: new ol.style.Stroke({
                  color: 'yellow',
                  width: 2,
                }),
                image: new ol.style.Circle({
                  radius: 5,
                  fill: new ol.style.Fill({
                    color: 'yellow',
                  }),
                }),
              }),
            });
            //AJOUTER LE LAYER DANS LA MAP
            nouveauLayer.setZIndex(9999);
            map.addLayer(nouveauLayer);
            lastSource = nouveauLayer.getSource();

            var lastFeature = evt.feature;

            $timeout(function() {
              sourceDessin.removeFeature(lastFeature);
            }, 0);
          });
        };

        /**
         * supprimer canalisations selectionnees
         */
        scope.removeFeaturesSelected = function() {
          var ans;
          console.log(scope.featuresSelectionnees);
          if (scope.featuresSelectionnees.length == 1) {
            ans = confirm('Effacer la géométrie de cet élément ?');
          } else {
            ans = confirm(
              'Effacer la géométrie de ces ' +
                scope.featuresSelectionnees.length +
                ' éléments ?'
            );
          }

          if (ans) {
            map.removeInteraction(draw_select);

            if (scope.select_features == true) {
              scope.select_features = false;
            }

            elementsSource.getFeatures().forEach(function(f) {
              scope.featuresSelectionnees.forEach(function(ff) {
                if (ff.getId() == f.getId()) {
                  scope.displayElements.forEach(function(e) {
                    if (e.feature.id == ff.getId()) {
                      if (ff.getId().indexOf('kis_anc') == -1) {
                        elementsSource.removeFeature(f);
                        delete e.feature.geometry;
                      }
                    }
                  });
                }
              });
            });
          }
          remove_source_dessin();
          scope.featuresSelectionnees = [];
        };

        /**
         * supprimer les dessins
         */
        var remove_source_dessin = function() {
          sourceDessin.clear();
          nouveauSource.clear();
          if (lastSource) {
            lastSource.clear();
          }
        };

        /**
         * mapConfig
         */
        scope.mapFeatureConfig = {};

        /**
         * Annotation Dialog
         */
        var AnnotationDialog;
        scope.currentAnnotation = {};
        scope.CurrentAnnotationElem = false;
        scope.openAnnotationDialog = function(elem) {
          scope.currentAnnotation = {};
          scope.CurrentAnnotationElem = elem;
          scope.currentAnnotation.text = '';
          if (elem.feature.properties && elem.feature.properties.label) {
            scope.currentAnnotation.text = elem.feature.properties.label;
          }
          AnnotationDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.representationAnnotation.html',
            className: 'ngdialog-theme-plain width300 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        var ImageDialog;
        scope.currentSelectedImage = {};
        scope.CurrentImageElem = false;
        scope.openImageDialog = function(elem) {
          scope.currentSelectedImage.url = elem.feature.properties.url;
          scope.CurrentImageElem = elem;
          ImageDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.representationImage.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        var filiereRepresentationImagesDialog;
        scope.currentFiliereRepresentationImages = [];
        scope.openFiliereRepresentationImagesDialog = function(elem) {
          var tmp = elem.feature.id.split('.');
          scope.currentFiliereRepresentationImages = infosStyleElements[tmp[0]]
            .split(';')
            .filter(function(elem, index, self) {
              return index == self.indexOf(elem);
            });

          scope.currentFiliereRepresentation = elem;
          filiereRepresentationImagesDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.filiereRepresentationImages.html',
            className: 'ngdialog-theme-plain width500 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.setFiliereRepresentationImage = function(url) {
          console.log(url);

          filiereRepresentationImagesDialog.close();
          var properties;
          scope.displayElements.forEach(function(e) {
            if (e.feature.id == scope.currentFiliereRepresentation.feature.id) {
              if (!e.feature.properties) e.feature.properties = {};
              e.feature.properties.url = url;
              properties = e.feature.properties;
            }
          });

          elementsSource.getFeatures().forEach(function(f) {
            if (f.getId() == scope.currentFiliereRepresentation.feature.id) {
              var style = getElementFiliereStyle(url);
              style.getText().setText(scope.currentFiliereRepresentation.nom);
              f.setStyle(style);
              f.setProperties(properties);
              elementsSource.changed();
            }
          });

          resetScale();
          scope.currentFiliereRepresentation = {};
        };

        scope.setRepresentationImage = function(data) {
          ImageDialog.close();
          console.log(data);

          var properties;
          scope.displayElements['images'].forEach(function(e) {
            if (e.feature.id == scope.CurrentImageElem.feature.id) {
              e.feature.properties.url = data.url + '/' + data.img;
              properties = e.feature.properties;
            }
          });

          elementsSource.getFeatures().forEach(function(f) {
            if (f.getId() == scope.CurrentImageElem.feature.id) {
              var style = getElementFiliereStyle(data.url + '/' + data.img);
              var image = style.getImage();
              image.setScale(0.5);
              //  style.getText().setText('Image');
              f.setProperties(properties);
              f.setStyle(style);
              elementsSource.changed();
            }
          });
          resetScale();
          scope.currentSelectedImage = {};
        };

        /**
         * update Annotation
         */
        scope.updateAnnotation = function() {
          var properties;
          scope.displayElements['annotations'].forEach(function(e) {
            if (e.feature.id == scope.CurrentAnnotationElem.feature.id) {
              e.feature.properties.label = scope.currentAnnotation.text;
              properties = e.feature.properties;
            }
          });

          elementsSource.getFeatures().forEach(function(f) {
            if (f.getId() == scope.CurrentAnnotationElem.feature.id) {
              var style = getFeatureStyle(f);
              f.setProperties(properties);
              style.getText().setText(scope.currentAnnotation.text);
              f.setStyle(style);
              elementsSource.changed();
            }
          });

          AnnotationDialog.close();
          scope.currentAnnotation = {};
        };

        var refreshRepresentationDisplayElements = $rootScope.$on(
          'refreshRepresentationDisplayElements',
          function(event, data) {
            var ftinfo = FeatureTypeFactory.getFeatureByUid(data.uid);
            addDisplayElement(
              {
                nom: ftinfo.alias,
                typeInfo: ftinfo.typeInfo,
                feature: {
                  properties: [data.featureCollection.features[0].properties],
                  id: data.ftid,
                },
              },
              'element_filiere',
              1
            );
            /*
                     if(!angular.isDefined(scope.displayElements["element_filiere"])) scope.displayElements["element_filiere"] = [];
                     scope.displayElements["element_filiere"].splice(scope.displayElements["element_filiere"].length - 1, 0, {
                     nom: ftinfo.alias,
                     typeInfo: ftinfo.typeInfo,
                     feature: {
                     properties: [data.featureCollection.features[0].properties],
                     id: data.ftid
                     }
                     });*/
          }
        );

        /**
         * set zIndex
         */
        elementsLayer.setZIndex(9900);
        map.getLayers().insertAt(9900, elementsLayer);
        layerDessin.setZIndex(9900);
        map.getLayers().insertAt(9900, layerDessin);
        scope.currentMap = map;
        scope.featuresConfig =
          AncAppFactory.appCfg.main.mapConfiguration.featuresConfig;

        /**
         * bloquer le dessin tant que la filière n'a pas été localisée
         */
        scope.bloquerDessin = function() {
          return (
            angular.isDefined(scope.displayElements) &&
            angular.isDefined(scope.displayElements.filiere) &&
            scope.displayElements.filiere[0].feature.geometry
          );

          /* var res = false;
                     scope.hasFiliereGeometry = false;
                     if(scope.displayElements &&scope.displayElements.length){
                     for(var i=0;i<scope.displayElements.length;i++){
                     if(scope.displayElements[i].feature.geometry){
                     scope.hasFiliereGeometry = true;
                     res = true;
                     }
                     }
                     }
                     return res;*/
        };

        /**
         * is cotation
         * @param elem
         * @returns {boolean}
         */
        scope.isCotation = function(elem) {
          var res = false;
          if (elem.feature.id.indexOf('Canalisation_cotation') == 0) {
            res = true;
          }
          return res;
        };

        scope.hasSeveralImages = function(elem) {
          var res = false;
          var tmp = elem.feature.id.split('.');
          if (
            infosStyleElements[tmp[0]] &&
            infosStyleElements[tmp[0]].split(';').length > 1
          ) {
            res = true;
          }
          return res;
        };

        scope.elementsGroups = function(elements) {
          if (!elements.length) return;

          var groups = {};
          elements.forEach(function(e) {
            if (!angular.isDefined(groups[e.group])) groups[e.group] = [];
            groups[e.group].push(e);
          });

          console.log(groups);
          //return elements;
          return groups;
        };

        /**
         * Mode déconnecté Android
         */
        if (typeof AppAndroid !== 'undefined') {
          if (AppAndroid.isNetworkAvailable())
            map.getLayers().insertAt(0, OSMLayer);

          var positionStyle = new ol.style.Style({
            image: new ol.style.Icon({
              src: 'img/widget/gsw/gsw_01.png',
              scale: 1,
            }),
          });

          var parseGeoJSONPosition = function(json) {
            var response = null;
            if (json) {
              var position = JSON.parse(json);
              if (position && position.lon && position.lat) {
                var coordinates = [
                  parseFloat(position.lon),
                  parseFloat(position.lat),
                ];
                var coordinatesProj = ol.proj.transform(
                  coordinates,
                  'EPSG:4326',
                  'EPSG:3857'
                );

                var point = new ol.geom.Point(coordinatesProj);

                var feature = new ol.Feature({
                  geometry: point,
                });

                var source = new ol.source.Vector({
                  features: [feature],
                });

                var layer = new ol.layer.Vector({
                  source: source,
                  style: positionStyle,
                });

                response = layer;
              }
            }
            return response;
          };

          var upadteGeojsonPosition = function(json, layer) {
            var response = false;
            var position = JSON.parse(json);
            if (position && position.lon && position.lat) {
              var coordinates = [position.lon, parseFloat(position.lat)];
              var coordinatesProj = ol.proj.transform(
                coordinates,
                'EPSG:4326',
                'EPSG:3857'
              );

              var point = new ol.geom.Point(coordinatesProj);

              layer.getSource().forEachFeature(function(feature) {
                feature.setGeometry(point);
                response = true;
              });
            }
            return response;
          };

          scope.gpsrunning = function() {
            var position = AppAndroid.getGpsPosition();
            if (position && !scope.userPosition) {
              scope.userPosition = parseGeoJSONPosition(position);
              if (scope.userPosition) {
                map.getLayers().insertAt(10, scope.userPosition);
                scope.zoomonuseranddata();
              }
            } else if (
              position &&
              scope.userPosition &&
              scope.userPosition instanceof ol.layer.Vector
            ) {
              upadteGeojsonPosition(position, scope.userPosition);
            }
          };

          scope.zoomonuseranddata = function() {
            var extent;
            if (
              AncAppFactory.appCfg &&
              AncAppFactory.appCfg.main &&
              AncAppFactory.appCfg.main.mapConfiguration &&
              AncAppFactory.appCfg.main.mapConfiguration.bbox
            )
              var extentd = AncAppFactory.appCfg.main.mapConfiguration.bbox;

            if (
              scope.userPosition &&
              scope.userPosition.getSource() &&
              scope.userPosition.getSource().getExtent()
            )
              var extentp = scope.userPosition.getSource().getExtent();

            if (extentd && extentp) extent = ol.extent.extend(extentd, extentp);
            else if (extentd && !extentp) extent = extentd;
            else if (!extentd && extentp) extent = extentp;

            if (extent) map.getView().fit(extent, map.getSize());
          };

          var isNetworkRunning = function() {
            var networkAvailable = AppAndroid.isNetworkAvailable();
            var index = -1;
            map.getLayers().forEach(function(layer, ind) {
              if (layer.getSource() instanceof ol.source.OSM) index = ind;
            });
            if (!networkAvailable) {
              if (index !== -1) map.getLayers().removeAt(index);
            } else {
              if (index === -1) map.getLayers().insertAt(0, OSMLayer);
            }
          };
          $interval(isNetworkRunning, 4000);
          var base64Prefix = 'data:image/png;base64,',
            emptyImage =
              'data:image/png;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
          var projection = ol.proj.get('EPSG:3857'),
            projectionExtent = projection.getExtent(),
            tileSize = 256;

          var maxResolution =
            ol.extent.getWidth(projectionExtent) / (tileSize * 2);
          var resolutions = [];
          var z;

          for (var z = 0; z < 31; ++z) {
            // generate resolutions and matrixIds arrays for this WMTS
            resolutions[z] = maxResolution / Math.pow(2, z);
          }

          scope.checkOrAddMbtiles = function(mbtilesname) {
            if (mbtilesname) {
              AppAndroid.setMbtilesName(mbtilesname);
              AppAndroid.checkOrCreateConnexionDb(mbtilesname);
              if (
                !scope.mbtilesLayer ||
                AppAndroid.getAppName() !== 'DOSSIER'
              ) {
                var source = new ol.source.XYZ({
                  tileGrid: new ol.tilegrid.TileGrid({
                    origin: ol.extent.getBottomLeft(projectionExtent),
                    resolutions: resolutions,
                    extent: projectionExtent,
                  }),
                  tileUrlFunction: function(tileCoord) {
                    return '';
                  },
                  tileLoadFunction: function(imageTile, src) {
                    var tileCoord = imageTile.getTileCoord();
                    var z = tileCoord[0] + 1;
                    var x = tileCoord[1];
                    var y = tileCoord[2];

                    var base64src = AppAndroid.getBase64(x, y, z);
                    if (!base64src) {
                      imageTile.getImage().src = emptyImage;
                      return;
                    }

                    imageTile.getImage().src = base64Prefix + base64src;
                  },
                });
                scope.mbtilesLayer = new ol.layer.Tile({
                  source: source,
                });

                zoomToMbtiles();
              } else {
                zoomToMbtiles();
              }
            }
          };

          scope.removeuserPosition = function() {
            if (scope.userPosition) {
              map.removeLayer(scope.userPosition);
              scope.userPosition = null;
            }
          };

          scope.checkOrAddMbtiles(AppAndroid.mbtilesname);

          scope.removeMbtile = function() {
            if (scope.mbtilesLayer) scope.mbtilesLayer.setVisible(false);
          };

          var zoomToMbtiles = function() {
            var index = -1;
            var indexMbtiles = -1;
            map.getLayers().forEach(function(layer, ind) {
              if (layer.getSource() instanceof ol.source.OSM) index = ind;
              else if (layer.getSource() instanceof ol.source.XYZ)
                indexMbtiles = ind;
            });

            if (indexMbtiles !== -1) scope.mbtilesLayer.setVisible(true);
            else map.getLayers().insertAt(index + 1, scope.mbtilesLayer);
            map
              .getView()
              .fit(
                ol.proj.transformExtent(
                  JSON.parse(AppAndroid.getExtent()),
                  'EPSG:4326',
                  'EPSG:3857'
                ),
                map.getSize()
              );
          };
          /***
           * END MODE DECONNECTER
           */
        }

        // cleanup
        scope.$on('$destroy', function() {
          maj_representation_filiere();
          refreshRepresentationDisplayElements();
        });
      },
    };
  };

  representationFiliere.$inject = [
    'QueryFactory',
    'FeatureTypeFactory',
    'EditFactory',
    'gaDomUtils',
    '$timeout',
    'ConfigFactory',
    'AncAppFactory',
    '$rootScope',
    '$q',
    'gcWMS',
    'ngDialog',
    '$interval',
  ];
  return representationFiliere;
});
