'use strict';
define(function() {
  var representationFiliere = function(
    QueryFactory,
    FeatureTypeFactory,
    EditFactory,
    gaDomUtils,
    $timeout,
    AncAppFactory,
    $rootScope,
    $q,
    ngDialog,
    $interval,
    BaseMapFactory,
    gclayers,
    gcFeatureGeometryEditor,
    gaJsUtils,
    PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/representation_filiere.html',
      restrict: 'EA',
      scope: {
        filiere: '=',
        elements: '=',
        positionDossier: '=?',
        displayLayers: '=?', // array of fti to display
        hasFiliereGeometry: '=?',
        filieres: '=?',
        reportId: '=?',
        currentBranchData: '=?',
      },
      link: {
        pre: function(scope, elt, attrs, ctrl) {
          scope.map = new ol.Map({
            layers: [new ol.layer.Tile({})],
            controls: ol.control.defaults({
              attribution: false,
              zoom: false,
            }),
            target: 'rf_map',
            view: new ol.View({
              projection: 'EPSG:3857',
              zoom: 14,
            }),
          });
          scope.map.addControl(new ol.control.ScaleLine({minWidth: 115}));

          // -----------------------------------------------
          // Ajout du graticule  (quadrillage)
          // -----------------------------------------------

          var g;
          function setGraticule() {
            if (g) scope.map.removeControl(g);
            if (!scope.displayGraticule) return;
            g = new ol.control.Graticule({
              step: 1,
              stepCoord: 1,
              projection: 'EPSG:3857',
              graticule3857Kis: true,
              formatCoord: function(c, distance) {
                // format
                var ret;
                distance = Math.abs(distance);
                if (distance == 0) {
                  ret = distance;
                } else if (distance < 10) {
                  ret = Math.round(distance * 10) / 10 + 'm';
                } else if (distance < 1000) {
                  ret = Math.round(distance) + 'm';
                } else {
                  ret = Math.round(distance / 1000) + 'km';
                }
                return ret;
              },
            });
            var style = new ol.style.Style();
            style.setStroke(new ol.style.Stroke({ color: '#999', width: 1 }));
            style.setText(
              new ol.style.Text({
                stroke: new ol.style.Stroke({
                  color: '#fff',
                  width: 2,
                }),
                fill: new ol.style.Fill({ color: '#444' }),
              })
            );
            g.setStyle(style);
            scope.map.addControl(g);
          }

          /**
           * Afficher/cacher le graticule
           */
          scope.displayGraticule = false;
          scope.toggleGraticule = function() {
            scope.displayGraticule = !scope.displayGraticule;
            setGraticule();
          };

          // -----------------------------------------------
          // Ajout des layers
          // -----------------------------------------------
          // ajout des layer group des ef + canalisations
          if (
            AncAppFactory.appCfg.main.properties.filieresVectorielles.active
          ) {
            var portalId = PortalsFactory.getPortalId();
            var efWMS = new ol.layer.Tile({
              id: 'efLayerAll',
              source: new ol.source.TileWMS({
                url:
                  '/services/' +
                  portalId +
                  '/geoserver/wms?token=' +
                  localStorage.auth_token,
                params: {
                  LAYERS:
                    portalId +
                    ':lg_anc_ef_pretraitement,' +
                    portalId +
                    ':lg_anc_ef_traitement,' +
                    portalId +
                    ':lg_anc_ef_autre,' +
                    portalId +
                    ':lg_anc_ef_agree',
                  TILED: true,
                  CQL_FILTER:
                    "id_filiere='" +
                    scope.filiere.id +
                    "';" +
                    "id_filiere='" +
                    scope.filiere.id +
                    "';" +
                    "id_filiere='" +
                    scope.filiere.id +
                    "';" +
                    "id_filiere='" +
                    scope.filiere.id +
                    "'",
                },
                serverType: 'geoserver',
                crossOrigin: 'anonymous',
              }),
              zIndex: 9000,
            });

            var efCanaWMS = new ol.layer.Tile({
              id: 'efCanalisations',
              source: new ol.source.TileWMS({
                url:
                  '/services/' +
                  portalId +
                  '/geoserver/wms?token=' +
                  localStorage.auth_token,
                params: {
                  LAYERS: portalId + ':kis_anc_efx_canalisations',
                  TILED: true,
                  CQL_FILTER: "id_filiere='" + scope.filiere.id + "'",
                  STYLES: portalId + ':kis_anc_efx_canalisations',
                },
                serverType: 'geoserver',
                crossOrigin: 'anonymous',
              }),
              zIndex: 9000,
            });

            // on ajoute seulement
            var deregfeaturesConfigLoaded = $rootScope.$on(
              'featuresConfigLoaded',
              function(event, data) {
                scope.map.addLayer(efWMS);
                scope.map.addLayer(efCanaWMS);
              }
            );
            scope.$on('$destroy', function() {
              deregfeaturesConfigLoaded();
            });
          }
        },
        post: function(scope, elt, attrs, ctrl) {
          // permet de cacher le bandeau "Cette filière est inactive"
          scope.checkedInactive = { x: false };
          var propsElemFiliere = [];

          // -----------------------------------------------
          // INITIALISATIONS
          // -----------------------------------------------

          var filieresActivesDansConfigAppli = angular.copy(
            AncAppFactory.appCfg.main.properties.filieresVectorielles.active
          );

          scope.hasGeomFiliere = false;
          if (angular.isDefined(scope.filiere)) {
            if (angular.isDefined(scope.filiere.geometry)) {
              scope.hasGeomFiliere = true;
            }
          }

          // cotationsV2
          scope.cotationsV2 = [];

          scope.configCanas = angular.copy(
            AncAppFactory.appCfg.main.properties.configCanas
          );
          var sortConfigCanas = {};
          if (angular.isDefined(scope.configCanas) && scope.configCanas.liste) {
            scope.configCanas.liste.map(function(x) {
              sortConfigCanas[x.lib] = x.color;
            });
          }

          if (typeof AppAndroid !== 'undefined') scope.AppAndroid = AppAndroid;

          scope.isSlidable = false;

          // -----------------------------------------------
          // MOUSE / PROJECTION
          // -----------------------------------------------
          var mousePositionControl = new ol.control.MousePosition({
            coordinateFormat: ol.coordinate.createStringXY(4),
            projection: 'EPSG:3857',
            className: 'custom-mouse-position',
            target: document.getElementById('mouse-position'),
            undefinedHTML: '&nbsp;',
          });

          var projectionSelect = document.getElementById('projection');
          if (projectionSelect)
            projectionSelect.addEventListener('change', function(event) {
              mousePositionControl.setProjection(
                ol.proj.get(event.target.value)
              );
            });

          // -----------------------------------------------
          // SOURCES
          // -----------------------------------------------

          var sourceDessin = new ol.source.Vector({ wrapX: false });
          //LAYER DU DESSIN AVEC UN STYLE
          var layerDessin = new ol.layer.Vector({
            source: sourceDessin,
            style: new ol.style.Style({
              fill: new ol.style.Fill({
                color: 'rgba(255, 255, 255, 0.2)',
              }),
              stroke: new ol.style.Stroke({
                color: 'yellow',
                width: 2,
              }),
              image: new ol.style.Circle({
                radius: 2,
                fill: new ol.style.Fill({
                  color: 'yellow',
                }),
              }),
            }),
          });

          var draw,
            modify,
            // filiere fti
            filiereFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
              AncAppFactory.appCfg.main.datastore,
              'kis_anc_dossier_filiere'
            ),
            formatter = new ol.format.GeoJSON(),
            // default draw style
            drawStyle = new ol.style.Style({
              fill: new ol.style.Fill({
                color: 'rgba(255, 255, 255, 0.5)',
              }),
              stroke: new ol.style.Stroke({
                color: '#3498db',
                width: 2,
              }),
              image: new ol.style.Circle({
                radius: 7,
                fill: new ol.style.Fill({
                  color: '#3498db',
                }),
              }),
            }),
            // filiere
            filiereStyle = new ol.style.Style({
              image: new ol.style.Icon({
                src: 'img/common/map_directive_picker.png',
              }),
              text: new ol.style.Text({
                textAlign: 'center',
                textBaseline: 'middle',
                font: 'Normal 12px Arial',
                text: '',
                fill: new ol.style.Fill({
                  color: '#000000',
                }),
                stroke: new ol.style.Stroke({
                  color: '#FFFFFF',
                  width: 2,
                }),
                offsetY: 20,
              }),
            }),
            displayStyle = new ol.style.Style({
              fill: new ol.style.Fill({
                color: 'rgba(255, 255, 255, 0.5)',
              }),
              stroke: new ol.style.Stroke({
                color: '#16a085',
                width: 2,
              }),
              image: new ol.style.Circle({
                radius: 7,
                fill: new ol.style.Fill({
                  color: '#16a085',
                }),
              }),
              text: new ol.style.Text({
                textAlign: 'center',
                textBaseline: 'middle',
                font: 'Normal 12px Arial',
                text: '',
                fill: new ol.style.Fill({
                  color: '#000000',
                }),
                stroke: new ol.style.Stroke({
                  color: '#FFFFFF',
                  width: 2,
                }),
                offsetY: 20,
              }),
            });

          /**
           * return elementFiliereStyle
           * @param img
           */
          var getElementFiliereStyle = function(img) {
            var scale = 1;
            // svg fix size
            if (~img.indexOf('.svg')) scale = 0.05;

            if (typeof AppAndroid !== 'undefined')
              return new ol.style.Style({
                image: new ol.style.Icon({
                  src: img.replace(
                    '/geoserver/styles/kis/common/images/',
                    'img/'
                  ),
                  scale: scale,
                }),
                text: new ol.style.Text({
                  textAlign: 'center',
                  textBaseline: 'middle',
                  font: 'Normal 12px Arial',
                  text: '',
                  fill: new ol.style.Fill({
                    color: '#000000',
                  }),
                  stroke: new ol.style.Stroke({
                    color: '#FFFFFF',
                    width: 2,
                  }),
                  offsetY: 20,
                }),
              });
            else
              return new ol.style.Style({
                image: new ol.style.Icon({
                  src: img,
                  scale: scale,
                }),
                text: new ol.style.Text({
                  textAlign: 'center',
                  textBaseline: 'middle',
                  font: 'Normal 12px Arial',
                  text: '',
                  fill: new ol.style.Fill({
                    color: '#000000',
                  }),
                  stroke: new ol.style.Stroke({
                    color: '#FFFFFF',
                    width: 2,
                  }),
                  offsetY: 20,
                }),
              });
          };

          // actual geometries layer
          var elementsSource = new ol.source.Vector();
          var elementsLayer = new ol.layer.Vector({
            source: elementsSource,
            style: displayStyle,
          });

          // feature collection used to draw new geometries
          var features = new ol.Collection();

          var collection = new ol.Collection();
          var featureOverlay = new ol.layer.Vector({
            map: scope.map,
            source: new ol.source.Vector({
              features: collection,
              useSpatialIndex: false, // optional, might improve performance
            }),
            style: drawStyle,
            updateWhileAnimating: true, // optional, for instant visual feedback
            updateWhileInteracting: true, // optional, for instant visual feedback
          });

          /**
           * v2LayerStyle
           * Determine le style des ef vectoriels (en edition : style sinon depuis wms)
           * @param {*} feature
           */
          var v2LayerStyle = function(feature) {
            if (
              feature.get('isNotSavedYet') ||
              feature.getId() == scope.currentlyEditedFeature
            ) {
              return new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: 'black',
                  width: 1,
                }),
                fill: new ol.style.Fill({
                  color: 'rgba(0, 255, 255, 1)',
                }),
              });
            } else {
              // empty, probably could return null
              return null;
            }
          };

          // DESSIN_FILIERES_V2
          // elements filiere gémeotry
          var elementsGeometrySource = new ol.source.Vector({
            features: [],
          });
          var elementsGeometryLayer = new ol.layer.Vector({
            source: elementsGeometrySource,
            style: v2LayerStyle,
          });

          var map = scope.map;

          /**
           * toggleBaseMap
           */
          scope.toggleBaseMap = function(layer) {
            gclayers.addBackGroundLayerByDesc(layer);

            if (scope.currentlayer == null) {
              layer.active = true;
              scope.currentlayer = layer;
            } else {
              if (scope.currentlayer == layer) {
                scope.currentlayer = null;
                layer.active = false;
              } else {
                scope.currentlayer.active = false;
                layer.active = true;
                scope.currentlayer = layer;
              }
            }

            try {
              // refresh layer
              var bgLayers = gclayers.getBackGroundLayer();
              for (var i in bgLayers) {
                for (var j = 0; j < scope.baselayers.length; j++) {
                  if (scope.baselayers[j].name == bgLayers[i].get('name')) {
                    bgLayers[i].setVisible(scope.baselayers[j].active);
                  }
                }
              }
            } catch (e) {
              console.log(e);
            }
          };

          var initBaseMap = function() {
            scope.baselayers = angular.copy(BaseMapFactory.resources.basemaps);

            // check si un layer deja actif (ce bloc et le suivant semblent inutiles ?)
            var lcbg = map.getLayers().getArray();
            for (var i = lcbg.length - 1; i >= 0; i--) {
              for (var j = 0; j < scope.baselayers.length; j++) {
                if (lcbg[i].get('visible')) {
                  if (scope.baselayers[j].name == lcbg[i].get('name')) {
                    scope.baselayers[j].active = true;
                    scope.currentlayer = scope.baselayers[j];
                  }
                }
              }
            }

            for (var i = scope.baselayers.length - 1; i >= 0; i--) {
              if (
                scope.baselayers[i].active != null &&
                scope.baselayers[i].type != 'OSM'
              ) {
                scope.baselayers[i].active = null;
              }
            }

            gclayers.forceClearBackgroundLayer();

            if (scope.currentlayer == null) {
              for (var i = scope.baselayers.length - 1; i >= 0; i--) {
                if (scope.baselayers[i].type === 'OSM') {
                  scope.toggleBaseMap(scope.baselayers[i]);
                }
              }
            }
          };

          scope.currentlayer = null;
          if (BaseMapFactory.resources.basemaps.length == 0) {
            BaseMapFactory.get().then(function() {
              initBaseMap();
            });
          } else {
            initBaseMap();
          }

          if (
            angular.isDefined(scope.positionDossier) &&
            scope.positionDossier != null
          ) {
            if (typeof scope.positionDossier === 'string')
              scope.positionDossier = JSON.parse(scope.positionDossier);

            var posDossier = angular.copy(scope.positionDossier);
            if (typeof posDossier == 'string')
              posDossier = JSON.parse(posDossier);

            var dossierCoords = angular.copy(posDossier.coordinates);

            //if(angular.isDefined(dossierCoords) && angular.isArray(dossierCoords[0])) dossierCoords = dossierCoords[0];

            // rajoute icon dossier
            var iconFeature = new ol.Feature({
                geometry: new ol.geom.MultiPoint(dossierCoords),
              }),
              iconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                  src: 'img/anc/dossier.png',
                  scale: 1,
                }),
              });

            iconFeature.setStyle(iconStyle);

            var positionVectorLayer = new ol.layer.Vector({
              source: new ol.source.Vector({
                features: [iconFeature],
              }),
            });

            scope.map.addLayer(positionVectorLayer);

            var center = angular.copy(dossierCoords);
            if (scope.positionDossier.type === 'MultiPoint') {
              scope.map.getView().setCenter(center[0]);
            } else {
              scope.map.getView().setCenter(center);
            }

            scope.map.getView().setZoom(18);
          } else {
            if (
              angular.isDefined(AncAppFactory.appCfg.main.mapConfiguration.bbox)
            ) {
              scope.map
                .getView()
                .fit(
                  AncAppFactory.appCfg.main.mapConfiguration.bbox,
                  scope.map.getSize()
                );
            }
          }

          featureOverlay.setMap(scope.map);

          // -----------------------------------------------
          // LOGIC
          // -----------------------------------------------

          /**
           * getFeatureStyle
           * @param id
           * @returns ol.style
           */

          var getFeatureStyle = function(feature) {
            var id = feature.getId();
            var tmp = id.split('.');
            var style = displayStyle;
            var foundFeature,
              img_url,
              displayName = '';

            for (var category in scope.displayElements) {
              if (scope.displayElements[category].length) {
                scope.displayElements[category].forEach(function(e) {
                  if (e.feature.id == id) {
                    foundFeature = e;
                    /* if (foundFeature.nom == 'Canalisations') {
                                            foundFeature.nom =  e.feature.id.split('_')[2];
                                        }*/

                    // console.log(foundFeature);
                    // console.log(id);

                    if (foundFeature.typeInfo == 'Annotation') {
                      if (e.feature.properties && e.feature.properties.label)
                        displayName = e.feature.properties.label;
                    }

                    if (foundFeature.typeInfo == 'Image') {
                      displayName = foundFeature.nom;
                      img_url = e.feature.properties.url;
                    }

                    if (id.indexOf('Canalisation_cotation') == 0) {
                      if (e.feature.properties && e.feature.properties.label)
                        displayName = e.feature.properties.label;
                    }

                    if (e.feature.properties && e.feature.properties.url) {
                      img_url = e.feature.properties.url;
                    }
                  }
                });
              }
            }

            if (id.indexOf('Canalisation') == 0) {
              var color = sortConfigCanas[foundFeature.feature.properties.type];

              // c'est le flux wms qui nous interesse desormais
              // on affiche donc le style mobile en attendant l'enregistrement (+ dashed)
              var strokeStyle = !scope.isFiliereVectorielle
                ? new ol.style.Stroke({
                    color: color,
                    width: 2,
                  })
                : new ol.style.Stroke({
                    color: color,
                    width: 2,
                    lineDash: [4, 4],
                  });

              var tuyauxStyle = new ol.style.Style({
                stroke: strokeStyle,
                text: new ol.style.Text({
                  textAlign: 'center',
                  textBaseline: 'middle',
                  font: 'Normal 12px Arial',
                  text: foundFeature.feature.properties.type,
                  fill: new ol.style.Fill({
                    color: '#000000',
                  }),
                  stroke: new ol.style.Stroke({
                    color: '#FFFFFF',
                    width: 2,
                  }),
                  offsetY: 20,
                }),
              });

              // si l'objet a deja la propriete id_efx_cana, on cache, c'est le flux wms qui est affiche
              if (
                scope.isFiliereVectorielle &&
                angular.isDefined(foundFeature.feature.properties.id_efx_cana)
              ) {
                // sauf si on est en train de l'editer
                if (scope.currentlyEditedFeature != foundFeature.feature.id) {
                  tuyauxStyle = new ol.style.Style({});
                }
              }

              // semble inutilisé
              // if (id.indexOf("Canalisation_cotation") == 0) {
              //     tuyauxStyle = new ol.style.Style({
              //         fill: new ol.style.Fill({
              //             color: 'rgba(255, 255, 255, 0.2)'
              //         }),
              //         stroke: new ol.style.Stroke({
              //             color: 'rgba(0, 0, 0, 0.5)',
              //             lineDash: [10, 10],
              //             width: 2
              //         }),
              //         text: new ol.style.Text({
              //             textAlign: "center",
              //             textBaseline: "middle",
              //             font: 'Normal 12px Arial',
              //             text: displayName,
              //             fill: new ol.style.Fill({
              //                 color: '#000000'
              //             }),
              //             stroke: new ol.style.Stroke({
              //                 color: '#FFFFFF',
              //                 width: 2
              //             }),
              //             offsetY: 20
              //         })
              //     });

              // };

              style = tuyauxStyle;
            } else if (id.indexOf('Annotation') == 0) {
              var AnnotationStyle = new ol.style.Style({
                fill: new ol.style.Fill({
                  color: 'rgba(255, 255, 255, 0.5)',
                }),
                stroke: new ol.style.Stroke({
                  color: '#16a085',
                  width: 2,
                }),
                // KIS-1635
                /* image: new ol.style.Circle({
                  radius: 3,
                  fill: new ol.style.Fill({
                    color: 'red',
                  }),
                }),*/
                text: new ol.style.Text({
                  textAlign: 'center',
                  textBaseline: 'middle',
                  font: 'Normal 16px Arial bold',
                  text: displayName,
                  fill: new ol.style.Fill({
                    color: '#000000',
                  }),
                  // KIS-1635
                  /*stroke: new ol.style.Stroke({
                    color: '#FFFFFF',
                    width: 6,
                  }),*/
                  scale: 0.8,
                  offsetY: 15,
                }),
              });
              style = AnnotationStyle;
            } else if (~id.indexOf('kis_anc_dossier_filiere')) {
              if (styleFeatures) {
                var img = filiereStyle.getImage();
                var keys = Object.keys(styleFeatures);
                keys.forEach(function(key) {
                  if (key == id) {
                    img.setScale(Math.abs(styleFeatures[key].scale));
                    img.setRotation(
                      styleFeatures[key].rotate * (Math.PI / 180)
                    );
                  }
                });
              }

              style = filiereStyle;
            } else if (~id.indexOf('Accessoire')) {
              //  console.log('ici');
              style = getElementFiliereStyle(img_url);
              //console.log(style);
            } else {
              if (
                angular.isDefined(infosStyleElements[tmp[0]]) &&
                infosStyleElements[tmp[0]] != ''
              ) {
                if (img_url && img_url != '') {
                  style = getElementFiliereStyle(img_url);
                } else {
                  style = getElementFiliereStyle(
                    infosStyleElements[tmp[0]].split(';')[0]
                  );
                }

                if (styleFeatures) {
                  var img = style.getImage();

                  var keys = Object.keys(styleFeatures);
                  keys.forEach(function(key) {
                    if (key == id) {
                      img.setScale(Math.abs(styleFeatures[key].scale));
                      img.setRotation(
                        styleFeatures[key].rotate * (Math.PI / 180)
                      );
                    }
                  });
                }
              }
            }

            // text layer
            if (style.getText()) {
              if (!foundFeature.nom) foundFeature.nom = '';
              if (
                foundFeature.nom != 'Canalisations' &&
                foundFeature.nom.indexOf('Annotation') != 0 &&
                foundFeature.nom != 'Image'
              ) {
                style.getText().setText(displayName);
              }
            }

            return style;
          };

          var getGeometryDepuisBibliothequeAnc = function(x) {
            var def = $q.defer();

            QueryFactory.data(
              'kis_anc_bibliotheque_ef',
              "identifiant = '" + x.split(':')[1] + "'",
              'EPSG:3857'
            ).then(
              function(res) {
                def.resolve(res.data.features[0]);
              },
              function() {
                def.reject();
                console.log('err recup modeleName');
              }
            );

            return def.promise;
          };

          function getCenterOfExtent(Extent) {
            var X = Extent[0] + (Extent[2] - Extent[0]) / 2;
            var Y = Extent[1] + (Extent[3] - Extent[1]) / 2;
            return [X, Y];
          }

          /**
           * letsDraw
           * @param type
           * @param element
           */
          function drawFeature(type, element) {
            // DESSIN_FILIERES_V2
            if (
              scope.isFiliereVectorielle &&
              !element.feature.id.startsWith('kis_anc_dossier_filiere') &&
              element.feature.id.indexOf('kis_anc_ef') !== -1
            ) {
              // recuperation la representation_vectorielle depuis kis_anc_element_filiere
              var typeEf = element.feature.id.split('.')[0];
              var descEf = descriptionElementsFiliere.features.filter(function(
                x
              ) {
                return x.properties.identifiant == typeEf;
              });

              // ssi on retrouve le bon element de filiere
              if (descEf.length) {
                // recuperation des representation_vectorielle
                var representation_vectorielle =
                  descEf[0].properties.representation_vectorielle;
                if (representation_vectorielle == null) {
                  scope.currentlyEditedFeature = -1;
                  require('toastr').error(
                    "Aucune représentation n'est configurée pour cet élément de filière",
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                  return;
                }

                draw = new ol.interaction.Draw({
                  features: features,
                  type: 'Point',
                  style: drawStyle,
                });

                scope.map.getLayers().insertAt(9999, elementsGeometryLayer);
                scope.map.addInteraction(draw);

                draw.on('drawend', function(e) {
                  $timeout(function() {
                    // coordonnées du point cliqué
                    var coordinates = e.feature.getGeometry().getCoordinates();

                    // on propose les choix ?
                    var choixVectoriel = representation_vectorielle.split(';');

                    // on recupere tjrs le premier ce n' est qu'apres qu'on propose de switcher entre plusieurs
                    getGeometryDepuisBibliothequeAnc(choixVectoriel[0]).then(
                      function(res) {
                        if (!angular.isDefined(res)) {
                          require('toastr').error(
                            "La représentation configurée pour cet élément de filière n'existe pas.<br/>Se référer à l'administration de l'application.",
                            '',
                            {
                              positionClass: 'toast-bottom-left',
                            }
                          );
                          scope.map.removeInteraction(draw);
                          cancelEditMode();
                          return;
                        }
                        // recuperation de le geometrie de ce type d'element de filiere et translation à la position du point cliqué
                        var mEfJson = res, // feature json
                          mEf = formatter.readFeature(mEfJson); // feature ol

                        var efBibliothequeXY = getCenterOfExtent(
                          mEf.getGeometry().getExtent()
                        );

                        mEf
                          .getGeometry()
                          .translate(
                            coordinates[0] - efBibliothequeXY[0],
                            coordinates[1] - efBibliothequeXY[1]
                          ); // deplace au bon endroit

                        // met a jour la geometrie de notre element
                        var fixedFt = {
                          type: 'Feature',
                          // @TODO @TOFIX les features ajoutées directement ont leur propriété dans un tableau (refreshRepresentationDisplayElements)
                          // il faudrait fixer mais attention aux implications surtout pour le mobile...
                          // en attendant on laisse comme ça...
                          properties:
                            angular.isArray(element.feature.properties) &&
                            angular.isDefined(element.feature.properties[0])
                              ? element.feature.properties[0]
                              : element.feature.properties,
                          id: element.feature.id,
                        };

                        //isFilierev2
                        // fixedFt.properties.isFilierev2 = true;
                        fixedFt.properties.isNotSavedYet = true;

                        var elementOl = formatter.readFeature(fixedFt);
                        elementOl.setGeometry(mEf.getGeometry());

                        // au niveau du geojson on garde la geometrie du point dessine
                        var formatted_drawn_feature = formatter.writeFeatureObject(
                          e.feature
                        );
                        element.feature.geometry =
                          formatted_drawn_feature.geometry;

                        // #ICI
                        e.feature.setId(element.feature.id);
                        e.feature.setProperties(element.feature.properties);
                        scope.map.removeInteraction(draw);

                        // si feature existe deja (geometrie supprimée) on l'enleve d'abord pour reset
                        elementsGeometrySource
                          .getFeatures()
                          .forEach(function(f) {
                            if (f.getId() == element.feature.id) {
                              elementsGeometrySource.removeFeature(f);
                            }
                          });

                        elementsGeometrySource.addFeature(elementOl);

                        cancelEditMode();
                      },
                      function() {
                        require('toastr').error(
                          "Erreur lors de la récupération de la géométrie associée à ce type d'élément de filière",
                          '',
                          {
                            positionClass: 'toast-bottom-left',
                          }
                        );
                      }
                    );

                    // // recuperation de le geometrie de ce type d'element de filiere et translation à la position du point cliqué
                    // var mEfJson = descEf[0], // feature json
                    //     mEf = formatter.readFeature(mEfJson); // feature ol
                    // mEf.getGeometry().translate(coordinates[0], coordinates[1]);

                    // // met a jour la geometrie de notre element
                    // var fixedFt = {
                    //     type: "Feature",
                    //     // @TODO @TOFIX les features ajoutées directement ont leur propriété dans un tableau (refreshRepresentationDisplayElements)
                    //     // il faudrait fixer mais attention aux implications surtout pour le mobile...
                    //     // en attendant on laisse comme ça...
                    //     properties: angular.isArray(element.feature.properties) && angular.isDefined(element.feature.properties[0]) ? element.feature.properties[0] : element.feature.properties,
                    //     id: element.feature.id
                    // };

                    // //isFilierev2
                    // fixedFt.properties.isFilierev2 = true;
                    // fixedFt.properties.isNotSavedYet = true;

                    // var elementOl = formatter.readFeature(fixedFt);
                    // elementOl.setGeometry(mEf.getGeometry());

                    // // zoom sur l'ef dessiné
                    // // var zoom = scope.map.getView().getZoom();
                    // // scope.map.getView().fit(mEf.getGeometry().getExtent(), scope.map.getSize());
                    // // scope.map.getView().getZoom(zoom);

                    // // au niveau du geojson on garde la geometrie du point dessine
                    // var formatted_drawn_feature = formatter.writeFeatureObject(e.feature);
                    // element.feature.geometry = formatted_drawn_feature.geometry;

                    // // #ICI
                    // e.feature.setId(element.feature.id);
                    // e.feature.setProperties(element.feature.properties);
                    // scope.map.removeInteraction(draw);
                    // elementsGeometrySource.addFeature(elementOl);

                    // scope.currentlyEditedFeature = -1;
                    // scope.currentEditMode = false;
                  });
                });
              } else {
                scope.currentlyEditedFeature = -1;
                require('toastr').error(
                  'Impossible de récupérer la description de la couche ' +
                    typeEf,
                  '',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
                return;
              }

              // autres types de geometrie
            } else {
              draw = new ol.interaction.Draw({
                features: features,
                type: type,
                style: drawStyle,
              });
              scope.map.addInteraction(draw);

              scope.map.getLayers().insertAt(9999, elementsLayer);
              scope.map.getLayers().insertAt(9999, layerDessin);

              if (element.feature.id.indexOf('Accessoire') == 0) {
                scope.openImageDialog(element);
              }

              draw.on('drawend', function(e) {
                console.log(element.feature.id);
                if (element.feature.id.indexOf('Annotation') == 0) {
                  scope.openAnnotationDialog(element);
                } else if (
                  element.feature.id.indexOf('Canalisation_cotation') == 0
                ) {
                  scope.openAnnotationDialog(element);
                  // }else if (element.feature.id.indexOf('Accessoire') == 0) {
                  //     scope.openImageDialog(element);
                } else {
                  if (
                    element.feature.id.indexOf('Canalisation') != 0 &&
                    element.feature.id.indexOf('kis_anc_dossier_filiere') !=
                      0 &&
                    element.feature.id.indexOf('Accessoire') != 0
                  ) {
                    var tmp = element.feature.id.split('.');
                    var urls = infosStyleElements[tmp[0]].split(';');
                    if (urls.length > 1) {
                      scope.openFiliereRepresentationImagesDialog(element);
                    }
                  }
                }

                $timeout(function() {
                  // retrieve and format the geometry of the drawn element
                  var formatted_drawn_feature = formatter.writeFeatureObject(
                    e.feature
                  );
                  element.feature.geometry = formatted_drawn_feature.geometry;

                  e.feature.setId(element.feature.id);
                  e.feature.setProperties(element.feature.properties);

                  if (styleFeatures) {
                    styleFeatures[e.feature.getId()] = {
                      scale: 1,
                      rotate: 0,
                    };
                  }

                  e.feature.setStyle(getFeatureStyle(e.feature));

                  elementsSource.addFeature(e.feature);

                  scope.map.removeInteraction(draw);
                  resetScale();
                  cancelEditMode();
                });
              });
            }
          }

          var forceLayerRefresh = function(lay) {
            // force refresh
            var source = lay.getSource();
            var params = source.getParams();
            params.t = new Date().getMilliseconds();
            source.updateParams(lay);
            scope.map.renderSync();
          };
          /**
           * refreshAndSetLayerEfVisibility
           * @param {*} visibility
           */
          var refreshAndSetLayerEfVisibility = function(visibility) {
            visibility = angular.isDefined(visibility)
              ? visibility
              : scope.categoryVisibility['element_filiere'].v;
            scope.map.getLayers().forEach(function(lay) {
              if (lay.get('id') == 'efLayerAll') {
                lay.setVisible(visibility);
                forceLayerRefresh(lay);
              }
            });
          };
          /**
           * refreshAndSetLayerCanaVisibility
           * @param {*} visibility
           */
          var refreshAndSetLayerCanaVisibility = function(visibility) {
            visibility = angular.isDefined(visibility)
              ? visibility
              : scope.categoryVisibility['canalisations'].v;
            scope.map.getLayers().forEach(function(lay) {
              if (lay.get('id') == 'efCanalisations') {
                lay.setVisible(visibility);
                forceLayerRefresh(lay);
              }
            });
          };

          scope.categoryVisibility = {
            filiere: { v: true },
            element_filiere: { v: true },
            canalisations: { v: true },
            annotations: { v: true },
            images: { v: true },
            cotations: { v: true },
          };

          /**
           * toggle la representation d'une categorie d'elements
           */
          scope.toggleCategory = function(c) {
            scope.categoryVisibility[c].v = !scope.categoryVisibility[c].v;
            if (c == 'element_filiere') refreshAndSetLayerEfVisibility();
            if (c == 'canalisations') refreshAndSetLayerCanaVisibility();
            if (c == 'cotations')
              scope.$broadcast('loadDataIntoMesasureToolbar', {
                data: scope.categoryVisibility[c].v ? scope.cotationsV2 : [],
              });

            resetScale();
          };

          /**
           * newFeature
           * @param element
           */
          scope.newFeature = function(element) {
            if (element.feature.id.indexOf('kis_anc_dossier_filiere') == 0)
              scope.hasGeomFiliere = true;

            scope.map.removeInteraction(modify);
            if (
              element &&
              element.feature &&
              element.feature.id &&
              scope.currentlyEditedFeature !== element.feature.id
            ) {
              scope.currentlyEditedFeature = element.feature.id;
            } else if (
              element &&
              element.feature &&
              element.feature.id &&
              scope.currentlyEditedFeature === element.feature.id
            ) {
              cancelEditMode();
              scope.map.removeInteraction(draw);
              return;
            } else {
              scope.currentlyEditedFeature = -1;
            }
            scope.currentEditMode = false;

            var currentDrawTypeInfo;
            switch (element.typeInfo) {
              case 'LINE':
                currentDrawTypeInfo = 'LineString';
                break;
              case 'POLYGON':
                currentDrawTypeInfo = 'Polygon';
                break;
              case 'GEOMETRY':
                currentDrawTypeInfo = 'GEOMETRY';
                break;
              default:
                currentDrawTypeInfo = 'Point';
                break;
            }
            scope.map.removeInteraction(draw);
            drawFeature(currentDrawTypeInfo, element);
          };

          cancelEditMode();

          scope.setEditMode = function(mode) {
            if (scope.currentEditMode == mode) {
              scope.currentEditMode = false;
              return false;
            }
            scope.currentEditMode = mode;
          };

          /**
           * findFeatureInCollections
           * retrouve la feature dans les collections v1/v2
           */
          function findFeatureInCollections(element) {
            var subFeatures = new ol.Collection();

            var found = false,
              typeEf = 'classique';
            elementsSource.getFeatures().forEach(function(f) {
              if (f.getId() == element.feature.id) {
                subFeatures.push(f);
                found = true;
              }
            });

            if (!found) {
              elementsGeometrySource.getFeatures().forEach(function(f) {
                if (f.getId() == element.feature.id) {
                  subFeatures.push(f);
                  found = true;
                  typeEf = 'v2';
                }
              });
            }

            if (!found) {
              console.log('Impossible de retrouver la feature ?');
              return false;
            }

            return {
              features: subFeatures,
              typeEf: typeEf,
            };
          }

          /**
           * zoomToFeature
           * @param feature
           */
          scope.zoomToFeature = function(feature) {
            //var beforeFitZoom = angular.copy(scope.map.getView().getZoom());

            var extent = feature.getGeometry().getExtent();
            scope.map.getView().fit(extent, scope.map.getSize());
            if (scope.map.getView().getZoom() > 22) {
              scope.map.getView().setZoom(22);
            }
          };

          var highlightStyleCache = {};
          var featureHighLightOverlay = new ol.layer.Vector({
            source: new ol.source.Vector(),
            map: map,
            style: function(feature, resolution) {
              var rid = feature.get('rid');

              if (!highlightStyleCache[rid]) {
                highlightStyleCache[rid] = new ol.style.Style({
                  stroke: new ol.style.Stroke({
                    color: '#8b0000',
                    width: 2,
                  }),
                  fill: new ol.style.Fill({
                    color: 'rgba(255,165,0,1)',
                  }),
                  image: new ol.style.Icon({
                    anchor: [0.5, 50],
                    anchorXUnits: 'fraction',
                    anchorYUnits: 'pixels',
                    src: 'img/widget/network/marker.png',
                    scale: 0.5,
                  }),
                });
              }
              return highlightStyleCache[rid];
            },
          });
          featureHighLightOverlay.setMap(scope.map);

          /**
           * Selection d'une preview de représentation
           */
          var cachePreviews = {};
          scope.selectRepForPreview = function(x) {
            scope.currentlyPickedPreview = x.identifiant;
            if (!angular.isDefined(cachePreviews[x.identifiant])) {
              QueryFactory.data(
                'kis_anc_bibliotheque_ef',
                "identifiant = '" + x.identifiant + "'",
                'EPSG:2154'
              ).then(function(res) {
                if (res.data.features.length) {
                  scope.pickedForPreview = {
                    index: x.index,
                    modele: res.data.features[0],
                  };
                }
              });
            } else {
              scope.pickedForPreview = {
                index: x.index,
                modele: cachePreviews[x.identifiant],
              };
            }
          };
          /**
           * doHighLightFeature
           * Highlight une feature
           * @param {*} theFeat
           * @param {*} featureId
           */
          var doHighLightFeature = function(theFeat, featureId) {
            scope.currentlyHighlightedFeature = featureId;

            // first clear any existing features in the overlay
            featureHighLightOverlay.getSource().clear();

            try {
              // test the feature's geometry type and compute a reasonable point
              // at which to display the text.
              var geometry = theFeat.getGeometry();
              var point;
              switch (geometry.getType()) {
                case 'GeometryCollection':
                  var geometries = theFeat.getGeometry().getGeometries();

                  for (var key in geometries) {
                    // si la geom est du multi polygon
                    if (geometries[key].getType() == 'MultiPolygon');
                    {
                      var poly = geometries[key]
                        .getPolygons()
                        .reduce(function(left, right) {
                          return left.getArea() > right.getArea()
                            ? left
                            : right;
                        });
                      point = poly.getInteriorPoint().getCoordinates();
                    }
                  }
                  //point = poly.getInteriorPoint().getCoordinates();
                  break;
                case 'MultiPolygon':
                  var poly = geometry
                    .getPolygons()
                    .reduce(function(left, right) {
                      return left.getArea() > right.getArea() ? left : right;
                    });
                  point = poly.getInteriorPoint().getCoordinates();
                  break;
                case 'LineString':
                  point = getCenterOfExtent(theFeat.getGeometry().getExtent());
                  break;
                case 'Polygon':
                  point = geometry.getInteriorPoint().getCoordinates();
                  break;
                default:
                  point = theFeat.getGeometry().getCoordinates();
              }

              // console.log(point);
              var _tmp = formatter.writeFeatureObject(theFeat);
              var ftOverlay = formatter.readFeature({
                type: 'Feature',
                geometry: _tmp.geometry,
                properties: {},
              });

              // create a new feature to display the text
              var textFeature = new ol.Feature({
                geometry: new ol.geom.Point(point),
                rid: featureId,
              });

              featureHighLightOverlay.getSource().addFeature(textFeature);
              featureHighLightOverlay.getSource().addFeature(ftOverlay);
              // scope.zoomToFeature(ftOverlay);
            } catch (e) {
              console.log(
                '%c Impossible de recup la geometrie ',
                'background: #f00; color: #fff'
              );
              console.log(e);
            }
          };
          scope.currentlyHighlightedFeature;

          /**
           * highlight tout sauf cotations
           */
          scope.addhighLightFeature = function(e) {
            if (!e.feature.geometry) return;
            // retrieve the feature
            var featureData = findFeatureInCollections(e);
            if (!featureData) return false;
            doHighLightFeature(
              featureData.features.getArray()[0],
              e.feature.id
            );
          };

          /**
           * highLightCotation
           */
          scope.highLightCotation = function(e) {
            console.log(e.properties.uid);

            var ft = null;
            gclayers
              .getMeasureLayer()
              .getSource()
              .getFeatures()
              .forEach(function(f) {
                if (f.get('uid') == e.properties.uid) {
                  ft = f;
                }
              });
            $('[data-uniqid=' + e.properties.uid + ']').addClass(
              'highLightedCotationTooltip'
            );
            if (ft !== null) {
              doHighLightFeature(ft, e.properties.uid);
            }
          };
          scope.rmHighLightFeature = function() {
            scope.currentlyHighlightedFeature = -1;
            featureHighLightOverlay.getSource().clear();
            $('.highLightedCotationTooltip').removeClass(
              'highLightedCotationTooltip'
            );
          };

          /**
           * goToFeature
           * @param element
           */
          scope.goToFeature = function(element) {
            var featureData = findFeatureInCollections(element);
            if (!featureData) return false;
            scope.zoomToFeature(featureData.features.getArray()[0]);
          };

          function cancelEditMode() {
            scope.currentlyEditedFeature = -1;
            scope.currentEditMode = false;
          }

          /**
           * getCurrentlyEditedFeatureDimensions
           * get la hauteur / largeur actuelle de l'element
           */
          scope.curreEfDimension = {
            ft: null,
            largeur_base: 1,
            hauteur_base: 1,
            largeur: 1,
            hauteur: 1,
            preserveRatio: true,
          };

          var canUpdateDimensions = true;
          scope.$watch(
            function() {
              // strip ft sans quoi le watch devient fou
              var cpy = {
                largeur: scope.curreEfDimension.largeur,
                hauteur: scope.curreEfDimension.hauteur,
                preserveRatio: scope.curreEfDimension.preserveRatio,
              };
              return cpy;
            },
            function(cfd, oldcfd) {
              if (cfd && oldcfd && cfd.preserveRatio) {
                // only once sinon boucle infinie
                if (!canUpdateDimensions) {
                  canUpdateDimensions = true;
                  return;
                }

                if (
                  cfd.hauteur != oldcfd.hauteur &&
                  cfd.hauteur !== null &&
                  oldcfd.hauteur !== null
                ) {
                  var ratio = cfd.hauteur / oldcfd.hauteur;
                  var _l = Math.round(cfd.largeur * ratio * 100) / 100;
                  scope.curreEfDimension.largeur = _l <= 0 ? 0.01 : _l;
                  canUpdateDimensions = false;
                }
                if (
                  cfd.largeur != oldcfd.largeur &&
                  cfd.largeur !== null &&
                  oldcfd.largeur !== null
                ) {
                  var ratio = cfd.largeur / oldcfd.largeur;
                  var _h = Math.round(cfd.hauteur * ratio * 100) / 100;
                  scope.curreEfDimension.hauteur = _h <= 0 ? 0.01 : _h;
                  canUpdateDimensions = false;
                }
              }
            },
            1
          );

          var wgs84Sphere = new ol.Sphere(6378137);
          var editFeatureExtrasSource = new ol.source.Vector({
            wrapX: false,
          });
          //LAYER DU DESSIN AVEC UN STYLE
          function editFeatureExtrasLayerStyleFunction() {
            return [
              new ol.style.Style({
                fill: new ol.style.Fill({
                  color: 'rgba(255, 255, 255, 0.25)',
                }),
                stroke: new ol.style.Stroke({
                  color: 'red',
                  width: 1,
                }),
                text: new ol.style.Text({
                  font: '12px Calibri,sans-serif',
                  fill: new ol.style.Fill({ color: '#000' }),
                  stroke: new ol.style.Stroke({
                    color: '#fff',
                    width: 2,
                  }),
                  // get the text from the feature - `this` is ol.Feature
                  // and show only under certain resolution
                  text: this.get('description'),
                }),
              }),
            ];
          }
          var editFeatureExtrasLayer = new ol.layer.Vector({
            source: editFeatureExtrasSource,
          });
          editFeatureExtrasLayer.setZIndex(9800);
          scope.map.addLayer(editFeatureExtrasLayer);
          var getCurrentlyEditedFeatureDimensions = function() {
            // clear editFeatureExtrasSource
            editFeatureExtrasSource.clear();

            var ft = scope.editEfv2Cfg.features.getArray()[0],
              ex = ft.getGeometry().getExtent(),
              _cd = scope.curreEfDimension;
            _cd.ft = ft;

            // dessine l'extent
            var bottomLeft = ol.extent.getBottomLeft(ex);
            var topRight = ol.extent.getTopRight(ex);
            var bottomRight = ol.extent.getBottomRight(ex);
            var topLeft = ol.extent.getTopLeft(ex);
            var ring = [
              [bottomLeft[0], bottomLeft[1]],
              [topLeft[0], topLeft[1]],
              [topRight[0], topRight[1]],
              [bottomRight[0], bottomRight[1]],
            ];
            var _ext = new ol.Feature({
              geometry: new ol.geom.Polygon([ring]),
            });

            var verticalLength =
              Math.round(
                wgs84Sphere.haversineDistance(
                  ol.proj.transform(bottomLeft, 'EPSG:3857', 'EPSG:4326'),
                  ol.proj.transform(topLeft, 'EPSG:3857', 'EPSG:4326')
                ) * 100
              ) / 100;
            var horizontalLength =
              Math.round(
                wgs84Sphere.haversineDistance(
                  ol.proj.transform(bottomLeft, 'EPSG:3857', 'EPSG:4326'),
                  ol.proj.transform(bottomRight, 'EPSG:3857', 'EPSG:4326')
                ) * 100
              ) / 100;

            _ext.set(
              'description',
              horizontalLength + 'm * ' + verticalLength + 'm'
            );
            _ext.setStyle(editFeatureExtrasLayerStyleFunction);
            editFeatureExtrasSource.addFeature(_ext);

            _cd.largeur = _cd.largeur_base = horizontalLength;
            _cd.hauteur = _cd.hauteur_base = verticalLength;
          };

          /**
           * updateEfDimensions
           * Mise a jour de la taille de l'element de filiere en fonction des valeurs rentrées
           */
          scope.updateEfDimensions = function() {
            try {
              if (scope.curreEfDimension.largeur <= 0)
                scope.curreEfDimension.largeur = 0.01;
              if (scope.curreEfDimension.hauteur <= 0)
                scope.curreEfDimension.hauteur = 0.01;

              var _cd = scope.curreEfDimension,
                ratioHauteur = _cd.hauteur / _cd.hauteur_base,
                ratioLargeur = _cd.largeur / _cd.largeur_base;

              console.log(
                '%c ratios - hauteur :  ' +
                  ratioHauteur +
                  ' , largeur : ' +
                  ratioLargeur,
                'background: #f00; color: #fff'
              );

              scope.curreEfDimension.ft
                .getGeometry()
                .scale(ratioLargeur, ratioHauteur);
              //scope.curreEfDimension.ft.getGeometry().scale(ratioLargeur, ratioHauteur, ol.extent.getBottomLeft(_cd.ft.getGeometry().getExtent()));
              _cd.hauteur_base = _cd.hauteur;
              _cd.largeur_base = _cd.largeur;
            } catch (error) {
              require('toastr').error(
                'Erreur.',
                "Impossible d'appliquer ces dimensions",
                {
                  positionClass: 'toast-bottom-left',
                }
              );
              // reset
            }
            getCurrentlyEditedFeatureDimensions();
          };

          /**
           * reset le style des canalisations
           */
          var resetCanasStyle = function() {
            elementsSource.getFeatures().forEach(function(f) {
              if (f.get('category') == 'canalisations') {
                f.setStyle(getFeatureStyle(f));
              }
            });
          };

          /**
           * editFeature
           * @param element
           */
          scope.editFeature = function(element) {
            scope.map.removeInteraction(modify);
            elementsGeometrySource.changed();
            editFeatureExtrasSource.clear();
            gcFeatureGeometryEditor.resetBoxAndHandles(map);

            // retrieve the feature
            var featureData = findFeatureInCollections(element);
            if (!featureData) return false;

            // toggle self, cancel all
            if (scope.currentlyEditedFeature == element.feature.id) {
              cancelEditMode();
              resetCanasStyle();
              return;
            }

            // if found
            var _ft = featureData.features.getArray()[0];
            if (
              element.feature.id.indexOf('kis_anc_ef_') === -1 ||
              !AncAppFactory.appCfg.main.mapConfiguration ||
              !AncAppFactory.appCfg.main.mapConfiguration.skipZoomSf
            ) {
              scope.zoomToFeature(_ft);
            }
            scope.currentlyEditedFeature = element.feature.id;

            resetCanasStyle();

            // v1
            if (featureData.typeEf !== 'v2') {
              modify = new ol.interaction.Modify({
                features: featureData.features,
              });
              scope.map.addInteraction(modify);
              // seulement les elements de filiere vectoriels
            } else {
              scope.editEfv2Cfg = {
                mode: '',
                features: featureData.features,
                typeFeature: element.feature.id.split('.')[0],
              };
              getCurrentlyEditedFeatureDimensions();
            }

            // alimenter avec styleFeatures[id]
            scope.featureParams = {};

            if (styleFeatures) {
              var keys = Object.keys(styleFeatures);
              keys.forEach(function(key) {
                if (key == element.feature.id) {
                  scope.featureParams.rotate = styleFeatures[key].rotate;
                  scope.featureParams.scale = -Math.abs(
                    styleFeatures[key].scale
                  );
                }
              });
            } else {
              scope.featureParams = { rotate: 0, scale: -1 };
            }
          };

          /**
           * resetEfv2
           * @param {*} index
           */
          var resetEfv2 = function(index) {
            var ans = confirm(
              'Êtes-vous sur de vouloir réinitaliser la géométrie de cet élément de filière ?'
            );
            if (!ans) return;

            var featureConcernee = scope.editEfv2Cfg.features.getArray()[0];

            var descEf = descriptionElementsFiliere.features.filter(function(
              x
            ) {
              return x.properties.identifiant == scope.editEfv2Cfg.typeFeature;
            });
            if (descEf.length) {
              getGeometryDepuisBibliothequeAnc(
                descEf[0].properties.representation_vectorielle.split(';')[
                  index
                ]
              ).then(function(res) {
                var mEf = formatter.readFeature(res);

                var efBibliothequeXY = getCenterOfExtent(
                  mEf.getGeometry().getExtent()
                );
                var coordinates = getCenterOfExtent(
                  featureConcernee.getGeometry().getExtent()
                );

                mEf
                  .getGeometry()
                  .translate(
                    coordinates[0] - efBibliothequeXY[0],
                    coordinates[1] - efBibliothequeXY[1]
                  );

                featureConcernee.setGeometry(mEf.getGeometry());
                getCurrentlyEditedFeatureDimensions();
              });

              // var _geom = (formatter.readFeature(descEf[0])).getGeometry();
              // // on recupere la position actuelle de le feature
              // var extent = featureConcernee.getGeometry().getExtent();
              // _geom.translate(extent[0] + (extent[2] - extent[0]) / 2, extent[1] + (extent[3] - extent[1]) / 2);
              // featureConcernee.setGeometry(_geom);
            }
          };

          var translateEf;
          /**
           * Modification des features v2
           */
          scope.editEfv2 = function(mode) {
            scope.currentlyPickedPreview = false;
            scope.map.removeInteraction(modify);
            scope.map.removeInteraction(translateEf);
            gcFeatureGeometryEditor.resetBoxAndHandles(map);
            scope.repVectoriellePicker = [];

            var featureConcernee = scope.editEfv2Cfg.features.getArray()[0];
            getCurrentlyEditedFeatureDimensions();
            refreshAndSetLayerEfVisibility();

            // deja activé
            if (scope.editEfv2Cfg.mode == mode) {
              scope.editEfv2Cfg.mode = '';

              return;
            }

            scope.editEfv2Cfg.mode = '';

            if (mode == 'reset') {
              resetEfv2(0);
            } else {
              scope.editEfv2Cfg.mode = mode;

              if (mode == 'pickRepresentation') {
                try {
                  var efType = scope.currentlyEditedFeature.split('.')[0];
                  var reps = representationsVectorielles[efType];

                  scope.repVectoriellePicker = reps.map(function(x, i) {
                    var _x = x.split(':');
                    return {
                      label: _x[0],
                      identifiant: _x[1],
                      index: i,
                    };
                  });
                } catch (e) {
                  // err
                }
              }

              if (mode == 'deplacement') {
              }
              //modifier la geometrie
              if (mode == 'modify') {
                modify = new ol.interaction.Modify({
                  features: scope.editEfv2Cfg.features,
                });
                scope.map.addInteraction(modify);
              }
              // deplacer
              if (mode == 'deplacement') {
                translateEf = new ol.interaction.Translate({
                  features: scope.editEfv2Cfg.feature,
                });
                scope.map.addInteraction(translateEf);
              }
              // transformer la geometrie
              if (mode == 'advanced') {
                gcFeatureGeometryEditor.init(map, featureConcernee);
              }
            }
          };

          /**
           * repVectoriellePick
           */
          scope.repVectoriellePick = function(x) {
            // recupere la feature
            resetEfv2(x.index);
          };

          /**
           * reset Scale of image and text
           */
          var resetScale = function() {
            var zoom = scope.map.getView().getZoom();
            var scale = zoom / 10 - 1.4;
            if (scale < 0.2) {
              scale = 0.2;
            }
            elementsSource.getFeatures().forEach(function(f) {
              var props = f.getProperties();
              var currentCategory = angular.isDefined(props.category)
                ? props.category
                : '';

              var style = getFeatureStyle(f);
              var image = style.getImage();

              if (image) {
                //scale of image
                if (zoom >= 21) {
                  if (styleFeatures) {
                    if (styleFeatures[f.getId()]) {
                      if (styleFeatures[f.getId()].scale) {
                        image.setScale(
                          Math.abs(styleFeatures[f.getId()].scale)
                        );
                      }
                    }
                  }
                } else {
                  image.setScale(Math.abs(scale));
                }
                //scale of text
                if (scale > 1) {
                  if (f.getId().indexOf('Annotation') == 0) {
                    style.getText().setScale(2);
                  } else {
                    style.getText().setScale(1);
                  }
                } else {
                  style.getText().setScale(scale + 0.2);
                }

                if (
                  f.getProperties() &&
                  f.getProperties().url &&
                  ~f.getProperties().url.indexOf('.svg')
                ) {
                  image.setScale(0.05);
                }
              } else {
                //Set Canalisations' text scale
                if (scale > 1) scale = 1;
                if (style.getText() != null)
                  style.getText().setScale(scale + 0.2);
              }

              if (zoom < 10) {
                if (style.getText() != null) style.getText().setScale(0);
              } else if (
                style.getText() &&
                f.getId().indexOf('Annotation') != 0
              ) {
                if (style.getText() != null)
                  style.getText().setScale(scope.displayTextStyle ? 1 : 0);
              } else if (
                style.getText() &&
                f.getId().indexOf('Annotation') == 0
              ) {
                if (style.getText() != null) style.getText().setScale(1);
              }

              // seulement si visible
              if (scope.categoryVisibility[currentCategory].v) {
                f.setStyle(style);
              } else {
                f.setStyle(new ol.style.Style({}));
              }

              elementsSource.changed();
            });
          };

          // listen zoom changed
          scope.map.getView().on('propertychange', function(e) {
            switch (e.key) {
              case 'resolution':
                resetScale();
                break;
            }
          });

          var watchfeatureParams = scope.$watch(
            'featureParams',
            function(fp) {
              if (scope.currentlyEditedFeature == -1) {
                return false;
              }

              if (scope.currentlyEditedFeature.indexOf('Canalisation') == 0) {
                return false;
              }

              elementsSource.getFeatures().forEach(function(f) {
                if (f.getId() == scope.currentlyEditedFeature) {
                  var style = getFeatureStyle(f);
                  var image = style.getImage();

                  image.setScale(Math.abs(fp.scale));
                  image.setRotation(fp.rotate * (Math.PI / 180));

                  f.setStyle(style);
                  elementsSource.changed();
                  if (!styleFeatures) {
                    styleFeatures = {};
                  }

                  styleFeatures[f.getId()] = {
                    scale: Math.abs(fp.scale),
                    rotate: fp.rotate,
                  };
                }
              });
            },
            1
          );

          var hiddenEfv2 = [];

          /**
           * les elements de filiere vectoriels qui ne doivent plus apparaitre dans le
           * flux wms car on a supprimé leur géométrie
           */
          var setHiddenEfv2 = function() {
            scope.map.getLayers().forEach(function(lay) {
              if (lay.get('id') == 'efLayerAll') {
                var source = lay.getSource();
                var params = source.getParams();
                params.t = new Date().getMilliseconds();
                var cqlFilter = '';
                for (var i = 0; i < 4; i++) {
                  cqlFilter += "id_filiere='" + scope.filiere.id + "'";
                  if (hiddenEfv2.length) {
                    cqlFilter +=
                      " AND NOT IN ('" + hiddenEfv2.join("','") + "'); ";
                  }
                  console.log(cqlFilter);
                }

                cqlFilter = cqlFilter.substring(0, cqlFilter.length - 2);
                console.log(cqlFilter);
                params.CQL_FILTER = cqlFilter;
                source.updateParams(lay);
              }
            });
          };
          var setHiddenCanav2 = function() {
            scope.map.getLayers().forEach(function(lay) {
              if (lay.get('id') == 'efCanalisations') {
                var source = lay.getSource();
                var params = source.getParams();
                params.t = new Date().getMilliseconds();
                var cqlFilter = "id_filiere='" + scope.filiere.id + "'";
                if (canasv2Asupprimer.length) {
                  cqlFilter +=
                    " AND NOT IN ('" + canasv2Asupprimer.join("','") + "') ";
                }
                console.log(cqlFilter);
                params.CQL_FILTER = cqlFilter;
                source.updateParams(lay);
              }
            });
          };

          var suppEfv2Dialog = null;
          var canasv2Asupprimer = [];
          /**
           * removeFeatureGeometry
           * @param category
           * @param element
           * @param index
           */
          scope.removeFeatureGeometry = function(category, element, index) {
            scope.map.removeInteraction(modify);
            scope.currentlyEditedFeature = -1;

            var isSuppressionEfv2 =
              scope.isFiliereVectorielle && category == 'element_filiere';
            if (!isSuppressionEfv2) {
              var suppressionDirecte =
                element.nom == 'Canalisations' ||
                element.nom == 'Annotation' ||
                element.nom == 'Image' ||
                element.nom.indexOf('Annotation_') == 0;
              var msg = !suppressionDirecte
                ? 'Supprimer la représentation de cet élément ?'
                : 'Supprimer cet élément ?';
              var ans = confirm(msg);
              if (ans) {
                if (suppressionDirecte) {
                  scope.displayElements[category].splice(index, 1);
                }

                elementsSource.getFeatures().forEach(function(f) {
                  if (f.getId() == element.feature.id) {
                    if (
                      angular.isDefined(element.feature.properties.id_efx_cana)
                    ) {
                      canasv2Asupprimer.push(
                        element.feature.properties.id_efx_cana
                      );
                      elementsSource.removeFeature(f);
                      delete element.feature.geometry;
                      setHiddenCanav2();
                      // cas des canalisations v2 qu'il faut aussi supprimer en base
                      scope.saveElementsFeatures();
                    } else {
                      elementsSource.removeFeature(f);
                      delete element.feature.geometry;
                    }
                  }
                });
              }
            } else {
              scope.suppressionDetails = {
                del_geometry: angular.isDefined(element.feature.geometry),
                geometry_gone: !angular.isDefined(element.feature.geometry),
                del_ef: !angular.isDefined(element.feature.geometry),
                ef: element,
                efIndex: index,
              };
              suppEfv2Dialog = ngDialog.open({
                template:
                  'js/XG/widgets/ancapp/main/views/modals/modal.supprimer_ef_v2.html',
                className:
                  'ngdialog-theme-plain error_dialog width600 miniclose nopadding',
                closeByDocument: false,
                scope: scope,
              });

              scope.map.removeInteraction(draw);
            }
          };

          /**
           * doRemoveEf
           */
          scope.doRemoveEf = function() {
            suppEfv2Dialog.close();

            if (scope.suppressionDetails.del_geometry) {
              // DESSIN_FILIERES_V2
              delete scope.suppressionDetails.ef.feature.geometry;
              elementsGeometrySource.getFeatures().forEach(function (f) {
                if (f.getId() == scope.suppressionDetails.ef.feature.id) {
                  // on ne remove pas de la source sans quoi il ne serait pas update en base
                  //elementsGeometrySource.removeFeature(f);
                  f.setGeometry(null);
                  // la geometrie est temporairement cachée dans le flux
                  hiddenEfv2.push(scope.suppressionDetails.ef.feature.id);
                  // permet de dessiner a nouveau
                  setHiddenEfv2();
                  // f.unset();
                  let ftname = f.getId().split('.')[0];
                  let fid = f.getId().split('.')[1];
                  if (ftname && fid) {
                    AncAppFactory.setNullGeomElementfiliere(fid,ftname).then(() => {
                      require('toastr').success(
                        'Supression de la représentation de cet élément ',
                        '',
                        {
                          positionClass: 'toast-bottom-left',
                        }
                      );
                    }).catch(e => {
                      require('toastr').error('échec de supression de la représentation de cet élément');
                      e.stack;
                    });
                  }
                }
              });
            }

            if (scope.suppressionDetails.del_ef) {
              var relation_id = false;
              var fid = scope.suppressionDetails.ef.feature.id;
              var ftname = fid.split('.')[0];

              scope.currentBranchData.children.forEach(function(x) {
                if (x.identifier == 'element_filiere') {
                  if (x.linkedElement.properties.feature_id == fid) {
                    relation_id = x.linkedElement.id;
                  }
                }
              });

              if (relation_id) {
                // supprime vraiment l'ef ainsi que l'entre dans le geojson
                AncAppFactory.removeelementfromfiliere(
                  relation_id,
                  ftname,
                  fid
                ).then(function() {
                  // doNotTriggerDirtyRF = true;
                  $rootScope.$broadcast('resetDossierArborescence', {
                    filiereId: scope.filiere.id,
                    doNotTriggerDirtyRF: true,
                    doNotResetCtrl: true,
                  });
                });

                scope.displayElements['element_filiere'].splice(
                  scope.suppressionDetails.efIndex,
                  1
                );
                refreshAndSetLayerEfVisibility();
                // alert('finir ca')
              }
            }
          };

          /**
           * saveElementsFeatures
           */
          scope.saveElementsFeatures = function(prepareJsonWithoutSaving) {
            var def = $q.defer();
            prepareJsonWithoutSaving = prepareJsonWithoutSaving || false;

            editFeatureExtrasSource.clear();

            var geojsonFiliere = {
              type: 'FeatureCollection',
              features: [],
            };

            // DESSIN_FILIERES_V2
            // la liste eventuelle des elements de filiere dont il faut mettre la geometrie a jour
            var updateEfQueries = [];
            elementsGeometrySource.getFeatures().forEach(function(f) {
              var ft = formatter.writeFeatureObject(f);
              // SAVE DANS LE GEOJSON
              // la geometrie enregistree est juste celle du point
              var _ft = formatter.readFeature(ft),
                _geom = _ft.getGeometry();
              if (_geom !== null) {
                var extent = _ft.getGeometry().getExtent();
                var x = extent[0] + (extent[2] - extent[0]) / 2,
                  y = extent[1] + (extent[3] - extent[1]) / 2;

                _ft.setGeometry(new ol.geom.Point([x, y]));
                geojsonFiliere.features.push(formatter.writeFeatureObject(_ft));
              }

              // updateEf en base
              var currentEfFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
                AncAppFactory.appCfg.main.datastore,
                ft.id.split('.')[0]
              );

              // ajout de la notion de filiere active et id_filiere
              ft.properties.filiere_active =
                scope.filiere.properties.etat == 'active' ? true : false;
              ft.properties.id_filiere = scope.filiere.id;

              // delete dans la feature et le geojson
              delete ft.properties.isNotSavedYet;
              var ftCopy = angular.copy(ft);

              // delete avant crud
              delete ftCopy.properties.isFilierev2;
              delete ftCopy.properties.category;

              if (!prepareJsonWithoutSaving) {
                ftCopy.properties = {};
                updateEfQueries.push(
                  EditFactory.updatespecifiedproperties(
                    currentEfFti.uid,
                    {
                      type: 'FeatureCollection',
                      features: [ftCopy],
                    },
                    scope.map
                      .getView()
                      .getProjection()
                      .getCode()
                  )
                );
              }
            });

            // Mise a jour de la geometrie des elements de filiere en base de données
            if (updateEfQueries.length) {
              $q.all(updateEfQueries).then(
                function(res) {
                  refreshAndSetLayerEfVisibility(1);
                },
                function() {
                  require('toastr').error(
                    'Erreur lors de la mise à jour de la géométrie des filières.',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                }
              );
            }

            // Mise à jour de la position de la filière
            var currentFiliereFeature = false;
            elementsSource.getFeatures().forEach(function(f) {
              var ft = formatter.writeFeatureObject(f);
              if (f.getId() == scope.filiere.id) {
                if (
                  angular.isDefined(f.properties) &&
                  angular.isDefined(f.properties.category)
                )
                  delete f.properties.category;
                currentFiliereFeature = ft;
              }
              geojsonFiliere.features.push(ft);
            });

            // Necessaire d'avoir placé la filiere pour sauvegarder
            if (!prepareJsonWithoutSaving && !currentFiliereFeature) {
              require('toastr').error(
                'Veuillez renseigner la position de la filière',
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
              return;
            }

            if (angular.isUndefined(srid))
              var srid = scope.map
                .getView()
                .getProjection()
                .getCode();

            // Mise a jour de la filiere en base
            if (currentFiliereFeature) {
              // suppression de la category
              if (
                angular.isDefined(currentFiliereFeature.properties) &&
                angular.isDefined(currentFiliereFeature.properties.category)
              )
                delete currentFiliereFeature.properties.category;

              if (!prepareJsonWithoutSaving) {
                EditFactory.update(
                  filiereFti.uid,
                  {
                    type: 'FeatureCollection',
                    features: [currentFiliereFeature],
                  },
                  srid
                ).then(function(res) {
                  // apply it to current filiere object
                  scope.filiere.geometry = currentFiliereFeature.geometry;
                });
              }
            }

            // DESSIN_FILIERES_V2
            var waitForRequestsCompletion = [];
            // canas a supprimer en base
            if (
              (!prepareJsonWithoutSaving || scope.isFiliereVectorielle) &&
              canasv2Asupprimer.length
            ) {
              for (let i in canasv2Asupprimer) {
                waitForRequestsCompletion.push(
                  EditFactory.remove(
                    'kis_anc_efx_canalisations',
                    canasv2Asupprimer[i]
                  ).then(
                    function() {
                      refreshAndSetLayerCanaVisibility();
                    },
                    function() {
                      require('toastr').error(
                        'Erreur lors de la suppression de la canalisation en base de données.',
                        '',
                        {
                          positionClass: 'toast-bottom-left',
                        }
                      );
                    }
                  )
                );
              }
            }
            // canas a inserer en base
            if (
              !prepareJsonWithoutSaving &&
              scope.isFiliereVectorielle &&
              geojsonFiliere.features.length
            ) {
              // recuperation des features concernees
              var efCanaToAdd = [];
              geojsonFiliere.features.forEach(function(f) {
                if (f.id.indexOf('Canalisation') != -1) {
                  efCanaToAdd.push({
                    featureGeoJson: f,
                    featureToPush: {
                      geometry: f.geometry,
                      properties: {
                        type: f.properties.type,
                        filiere_active:
                          scope.filiere.properties.etat == 'active'
                            ? true
                            : false,
                        id_filiere: scope.filiere.id,
                      },
                      // undefined si nouvelle cana
                      id: f.properties.id_efx_cana,
                    },
                  });
                }
              });

              // insere/update les canas en base
              if (efCanaToAdd.length) {
                var _err = function() {
                  require('toastr').error(
                    'Erreur.',
                    "Erreur lors de l'enregistrement de la canaliation en base de données",
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                };
                // @ES6 FTW, sans quoi le i du efCanaToAdd[i] plus bas est asynchrone et prend tjrs la valeur 0
                for (let i in efCanaToAdd) {
                  let toPushCana = gaJsUtils.setNewFeatureCollection(
                      efCanaToAdd[i].featureToPush
                    ),
                    _proj = scope.map
                      .getView()
                      .getProjection()
                      .getCode(),
                    isUpdate = angular.isDefined(
                      efCanaToAdd[i].featureToPush.id
                    ),
                    crudCanaPromise = isUpdate
                      ? EditFactory.update(
                          'kis_anc_efx_canalisations',
                          toPushCana,
                          _proj
                        )
                      : EditFactory.add(
                          'kis_anc_efx_canalisations',
                          toPushCana,
                          _proj
                        );

                  waitForRequestsCompletion.push(
                    crudCanaPromise.then(
                      function(res) {
                        if (res.data.create.length || res.data.update.length) {
                          // si insert
                          if (!isUpdate) {
                            // On insere l'id de la cana nouvellement crée dans le geojson
                            efCanaToAdd[
                              i
                            ].featureGeoJson.properties.id_efx_cana =
                              res.data.create[0].id;
                            // a mettre a jour aussi dans geometrysource
                            elementsSource.getFeatures().forEach(function(f) {
                              if (f.getId() == efCanaToAdd[i].featureGeoJson.id)
                                f.set('id_efx_cana', res.data.create[0].id);
                            });
                            // et dans le displayElements
                            scope.displayElements.canalisations.forEach(
                              function(e) {
                                if (
                                  e.feature.id ==
                                  efCanaToAdd[i].featureGeoJson.id
                                ) {
                                  e.feature.properties.id_efx_cana =
                                    res.data.create[0].id;
                                }
                              }
                            );
                          }
                        } else {
                          _err();
                        }
                      },
                      function() {
                        _err();
                      }
                    )
                  );
                }
              }
            }

            // on attend que les ids des cana reviennent du serveur (DESSIN_FILIERES_V2)
            $q.all(waitForRequestsCompletion).then(function() {
              canasv2Asupprimer = [];
              currentGeoJsonData = geojsonFiliere;

              var bbox = scope.map
                .getView()
                .calculateExtent(scope.map.getSize());

              var sendata = {
                collection: geojsonFiliere,
                style: styleFeatures,
                bbox: bbox,
                isFiliereVectorielle: scope.isFiliereVectorielle,
                cotationsV2: scope.cotationsV2,
              };

              console.log('----------------------');
              console.log(sendata.collection);

              // on ne fait que renvoyer le json pret a être sauvé
              if (prepareJsonWithoutSaving) {
                def.resolve(sendata);
                return;
              }

              if (typeof ancAppAndroid !== 'undefined') {
                var promise = AncAppFactory.addFiliereByid(
                  scope.filiere.id,
                  JSON.stringify(sendata)
                );
              } else {
                //var promise = ConfigFactory.add(sendata, '../../../BIZ/ANC/FILIERES_GEOJSON/' + scope.filiere.id,        "filiere.json", AncAppFactory.appCfg.appname);
                var promise = AncAppFactory.addrepresentationfilierejson(
                  sendata,
                  scope.filiere.id
                );
              }

              bkpCurrentGeoJsonData = angular.copy(sendata);

              // SAVE GEOJSON
              promise.then(
                function() {
                  //require('toastr').success("Geométrie de la filière enregistrée");
                  require('toastr').success(
                    'Représentation de la filière enregistrée',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );

                  // reset les layers
                  refreshAndSetLayerEfVisibility();
                  refreshAndSetLayerCanaVisibility();
                  scope.map.renderSync();
                  def.resolve();
                },
                function() {
                  def.reject();
                }
              );
            });

            $rootScope.$broadcast('updateCurrentFiliere', scope.filiere);

            return def.promise;
          };

          scope.createTooltipInCanvas = function(
            canvas,
            ctx,
            x,
            y,
            width,
            height,
            radius,
            fill,
            stroke,
            text,
            strokeStyle,
            fillStyle,
            fillStyleText,
            font,
            lineWidth
          ) {
            if (typeof stroke == 'undefined') {
              stroke = true;
            }

            ctx.beginPath();
            ctx.moveTo(x + radius, y);
            ctx.lineTo(x + width - radius, y);
            ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
            ctx.lineTo(x + width, y + height - radius);
            ctx.quadraticCurveTo(
              x + width,
              y + height,
              x + width - radius,
              y + height
            );

            ctx.lineTo(x + width / 2 - 5, y + height);
            ctx.lineTo(x + width / 2, y + height + 5);
            ctx.lineTo(x + width / 2 + 5, y + height);
            ctx.lineTo(x + radius, y + height);

            ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
            ctx.lineTo(x, y + radius);
            ctx.quadraticCurveTo(x, y, x + radius, y);

            ctx.strokeStyle = strokeStyle;
            ctx.lineWidth = lineWidth;
            ctx.fillStyle = fillStyle;

            if (stroke) {
              ctx.stroke();
            }

            if (fill) {
              ctx.fill();
            }

            ctx.closePath();

            ctx.font = font;
            ctx.textBaseline = 'middle';
            ctx.fillStyle = fillStyleText;

            let textString = text,
              textWidth = ctx.measureText(textString).width;

            ctx.fillText(
              textString,
              x + (width - textWidth) / 2,
              y + height / 2
            );
          };

          /**
           * saveRepAsImage
           */
          scope.saveRepAsImage = () => {
            // recup base 64 et save png
            scope.map.once('postcompose', (event) => {
              let canvas = event.context.canvas;
              let canvasContainer = canvas.getBoundingClientRect();

              let newCanvas = document.createElement('canvas');
              newCanvas.width = canvas.width;
              newCanvas.height = canvas.height;
              let context = newCanvas.getContext('2d');

              let ctx = event.context.canvas.getContext('2d');

              let imageData = ctx.getImageData(
                0,
                0,
                canvas.width,
                canvas.height
              );

              context.putImageData(imageData, 0, 0);
              const scaleX = canvas.width / canvasContainer.width;
              const scaleY = canvas.height / canvasContainer.height;;
              context.scale(scaleX, scaleY);

              let tooltips = document.querySelectorAll(
                'div.ol-overlay-container .tooltip.tooltip-static'
              );

              for (let i = 0; i < tooltips.length; i++) {
                let tooltip = tooltips[i].parentElement.getBoundingClientRect();
                scope.createTooltipInCanvas(
                  newCanvas,
                  context,
                  tooltip.left - canvasContainer.left,
                  tooltip.top - canvasContainer.top,
                  tooltip.width,
                  tooltip.height,
                  4,
                  true,
                  true,
                  tooltips[i].innerText,
                  'rgba(255, 255, 255, 0.7)',
                  'rgba(255, 204, 51, 0.7)',
                  'rgba(0, 0, 0, 0.7)',
                  "12px 'opensans', sans-serif",
                  1
                );
              }
              // reset scale and draw behind existing image
              context.setTransform(1, 0, 0, 1, 0, 0);
              context.globalCompositeOperation = 'destination-over';
              // add background
              context.fillStyle = 'white';
              context.fillRect(0, 0, canvas.width, canvas.height);
              // reset the context
              context.globalCompositeOperation = 'source-over';
              context.scale(scaleX, scaleY);

              let image = newCanvas.toDataURL('image/png');
              AncAppFactory.base64topng(image, scope.filiere.id).then(
                function() {
                  require('toastr').success(
                    'Plan généré et stocké dans les documents liés de la filière.',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                  if (angular.isDefined(scope.filiere.attachmentsNo)) {
                    scope.filiere.attachmentsNo += 1;
                  }
                }
              );
            });
            scope.map.renderSync();
          };

          /**
           * addDisplayElement
           * @param item
           * @param groupe
           * @param insertFirst
           */
          var addDisplayElement = function(item, category, insertFirst) {
            // stocke category
            if (
              !angular.isDefined(item.feature.properties) ||
              item.feature.properties == null
            )
              item.feature.properties = {};
            item.feature.properties.category = category;

            var tmpGroup = angular.copy(scope.displayElements);

            if (!angular.isDefined(tmpGroup)) tmpGroup = {};
            if (!angular.isDefined(tmpGroup[category])) tmpGroup[category] = [];

            if (insertFirst) {
              tmpGroup[category].splice(1, 0, item);
            } else {
              tmpGroup[category].push(item);
            }

            // sort
            if (
              angular.isDefined(tmpGroup['element_filiere']) &&
              tmpGroup['element_filiere'].length > 1
            ) {
              tmpGroup['element_filiere'] = AncAppFactory.sortElementsFiliere(
                tmpGroup['element_filiere'],
                'representation'
              );
            }
            // reaffect
            scope.displayElements = tmpGroup;
          };

          // get_keys pour trier la liste des catégories
          scope.get_keys = function(obj) {
            if (obj) return Object.keys(obj);
          };
          /**
           * orderCategories
           * @param category
           * @returns {number}
           */
          scope.orderCategories = function(category) {
            if (category == 'filiere') return 10;
            if (category == 'element_filiere') return 20;
            if (category == 'canalisations') return 30;
            return 100;
          };
          scope.renderCategoryName = function(category) {
            if (category == 'filiere') return 'Filière';
            if (category == 'element_filiere') return 'Eléments de filière';
            if (category == 'canalisations') return 'Canalisations';
            if (category == 'annotations') return 'Annotations';
            if (category == 'images') return 'Accessoires';
            return category;
          };

          /**
           * refresh the full elements list and layers
           */
          var panToPositionOnOpen = true;
          var currentGeoJsonData;
          scope.isFiliereVectorielle = filieresActivesDansConfigAppli
            ? true
            : false;
          scope.allowTransformEFToVectoriel = false;
          var elementFiliereDesc = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_element_filiere'
          );
          var infosStyleElements = {};
          var representationsVectorielles = {};
          var styleFeatures;
          var descriptionElementsFiliere = false;
          var bkpCurrentGeoJsonData = null;

          var dataLoadTime = 0;

          var refreshAll = function(saveAfterSet) {
            dataLoadTime = performance.now();

            // reset les layers
            refreshAndSetLayerEfVisibility(1);
            refreshAndSetLayerCanaVisibility(1);

            // init toutes les catégories
            scope.displayElements = {
              filiere: [],
              annotations: [],
              images: [],
              canalisations: [],
              element_filiere: [],
            };

            // DESSIN_FILIERES_V2
            var asynchLoadedElements = [];

            elementsSource.clear();
            elementsGeometrySource.clear();
            // used when an element is removed from the filiere
            var needToSave = false;

            // TODO : Faire tourner une seule fois cette requete ?
            QueryFactory.data(elementFiliereDesc.uid).then(function(res) {
              descriptionElementsFiliere = res.data;

              for (var i in res.data.features) {
                var props = res.data.features[i].properties;
                infosStyleElements[props.identifiant] = props.representation;
                representationsVectorielles[
                  props.identifiant
                ] = props.representation_vectorielle
                  ? props.representation_vectorielle.split(';')
                  : [];
              }

              addDisplayElement(
                {
                  nom: 'Filière',
                  typeInfo: 'POINT',
                  feature: angular.copy(scope.filiere),
                },
                'filiere'
              );

              // retrieve the geojson data
              if (typeof ancAppAndroid !== 'undefined') {
                var promise = AncAppFactory.getFiliere(scope.filiere.id);
              } else {
                var promise = AncAppFactory.getrepresentationfilierejson(
                  scope.filiere.id
                );
              }
              // Récupération des éléments de filiere
              promise.then(
                function(res) {
                  currentGeoJsonData = res.data.collection;

                  bkpCurrentGeoJsonData = angular.copy(res.data);

                  if (res.data != '')
                    scope.isFiliereVectorielle = res.data.isFiliereVectorielle
                      ? res.data.isFiliereVectorielle
                      : false;

                  styleFeatures = res.data.style;
                  if (res.data.bbox) {
                    scope.map.getView().fit(res.data.bbox, scope.map.getSize());
                    resetScale();
                  }

                  scope.schematiqueATransformer = [];

                  // got some
                  if (
                    currentGeoJsonData != '' &&
                    angular.isDefined(currentGeoJsonData) &&
                    angular.isDefined(currentGeoJsonData.features)
                  ) {
                    currentGeoJsonData.features.forEach(function(cf) {
                      if (!~cf.id.indexOf('kis_anc_dossier_filiere')) {
                        if (cf.id.indexOf('Annotation') == 0) {
                          addDisplayElement(
                            {
                              nom: cf.id,
                              typeInfo: 'Annotation',
                              feature: cf,
                            },
                            'annotations'
                          );
                        } else if (cf.id.indexOf('Accessoire') == 0) {
                          addDisplayElement(
                            {
                              nom: 'Image',
                              typeInfo: 'Image',
                              feature: cf,
                            },
                            'images'
                          );
                        } else if (cf.id.indexOf('Canalisation') == 0) {
                          addDisplayElement(
                            {
                              nom: 'Canalisations',
                              typeInfo: 'LINE',
                              feature: cf,
                            },
                            'canalisations'
                          );
                        } else {
                          // ONLY IF STILL PART OF FILIERE ELEMENTS !
                          var ftinfo = FeatureTypeFactory.getFeatureByNameAndDatastore(
                            AncAppFactory.appCfg.main.datastore,
                            cf.id.split('.')[0]
                          );
                          var stillPartOfFiliere = false;

                          scope.elements.forEach(function(e) {
                            if (e.properties.feature_id == cf.id)
                              stillPartOfFiliere = true;
                          });
                          if (scope.elements.length && !stillPartOfFiliere)
                            needToSave = true;

                          // ajout des ef
                          if (stillPartOfFiliere) {
                            // ef vectorisée
                            if (scope.isFiliereVectorielle) {
                              asynchLoadedElements.push(cf.id);

                              // recupère la vraie géométrie
                              QueryFactory.get(cf.id.split('.')[0], cf.id).then(
                                function(res) {
                                  if (res.data.features) {
                                    propsElemFiliere.push(
                                      angular.copy(res.data.features[0])
                                    );
                                    var v2ft = res.data.features[0];
                                    // w/e des properties pas utile de trimballer tout ca dans le json
                                    delete v2ft.properties;
                                    v2ft.properties = {
                                      isFilierev2: true,
                                    };

                                    addDisplayElement(
                                      {
                                        nom: ftinfo.alias,
                                        typeInfo: ftinfo.typeInfo,
                                        properties: {
                                          isFilierev2: true,
                                        },
                                        feature: v2ft,
                                      },
                                      'element_filiere',
                                      1
                                    );
                                  }

                                  $timeout(function() {
                                    refreshAndSetLayerEfVisibility(1);
                                  });

                                  // add it here ?
                                  elementsGeometrySource.addFeature(
                                    formatter.readFeature(v2ft)
                                  );
                                },
                                function() {
                                  console.log('Erreur recup feature');
                                }
                              );

                              // ancienne version issue du geojson
                            } else {
                              if (cf.geometry != null) {
                                scope.schematiqueATransformer.push(cf.id);
                              }

                              addDisplayElement(
                                {
                                  nom: ftinfo.alias,
                                  typeInfo: ftinfo.typeInfo,
                                  feature: cf,
                                },
                                'element_filiere',
                                1
                              );
                            }
                          }
                        }
                      }
                    });

                    scope.currentGeoJsonData = angular.copy(currentGeoJsonData);
                  }

                  scope.allowTransformEFToVectoriel =
                    filieresActivesDansConfigAppli &&
                    !scope.isFiliereVectorielle &&
                    scope.filiere.properties.etat == 'active' &&
                    scope.schematiqueATransformer.length;
                  // si rien a transformer on considere que c'est deja du vectoriel
                  if (
                    !scope.schematiqueATransformer.length &&
                    filieresActivesDansConfigAppli
                  ) {
                    scope.isFiliereVectorielle = true;
                  }

                  // ajout sur la map
                  for (var category in scope.displayElements) {
                    if (scope.displayElements[category].length) {
                      scope.displayElements[category].forEach(function(e) {
                        if (e.feature.geometry) {
                          var olFt = formatter.readFeature(e.feature);

                          // DESSIN_FILIERES_V2

                          //if (e.feature.id.indexOf('kis_anc_ef_') !== -1 && e.feature.properties && e.feature.properties.isFilierev2) {
                          if (
                            category == 'element_filiere' &&
                            scope.isFiliereVectorielle
                          ) {
                            // elementsGeometrySource.addFeature(olFt);
                          } else {
                            olFt.setStyle(getFeatureStyle(olFt));
                            elementsSource.addFeature(olFt);
                          }
                        }
                      });
                    }
                  }

                  resetScale();

                  // only once
                  if (panToPositionOnOpen) {
                    var view = scope.map.getView();
                    /*map.beforeRender(ol.animation.pan({
                                        duration: 500,
                                        source: (view.getCenter())
                                    }));*/
                    view.animate({
                      duration: 500,
                      source: view.getCenter(),
                    });

                    //  map.getView().fit(elementsSource.getExtent(), map.getSize());

                    panToPositionOnOpen = false;
                  }

                  if (needToSave) {
                    scope.saveElementsFeatures();
                  }

                  // adding new elements
                  if (!angular.isUndefined(scope.elements)) {
                    var displayIds = {};

                    for (var category in scope.displayElements) {
                      if (scope.displayElements[category].length) {
                        scope.displayElements[category].forEach(function(de) {
                          displayIds[de.feature.id] = category;
                        });
                      }
                    }

                    scope.elements.forEach(function(e) {
                      // new element indeed ! ~~

                      if (
                        !~Object.keys(displayIds).indexOf(
                          e.properties.feature_id
                        )
                      ) {
                        if (
                          asynchLoadedElements.indexOf(
                            e.properties.feature_id
                          ) == -1
                        ) {
                          var mFeat = FeatureTypeFactory.getFeatureByUid(
                            e.properties.feature_uid
                          );

                          addDisplayElement(
                            {
                              nom: mFeat.alias,
                              typeInfo: mFeat.typeInfo,
                              feature: {
                                properties: [],
                                id: e.properties.feature_id,
                              },
                            },
                            'element_filiere'
                          );
                        }
                      }
                    });
                  }
                  // gestion des cotations v2
                  if (angular.isDefined(res.data.cotationsV2)) {
                    scope.cotationsV2 = res.data.cotationsV2;
                    scope.$broadcast('loadDataIntoMesasureToolbar', {
                      data: res.data.cotationsV2,
                    });
                  }
                },
                function() {
                  require('toastr').error(
                    'Erreur lors du chargement de la représentation de la filière.',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                }
              );
            });
          };

          /**
           * transformEFToVectoriel
           */
          scope.transformEFToVectoriel = function() {
            swal(
              {
                title: 'Lancer la transformation ?',
                text:
                  "Les représentations vectorielles par défaut des éléments de filière remplaceront les représentations schématiques actuelles. Il vous faudra sans doute adapter la taille et l'orientation des éléments ainsi crées.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#DD6B55',
                confirmButtonText: 'Lancer',
                cancelButtonText: 'Annuler',
                closeOnConfirm: false,
              },
              function(isConfirm) {
                if (isConfirm) {
                  gaDomUtils.showGlobalLoader();

                  // transformation des ef, client-side
                  try {
                    elementsSource.getFeatures().forEach(function(f) {
                      if (
                        f.getGeometry() != null &&
                        f.getId().indexOf('kis_anc_ef') !== -1
                      ) {
                        var typeEf = f.getId().split('.')[0];
                        var descEf = descriptionElementsFiliere.features.filter(
                          function(x) {
                            return x.properties.identifiant == typeEf;
                          }
                        );

                        if (descEf.length) {
                          // recuperation des representation_vectorielle
                          var representation_vectorielle =
                            descEf[0].properties.representation_vectorielle;
                          if (representation_vectorielle == null)
                            throw "Pas de modele pour ce type d'element de filiere ?";

                          // coordonnées de l'ancienne feature
                          var coordinates = f.getGeometry().getCoordinates();
                          var choixVectoriel = representation_vectorielle.split(
                            ';'
                          );

                          // on recupere tjrs le premier ce n' est qu'apres qu'on propose de switcher entre plusieurs
                          getGeometryDepuisBibliothequeAnc(
                            choixVectoriel[0]
                          ).then(
                            function(res) {
                              // recuperation de le geometrie de ce type d'element de filiere et translation à la position du point cliqué
                              var mEfJson = res, // feature json
                                mEf = formatter.readFeature(mEfJson); // feature ol

                              var efBibliothequeXY = getCenterOfExtent(
                                mEf.getGeometry().getExtent()
                              );

                              mEf
                                .getGeometry()
                                .translate(
                                  coordinates[0] - efBibliothequeXY[0],
                                  coordinates[1] - efBibliothequeXY[1]
                                ); // deplace au bon endroit

                              var tmp = formatter.writeFeatureObject(f);

                              // met a jour la geometrie de notre element
                              var fixedFt = {
                                type: 'Feature',
                                // @TODO @TOFIX les features ajoutées directement ont leur propriété dans un tableau (refreshRepresentationDisplayElements)
                                // il faudrait fixer mais attention aux implications surtout pour le mobile...
                                // en attendant on laisse comme ça...
                                properties:
                                  angular.isArray(tmp.properties) &&
                                  angular.isDefined(tmp.properties[0])
                                    ? tmp.properties[0]
                                    : tmp.properties,
                                id: tmp.id,
                              };

                              fixedFt.properties.isNotSavedYet = true;

                              var elementOl = formatter.readFeature(fixedFt);
                              elementOl.setGeometry(mEf.getGeometry());

                              // au niveau du geojson on garde la geometrie du point dessine
                              // var formatted_drawn_feature = formatter.writeFeatureObject(e.feature);
                              // element.feature.geometry = formatted_drawn_feature.geometry;

                              // #ICI
                              //e.feature.setId(element.feature.id);
                              // e.feature.setProperties(element.feature.properties);
                              elementsGeometrySource.addFeature(elementOl);
                            },
                            function() {
                              require('toastr').error(
                                "Erreur lors de la récupération de la géométrie associée à ce type d'élément de filière",
                                '',
                                {
                                  positionClass: 'toast-bottom-left',
                                }
                              );
                            }
                          );

                          elementsSource.removeFeature(f);
                        } else {
                          throw "Pas de modele pour ce type d'element de filiere ?";
                        }
                      }
                    });

                    // clean source
                    //elementsSource.clear();

                    $timeout(function() {
                      scope.isFiliereVectorielle = true;
                      swal({
                        title: 'Transformation effectuée',
                        text: '',
                        type: 'success',
                        showCancelButton: false,
                        showConfirmButton: false,
                        timer: 3000,
                      });
                      scope.allowTransformEFToVectoriel = false;
                      gaDomUtils.hideGlobalLoader();
                    }, 1500);
                  } catch (e) {
                    console.log('%c  ' + e, 'background: #f00; color: #fff');
                    swal({
                      title: 'Erreur',
                      text:
                        "Une erreur s'est produite lors de la transformation des éléments de filière. (" +
                        e +
                        ')',
                      type: 'error',
                      showCancelButton: false,
                      showConfirmButton: false,
                      timer: 3000,
                    });
                    gaDomUtils.hideGlobalLoader();
                  }
                }
              }
            );
          };
          /**
           * Whenever elements are changed
           */
          refreshAll();
          var watchElements = scope.$watch('elements', function(elements) {
            if (angular.isUndefined(scope.filiere)) return false;
            // refreshAll();
          });

          var maj_representation_filiere = $rootScope.$on(
            'maj_representation_filiere',
            function(event, data) {
              if (data.fid == scope.filiere.id) {
                refreshAll();
                resetScale();
              }
            }
          );
          var watchFiliereId = scope.$watch('filiere.id', function(id, previd) {
            // refresh when the same partial is loaded for a different filiere
            if (
              angular.isDefined(id) &&
              angular.isDefined(previd) &&
              id != previd
            )
              refreshAll();
          });

          /**
           * afficher et cacher la description du icon
           */
          scope.displayTextStyle = false;
          scope.toggleText = function() {
            scope.displayTextStyle = !scope.displayTextStyle;

            elementsSource.getFeatures().forEach(function(f) {
              if (f.getId().indexOf('Annotation') == 0) {
                var style = getFeatureStyle(f);
                if (style.getText()) {
                  style.getText().setScale(1);
                  f.setStyle(style);
                  elementsSource.changed();
                }
              } else {
                var style = getFeatureStyle(f);

                if (style.getText()) {
                  style.getText().setScale(scope.displayTextStyle ? 1 : 0);
                  f.setStyle(style);
                  elementsSource.changed();
                }
              }
            });
            elementsGeometrySource.getFeatures().forEach(function(f) {
              // todo ?
            });
          };

          /**
           * retrieveLastid
           * @param type
           * @returns {number}
           */
          var retrieveLastid = function(type) {
            var tableau = [];
            var id = 0;

            if (angular.isDefined(scope.displayElements[type])) {
              scope.displayElements[type].forEach(function(e) {
                tableau = e.feature.id.split('_');
                if (parseInt(tableau[1]) > id) {
                  id = parseInt(tableau[1]);
                }
              });
            }

            id++;
            return id;
          };

          /**
           * add Canalisations
           */
          scope.addCanalisationv2 = function(type) {
            // on utilise le composant kis_anc_efx_canalisations

            var id_canalisation =
              'Canalisation_' + retrieveLastid('canalisations');
            var elem = {
              nom: 'Canalisations',
              typeInfo: 'LINE',
              feature: {
                id: id_canalisation,
                properties: {
                  type: type,
                },
              },
            };

            addDisplayElement(elem, 'canalisations');
            scope.newFeature(elem);
          };

          /**
           * add Annotation
           */
          scope.addAnnotation = function() {
            scope.currentAnnotation = {};
            var id_annotation = 'Annotation_' + retrieveLastid('annotations');

            var elem = {
              nom: id_annotation,
              typeInfo: 'Annotation',
              feature: {
                properties: {
                  label: scope.currentAnnotation.text,
                },
                id: id_annotation,
              },
            };

            addDisplayElement(elem, 'annotations');
            // scope.displayElements["annotations"].push(elem);
            scope.newFeature(elem);
          };

          /**
           * addDisplayElementFromCategory
           */
          scope.addDisplayElementFromCategory = function(c) {
            switch (c) {
              case 'annotations':
                scope.addAnnotation();
                break;
              case 'images':
                scope.addImage();
                break;
            }
          };

          /**
           * addImage
           */
          scope.addImage = function() {
            var id_image = 'Accessoire_' + retrieveLastid('images');
            var elem = {
              nom: id_image,
              typeInfo: 'Image',
              feature: {
                properties: {
                  url: '',
                },
                id: id_image,
              },
            };
            addDisplayElement(elem, 'images');
            scope.newFeature(elem);
          };

          scope.renderTypeFeature = function(currentlyEditedFeature) {
            if (currentlyEditedFeature != -1) {
              if (
                currentlyEditedFeature.indexOf('Canalisation') != 0 &&
                currentlyEditedFeature.indexOf('Annotation') != 0
              ) {
                return true;
              }
            }
          };

          /**
           * displayToolbarVectorielle
           * Détermine si on affiche la toolbar de modification vectorielle ou pas
           */
          scope.displayToolbarVectorielle = function() {
            if (!angular.isDefined(scope.editEfv2Cfg)) return false;

            if (
              scope.currentlyEditedFeature != -1 &&
              scope.isFiliereVectorielle
            ) {
              if (
                scope.currentlyEditedFeature.indexOf(
                  'kis_anc_dossier_filiere.'
                ) != 0 &&
                scope.currentlyEditedFeature.indexOf('Canalisation') != 0 &&
                scope.currentlyEditedFeature.indexOf('Annotation') != 0
              ) {
                return true;
              }
            }
            return false;
          };

          /**
           * renderNameCanalisations
           * @param element
           * @returns {string}
           */
          scope.renderNameCanalisations = function(element) {
            var id = element.feature.id;
            var value = id.split('_');

            if (value[2] && value[2].indexOf('cotation') == 0) {
              var name = value[2].split('.');
              return 'Cotation_' + name[1];
            } else {
              return element.feature.properties.type;
            }
          };

          /**
           * renderNameAnnotations
           * @param elem
           * @returns {string}
           */
          /*scope.renderNameAnnotations = function (elem) {
                        var value = elem.feature.id.split('.');
                        return 'Annotation_' + value[1];
                    };*/

          /*   scope.renderNameImages = function (id) {
                        var value = id.split('.');
                        return 'Image_' + value[1];
                    };*/

          /**
           * faire un dessin de polygon pour supprimer canalisations selectionnees
           */
          scope.featuresSelectionnees = [];
          scope.select_features = false;
          var draw_select, nouveauSource, nouveauLayer, lastSource;
          scope.selectCanalisattions = function() {
            scope.map.removeInteraction(draw_select);
            nouveauSource = new ol.source.Vector({});
            remove_source_dessin();
            if (scope.select_features == true) {
              scope.featuresSelectionnees = [];
              scope.select_features = false;
              return false;
            }
            scope.select_features = true;

            draw_select = new ol.interaction.Draw({
              source: sourceDessin,
              type: 'Polygon',
            });

            scope.map.addInteraction(draw_select);

            draw_select.on('drawend', function(evt) {
              remove_source_dessin();
              scope.featuresSelectionnees = [];

              var extent = evt.feature.getGeometry().getExtent();

              elementsSource.forEachFeatureIntersectingExtent(extent, function(
                feature
              ) {
                if (feature.getId().indexOf('kis_anc') == -1) {
                  scope.featuresSelectionnees.push(feature);
                }
                //AJOUTER TOUS LES FEATURES DANS LA SOURCE
                var geometry = feature.getGeometry();
                var coordinates = geometry.getCoordinates();

                // console.log(feature.getId());
                var nouveau_feature;
                if (feature.getId().indexOf('Annotation') == 0) {
                  nouveau_feature = new ol.Feature({
                    geometry: new ol.geom.Point(coordinates),
                  });
                } else {
                  nouveau_feature = new ol.Feature({
                    geometry: new ol.geom.LineString(coordinates),
                  });
                }
                console.log(nouveau_feature);
                nouveauSource.addFeature(nouveau_feature);
              });

              // CREER UN NOUVEAU LAYER POUR LES FEATURES CHOISIES
              nouveauLayer = new ol.layer.Vector({
                source: nouveauSource,
                style: new ol.style.Style({
                  fill: new ol.style.Fill({
                    color: 'yellow',
                  }),
                  stroke: new ol.style.Stroke({
                    color: 'yellow',
                    width: 2,
                  }),
                  image: new ol.style.Circle({
                    radius: 5,
                    fill: new ol.style.Fill({
                      color: 'yellow',
                    }),
                  }),
                }),
              });
              //AJOUTER LE LAYER DANS LA MAP
              nouveauLayer.setZIndex(9999);
              scope.map.addLayer(nouveauLayer);
              lastSource = nouveauLayer.getSource();

              var lastFeature = evt.feature;

              $timeout(function() {
                sourceDessin.removeFeature(lastFeature);
              }, 0);
            });
          };

          /**
           * supprimer canalisations selectionnees
           */
          scope.removeFeaturesSelected = function() {
            var ans;
            console.log(scope.featuresSelectionnees);
            if (scope.featuresSelectionnees.length == 1) {
              ans = confirm('Effacer la géométrie de cet élément ?');
            } else {
              ans = confirm(
                'Effacer la géométrie de ces ' +
                  scope.featuresSelectionnees.length +
                  ' éléments ?'
              );
            }

            if (ans) {
              scope.map.removeInteraction(draw_select);

              if (scope.select_features == true) {
                scope.select_features = false;
              }

              elementsSource.getFeatures().forEach(function(f) {
                scope.featuresSelectionnees.forEach(function(ff) {
                  if (ff.getId() == f.getId()) {
                    scope.displayElements.forEach(function(e) {
                      if (e.feature.id == ff.getId()) {
                        if (ff.getId().indexOf('kis_anc') == -1) {
                          elementsSource.removeFeature(f);
                          delete e.feature.geometry;
                        }
                      }
                    });
                  }
                });
              });
            }
            remove_source_dessin();
            scope.featuresSelectionnees = [];
          };

          /**
           * supprimer les dessins
           */
          var remove_source_dessin = function() {
            sourceDessin.clear();
            nouveauSource.clear();
            if (lastSource) {
              lastSource.clear();
            }
          };

          /**
           * mapConfig
           */
          scope.mapFeatureConfig = {};

          /**
           * Annotation Dialog
           */
          var AnnotationDialog;
          scope.currentAnnotation = {};
          scope.CurrentAnnotationElem = false;
          scope.openAnnotationDialog = function(elem) {
            scope.currentAnnotation = {};
            scope.CurrentAnnotationElem = elem;
            scope.currentAnnotation.text = '';
            if (elem.feature.properties && elem.feature.properties.label) {
              scope.currentAnnotation.text = elem.feature.properties.label;
            }
            AnnotationDialog = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.representationAnnotation.html',
              className: 'ngdialog-theme-plain width300 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
            });
          };

          var ImageDialog;
          scope.currentSelectedImage = {};
          scope.CurrentImageElem = false;
          scope.openImageDialog = function(elem) {
            scope.currentSelectedImage.url = elem.feature.properties.url;
            scope.CurrentImageElem = elem;
            ImageDialog = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.representationImage.html',
              className: 'ngdialog-theme-plain width800 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
            });
          };

          var filiereRepresentationImagesDialog;
          scope.currentFiliereRepresentationImages = [];
          scope.openFiliereRepresentationImagesDialog = function(elem) {
            var tmp = elem.feature.id.split('.');
            scope.currentFiliereRepresentationImages = infosStyleElements[
              tmp[0]
            ]
              .split(';')
              .filter(function(elem, index, self) {
                return index == self.indexOf(elem);
              });

            scope.currentFiliereRepresentation = elem;
            filiereRepresentationImagesDialog = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.filiereRepresentationImages.html',
              className: 'ngdialog-theme-plain width500 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
            });
          };

          scope.setFiliereRepresentationImage = function(url) {
            console.log(url);

            filiereRepresentationImagesDialog.close();
            var properties;
            scope.displayElements.element_filiere.forEach(function(e) {
              if (
                e.feature.id == scope.currentFiliereRepresentation.feature.id
              ) {
                if (!e.feature.properties) e.feature.properties = {};
                e.feature.properties.url = url;
                properties = e.feature.properties;
              }
            });

            elementsSource.getFeatures().forEach(function(f) {
              if (f.getId() == scope.currentFiliereRepresentation.feature.id) {
                var style = getElementFiliereStyle(url);
                style.getText().setText(scope.currentFiliereRepresentation.nom);
                f.setStyle(style);
                f.setProperties(properties);
                elementsSource.changed();
              }
            });

            resetScale();
            scope.currentFiliereRepresentation = {};
          };

          scope.setRepresentationImage = function(data) {
            ImageDialog.close();
            console.log(data);

            var properties;
            scope.displayElements['images'].forEach(function(e) {
              if (e.feature.id == scope.CurrentImageElem.feature.id) {
                e.feature.properties.url = data.url + '/' + data.img;
                properties = e.feature.properties;
              }
            });

            elementsSource.getFeatures().forEach(function(f) {
              if (f.getId() == scope.CurrentImageElem.feature.id) {
                var style = getElementFiliereStyle(data.url + '/' + data.img);
                var image = style.getImage();
                image.setScale(0.5);
                //  style.getText().setText('Image');
                f.setProperties(properties);
                f.setStyle(style);
                elementsSource.changed();
              }
            });
            resetScale();
            scope.currentSelectedImage = {};
          };

          /**
           * update Annotation
           */
          scope.updateAnnotation = function() {
            var properties;
            scope.displayElements['annotations'].forEach(function(e) {
              if (e.feature.id == scope.CurrentAnnotationElem.feature.id) {
                e.feature.properties.label = scope.currentAnnotation.text;
                properties = e.feature.properties;
              }
            });

            elementsSource.getFeatures().forEach(function(f) {
              if (f.getId() == scope.CurrentAnnotationElem.feature.id) {
                var style = getFeatureStyle(f);
                f.setProperties(properties);
                style.getText().setText(scope.currentAnnotation.text);
                f.setStyle(style);
                elementsSource.changed();
              }
            });

            AnnotationDialog.close();
            scope.currentAnnotation = {};
          };

          var refreshRepresentationDisplayElements = $rootScope.$on(
            'refreshRepresentationDisplayElements',
            function(event, data) {
              var ftinfo = FeatureTypeFactory.getFeatureByUid(data.uid);

              // TODO FIX THAT CRAP SOMEDAY ?!
              // pourquoi properties dans un tableau ?!?!
              addDisplayElement(
                {
                  nom: ftinfo.alias,
                  typeInfo: ftinfo.typeInfo,
                  feature: {
                    properties: [data.featureCollection.features[0].properties],
                    id: data.ftid,
                  },
                },
                'element_filiere',
                1
              );
              /*
                        if(!angular.isDefined(scope.displayElements["element_filiere"])) scope.displayElements["element_filiere"] = [];
                        scope.displayElements["element_filiere"].splice(scope.displayElements["element_filiere"].length - 1, 0, {
                            nom: ftinfo.alias,
                            typeInfo: ftinfo.typeInfo,
                            feature: {
                                properties: [data.featureCollection.features[0].properties],
                                id: data.ftid
                            }
                        });*/
            }
          );

          /**
           * set zIndex
           */
          elementsLayer.setZIndex(9900);
          scope.map.getLayers().insertAt(9900, elementsLayer);

          elementsGeometryLayer.setZIndex(9900);
          scope.map.getLayers().insertAt(9900, elementsGeometryLayer);

          layerDessin.setZIndex(9900);
          scope.map.getLayers().insertAt(9900, layerDessin);
          scope.currentMap = scope.map;
          scope.featuresConfig =
            AncAppFactory.appCfg.main.mapConfiguration.featuresConfig;

          /**
           * bloquer le dessin tant que la filière n'a pas été localisée
           */
          scope.bloquerDessin = function() {
            var bloque = true;

            try {
              if (
                angular.isDefined(
                  scope.displayElements.filiere[0].feature.geometry
                )
              )
                bloque = false;
            } catch (e) {}
            return bloque;
          };

          /**
           * is cotation
           * @param elem
           * @returns {boolean}
           */
          scope.isCotation = function(elem) {
            var res = false;
            if (elem.feature.id.indexOf('Canalisation_cotation') == 0) {
              res = true;
            }
            return res;
          };

          scope.hasSeveralImages = function(elem) {
            if (elem.properties && elem.properties.isFilierev2) return false;

            var res = false;
            var tmp = elem.feature.id.split('.');
            if (
              infosStyleElements[tmp[0]] &&
              infosStyleElements[tmp[0]].split(';').length > 1
            ) {
              res = true;
            }
            return res;
          };

          /**
           * isMultiRepresentations
           * verifie si plusieurs reprensentations vectorielles pour cet ef
           */
          scope.isMultiRepresentations = function() {
            try {
              var efType = scope.currentlyEditedFeature.split('.')[0];
              var reps = representationsVectorielles[efType];
              return reps.length > 1;
            } catch (e) {
              // err
            }
            return false;
          };

          scope.elementsGroups = function(elements) {
            if (!elements.length) return;

            var groups = {};
            elements.forEach(function(e) {
              if (!angular.isDefined(groups[e.group])) groups[e.group] = [];
              groups[e.group].push(e);
            });

            console.log(groups);
            //return elements;
            return groups;
          };

          /**
           * Mode déconnecté Android
           */
          if (typeof AppAndroid !== 'undefined') {
            if (AppAndroid.isNetworkAvailable())
              scope.map.getLayers().insertAt(0, OSMLayer);

            var positionStyle = new ol.style.Style({
              image: new ol.style.Icon({
                src: 'img/widget/gsw/gsw_01.png',
                scale: 1,
              }),
            });

            var parseGeoJSONPosition = function(json) {
              var response = null;
              if (json) {
                var position = JSON.parse(json);
                if (position && position.lon && position.lat) {
                  var coordinates = [
                    parseFloat(position.lon),
                    parseFloat(position.lat),
                  ];
                  var coordinatesProj = ol.proj.transform(
                    coordinates,
                    'EPSG:4326',
                    'EPSG:3857'
                  );

                  var point = new ol.geom.Point(coordinatesProj);

                  var feature = new ol.Feature({
                    geometry: point,
                  });

                  var source = new ol.source.Vector({
                    features: [feature],
                  });

                  var layer = new ol.layer.Vector({
                    source: source,
                    style: positionStyle,
                  });

                  response = layer;
                }
              }
              return response;
            };

            var upadteGeojsonPosition = function(json, layer) {
              var response = false;
              var position = JSON.parse(json);
              if (position && position.lon && position.lat) {
                var coordinates = [position.lon, parseFloat(position.lat)];
                var coordinatesProj = ol.proj.transform(
                  coordinates,
                  'EPSG:4326',
                  'EPSG:3857'
                );

                var point = new ol.geom.Point(coordinatesProj);

                layer.getSource().forEachFeature(function(feature) {
                  feature.setGeometry(point);
                  response = true;
                });
              }
              return response;
            };

            scope.gpsrunning = function() {
              var position = AppAndroid.getGpsPosition();
              if (position && !scope.userPosition) {
                scope.userPosition = parseGeoJSONPosition(position);
                if (scope.userPosition) {
                  scope.map.getLayers().insertAt(10, scope.userPosition);
                  scope.zoomonuseranddata();
                }
              } else if (
                position &&
                scope.userPosition &&
                scope.userPosition instanceof ol.layer.Vector
              ) {
                upadteGeojsonPosition(position, scope.userPosition);
              }
            };

            scope.zoomonuseranddata = function() {
              var extent;
              if (
                AncAppFactory.appCfg &&
                AncAppFactory.appCfg.main &&
                AncAppFactory.appCfg.main.mapConfiguration &&
                AncAppFactory.appCfg.main.mapConfiguration.bbox
              )
                var extentd = AncAppFactory.appCfg.main.mapConfiguration.bbox;

              if (
                scope.userPosition &&
                scope.userPosition.getSource() &&
                scope.userPosition.getSource().getExtent()
              )
                var extentp = scope.userPosition.getSource().getExtent();

              if (extentd && extentp)
                extent = ol.extent.extend(extentd, extentp);
              else if (extentd && !extentp) extent = extentd;
              else if (!extentd && extentp) extent = extentp;

              if (extent) scope.map.getView().fit(extent, scope.map.getSize());
            };

            var isNetworkRunning = function() {
              var networkAvailable = AppAndroid.isNetworkAvailable();
              var index = -1;
              scope.map.getLayers().forEach(function(layer, ind) {
                if (layer.getSource() instanceof ol.source.OSM) index = ind;
              });
              if (!networkAvailable) {
                if (index !== -1) scope.map.getLayers().removeAt(index);
              } else {
                if (index === -1) scope.map.getLayers().insertAt(0, OSMLayer);
              }
            };
            $interval(isNetworkRunning, 4000);
            var base64Prefix = 'data:image/png;base64,',
              emptyImage =
                'data:image/png;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
            var projection = ol.proj.get('EPSG:3857'),
              projectionExtent = projection.getExtent(),
              tileSize = 256;

            var maxResolution =
              ol.extent.getWidth(projectionExtent) / (tileSize * 2);
            var resolutions = [];
            var z;

            for (var z = 0; z < 31; ++z) {
              // generate resolutions and matrixIds arrays for this WMTS
              resolutions[z] = maxResolution / Math.pow(2, z);
            }

            scope.checkOrAddMbtiles = function(mbtilesname) {
              if (mbtilesname) {
                AppAndroid.setMbtilesName(mbtilesname);
                AppAndroid.checkOrCreateConnexionDb(mbtilesname);
                if (
                  !scope.mbtilesLayer ||
                  AppAndroid.getAppName() !== 'DOSSIER'
                ) {
                  var source = new ol.source.XYZ({
                    tileGrid: new ol.tilegrid.TileGrid({
                      origin: ol.extent.getBottomLeft(projectionExtent),
                      resolutions: resolutions,
                      extent: projectionExtent,
                    }),
                    tileUrlFunction: function(tileCoord) {
                      return '';
                    },
                    tileLoadFunction: function(imageTile, src) {
                      var tileCoord = imageTile.getTileCoord();
                      var z = tileCoord[0] + 1;
                      var x = tileCoord[1];
                      var y = tileCoord[2];

                      var base64src = AppAndroid.getBase64(x, y, z);
                      if (!base64src) {
                        imageTile.getImage().src = emptyImage;
                        return;
                      }

                      imageTile.getImage().src = base64Prefix + base64src;
                    },
                  });
                  scope.mbtilesLayer = new ol.layer.Tile({
                    source: source,
                  });

                  zoomToMbtiles();
                } else {
                  zoomToMbtiles();
                }
              }
            };

            scope.removeuserPosition = function() {
              if (scope.userPosition) {
                scope.map.removeLayer(scope.userPosition);
                scope.userPosition = null;
              }
            };

            scope.checkOrAddMbtiles(AppAndroid.mbtilesname);

            scope.removeMbtile = function() {
              if (scope.mbtilesLayer) scope.mbtilesLayer.setVisible(false);
            };

            var zoomToMbtiles = function() {
              var index = -1;
              var indexMbtiles = -1;
              scope.map.getLayers().forEach(function(layer, ind) {
                if (layer.getSource() instanceof ol.source.OSM) index = ind;
                else if (layer.getSource() instanceof ol.source.XYZ)
                  indexMbtiles = ind;
              });

              if (indexMbtiles !== -1) scope.mbtilesLayer.setVisible(true);
              else
                scope.map.getLayers().insertAt(index + 1, scope.mbtilesLayer);
              scope.map
                .getView()
                .fit(
                  ol.proj.transformExtent(
                    JSON.parse(AppAndroid.getExtent()),
                    'EPSG:4326',
                    'EPSG:3857'
                  ),
                  scope.map.getSize()
                );
            };
            /***
             * END MODE DECONNECTE
             */
          }

          var addElementModal;
          scope.addElemFilierePopup = function() {
            addElementModal = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.report.filiere_add_element.html',
              className: 'ngdialog-theme-plain width800 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
            });
          };

          scope.$on('closeAddElemPopup', function(event) {
            if (angular.isDefined(addElementModal) && addElementModal != null)
              addElementModal.close();
          });

          scope.dessinFiliereActive = true;
          scope.toggleFiliere = function() {
            scope.dessinFiliereActive = scope.dessinFiliereActive
              ? false
              : true;
            elementsLayer.setVisible(scope.dessinFiliereActive);
          };

          /**Tooltip affichage composant **/
          scope.tooltipTitle = {};
          scope.tooltipTitle.title = 'Afficher/Cacher';
          scope.tooltipTitle.class = 'cursorHelp';

          /**
           * Open modal copie de filière
           */
          var FilieresDialog;
          scope.openCopyFiliere = function() {
            if (angular.isDefined(scope.filieres) && scope.filieres.length)
              scope.filieresInactives = angular.copy(scope.filieres);

            for (var i = scope.filieresInactives.length - 1; i >= 0; i--) {
              if (scope.filieresInactives[i].properties.etat === 'active')
                scope.filieresInactives.splice(i, 1);
            }

            FilieresDialog = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.copyFiliere.html',
              className: 'ngdialog-theme-plain width600 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
            });
          };

          scope.copyFiliere = function(id_filiere) {
            var ans = confirm(
              'Êtes-vous certain de vouloir copier la dernière filière ?'
            );
            if (ans) {
              FilieresDialog.close();
              gaDomUtils.showGlobalLoader();
              var defer = true;
              var elementCopied = [];

              scope.filieres.forEach(function(f) {
                if (f.id == id_filiere)
                  Object.keys(f).forEach(function(e) {
                    if (e != 'id') scope.filiere[e] = f[e];
                  });
              });

              scope.filiere.properties.etat = 'active';

              AncAppFactory.copyselectedfiliere(
                scope.filiere.id,
                id_filiere,
                scope.reportId
              ).then(function() {
                $timeout(function() {
                  // delete scope.filiere.elements;
                  // delete scope.filiere.geometry;
                  $rootScope.$broadcast('maj_representation_filiere', {
                    fid: scope.filiere.id,
                  });
                });

                var obj = {
                  filiereId: scope.filiere.id,
                  doNotResetCtrl: true,
                };
                $rootScope.$broadcast('resetDossierArborescence', {
                  doNotTriggerDirtyRF: true,
                  doNotResetCtrl: false,
                });

                gaDomUtils.hideGlobalLoader();
              });
            }
          };

          scope.resetAllFiliereElement = function() {
            var ans = confirm(
              'Êtes-vous certain de vouloir réinitialiser la filière ?'
            );
            if (ans) {
              gaDomUtils.showGlobalLoader();

              AncAppFactory.resetfiliere(scope.filiere.id).then(function() {
                $timeout(function() {
                  scope.deleteCotations(true);
                  delete scope.filiere.elements;
                  delete scope.filiere.geometry;
                  // maj manuelle du geojson
                  $rootScope.$broadcast('maj_representation_filiere', {
                    fid: scope.filiere.id,
                  });
                });

                $rootScope.$broadcast('resetDossierArborescence', {
                  doNotTriggerDirtyRF: true,
                  doNotResetCtrl: true,
                  filiereId: scope.filiere.id,
                });

                gaDomUtils.hideGlobalLoader();
              });
            }
          };

          scope.stripName = function(nom) {
            if (nom.length > 30) return nom.substr(0, 30) + '...';
            else return nom;
          };

          // var convertAsGeoJson = function (elems) {
          //     var geojsonFiliere = {
          //             type: "FeatureCollection",
          //             features: []
          //     };
          //     elems.forEach(function (f) {
          //         var ft
          //         if(angular.isDefined(f.getId))
          //             ft = formatter.writeFeatureObject(f);
          //         else
          //             ft = f

          //         // Delete properties
          //         if(angular.isDefined(ft.properties)) {
          //             delete ft.properties;
          //         }

          //         var _ft = (formatter.readFeature(ft)),
          //             _geom = _ft.getGeometry();

          //         if (_geom !== null) {
          //             var extent = _ft.getGeometry().getExtent();
          //             var x = extent[0] + (extent[2] - extent[0]) / 2,
          //                 y = extent[1] + (extent[3] - extent[1]) / 2;

          //             _ft.setGeometry(new ol.geom.Point([x, y]))
          //             geojsonFiliere.features.push(formatter.writeFeatureObject(_ft));

          //         }
          //     });

          //     return geojsonFiliere

          // }

          /**
           * verification des modifications apportées a la filiere
           */
          var deregCheckDirty = $rootScope.$on('check_dirty_rf', function() {
            if (scope.bloquerDessin()) {
              $timeout(function() {
                $rootScope.$broadcast('resolve_change_rf');
              });
              return;
            }

            // si l'utilisateur change trop vite dans l'aborescence,
            // il se peut que les donnees ne soient pas completement chargées et que le compare échoue
            // on laisse 1 sec max a la branche le temps de se charger
            var timeElaspedSinceLoad = performance.now() - dataLoadTime;
            var timeOutDuration =
              timeElaspedSinceLoad < 1000 ? 1000 - timeElaspedSinceLoad : 0;

            $timeout(function() {
              scope.saveElementsFeatures(true).then(function(res) {
                console.log('check_dirty_rf');

                // comparaison des deux objets
                var cmp1 = gaJsUtils.removeEmpty(
                  angular.copy(bkpCurrentGeoJsonData)
                );
                var cmp2 = gaJsUtils.removeEmpty(angular.copy(res));

                // si user toggle tres vite (spam changement de branche)
                // cmp1 est null (pas encore chargé), dans ce cas on resolve direct
                if (cmp1 == null) {
                  $timeout(function() {
                    $rootScope.$broadcast('resolve_change_rf');
                  });
                  return;
                }

                // on ne verifie pas la bbox qui change a chaque pan/zoom
                delete cmp1.bbox;
                delete cmp2.bbox;

                // on ne s'interesse pas aux proprietes des elements de filiere qui peuvent changer (isNotSavedYet, isFilierev2 ...)
                // mais qui sont temporaires
                try {
                  cmp1.collection.features.forEach(function(x) {
                    if (x.id.indexOf('kis_anc_ef') == 0) delete x.properties;
                  });
                  cmp2.collection.features.forEach(function(x) {
                    if (x.id.indexOf('kis_anc_ef') == 0) delete x.properties;
                  });
                } catch (e) {}

                var canResolve = true;
                if (JSON.stringify(cmp1) != JSON.stringify(cmp2)) {
                  if (
                    confirm(
                      'Enregistrer les modifications apportées à la représentation de la filière ?'
                    )
                  ) {
                    canResolve = false;
                    scope.saveElementsFeatures().then(function() {
                      $timeout(function() {
                        $rootScope.$broadcast('resolve_change_rf');
                      });
                    });
                  }
                }
                if (canResolve)
                  $timeout(function() {
                    $rootScope.$broadcast('resolve_change_rf');
                  });
              });
            }, timeOutDuration);
          });

          /**
           * Mise a jour de la valeur d'une cotation
           */
          scope.cotationValueDisplay = {};
          scope.editCotationValue = function(idx, cotation) {
            scope.cotationValueDisplay[idx] = !scope.cotationValueDisplay[idx];
            if (!scope.cotationValueDisplay[idx]) {
              $timeout(function() {
                $('[data-uniqid=' + cotation.properties.uid + ']').html(
                  cotation.properties.distance
                );
              });
            }
          };
          // gestion des cotations v2
          scope.$on('measureToolbarDrawEnd', function(event, args) {
            scope.cotationsV2 = [];
            for (var i in args.data) {
              var jsonFt = formatter.writeFeatureObject(args.data[i]);
              scope.cotationsV2.push(jsonFt);
            }
          });

          scope.deleteCotations = function(force) {
            if (!scope.cotationsV2.length) return;
            var ans = force || confirm('Supprimer toutes les cotations ?');
            if (ans) scope.cotationsV2 = [];
            scope.$broadcast('loadDataIntoMesasureToolbar', {
              data: scope.cotationsV2,
            });
          };

          /**
           * removeCotationById
           */
          scope.removeCotationById = function(cotation) {
            if (angular.isDefined(cotation.properties.uid)) {
              scope.cotationsV2 = scope.cotationsV2.filter(function(x) {
                return x.properties.uid != cotation.properties.uid;
              });
              scope.$broadcast('loadDataIntoMesasureToolbar', {
                data: scope.cotationsV2,
              });
            } else {
              console.log(
                '%c  impossible de supprimer cette cotation ?!?!',
                'background: #f00; color: #fff'
              );
            }
          };

          // cleanup
          scope.$on('$destroy', function() {
            watchfeatureParams();
            watchFiliereId();
            watchElements();
            maj_representation_filiere();
            refreshRepresentationDisplayElements();
            deregCheckDirty();
          });

          scope.scaleValueList = [
            { value: 100, label: '100' },
            { value: 250, label: '250' },
            { value: 300, label: '300' },
            { value: 500, label: '500' },
            { value: 1000, label: '1000' },
          ];

          // ugly af !!
          $timeout(function() {
            $('#toolbar_measuredirective_popover').attr('title', 'Côter');

            $('#toolbar_measuredirective_popover').click(() => {

              // supprime la tooltip des outils de mesure qui persistait même après avoir désactivé le bouton du compas
              const tooltipContainer = $('.ol-overlay-container > div.tooltip:contains("Cliquer pour commencer")');
              if (tooltipContainer.length > 0) {
                $(tooltipContainer).hide();
              }

              // prévient le décalage du point de dessin (cercle jaune) causé par la suppression de la pté CSS "position=static" de la carte
              // provoquée par $rootScope.$broadcast('gcChangeCursorMap', '') exécuté depuis bizeditwidget
              // Bien qu'une condition soit déjà présente dans le $on() de gcmap pour éviter ce problème,
              // ce test assure qu'au clic la carte soit prête à la mesure
              if (!($('#rf_map').hasClass('rf_map'))){
                $('#rf_map').addClass('rf_map');
              }
            });
          }, 1000);
        },
      },
    };
  };

  representationFiliere.$inject = [
    'QueryFactory',
    'FeatureTypeFactory',
    'EditFactory',
    'gaDomUtils',
    '$timeout',
    'AncAppFactory',
    '$rootScope',
    '$q',
    'ngDialog',
    '$interval',
    'BaseMapFactory',
    'gclayers',
    'gcFeatureGeometryEditor',
    'gaJsUtils',
    'PortalsFactory',
  ];
  return representationFiliere;
});
