'use strict';
define(function() {
  var listeDossiers = function(
    AncAppFactory,
    BacAppFactory,
    ApplicationFactory,
    FeatureTypeFactory,
    $filter,
    $rootScope,
    ngDialog,
    gaDomUtils,
    FeatureHistoryFactory,
    $timeout,
    QueryFactory,
    EditFactory,
    $sce,
    DocumentFactory,
    $q,
    CalendarFactory,
    gaJsUtils,
    UsersFactory,
    $location,
    FeatureAttachmentFactory,
    uiCalendarConfig,
    $interval,
    ancBacTools,
    DataStoreFactory,
    ConfigFactory,
    kisCalendarFactory,
    OmegaFactory,
    dateUtils,
    HtmlUtils,
    gclayers
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/liste_dossiers.html',
      restrict: 'EA',
      scope: {
        type: '=',
        appname: '=?',
        datatableHeight: '=?',
        map: '=?',
        mobile: '=?',
        externalDossierFilter: '=?',
        idsfilter: '=?',
        globalfilter: '=?',
        res: '=?',
        canDeleteControleAnc: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        // Plage des valeurs pour les durées de rendez-vous
        scope.valueTimesRdv = [15,30,45,60,75,90,105,120,135,150,165,180]
        // fti de composnat  kis_anc_listes_deroulantes_controles
        scope.kis_anc_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
          'kis_anc_listes_deroulantes_controles'
        );

        /**
         * nombre des lignes a afficher dans le tableau de la liste des dossiers
         */
        scope.startCount = AncAppFactory.appCfg.main.properties.gcDataTableCount;

        let dossierDateNames = [
          'alerte_echeance',
          'date_creation',
          'date_raccordement',
          'date_dernier_controle',
          'date_prochain_controle',
          'date_etat_raccordement',
          'date_derogation',
          'date_prochain_controle_preconise',
          'date_deliberation_zonage',
          'date_filiere_anc',
          'date_debut_derogation',
        ];
        let vidangeDateNames = ['date_controle', 'date_creation'];
        scope.documentsCheckedForMail = [];

        if (typeof ancAppAndroid == 'undefined') {
          scope.appCfgProperties = angular.copy(
            AncAppFactory.appCfg.main.properties
          );
        }
        DataStoreFactory.get();
        // Modifier les filières en fonction des rôles
        scope.canModifyFiliere = () =>{
          if($rootScope.xgos.user.roles.findIndex((x) => x.name == "ANC_responsable" || x.name == "rootUser") != -1) {
            return false;
          } else {
            return true;
          }
        }


        scope.canDeleteControleAnc = () => {
          if($rootScope.xgos.user.roles.findIndex((x) => x.name == "ANC_responsable" || x.name == "rootUser") != -1) {
            return false;
          } else {
            return true;
          }
        }

        /*
         * cache la prise de rdv et autres actions sur les tablettes, en acces
         * direct ou via appli android
         */
        scope.isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(
          navigator.userAgent
        );
        /* access depuis browser seulement, pas appli android */
        scope.isMobileBrowser =
          scope.isMobile && typeof ancAppAndroid == 'undefined';

        if (scope.isMobileBrowser) {
          navigator.connection.addEventListener('change', logNetworkInfo);

          scope.networkInformationData = {};
          function logNetworkInfo() {
            scope.networkInformationData.type = navigator.connection.type;
            scope.networkInformationData.downlink =
              navigator.connection.downlink;
            scope.networkInformationData.rtt = navigator.connection.rtt;
            scope.networkInformationData.downlinkMax =
              navigator.connection.downlinkMax;
            scope.networkInformationData.effectiveType =
              navigator.connection.effectiveType;
            scope.networkInformationData.saveData =
              navigator.connection.saveData;
          }

          logNetworkInfo();
        }

        scope.activePanancGrille =
          AncAppFactory.appCfg.main.properties.activePanancGrille;
        if (typeof ancAppAndroid == 'undefined') {
          scope.priseRDV = AncAppFactory.appCfg.main.properties.priseRdv;
        }
        if (typeof ancAppAndroid !== 'undefined') {
          scope.ancAppAndroid = ancAppAndroid;
          gaDomUtils.showGlobalLoader();
        }

        scope.feedModeDossier = true;
        scope.displayFeedDossier = false;
        if (scope.displayFeedDossier == false) {
          $('.feederKey')
            .parent()
            .remove();
          $('.feederKey').remove();
        }

        try {
          if (typeof ancAppAndroid !== 'undefined') {
            scope.notournee = ancAppAndroid.checkTourneeExist();
            if (scope.notournee) {
              gaDomUtils.hideGlobalLoader();
              return;
            }
          }

          if (!angular.isDefined(scope.datatableHeight)) {
            scope.datatableHeight = '1000px';
          }
          if (
            typeof userAndroid !== 'undefined' &&
            typeof cfgandroid !== 'undefined'
          ) {
            scope.cfgandroid = cfgandroid;
            $rootScope.xgos = { user: {} };
            var user = userAndroid.getUser();
            if (!user || user === 'ERROR') {
              AppAndroid.setConf(false);
            } else {
              AppAndroid.setConf(true);
            }
            $rootScope.xgos.user = JSON.parse(user);
            AncAppFactory.appCfg = { main: {}, appName: 'anc' };
            AncAppFactory.appCfg.main = JSON.parse(
              cfgandroid.get('main', 'mainConfig', 'anc')
            );
            AncAppFactory.initappCfg(AncAppFactory.appCfg);
          }
          scope.dossierBbox = AncAppFactory.appCfg.main.mapConfiguration.bbox;
          scope.avisCtrl = angular.copy(
            AncAppFactory.appCfg.main.dossierCfg.avisControles
          );
          scope.activeRdv =
            AncAppFactory.appCfg.main.properties.priseRdv.active;
          var needToAddVidange =
            AncAppFactory.appCfg.main.properties.formVidange;

          var filiereFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_dossier_filiere'
          );
          var elementFiliereFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_dossier_filiere_element'
          );
          var controleFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_dossier_controle'
          );
          var cahierFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_dossier_cahier_de_vie'
          );
          scope.vidangeFormFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_vidange_formulaire'
          );
          scope.subventionFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_dossier_subvention'
          );

          AncAppFactory.getElementFiliereData('type').then(function(res) {
            scope.listeTypeFilieres = res.data.features;
          });
          AncAppFactory.getElementFiliereData('element').then(function(res) {
            scope.listeElementsFilieres = res.data.features;
          });

          scope.parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            AncAppFactory.appCfg.main.parcellesCfg.emplacement
          );
          scope.controleFti = controleFti;
          if (filiereFti) scope.filiereFti = filiereFti;
        } catch (e) {
          e.stack;
          if (typeof ancAppAndroid !== 'undefined')
            gaDomUtils.hideGlobalLoader();
        }
        // utilise pour ordonner les elements de filiere
        AncAppFactory.setListeElementsFiliere();

        /***********************************************************************
         * LISTE DES DOSSIERS
         **********************************************************************/

        scope.dossierFti = angular.copy(
          FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_dossier'
          )
        );

        var listeDossiersCfg = AncAppFactory.getListeDossiersCfg(
          scope.dossierFti
        );

        scope.dossierAttributes = listeDossiersCfg['attributes'];
        scope.buttonEditIcon = listeDossiersCfg['editButton'];
        scope.renduTitleColonneDossier =
          listeDossiersCfg['renduTitleColonneDossier'];
        scope.renduColonnesEtatDossier =
          listeDossiersCfg['renduColonnesEtatDossier'];
        scope.filterRender = listeDossiersCfg['filterRender'];
        scope.extraFilterRender = listeDossiersCfg['extraFilterRender'];
        scope.choixStatutRDV = AncAppFactory.getChoixStatutRDV();

        scope.dossierAttributesRaccordes =
          listeDossiersCfg['attributes_raccordes'];

        var listeDesVillesActives = AncAppFactory.appCfg.main.infosSpancListeVillesCfg.filter(
          function(x) {
            return x.gere_spanc;
          }
        );

        scope.controleAttributes = [];

        if (Array.isArray(controleFti.attributes)) {
          controleFti.attributes.forEach(function(att) {
            if (
              ~[
                'type',
                'agent',
                'etat',
                'date_saisie_controle',
                'date_passage',
                'date_passage_rdv',
                'date_avis',
                'statut_facture',
                'statut_rdv',
                'subvention',
              ].indexOf(att.name)
            ) {
              scope.controleAttributes.push(att);
            }
          });
        }


        scope.typesControle = AncAppFactory.appCfg.main.controleCfg;

        scope.typesVidanges =
          AncAppFactory.appCfg.main.properties.vidangeDocumentsCfg.document_types;
        scope.typesSubvention =
          AncAppFactory.appCfg.main.properties.subventionDocumentsCfg.document_types;

        scope.reportTabs = [
          {
            title: 'Tous les dossiers',
            key: 'tous',
          },
        ];

        scope.typesControle.forEach(function(tc) {
          scope.reportTabs.push({
            title: tc.label_court,
            key: tc.type,
          });
        });

        scope.allCtrlConfig = {};
        AncAppFactory.getAllCtrlFormCfg().then(function(res) {
          scope.allCtrlConfig = res.data;
        });

        // add vidange factu si objet de conf existe et est vrai
        if (
          angular.isDefined(AncAppFactory.appCfg.main.properties.formVidange) &&
          AncAppFactory.appCfg.main.properties.formVidange == true
        ) {
          scope.reportTabs.push({
            title: 'Vidanges',
            key: 'vidange_factu',
          });
        }

        scope.reportTabs.activeTab = 0;
        if ($location.hash() != null && $location.hash() == 'recherche_anc') {
          scope.reportTabs.activeTab = scope.reportTabs.length;
        }

        scope.reportsLength = { v: -1 };

        /**
         * store the reports id returned by elasticsearch to feed the datatable *
         */
        scope.restrictFtids = [scope.dossierFti.uid, controleFti.uid];
        scope.filterfti = { x: {} };
        scope.advancedFiltersResult = { res: {} };
        var filteredReportsIds = [];
        var setFilteredReportsIds = function() {
          filteredReportsIds = [];
          if (
            scope.reportTabs[scope.reportTabs.activeTab] &&
            scope.reportTabs[scope.reportTabs.activeTab].key ==
              'advanced_filters'
          ) {
            // controle / dossier ?
            var deregWatchFilters = scope.$watch(
              'advancedFiltersResult',
              function(af) {
                if (af.res.totalFeatures > 0) {
                  filteredReportsIds = af.res.features.map(function(f) {
                    return f.id;
                  });
                }
                scope.refreshReports();
              },
              1
            );
          } else {
            if (deregWatchFilters) deregWatchFilters();
          }
        };

        scope.controleTableActions = [
          {
            label: 'btn',
            btnclass: 'default',
            cfg: {
              iconOrLabel: 'icon',
              label: 'Afficher',
              size: 'btn-xs',
            },
          },
        ];

        scope.clickOnControle = function(expr, controle) {
          var controle_id = controle.id;
          var dossier_id = controle.properties.ref_dossier;

          gaDomUtils.showGlobalLoader();
          AncAppFactory.getdossier(dossier_id).then(function(res) {
            gaDomUtils.hideGlobalLoader();
            scope.editReport(res.data.features[0], false, controle_id);
          });
        };

        /**
         * refreshCurrentReport
         *
         * @returns {*}
         */
        scope.refreshCurrentReport = function() {
          if (
            angular.isDefined(scope.currentReport) &&
            angular.isDefined(scope.currentReport.id)
          ) {
            AncAppFactory.getdossier(scope.currentReport.id).then(function(
              res
            ) {
              var report = res.data.features[0],
                props = report.properties;
              scope.currentReportTitle = $sce.trustAsHtml(
                ancBacTools.setDossierFullname(
                  report,
                  'anc',
                  initCopyReportButton,
                  $location
                )
              );
              dateUtils.convertAllDatesToDateString(props, dossierDateNames);
              scope.currentReport.properties = props;
            });
          }
        };

        /**
         * refreshReports
         *
         * @param noselfrefresh
         */
        scope.refreshReports = function(noselfrefresh) {
          if (!noselfrefresh) {
            scope.refreshCurrentReport();
          }
          $rootScope.$broadcast('reloadDatatable');
        };

        /**
         * when a tab is selected
         */
        scope.$watch('reportTabs.activeTab', function(tab) {
          setFilteredReportsIds();
          if (angular.isDefined(tab)) scope.refreshReports(1);
        });

        // refresh list des dossiers lorsqu'event est modifie
        scope.$on('kis_calendar_event_refresh', function() {
          scope.refreshReports();
        });

        scope.dossierFilterBtn = { v: 'en_cours' };
        scope.innerWhere = false;
        scope.externalWhere = false;

        var setDataTableWhere = function() {
          scope.listeDossiersWhere = scope.innerWhere || '1=1'; // +
          if (scope.externalWhere) {
            scope.listeDossiersWhere =
              scope.listeDossiersWhere + ' AND ' + scope.externalWhere;
          }
        };

        scope.$watch(
          'dossierFilterBtn.v',
          function(v) {
            scope.innerWhere = false;
            if (v) {
              if (v != 'filtregeo') {
                scope.innerWhere = 'etat_dossier = \'' + v + '\'';
                setDataTableWhere();
              } else {
                var coll = scope.result.selectedDossiers;
                if (coll && coll.features.length) {
                  var feats = coll.features;
                  var refs = [];
                  var ids = [];
                  for (var j = 0; j < feats.length; j++) {
                    var id = feats[j].id.split('.')[1];
                    refs.push(feats[j].properties.ref_dossier);
                    ids.push(id);
                  }
                  scope.innerWhere = false;
                  scope.innerWhere = 'IN (\'' + ids.join('\',\'') + '\')';
                  setDataTableWhere();
                } else {
                  scope.innerWhere = false;
                }
              }
            }
          },
          1
        );

        scope.$watch('externalDossierFilter', function(edf) {
          scope.externalWhere = false;
          if (angular.isDefined(edf)) {
            if (edf) {
              scope.externalWhere =
                'ref_dossier IN (\'' + edf.join('\',\'') + '\')';
            }
            setDataTableWhere();
          }
        });

        scope.$watch('idsfilter', function(edf) {
          scope.externalWhere = false;
          if (angular.isDefined(edf)) {
            if (edf) {
              scope.externalWhere = ' IN (\'' + edf.join('\',\'') + '\')';
            }
            setDataTableWhere();
          }
        });

        scope.$watch('globalfilter', function(edf) {
          scope.externalWhere = false;
          if (angular.isDefined(edf)) {
            if (edf) {
              scope.externalWhere = edf;
            }
            setDataTableWhere();
          }
        });

        scope.$watch('result.selectedDossiers', function(coll) {
          if (angular.isDefined(coll)) {
            if (scope.dossierFilterBtn.v !== 'filtregeo') {
              scope.dossierFilterBtn.v = 'filtregeo';
            } else {
              var feats = coll.features;
              if (feats) {
                var refs = [];
                var ids = [];
                for (var j = 0; j < feats.length; j++) {
                  var id = feats[j].id.split('.')[1];
                  ids.push(id);
                  refs.push(feats[j].properties.ref_dossier);
                }
                scope.innerWhere = false;
                scope.innerWhere = 'IN (\'' + ids.join('\',\'') + '\')';
                setDataTableWhere();
              }
            }
          }
        });

        /**
         * function passed to the datable to retrieve dossiers data
         *
         * @param p
         * @returns {*}
         */
        scope.getReports = function(p) {
          var restrictedIds = filteredReportsIds.join(',');
          if (p) {
            scope.dataTableParams = p;
            if (p.force_restricted_ids) restrictedIds = p.force_restricted_ids;
          }
          var filtreControle = scope.reportTabs[scope.reportTabs.activeTab].key;
        
          // advanced filters
          if (filtreControle === 'advanced_filters') {
            filtreControle = 'tous';
          }

          try {
            if (typeof ProgressionAndroid !== 'undefined')
              ProgressionAndroid.showProgress();
          } catch (e) {
            e.stack;
          }

          scope.filtrecontrole = filtreControle;

          if (filtreControle === 'vidange_factu') {
            filtreControle = 'tous';
            if (
              angular.isUndefined(scope.dataTableParams.liaisonFilter) ||
              scope.dataTableParams.liaisonFilter === '{}'
            )
              scope.dataTableParams.liaisonFilter = '{"vidanges": "vidanges",}';
            else
              scope.dataTableParams.liaisonFilter =
                scope.dataTableParams.liaisonFilter.substr(0, 1) +
                '"vidanges": "vidanges",' +
                scope.dataTableParams.liaisonFilter.substr(1);
          }
          var promise = AncAppFactory.getdossiers(
            filtreControle,
            scope.dataTableParams.filter,
            scope.dataTableParams.crs,
            scope.dataTableParams.page,
            scope.dataTableParams.count,
            scope.dataTableParams.liaisonFilter,
            scope.dataTableParams.case_sensitive,
            scope.dataTableParams.sort,
            restrictedIds,
            scope.dataTableParams.isExport
          );
          promise.then(function(res) {
            scope.reportsLength.v = parseInt(res.data.totalFeatures);
            const arrayPromises = [];
            for (let feat of res.data.features) {
              // on applique le "traitement" du correctInfos sur chaque dossier
              arrayPromises.push(AncAppFactory.correctInfosDossier(JSON.stringify(feat)));
            }
            scope.doss = res.data.features;
            scope.updateFileDataInCtrlDossiers();
          });
          return promise;
        };

        scope.updateFileDataInCtrlDossiers = ()=>{
          if(scope.ctrlDossiers && scope.ctrlDossiers.length){
            scope.ctrlDossiers.forEach((controlDoss)=>{
              if(scope.doss && scope.doss.length){
                const updatedFile = scope.doss.find(
                  (fileItem)=> fileItem.id === controlDoss.doss.id);
                if (updatedFile){
                  controlDoss.doss = updatedFile;
                }
              }
            });
          }
        };

        scope.sendDossiersResult = function(result) {
          AncAppFactory.sendResultBackDossiers(result);
        };

        scope.selecteddossiers = { list: [] };

        scope.$watch('selecteddossiers.list', function(l) {
          scope.dossiersArchivables = 0;
          if (l) {
            for (var i in l) {
              if (l[i].properties.etat_dossier !== 'archive') {
                scope.dossiersArchivables++;
              }
            }
            scope.$emit('changeSelectedDossier', l);
            scope.res = l;
          }
        });

        scope.updateStatutDossiers = function(statut) {
          if (scope.selecteddossiers.list.length) {
            var ans = confirm(
              'Êtes-vous sur de vouloir modifier le statut des dossiers sélectionnés ?'
            );
            if (ans) {
              gaDomUtils.showLocalLoader('.currentPage');

              var toChange = scope.selecteddossiers.list.map(function(c) {
                return c.id;
              });

              AncAppFactory.updatestatutdossiers(toChange, statut).then(
                function() {
                  scope.dossiersArchivables = 0;
                  gaDomUtils.hideGlobalLoader('.currentPage');
                  scope.refreshReports(1);
                }
              );
            }
          }
        };

        /***********************************************************************
         * EDITION D'UN DOSSIER
         **********************************************************************/

        /**
         * setReferenceDossier
         */
        scope.setReferenceDossier = function() {
          if (AncAppFactory.appCfg.main.dossierCfg.numerotation.auto) {
            scope.saveReport(AncAppFactory.getNumeroAuto('TMP_KIS_DOSSIER_ID'));
          }
        };

        /**
         * notifyLinkCopy
         */
        scope.notifyLinkCopy = function(type) {
          require('toastr').success(
            'Lien d\'accès direct à ce ' +
              type +
              ' copié dans votre presse-papiers.',
            '',
            {
              positionClass: 'toast-bottom-left',
            }
          );
        };

        var initCopyReportButton = false;
        var reportDialog;
        scope.getCopyControleUrl = function() {
          if ($location.search().fid) $location.search('fid', null);
          return $location.absUrl() + '&fid=' + scope.currentControle.id;
        };

        scope.$on('updateDossierName', function() {
          scope.currentReportTitle = $sce.trustAsHtml(
            ancBacTools.setDossierFullname(
              scope.currentReport,
              'anc',
              initCopyReportButton,
              $location
            )
          );
        });

        let removeListennerOpenDossier = scope.$on('anc_open_dossier', function(event, data) {
          if (angular.isDefined(data)) {
            AncAppFactory.getdossier(data[0].id).then(function(res) {
              scope.editReport(res.data.features[0],undefined,undefined,undefined,undefined,undefined, undefined, true);
            });
          }
        });

        scope.$on('anc_open_controle', function(event, data) {
          if (angular.isDefined(data)) {
            gaDomUtils.showGlobalLoader();
            AncAppFactory.getdossier(data[0].dossier_id).then(function(res) {
              gaDomUtils.hideGlobalLoader();
              scope.editReport(
                res.data.features[0],
                false,
                data[0].controle_id
              );
            });
          }
        });

        scope.$on('anc_open_vidange', function(event, data) {
          if (angular.isDefined(data)) {
            gaDomUtils.showGlobalLoader();
            AncAppFactory.getdossier(data[0].dossier_id).then(function(res) {
              gaDomUtils.hideGlobalLoader();
              scope.editReport(res.data.features[0], false, data[0].vidange_id);
            });
          }
        });

        var alerteDialog;
        scope.$on('edit_alerte_dossier', function(event, data) {
          if (data) {
            AncAppFactory.getdossier(data).then(function(res) {
              if (res.data.features.length) {
                scope.currentReport = res.data.features[0];
                dateUtils.convertAllDatesToDateString(
                  scope.currentReport.properties,
                  dossierDateNames
                );
                alerteDialog = ngDialog.open({
                  template:
                    'js/XG/widgets/ancapp/main/views/modals/modal.alerte.edit.html',
                  className:
                    'ngdialog-theme-plain width800 nopadding miniclose',
                  closeByDocument: false,
                  scope: scope,
                  preCloseCallback: function() {
                    scope.currentReport = {};
                  },
                });
              }
            });
          }
        });

        scope.updateAlerte = function(update) {
          if (angular.isDefined(scope.currentReport)) {
            var ans = null;
            if (!update) {
              ans = confirm(
                'Etes-vous sur de vouloir supprimer cette alerte ?'
              );
              if (ans) {
                scope.currentReport.properties.alerte = '';
                scope.currentReport.properties.alerte_echeance = null;
              }
            }
            if (ans == null || ans) scope.saveReport();
          }
          alerteDialog.close();
        };

        scope.setLock = {};
        var getOrSetUserTimeOut = function() {
          AncAppFactory.setusertimeout(
            scope.lockFolder.id,
            scope.lockFolder.user
          )
            .then(function(res) {
              if (res.data !== undefined)
                if (
                  res.data.used &&
                  scope.lockFolder.user !== res.data.usedBy
                ) {
                  scope.setLock = {
                    lock: true,
                    user: res.data.usedBy,
                  };
                  $interval.cancel(lockFolderInterval);
                } else scope.setLock = { lock: false };
            })
            .catch((err) => {
              err.stack;
            });
        };

        /**
         * open report
         */
        var lockFolderInterval;
        /**
         *
         * @param {objet} report dossier ANC à ouvrir au format geojson
         * @param geometry
         * @param controleId
         * @param suppOptions
         * @param fromAndroid
         * @param id_dossier
         * @param fromMap
         * @param {boolean} openFromMap
         */
        scope.editReport = function(
          report,
          geometry,
          controleId,
          suppOptions,
          fromAndroid,
          id_dossier,
          fromMap,
          openFromMap
        ) {
          scope.omegaCfg = { active: false };
          scope.omegaCfg.active = gaJsUtils.checkNestedProperty(
            'portal.parameters.interfaces.omega.active',
            $rootScope.xgos
          );

          scope.isroot = $rootScope.xgos.isroot;

          if (angular.isDefined(scope.filiereActive)) {
            scope.filiereActive = {};
          }

          scope.setLock = {};
          if (report != null) {
            scope.lockFolder = {
              id: report.id,
              user: $rootScope.xgos.user.login,
            };

            if (
              angular.isDefined(
                AncAppFactory.appCfg.main.properties.isOpenedFolderActive
              ) &&
              AncAppFactory.appCfg.main.properties.isOpenedFolderActive === true
            ) {
              getOrSetUserTimeOut();
              lockFolderInterval = $interval(function() {
                getOrSetUserTimeOut();
              }, 10000);
            }
          }

          try {
            if (typeof ProgressionAndroid !== 'undefined')
              ProgressionAndroid.showProgress();
          } catch (e) {
            e.stack;
          }

          if (
            typeof AppAndroid !== 'undefined' &&
            typeof ancAppAndroid !== 'undefined'
          ) {
            try {
              if (typeof AppAndroid !== 'undefined') AppAndroid.adjustBar(true);
            } catch (e) {
              e.stack;
            }

            AppAndroid.setReportOpened(true);

          }

          if ((id_dossier == undefined) && (report != undefined)) {
            id_dossier = report.id;
          }
          //update dossier to avoid issues in widget anc
          //we need to update geographic data to fit ANC's srid
          AncAppFactory.getdossier(id_dossier).then((res) => {
            if (res.data && res.data.features && res.data.features.length > 0) {
              try {
                if (reportDialog) reportDialog.close();
              } catch (e) {
                console.error('error closing dossier: ' + e.message);
              }
              report = res.data.features[0];
            } else {
              console.error('error getDossier(id_dossier) with id_dossier = ' + id_dossier);
            }
            editReportComplete(
              report,
              geometry,
              controleId,
              suppOptions,
              fromAndroid,
              id_dossier,
              fromMap,
              openFromMap
            );
          });
        };

        /* CAHIER DE VIE */
        scope.closedCahier = true;
        scope.reopenCahier = function(currentCahier) {
          if (scope.closedCahier === true) {
            scope.closedCahier = false;
            scope.currentCahier.properties.etat = 'actif';
          }
        };

        scope.updateCahierDeVie = function(cahier) {
          if (scope.closedCahier === false) {
            scope.currentCahier.properties.etat = 'inactif';
            scope.closedCahier = true;
          } else {
            scope.closedCahier = true;
          }

          var featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };

          gaDomUtils.showGlobalLoader();
          var cahierToUpdate = {};
          if (angular.isDefined(cahier.id)) {
            cahierToUpdate = {
              type: 'Feature',
              id: cahier.id,
              properties: cahier.properties,
            };
            featureCollection.features.push(cahierToUpdate);
            EditFactory.update(
              'kis_anc_dossier_cahier_de_vie',
              featureCollection
            ).then(function(res) {
              require('toastr').success('Enregistré');
              gaDomUtils.hideGlobalLoader();
            });
          }

          scope.bkpCurrentCahier = angular.copy(cahier);
        };

        // Afficher ou Cacher un cahier de vie
        scope.toggleCahierOnDossier = function(cahier, index) {
          var show = false;
          var first_element = false;
          scope.reportTree.forEach(function(b) {
            if (b.label === 'Cahiers de vie') {
              b.children.forEach(function(f) {
                if (f.cahierId === cahier.id) {
                  f.classes.forEach(function(cc) {
                    if (
                      cc === 'showTreeBranch' &&
                      cahier.properties.etat !== 'actif'
                    ) {
                      f.classes.splice(f.classes.indexOf('showTreeBranch'));
                      f.classes.push('hiddenTreeBranch');
                      show = true;
                    }
                    if (
                      cc === 'hiddenTreeBranch' &&
                      cahier.properties.etat === 'actif'
                    ) {
                      f.classes.splice(f.classes.indexOf('hiddenTreeBranch'));
                      first_element = true;
                    }
                  });
                  if (
                    first_element === false &&
                    cahier.properties.etat === 'actif'
                  ) {
                    f.classes.push('hiddenTreeBranch');
                  }
                  if (show === false && cahier.properties.etat !== 'actif') {
                    f.classes.push('showTreeBranch');
                  }
                }
              });
            }
          });
        };

        // revoyer l'etat du button
        scope.renderDisplayHideCahier = function(cahier, index) {
          var res = true;

          scope.reportTree.forEach(function(b) {
            if (b.label === 'Cahiers de vie') {
              b.children.forEach(function(f) {
                if (f.cahierId === cahier.id) {
                  f.classes.forEach(function(cc) {
                    if (cc === 'showTreeBranch') {
                      res = false;
                    }
                    if (
                      cc === 'hiddenTreeBranch' &&
                      cahier.properties.etat === 'actif'
                    ) {
                      res = false;
                    }
                  });
                }
              });
            }
          });

          if (cahier.properties.etat === 'actif') {
            res = !res;
          }
          return res;
        };

        scope.removeSelectedCahier = function(cahier, idx) {
          scope.currentCahiers.splice(idx, 1);
          scope.reportTree[cahierBranchIndex].children.map(function(c, i) {
            if (c.cahierId === cahier.id) {
              scope.reportTree[cahierBranchIndex].children.splice(i, 1);
            }
          });

          AncAppFactory.removecahier(cahier.id).then(function() {
            require('toastr').success('Cahier de vie supprimé', '', {
              positionClass: 'toast-bottom-left',
            });
          });
        };

        var checkCahierDeVie = function(report) {
          var cahierDeVieBranch = {
            label: 'Cahiers de vie',
            identifier: 'cahiers_de_vie',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.cahier_de_vie.liste.html',
            classes: [],
          };

          var cahierDeVieExist = false;

          scope.reportTree.map(function(x, i) {
            if (x.label === 'Cahiers de vie') {
              cahierDeVieExist = true;
            }
          });

          let dossierTemporaire = angular.copy(scope.currentReport);

          if (
            dossierTemporaire === undefined ||
            (typeof dossierTemporaire == 'object' &&
              Object.keys(dossierTemporaire).length == 0)
          ) {
            //update cahier de vie when we open the file
            if (
              (report.properties.filiere_sup_20_eh === true ||
                report.properties.filiere_sup_20_eh === false) &&
              cahierDeVieExist === false &&
              (report.properties.infosFilieres.volume == '1' ||
                report.properties.infosFilieres.volume == '2')
            ) {
              // add cahier de vie
              scope.reportTree.splice(2, 0, cahierDeVieBranch);
            } else if (
              scope.reportTree[2].label === 'Cahiers de vie' &&
              (report.properties.filiere_sup_20_eh === true ||
                report.properties.filiere_sup_20_eh === false) &&
              cahierDeVieExist === true &&
              report.properties.infosFilieres.volume == '0'
            ) {
              // delete cahier de vie
              scope.reportTree.splice(2, 1);
            } else if (
              cahierDeVieExist === true &&
              report.properties.filiere_sup_20_eh == null &&
              report.properties.infosFilieres.volume === undefined
            ) {
              if (scope.reportTree[2].label === 'Cahiers de vie') {
                scope.reportTree.splice(2, 1);
              }
            }
          } else {
            // edit filliere volume
            if (
              report.properties.filiere_sup_20_eh === true &&
              cahierDeVieExist === false
            ) {
              scope.reportTree.splice(2, 0, cahierDeVieBranch);
            } else if (
              scope.reportTree[2].label === 'Cahiers de vie' &&
              report.properties.filiere_sup_20_eh !== true &&
              cahierDeVieExist === true
            ) {
              scope.reportTree.splice(2, 1);
            }
          }
        };
        scope.subventionDossierCheck = function(check) {
          var SubventionBranch = {
            label: 'Subventions',
            identifier: 'subventions_dossier',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.subvention_dossier.liste.html',
            classes: [],
          };

          var subventionExit = false;
          var controlePosition = 0;

          scope.reportTree.map(function(x, i) {
            if (x.label === 'Contrôles') {
              controlePosition = i;
            }
            if (x.label === 'Subventions') {
              subventionExit = true;
            }
          });
          if (subventionExit && !check) {
            scope.reportTree.splice(controlePosition + 1, 1);
          } else if (!subventionExit && check) {
            scope.reportTree.splice(controlePosition + 1, 0, SubventionBranch);
          }
          setDossierArborescence();
        };

        scope.sumMontantSubvention = function() {
          var total = 0;
          if (angular.isDefined(scope.currentSubvention)) {
            scope.currentSubvention.forEach(function(f) {
              total += f.properties.montant_subvention;
            });
          }
          return total;
        };

        scope.idEntrepriseNom = {};
        scope.$watch(
          'currentSubvention',
          function() {
            if (angular.isDefined(scope.currentSubvention)) {
              scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
                AncAppFactory.appCfg.main.datastore,
                AncAppFactory.appCfg.main.entreprisesCfg.emplacement
              );
              scope.currentSubvention.forEach(function(subvention) {
                QueryFactory.get(
                  scope.entreprisesFti.uid,
                  subvention.properties.id_entreprise
                ).then(function(res) {
                  scope.idEntrepriseNom[
                    subvention.properties.id_entreprise
                  ] = angular.isDefined(res.data.features[0])
                    ? res.data.features[0].properties.nom
                    : null;
                });
              });
            }
          },
          true
        );

        scope.resetCahierDeVie = function() {
          if (angular.isDefined(scope.currentCahier))
            var copie = angular.copy(scope.currentCahier);
          scope.currentCahier.properties = {};
          scope.currentCahier.properties.ref_dossier =
            copie.properties.ref_dossier;
          scope.currentCahier.properties.nom = copie.properties.nom;
          scope.currentCahier.properties.etat = copie.properties.etat;
        };

        // @LOC le comique
        // Haut, haut, bas, bas, gauche, droite, gauche, droite, B, A
        var k = [38, 38, 40, 40, 37, 39, 37, 39],
          n = 0;
        $(document).keydown(function(e) {
          if (e.keyCode === k[n++]) {
            if (n === k.length) {
              ngDialog.open({
                template:
                  'js/XG/widgets/ancapp/main/views/modals/modal.report.hyperimportant.html',
                className:
                  'ngdialog-theme-plain fullScreen nopadding miniclose',
                closeByDocument: false,
              });
              n = 0;
              return false;
            }
          } else {
            n = 0;
          }
        });

        /* FORMULAIRE DE VIDANGE */
        scope.updateVidange = function(vidange) {
          if (scope.closedVidange === false) {
            scope.currentVidange.properties.etat = 'inactif';
            scope.closedVidange = true;
          } else {
            scope.closedVidange = true;
          }

          var featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };

          gaDomUtils.showGlobalLoader();
          var vidangeToUpdate = {};
          if (angular.isDefined(vidange.id)) {
            vidangeToUpdate = {
              type: 'Feature',
              id: vidange.id,
              properties: vidange.properties,
            };
            featureCollection.features.push(vidangeToUpdate);
            EditFactory.update(
              'kis_anc_vidange_formulaire',
              featureCollection
            ).then(function(res) {
              require('toastr').success('Enregistré');
              gaDomUtils.hideGlobalLoader();
            });
          }
        };

        scope.removeSelectedVidange = function(vidange, idx) {
          var ans = confirm(
            'Etes-vous certain de vouloir supprimer cette intervention ?'
          );

          if (ans) {
            scope.currentVidanges.splice(idx, 1);
            scope.reportTree[vidangeBranchIndex].children.map(function(c, i) {
              if (c.vidangeId === vidange.id) {
                scope.reportTree[vidangeBranchIndex].children.splice(i, 1);
              }
            });

            AncAppFactory.removeformvidange(
              scope.currentReport.id,
              vidange.id
            ).then(function() {
              require('toastr').success('Vidange supprimée', '', {
                positionClass: 'toast-bottom-left',
              });
            });
          }
        };

        /**
         * makeNewVidange
         */
        var makeNewVidange = function() {
          scope.newVidange = {
            date: $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss.sssZ'),
          };
        };
        makeNewVidange();

        /**
         * addVidangeToDossier
         */
        scope.addVidangeToDossier = function() {
          var ans = 1;
          if (
            angular.isDefined(scope.currentVidanges) &&
            scope.currentVidanges.length > 0
          ) {
            ans = confirm(
              'Êtes-vous certain de vouloir ajouter une vidange pour ce dossier?\nLa vidange actuellement active deviendra inactive.'
            );
          }

          if (ans) {
            gaDomUtils.showGlobalLoader();

            AncAppFactory.addformvidange(
              scope.currentReport.id,
              scope.newVidange.date
            ).then(function() {
              makeNewVidange();
              require('toastr').success('Vidange ajoutée au dossier.', '', {
                positionClass: 'toast-bottom-left',
              });

              setDossierArborescence();
              gaDomUtils.hideGlobalLoader();
            });
          }
        };

        /**
         * makeSubvention
         */
        var makeSubvention = function() {
          scope.newSubvention = {
            date: $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss.sssZ'),
          };
        };
        makeSubvention();

        /**
         * addSubventionToDossier
         */
        scope.addSubventionToDossier = function() {
          var ans = 1;
          if (
            angular.isDefined(scope.currentVidanges) &&
            scope.currentVidanges.length > 0
          ) {
            ans = confirm(
              'Êtes-vous certain de vouloir ajouter un nouvel organisme financeur?'
            );
          }
          if (ans) {
            gaDomUtils.showGlobalLoader();

            AncAppFactory.addSubventionDossier(
              scope.currentReport.id,
              scope.newSubvention.date
            ).then(function() {
              makeSubvention();
              require('toastr').success(
                'organisme financeur ajouté au dossier.',
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );

              setDossierArborescence();
              gaDomUtils.hideGlobalLoader();
            });
          }
        };

        scope.removeSelectedSubvention = function(subvention, idx) {
          var ans = confirm(
            'Etes-vous certain de vouloir supprimer cet organisme ?'
          );

          if (ans) {
            scope.currentSubvention.splice(idx, 1);
            scope.reportTree[subventionBranchIndex].children.map(function(
              c,
              i
            ) {
              if (c.SubventionId === subvention.id) {
                scope.reportTree[subventionBranchIndex].children.splice(i, 1);
              }
            });

            AncAppFactory.removeSubvention(
              scope.currentReport.id,
              subvention.id
            ).then(function() {
              setDossierArborescence();
              require('toastr').success('Organisme supprimé', '', {
                positionClass: 'toast-bottom-left',
              });
            });
          }
        };

        var clearLockInterval = function() {
          if (angular.isDefined(lockFolderInterval))
            $interval.cancel(lockFolderInterval);
        };

        scope.newFromMap = false;

        /**
         *
         * @param {objet} report dossier ANC à ouvrir au format geojson
         * @param geometry
         * @param controleId
         * @param suppOptions
         * @param fromAndroid
         * @param id_dossier
         * @param fromMap
         * @param {boolean} openFromMap true quand on ouvre un dossier ANC existant
         *  depuis le bouton "Sélectionner dossier" du widget ANC de l'application MAP.
         *  Permet de lancer la restauration du modèle de carte et des couches à la fermeture de la popup
         */
        var editReportComplete = function(
          report,
          geometry,
          controleId,
          suppOptions,
          fromAndroid,
          id_dossier,
          fromMap,
          openFromMap
        ) {
          scope.newFiliereElement = {};
          scope.currentFiliere = {};
          scope.currentFilieres = undefined;
          scope.currentControle = {};
          scope.currentControles = undefined;
          scope.currentVidange = {};
          scope.currentVidanges = undefined;
          scope.currentCahier = {};
          scope.currentCahiers = undefined;
          scope.documentsCheckedForMail = [];
          scope.currentControlesFacturesAnnuelles= undefined;


          if (
            angular.isDefined(report) &&
            report != null &&
            angular.isDefined(report.properties)
          ) {
            checkCahierDeVie(report);
          }

          scope.tournee = { concerne: false };

          // default
          if (!report) {
            report = {
              type: 'Feature',
              properties: {
                ref_dossier: '',
                etat_dossier: 'ouvert',
                proprietaires: [],
                locataires: [],
                parcelleHabitation: null,
                parcelleFiliere: null,
              },
            };

            if (geometry) {
              report.geometry = geometry;
            }

            // Emprise depuis ANC MAP WIDGET, récupération des
            // informations de l'adresse puis injection dans le formulaire
            if (suppOptions) {
              Object.keys(suppOptions).forEach(function(c) {
                if (~c.indexOf('housenumber')) {
                  report.properties.adresse_num_rue = parseInt(
                    suppOptions[c],
                    10
                  );
                }
                if (~c.indexOf('street')) {
                  report.properties.adresse_rue = suppOptions[c];
                }
                if (~c.indexOf('city') && c !== 'citycode') {
                  report.properties.adresse_ville = suppOptions[c];

                  // alerte si ville pas connue
                  var villeCorrespondance = suppOptions[c];
                  if (listeDesVillesActives.length) {
                    var hits = listeDesVillesActives.filter(function(x) {
                      return (
                        x.value.toLowerCase() === suppOptions[c].toLowerCase()
                      );
                    });
                    // aucune correspondance directe (lowercase)
                    if (!hits.length) {
                      // tentative avec levenshtein
                      var hitsLev = listeDesVillesActives
                        .filter(function(x) {
                          x.lev = gaJsUtils.levenshtein(
                            x.value,
                            suppOptions[c]
                          );
                          return x.lev > 0.6;
                        })
                        .sort(function(a, b) {
                          return a.lev > b.lev ? -1 : b.lev > a.lev ? 1 : 0;
                        });

                      // rien > 0.6 avec levenshtein
                      if (!hitsLev.length) {
                        require('toastr').error(
                          'Aucune correspondance avec une commune gérée par le SPANC n\'a pu être établie avec la commune <b> ' +
                            suppOptions[c] +
                            '</b>.',
                          'Attention',
                          {
                            closeButton: true,
                            timeOut: '0',
                            extendedTimeOut: '0',
                          }
                        );
                        villeCorrespondance = null;
                      } else {
                        require('toastr').warning(
                          'Aucune correspondance directe avec une commune gérée par le SPANC n\'a pu être établie avec la commune <b> ' +
                            suppOptions[c] +
                            '.</b><br/><br/>' +
                            'Cependant la commune <b>' +
                            hitsLev[0].value +
                            '</b> semble correspondre et a été sélectionnée.',
                          'Information',
                          {
                            closeButton: true,
                            timeOut: '0',
                            extendedTimeOut: '0',
                          }
                        );
                        villeCorrespondance = hitsLev[0].value;
                        if (hitsLev[0].cp.length) {
                          report.properties.adresse_cp = hitsLev[0].cp[0];
                        }
                      }
                    } else {
                      villeCorrespondance = hits[0].value;
                      if (hits[0].cp.length) {
                        report.properties.adresse_cp = hits[0].cp[0];
                      }
                    }
                  }
                  report.properties.adresse_ville = villeCorrespondance;
                }

                if (~c.indexOf('country')) {
                  report.properties.adresse_pays = suppOptions[c];
                }
              });
            }

            scope.currentReportTitle = 'Nouveau Dossier';

            dateUtils.convertAllDatesToDateString(
              report.properties,
              dossierDateNames
            );
            scope.currentReport = report;

            if (fromMap) {
              scope.currentReport.newFromMap = true;
            }

            scope.currentReport.properties.date_creation = new Date();
            scope.setReferenceDossier();
          } else {
            if (report.properties.tournee === true) {
              scope.tournee = {
                concerne: true,
                par: report.properties.tournee_par,
                pour: report.properties.tournee_pour,
                nom: report.properties.tournee_name,
              };
            }

            if (report.geometry && typeof report.geometry == 'string') {
              report.geometry = JSON.parse(report.geometry);
            }

            scope.currentReportTitle = $sce.trustAsHtml(
              ancBacTools.setDossierFullname(
                report,
                'anc',
                initCopyReportButton,
                $location
              )
            );
            dateUtils.convertAllDatesToDateString(
              report.properties,
              dossierDateNames
            );
            scope.currentReport = report;
          }

          let isClosingPopup = false;

          reportDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.html',
            className: 'ngdialog-theme-plain fullScreen nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            preCloseCallback: function() {
              // trigger vérification des différences pour
              // enregistrement sur éléments concernés
              switch (scope.currentBranch.identifier) {
                case 'info_generales':
                  scope.$broadcast(
                    'checkDirtyReport',
                    scope.bkpCurrentReport,
                    scope.currentReport
                  );
                  if (
                    scope.dossierIsDirty &&
                    !scope.tournee.concerne &&
                    !scope.setLock.lock
                  ) {
                    scope.dossierIsDirty = false;
                    if (
                      confirm(
                        'Enregistrer les modifications apportées au dossier en cours ?'
                      )
                    ) {
                      scope.saveReport();
                    }
                  }
                case 'filiere':
                  $rootScope.$broadcast('check_dirty_rf');
                  break;
                case 'controle':
                  scope.$broadcast(
                    'checkDirty',
                    scope.checkDiffCdata,
                    scope.cdata
                  );
                  break;
                case 'facturation':
                case 'documents_dossier':
                case 'taches':
                case 'evenements':
                case 'historique':
                  break;
                case 'vidange':
                  scope.$emit('check_dirty_vidanges', scope.bkpVdata);
                  break;
                case 'element_filiere':
                  scope.$broadcast('check_dirty_element');
                  break;
                case 'cahier_de_vie':
                  testDiffCahierVie();
                  break;
                default:
                  console.log('nothing to trigger');
              }
              clearLockInterval();
              if (typeof AppAndroid !== 'undefined') {
                try {
                  if (typeof AppAndroid !== 'undefined') {
                    AppAndroid.setReportOpened(false);
                    AppAndroid.adjustBar(false);
                  }
                } catch (e) {
                  e.stack;
                }
              }

              scope.currentReport = {};
              scope.currentBranch = {};

              // A la fermeture d'un dossier ANC ouvert par le bouton "Sélection par point" du widget ANC
              // KIS-2447 | ANC-98
              if (!isClosingPopup && openFromMap) {
                // vide la couche technique de dessin
                if (gclayers.getDrawLayer() && gclayers.getDrawLayer().getSource()) {
                  gclayers.getDrawLayer().getSource().clear();
                }
                // vide la couche technique de sélection
                if (gclayers.getselectSource()) {
                  gclayers.getselectSource().clear();
                }
                // vide la couche technique de mise en évidence
                if (gclayers.getHighLightLayer() && gclayers.getHighLightLayer().getSource()) {
                  gclayers.getHighLightLayer().getSource().clear();
                }
                // Envoie un évènement au controller de l'application MAP
                $rootScope.$broadcast('anc_close_dossier');
                isClosingPopup = true;
              }
            },
          });

          if (typeof ancAppAndroid !== 'undefined')
            scope.reportDialogForAndroid = reportDialog;

          // collapse and select first branch when dialog is opened
          var deregOpenReportDialog = $rootScope.$on(
            'ngDialog.opened',
            function(e, $dialog) {
              if (reportDialog.id === $dialog.attr('id')) {
                $timeout(function() {
                  if (
                    angular.isDefined(controleId) &&
                    controleId.indexOf('kis_anc_vidange_formulaire') === 0
                  )
                    setDossierArborescence(
                      undefined,
                      undefined,
                      controleId,
                      undefined,
                      undefined,
                      true
                    );
                  else setDossierArborescence(undefined, controleId);

                  scope.reportTreeControl.reset_rows();
                  scope.reportTreeControl.collapse_all();
                  scope.reportTreeControl.select_first_branch();

                  deregOpenReportDialog();
                });
              }
            }
          );

          scope.bkpCurrentReport = angular.copy(scope.currentReport);

          refreshDossierActions();

          try {
            if (typeof ProgressionAndroid !== 'undefined')
              ProgressionAndroid.hideProgress();
          } catch (e) {
            e.stack;
          }
        };

        $rootScope.$on('ngDialog.closed', function(e, $dialog) {
          if (
            reportDialog &&
            reportDialog.id &&
            reportDialog.id === $dialog.attr('id')
          ) {
            $timeout(function() {
              scope.reportTreeControl.reset_rows();
              scope.reportTreeControl.collapse_all();
              scope.reportTreeControl.select_first_branch();
              if ($location.search().fid) {
                $location.search('fid', null);
              }
            });
          }
        });

        if (
          typeof AppAndroid !== 'undefined' ||
          scope.idsfilter ||
          scope.globalfilter
        ) {
          scope.datatableDossiersCrud = {
            update: { func: scope.editReport },
            remove: false,
          };
        } else {
          scope.datatableDossiersCrud = {
            create: { func: scope.editReport },
            update: { func: scope.editReport },
            remove: true,
          };
        }

        var documentsDossierBranchLabel = 'Documents du dossier';
        scope.reportTree = [
          {
            label: 'Informations générales',
            identifier: 'info_generales',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.general.html',
            isMainBranch: true,
          },
          {
            label: 'Filières',
            identifier: 'filieres',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.filieres.liste.html',
            children: [],
            classes: ['hiddenTreeBranch'],
          },
          {
            label: 'Contrôles',
            identifier: 'controles',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.controles.liste.html',
            classes: ['hiddenTreeBranch'],
          },
          {
            label: 'Facturation',
            identifier: 'facturation',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.facturation.html',
            classes: ['hiddenTreeBranch'],
          },
          {
            label: documentsDossierBranchLabel,
            identifier: 'documents_dossier',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.dossier.html',
            classes: ['hiddenTreeBranch'],
          },
        ];

        // onglet des informations du dossier
        scope.dossierInfosSupTabs = [
          { title: 'Données générales' },
          { title: 'Données techniques' },
        ];
        scope.dossierInfosSupTabs.activeTab = 0;
        scope.$watch(
          'dossierInfosSupTabs.activeTab',
          function(i) {
            if (i < 0) scope.dossierInfosSupTabs.activeTab = 0;
          },
          1
        );

        // informations supplémentaires si presence d'attributs prefixes
        // par extra_ dans le fti kis_anc_dossier
        if (scope.dossierFti != undefined && Array.isArray(scope.dossierFti.attributes)) {
          scope.dossierInfosSup = scope.dossierFti.attributes.filter((x) => {
            return x.name.indexOf('extra_') === 0;
          });
          if (scope.dossierInfosSup.length) {
            scope.dossierInfosSupTabs.push({
              title: 'Données supplémentaires',
            });
          }
        }

        

        if (typeof AppAndroid === 'undefined') {
          scope.reportTree.push({
            label: 'Tâches associées aux contrôles',
            identifier: 'taches',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.tasks.html',
            classes: ['hiddenTreeBranch'],
          });
          scope.reportTree.push({
            label: 'Rendez-vous',
            identifier: 'evenements',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.evenement.html',
            classes: ['hiddenTreeBranch'],
          });
          scope.reportTree.push({
            label: 'Historique des actions',
            identifier: 'historique',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.history.html',
            classes: ['hiddenTreeBranch'],
          });
        }

        if (needToAddVidange) {
          var brancheVidange = {
            label: 'Vidanges',
            identifier: 'vidanges',
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.vidanges.liste.html',
            classes: ['hiddenTreeBranch'],
          };

          scope.reportTree.push(brancheVidange);
        }

        // le controle a été modifié il faut donc proposer de le
        // sauvegarder si on change d'onglet
        scope.$on('ancCtrlFormIsDirty', function(v, i) {
          scope.ctrlFormIsDirty = 1;
        });

        scope.$on('reportIsDirty', function(v, i) {
          scope.dossierIsDirty = true;
        });

        scope.$on('ancControleDemandeurChoisi', function(v, data) {
          scope.currentControle.properties.id_demandeur = data.demandeur.id;
        });

        scope.$on('ancControleDemandeurReset', function(v, data) {
          scope.currentControle.properties.id_demandeur = null;
        });

        scope.reopenedControle = false;
        /**
         * reopenControle permet de reouvrir temporaire un controle
         */
        scope.reopenControle = function() {
          scope.reopenedControle = true;
          $rootScope.$broadcast('reopenControle');
        };

        var testDiffCahierVie = function() {
          var cleanData = gaJsUtils.removeEmpty(scope.currentCahier);
          var cleanNewData = gaJsUtils.removeEmpty(scope.bkpCurrentCahier);

          // Compare ONLY data
          if (!angular.equals(cleanData, cleanNewData)) {
            var ans = confirm(
              'Des données n\'ont pas été sauvegardées, voulez-vous les enregistrer ?'
            );
            if (ans) scope.updateCahierDeVie(scope.currentCahier);
          }
        };

        var deregChekDirtyRF = null;
        var doNotTriggerDirtyRF = false;

        scope.actionAvantChangementBranche = function(branch) {
          if (deregChekDirtyRF != null) {
            deregChekDirtyRF();
          }

          var def = $q.defer();

          var wtfResolve = true;
          if (scope.mobile) {
            scope.tournee.concerne = false;
          }

          // previous branch
          if (
            angular.isDefined(scope.currentBranch) &&
            angular.isDefined(branch)
          ) {
            if (scope.currentBranch.isCtrlForm) {
              // previous branch was a controle
              scope.$broadcast('checkDirty', scope.checkDiffCdata, scope.cdata);
              if (
                scope.ctrlFormIsDirty &&
                !scope.tournee.concerne &&
                !scope.setLock.lock
              ) {
                wtfResolve = false;
                var ans = confirm(
                  'Enregistrer les modifications apportées au contrôle en cours ?'
                );
                if (!ans) {
                  def.resolve();
                } else {
                  scope.saveControleDetail().then(
                    function() {
                      def.resolve();
                    },
                    function() {
                      def.reject();
                    }
                  );
                }
              }
            }

            if (scope.currentBranch.identifier === 'info_generales') {
              scope.$emit(
                'checkDirtyReport',
                scope.bkpCurrentReport,
                scope.currentReport
              );
              if (
                scope.dossierIsDirty &&
                !scope.tournee.concerne &&
                !scope.setLock.lock
              ) {
                wtfResolve = false;
                if (
                  confirm(
                    'Enregistrer les modifications apportées au dossier en cours ?'
                  )
                ) {
                  scope.saveReport();
                }
                def.resolve();
                scope.dossierIsDirty = false;
              }
            }

            if (
              scope.currentBranch.identifier === 'element_filiere' &&
              !scope.tournee.concerne &&
              !scope.setLock.lock
            ) {
              wtfResolve = false;
              scope.newB = angular.copy(branch);

              scope.$emit('check_dirty_element');

              $rootScope.$on('resolve_change_element', function() {
                branch = scope.newB;
                def.resolve();
              });
            }

            if (
              scope.currentBranch.identifier === 'filiere' &&
              !scope.tournee.concerne &&
              !scope.setLock.lock
            ) {
              if (doNotTriggerDirtyRF) {
                doNotTriggerDirtyRF = false;
              } else {
                wtfResolve = false;
                scope.newB = angular.copy(branch);

                scope.$emit('check_dirty_rf');
                deregChekDirtyRF = $rootScope.$on(
                  'resolve_change_rf',
                  function() {
                    branch = scope.newB;
                    def.resolve();
                  }
                );
              }
            }

            if (
              scope.currentBranch.identifier === 'cahier_de_vie' &&
              !scope.tournee.concerne &&
              !scope.setLock.lock
            ) {
              testDiffCahierVie();
            }

            if (
              scope.currentBranch.identifier === 'vidange' &&
              !scope.tournee.concerne &&
              !scope.setLock.lock
            ) {
              wtfResolve = false;
              scope.newB = angular.copy(branch);
              scope.$emit('check_dirty_vidanges', scope.bkpVdata);

              $rootScope.$on('resolve_change_vidange', function() {
                branch = scope.newB;
                def.resolve();
              });
            }

            if (scope.currentBranch.identifier === 'documents_dossier') {
              scope.documentsCheckedForMail = [];
            }
          }
          if (angular.isDefined(scope.controleCommentConfig))
            delete scope.controleCommentConfig;

          // problablement à virer, wtf ?
          if (wtfResolve) def.resolve();

          // deactivate feeder mode on change
          scope.feedMode = true;
          scope.feedModeDossier = true;
          scope.displayFeedDossier = false;

          return def.promise;
        };

        scope.reportTreeControl = {};
        scope.controleCommentConfig = {};

        if (typeof AppAndroid !== 'undefined') scope.AppAndroid = AppAndroid;

        scope.transformLoginIfNeeded = function(controle) {
          var name;
          var noNeedToTransform = 1;
          for (var i = 0; i < userslist.length; i++) {
            if (controle.properties.agent === userslist[i].login) {
              name = userslist[i].name + ' ' + userslist[i].vorname;
              noNeedToTransform = 0;
              return name;
            }
          }

          // wtf is that ?!?!
          if ((noNeedToTransform = 1)) {
            return controle.properties.agent;
          }
        };

        // documents lies au dossier
        scope.documentLiesTousTabs = [];
        scope.documentLiesTousTabs.activeTab = 0;
        scope.$watch(
          'documentLiesTousTabs.activeTab',
          function(i) {
            if (i < 0) scope.documentLiesTousTabs.activeTab = 0;
          },
          1
        );

        var getNearestCtrl = function(list, current, nearest_type) {
          let nearest = {};

          list.forEach(function(ctrl) {
            if (ctrl.properties.type === nearest_type) {
              if (
                Object.keys(nearest).length === 0 &&
                ctrl.id.split('.')[1] < current.id.split('.')[1]
              )
                nearest = ctrl;
              else {
                let id = 0;
                if (Object.keys(nearest).length > 0)
                  id = nearest.id.split('.')[1];

                if (
                  id < ctrl.id.split('.')[1] &&
                  ctrl.id.split('.')[1] < current.id.split('.')[1]
                )
                  nearest = ctrl;
              }
            }
          });

          return nearest;
        };

        /**
         * picking a branch
         */
        scope.reportTree_handle = function(branch) {
          scope.currentBranch = branch;
          scope.ctrlFormIsDirty = false;
          scope.reopenedControle = false;
          scope.dossierIsDirty = false;

          // Need to see if user is in facturation group
          var getRole = $rootScope.xgos.user.roles.filter(function(x) {
            if (x.name.indexOf('ANC_facturation') === 0)
              return x.name.indexOf('ANC_facturation') === 0;
            if (x.name.indexOf('rootUser') === 0)
              return x.name.indexOf('rootUser') === 0;
          }).length;

          getRole !== 0
            ? (scope.canAccessFacturation = true)
            : (scope.canAccessFacturation = false);

          if (branch.hasOwnProperty('filiereId')) {
            $rootScope.$broadcast('typeOfControl', undefined);

            scope.currentFilieres.forEach(function(f) {
              if (f.id === branch.filiereId) {
                scope.currentFiliere = f;
              }
            });
            scope.reportTreeControl.expand_branch(branch);
          }

          if (branch.hasOwnProperty('cahierId')) {
            scope.currentCahiers.forEach(function(f) {
              if (f.id === branch.cahierId) {
                scope.currentCahier = f;
                scope.bkpCurrentCahier = angular.copy(f);
              }
            });
            scope.reportTreeControl.expand_branch(branch);
          }

          if (branch.hasOwnProperty('vidangeId')) {
            scope.currentVidanges.forEach(function(f) {
              if (f.id === branch.vidangeId) {
                dateUtils.convertAllDatesToDateString(
                  f.properties,
                  vidangeDateNames
                );
                scope.currentVidange = f;
              }
            });
            scope.reportTreeControl.expand_branch(branch);
          }

          if (typeof AppAndroid !== 'undefined') {
            if (branch && branch.isFiliereSummary) {
              AppAndroid.setAppName('DOSSIER');
              AppAndroid.setLastAppName('DOSSIER');
            } else {
              AppAndroid.setAppName('OTHER');
              AppAndroid.setLastAppName('OTHER');
            }
          }

          if (branch.hasOwnProperty('controleId')) {
            // reset tout le temps
            scope.cdata = {
              general: {},
              conformite: {},
            };
            scope.controleIsLoaded = false;

            // attachment du controle
            scope.controleAttachmentData = {
              id: branch.controleId,
              featuretype: 'kis_anc_dossier_controle',
            };

            scope.typeControle = branch.typeControle;
            scope.currentControles.forEach(function(c) {
              if (c.id === branch.controleId) {
                scope.currentControle = c;

                var id_filiere = c.properties.reference_filiere.slice(
                  24,
                  c.properties.reference_filiere.length
                );
                QueryFactory.get(filiereFti.uid, id_filiere).then(function(
                  res
                ) {
                  scope.filiereDuControle = res.data.features.length
                    ? res.data.features[0]
                    : false;
                });

                gaDomUtils.showLocalLoader('.currentPage');
                AncAppFactory.getcontroledetail(
                  scope.currentReport.id,
                  c.id
                ).then(function(res) {
                  var dateToSet = '';
                  scope.currentControle.properties.type === 'FO0'
                    ? (dateToSet = 'date_demande')
                    : (dateToSet = 'date_controle');
                  // scope.currentControle.properties.reference_filiere
                  if (res.data !== '') {
                    scope.cdata = res.data;
                    if (!scope.cdata.ctrlFiliereData) {
                      scope.cdata.ctrlFiliereData = {};
                    }

                    if (!scope.cdata.datesDossier) {
                      scope.cdata.datesDossier = {};
                    }
                    if (
                      angular.isUndefined(scope.cdata.datesDossier[dateToSet])
                    ) {
                      scope.cdata.datesDossier[dateToSet] =
                      scope.currentControle.properties.date_passage;
                    }


                    // nouveau controle
                  } else if (res.data === '') {
                    // a décommenter pour autofill des infos
                    // du dossier dans un nouveau contrôle
                    if (!angular.isDefined(scope.cdata.datesDossier))
                      scope.cdata.datesDossier = {};
                    // force la date du controle dans le json
                    if (angular.isDefined(scope.currentControle.properties.date_passage)) {
                      scope.cdata.datesDossier[dateToSet] =
                        scope.currentControle.properties.date_passage;
                    }
                  }

                  if (!scope.cdata.datesDossier.date_controle_rdv) {
                    scope.cdata.datesDossier.date_controle_rdv = dateUtils.isValidDateAndExists(
                      scope.currentControle.properties.date_passage_rdv
                    )
                      ? new Date(
                        scope.currentControle.properties.date_passage_rdv
                      )
                      : undefined;
                  }

                  if (scope.currentControle.properties.type === 'FO1') {
                    if (scope.currentControles.length > 1) {
                      var lastFo0 = getNearestCtrl(
                        angular.copy(scope.currentControles),
                        angular.copy(scope.currentControle),
                        'FO0'
                      );
                      if (
                        gaJsUtils.checkNestedProperty(
                          'properties.date_passage',
                          lastFo0
                        )
                      ) {
                        scope.cdata.datesDossier.passage_reception =
                          lastFo0.properties.date_passage;
                      }
                    }
                  }
                  if (scope.currentControle.properties.type === 'FO2') {
                    if (scope.currentControles.length > 1) {
                      var lastFo1 = getNearestCtrl(
                        angular.copy(scope.currentControles),
                        angular.copy(scope.currentControle),
                        'FO1'
                      );
                      if (
                        gaJsUtils.checkNestedProperty(
                          'properties.date_passage',
                          lastFo1
                        )
                      ) {
                        scope.cdata.datesDossier.passage_conception =
                          lastFo1.properties.date_passage;
                      }
                    }
                  }

                  $timeout(function() {
                    $rootScope.$broadcast('updateInstallTab');
                    scope.checkDiffCdata = angular.copy(scope.cdata);
                  }, 0);
                  $timeout(function() {
                    gaDomUtils.removeLocalLoader('.currentPage');
                    scope.controleIsLoaded = true;
                    scope.checkDiffCdata = angular.copy(scope.cdata);
                  }, 500);
                });
                scope.reportTreeControl.expand_branch(branch);
              }
            });

            var controleName = scope.currentControle.properties.type;
            if (angular.isDefined(scope.allCtrlConfig)) {
              if (angular.isDefined(scope.allCtrlConfig[controleName]))
                scope.controleCommentConfig = scope.allCtrlConfig[controleName];
              else scope.controleCommentConfig = {};
            } else {
              scope.controleCommentConfig = {};
            }
          }

          if (needToAddVidange) {
            if (branch.hasOwnProperty('vidangeId')) {
              // attachment du controle
              scope.vidangeAttachmentData = {
                id: branch.vidangeId,
                featuretype: 'kis_anc_vidange_formulaire',
              };

              scope.currentVidanges.forEach(function(c) {
                if (c.id === branch.vidangeId) {
                  dateUtils.convertAllDatesToDateString(
                    c.properties,
                    vidangeDateNames
                  );
                  scope.currentVidange = c;

                  // retrieve data
                  scope.vdata = {};

                  gaDomUtils.showLocalLoader('.currentPage');
                  AncAppFactory.getvidangedetail(
                    scope.currentReport.id,
                    c.id
                  ).then(function(res) {
                    if (res.data !== '') {
                      scope.vdata = res.data;
                      if (angular.isDefined(scope.vdata)) {
                        var vidangeur = gaJsUtils.checkNestedProperty(
                          'id_vidangeur',
                          scope.currentVidange
                        );
                        if (vidangeur) {
                          QueryFactory.get(
                            scope.entreprisesFti.uid,
                            scope.currentVidange.properties.id_vidangeur
                          ).then(function(res) {
                            scope.vdata.vidangeur =
                              res.data.features[0].properties;
                            scope.bkpVdata = angular.copy(scope.vdata);
                          });
                        } else {
                          scope.bkpVdata = angular.copy(scope.vdata);
                        }
                      }
                    } else if (res.data === '') {
                    }

                    $rootScope.$broadcast('vdataToLogic', {
                      vdata: scope.vdata,
                    });

                    $timeout(function() {
                      gaDomUtils.removeLocalLoader('.currentPage');
                    }, 0);
                  });
                  scope.reportTreeControl.expand_branch(branch);
                }
              });
            }
          }

          if (branch.label.startsWith(documentsDossierBranchLabel)) {
            scope.fillDossierAttachmentsTab();
            if (branch.identifier === 'subvention_dossier') {
              $rootScope.$broadcast('refreshSubventionTree', {
                branch: branch,
              });
            }
          }
        };

        scope.fillDossierAttachmentsTab = function() {
          // alimentation de la liste
          scope.documentLiesTousTabs.splice(
            0,
            scope.documentLiesTousTabs.length
          );

          scope.documentLiesTousTabs.push({
            title:
              'Dossier (' + scope.dossierAttachmentData.attachmentsNo + ')',
            key: 'dossier',
            content:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.dossier.documents_dossier.html',
            activeTab: 0,
          });

          scope.documentLiesTousTabs.push({
            title: 'Filières',
            key: 'filières',
            content:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.dossier.documents_filieres.html',
            activeTab: 1,
          });

          scope.documentLiesTousTabs.push({
            title: 'Contrôles',
            key: 'controles',
            content:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.dossier.documents_controles.html',
            activeTab: 2,
          });

          // verifie les tabs presents pour les ajouter une seule fois
          var tabsPresents = scope.documentLiesTousTabs.map(function(x) {
            return x.activeTab;
          });

          if (
            scope.currentReport.properties.filiere_sup_20_eh === true &&
            tabsPresents.indexOf(3) === -1
          ) {
            var docLiesCahier = {
              title: 'Cahiers de vie',
              key: 'cahiers_de_vie',
              content:
                'js/XG/widgets/ancapp/main/views/modals/modal.report.dossier.documents_cahiers.html',
              activeTab: 3,
            };

            scope.documentLiesTousTabs.push(docLiesCahier);
          }

          if (needToAddVidange && tabsPresents.indexOf(4) === -1) {
            var docLiesVidange = {
              title: 'Vidange',
              key: 'vidanges',
              content:
                'js/XG/widgets/ancapp/main/views/modals/modal.report.dossier.documents_vidanges.html',
              activeTab: 4,
            };

            scope.documentLiesTousTabs.push(docLiesVidange);
          }

          $rootScope.countWhichTab = 0;

          scope.updateAllTabsLabels();
        };

        /**
         * getFeatureAliasFromUid
         *
         * @param uid
         * @returns {*}
         */
        scope.getFeatureAliasFromUid = function(uid) {
          var ft = FeatureTypeFactory.getFeatureByUid(uid);
          return ft.alias;
        };

        scope.getTypePreconise = function() {
          if (
            angular.isDefined(
              scope.currentReport.properties.type_prochain_controle_preconise
            ) &&
            scope.currentReport.properties.type_prochain_controle_preconise !=
              null
          )
            scope.newControle.type =
              scope.currentReport.properties.type_prochain_controle_preconise;
        };

        // force le controle ouvert en haut
        var sortCajControles = function(tmp) {
          var idx;
          var contientControleOuvert = tmp.filter(function(x, i) {
            if (x.properties.etat === 'ouvert') idx = i;
            return x.properties.etat === 'ouvert';
          }).length;
          if (contientControleOuvert) {
            var openedControle = tmp[idx];
            tmp.splice(idx, 1);

            if (tmp.length)
              tmp = [tmp.shift()]
                .concat(
                  gaJsUtils.sortByFeatureProperty(
                    tmp,
                    AncAppFactory.appCfg.main.properties.triControleCaj.name
                  )
                )
                .reverse();
            tmp.splice(0, 0, openedControle);
          } else {
            tmp = gaJsUtils
              .sortByFeatureProperty(
                tmp,
                AncAppFactory.appCfg.main.properties.triControleCaj.name
              )
              .reverse();
          }
          return tmp;
        };

        scope.getControleFromFiliere = function(filiere) {
          if (angular.isDefined(scope.currentControles)) {
            var controleLink = '-';
            if (scope.currentControles.length) {
              scope.currentControles.forEach(function(x) {
                if (x.properties.reference_filiere === filiere.id) {
                  controleLink = AncAppFactory.getControleName(
                    x.properties.type,
                    x.properties.date_passage
                  );
                }
              });
            }
          }

          return controleLink;
        };

        scope.UpdateEntrepriseData = function(id_entreprise) {
          scope.entrepriseData = null;
          scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            AncAppFactory.appCfg.main.entreprisesCfg.emplacement
          );
          QueryFactory.get(scope.entreprisesFti.uid, id_entreprise).then(
            function(res) {
              scope.entrepriseData = res.data.features[0].properties;
            }
          );
        };

        /**
         * refresh la liste des controles qui apparaissent dans le dossier
         */
        var refreshListeControles = function(
          filiereBranchIndex,
          hasFiliereActive,
          controleId,
          vidangeId
        ) {
          // get controles
          AncAppFactory.getcontroles(scope.currentReport.id).then(function(
            res
          ) {
            // TRI DES CONTROLES
            var tmp = res.data.features;

            var contientControlesMigration = tmp.filter(function(x) {
              return x.properties.caj_id_controle !== null;
            }).length;

            var onlyControleMigration =
              contientControlesMigration === tmp.length;

            // controles issus de la migration
            if (contientControlesMigration && tmp.length) {
              // dans le cas ou tous les controles proviennent de la migration
              if (onlyControleMigration) {
                tmp = sortCajControles(tmp);
              } else {
                var kisCtrls = [],
                  cajCtrls = [];
                tmp.map(function(x) {
                  if (x.properties.caj_id_controle !== null) {
                    cajCtrls.push(x);
                  } else {
                    kisCtrls.push(x);
                  }
                });
                tmp = gaJsUtils
                  .sortByFeatureId(kisCtrls, 'desc')
                  .concat(sortCajControles(cajCtrls));
              }
              // cas kis
            } else {
              tmp = gaJsUtils.sortByFeatureId(tmp, 'desc');
            }

            scope.currentControles = tmp;

            setDefaultControleAgent();
            scope.ctrlTaskTabs = [];
            scope.ctrlTaskTabs.activeTab = 0;
            scope.reportTree[ctrlBranchIndex].children = [];
            // need to reset it
            scope.listCtrlFiliereDocumentsLies.controles = [];

            var dateFiliereLabel = [];
            scope.currentControles.forEach(function(c, idx) {
              var dateFiliere = {};
              if (
                angular.isDefined(c.properties.date_passage) &&
                c.properties.date_passage != null &&
                c.properties.date_passage !== ''
              ) {
                dateFiliere = {
                  id: c.properties.reference_filiere,
                  date:
                    'Filière ' +
                    $filter('date')(c.properties.date_passage, 'dd.MM.yyyy'),
                };
                dateFiliereLabel.push(dateFiliere);
              } else {
                dateFiliere = {
                  id: c.properties.reference_filiere,
                  date: 'Filière',
                };
                dateFiliereLabel.push(dateFiliere);
              }

              var ctrlLabel = AncAppFactory.getControleName(
                c.properties.type,
                c.properties.date_passage
              );
              c.attachmentsNo = ancBacTools.getCurrentDossierAttachmentsInfos(
                scope.doss,
                scope.currentReport
              ).controlesAttachments[c.id];

              var ctrlBranch = {
                label: ctrlLabel,
                identifier: 'controle',
                template:
                  'js/XG/widgets/ancapp/main/views/modals/modal.report.controle.html',
                controleId: c.id,
                isCtrlForm: true,
                classes:
                  c.properties.etat === 'ouvert' ? [] : ['inactiveTreeBranch'],
                children: [
                  {
                    label: 'Documents du contrôle',
                    identifier: 'documents_controle',
                    template:
                      'js/XG/widgets/ancapp/main/views/modals/modal.report.controle.documents_types.html',
                    typeControle: c.properties.type,
                    controleId: c.id,
                  },
                ],
              };

              // set in tree
              scope.reportTree[ctrlBranchIndex].children.push(ctrlBranch);
              scope.reportTreeControl.expand_branch(
                scope.reportTree[ctrlBranchIndex]
              );

              if (controleId === c.id) {
                scope.reportTreeControl.select_branch(ctrlBranch);
              }

              scope.ctrlTaskTabs.push({
                title: ctrlLabel,
                content:
                  'js/XG/widgets/ancapp/main/views/modals/modal.report.ctrltask.html',
                uid: controleFti.uid,
                id: c.id,
              });

              var toPushC = {
                label:
                  ctrlLabel +
                  (c.properties.etat === 'ouvert'
                    ? ' (contrôle en cours)'
                    : ''),
                attachmentData: {
                  id: c.id,
                  featuretype: 'kis_anc_dossier_controle',
                  feature: c,
                },
              };
              scope.listCtrlFiliereDocumentsLies.controles.push(toPushC);
              if (c.properties.etat === 'ouvert') {
                scope.currentCtrlShowFiles = toPushC;
              }

              if (
                (angular.isUndefined(scope.filiereActive) ||
                  angular.equals(scope.filiereActive, {})) &&
                c.properties.est_dernier_controle_cloture === true
              ) {
                scope.reportTree[filiereBranchIndex].children.forEach(function(
                  f,
                  idx
                ) {
                  if (f.filiereId === c.properties.reference_filiere)
                    scope.reportTree[filiereBranchIndex].children[
                      idx
                    ].classes = ['inactiveTreeBranch', 'showTreeBranch'];
                });
              }
            });

            if (dateFiliereLabel.length > 0) {
              if (scope.reportTree[filiereBranchIndex] !== undefined) {
                scope.reportTree[filiereBranchIndex].children.forEach(function(
                  branch
                ) {
                  dateFiliereLabel.forEach(function(label) {
                    if (label.id === branch.filiereId)
                      branch.label = label.date;
                  });
                });
                if (scope.currentFilieres){
                  scope.currentFilieres.forEach(function(fil) {
                    dateFiliereLabel.forEach(function(label) {
                      if (label.id === fil.id)
                        fil.properties.nom = label.date == null ? '' : label.date;
                    });
                  });
                }
              }
            }
          });
        };

        var filiereBranchIndex,
          ctrlBranchIndex,
          cahierBranchIndex,
          subventionBranchIndex,
          vidangeBranchIndex;
        scope.listCtrlFiliereDocumentsLies = {};

        /**
         * set the whole report arborescence
         */
        var setDossierArborescence = function(
          filiereId,
          controleId,
          vidangeId,
          defer,
          doNotResetCtrl,
          openVidange,
          select_branch
        ) {
          scope.listCtrlFiliereDocumentsLies.filieres = [];
          scope.listCtrlFiliereDocumentsLies.cahiers = [];
          scope.listCtrlFiliereDocumentsLies.vidanges = [];
          scope.listCtrlFiliereDocumentsLies.subvention = [];

          scope.reportTree.forEach(function(b, i) {
            if (b.label === 'Filières') filiereBranchIndex = i;
            if (b.label === 'Contrôles') ctrlBranchIndex = i;
            if (b.label === 'Cahiers de vie') cahierBranchIndex = i;
            if (b.label === 'Vidanges') vidangeBranchIndex = i;
            if (b.label == 'Subventions') subventionBranchIndex = i;
          });

          var hasFiliereActive = false;

          scope.reportTree[filiereBranchIndex].children = [];
          if (!doNotResetCtrl) scope.reportTree[ctrlBranchIndex].children = [];

          if (!scope.currentReport.id) return;

          // get vidange
          if (needToAddVidange) {
            if (
              angular.isDefined(scope.reportTree[vidangeBranchIndex]) &&
              angular.isDefined(
                scope.reportTree[vidangeBranchIndex].children
              ) &&
              scope.reportTree[vidangeBranchIndex].children.length > 0
            ) {
              scope.reportTree[vidangeBranchIndex].children = [];
            }
            if (angular.isDefined(openVidange) && openVidange === true)
              scope.getVidange = true;

            QueryFactory.data(
              scope.vidangeFormFti.uid,
              'ref_dossier=\'' + scope.currentReport.id + '\''
            ).then(function(res) {
              scope.currentVidanges = gaJsUtils.sortByFeatureId(
                res.data.features,
                'desc'
              );

              scope.currentVidanges.forEach(function(f, idx) {
                f.attachmentsNo = ancBacTools.getCurrentDossierAttachmentsInfos(
                  scope.doss,
                  scope.currentReport
                ).vidangesAttachments[f.id];
                var label = 'Vidange';
                if (
                  angular.isDefined(f.properties.date_controle) &&
                  f.properties.date_controle != null
                )
                  label +=
                    ' ' +
                    $filter('date')(f.properties.date_controle, 'dd.MM.yyyy');

                var vidangeBranch = {
                  label: label,
                  identifier: 'vidange',
                  template:
                    'js/XG/widgets/ancapp/main/views/controle/vidange.html',
                  vidangeId: f.id,
                  classes:
                    f.properties.etat === 'actif'
                      ? []
                      : ['inactiveTreeBranch', 'vidangeBranch'],
                  children: [],
                };
                scope.reportTree[vidangeBranchIndex].children.push(
                  vidangeBranch
                );
                if (f.properties.etat === 'actif') {
                  dateUtils.convertAllDatesToDateString(
                    f.properties,
                    vidangeDateNames
                  );
                  scope.currentVidange = f;
                }

                vidangeBranch.children.push({
                  label: 'Documents (' + f.attachmentsNo + ')',
                  identifier: 'documents_vidange',
                  template:
                    'js/XG/widgets/ancapp/main/views/modals/modal.report.vidange.attachments.html',
                  typeControle: 'Vidange',
                  vidangeId: f.id,
                });

                // feed list pour documents lies depuis documents du dossier
                var toPushC = {
                  label:
                    'Vidange ' +
                    $filter('date', 'dd.MM.yyyy')(f.properties.date_creation) +
                    (f.properties.etat === 'actif' ? ' (vidange active)' : ''),
                  attachmentData: {
                    id: f.id,
                    featuretype: 'kis_anc_vidange_formulaire',
                    feature: f,
                  },
                };

                scope.listCtrlFiliereDocumentsLies.vidanges.push(toPushC);
                if (f.properties.etat === 'actif') {
                  scope.currentVidangesShowFiles = toPushC;
                }
              });
              scope.reportTreeControl.expand_branch(
                scope.reportTree[vidangeBranchIndex]
              );
              scope.reportTreeControl.expand_branch(
                scope.reportTree[vidangeBranchIndex].children
              );

              if (
                angular.isDefined(scope.getVidange) &&
                scope.getVidange === true
              )
                scope.reportTree[vidangeBranchIndex].children.forEach(function(
                  b,
                  i
                ) {
                  if (b.vidangeId === vidangeId)
                    scope.reportTreeControl.select_branch(
                      scope.reportTree[vidangeBranchIndex].children[i]
                    );
                  scope.reportTreeControl.expand_branch(
                    scope.reportTree[vidangeBranchIndex].children[i]
                  );
                });
            });
          }

          // get cahier de vie
          if (scope.currentReport.properties.filiere_sup_20_eh === true) {
            if (
              angular.isDefined(scope.reportTree[cahierBranchIndex]) &&
              angular.isDefined(scope.reportTree[cahierBranchIndex].children) &&
              scope.reportTree[cahierBranchIndex].children.length > 0
            ) {
              scope.reportTree[cahierBranchIndex].children = [];
            }

            QueryFactory.data(
              cahierFti.uid,
              'ref_dossier=\'' + scope.currentReport.id + '\''
            ).then(function(res) {
              scope.currentCahiers = gaJsUtils.sortByFeatureId(
                res.data.features,
                'desc'
              );

              scope.currentCahiers.forEach(function(f, idx) {
                f.attachmentsNo = ancBacTools.getCurrentDossierAttachmentsInfos(
                  scope.doss,
                  scope.currentReport
                ).cahiersAttachments[f.id];
                var cahierBranch = {
                  label: f.properties.nom,
                  identifier: 'cahier_de_vie',
                  template:
                    'js/XG/widgets/ancapp/main/views/modals/modal.report.cahier_de_vie.html',
                  cahierId: f.id,
                  classes:
                    f.properties.etat === 'actif'
                      ? []
                      : [
                        'inactiveTreeBranch',
                        'cahierBranch',
                        'hiddenTreeBranch',
                      ],
                  children: [],
                };
                scope.reportTree[cahierBranchIndex].children.push(cahierBranch);
                if (f.properties.etat === 'actif') {
                  scope.cahierActif = f;
                }
                cahierBranch.children.push({
                  label: 'Documents liés (' + f.attachmentsNo + ')',
                  identifier: 'documents_cahier_de_vie',
                  template:
                    'js/XG/widgets/ancapp/main/views/modals/modal.report.cahier_de_vie.attachments.html',
                  cahierId: f.id,
                  currentCahier: f,
                });

                // feed list pour documents lies depuis documents du dossier
                var toPushC = {
                  label:
                    f.properties.nom +
                    (f.properties.etat === 'actif' ? ' (cahier actif)' : ''),
                  attachmentData: {
                    id: f.id,
                    featuretype: 'kis_anc_dossier_cahier_de_vie',
                    feature: f,
                  },
                };

                scope.listCtrlFiliereDocumentsLies.cahiers.push(toPushC);
              });
              scope.reportTreeControl.expand_branch(
                scope.reportTree[cahierBranchIndex]
              );
              scope.reportTreeControl.expand_branch(
                scope.reportTree[cahierBranchIndex].children
              );
            });
          }

          // get subvention
          if (
            angular.isDefined(subventionBranchIndex) &&
            scope.currentReport.properties.subventionnable_dossier
          ) {
            if (
              angular.isDefined(scope.reportTree[subventionBranchIndex]) &&
              angular.isDefined(
                scope.reportTree[subventionBranchIndex].children
              ) &&
              scope.reportTree[subventionBranchIndex].children.length > 0
            ) {
              scope.reportTree[subventionBranchIndex].children = [];
            }

            QueryFactory.data(
              scope.subventionFti.uid,
              'ref_dossier=\'' + scope.currentReport.id + '\''
            ).then(function(res) {
              scope.currentSubvention = gaJsUtils.sortByFeatureId(
                res.data.features,
                'desc'
              );
              scope.currentSubvention.forEach(function(f, idx) {
                var subventionBranch = {
                  label:
                    'Subvention' +
                    (f.properties.numero_convention
                      ? '_' + f.properties.numero_convention
                      : ''),
                  identifier: 'subvention_dossier',
                  template:
                    'js/XG/widgets/ancapp/main/views/modals/modal.report.subvention.html',
                  subventionId: f.id,
                  subvention: f,
                  classes: [],
                  children: [],
                };
                delete scope.entrepriseData;
                scope.reportTree[subventionBranchIndex].children.push(
                  subventionBranch
                );
                subventionBranch.children.push({
                  label: 'Documents liés',
                  identifier: 'documents_subvention_dossier',
                  template:
                    'js/XG/widgets/ancapp/main/views/modals/modal.report.subvention.attachments.html',
                  subventionId: f.id,
                  subvention: f,
                });

                // feed list pour documents lies depuis
                // documents du dossier
                var toPushC = {
                  label:
                    'Subvention' +
                    (f.properties.numero_convention
                      ? '_' + f.properties.numero_convention
                      : ''),
                  attachmentData: {
                    id: f.id,
                    featuretype: 'kis_anc_dossier_subvention',
                  },
                };

                scope.listCtrlFiliereDocumentsLies.subvention.push(toPushC);
                scope.reportTreeControl.expand_branch(
                  scope.reportTree[subventionBranchIndex]
                );
                scope.reportTreeControl.expand_branch(
                  scope.reportTree[subventionBranchIndex].children
                );
              });
            });

            // });
          }

          // get filieres
          QueryFactory.data(
            filiereFti.uid,
            'ref_dossier=\'' + scope.currentReport.id + '\''
          ).then(function(res) {
            // reset
            scope.reportTree[filiereBranchIndex].children = [];

            scope.currentFilieres = gaJsUtils.sortByFeatureId(
              res.data.features,
              'desc'
            );

            scope.currentFilieres.forEach(function(f, idx) {
              f.attachmentsNo = ancBacTools.getCurrentDossierAttachmentsInfos(
                scope.doss,
                scope.currentReport
              ).filieresAttachments[f.id];
              var fActive = false;

              if (f.properties.etat === 'active') {
                scope.filiereActive = f;
                hasFiliereActive = true;
                fActive = true;
              }

              var filiereBranch = {
                label: 'Filière',
                identifier: 'filiere',
                isFiliereSummary: true,
                filiereId: f.id,
                classes:
                  f.properties.etat === 'active'
                    ? []
                    : ['inactiveTreeBranch', 'filiereBranch'],
                children: [],
                active: fActive,
              };
              scope.reportTree[filiereBranchIndex].children.push(filiereBranch);

              // set in tree
              scope.reportTreeControl.expand_branch(
                scope.reportTree[filiereBranchIndex]
              );

              // get filieres elements
              QueryFactory.data(
                elementFiliereFti.uid,
                'id_filiere=\'' + f.id + '\''
              ).then(function(res) {
                scope.currentFilieres[
                  idx
                ].elements = AncAppFactory.sortElementsFiliere(
                  res.data.features,
                  'dossier'
                );
                scope.currentFilieres[idx].elements.forEach(function(ef) {
                  if (scope.currentControles.length) {
                    scope.currentControles.forEach(function(control) {
                      if (
                        control.properties.reference_filiere ===
                        ef.properties.id_filiere
                      ) {
                        ef.properties.typeControle = control.properties.type;
                      }
                    });
                  }

                  filiereBranch.children.push({
                    label: scope.getFeatureAliasFromUid(
                      ef.properties.feature_uid
                    ),
                    identifier: 'element_filiere',
                    template:
                      'js/XG/widgets/ancapp/main/views/modals/modal.report.filiere.element.html',
                    linkedElement: ef,
                    idfiliereparent: f.id,
                  });
                });

                // refresh
                if (filiereId && f.id === filiereId) {
                  scope.currentFiliere = scope.currentFilieres[idx];
                }

                let nbAttachments = scope.filiereActive
                  ? scope.filiereActive.attachmentsNo
                  : 0;
                filiereBranch.children.push({
                  label: `Documents liés (${nbAttachments})`,
                  identifier: 'documents_filiere',
                  template:
                    'js/XG/widgets/ancapp/main/views/modals/modal.report.filiere.attachments.html',
                  filiereId: f.id,
                });

                var expand = null;
                var enCours = null;

                // Expand active filiere
                if (
                  angular.isDefined(
                    scope.reportTree[filiereBranchIndex].children
                  )
                ) {
                  scope.reportTree[filiereBranchIndex].children.filter(function(
                    f,
                    i
                  ) {
                    if (f.active === true) expand = i;
                    if (f.filiereId === filiereId) enCours = i;
                  });

                  if (expand != null) {
                    $timeout(function() {
                      scope.reportTreeControl.expand_branch(
                        scope.reportTree[filiereBranchIndex].children[expand]
                      );
                    });
                  }
                }

                // select branch
                if (filiereId && f.id === filiereId && enCours != null) {
                  scope.reportTreeControl.select_branch(
                    scope.reportTree[filiereBranchIndex].children[expand]
                  );
                }
              });

              // feed list pour documents lies depuis documents du dossier
              var toPushF = {
                label:
                  f.properties.nom +
                  (f.properties.etat === 'active' ? ' (filière active)' : ''),
                attachmentData: {
                  id: f.id,
                  featuretype: 'kis_anc_dossier_filiere',
                  feature: f,
                },
              };
              scope.listCtrlFiliereDocumentsLies.filieres.push(toPushF);
              if (f.properties.etat === 'active') {
                scope.currentFiliereShowFiles = toPushF;
              }

              if (defer === true) {
                scope.reportTree.forEach(function(b, i) {
                  if (b.label === 'Filières') {
                    scope.reportTreeControl.select_branch(b.children[0]);
                    scope.reportTreeControl.expand_branch(scope.currentBranch);
                  }
                });
              }
            });
          });

          if (select_branch && controleId) {
            scope.reportTree.forEach(function(b, i) {
              if (b.label === 'Contrôles') {
                scope.reportTreeControl.select_branch(b.children[0]);
                scope.reportTreeControl.expand_branch(scope.currentBranch);
              }
            });
          }

          if (angular.isUndefined(doNotResetCtrl) || !doNotResetCtrl)
            refreshListeControles(
              filiereBranchIndex,
              hasFiliereActive,
              controleId
            );
          else if (doNotResetCtrl) {
            if (
              (angular.isUndefined(scope.filiereActive) ||
                angular.equals(scope.filiereActive, {})) &&
              scope.currentControle.properties.est_dernier_controle_cloture ===
                true
            ) {
              scope.reportTree[filiereBranchIndex].children.forEach(function(
                f,
                idx
              ) {
                if (
                  f.filiereId ===
                  scope.currentControle.properties.reference_filiere
                )
                  scope.reportTree[filiereBranchIndex].children[idx].classes = [
                    'inactiveTreeBranch',
                    'showTreeBranch',
                  ];
              });
            }
          }
          scope.getControlesFacturationAnnuelleData();

        };

        var getftiForAttribute = function(nom, id_element) {
          var fti = {};
          var ft = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            id_element.split('.')[0]
          );

          for (var i in ft.attributes) {
            if (ft.attributes[i].name === nom) {
              // nom = ft.attributes[i];
              fti = ft.attributes[i];
              break;
            }
          }
          return fti;
        };

        function inArray(needle, haystack) {
          var count = haystack.length;
          for (var i = 0; i < count; i++) {
            if (haystack[i] === needle) {
              return true;
            }
          }
          return false;
        }

        function getPropValue(obj, name) {
          var value;
          for (var key in obj) {
            if (key === name) {
              value = obj[key];
            }
          }
          return value;
        }

        function isJsondata(property) {
          return property == 'caracteristiques_hab';
        }

        /**
         *  EDG:  Paramétré datatype ajouté car le champ "type_habitation"
         *        apparait dans bdd dans table kis_dossier avec sa liste
         *        de valeurs et dans le json de kis_dossier_controle avec
         *        une liste déroulante associé. Ce champ apparaît 2 fois et
         *        la valeur (ou "" si pas de valeur) de la deuxième liste parsé
         *        est prise en compte.
         *        Dans l'idéla il faut tagger chaque propriété par un indictaur
         *        qui dit quelle est sa source pour lui appliquer la bonne
         *        liste de valeurs.
         *        le cas géré de cette manière ici est seulement le cas
         *        de "caracteristiques_hab".
         */
        function traverseAndReplaceListeDeroulantes(
          o,
          toReplace,
          prevKey,
          datatype
        ) {
          // Key collecte_eau already exists as a restrict domain for
          // FO3. This is needed to prevent value replacement for radio button
          if (scope.currentControle.properties.type === 'FO4') {
            delete toReplace.collecte_eau;
          }

          for (var i in o) {
            if (isJsondata(i) && datatype != 'jsondata') continue;
            if (!!o[i] && typeof o[i] == 'object') {
              traverseAndReplaceListeDeroulantes(
                o[i],
                toReplace,
                prevKey + (prevKey === '' ? '' : '.') + i,
                datatype
              );
            } else {
              if (angular.isDefined(toReplace[i])) {
                o[i] = toReplace[i][o[i]];
              }
            }
          }
        }

        /**
         * emptyTemplate
         *
         * @param template
         * @returns {boolean}
         */
        var emptyTemplate = function(template) {
          var isEmpty = false;
          var chk = template[scope.typeControle.replace('_mutation', '')];

          if (
            chk[0] &&
            chk[0].items &&
            chk[0].items.length === 1 &&
            Object.keys(chk[0].items[0]).length === 0
          ) {
            isEmpty = true;
          }

          return isEmpty;
        };

        var setElementNoTemplate = function(
          ft,
          elem,
          new_elem,
          copyFromTemplate
        ) {
          var typesControle = [],
            beginByCtrl = new RegExp('^ctrl*');

          // boucle sur les attributs du fti pour conserver l' ordre
          for (var idx in ft.attributes) {
            var ftiAttribute = ft.attributes[idx];
            var isControleAttribute = beginByCtrl.test(ftiAttribute.name);
            var isRelatedControleAttribute = false;

            var name =
              scope.currentControle.properties.type.toLowerCase() + '_';
            if (name.endsWith('_mutation_'))
              name = name.replace('_mutation', '');

            if (ftiAttribute.name.indexOf(name) !== -1) {
              if (
                name ===
                scope.currentControle.properties.type
                  .toLowerCase()
                  .substring(0, 3) +
                  '_'
              ) {
                isRelatedControleAttribute = true;
              }
            }

            var displayValue = null;
            if (
              angular.isDefined(elem.data.properties[ftiAttribute.name]) &&
              elem.data.properties[ftiAttribute.name] != null
            ) {
              var propss = elem.data.properties;
              if (
                ftiAttribute.restrictions.length > 0 &&
                angular.isUndefined(copyFromTemplate)
              ) {
                // test to check if restrictions exist
                if (
                  angular.isDefined(
                    ftiAttribute.restrictions[0].listofValues
                  ) &&
                  angular.isDefined(
                    ftiAttribute.restrictions[0].listofValues[
                      propss[ftiAttribute.name]
                    ]
                  )
                )
                  displayValue =
                    ftiAttribute.restrictions[0].listofValues[
                      propss[ftiAttribute.name]
                    ];
              } else {
                if (propss[ftiAttribute.name] instanceof Object)
                  displayValue = propss[ftiAttribute.name].value;
                else displayValue = propss[ftiAttribute.name];
              }
            } else {
              displayValue = '-';
            }

            // ignore si commence par caj_id_
            if (ftiAttribute.name.indexOf('caj_id') !== 0) {
              if (isRelatedControleAttribute) {
                new_elem.controle[ftiAttribute.name] = {
                  value: displayValue,
                  first: 'false',
                  alias: ftiAttribute.alias,
                };
              } else if (!isControleAttribute) {
                new_elem.filiere.attributs[ftiAttribute.name] = {
                  value: displayValue,
                  first: 'false',
                  alias: ftiAttribute.alias,
                };
              }
            }
          }

          return new_elem;
        };

        var setElementFiliereTemplate = function(elemName, elem, new_elem) {
          var tplz = angular.copy(AncAppFactory.getElementsFiliereTemplates());
          var props = [];

          var config =
            tplz[elemName][scope.typeControle.replace('_mutation', '')];
          var items = [];
          var firsts = [];

          for (var k = 0; k < config.length; k++) {
            for (var j = 0; j < config[k].items.length; j++) {
              if (k > 0 && j === 0) {
                firsts.push(config[k].items[j]);
              }
              items.push(config[k].items[j]);
            }
          }

          var propsD = [];
          var propsG = [];
          items.forEach(function(item) {
            propsD.push(item.droite);
            propsG.push(item.gauche);
            props.push(item.droite, item.gauche);
          });
          var firstsxx = [];
          firsts.forEach(function(item) {
            firstsxx.push(item.gauche, item.droite);
          });
          var elemProps = elem.data.properties;

          for (var key in elemProps) {
            if (!inArray(key, props)) {
              delete elemProps[key];
            }
          }
          elem.data.properties = elemProps;

          var elemPropsB = elem.data.properties;
          for (var key in elemPropsB) {
            var ftiAtt = getftiForAttribute(key, elem.data.id);
            var valueAtt;
            if (ftiAtt.restrictions && ftiAtt.restrictions.length > 0) {
              valueAtt = ftiAtt.restrictions[0].listofValues[elemPropsB[key]];
            } else {
              valueAtt = elemPropsB[key];
            }
            if (inArray(key, firstsxx)) {
              var newElem = {
                value: valueAtt,
                first: 'true',
              };
              elemPropsB[key] = newElem;
            } else {
              var newElem = {
                value: valueAtt,
                first: 'false',
              };
              elemPropsB[key] = newElem;
            }
          }

          elem.data.properties = elemPropsB;

          // / remplir l'objet controle dans l'ordre
          for (var i = 0; i < propsD.length; i++) {
            if (propsD[i] !== 0 && propsD[i] !== undefined) {
              var fti = getftiForAttribute(propsD[i], elem.data.id);
              if (angular.isDefined(fti)) {
                var propvalue = getPropValue(elemPropsB, propsD[i]);
                if (angular.isDefined(propvalue)) {
                  propvalue.alias = fti.alias;
                  new_elem.controle[fti.name] = propvalue;
                }
              }
            } else {
              var test = 'vide[' + i + ']';
              // new_elem.controle[test] =" ";
              new_elem.controle[test] = {
                value: ' ',
                first: 'false',
              };
            }
          }

          // remplir l'objet filiere
          for (var i = 0; i < propsG.length; i++) {
            if (propsG[i] !== 0 && propsG[i] !== undefined) {
              var fti = getftiForAttribute(propsG[i], elem.data.id);
              if (angular.isDefined(fti)) {
                var propvalue = getPropValue(elemPropsB, propsG[i]);
                if (angular.isDefined(propvalue)) {
                  propvalue.alias = fti.alias;
                  new_elem.filiere.attributs[fti.name] = propvalue;
                }
              }
            } else {
              var test = 'vide[' + i + ']';
              new_elem.filiere.attributs[test] = {
                value: ' ',
                first: 'false',
              };
            }
          }

          return new_elem;
        };

        var getVilleMairieValue = function(nomVille) {
          var obj = {};
          AncAppFactory.appCfg.main.infosSpancListeVillesCfg.forEach(function(
            v
          ) {
            if (v.value === nomVille) obj = v.maire;
          });

          return obj;
        };

        var getDomaineRestriction = function(fti) {
          var keyvals = {};
          fti.attributes.forEach(function(att) {
            if (
              att.name !== 'civilite' &&
              angular.isDefined(att.restrictions) &&
              att.restrictions.length
            ) {
              keyvals[att.name] = att.restrictions[0].listofValues;
            }
          });
          return keyvals;
        };

        /**
         * transformDataForDocxGeneration
         *
         * @param data
         * @returns {*}
         */
        var transformDataForDocxGeneration = function(data) {
          const def = $q.defer();
          let obj = angular.copy(data);
          let ctrlFiliereData = obj.ctrlFiliereData || {};
          if (!ctrlFiliereData.elements) ctrlFiliereData.elements = [];

          if (angular.isDefined(ctrlFiliereData)) {
            obj.anc_elements_filiere = [];
            obj.anc_elements_filiere_no_template = [];
            let toFill = obj.anc_elements_filiere;
            let toFillSansTemplate = obj.anc_elements_filiere_no_template;

            ctrlFiliereData.elements.forEach(function(elem) {
              let getNoTemplate = false;
              if (elem.data) {
                let ft = FeatureTypeFactory.getFeatureByNameAndDatastore(
                  AncAppFactory.appCfg.main.datastore,
                  elem.data.id.split('.')[0]
                );

                for (let i in scope.listeElementsFilieres) {
                  if (
                    scope.listeElementsFilieres[i].properties.identifiant ===
                    ft.name
                  ) {
                    for (let j in scope.listeTypeFilieres) {
                      if (
                        scope.listeElementsFilieres[i].properties.id_type ===
                        scope.listeTypeFilieres[j].id
                      )
                        ft.type_ef = scope.listeTypeFilieres[j].id;
                      ft.groupe_ef =
                        scope.listeTypeFilieres[j].properties.id_groupe;
                      ft.nom_groupe_ef =
                        scope.listeTypeFilieres[j].properties.nom;
                    }
                  }
                }

                let elemName = elem.data.id.split('.')[0];
                let new_elem = {
                  filiere: {
                    nom: ft.alias,
                    uid: ft.uid,
                    type_ef: ft.type_ef,
                    groupe_ef: ft.groupe_ef,
                    nom_groupe_ef: ft.nom_groupe_ef,
                    id_element_filiere: elem.data.id,
                    attributs: {},
                  },
                  controle: {},
                };

                let new_elem_no_template = {
                  filiere: {
                    nom: ft.alias,
                    uid: ft.uid,
                    type_ef: ft.type_ef,
                    groupe_ef: ft.groupe_ef,
                    nom_groupe_ef: ft.nom_groupe_ef,
                    id_element_filiere: elem.data.id,
                    attributs: {},
                  },
                  controle: {},
                };

                // /*******************/
                let tplz = angular.copy(
                  AncAppFactory.getElementsFiliereTemplates()
                );
                if (
                  angular.isDefined(tplz[elemName]) &&
                  !emptyTemplate(tplz[elemName])
                ) {
                  new_elem = setElementFiliereTemplate(
                    elemName,
                    elem,
                    new_elem
                  );
                  new_elem_no_template = setElementNoTemplate(
                    ft,
                    elem,
                    new_elem,
                    true
                  );
                  getNoTemplate = true;
                } else {
                  new_elem = setElementNoTemplate(ft, elem, new_elem);
                  new_elem_no_template = new_elem;
                  getNoTemplate = true;
                }

                if (getNoTemplate) {
                  toFillSansTemplate.push(new_elem_no_template);
                  getNoTemplate = false;
                }

                toFill.push(new_elem);
              }
            });

            delete obj.ctrlFiliereData;
          }
          if (scope.kis_anc_listes_deroulantes_controles) {
            let keyvals = getDomaineRestriction(
              scope.kis_anc_listes_deroulantes_controles
            );
            traverseAndReplaceListeDeroulantes(obj, keyvals, '', 'jsondata');
          }

          if (
            angular.isDefined(data.info_generales) &&
            angular.isDefined(data.info_generales.dossier)
          ) {
            obj.infos_maire = getVilleMairieValue(
              data.info_generales.dossier.adresse_ville
            );
          }

          obj.infos_spanc = AncAppFactory.appCfg.main.infosSpanc;
          obj.dossier = scope.currentReport.properties;
          if (scope.dossierFTI) {
            let keyvals = getDomaineRestriction(scope.dossierFTI);
            traverseAndReplaceListeDeroulantes(obj, keyvals, '', 'dbdata');
          }

          obj.controle_type = AncAppFactory.getControleName(
            scope.currentControle.properties.type
          );
          obj.avis = scope.currentControle.properties.avis;

          let typeProchaineControle = gaJsUtils.firstOrDefault(
            scope.typesControle,
            'type',
            scope.currentReport.properties.prochain_controle,
            false
          );
          obj.infos_generales = {
            type_dernier_controle:
              scope.currentReport.properties.type_dernier_controle,
            date_dernier_controle:
              scope.currentReport.properties.date_dernier_controle,
            avis_dernier_controle:
              scope.currentReport.properties.avis_dernier_controle,
            type_prochain_controle: typeProchaineControle
              ? typeProchaineControle.label_court
              : '',
            date_prochain_controle:
              scope.currentReport.properties.date_prochain_controle,
          };

          obj.prochain_controle_preconise = {
            type_prochain_controle_preconise:
              scope.currentControle.properties.type_prochain_controle_preconise,
            date_prochain_controle_preconise: scope.currentControle.properties
              .date_prochain_controle_preconise
              ? $filter('date')(
                scope.currentControle.properties
                  .date_prochain_controle_preconise,
                'dd/MM/yyyy'
              )
              : '',
          };

          if (scope.currentReport.properties.parcelleHabitation) {
            obj.parcelle_habitation = {
              commune:
                scope.currentReport.properties.parcelleHabitation.commune,
              section:
                scope.currentReport.properties.parcelleHabitation.section,
              numero: scope.currentReport.properties.parcelleHabitation.numero,
              surface: scope.cdata.caracteristique_terrain.superficie,
            };
          }

          if (
            scope.currentReport.properties.proprietaires !== undefined &&
            scope.currentReport.properties.proprietaires[0] !== undefined
          ) {
            obj.proprietaire = scope.currentReport.properties.proprietaires[0];
          }
          if (
            scope.currentReport.properties.locataires !== undefined &&
            scope.currentReport.properties.locataires[0] !== undefined
          ) {
            obj.proprietaire = scope.currentReport.properties.locataires[0];
          }
          let CurrentAppFactory = AncAppFactory;
          scope.demandeUrbaFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            CurrentAppFactory.appCfg.main.datastore,
            CurrentAppFactory == BacAppFactory
              ? 'kis_bac_demande_autorisation_urbanisme'
              : 'kis_anc_demande_autorisation_urbanisme'
          );

          obj.demande = {};
          if (scope.currentReport.properties.parcelleHabitation) {
            let filter =
              'id_parcelle IN (\'' +
              scope.currentReport.properties.parcelleHabitation.id +
              '\')';
            QueryFactory.data(scope.demandeUrbaFti.uid, filter)
              .then(function(res) {
                if (
                  res !== undefined &&
                  res.data !== undefined &&
                  res.data.features !== undefined &&
                  res.data.features[0] !== undefined
                ) {
                  obj.demande = res.data.features[0].properties;
                  def.resolve(obj);
                }
              })
              .catch((err) => {
                err.stack;
                throw err;
              })
              .finally(() => def.resolve(obj));
          } else {
            def.resolve(obj);
          }

          return def.promise;
        };

        /**
         * refresh dossiers actions
         *
         * @TODO remove when directive is done
         */
        var refreshDossierActions = function() {
          $rootScope.$broadcast('refreshDossierActions', {
            fid: scope.currentReport.id,
            ftid: scope.dossierFti.uid,
          });
        };

        /**
         * Check wether a report is valid and can be sumbitted
         */
        scope.$on('$typeahead.select', function(v, i) {
          $timeout(function() {
            scope.validReport();
          });
        });
        scope.validReport = function() {
          if (angular.isUndefined(scope.currentReport.properties)) return false;

          var valid = true,
            props = scope.currentReport.properties;

          // mandatory
          if (!props.ref_dossier || props.ref_dossier === '') valid = false;
          return valid;
        };

        var toggleReportBranches = function(isnew) {
          scope.reportTree.forEach(function(b, idx) {
            if (idx > 0) {
              if (isnew) {
                b.classes.push('hiddenTreeBranch');
              } else {
                b.classes.splice(b.classes.indexOf('hiddenTreeBranch'));
              }
            }
          });
        };

        /**
         * Whenever the id is set, allow to upload
         */
        scope.$watch('currentReport.id', function (id) {
          if (angular.isDefined(id)) {
            let dossierAttachmentsNo = ancBacTools.getCurrentDossierAttachmentsInfos(
              scope.doss,
              scope.currentReport
            );
            scope.dossierAttachmentData = {
              id: id,
              featuretype: 'kis_anc_dossier',
              attachmentsNo:
                dossierAttachmentsNo != null && dossierAttachmentsNo.dossierAttachmentsNo != null
                  ? dossierAttachmentsNo.dossierAttachmentsNo
                  : 0,
            };

            toggleReportBranches(0);
            resetNewControle();
          } else {
            toggleReportBranches(1);
          }
        });

        // pick agent
        scope.$watch(
          'newControleAgentPicker.value',
          function(nap) {
            if (
              nap &&
              angular.isDefined(nap) &&
              angular.isDefined(scope.newControle)
            ) {
              scope.newControle.agent = nap.login;
              scope.newControle.agent_name = nap.name + ' ' + nap.vorname;
              scope.newControleAgentPicker = { value: false };
            }
          },
          1
        );

        /**
         * save report
         */
        scope.saveReport = (tmpReference) => {
          let tempDossier = angular.copy(scope.currentReport);
          let alerte = AncAppFactory.getAlerteColorClass(
            new Date(scope.currentReport.properties.alerte_echeance)
          );
          scope.$broadcast('alerteColor', alerte);
          delete tempDossier.properties.attachmentsInfos;
          dateUtils.convertAllDatesToTimestamps(
            tempDossier.properties,
            dossierDateNames
          );

          let featureCollection = {
            type: 'FeatureCollection',
            features: [
              AncAppFactory.ancDossierToDossier(tempDossier, tmpReference),
            ],
          };

          gaDomUtils.showGlobalLoader();

          if (angular.isUndefined(scope.currentReport.id)) {
            if (scope.currentReport.newFromMap) {
              delete scope.currentReport.newFromMap;
            }

            AncAppFactory.adddossier(featureCollection)
              .then((res) => {
                if (res.data === 'already_exist') {
                  require('toastr').error(
                    'Cette référence de dossier est déjà utilisée.',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                  gaDomUtils.hideGlobalLoader();
                } else {
                  require('toastr').success('Dossier enregistré', '', {
                    positionClass: 'toast-bottom-left',
                  });
                  scope.currentReport.id = res.data[0].id;
                  scope.bkpCurrentReport = angular.copy(scope.currentReport);
                  gaDomUtils.hideGlobalLoader();
                  refreshDossierActions();
                  scope.refreshReports();
                  $rootScope.$broadcast(
                    'gcOperationalLayerChange',
                    '',
                    'applyall'
                  );

                  // make cahier de vie not be there before adding filliere
                  if (scope.currentReport !== undefined) {
                    checkCahierDeVie(scope.currentReport);
                  }

                  // permet la maj des documents d'urbanisme
                  $rootScope.$broadcast('modificationParcellesDossier');
                }
              })
              .catch((res) => {
                require('toastr').error(
                  'Impossible d\'enregistrer le dossier.',
                  'Erreur',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
                gaDomUtils.hideGlobalLoader();
              });
          } else {
            AncAppFactory.updatedossier(featureCollection)
              .then((res) => {
                if (res.data === 'already_exist') {
                  require('toastr').error(
                    'Cette référence de dossier est déjà utilisée.',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                  gaDomUtils.hideGlobalLoader();
                } else {
                  scope.bkpCurrentReport = angular.copy(scope.currentReport);
                  refreshDossierActions();
                  gaDomUtils.hideGlobalLoader();
                  scope.refreshReports();
                  require('toastr').success('Dossier mis à jour.', '', {
                    positionClass: 'toast-bottom-left',
                  });
                }
              })
              .catch((res) => {
                require('toastr').error(
                  'Impossible d\'enregistrer le dossier.',
                  'Erreur',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
                gaDomUtils.hideGlobalLoader();
              });
          }
          scope.dossierIsDirty = false;
          var report_id = scope.currentReport.id;
          scope.$emit('updateDebiteurEvent', report_id);
        };

        $rootScope.$on('saveCurrentReport', function(event, data) {
          scope.saveReport();
        });

        /*----------------------------------------------
         * verification que le type Propriétaire est renséignés sur tous les proprietaires
         *---------------------------------------------*/
        scope.verifTypePropriétaire = function(proprietaires) {
          var x = true;
          for (var proprietaire in proprietaires) {
            if (
              !(
                angular.isDefined(
                  proprietaires[proprietaire].typeProprietaire
                ) &&
                proprietaires[proprietaire].typeProprietaire !== null &&
                proprietaires[proprietaire].typeProprietaire.length > 0
              )
            ) {
              x = false;
              break;
            }
          }
          return x;
        };

        /*----------------------------------------------
         * CONTROLE
         *---------------------------------------------*/

        scope.typesControle = AncAppFactory.appCfg.main.controleCfg;

        /**
         * makeNewFiliere
         */
        var resetNewControle = function() {
          scope.newControle = {
            ref_dossier: scope.currentReport.id,
            reference_filiere: '',
            agent: '',
            agent_name: '',
            type: scope.currentReport.properties.prochain_controle
              ? scope.currentReport.properties.prochain_controle
              : scope.typesControle[0].type,
            etat: 'ouvert',
            date_saisie_controle: $filter('date')(
              new Date(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            ),
            est_dernier_controle_cloture: false,
          };
          scope.newControleAgentPicker = { value: false };
          setDefaultControleAgent();
        };

        // used to change the last ctrl type
        scope.newCtrlType = {};

        /**
         * Changer le type d'un controle changeControleType
         */
        scope.changeControleType = function() {
          var ans = confirm(
            'Confirmez-vous le changement du type de contrôle ?\nToute information non commune aux deux types de contrôle sera perdue.'
          );
          if (ans) {
            gaDomUtils.showGlobalLoader();


            /**
             * Avant la création d'un nouveau controle ,
             * on fait la verification si on a des controles à maj
             */
            scope.updateControlesArreterFacturationAnnuelle(
              scope.newCtrlType.value
            );

            AncAppFactory.getNewControleData(
              scope.currentReport.id,
              scope.currentControles,
              scope.newCtrlType.value
            ).then(function(newCtrlData) {
              var dernierControle = angular.copy(scope.currentControles[0]);
              dernierControle.properties.type = scope.newCtrlType.value;

              // update controle type
              AncAppFactory.updatecontrole({
                type: 'FeatureCollection',
                features: [dernierControle],
              }).then(
                function(res) {
                  refreshListeControles();
                  if (newCtrlData) {
                    newCtrlData.conformite = {};
                    // update controle detail (json)
                    AncAppFactory.addcontroledetail(
                      newCtrlData,
                      scope.currentReport.id,
                      dernierControle.id
                    ).then(
                      function(res) {
                        scope.currentReport.properties.prochain_controle =
                          scope.newCtrlType.value;
                        scope.currentReport.properties.date_prochain_controle_preconise = null;
                        gaDomUtils.hideGlobalLoader();
                        scope.saveReport();
                      },
                      function() {
                        gaDomUtils.hideGlobalLoader();
                      }
                    );
                  } else {
                    gaDomUtils.hideGlobalLoader();
                  }
                },
                function() {
                  gaDomUtils.hideGlobalLoader();
                }
              );
            });
          }
        };

        /**
         *  Fonction permettant de récupérer les données du contrôle précédent
         */
        scope.getPreviousData = () => {

          let prevId = '';
          if (scope.currentControles && scope.currentControles.length > 1) {
            let idMax = 0;
            let idPrev = 0;
            scope.currentControles.forEach(ctrl => {
              if (ctrl.id.split('.')[1] > idMax) {
                idMax = ctrl.id.split('.')[1];
              } else {
                if (idMax > idPrev && idPrev < ctrl.id.split('.')[1]) {
                  idPrev = ctrl.id.split('.')[1];
                  prevId = ctrl.id;
                }
              }
            });
          }

          AncAppFactory.getNewControleData(
              scope.currentReport.id,
              scope.currentControles,
              scope.currentControle.properties.type,
              prevId
          ).then((newCtrlData = {}) => {
              if (
                  Object.keys(newCtrlData).length > 0 &&
                  confirm(
                      'Récupérer les informations disponibles à partir du contrôle précédent ?'
                  )
              ) {
                if (newCtrlData.modif) {
                  newCtrlData.modif = { aucune: '1' };
                }
                return newCtrlData;
              }
            })
            .then((newControleData) => {
              if (
                  !Object.keys(newControleData.caracteristiques_install || {})
                      .length
              ) {
                return newControleData;
              }

              newControleData.caracteristiques_install = Object.assign(
                  scope.cdata.caracteristiques_install || {},
                  newControleData.caracteristiques_install || {}
              );
              newControleData.ctrlFiliereData = scope.cdata.ctrlFiliereData;

              const currentControl = scope.currentControles.find(
                  (controle) => controle.id === prevId
              );
              if (
                  !currentControl ||
                  !currentControl.properties ||
                  !currentControl.properties.reference_filiere
              ) {
                return newControleData;
              }

              const oldControleFilliere = scope.currentFilieres.find(
                  (filiere) =>
                      filiere.id === currentControl.properties.reference_filiere
              );
              if (
                  !oldControleFilliere ||
                  !(oldControleFilliere.elements || []).length
              ) {
                return newControleData;
              }

              const currentControleFilliere = angular.copy(
                  scope.currentFilieres.find(
                      (filiere) =>
                          filiere.id ===
                          scope.currentControle.properties.reference_filiere
                  )
              ) || { elements: [] };

              const toAddElements = oldControleFilliere.elements.filter(
                  (oldControleFiliereElement) => {
                    return !currentControleFilliere.elements.find(
                        (element) =>
                            element.properties.feature_uid ===
                            oldControleFiliereElement.properties.feature_uid
                    );
                  }
              );
              if (toAddElements.length === 0) {
                return newControleData;
              }

              const promises = toAddElements.map((element) => {
                return QueryFactory.get(
                    element.properties.feature_uid,
                    element.properties.feature_id
                )
                .catch(() => false)
                .then((res) => {
                  if (
                      !res ||
                      !res.data ||
                      !(res.data.features || []).length
                  ) {
                    return res;
                  }
                  res.data.features = res.data.features.map((feature) => {
                    delete feature.id;
                    return feature;
                  });
                  const featureCollection = {
                    features: res.data.features,
                    type: res.data.type,
                  };
                  return EditFactory.add(
                      element.properties.feature_uid,
                      featureCollection
                  ).then((addedElement) => {
                    const ftid = addedElement.data.create[0].id;
                    return CurrentAppFactory.addelementtofiliere(
                        currentControleFilliere.id,
                        element.properties.feature_uid,
                        ftid
                    ).then((addedElementRelation) => {
                      $rootScope.$broadcast(
                          'refreshRepresentationDisplayElements',
                          {
                            uid: element.properties.feature_uid,
                            featureCollection: featureCollection,
                            ftid: ftid,
                          }
                      );
                      const resetDossierData = {
                        doNotTriggerDirtyRF: true,
                        doNotResetCtrl: true,
                      };
                      $rootScope.$broadcast(
                          'resetDossierArborescence',
                          resetDossierData
                      );
                      return addedElementRelation;
                    });
                  });
                });
              });

              return $q.all(promises).then(() => {
                $rootScope.$broadcast('ajoutElementFiliere', {
                  filiereId: true,
                  reset: true,
                });
                return newControleData;
              });
            })
            .then(newCtrlData => (scope.cdata = newCtrlData));
        };

        $rootScope.$on('add_controle_to_dossier', function(
          event,
          date_passage_rdv
        ) {
          if (scope.nextControle.data) {
            var dateSaisie = $filter('date')(
              new Date(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            );
            scope.newControle = {
              agent: scope.currentControle.properties.agent,
              date_saisie_controle: dateSaisie,
              est_dernier_controle_cloture: false,
              etat: 'ouvert',
              ref_dossier: scope.currentReport.id,
              reference_filiere: '',
              type: scope.nextControle.data.type,
              date_max: scope.nextControle.data.delai
                ? scope.nextControle.data.dateMax
                : null,
            };

            if (
              angular.isDefined(date_passage_rdv) &&
              date_passage_rdv.length > 0
            )
              scope.newControle.date_passage_rdv = date_passage_rdv;

            scope.newControle.type = scope.nextControle.data.type;
            scope.addControleToDossier(date_passage_rdv);

            $timeout(function() {
              AncAppFactory.getNewControleData(
                scope.currentReport.id,
                scope.currentControles,
                scope.newCtrlType.value
              ).then(function(newCtrlData) {
                var dernierControle = angular.copy(scope.currentControles[0]);
                dernierControle.properties.type = scope.newCtrlType.value;
                var data = { control: dernierControle };
                avisControleDialog.close();
                $rootScope.$broadcast('save_current_event_control', data);
              });
            }, 2000);
          }
        });

        $rootScope.$on('refresh_liste_controle', function(event, data) {
          refreshListeControles();
        });

        /**
         * addControleToDossier
         */
        scope.addControleToDossier = function(
          date_passage_rdv,
          open_calendar,
          select_new_branch
        ) {
          var filiere_id;
          var canAddNew = true;
          if (scope.currentControles.length) {
            scope.currentControles.forEach(function(cc) {
              if (cc.properties.etat === 'ouvert') {
                canAddNew = false;
              }
            });
          } else {
            if (
              scope.currentFilieres &&
              scope.currentFilieres[0] &&
              scope.currentFilieres[0].id
            ) {
              filiere_id = scope.currentFilieres[0].id;
            }
          }

          if (!canAddNew) {
            alert('Un contrôle est en cours pour ce dossier.');
            return;
          }

          gaDomUtils.showGlobalLoader();

          // recuperation des cles communes avec l'ancien controle
          AncAppFactory.getNewControleData(
            scope.currentReport.id,
            scope.currentControles,
            scope.newControle.type
          ).then(
            function(newCtrlData) {
              if (newCtrlData) {
                if (Object.keys(newCtrlData).length > 0) {
                  if (
                    !confirm(
                      'Récupérer les informations disponibles à partir du contrôle précédent ?'
                    )
                  ) {
                    newCtrlData = false;
                  }
                }
              }

              var toSubmit = angular.copy(scope.newControle);
              delete toSubmit.agent_name;
              toSubmit.statut_facture = 'aucune';

              // create controle feature collection
              var cFC = {
                type: 'FeatureCollection',
                features: [
                  {
                    type: 'Feature',
                    properties: toSubmit,
                  },
                ],
              };

              if (
                angular.isDefined(
                  scope.currentReport.properties
                    .type_prochain_controle_preconise
                ) &&
                scope.currentReport.properties
                  .type_prochain_controle_preconise != null
              ) {
                if (
                  scope.currentReport.properties
                    .type_prochain_controle_preconise !==
                  cFC.features[0].properties.type
                )
                  scope.currentReport.properties.date_prochain_controle_preconise = null;
              }
              if (angular.isUndefined(filiere_id) && newCtrlData === false) {
                filiere_id = 'newFiliere';
              }

              /**
               * Avant la création d'un nouveau controle , on fait la verification si on a des controles à maj
               */
              scope.updateControlesArreterFacturationAnnuelle(cFC.features[0].properties.type);

              AncAppFactory.addcontrole(
                cFC,
                scope.currentReport.id,
                filiere_id
              ).then(
                function(res) {
                  var newControleId = res.data;
                  if (angular.isDefined(date_passage_rdv)) {
                    if (
                      date_passage_rdv != null &&
                      date_passage_rdv.length > 0
                    ) {
                      if (!newCtrlData) {
                        newCtrlData = {};
                      }

                      if (!newCtrlData.datesDossier) {
                        newCtrlData.datesDossier = {};
                      }

                      newCtrlData.datesDossier.date_controle_rdv = date_passage_rdv;
                    }
                  }
                  // init new ctrl data
                  if (newCtrlData) {
                    // force no modif aucune
                    if (angular.isDefined(newCtrlData.modif)) {
                      newCtrlData.modif = { aucune: '1' };
                    }
                    AncAppFactory.addcontroledetail(
                      newCtrlData,
                      scope.currentReport.id,
                      newControleId
                    ).then(function(res) {
                      if (open_calendar) scope.actionPriseRdv(true);
                    });
                  }

                  scope.newControleId = newControleId;
                  resetNewControle();
                  require('toastr').success('Contrôle ajouté au dossier.', '', {
                    positionClass: 'toast-bottom-left',
                  });

                  // change le statut du dossier
                  scope.currentReport.properties.etat_dossier = 'en_cours';
                  scope.currentReport.properties.prochain_controle =
                    toSubmit.type;
                  scope.saveReport();

                  setDossierArborescence(
                    false,
                    newControleId,
                    false,
                    false,
                    undefined,
                    false,
                    select_new_branch
                  );
                  gaDomUtils.hideGlobalLoader();
                },
                function() {
                  gaDomUtils.hideGlobalLoader();
                }
              );
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * Recuperation de l'url du formulaire de controle
         */
        scope.getFormulaireControleURL = function() {
          var file;
          scope.typesControle.forEach(function(x) {
            if (scope.currentControle.properties) {
              if (x.type === scope.currentControle.properties.type)
                file = x.template;
            }
          });

          return 'js/XG/widgets/ancapp/main/views/controle/' + file;
        };

        var getLogin = function(username) {
          var res = username;
          if (userslist && userslist.length) {
            userslist.forEach(function(user) {
              var compare = user.vorname + ' ' + user.name;
              if (compare === username) {
                res = user.login;
              }
            });
          }
          return res;
        };

        $rootScope.$on('save_controle_detail', function(event) {
          scope.saveControleDetail(0);
        });

        scope.feedMode = true;
        scope.toggleDisplayFeed = () => {
          scope.feedMode = !scope.feedMode;
          $rootScope.$broadcast('toggleDisplayFeeder');
        };

        scope.feedModeDossier = true;
        scope.toggleDisplayFeedDossier = function() {
          scope.feedModeDossier =
            scope.feedModeDossier === false ? true : false;
          $rootScope.$broadcast('toggleDisplayFeederDossier');
        };

        scope.displayFeedDossier = false;
        scope.$on('toggleDisplayFeederDossier', function() {
          if (!scope.isMobile) {
            scope.displayFeedDossier = !scope.displayFeedDossier;
            if (!scope.displayFeedDossier) {
              $('.feederKey')
                .parent()
                .remove();
              $('.feederKey').remove();
            } else {
              $(
                'input:not(.ancControleFiliere input, #ancListeDossiers input, .vidangeANC input)'
              ).each(function() {
                HtmlUtils.feedInputSignet(this);
              });

              $('textarea')
                .not(
                  '.ancElementFiliere textarea, #ancListeDossiers textarea, .vidangeANC textarea'
                )
                .each(function() {
                  HtmlUtils.feedTextareaSignet(this);
                });

              $(
                'select.form-control:not(.ancControleFiliere > *, #ancListeDossiers > *, .mainListeDossierActions > *, .loadingReports > *, .ancBacMainList > *, .vidangeANC > *)'
              ).each(function() {
                HtmlUtils.feedSelectFormControlSignet(this);
              });

              $(
                'select:not(.ancControleFiliere > *, #ancListeDossiers > *, .mainListeDossierActions > *, .loadingReports > *, .ancBacMainList > *, .vidangeANC > *)'
              ).each(function() {
                HtmlUtils.feedSelectOtherSignet(this);
              });

              $(
                '[form-field]:not(.ancControleFiliere > *, #ancListeDossiers > *, .vidangeANC > *)'
              ).each(function() {
                HtmlUtils.feedFormControlSignet(this);
              });

              $('span.feederKey').on('click', function() {
                HtmlUtils.clickOnFeederKey(this);
              });
            }
          }
        });

        /**
         * saveControleDetail
         */
        scope.saveControleDetail = function(miseAJourComposant) {
          if (
            !gaJsUtils.checkNestedProperty('general.statut_rdv', scope.cdata)
          ) {
            gaJsUtils.setNestedProperty(
              'general.statut_rdv',
              scope.cdata,
              null
            );
          }

          if (!angular.isDefined(scope.cdata.conformite)) {
            scope.cdata.conformite = {
              agent: null,
              avis_agent: null,
              avis: null,
              responsable: null,
            };
          }

          if (
            scope.cdata.caracteristiques_terrain &&
            scope.cdata.caracteristiques_terrain.captage != 1
          ) {
            delete scope.cdata.caracteristiques_terrain.consomhumaine;
            delete scope.cdata.caracteristiques_terrain.distance;
            delete scope.cdata.caracteristiques_terrain.declare;
          }

          if (gaJsUtils.checkNestedProperty('datesDossier', scope.cdata)) {
            Object.keys(scope.cdata.datesDossier).forEach(function(date) {
              if (scope.cdata.datesDossier[date] === '') {
                scope.cdata.datesDossier[date] = null;
              }
            });
          }

          var dateToInsert = extractDateToDatePassageSelonTypeCtrl();
          var toCompare = {
            agent: getLogin(scope.cdata.conformite.agent),
            avis: scope.cdata.conformite.valeur,
            avis_agent: scope.cdata.conformite.valeur_agent,
            date_avis:
              scope.cdata.datesDossier.date_avis || null,
            date_avis_agent: scope.cdata.datesDossier.date_avis_controleur,
            date_passage:
              angular.isDefined(scope.cdata.datesDossier[dateToInsert]) &&
              scope.cdata.datesDossier[dateToInsert] != null &&
              scope.cdata.datesDossier[dateToInsert].length
                ? scope.cdata.datesDossier[dateToInsert]
                : scope.cdata.datesDossier.date_avis,

            id_demandeur: scope.currentControle.properties.id_demandeur,
            date_passage_rdv:
              angular.isDefined(scope.cdata.datesDossier.date_controle_rdv) &&
              scope.cdata.datesDossier.date_controle_rdv != null &&
              scope.cdata.datesDossier.date_controle_rdv.length
                ? scope.cdata.datesDossier.date_controle_rdv
                : null,
            responsable: getLogin(scope.cdata.conformite.responsable),
            statut_rdv: scope.cdata.general.statut_rdv,
          };

          // force le bon format de date sur le controle
          ['date_avis', 'date_avis_agent', 'date_passage'].forEach(function(x) {
            if (toCompare[x] === '') toCompare[x] == null;
            else
              toCompare[x] = $filter('date')(
                toCompare[x],
                'yyyy-MM-ddTHH:mm:ss.sssZ'
              );
          });

          Object.keys(scope.currentControle.properties).forEach(function(
            currProp
          ) {
            Object.keys(toCompare).forEach(function(newProp) {
              if (currProp === newProp) {
                if (
                  scope.currentControle.properties[currProp] !==
                  toCompare[newProp]
                ) {
                  if (
                    !(
                      newProp === 'agent' &&
                      (toCompare[newProp] == null || toCompare[newProp] == null)
                    )
                  ) {
                    scope.currentControle.properties[currProp] =
                      toCompare[newProp];
                  }
                  if (
                    !(
                      newProp === 'date_passage' &&
                      (toCompare[newProp] == null || toCompare[newProp] == null)
                    )
                  ) {
                    scope.currentControle.properties[currProp] =
                      toCompare[newProp];
                  }
                  if (
                    !(
                      newProp === 'date_passage_rdv' &&
                      (toCompare[newProp] == null || toCompare[newProp] == null)
                    )
                  ) {
                    scope.currentControle.properties[currProp] =
                      toCompare[newProp];
                  }
                }
              }
            });
          });

          var needToSaveDossier = false;

          if (
            angular.isDefined(scope.cdata.conformite.valeur) &&
            scope.currentReport.properties.avis_dernier_controle !==
              scope.cdata.conformite.valeur &&
            scope.currentControle.properties.etat === 'clos'
          ) {
            scope.currentReport.properties.avis_dernier_controle =
              scope.cdata.conformite.valeur;
            needToSaveDossier = true;
          }

          // update service controle
          if (
            angular.isDefined(scope.cdata.service_controle) &&
            angular.isDefined(scope.cdata.service_controle.nom)
          ) {
            scope.currentControle.properties.json_service_controle =
              scope.cdata.service_controle.nom;
          }

          function isLastClosedControle() {
            let isClosedControle =
              angular.isDefined(scope.currentControle.properties.etat) &&
              scope.currentControle.properties.etat === 'clos';
            if (!isClosedControle) {
              return false;
            }
            return scope.currentControle.properties
              .est_dernier_controle_cloture;
          }

          if (isLastClosedControle()) {
            let dateControle = scope.cdata.datesDossier.date_controle;
            // if it's Reception (FO0) then we take the date_demande info
            if (scope.currentControle.properties.type === 'FO0') {
              dateControle = scope.cdata.datesDossier.date_demande;
            }
            if (
              angular.isDefined(scope.cdata.datesDossier.date_controle) &&
              scope.currentReport.properties.date_dernier_controle !==
                dateControle
            ) {
              scope.currentReport.properties.date_dernier_controle = dateControle;
              needToSaveDossier = true;
            }
          }

          if (
            angular.isDefined(scope.currentControle.properties.etat) &&
            scope.currentControle.properties.etat === 'ouvert'
          ) {
            if(!scope.activeRdv) {
              needToSaveDossier = scope.calculeDateRdv(needToSaveDossier);
            }
          }

          if (needToSaveDossier) {
            scope.saveReport();
          }
          if (!scope.activeRdv) {
            if (
              angular.isDefined(scope.cdata.datesDossier.date_controle_rdv) &&
              scope.cdata.datesDossier.date_controle_rdv !== {}
            ) {
              scope.currentControle.properties.date_passage_rdv = $filter(
                'date'
              )(
                scope.cdata.datesDossier.date_controle_rdv,
                'yyyy-MM-ddTHH:mm:ss.sssZ'
              );
            }
          }
          /**
           * Maj Date PAssage selon type Controle
           */
          if (dateToInsert != 'date_intervention') {
            scope.currentControle.properties.date_passage =
              angular.isDefined(scope.cdata.datesDossier[dateToInsert]) &&
              scope.cdata.datesDossier[dateToInsert] != null
                ? $filter('date')(
                  scope.cdata.datesDossier[dateToInsert],
                  'yyyy-MM-ddTHH:mm:ss.sssZ'
                )
                : scope.cdata.datesDossier.date_avis;
          } else {
            scope.currentControle.properties.date_passage =
              angular.isDefined(scope.cdata.general[dateToInsert]) &&
              scope.cdata.general[dateToInsert] != null
                ? $filter('date')(
                  scope.cdata.general[dateToInsert],
                  'yyyy-MM-ddTHH:mm:ss.sssZ'
                )
                : null;
          }
          // Maj label affiché sur le contrôle
          if (
            (!scope.currentControle.properties.date_passage ||
              !scope.currentControle.properties.date_passage.length) &&
            scope.currentControle.properties.date_avis
          ) {
            scope.currentControle.properties.date_passage =
              scope.currentControle.properties.date_avis;
          }
          var ctrlLabel = AncAppFactory.getControleName(
            scope.currentControle.properties.type,
            scope.currentControle.properties.date_passage
          );
          scope.currentBranch.label = ctrlLabel;

          gaDomUtils.showGlobalLoader();


          const def = $q.defer();

          AncAppFactory.updatecontrole({
            type: 'FeatureCollection',
            features: [scope.currentControle],
          }).then(function() {
            if (
              angular.isDefined(scope.currentControle.properties.date_passage)
            ) {
              scope.currentFilieres.forEach(function(f) {
                if (
                  f.id === scope.currentControle.properties.reference_filiere &&
                  $filter('date')(
                    scope.currentControle.properties.date_passage,
                    'dd.MM.yyyy'
                  ) != null &&
                  f.properties.nom !==
                    'Filière' +
                      ' ' +
                      $filter('date')(
                        scope.currentControle.properties.date_passage,
                        'dd.MM.yyyy'
                      )
                ) {
                  scope.filiereToUpdate = angular.copy(f);
                  scope.filiereToUpdate.properties.nom =
                    'Filière ' +
                    $filter('date')(
                      scope.currentControle.properties.date_passage,
                      'dd.MM.yyyy'
                    );
                  if (angular.isDefined(scope.filiereToUpdate.elements))
                    delete scope.filiereToUpdate.elements;
                  EditFactory.update(scope.filiereFTI.uid, {
                    type: 'FeatureCollection',
                    features: [scope.filiereToUpdate],
                  });
                }
              });

              if (angular.isDefined(scope.filiereToUpdate)) {
                var filiereBranchId;
                scope.reportTree.forEach(function(branch, i) {
                  if (branch.identifier === 'filieres') filiereBranchId = i;
                });
                scope.reportTree[filiereBranchId].children.forEach(function(
                  branch
                ) {
                  if ((branch.filiereId = scope.filiereToUpdate.id))
                    branch.label = scope.filiereToUpdate.properties.nom;
                });
              }
            }
            scope.checkDiffCdata = angular.copy(scope.cdata);
          }).then( () => {
            var filieresToSave = [];

            // sauve tous les elements de filiere si présents
            if (
              scope.cdata &&
              scope.cdata.ctrlFiliereData &&
              scope.cdata.ctrlFiliereData.elements
            ) {
              scope.cdata.ctrlFiliereData.elements.forEach(function(
                element,
                index
              ) {
                // nettoyage element.data depuis migration fme
                // Bug improbable sur CISE, décommenter si jamais..!
                // var elemId = angular.isDefined(element.data.id) ?
                // element.data.id : element.data.ID
                var uid = element.data.id.split('.')[0],
                  ftCompare = FeatureTypeFactory.getFeatureByNameAndDatastore(
                    AncAppFactory.appCfg.main.datastore,
                    uid
                  );

                ftCompare.attributes.map(function(attrCompare) {
                  if (attrCompare.type !== 'java.sql.String') {
                    if (
                      angular.isDefined(
                        element.data.properties[attrCompare.name]
                      ) &&
                      element.data.properties[attrCompare.name] === ''
                    ) {
                      element.data.properties[attrCompare.name] = null;
                    }
                  }
                });

                filieresToSave.push(
                  EditFactory.updatespecifiedproperties(
                    element.link.properties.feature_uid,
                    {
                      type: 'FeatureCollection',
                      features: [element.data],
                    }
                  )
                );
              });
            }
            if (scope.currentControle.properties.date_passage) {
              if (!angular.isDefined(scope.cdata.datesDossier))
                scope.cdata.datesDossier = {};
              scope.cdata.datesDossier.date_controle =
                scope.currentControle.properties.date_passage;
            }
            if (scope.currentControle.properties.date_passage_rdv) {
              if (!angular.isDefined(scope.cdata.datesDossier))
                scope.cdata.datesDossier = {};
              scope.cdata.datesDossier.date_controle_rdv =
                scope.currentControle.properties.date_passage_rdv;
            }

            // sauve les elements de filiere ou ne fait rien si pas d'element
            $q.when(filieresToSave.length ? $q.all(filieresToSave) : 1).then(
              function() {
                /*              const FORMAT_DATE = 'yyyy-MM-ddTHH:mm:ss.sssZ';
                const formattedDate = new Date(scope.currentControle.properties.date_passage_rdv);
                scope.currentControle.properties.date_passage_rdv = $filter('date')(formattedDate, FORMAT_DATE);*/
                // add controle detail
                AncAppFactory.addcontroledetail(
                  scope.cdata,
                  scope.currentReport.id,
                  scope.currentControle.id
                ).then(
                  function(res) {
                    require('toastr').success(
                      'Informations du contrôle enregistrées.',
                      '',
                      {
                        positionClass: 'toast-bottom-left',
                      }
                    );

                    // reset dirty variable
                    scope.ctrlFormIsDirty = 0;
                    gaDomUtils.hideGlobalLoader();

                    // refresh listedossier
                    scope.refreshReports();
                    def.resolve();
                  },
                  function() {
                    require('toastr').error(
                      'Un problème est survenu lors de l\'enregistrement du contrôle.',
                      'Erreur',
                      {
                        positionClass: 'toast-bottom-left',
                      }
                    );
                    gaDomUtils.hideGlobalLoader();
                    def.reject();  
                  }
                );
              },
              function() {
                require('toastr').error(
                  'Un problème est survenu lors de l\'enregistrement du contrôle (infos de la filière correspondante).',
                  'Erreur',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
                gaDomUtils.hideGlobalLoader();
                def.reject();
              });
          });
          return def.promise;
        };

        /**
         * Return le label d'un controle d'apres son type (pour utilisation dans
         * les vues)
         *
         * @param type
         * @returns {*}
         */
        scope.getControleName = function(type) {
          return AncAppFactory.getControleName(type);
        };

        scope.openedControles = function(controles) {
          if (angular.isDefined(controles)) {
            return ancBacTools.openedControles(controles);
          }
          return [];
        };

        var avisControleDialog;
        /**
         *
         */
        scope.pre_appliquerAvisControle = function(absentOuRefus) {
          if (scope.kis_anc_listes_deroulantes_controles) {
            let keyvals = getDomaineRestriction(
              scope.kis_anc_listes_deroulantes_controles
            );

            let origine_du_report_annulation = null;

            if (
              keyvals !== undefined &&
              keyvals.origine_du_report_annulation !== undefined
            ) {
              origine_du_report_annulation =
                keyvals.origine_du_report_annulation[
                  scope.cdata.general.origine_du_report_annulation
                ];
            }

            $timeout(function() {
              const where = 'created_by=\'' + $rootScope.xgos.user.login + '\'';
              CalendarFactory.getevents(
                where,
                '',
                '',
                '',
                scope.currentControle.id
              )
                .then(function(res) {
                  if (
                    res.data !== undefined &&
                    res.data.features !== undefined &&
                    res.data.features.length > 0
                  ) {
                    let event = res.data;
                    event.features[0].properties.origine_du_report_annulation_rdv = origine_du_report_annulation;
                    if (scope.cdata.general.statut_rdv_commnentaire) {
                      event.features[0].properties.commentaire_rdv =
                        scope.cdata.general.statut_rdv_commnentaire;
                    }

                    let feature = {
                      collection: {
                        type: 'FeatureCollection',
                        features: [event.features[0]],
                      },
                      users: [
                        [
                          {
                            login: event.agents[0],
                            type: 'concerne',
                          },
                        ],
                      ],
                    };

                    CalendarFactory.updateevent(feature)
                      .then(function(res) {
                        require('toastr').success(
                          'Informations du contrôle enregistrées.',
                          '',
                          {
                            positionClass: 'toast-bottom-left',
                          }
                        );
                      })
                      .catch((err) => {
                        require('toastr').error(
                          'Un problème est survenu lors de l\'enregistrement de l\'evenement.',
                          'Erreur',
                          {
                            positionClass: 'toast-bottom-left',
                          }
                        );
                        err.stack;
                      });
                  }
                })
                .catch((err) => {
                  err.stack;
                });
            }, 0);
          }

          if (absentOuRefus) {
            if (confirm('Veuillez-vous fermer le contrôle ?')) {
              /**
               * lors de l application de statut Absent = date avis = date de jour
               */
              !scope.cdata.datesDossier.date_avis
                ? $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss.sssZ')
                : scope.cdata.datesDossier.date_avis;
              scope.appliquerAvisControle(1);
              scope.cdata.general.statut_rdv_commnentaire = '';
              scope.cdata.general.origine_du_report_annulation = '';
            }
          } else {
            scope.nextControle = {};
            var workflowcfg = angular.copy(
              AncAppFactory.appCfg.main.controleWorkflowCfg
            );

            if (Object.keys(workflowcfg).length === 0) {
              require('toastr').error(
                'La configuration des enchaînements de contrôle n\'est pas faite.',
                'Erreur',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
              return;
            }

            scope.possibilitesProchainCtrl = [];

            scope.checkLabel = scope.cdata.conformite.valeur;

            workflowcfg.forEach(function(wcfg) {
              // seulement si meme type et meme avis
              if (!scope.cdata.general) scope.cdata.general = {};

              let check = [];
              if (
                scope.avisCtrl &&
                wcfg.avis ) {
                check = scope.avisCtrl.filter(
                  (ligneAvis) =>
                    ligneAvis.key == wcfg.avis &&
                    ligneAvis.type_controle == wcfg.current_controle
                );
              }

              if (check !== undefined && check[0] !== undefined) {
                var checkLabel = check[0].label;
              }

              if (
                scope.cdata.conformite.valeur === checkLabel &&
                scope.currentControle.properties.type === wcfg.current_controle
              ) {
                let delai = 0;
                if (wcfg.avec_delai && wcfg.delai) {
                  if (wcfg.delai.type === 'jour') {
                    delai = wcfg.delai.value;
                  } else if (wcfg.delai.type === 'semaine') {
                    delai = wcfg.delai.value * 7;
                  } else if (wcfg.delai.type === 'mois') {
                    delai = wcfg.delai.value * 30;
                  } else if (wcfg.delai.type === 'année') {
                    delai = wcfg.delai.value * 365;
                  }
                  wcfg.delai.typePluriel =
                    wcfg.delai.value > 1 && wcfg.delai.type !== 'mois'
                      ? wcfg.delai.type + 's'
                      : wcfg.delai.type;
                }
                scope.possibilitesProchainCtrl.push({
                  avec_delai: wcfg.avec_delai,
                  label: AncAppFactory.getControleName(wcfg.next_controle),
                  type: wcfg.next_controle,
                  delai: angular.copy(wcfg.delai),
                  date: $filter('date')(
                    moment().add(delai, 'day').toDate(),
                    'yyyy-MM-ddTHH:mm:ss.sssZ'
                  ),
                  dateMax: calcDateMax(
                    scope.currentControle.properties.date_passage,
                    scope.cdata.datesDossier.date_controle,
                    scope.cdata.datesDossier.date_avis,
                    delai
                  ),
                });
                // si un seul on l'ouvre directement
                if (scope.possibilitesProchainCtrl.length === 1) {
                  scope.nextControle.data = scope.possibilitesProchainCtrl[0];
                }
              }
            });

            avisControleDialog = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.avis.controle.html',
              className:
                'ngdialog-theme-plain width800 nopadding miniclose error_dialog',
              closeByDocument: false,
              scope: scope,
            });
          }
        };

        /**
         * checkDateProchainControle
         *
         * @returns {boolean}
         */
        scope.checkDateProchainControle = function() {
          var valid = false;

          if (scope.nextControle.data) {
            var d1 = new Date(scope.nextControle.data.date);
            var d2 = new Date(scope.nextControle.data.dateMax);

            if (d1 <= d2) {
              valid = true;
            }
          }

          return valid;
        };

        var calendarEventTypes = [];
        var getEventTypes = function() {
          // AddMobile
          if (!scope.mobile) {
            CalendarFactory.geteventtypes().then(function(res) {
              calendarEventTypes = CalendarFactory.resources.event_types;
            });
          }
        };
        getEventTypes();

        /**
         * getLibelleControleDepuisCle (PLUS UTILISE)
         *
         * @param val
         * @returns {string}
         */
        var getLibelleControleDepuisCle = function(val) {
          var libelle = '';

          // recup lib avis (yirk !)
          for (var i = scope.avisCtrl.length - 1; i >= 0; i--) {
            if (scope.avisCtrl[i].key === val) {
              libelle = scope.avisCtrl[i].label;
            }
          }

          return libelle;
        };

        /**
         * Application finale de l'avis apres choix du prochain controle
         */
        scope.appliquerAvisControle = function(appliqueDepuisStatutCtrl) {
          gaDomUtils.showGlobalLoader();
          // save controle detail
          scope.saveControleDetail().then(
            function() {
              scope.currentControle.properties.etat = 'clos';
              scope.currentControle.properties.est_dernier_controle_cloture = true;
              scope.currentControle.properties.avis = !appliqueDepuisStatutCtrl
                ? scope.cdata.conformite.valeur
                : scope.cdata.general.statut_rdv;

              if (!appliqueDepuisStatutCtrl) {
                scope.currentControle.properties.avis_agent = angular.isDefined(
                  scope.cdata.conformite.valeur_agent
                )
                  ? scope.cdata.conformite.valeur_agent
                  : null;
              }
              scope.currentControle.properties.date_avis = angular.isDefined(
                scope.cdata.datesDossier.date_avis
              )
                ? $filter('date')(
                  scope.cdata.datesDossier.date_avis,
                  'yyyy-MM-ddTHH:mm:ss.sssZ'
                )
                : null;
              scope.currentControle.properties.date_avis_agent = angular.isDefined(
                scope.cdata.datesDossier.date_avis_controleur
              )
                ? $filter('date')(
                  scope.cdata.datesDossier.date_avis_controleur,
                  'yyyy-MM-ddTHH:mm:ss.sssZ'
                )
                : null;

              if (
                angular.isDefined(scope.cdata.datesDossier.date_passage) &&
                scope.cdata.datesDossier.date_passage !== {}
              )
                scope.currentControle.properties.date_passage = $filter('date')(
                  scope.cdata.datesDossier.date_passage,
                  'yyyy-MM-ddTHH:mm:ss.sssZ'
                );

              scope.currentControle.properties.statut_rdv = scope.cdata.general
                .statut_rdv
                ? scope.cdata.general.statut_rdv
                : 'present';

              // maj des anciens controles => est_dernier_controle_cloture =
              // false
              var listeControlesClos = scope.currentControles.filter(function(
                x
              ) {
                x.properties.etat = 'clos';
                return x.id !== scope.currentControle.id;
              });
              listeControlesClos.map(function(x) {
                x.properties.est_dernier_controle_cloture = false;
              });

              if (
                !appliqueDepuisStatutCtrl &&
                scope.possibilitesProchainCtrl.length
              ) {
                scope.currentControle.properties.date_prochain_controle_preconise =
                  scope.nextControle.data.dateMax &&
                  scope.nextControle.data.delai
                    ? $filter('date')(
                      scope.nextControle.data.dateMax,
                      'yyyy-MM-ddTHH:mm:ss.sssZ'
                    )
                    : null;
                scope.currentControle.properties.type_prochain_controle_preconise = angular.isDefined(
                  scope.nextControle.data.type
                )
                  ? scope.nextControle.data.type
                  : null;
              }

              // update controle object
              AncAppFactory.updatecontrole({
                type: 'FeatureCollection',
                features: [scope.currentControle].concat(listeControlesClos),
              }).then(
                function(res) {
                  // update dossier
                  scope.currentReport.properties.type_dernier_controle =
                    scope.currentControle.properties.type;
                  scope.currentReport.properties.avis_dernier_controle =
                    scope.currentControle.properties.avis;
                  scope.currentReport.properties.date_dernier_controle =
                    scope.currentControle.properties.date_passage;

                  scope.currentReport.properties.prochain_controle = null;
                  scope.currentReport.properties.date_prochain_controle = null;

                  // -----> LOC Comportement non désiré si appliquer
                  // avis contrôle ne crée pas le contrôle suivante
                  // <-------
                  // --> RB on va le reactiver temporairement en
                  // attendant le dev prevu sur ce sujet
                  // sauf si pas de workflow
                  if (
                    !appliqueDepuisStatutCtrl &&
                    scope.possibilitesProchainCtrl.length
                  ) {
                    scope.currentReport.properties.date_prochain_controle_preconise =
                      scope.nextControle.data.dateMax &&
                      scope.nextControle.data.delai
                        ? $filter('date')(
                          scope.nextControle.data.dateMax,
                          'yyyy-MM-ddTHH:mm:ss.sssZ'
                        )
                        : null;
                    scope.currentReport.properties.type_prochain_controle_preconise = angular.isDefined(
                      scope.nextControle.data.type
                    )
                      ? scope.nextControle.data.type
                      : null;
                  }

                  scope.saveReport();

                  if (
                    angular.isDefined(avisControleDialog) &&
                    !scope.priseRDV.active
                  ) {
                    avisControleDialog.close();
                  }
                  if (appliqueDepuisStatutCtrl) {
                    scope.currentBranch.classes.push('inactiveTreeBranch');

                    // undirty
                    scope.ctrlFormIsDirty = 0;

                    scope.reportTree.forEach(function(b, i) {
                      if (b.label === 'Contrôles') {
                        scope.reportTreeControl.select_branch(b);
                        scope.reportTreeControl.collapse_branch(
                          scope.currentBranch
                        );
                      }
                    });
                  }

                  // We need to clean to select inactive filiere after
                  // UI refresh
                  scope.filiereActive = {};
                  scope.reportTreeControl;
                  setDossierArborescence(
                    null,
                    scope.currentControle.id,
                    null,
                    null,
                    null,
                    null,
                    true
                  );

                  gaDomUtils.hideGlobalLoader();
                },
                function() {
                  gaDomUtils.hideGlobalLoader();
                  require('toastr').error(
                    'Erreur lors de la mise à jour du contrôle.'
                  );
                }
              );
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                'Erreur lors de la mise à jour du contrôle.'
              );
            }
          );
        };

        /**
         * makeNewCahier
         */
        var makeNewCahier = function() {
          scope.newCahier = {
            date: $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss.sssZ'),
          };
        };
        makeNewCahier();

        /**
         * addCahierToDossier
         */
        scope.addCahierToDossier = function() {
          var ans = 1;
          if (
            angular.isDefined(scope.currentCahiers) &&
            scope.currentCahiers.length > 0
          ) {
            ans = confirm(
              'Êtes-vous certain de vouloir ajouter un cahier de vie pour ce dossier?\nLe cahier de vie actuellement actif deviendra inactif.'
            );
          }

          if (ans) {
            var nomCahier =
              'Cahier de vie ' +
              $filter('date')(scope.newCahier.date, 'dd.MM.yyyy');

            gaDomUtils.showGlobalLoader();

            AncAppFactory.addcahierdevie(
              scope.currentReport.id,
              nomCahier,
              scope.newCahier.date
            ).then(function() {
              makeNewCahier();
              require('toastr').success(
                'Cahier de vie ajoutée au dossier.',
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );

              setDossierArborescence();
              gaDomUtils.hideGlobalLoader();
            });
          }
        };

        /**
         * makeNewFiliere
         */
        var makeNewFiliere = function() {
          scope.newFiliere = {
            date: $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss.sssZ'),
          };
        };
        makeNewFiliere();

        /**
         * renderRestriction
         */

        scope.renderRestriction = function(fti, att, obj) {
          if (angular.isUndefined(obj)) obj = scope.filiereDuControle;

          var selectedAtt = {};
          if (obj && angular.isDefined(obj.properties))
            var v = obj.properties[att];

          if (angular.isUndefined(fti)) {
            fti = FeatureTypeFactory.getFeatureByNameAndDatastore(
              AncAppFactory.appCfg.main.datastore,
              'kis_anc_dossier_filiere'
            );
          }
          fti.attributes.map(function(ftiAtt) {
            if (ftiAtt.name === att) {
              selectedAtt = ftiAtt;
            }
          });

          for (var i = selectedAtt.restrictions.length - 1; i >= 0; i--) {
            if (v !== undefined && v !== null) {
              if (selectedAtt.restrictions[i].type === 'Domain') {
                if (selectedAtt.restrictions[i].listofValues[v] !== undefined) {
                  var value = selectedAtt.restrictions[i].listofValues[v];
                  if ((att = 'volume_eh' && angular.isDefined(scope.cdata))) {
                    if (angular.isDefined(scope.cdata.general)) {
                      scope.cdata.general.taille_filiere = value;
                    }
                  }
                  return value;
                }
              }
            } else if (v == null) {
              return 'Non défini';
            }
          }
          return v;
        };

        var editFiliereModal;
        scope.openEditFiliere = function(filiere, index) {
          scope.editedFiliere = angular.isDefined(filiere)
            ? angular.copy(filiere)
            : {};
          if (
            scope.editedFiliere.properties !== undefined &&
            scope.editedFiliere.properties.volume_eh !== undefined
          ) {
            scope.editedFiliere.properties.volume_eh = scope.editedFiliere.properties.volume_eh.toString();
          }

          editFiliereModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.filiere.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.updateFiliere = function() {
          var featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };

          gaDomUtils.showGlobalLoader();
          var filiereToUpdate = {};
          if (angular.isDefined(scope.editedFiliere.id)) {
            filiereToUpdate = {
              type: 'Feature',
              id: scope.editedFiliere.id,
              properties: scope.editedFiliere.properties,
            };
            if (angular.isDefined(scope.editedFiliere.geometry))
              filiereToUpdate.geometry = scope.editedFiliere.geometry;

            featureCollection.features.push(filiereToUpdate);
            EditFactory.update(scope.filiereFti.uid, featureCollection).then(
              function(res) {
                require('toastr').success('Enregistré');

                scope.currentFilieres.forEach(function(fil) {
                  if (fil.id === scope.editedFiliere.id)
                    fil.properties.volume_eh =
                      scope.editedFiliere.properties.volume_eh;
                });
                editFiliereModal.close();

                scope.currentReport.properties.filiere_sup_20_eh =
                  ([...scope.currentFilieres] || []).filter(
                    (filliere) =>
                      filliere &&
                      filliere.properties &&
                      parseInt(filliere.properties.volume_eh, 10) !== 0
                  ).length > 0;

                scope.saveReport();

                if (angular.isDefined(scope.currentReport.properties))
                  checkCahierDeVie(scope.currentReport);
              },
              function() {
                require('toastr').error(
                  'Erreur lors de la modification de la filière.',
                  '',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        // Default value for 20EH
        scope.newFiliere.volume_eh = '0';

        /**
         * addFiliereToDossier
         */
        scope.addFiliereToDossier = function() {
          var ans = 1;
          if (
            scope.currentFilieres !== undefined &&
            scope.currentFilieres.length > 0
          ) {
            ans = confirm(
              'Êtes-vous certain de vouloir ajouter une filière pour ce dossier?\nLa filière actuellement active deviendra inactive.'
            );
          }

          if (ans) {
            var nomFiliere =
              'Filière ' + $filter('date')(scope.newFiliere.date, 'dd.MM.yyyy');

            gaDomUtils.showGlobalLoader();

            // sometimes the volume_eh comes as number however the check is made
            // for string
            if (
              scope.newFiliere.volume_eh !== undefined &&
              scope.newFiliere.volume_eh === 0
            ) {
              scope.newFiliere.volume_eh = '0';
            }

            AncAppFactory.addfiliere(
              scope.currentReport.id,
              nomFiliere,
              scope.newFiliere
            )
              .then(function() {
                scope.currentFilieres = Array.isArray(scope.currentFilieres)
                  ? scope.currentFilieres
                  : [];
                scope.currentReport.properties.filiere_sup_20_eh =
                  [...scope.currentFilieres]
                    .concat([
                      {
                        properties: {
                          volume_eh: scope.newFiliere.volume_eh,
                        },
                      },
                    ])
                    .filter(
                      (filliere) =>
                        filliere &&
                        filliere.properties &&
                        parseInt(filliere.properties.volume_eh, 10) !== 0
                    ).length > 0;

                scope.saveReport();

                makeNewFiliere();
                require('toastr').success('Filière ajoutée au dossier.', '', {
                  positionClass: 'toast-bottom-left',
                });

                if (angular.isDefined(scope.currentReport.properties))
                  checkCahierDeVie(scope.currentReport);
              })
              .then(
                function() {
                  scope.newFiliere.volume_eh = 0;
                  setDossierArborescence();
                  gaDomUtils.hideGlobalLoader();
                },
                function() {
                  require('toastr').error(
                    'Erreur lors de l\'ajout de la filière au dossier'
                  );
                  gaDomUtils.hideGlobalLoader();
                }
              );
          }
        };

        // ajout d'un element de filiere depuis la directive
        $rootScope.$on('ajoutElementFiliere', function(event, data) {
          // data.filiereId
          QueryFactory.data(
            elementFiliereFti.uid,
            'id_filiere=\'' + scope.currentFiliere.id + '\''
          ).then(function(res) {
            scope.currentFiliere.elements = AncAppFactory.sortElementsFiliere(
              res.data.features,
              'dossier'
            );
          });
        });

        // Ajout suppression d'élément de filière, mise à jour du
        // tableau d'installation
        scope.$on('updateInstallTab', function(event, data) {
          if (
            angular.isDefined(data) &&
            angular.isDefined(data.currentElementFiliere)
          ) {
            if (
              angular.isDefined(data.currentElementFiliere.select_filiere) &&
              data.currentElementFiliere.select_filiere === true
            ) {
              scope.reportTree.forEach(function(b) {
                if (b.label === 'Filières') {
                  scope.reportTreeControl.select_branch(b);
                  scope.currentBranch = b;
                }
              });
            }
          }

          if (
            angular.isDefined(scope.currentControle) &&
            angular.isDefined(scope.currentControle.properties)
          ) {
            var copieFiliere;
            scope.currentFilieres.forEach(function(f, i) {
              if (f.id === scope.currentControle.properties.reference_filiere) {
                copieFiliere = angular.copy(f);
              }
            });

            AncAppFactory.getinstalltabdetail(
              scope.currentControle.properties.reference_filiere
            ).then(function(res) {
              if (res.data) {
                if (angular.isDefined(scope.cdata.caracteristiques_install)) {
                  Object.keys(scope.cdata.caracteristiques_install).forEach(
                    function(attr) {
                      if (attr.startsWith('has_'))
                        delete scope.cdata.caracteristiques_install[attr];
                    }
                  );
                  Object.keys(res.data).forEach(function(attr) {
                    scope.cdata.caracteristiques_install[attr] = res.data[attr];
                  });
                } else {
                  scope.cdata.caracteristiques_install = res.data;
                }
              }
            });
          }
        });

        // remove element filiere from another directive
        scope.$on('remove_element_filiere', function(event, data) {
          setDossierArborescence();
        });

        // resetDossierArborescence
        scope.$on('resetDossierArborescence', function(event, data) {
          var filiereId = angular.isDefined(data.filiereId)
            ? data.filiereId
            : null;
          var doNotResetCtrl = angular.isDefined(data.doNotResetCtrl)
            ? data.doNotResetCtrl
            : 0;
          doNotTriggerDirtyRF = data.doNotTriggerDirtyRF;
          setDossierArborescence(filiereId, null, null, null, doNotResetCtrl);
        });

        let presetDereg = $rootScope.$on('preset_anc_dossier', (event,data) => {
          if (data.adresse && !data.newFromMap) {
            scope.editReport(
              false,
              data.feature.geometry,
              undefined,
              data.adresse
            );
          } else if (data.adresse && data.newFromMap) {
            scope.editReport(
              false,
              data.feature.geometry,
              undefined,
              data.adresse,
              undefined,
              undefined,
              true
            );
          } else {
            scope.editReport(false, data.feature.geometry);
          }
        });

        // sans ca est appele plusieurs fois si le widget mapwidget est
        // toggled plusieurs fois
        scope.$on('$destroy', function() {
          presetDereg();
          removeListennerOpenDossier();
        });

        /**
         * edit report
         */
        scope.$watch('$routeUpdate', function() {
          var fid = $location.search().fid;
          if (fid) {
            if (fid.split('.')[0] === 'kis_anc_dossier') {
              $rootScope.$broadcast('anc_open_dossier', [{ id: fid }]);
            } else if (fid.split('.')[0] === 'kis_anc_dossier_controle') {
              AncAppFactory.getdossierbycontroleid(fid).then(function(res) {
                if (res.data.features[0]) {
                  $rootScope.$broadcast('anc_open_controle', [
                    {
                      dossier_id: res.data.features[0].id,
                      controle_id: fid,
                    },
                  ]);
                }
              });
            }
          }
        });

        scope.tooltipTitle = {};
        scope.tooltipTitle.titleFilter = 'Appliquer un filtre';
        scope.tooltipTitle.class = 'cursorHelp';

        /*
         * DOCUMENT DOSSIER
         */

        /**
         * setLastImageFiliere
         *
         * @returns {*}
         */
        var setLastImageFiliere = function() {
          var def = $q.defer();

          if (
            angular.isDefined(
              scope.currentControle.properties.reference_filiere
            )
          ) {
            // documents associés à la filiere
            FeatureAttachmentFactory.list(
              'kis_anc_dossier_filiere',
              scope.currentControle.properties.reference_filiere
            ).then(function(res) {
              var documentsFiliere = res.data;
              if (documentsFiliere.length) {
                // tous les fichiers contenant representation_filiere_x.png
                // classes par l'index x
                var files = [];
                documentsFiliere.map(function(d) {
                  if (d.indexOf('representation_filiere') === 0) {
                    var tmp = d.split('_'),
                      idx = angular.isDefined(tmp[2])
                        ? tmp[2].replace('.png', '')
                        : 0;
                    files[idx] = d;
                  }
                });

                // got it
                if (files.length) {
                  def.resolve({
                    id: scope.currentControle.properties.reference_filiere,
                    file: files[files.length - 1],
                  });
                  // nope
                } else {
                  def.resolve(false);
                }
              } else {
                def.resolve(false);
              }
            });
          } else {
            def.resolve(false);
          }

          return def.promise;
        };

        scope.dossierCfg = AncAppFactory.appCfg.main.dossierCfg;
        ConfigFactory.checkTemplates(scope.dossierCfg.templates).then(function(
          res
        ) {
          scope.dossierCfg.templates = res.data;
        });

        scope.getCommentValue = function() {
          const a = 'Danger pour la santé des personnes (Article 4 - cas a).';
          const b = 'Installation non conforme.';
          const c = 'Travaux obligatoire sous 4 ans.';
          const d = 'Travaux dans un délai de un an en cas de vente.';
          const e = 'Installation non conforme (Article 4 - cas c).';
          const g = 'Risque environnemental avéré (Article 4 - cas b).';
          const conclusion_kis =
            'Installation ne présentant pas de non conformité';

          try {
            if (scope.cdata.grille.installation.absent === '1')
              scope.cdata.grille.installation.conc =
                'Non respect de l\'article L.1331-1-1 du code de la santé publique.\nMise en demeure de réaliser une installation conforme.\nTravaux à réaliser dans les meilleurs délais.';
          } catch (error) {}

          try {
            if (scope.cdata.grille.entretien_usure.show_article === 1)
              scope.cdata.grille.entretien_usure.conc =
                'Liste de recommandations pour améliorer le fonctionnement de l\'installation.';
          } catch (error) {}

          try {
            if (
              scope.cdata.grille.conc.enjeusan === '0' &&
              scope.cdata.grille.conc.enjeuenv === '0'
            ) {
              if (scope.cdata.grille.defaut_structure.show_article === 1)
                scope.cdata.grille.defaut_structure.conc =
                  b + '\n' + a + '\n' + c + '\n' + d;
              if (scope.cdata.grille.dysfonctionnement.show_article === 1)
                scope.cdata.grille.dysfonctionnement.conc = e + '\n' + d;
            }
          } catch (error) {}

          try {
            if (
              scope.cdata.grille.conc.enjeusan === '1' &&
              scope.cdata.grille.conc.enjeuenv === '0'
            ) {
              if (scope.cdata.grille.defaut_structure.show_article === 1)
                scope.cdata.grille.defaut_structure.conc =
                  b + '\n' + a + '\n' + c + '\n' + d;
              if (scope.cdata.grille.dysfonctionnement.show_article === 1)
                scope.cdata.grille.dysfonctionnement.conc =
                  b + '\n' + a + '\n' + c + '\n' + d;
            }
          } catch (error) {}

          try {
            if (
              scope.cdata.grille.conc.enjeusan === '0' &&
              scope.cdata.grille.conc.enjeuenv === '1'
            ) {
              if (scope.cdata.grille.defaut_structure.show_article === 1)
                scope.cdata.grille.defaut_structure.conc =
                  b + '\n' + a + '\n' + c + '\n' + d;
              if (scope.cdata.grille.dysfonctionnement.show_article === 1)
                scope.cdata.grille.dysfonctionnement.conc =
                  b + '\n' + g + '\n' + c + '\n' + d;
            }
          } catch (error) {}

          try {
            if (
              scope.cdata.grille.conc.enjeusan === '1' &&
              scope.cdata.grille.conc.enjeuenv === '1'
            ) {
              if (scope.cdata.grille.defaut_structure.show_article === 1)
                scope.cdata.grille.defaut_structure.conc =
                  b + '\n' + a + '\n' + g + '\n' + c + '\n' + d;
              if (scope.cdata.grille.dysfonctionnement.show_article === 1)
                scope.cdata.grille.dysfonctionnement.conc =
                  b + '\n' + g + '\n' + c + '\n' + d;
            }
          } catch (error) {}

          try {
            let hasAucunDefaut = Object.keys(scope.cdata.grille).filter(
              (defaut) => {
                return scope.cdata.grille[defaut].aucun_defaut === '1';
              }
            );

            if (
              angular.isDefined(scope.cdata.grille.installation) &&
              scope.cdata.grille.installation.present === '1'
            ) {
              hasAucunDefaut.push(scope.cdata.grille.installation.present);
            }

            if (
              scope.showConforme === 'avis_conforme' &&
              hasAucunDefaut.length
            ) {
              scope.cdata.grille.conclusion_kis = conclusion_kis;
            } else {
              scope.cdata.grille.conclusion_kis = '';
            }
          } catch (error) {}
        };

        /**
         * getCurrentElementsFiliere
         */
        scope.getCurrentElementsFiliere = function(reference_filiere) {
          if (scope.currentFilieres && scope.currentFilieres.length) {
            for (var i = 0; i < scope.currentFilieres.length; i++) {
              let filiere = scope.currentFilieres[i];
              if (filiere.id === reference_filiere && filiere.elements) {
                scope.currentElementsFiliereslength = filiere.elements.length;
              }
            }
          }
          if (!scope.currentElementsFiliereslength) {
            scope.currentElementsFiliereslength = 0;
          }
        };

        /**
         * getDocxControle Récupération du document tyoe
         */
        scope.getDocxControle = function(fichier, pdf) {
          var ansGenerate = false;
          if (scope.cdata && scope.cdata.ctrlFiliereData) {
            if (
              scope.cdata &&
              scope.cdata.ctrlFiliereData &&
              scope.cdata.ctrlFiliereData.idFiliere
            ) {
              scope.getCurrentElementsFiliere(
                scope.cdata.ctrlFiliereData.idFiliere
              );
              if (
                scope.cdata.ctrlFiliereData.elements &&
                scope.cdata.ctrlFiliereData.elements.length !=
                  scope.currentElementsFiliereslength
              ) {
                ansGenerate = confirm(
                  'Des éléments de filière existent et ne sont pas récupérés.\nÊtes-vous certain de vouloir télécharger le document ?'
                );
              } else {
                ansGenerate = true;
              }
            } else {
              ansGenerate = true;
            }
          } else {
            ansGenerate = confirm(
              'Aucun élément de filière récupéré.\nÊtes-vous certain de vouloir télécharger le document ?'
            );
          }

          if (ansGenerate) {
            scope.getCommentValue();
            if (!fichier) {
              require('toastr').error(
                'Le template word n\'a pas été spécifié pour ce type de document',
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
              return;
            }
            gaDomUtils.showGlobalLoader();

            transformDataForDocxGeneration(scope.cdata).then(function(
              docxdata
            ) {
              docxdata.date_current = $filter('date')(new Date(), 'dd/MM/yyyy');
              docxdata._type_controle = scope.typeControle.replace(
                '_mutation',
                ''
              );
              docxdata._storename = AncAppFactory.appCfg.main.datastore;

              var ctrlLabel = AncAppFactory.getControleName(
                scope.currentControle.properties.type,
                scope.currentControle.properties.date_saisie_controle
              );

              setLastImageFiliere().then(function(lastImageFiliere) {
                if (lastImageFiliere) docxdata.image_filiere = lastImageFiliere;

                DocumentFactory.generatedocx(
                  docxdata,
                  fichier,
                  scope.currentControle.id,
                  pdf
                ).then(
                  function(doto) {
                    if (scope.dossierInfosSup !== undefined) {
                      scope.dossierInfosSup.map((extra_field) => {
                        extra_field.restrictions.map((item) => {
                          if (item.listofValues !== undefined) {
                            for (let key in item.listofValues) {
                              if (item.listofValues.hasOwnProperty(key)) {
                                if (
                                  item.listofValues[key] ===
                                  scope.currentReport.properties[
                                    extra_field.name
                                  ]
                                ) {
                                  scope.currentReport.properties[
                                    extra_field.name
                                  ] = key;
                                }
                              }
                            }
                          }
                        });
                      });
                    }

                    FeatureHistoryFactory.addaction(
                      scope.dossierFti.uid,
                      scope.currentReport.id,
                      'Edition de rapport',
                      'Edition du rapport (' +
                        ctrlLabel +
                        ') ' +
                        fichier +
                        ' par ' +
                        $rootScope.xgos.user.login
                    );
                    gaDomUtils.hideGlobalLoader();
                    window.open(
                      '/services/' +
                        doto.data.portalid +
                        '/documents/downloaddocx?' +
                        '&name=' +
                        doto.data.name.replace('\\', '/')
                    );
                    // refresh featureattachement
                    $rootScope.$broadcast('refreshFeatureAttachment', {
                      id: scope.currentControle.id,
                      featuretype: 'kis_anc_dossier_controle',
                    });
                  },
                  function() {
                    gaDomUtils.hideGlobalLoader();
                    require('toastr').error(
                      'Erreur lors de la génération du document.'
                    );
                  }
                );
              });
            });
          }
        };

        /**
         * getDocxVidange Generation des documents des vidanges
         */
        scope.getDocxVidange = function(fichier, pdf) {
          if (!fichier) {
            require('toastr').error(
              'Le template word n\'a pas été spécifié pour ce type de document',
              '',
              {
                positionClass: 'toast-bottom-left',
              }
            );
            return;
          }
          gaDomUtils.showGlobalLoader();

          var docxdata = {
            vdata: angular.copy(scope.vdata),
          };

          docxdata.date_current = $filter('date')(new Date(), 'dd/MM/yyyy');
          docxdata._storename = AncAppFactory.appCfg.main.datastore;

          DocumentFactory.generatedocx(
            docxdata,
            fichier,
            scope.currentVidange.id,
            pdf
          ).then(
            function(doto) {
              FeatureHistoryFactory.addaction(
                scope.dossierFti.uid,
                scope.currentVidange.id,
                'Edition de rapport de vidange',
                'Edition du rapport ' +
                  fichier +
                  ' par ' +
                  $rootScope.xgos.user.login
              );
              gaDomUtils.hideGlobalLoader();
              window.open(
                '/services/' +
                  doto.data.portalid +
                  '/documents/downloaddocx?' +
                  '&name=' +
                  doto.data.name
              );
              $rootScope.$broadcast('refreshFeatureAttachment', {
                id: scope.currentVidange.id,
                featuretype: 'kis_anc_vidange_formulaire',
              });
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                'Erreur lors de la génération du document.'
              );
            }
          );
        };

        /**
         * getDocxSubvention Generation des documents des subvention
         */
        scope.getDocxSubvention = function(fichier, pdf) {
          if (!fichier) {
            // require('toastr').error("Le template word n'a pas été
            // spécifié pour ce type de document");
            require('toastr').error(
              'Le template word n\'a pas été spécifié pour ce type de document',
              '',
              {
                positionClass: 'toast-bottom-left',
              }
            );
            return;
          }
          gaDomUtils.showGlobalLoader();
          var propertiesEntreprise;
          if (angular.isDefined(scope.currentBranch.subvention)) {
            if (scope.currentBranch.subvention.properties.id_entreprise) {
              scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
                AncAppFactory.appCfg.main.datastore,
                AncAppFactory.appCfg.main.entreprisesCfg.emplacement
              );
              QueryFactory.get(
                scope.entreprisesFti.uid,
                scope.currentBranch.subvention.properties.id_entreprise
              ).then(function(res) {
                propertiesEntreprise = angular.isDefined(res.data.features[0])
                  ? res.data.features[0].properties
                  : null;
                getdocxSubvention(fichier, pdf, propertiesEntreprise);
              });
            } else {
              getdocxSubvention(fichier, pdf);
            }
          }
        };

        var getdocxSubvention = function(fichier, pdf, propertiesEntreprise) {
          var docxdata = {
            currentSubvention: angular.copy(scope.currentBranch.subvention),
            propertiesEntreprise: angular.copy(propertiesEntreprise),
          };

          docxdata.date_current = $filter('date')(new Date(), 'dd/MM/yyyy');
          docxdata._storename = AncAppFactory.appCfg.main.datastore;

          DocumentFactory.generatedocx(
            docxdata,
            fichier,
            scope.currentBranch.subvention.id,
            pdf
          ).then(
            function(doto) {
              FeatureHistoryFactory.addaction(
                scope.dossierFti.uid,
                scope.currentBranch.subvention.id,
                'Edition de rapport de vidange',
                'Edition du rapport ' +
                  fichier +
                  ' par ' +
                  $rootScope.xgos.user.login
              );
              gaDomUtils.hideGlobalLoader();
              window.open(
                '/services/' +
                  doto.data.portalid +
                  '/documents/downloaddocx?' +
                  '&name=' +
                  doto.data.name
              );
              $rootScope.$broadcast('refreshFeatureAttachment', {
                id: scope.currentBranch.subvention.id,
                featuretype: 'kis_anc_dossier_subvention',
              });
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                'Erreur lors de la génération du document.'
              );
            }
          );
        };

        /**
         * getDocxDossier
         *
         * @param fichier
         */
        scope.getDocxDossier = function(fichier, pdf) {
          gaDomUtils.showGlobalLoader();
          var promise = AncAppFactory.getZipDocumentsTypes(
            [scope.currentReport.id],
            [fichier],
            pdf
          );
          promise.then(
            function(res) {
              window.open(
                '/services/' +
                  res.data.portalid +
                  '/documents/downloaddocx?' +
                  '&name=' +
                  res.data.name
              );
              gaDomUtils.hideGlobalLoader();
              // refresh featureattachement
              $rootScope.$broadcast('refreshFeatureAttachment', {
                id: scope.currentReport.id,
                featuretype: 'kis_anc_dossier',
              });
            },
            function() {
              require('toastr').error('Erreur lors de génération du document.');
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * Remove statut facture pour réinitialiser le lien entre dolibarr et le
         * controle
         *
         * @param controle
         */
        scope.removeLinkWithInvoice = function(obj, type) {
          if (type === 'controle') {
            var ans = confirm(
              'Êtes-vous certain de vouloir supprimer la facture associée au contrôle ' +
                obj.properties.type +
                ' ? \r\nAttention: dans cette version, il faut aussi abandonner la facture coté module de facturation.'
            );
            if (ans) {
              obj.properties.statut_facture = 'aucune';
              obj.properties.id_facture_logiciel_facturation = null;

              AncAppFactory.updatecontrole({
                type: 'FeatureCollection',
                features: [obj],
              }).then(function(res) {
                require('toastr').success('Mise à jour effectuée.', '', {
                  positionClass: 'toast-bottom-left',
                });
              });
            }
          } else if (type === 'vidange') {
            var ans = confirm(
              'Êtes-vous certain de vouloir supprimer la facture associée à la vidange ? \r\nAttention: dans cette version, il faut aussi abandonner la facture coté module de facturation.'
            );
            if (ans) {
              obj.properties.statut_facture = 'aucune';
              obj.properties.id_facture_logiciel_facturation = null;

              EditFactory.update(
                scope.vidangeFormFti.uid,
                gaJsUtils.setNewFeatureCollection(obj),
                ''
              ).then(function() {
                require('toastr').success('Mise à jour effectuée.', '', {
                  positionClass: 'toast-bottom-left',
                });
              });
            }
          }
        };

        // supprimer controle du dossier
        scope.removeControleFromDossier = function(controle) {
          var ans = confirm(
            'Êtes-vous certain de vouloir supprimer ce contrôle ? La suppression du contrôle entraîne la suppression de la filière associée et cette opération est irréversible.'
          );
          if (ans) {
            scope.currentReport.properties.prochain_controle = null;
            scope.currentReport.properties.date_prochain_controle = null;
            scope.currentReport.properties.date_prochain_controle_preconise = null;
            scope.currentReport.properties.date_dernier_controle = null;

            if (scope.currentControles.length === 1) {
              delete scope.currentReport.properties.type_dernier_controle;
              delete scope.currentReport.properties.avis_dernier_controle;
              delete scope.currentReport.properties.prochain_controle;
              scope.currentReport.properties.date_dernier_controle = null;
              scope.currentReport.properties.date_prochain_controle = null;

              if (
                scope.currentControles.length === 1 &&
                angular.isDefined(
                  scope.currentReport.properties
                    .type_prochain_controle_preconise
                )
              )
                delete scope.currentReport.properties
                  .type_prochain_controle_preconise;
            } else {
              for (var i = 0; i < scope.currentControles.length; i++) {
                if (scope.currentControles[i].id === controle.id) {
                  scope.currentControles.splice(i, 1);
                }
              }

              scope.currentReport.properties.type_dernier_controle =
                scope.currentControles[0].properties.type;
              scope.currentReport.properties.avis_dernier_controle =
                scope.currentControles[0].properties.avis;
              scope.currentReport.properties.date_dernier_controle =
                scope.currentControles[0].properties.date_passage;

              var checkHighestId = [];
              for (var i = scope.currentControles.length - 1; i >= 0; i--) {
                if (scope.currentControles[i].properties.etat === 'clos')
                  checkHighestId.push(
                    scope.currentControles[i].id.replace(
                      /kis_anc_dossier_controle./g,
                      ''
                    )
                  );
              }

              for (i = scope.currentControles.length - 1; i >= 0; i--) {
                if (
                  scope.currentControles[i].id ===
                  'kis_anc_dossier_controle.' +
                    Math.max.apply(Math, checkHighestId)
                ) {
                  scope.currentControles[
                    i
                  ].properties.est_dernier_controle_cloture = true;

                  if (
                    angular.isDefined(
                      scope.currentControles[i].properties
                        .date_prochain_controle_preconise
                    ) &&
                    scope.currentControles[i].properties
                      .date_prochain_controle_preconise != null
                  )
                    scope.currentReport.properties.date_prochain_controle_preconise =
                      scope.currentControles[
                        i
                      ].properties.date_prochain_controle_preconise;

                  if (
                    angular.isDefined(
                      scope.currentControles[i].properties
                        .type_prochain_controle_preconise
                    ) &&
                    scope.currentControles[i].properties
                      .type_prochain_controle_preconise != null
                  )
                    scope.currentReport.properties.type_prochain_controle_preconise =
                      scope.currentControles[
                        i
                      ].properties.type_prochain_controle_preconise;
                }
                AncAppFactory.updatecontrole(
                  {
                    type: 'FeatureCollection',
                    features: [scope.currentControles[i]],
                  },
                  function() {
                    gaDomUtils.hideGlobalLoader();
                  }
                );
              }
            }
            gaDomUtils.showGlobalLoader();
            var promise = AncAppFactory.removecontrole(
              controle.properties.ref_dossier,
              controle.id,
              controle.properties.type
            );
            promise.then(
              function(res) {
                scope.saveReport();
                setDossierArborescence();
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        // changer etat du controle
        scope.changeEtat = function(controle) {
          var ans = confirm(
            'Êtes-vous certain de vouloir ré-ouvrir ce contrôle ?'
          );
          if (ans) {
            controle.properties.etat = 'ouvert';
            gaDomUtils.showGlobalLoader();
            var promise = AncAppFactory.updatecontrole({
              type: 'FeatureCollection',
              features: [controle],
            });
            promise.then(
              function(res) {
                setDossierArborescence();
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        // recuperer la premiere controle qui a un etat clos
        scope.getEtatControle = function(controle, index) {
          if (controle.properties.etat === 'ouvert') {
            return false;
          } else if (controle.properties.etat === 'clos') {
            if (index === 0) {
              return true;
            }
          }
          return false;
        };

        // Samedi et Dimanche retourner le Vendredi
        // minutes 0-29 --->0 30-59 --->30
        scope.$watch('nextControle.data.date', function(tab) {
          if (!scope.nextControle) {
            return false;
          }
          if (!scope.nextControle.data || !scope.nextControle.data.date) {
            return false;
          }
          var m = moment(tab);

          if (m.format('m') >= 0 && m.format('m') < 30) {
            m.set({ minute: 0, second: 0, millisecond: 0 });
          } else if (m.format('m') >= 30) {
            m.set({ minute: 30, second: 0, millisecond: 0 });
          }

          m = m.toISOString();
          m = $filter('date')(m, 'yyyy-MM-ddTHH:mm:ss.sssZ');
          scope.nextControle.data.date = m;

          if (moment(tab).format('dddd') === 'Saturday') {
            scope.nextControle.data.date = moment(scope.nextControle.data.date)
              .subtract(1, 'days')
              .toDate();
          } else if (moment(tab).format('dddd') === 'Sunday') {
            scope.nextControle.data.date = moment(scope.nextControle.data.date)
              .subtract(2, 'days')
              .toDate();
          }
        });

        // Afficher ou Cacher une filiere
        scope.toggleFiliereOnDossier = function(filiere, index) {
          var show = false;
          var first_element = false;
          scope.reportTree.forEach(function(b) {
            if (b.label === 'Filières') {
              b.children.forEach(function(f) {
                if (f.filiereId === filiere.id) {
                  f.classes.forEach(function(cc) {
                    if (
                      cc === 'showTreeBranch' &&
                      filiere.properties.etat !== 'active'
                    ) {
                      f.classes.splice(f.classes.indexOf('showTreeBranch'));
                      f.classes.push('hiddenTreeBranch');
                      scope.reportTreeControl.collapse_branch(f);

                      show = true;
                    }
                    if (
                      cc === 'hiddenTreeBranch' &&
                      filiere.properties.etat === 'active'
                    ) {
                      f.classes.splice(f.classes.indexOf('hiddenTreeBranch'));
                      first_element = true;
                    }
                  });
                  if (
                    first_element === false &&
                    filiere.properties.etat === 'active'
                  ) {
                    f.classes.push('hiddenTreeBranch');
                  }
                  if (show === false && filiere.properties.etat !== 'active') {
                    f.classes.push('showTreeBranch');
                  }
                }
              });
            }
          });
        };

        // revoyer l'etat du button
        scope.renderDisplayHideFiliere = function(filiere, index) {
          var res = true;

          scope.reportTree.forEach(function(b) {
            if (b.label === 'Filières') {
              b.children.forEach(function(f) {
                if (f.filiereId === filiere.id) {
                  f.classes.forEach(function(cc) {
                    if (cc === 'showTreeBranch') {
                      res = false;
                    }
                    if (
                      cc === 'hiddenTreeBranch' &&
                      filiere.properties.etat === 'active'
                    ) {
                      res = false;
                    }
                  });
                }
              });
            }
          });

          if (filiere.properties.etat === 'active') {
            res = !res;
          }
          return res;
        };

        var userslist = [];
        UsersFactory.getactiveuserslight().then(function(res) {
          userslist = res.data;
        });
        /**
         * set default controle agent
         */
        var setDefaultControleAgent = function() {
          scope.newControle.agent = '';
          scope.newControle.agent_name = '';
          if (scope.currentControles && scope.currentControles.length) {
            scope.currentControles.forEach(function(controle) {
              if (
                scope.newControle &&
                (!scope.newControle.agent || scope.newControle.agent === '')
              ) {
                userslist.forEach(function(user) {
                  if (user.login === controle.properties.agent) {
                    scope.newControle.agent = controle.properties.agent;
                    scope.newControle.agent_name =
                      user.name + ' ' + user.vorname;
                  }
                });
              }
            });
          }
          if (
            scope.newControle.agent === '' &&
            $rootScope.xgos.user.login !== 'root'
          ) {
            scope.newControle.agent = $rootScope.xgos.user.login;
            scope.newControle.agent_name =
              $rootScope.xgos.user.name + ' ' + $rootScope.xgos.user.vorname;
          }
        };

        /**
         * open controle externe dialog
         */
        scope.controleExternes = [];
        scope.selectcontroleexterne = {};
        scope.listeControlesWhere = 'etat = \'ouvert\'';
        scope.openControleExterneDialog = function() {
          scope.selectcontroleexterne = {};
          gaDomUtils.showGlobalLoader();
          scope.controleExterne_Tabs.activeTab = 0;
          AncAppFactory.getcontroledetailexterne('a_traiter').then(
            function(res) {
              scope.controleExternes = res.data;
              gaDomUtils.hideGlobalLoader();
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );
          ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.controle.externe.html',
            className: 'ngdialog-theme-plain fullScreen nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * add controle externe and detail
         *
         * @param id_dossier
         * @param filiere_id
         * @param detail
         */
        var addControleAndDetail = function(id_dossier, filiere_id, detail) {
          // create controle feature collection
          var cFC = {
            type: 'FeatureCollection',
            features: [
              {
                type: 'Feature',
                properties: {
                  type: 'CTRLBC',
                  ref_dossier: id_dossier,
                  statut_facture: 'aucune',
                  etat: 'ouvert',
                  date_saisie_controle: $filter('date')(
                    new Date(),
                    'yyyy-MM-ddTHH:mm:ss.sssZ'
                  ),
                  agent: scope.selectcontroleexterne.agent,
                  subvention: scope.selectcontroleexterne.subvention,
                },
              },
            ],
          };

          AncAppFactory.addcontrole(cFC, id_dossier, filiere_id).then(
            function(r) {
              require('toastr').success('Contrôle ajoutée au dossier.', '', {
                positionClass: 'toast-bottom-left',
              });

              AncAppFactory.addcontroledetail(detail, id_dossier, r.data).then(
                function(res) {
                  require('toastr').success(
                    'Informations du contrôle enregistrées.',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                  AncAppFactory.changeControleExterneDetail(
                    detail.filename,
                    'traite',
                    id_dossier,
                    r.data
                  ).then(function(res) {
                    AncAppFactory.getcontroledetailexterne('a_traiter').then(
                      function(res) {
                        scope.controleExternes = res.data;
                      },
                      function() {}
                    );
                  });
                }
              );
            },
            function() {}
          );
        };

        /**
         * appliquer controle externe detail
         */
        var addControleExterne = function(res, id_dossier, filiere_id, detail) {
          AncAppFactory.getcontroles(id_dossier).then(function(response) {
            var canAddControle = true;
            if (response.data.features.length) {
              response.data.features.forEach(function(controle) {
                if (controle.properties.etat === 'ouvert') {
                  require('toastr').error(
                    'Un contrôle est déjà ouvert pour ce dossier.',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                  canAddControle = false;
                }
              });
            } else {
              canAddControle = true;
            }

            if (canAddControle === true) {
              if (
                !response.data.features.length &&
                !filiere_id &&
                res.data.features[0]
              ) {
                filiere_id = res.data.features[0].id;
              }
              // create controle feature collection
              addControleAndDetail(id_dossier, filiere_id, detail);
            }
          });
        };

        /**
         * appliquer controle externe detail
         */
        scope.appliquerControleExterne = function(iddossier) {
          if (controleExternePrepareDialog) {
            controleExternePrepareDialog.close();
          }
          var detail =
            scope.controleExternes[scope.selectcontroleexterne.value];
          var id_dossier = iddossier;
          if (
            scope.selectcontroleexterne.dossier &&
            scope.selectcontroleexterne.dossier.length
          ) {
            id_dossier = scope.selectcontroleexterne.dossier[0].id;
          }

          var filiere_id;
          QueryFactory.data(
            filiereFti.uid,
            'ref_dossier=\'' + id_dossier + '\''
          ).then(function(res) {
            if (res.data.features.length) {
              addControleExterne(res, id_dossier, filiere_id, detail);
            } else {
              var nomFiliere =
                'Filière ' +
                $filter('date')(scope.newFiliere.date, 'dd.MM.yyyy');
              AncAppFactory.addfiliere(id_dossier, nomFiliere).then(function(
                res1
              ) {
                require('toastr').success('Filière ajoutée au dossier.', '', {
                  positionClass: 'toast-bottom-left',
                });
                filiere_id = res1.data.id;
                addControleExterne(res, id_dossier, filiere_id, detail);
              });
            }
          });
        };

        /**
         * open controle externe prepare dialog
         */
        var controleExternePrepareDialog;

        scope.openControleExternePrepareDialog = function(index) {
          scope.userPicker = {};
          scope.selectcontroleexterne.value = index;
          controleExternePrepareDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.controleExterneAgent.html',
            className: 'ngdialog-theme-plain width500 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        var dossierForControleExternePrepareDialog;

        scope.openDossierForControleExternePrepareDialog = function(index) {
          scope.ref_dossier_prepare = false;
          if (AncAppFactory.appCfg.main.dossierCfg.numerotation.auto) {
            scope.selectcontroleexterne.ref_dossier = AncAppFactory.getNumeroAuto(
              'TMP_KIS_DOSSIER_ID'
            );
            scope.ref_dossier_prepare = true;
          }

          scope.selectcontroleexterne.value = index;
          // date_creation etat_dossier ref_dossier
          dossierForControleExternePrepareDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.dossierForControleExternePrepare.html',
            className: 'ngdialog-theme-plain width500 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         *
         */
        scope.createDossierForControeleExterne = function() {
          gaDomUtils.showGlobalLoader();
          var proprietaire =
            scope.controleExternes[scope.selectcontroleexterne.value]
              .info_generales.proprietaire;
          var adresse_num_rue_extra = proprietaire.adresse_num_rue_extra;

          var pdata = {
            type: 'FeatureCollection',
            features: [
              {
                type: 'Feature',
                properties: {
                  date_creation: $filter('date')(
                    new Date(),
                    'yyyy-MM-ddTHH:mm:ss.sssZ'
                  ),
                  etat_dossier: 'ouvert',
                  ref_dossier: scope.selectcontroleexterne.ref_dossier,
                  adresse_num_rue: proprietaire.adresse_num_rue,
                  adresse_rue: proprietaire.adresse_rue,
                  adresse_ville: proprietaire.adresse_ville,
                  adresse_cp: proprietaire.adresse_cp,
                  adresse_num_rue_extra: adresse_num_rue_extra,
                },
              },
            ],
          };
          AncAppFactory.adddossier(pdata).then(
            function(res) {
              if (res.data === 'already_exist') {
                require('toastr').error(
                  'Cette référence de dossier est déjà utilisée.',
                  '',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
              } else {
                // add dossier
                dossierForControleExternePrepareDialog.close();
                require('toastr').success('Dossier enregistré', '', {
                  positionClass: 'toast-bottom-left',
                });
                var id_dossier = res.data[0].id;
                var nomFiliere =
                  'Filière ' +
                  $filter('date')(scope.newFiliere.date, 'dd.MM.yyyy');
                AncAppFactory.addfiliere(id_dossier, nomFiliere).then(function(
                  res1
                ) {
                  require('toastr').success('Filière ajoutée au dossier.', '', {
                    positionClass: 'toast-bottom-left',
                  });
                  var filiere_id = res1.data.id;
                  var detail =
                    scope.controleExternes[scope.selectcontroleexterne.value];
                  addControleAndDetail(id_dossier, filiere_id, detail);
                });

                scope.refreshReports();
              }
              gaDomUtils.hideGlobalLoader();
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * set agent
         *
         * @type {{}}
         */
        scope.userPicker = {};
        scope.$watch(
          'userPicker.agent',
          function(nap) {
            if (
              nap &&
              angular.isDefined(nap) &&
              angular.isDefined(scope.userPicker)
            ) {
              scope.selectcontroleexterne.agent = nap.login;
              scope.selectcontroleexterne.agent_name =
                nap.name + ' ' + nap.vorname;
            }
          },
          1
        );

        /**
         * dossier table action
         *
         * @type {*[]}
         */
        scope.dossierTableActions = [
          {
            label: 'btn',
            btnclass: 'default',
            cfg: {
              iconOrLabel: 'label',
              label: 'Afficher',
              size: 'btn-xs',
            },
          },
        ];

        /**
         * open dossier
         *
         * @param expr
         * @param dossier
         */
        scope.clickOnDossier = function(expr, dossier) {
          scope.editReport(dossier, false, false);
        };

        /**
         * remove controle externe detail
         *
         * @param v
         * @param index
         */
        scope.removeControleExterneDetail = function(v, index) {
          var ans = confirm('Êtes-vous sur de supprimer ce contrôle externe ?');
          if (ans) {
            AncAppFactory.changeControleExterneDetail(
              v.filename,
              'annule'
            ).then(function(res) {
              AncAppFactory.getcontroledetailexterne('a_traiter').then(
                function(res) {
                  scope.controleExternes = res.data;
                },
                function() {}
              );
            });
          }
        };

        var activeTab = 0;

        scope.controleExterneTabs = [
          {
            title: 'À traiter',
            key: 'a_traiter',
            content:
              'js/XG/widgets/ancapp/main/views/controle_habitant/a_traiter.html',
          },
          {
            title: 'Traité',
            key: 'traite',
            content:
              'js/XG/widgets/ancapp/main/views/controle_habitant/traite.html',
          },
          {
            title: 'Annulé',
            key: 'annule',
            content:
              'js/XG/widgets/ancapp/main/views/controle_habitant/annule.html',
          },
        ];

        scope.controleExterne_Tabs = {};

        scope.controleExterne_Tabs.activeTab = activeTab;

        /**
         * set tab
         */
        scope.$watch(
          'controleExterne_Tabs.activeTab',
          function(tab) {
            if (tab || tab === 0) {
              var type = 'a_traiter';
              if (tab === 1) type = 'traite';
              if (tab === 2) type = 'annule';
              AncAppFactory.getcontroledetailexterne(type).then(
                function(res) {
                  scope.controleExternes = res.data;
                },
                function() {}
              );
            }
          },
          1
        );

        /**
         * open report dialog
         *
         * @param dossier_id
         */
        scope.open_report_dialog = function(dossier_id, id_controle) {
          gaDomUtils.showGlobalLoader();
          AncAppFactory.getdossier(dossier_id).then(function(res) {
            gaDomUtils.hideGlobalLoader();
            scope.editReport(res.data.features[0], false, id_controle);
          });
        };

        /**
         * render user true name
         *
         * @param login
         */
        scope.renderTrueUserName = function(login) {
          var res = login;
          if (userslist && userslist.length) {
            userslist.forEach(function(user) {
              if (user.login === login) {
                res = user.name + ' ' + user.vorname;
              }
            });
          }
          return res;
        };

        /**
         * open controle habitant form
         */
        scope.openControleHabitantForm = function() {
          window.open(
            $location.absUrl().split('#')[0] +
              'ext/conception_anc/controle.html?portal=' +
              $location.search().portal +
              '&app=' +
              $location.search().app
          );
        };

        /**
         * active
         *
         * @param v
         */
        scope.activerAnnuleControleHabitant = function(v) {
          var ans = confirm(
            'Êtes-vous sur de vouloir activer ce contrôle habitant ?'
          );
          if (ans) {
            AncAppFactory.activecontroledetailexterne(v.filename).then(() => {
              AncAppFactory.getcontroledetailexterne('annule').then(
                function(res) {
                  scope.controleExternes = res.data;
                },
                function() {}
              );
            });
          }
        };

        scope.dossierFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_dossier'
        );

        scope.controleFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_dossier_controle'
        );

        scope.filiereFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_dossier_filiere'
        );

        scope.filiereElementFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_dossier_filiere_element'
        );

        scope.filiereElementSFTI = FeatureTypeFactory.resources.featuretypes
          .map(function(x) {
            if (x.name.startsWith('kis_anc_ef_')) return x;
          })
          .filter(function(x) {
            if (x) return x;
          });

        scope.showSearch = true;

        if (
          scope.dossierFTI.inElasticSearch &&
          scope.controleFTI.inElasticSearch
        ) {
          scope.reportTabs.push({
            title: 'Filtres avancés',
            key: 'advanced_filters_jointure',
          });
        }

        scope.visibleSearch = function() {
          scope.showSearch = !scope.showSearch;
        };

        scope.$on('resultelastic', function(event, q, t, r) {
          scope.searchquerydb = q;
          scope.searchType = t;
          scope.searchconfig = r;
          scope.showSearch = false;
        });

        scope.changedReportTabs = function() {
          if (scope.reportTabs.activeTab === 11) scope.showSearch = true;
        };

        // ///////////Fonctions pour prise de RDV
        scope.createCtrlAndWaitForRDV = function() {
          // /Creation d'un controle vide
          // bloqueChangementAvis puisque maintenant le controle reste
          // affiché en fond une fois l'avis donné
          $rootScope.$broadcast('bloqueChangementAvis', {});
          scope.appliquerAvisControle();
        };

        var getMinutesDiff = function(fin_date, debut_date) {
          fin_date = new Date(fin_date);
          debut_date = new Date(debut_date);
          var date_interval = new Date(fin_date - debut_date);
          date_interval.setMinutes(
            date_interval.getMinutes() + date_interval.getTimezoneOffset()
          );
          var diffMins = date_interval.getHours() * 60;

          return diffMins;
        };

        var getMaxInterval = function() {
          var matinee = 0;
          var apresmidi = 0;
          if (
            angular.isDefined(scope.paramData.matinee) &&
            scope.paramData.matinee
          ) {
            if (
              angular.isDefined(scope.paramData.dateDebut1) &&
              angular.isDefined(scope.paramData.dateFin1)
            ) {
              var matinee = getMinutesDiff(
                scope.paramData.dateFin1,
                scope.paramData.dateDebut1
              );
            }
          }

          if (
            angular.isDefined(scope.paramData.apresmidi) &&
            scope.paramData.apresmidi
          ) {
            if (
              angular.isDefined(scope.paramData.dateDebut2) &&
              angular.isDefined(scope.paramData.dateFin2)
            ) {
              var apresmidi = getMinutesDiff(
                scope.paramData.dateFin2,
                scope.paramData.dateDebut2
              );
            }
          }

          return matinee > apresmidi ? matinee : apresmidi;
        };

        var setDelaiLocalStorage = function(value) {
          var disablePlanifRdv = true;
          if (angular.isDefined(value) && value !== null) {
            if (Number.isInteger(value) && value > 0) {
              var maxInt = getMaxInterval();
              if (maxInt >= value) {
                scope.paramData.delai = value;
                disablePlanifRdv = false;
                $rootScope.$broadcast('disableClicEvent', disablePlanifRdv);
              } else {
                var horaire = {};
                horaire.hMax = Math.trunc(maxInt / 60);
                horaire.minMax = maxInt % 60;
                horaire.hMaxSaisie = Math.trunc(value / 60);
                horaire.minMaxSaisie = value % 60;

                horaire.dateMax = new Date();
                horaire.dateMax.setHours(
                  horaire.hMaxSaisie,
                  horaire.minMaxSaisie
                );
                horaire.dateMin = new Date();
                horaire.dateMin.setHours(horaire.hMax, horaire.minMax);

                require('toastr').error(
                  'Aucun créneau de ' +
                    moment(horaire.dateMax).format('HH:mm') +
                    ' n\'est disponible (max. ' +
                    moment(horaire.dateMin).format('HH:mm') +
                    ').',
                  'Erreur',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
                $rootScope.$broadcast('disableClicEvent', disablePlanifRdv);
              }
            } else {
              require('toastr').error('Délai invalide', 'Erreur', {
                positionClass: 'toast-bottom-left',
              });
            }
          }
          return disablePlanifRdv;
        };

        var testHourForPlanif = function(toSet) {
          var isOk = true;

          if (
            (toSet !== 'rdvHeureDebut1' &&
              !localStorage.getItem('rdvHeureDebut1')) ||
            isNaN(localStorage.getItem('rdvHeureDebut1')) ||
            localStorage.getItem('rdvHeureDebut1') == null
          )
            isOk = false;

          if (
            (toSet !== 'rdvHeureFin1' &&
              !localStorage.getItem('rdvHeureFin1')) ||
            isNaN(localStorage.getItem('rdvHeureFin1')) ||
            localStorage.getItem('rdvHeureFin1') == null
          )
            isOk = false;

          if (
            (toSet !== 'rdvHeureDebut2' &&
              !localStorage.getItem('rdvHeureDebut2')) ||
            isNaN(localStorage.getItem('rdvHeureDebut2')) ||
            localStorage.getItem('rdvHeureDebut2') == null
          )
            isOk = false;

          if (
            (toSet !== 'rdvHeureFin2' &&
              !localStorage.getItem('rdvHeureFin2')) ||
            isNaN(localStorage.getItem('rdvHeureFin2')) ||
            localStorage.getItem('rdvHeureFin2') == null
          )
            isOk = false;

          return isOk;
        };

        var checkValidParamData = function(delayValue) {
          var paramClass = {};
          if (!testHourForPlanif()) paramClass.hours = 'disable';

          if (setDelaiLocalStorage(delayValue)) {
            scope.delai.delaiToTest = 60;
            paramClass.delai = 'disable';
          }

          return paramClass;
        };

        // If date is changed, trigger a refresh on UI.
        scope.setLocalStorage = function() {
          return;
        };


        const addHiddenDay = (dayToHide) => {
          let dayNum = 0;
          switch (dayToHide) {
            case 'MONDAY': dayNum = 1; break;
            case 'TUESDAY': dayNum = 2; break;
            case 'WEDNESDAY': dayNum = 3; break;
            case 'THURSDAY': dayNum = 4; break;
            case 'FRIDAY': dayNum = 5; break;
            case 'SATURDAY': dayNum = 6; break;
          }
          scope.hiddenDays.push(dayNum);
        };


        /**
         * [openParametrageVisites parametrage pour prise de rdv auto]
         *
         * @return {[type]} [description]
         */
        scope.openParametrageVisites = function() {
          var date;
          scope.delai = {};
          date = new Date();
          date.setMinutes(0);
          date.setSeconds(0);
          var date_fin;
          date_fin = new Date(date);

          if (!scope.paramData) scope.paramData = {};

          var promise = UsersFactory.getactiveuserslight();

          promise.then(function(res) {
            var gusers = res.data;

            scope.agentCalendar = {
              value: {},
            };

            var heureDebutMatin = new Date(date);
            if (localStorage.getItem('rdvHeureDebut1')) {
              var hours = localStorage.getItem('rdvHeureDebut1');
              date.setHours(hours, 0);
              heureDebutMatin.setHours(hours, 0);
            } else {
              localStorage.setItem('rdvHeureDebut1', 8);
              heureDebutMatin.setHours(8, 0);
            }

            var heureFinMatin = new Date(date);
            if (localStorage.getItem('rdvHeureFin1')) {
              hours = localStorage.getItem('rdvHeureFin1');

              heureFinMatin.setHours(hours, 0);
            } else {
              localStorage.setItem('rdvHeureFin1', 12);
              heureFinMatin.setHours(12, 0);
            }

            var heureDebutApresmidi = new Date(date);
            if (localStorage.getItem('rdvHeureDebut2')) {
              hours = localStorage.getItem('rdvHeureDebut2');

              heureDebutApresmidi.setHours(hours, 0);
            } else {
              localStorage.setItem('rdvHeureDebut2', 14);
              heureDebutApresmidi.setHours(14, 0);
            }

            var heureFinApresmidi = new Date(date);
            if (localStorage.getItem('rdvHeureFin2')) {
              var hours = localStorage.getItem('rdvHeureFin2');

              heureFinApresmidi.setHours(hours, 0);
            } else {
              localStorage.setItem('rdvHeureFin2', 18);
              heureFinApresmidi.setHours(18, 0);
            }
            
            const delaix = 60;
            scope.delai.delaiToTest = delaix;
            
            var agent;
            if (localStorage.getItem('rdvAgent')) {
              for (var i = 0; i < gusers.length; i++) {
                if (gusers[i].login === localStorage.getItem('rdvAgent')) {
                  agent = gusers[i];
                }
              }
            } else {
              agent =
                $rootScope.xgos.user.login !== 'root'
                  ? $rootScope.xgos.user
                  : '';
            }
            function getDefaultTimetable() {
              return {
                matinee: true,
                apresmidi: true,
                dateDebut1: angular.copy(heureDebutMatin),
                dateFin1: angular.copy(heureFinMatin),
                dateDebut2: angular.copy(heureDebutApresmidi),
                dateFin2: angular.copy(heureFinApresmidi),
              };
            }
            scope.paramData = {
              delai: parseInt(delaix),
              agent: agent,
              date: date,
              date0: date,
              dateDebut1: heureDebutMatin,
              dateFin1: heureFinMatin,
              dateDebut2: heureDebutApresmidi,
              dateFin2: heureFinApresmidi,
              fin_rdv: date_fin,
              matinee: true,
              apresmidi: true,
              set_date_fin: false,
              jours: {
                MONDAY: {},
                TUESDAY: {},
                WEDNESDAY: {},
                THURSDAY: {},
                FRIDAY: {},
                SATURDAY: {},
                SUNDAY: {},
              },
            };
            const days = [
              'MONDAY',
              'TUESDAY',
              'WEDNESDAY',
              'THURSDAY',
              'FRIDAY',
              'SATURDAY',
              'SUNDAY',
            ];

            CalendarFactory.getcalendarworkhours().then((res) => {
              if (scope.hiddenDays) {
                scope.hiddenDays.splice(0, scope.hiddenDays.length);
              }
              else {
                scope.hiddenDays = [];
              }
              scope.businessHours = res.data.features.map(
                (workingHourFeature) => {
                  const businessDay =
                    scope.paramData.jours[
                      days[workingHourFeature.properties.weekday]
                    ];
                  businessDay.active = workingHourFeature.properties.active;
                  if (!businessDay.active) {
                    addHiddenDay(workingHourFeature.properties.weekday);
                  }
                  else {
                    const feature = workingHourFeature.properties;
                    businessDay.dateDebut1 =
                      getMinDate(feature.am_start, feature.am_end) ||
                      moment('08:00', 'HH:mm');
                    businessDay.dateFin1 =
                      getMaxDate(feature.am_start, feature.am_end) ||
                      moment('12:00', 'HH:mm');
                    businessDay.dateDebut2 =
                      getMinDate(feature.pm_start, feature.pm_end) ||
                      moment('13:00', 'HH:mm');
                    businessDay.dateFin2 =
                      getMaxDate(feature.pm_start, feature.pm_end) ||
                      moment('18:00', 'HH:mm');
                    businessDay.matinee = businessDay.apresmidi = true;
                  }
                }
              );
            });
          });
        };
        function getMinDate(date1, date2) {
          return !date1 || moment(date1).diff(moment(date2)) > 0
            ? date2
            : date1;
        }
        function getMaxDate(date1, date2) {
          return !date1 || moment(date1).diff(moment(date2)) < 0
            ? date2
            : date1;
        }

        /**
         * [saveParametresVisites recuperation des infos necessaires a la prise
         * de rdv auto]
         *
         * @return {[type]} [description]
         */
        scope.saveParametresVisites = function() {
          var date0 = angular.copy(scope.paramData.date);
          date0.setSeconds(0);
          var jours = angular.copy(scope.paramData.jours);
          for (let jour in jours) {
            let dateDebut1 = angular.copy(date0);

            dateDebut1.setHours(
              new Date(scope.paramData.jours[jour].dateDebut1).getHours()
            );
            dateDebut1.setMinutes(
              new Date(scope.paramData.jours[jour].dateDebut1).getMinutes()
            );
            dateDebut1.setSeconds(0);
            jours[jour].dateDebut1 = dateDebut1.getTime();

            let dateFin1 = angular.copy(date0);
            dateFin1.setHours(
              new Date(scope.paramData.jours[jour].dateFin1).getHours()
            );
            dateFin1.setMinutes(
              new Date(scope.paramData.jours[jour].dateFin1).getMinutes()
            );
            dateFin1.setSeconds(0);
            jours[jour].dateFin1 = dateFin1.getTime();

            let dateDebut2 = angular.copy(date0);

            dateDebut2.setHours(
              new Date(scope.paramData.jours[jour].dateDebut2).getHours()
            );
            dateDebut2.setMinutes(
              new Date(scope.paramData.jours[jour].dateDebut2).getMinutes()
            );

            dateDebut2.setSeconds(0);
            jours[jour].dateDebut2 = dateDebut2.getTime();

            let dateFin2 = angular.copy(date0);
            dateFin2.setHours(
              new Date(scope.paramData.jours[jour].dateFin2).getHours()
            );
            dateFin2.setMinutes(
              new Date(scope.paramData.jours[jour].dateFin2).getMinutes()
            );
            dateFin2.setSeconds(0);
            jours[jour].dateFin2 = dateFin2.getTime();
          }

          scope.parametresVisites = {
            delai: scope.paramData.delai,
            agent: scope.paramData.agent.login,
            date0: date0.getTime(),
            dossiers: [],
            // fin de rdv = date + delai (durée) du rdv
            fin_rdv: angular.isDefined(scope.paramData.fin_rdv)
              ? date0.getTime() + (scope.paramData.delai * 60 * 1000)
              : null,
            set_date_fin: scope.paramData.set_date_fin,
            interval: jours,
          };
          localStorage.setItem('rdvAgent', scope.parametresVisites.agent);
        };

        scope.cancelParametresVisites = function() {
          scope.ngDialogParametresVisites.close();
        };
        
        scope.testmap = () => {
          ngDialog.open({
            template: 'js/XG/widgets/ancapp/main/views/calendrierRdvsAuto.html',
            id: 'agnda',
            className: 'ngdialog-theme-plain width1000 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        // enregistre la config des horaires de travail
        scope.workHoursOrdered = {}
        scope.workHoursOrderedArrayToSend = []
        /**
         * update WorkHours
         */
        scope.saveWorkHours = function() {
          var ans = confirm($filter('translate')('calendar.config.confim'));

          if (ans) {
            
            var FeatureCollection = {
              type: 'FeatureCollection',
              features: angular.copy(scope.workHoursOrderedArrayToSend).map(day => {
                day.properties.am_start = day.properties.am_start && moment(day.properties.am_start).utc().format('YYYY-MM-DDTHH:mm:ss.SSSZZ');
                day.properties.am_end = day.properties.am_end && moment(day.properties.am_end).utc().format('YYYY-MM-DDTHH:mm:ss.SSSZZ');
                day.properties.pm_start = day.properties.pm_start && moment(day.properties.pm_start).utc().format('YYYY-MM-DDTHH:mm:ss.SSSZZ');
                day.properties.pm_end = day.properties.pm_end && moment(day.properties.pm_end).utc().format('YYYY-MM-DDTHH:mm:ss.SSSZZ');
                return day;
              }),
            };
            gaDomUtils.showGlobalLoader();
            CalendarFactory.updatecalendarworkhours(FeatureCollection).finally(
              gaDomUtils.hideGlobalLoader()
            );
          }
        };
        scope.getNewWorkHours = function() {
          scope.saveParametresVisites()
          for (let i=0; i<Object.keys(scope.parametresVisites.interval).length; i++) {
            scope.parametresVisites.interval[Object.keys(scope.parametresVisites.interval)[i]].dateDebut1 = new Date(scope.parametresVisites.interval[Object.keys(scope.parametresVisites.interval)[i]].dateDebut1);
            scope.parametresVisites.interval[Object.keys(scope.parametresVisites.interval)[i]].dateDebut2 = new Date(scope.parametresVisites.interval[Object.keys(scope.parametresVisites.interval)[i]].dateDebut2)
            scope.parametresVisites.interval[Object.keys(scope.parametresVisites.interval)[i]].dateFin1 =   new Date(scope.parametresVisites.interval[Object.keys(scope.parametresVisites.interval)[i]].dateFin1)
            scope.parametresVisites.interval[Object.keys(scope.parametresVisites.interval)[i]].dateFin2 =   new Date(scope.parametresVisites.interval[Object.keys(scope.parametresVisites.interval)[i]].dateFin2)

          }
          scope.workHoursOrdered['MONDAY'] = scope.parametresVisites.interval['MONDAY']
          scope.workHoursOrdered['TUESDAY'] = scope.parametresVisites.interval['TUESDAY']
          scope.workHoursOrdered['WEDNESDAY'] = scope.parametresVisites.interval['WEDNESDAY']
          scope.workHoursOrdered['THURSDAY'] = scope.parametresVisites.interval['THURSDAY']
          scope.workHoursOrdered['FRIDAY'] = scope.parametresVisites.interval['FRIDAY']
          scope.workHoursOrdered['SATURDAY'] = scope.parametresVisites.interval['SATURDAY']
          scope.workHoursOrdered['SUNDAY'] = scope.parametresVisites.interval['SUNDAY']

          // rename keys
          for (let j=0; j<Object.keys(scope.workHoursOrdered).length; j++) {
            scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['am_start'] = scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['dateDebut1'];
            delete scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['dateDebut1'];
            scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['am_end'] = scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['dateFin1']
            delete scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['dateFin1']; 
            scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['pm_start'] = scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['dateDebut2']
            delete scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['dateDebut2']; 
            scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['pm_end'] = scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['dateFin2'] 
            delete scope.workHoursOrdered[Object.keys(scope.workHoursOrdered)[j]]['dateFin2'];
          }


          var propertiesMonday = {weekday:0, am_start:scope.workHoursOrdered['MONDAY']['am_start'],
                                  am_end:scope.workHoursOrdered['MONDAY']['am_end'],
                                  pm_start:scope.workHoursOrdered['MONDAY']['pm_start'],
                                  pm_end:scope.workHoursOrdered['MONDAY']['pm_end'],
                                  active: scope.workHoursOrdered['MONDAY']['active']}
          var ObjecMonday = {type: 'Feature',id:'kis_calendar_work_hours.2', properties:propertiesMonday}

          var propertiesTuesday = {weekday:1, am_start:scope.workHoursOrdered['TUESDAY']['am_start'],
                                  am_end:scope.workHoursOrdered['TUESDAY']['am_end'],
                                  pm_start:scope.workHoursOrdered['TUESDAY']['pm_start'],
                                  pm_end:scope.workHoursOrdered['TUESDAY']['pm_end'],
                                  active: scope.workHoursOrdered['TUESDAY']['active']}
          var ObjecTuesday = {type: 'Feature',id:'kis_calendar_work_hours.3', properties:propertiesTuesday}

          var propertiesWednesday = {weekday:2, am_start:scope.workHoursOrdered['WEDNESDAY']['am_start'],
                                  am_end:scope.workHoursOrdered['WEDNESDAY']['am_end'],
                                  pm_start:scope.workHoursOrdered['WEDNESDAY']['pm_start'],
                                  pm_end:scope.workHoursOrdered['WEDNESDAY']['pm_end'],
                                  active: scope.workHoursOrdered['WEDNESDAY']['active']}
          var ObjecWednesday = {type: 'Feature',id:'kis_calendar_work_hours.4', properties:propertiesWednesday}

          var propertiesThursday = {weekday:3, am_start:scope.workHoursOrdered['THURSDAY']['am_start'],
                                  am_end:scope.workHoursOrdered['THURSDAY']['am_end'],
                                  pm_start:scope.workHoursOrdered['THURSDAY']['pm_start'],
                                  pm_end:scope.workHoursOrdered['THURSDAY']['pm_end'],
                                  active: scope.workHoursOrdered['THURSDAY']['active']}
          var ObjecThursday = {type: 'Feature',id:'kis_calendar_work_hours.5', properties:propertiesThursday}

          var propertiesFriday = {weekday:4, am_start:scope.workHoursOrdered['FRIDAY']['am_start'],
                                  am_end:scope.workHoursOrdered['FRIDAY']['am_end'],
                                  pm_start:scope.workHoursOrdered['FRIDAY']['pm_start'],
                                  pm_end:scope.workHoursOrdered['FRIDAY']['pm_end'],
                                  active: scope.workHoursOrdered['FRIDAY']['active']}
          var ObjecFriday = {type: 'Feature',id:'kis_calendar_work_hours.6', properties:propertiesFriday}


          var propertiesSaturday = {weekday:5, am_start:scope.workHoursOrdered['SATURDAY']['am_start'],
                                  am_end:scope.workHoursOrdered['SATURDAY']['am_end'],
                                  pm_start:scope.workHoursOrdered['SATURDAY']['pm_start'],
                                  pm_end:scope.workHoursOrdered['SATURDAY']['pm_end'],
                                  active: scope.workHoursOrdered['SATURDAY']['active']}
          var ObjecSaturday = {type: 'Feature',id:'kis_calendar_work_hours.7', properties:propertiesSaturday}

          var propertiesSunday = {weekday:6, am_start:scope.workHoursOrdered['SUNDAY']['am_start'],
                                  am_end:scope.workHoursOrdered['SUNDAY']['am_end'],
                                  pm_start:scope.workHoursOrdered['SUNDAY']['pm_start'],
                                  pm_end:scope.workHoursOrdered['SUNDAY']['pm_end'],
                                  active: scope.workHoursOrdered['SUNDAY']['active']}
          var ObjecSunday = {type: 'Feature',id:'kis_calendar_work_hours.8', properties:propertiesSunday}
          // on vide le tableau au cas
          scope.workHoursOrderedArrayToSend=[];
          scope.workHoursOrderedArrayToSend.push(ObjecMonday)
          scope.workHoursOrderedArrayToSend.push(ObjecTuesday)
          scope.workHoursOrderedArrayToSend.push(ObjecWednesday)
          scope.workHoursOrderedArrayToSend.push(ObjecThursday)
          scope.workHoursOrderedArrayToSend.push(ObjecFriday)
          scope.workHoursOrderedArrayToSend.push(ObjecSaturday)
          scope.workHoursOrderedArrayToSend.push(ObjecSunday)

          scope.saveWorkHours();
        }


        /**
         * [farraichir l'agenda au changement d'agent]
         *
         * @param {Object}
         *            agent)
         * @return {[type]} [description]
         */
        scope.$watch('paramData.agent', function(agent) {
          if (agent)
            $rootScope.$broadcast('kis_calendar_eventAgent_refresh', {
              agent: agent.login,
            });
        });

        const setWorkHoursByDay = (result, i) => {
          return { active: result.data.features[i].properties.active, 
            am_start: result.data.features[i].properties.am_start,
            am_end: result.data.features[i].properties.am_end,
            pm_start: result.data.features[i].properties.pm_start,
            pm_end: result.data.features[i].properties.pm_end
          }
        }


         // Cette fonction verifie si les horaires de l'evenement à enregistrer tombe dans une horaire interdite
        const checkIfCreneauAvailable = (infoEvent,ObjectWorkHours,daysOfWeekDatabase) => {
          const anyDateForComparaisonHourFunction = '01/01/2022 ';
            // heure : minutes des limites des créneaux interdits
            let dayLastRdv = daysOfWeekDatabase[((new Date(infoEvent.date0)).getDay()-1)]

            let heureMinutesDebutCreneauMatin = (new Date(ObjectWorkHours[dayLastRdv].am_start).getHours()) + ':' +
            (new Date(ObjectWorkHours[dayLastRdv].am_start).getMinutes());

            let heureMinutesFinCreneauMatin = (new Date(ObjectWorkHours[dayLastRdv].am_end).getHours()) + ':' +
            (new Date(ObjectWorkHours[dayLastRdv].am_end).getMinutes());

            let heureMinutesDebutCreneauAprem = (new Date(ObjectWorkHours[dayLastRdv].pm_start).getHours()) + ':' +
            (new Date(ObjectWorkHours[dayLastRdv].pm_start).getMinutes());

            let heureMinutesFinCreneauAprem = (new Date(ObjectWorkHours[dayLastRdv].pm_end).getHours()) + ':' +
            (new Date(ObjectWorkHours[dayLastRdv].pm_end).getMinutes());

            let heureMinutesLastAddedRdvDebut = (new Date(infoEvent.date0)).getHours() + ':' + (new Date(infoEvent.date0)).getMinutes();

  
            // Il s'agit d'une comparaison d'heure, la date importe peu, mais il faut quand même la mettre en paramètre
            // si une partie du dernier rdv tombe dans la zone "interdite", on le supprime
            if ( (((new Date(anyDateForComparaisonHourFunction + heureMinutesLastAddedRdvDebut)).getTime() >= (new Date(anyDateForComparaisonHourFunction+ heureMinutesDebutCreneauMatin)).getTime()
                && (new Date(anyDateForComparaisonHourFunction + heureMinutesLastAddedRdvDebut)).getTime() < (new Date(anyDateForComparaisonHourFunction+ heureMinutesFinCreneauMatin)).getTime())
                && 
                (((new Date(anyDateForComparaisonHourFunction + heureMinutesLastAddedRdvDebut)).getTime() + (scope.paramData.delai * 60 * 1000)) > (new Date(anyDateForComparaisonHourFunction+ heureMinutesDebutCreneauMatin)).getTime()
                && ((new Date(anyDateForComparaisonHourFunction + heureMinutesLastAddedRdvDebut)).getTime() + (scope.paramData.delai * 60 * 1000)) <= (new Date(anyDateForComparaisonHourFunction+ heureMinutesFinCreneauMatin)).getTime()) )
                || 
                (((new Date(anyDateForComparaisonHourFunction + heureMinutesLastAddedRdvDebut)).getTime() >= (new Date(anyDateForComparaisonHourFunction+ heureMinutesDebutCreneauAprem)).getTime()
                && (new Date(anyDateForComparaisonHourFunction + heureMinutesLastAddedRdvDebut)).getTime() < (new Date(anyDateForComparaisonHourFunction+ heureMinutesFinCreneauAprem)).getTime())
                && 
                (((new Date(anyDateForComparaisonHourFunction + heureMinutesLastAddedRdvDebut)).getTime() + (scope.paramData.delai * 60 * 1000))  > (new Date(anyDateForComparaisonHourFunction+ heureMinutesDebutCreneauAprem)).getTime()
                && ((new Date(anyDateForComparaisonHourFunction + heureMinutesLastAddedRdvDebut)).getTime() + (scope.paramData.delai * 60 * 1000)) <= (new Date(anyDateForComparaisonHourFunction+ heureMinutesFinCreneauAprem)).getTime()) )
                ) {
                   return true
                } else {
                  return false;
                }
        }
        

    

        /**
         * Lancement du webservice de prise de rdv
         */
        const doPriseRdv = (fixedSlot, dataToSend3, def) => {
          if (def == undefined) {
            def = $q.defer();
          }
          // aucun agent specifie
          if (!angular.isDefined(scope.paramData.agent)) {
            require('toastr').error(
              'Veuillez sélectionner l\'agent concerné',
              'Erreur',
              {
                positionClass: 'toast-bottom-left',
              }
            );
            return;
          }
          
          gaDomUtils.showGlobalLoader();
          scope.saveParametresVisites();
          $timeout(function () {
          scope.parametresVisites.dossiers = getDossierListIds();
          const dataToSend = angular.copy(scope.parametresVisites);
          dataToSend.fixedSlot = fixedSlot;
          var dataToSend2 = dataToSend
          dataToSend2.fin_rdv = dataToSend.date0 + (scope.paramData.delai * 60 * 1000)
          // l'odre des jours dans la base de données 
          let daysOfWeekDatabase = ['MONDAY','TUESDAY','WEDNESDAY','THURSDAY','FRIDAY','SATURDAY','SUNDAY'];
          // on mettra ici les horaires de travail définies dans la base
          let ObjectWorkHours = {};
          // S'il s'agit d'une planification
          if (dataToSend3) {
                CalendarFactory.getcalendarworkhours().then((result) => {
                  // récuperation des horaires de travail et on les enregistre dans un objet utilisable
                  for (let i=0; i<result.data.features.length; i++) {
                    if (result.data.features[i].properties.weekday === 0) {
                      ObjectWorkHours['MONDAY'] = setWorkHoursByDay(result, i);
                    }
                    if (result.data.features[i].properties.weekday === 1) {
                      ObjectWorkHours['TUESDAY'] = setWorkHoursByDay(result, i);
                    }
                    if (result.data.features[i].properties.weekday === 2) {
                      ObjectWorkHours['WEDNESDAY'] = setWorkHoursByDay(result, i);
                    }
                    if (result.data.features[i].properties.weekday === 3) {
                      ObjectWorkHours['THURSDAY'] = setWorkHoursByDay(result, i);
                    }
                    if (result.data.features[i].properties.weekday === 4) {
                      ObjectWorkHours['FRIDAY'] = setWorkHoursByDay(result, i);
                    }
                    if (result.data.features[i].properties.weekday === 5) {
                      ObjectWorkHours['SATURDAY'] = setWorkHoursByDay(result, i);
                    }
                    if (result.data.features[i].properties.weekday === 6) {
                      ObjectWorkHours['SUNDAY'] = setWorkHoursByDay(result, i);
                    }
                  }
                  
                },((eerr) =>{
                  def.reject();
                })).then(()=>{
                  // Si le créneau est disponible
                  if (checkIfCreneauAvailable(dataToSend3,ObjectWorkHours,daysOfWeekDatabase) === true) {
                    const fin_rdv = dataToSend3.date0 + (scope.paramData.delai * 60 * 1000)
                    // On vérifie s'il n y a pas d autres rdv au même endroit
                    CalendarFactory.checkSameTimeEvent(dataToSend3.agent,dataToSend3.date0,fin_rdv).then((res)=>{
                      // S'il y a un autre rdv au même endroit
                      if (res.data[0] ===  "true") {
                        // Récupération des données du rdv à l'endroit, et placer le nouveau juste après
                        const delai = Number(res.data[2]) - Number(res.data[1])
                        dataToSend3.date0 = Number(res.data[1]) + delai;
                        dataToSend3.fin_rdv = Number(res.data[2]) + delai;
                        doPriseRdv(fixedSlot, dataToSend3, def);
                      } else {
                        // Créneau autorisé et pas autre rdv à la même place
                        CalendarFactory.priseRdvsAuto(dataToSend3).then(
                          (res) => {
                            // si non, on fait comme avant
                            handlePriseRdvSuccess();
                            def.resolve();
                          },
                          (err) => {
                            gaDomUtils.hideGlobalLoader();
                            require('toastr').error(
                              'Erreur lors de la planification des RDV',
                              '',
                              { positionClass: 'toast-bottom-left' }
                            );
                            def.reject();
                          }
                        );
                      }
                    },err=>{
                      def.reject();
                    })
                  } else {
                    // heure : minutes des limites des créneaux interdits
                    const dayLastRdv = daysOfWeekDatabase[((new Date(dataToSend3.date0)).getDay()-1)]
                    // Si le créneau n est pas dispo (celui du matin), on va tester sur le début du créneau autorisé suivant (aprèm)
                    dataToSend3.date0 = (new Date(dataToSend3.date0)).setHours((new Date(ObjectWorkHours[dayLastRdv].pm_start).getHours()))
                    dataToSend3.date0 = (new Date(dataToSend3.date0)).setMinutes((new Date(ObjectWorkHours[dayLastRdv].pm_start).getMinutes()))
                    dataToSend3.fin_rdv = dataToSend3.date0 + (scope.paramData.delai * 60 * 1000)
                    doPriseRdv(fixedSlot, dataToSend3, def);
                  }
                }, err => {
                  def.reject();
                })
            
                
          } else {
            // S'il s'agit d'une prise de rdv manuelle
            dataToSend2.priseAuto = false
            // On vérifie s'il n y a pas d autres rdv au même endroit
            CalendarFactory.checkSameTimeEvent(dataToSend2.agent,dataToSend2.date0,dataToSend2.fin_rdv).then((res)=>{
              // S'il y a un autre rdv au même endroit
              if (res.data[0] ===  "true") {
                // Le créneau est occupé
                require('toastr').error(
                  'Un rendez-vous est déjà programmé pour cet agent sur ce créneau',
                  '',
                  { positionClass: 'toast-bottom-left' }
                );
                gaDomUtils.hideGlobalLoader(); 

              } else {
                // Créneau autorisé et pas autre rdv à la même place
                CalendarFactory.priseRdvsAuto(dataToSend2).then(
                  (res) => {
                    // si non, on fait comme avant
                    handlePriseRdvSuccess();
                    def.resolve()
                  },
                  (err) => {
                    gaDomUtils.hideGlobalLoader();
                    require('toastr').error(
                      'Erreur lors de la planification des RDV',
                      '',
                      { positionClass: 'toast-bottom-left' }
                    );
                  }
                );
              }
            },((err)=>{
              def.reject()
            }))
          }
        })    
        return def.promise; 
        };
        function handlePriseRdvSuccess() {
          if(!scope.datesDossier){
            scope.datesDossier ={};
          }
          scope.datesDossier.date_controle_rdv = $filter('date')(
            scope.parametresVisites.date0,
            'yyyy-MM-ddTHH:mm:ss.sssZ'
          );
          let broadcast = $rootScope.$broadcast('kis_calendar_eventAgent_refresh', {
            agent: scope.parametresVisites.agent,
          });
          scope.$on('$destroy', function destroyScope() {
            broadcast();
          });
          gaDomUtils.hideGlobalLoader();
          gaDomUtils.showLocalLoader('.controle_concernes');

          $timeout(function() {
            scope.refreshCtrlsPriseRdv(scope.fromControle);
            scope.heureDeb = false;
          }, 2000);

          scope.refreshReports();
        }

        function _confirm(mess, okCallback) {
          return swal(
            {
              title: mess,
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            okCallback
          );
        }

        scope.getDateDebutFirstAvailableHour = () => {
          const jours = angular.copy(scope.paramData.jours);
          const weekDays = moment.weekdays();
          const debutDay = moment(angular.copy(scope.paramData.date)).format(
            'dddd'
          );
          const orderedWeekdays = weekDays
            .splice(
              weekDays.indexOf(debutDay),
              weekDays.length - weekDays.indexOf(debutDay)
            )
            .concat(weekDays)
            .map((day) => day.toUpperCase());
          const hour = orderedWeekdays.reduce((finalHour, day) => {
            if (finalHour || !jours[day]) {
              return finalHour;
            }
            const intervalDay = jours[day];
            if (!intervalDay.matinee && !intervalDay.apresmidi) {
              return new Date(finalHour);
            }
            finalHour =
              intervalDay.matinee &&
              isDelayValidForIntervals(
                intervalDay.dateDebut1,
                intervalDay.dateFin1,
                scope.paramData.delai
              )
                ? intervalDay.dateDebut1
                : isDelayValidForIntervals(
                  intervalDay.dateDebut2,
                  intervalDay.dateFin2,
                  scope.paramData.delai
                )
                  ? intervalDay.dateDebut2
                  : false;
            return finalHour;
          }, false);
          function isDelayValidForIntervals(start, end, delai) {
            if (!start || !end) {
              return false;
            }
            return (
              moment(start)
                .add(delai, 'minutes')
                .diff(moment(end)) <= 0
            );
          }
          return new Date(hour);
        };

        /*
        * doPriseRdvRecursive
        */
        const doPriseRdvRecursive = (dataToSend,dossierList,index) =>{
            if (index < dossierList.length) {
              dataToSend.dossiers = [dossierList[index].doss.id];
              doPriseRdv(true,dataToSend).then((res)=>{
                doPriseRdvRecursive(dataToSend,dossierList,++index);
              })
            }
        }

        /**
         * [priseRdvsAuto prise de rdv automatique]
         *
         * @return {[type]} [description]
         */
        scope.priseRdvsAuto = function() {
          validateDelaiPriseDeRdv();
          scope.saveParametresVisites()
          // Organisation interne des jours dans uiCalendatUI
          var daysOfWeekUiCalendar = ['SUNDAY','MONDAY','TUESDAY','WEDNESDAY','THURSDAY','FRIDAY','SATURDAY']
          // Le jour du rendez vous à planifier automatiquement
          var newDayRdvAuto = daysOfWeekUiCalendar[new Date(uiCalendarConfig.calendars['kisCalendar'].fullCalendar('getDate')).getDay()]
          // Si le jour est active
          // scope.parametresVisites.interval[newDayRdvAuto] : on récupere les dateDebut défini dans l'agenda
          if (scope.parametresVisites.interval[newDayRdvAuto].active) {
            // si la matinée est active
            if (scope.parametresVisites.interval[newDayRdvAuto].matinee) {
                // récup de l'heure
                var time = new Date(scope.parametresVisites.interval[newDayRdvAuto].dateDebut1).getHours()
                // récup des minute : tout ceci est important pour la popup de confirmation
                var minutes = new Date(scope.parametresVisites.interval[newDayRdvAuto].dateDebut1).getMinutes()
                // le vrai "temps de début" à envoyer en backend
                var finaleTimeToSend = new Date(uiCalendarConfig.calendars['kisCalendar'].fullCalendar('getDate')).setHours(time)
                const dataToSend = angular.copy(scope.parametresVisites);
                // temps de début
                dataToSend.date0 = finaleTimeToSend
                // temps de fin =  temps de début + délai du frdv
                dataToSend.fin_rdv = finaleTimeToSend  + (scope.paramData.delai * 60 * 1000)
                dataToSend.fixedSlot = true
                // renseigner l'id du dossier
                dataToSend.dossiersList = [];
                dataToSend.dossiersList = scope.ctrlDossiers;
                // dataToSend.dossiers.push(scope.ctrlDossiers[0].doss.id)
                // on précise au backend qu'il s'agit d'une prise de rdv automatique
                dataToSend.priseAuto = true;
                _confirm(
                  'Voulez vous lancer la planification des rendez vous à partir de ' +
                  time + ':' + minutes +
                    ' ?',
                    (isConfirm) => {
                      if (isConfirm) {
                        if (Array.isArray(dataToSend.dossiersList)) {
                          doPriseRdvRecursive(dataToSend,dataToSend.dossiersList,0);
                        }
                      }
                    }
                );
                // si la matinee n'est pas active et l'aprem l'est, on passe directement à l heure de l aprem, même algo, on ajoute les suffixe 1 aux mêmes variables
            } else if (scope.parametresVisites.interval[newDayRdvAuto].apresmidi === true && scope.parametresVisites.interval[newDayRdvAuto].matinee === false) {
                var time1 = new Date(scope.parametresVisites.interval[newDayRdvAuto].dateDebut2).getHours()
                var minutes1 = new Date(scope.parametresVisites.interval[newDayRdvAuto].dateDebut2).getMinutes()
                var finaleTimeToSend1 = new Date(uiCalendarConfig.calendars['kisCalendar'].fullCalendar('getDate')).setHours(time1)
                const dataToSend1 = angular.copy(scope.parametresVisites);
                dataToSend1.date0 = finaleTimeToSend1
                dataToSend1.fin_rdv = finaleTimeToSend1 + (scope.paramData.delai * 60 * 1000)
                dataToSend1.fixedSlot = true
                dataToSend1.priseAuto = true;
                dataToSend.dossiersList = [];
                dataToSend1.dossiersList = scope.ctrlDossiers;
                _confirm(
                  'Voulez vous lancer la planification des rendez vous à partir de ' +
                  time1 + ':' + minutes1 +
                    ' ?',
                    (isConfirm) => {
                      if (isConfirm) {
                        if (Array.isArray(dataToSend.dossiersList)) {
                          doPriseRdvRecursive(dataToSend,dataToSend.dossiersList,0);
                        }
                      }
                    }
                  );
                }
              }
            };

        /**
         * [cancelRdvsAuto annuler la prise de rdv automatique]
         *
         * @return {[type]} [description]
         */
        scope.cancelRdvsAuto = function() {
          _confirm(
            'Êtes vous sûr de vouloir supprimer les évenements existants ?',
            function(isConfirm) {
              if (isConfirm) {
                scope.saveParametresVisites();
                var tabDossiers = [];
                for (var i = 0; i < scope.ctrlDossiers.length; i++) {
                  tabDossiers.push(scope.ctrlDossiers[i].doss.id);
                }
                scope.parametresVisites.dossiers = tabDossiers;
                CalendarFactory.cancelRdvsAuto(scope.parametresVisites).then(
                  function(res1) {
                    var data = {
                      agent: scope.parametresVisites.agent,
                    };
                    $rootScope.$broadcast(
                      'kis_calendar_eventAgent_refresh',
                      data
                    );
                    $timeout(function() {
                      scope.refreshCtrlsPriseRdv(scope.fromControle);
                    }, 2000);
                    scope.refreshReports();
                  }
                );
              }
            }
          );
        };

        /* prise de rdv depuis clic */
        var register = $rootScope.$on('getHeureDebut', function(event, data) {
          scope.heureDeb = true;
          var dateT = data.heureDebut.split(':');
          var hr = parseInt(dateT[0]);
          var min = parseInt(dateT[1]);
          scope.paramData.date0 = new Date(scope.paramData.dateFin1);
          scope.paramData.date0 = new Date(scope.paramData.date0.setHours(hr));
          scope.paramData.date0.setMinutes(min);
          scope.paramData.date0.setSeconds(0);
          scope.paramData.date = data.debut.toDate();
          scope.rdvFromClic = true;
          doPriseRdv(data.fixedSlot);
        });
        // Destruction du .$on, autrement l'appel au webservice de prise de rdv se fait plusieurs fois
        scope.$on('$destroy', function destroyScope() {
          register();
        });


        function FindByAttributeValue(attribute, value, element_type) {
          element_type = element_type || '*';
          var All = document.getElementsByTagName(element_type);
          for (var i = 0; i < All.length; i++) {
            if (All[i].getAttribute(attribute) === value) {
              return All[i];
            }
          }
        }

        // changement de date principale dans la prise de RDV
        scope.$watch('paramData.date', function(curr, prev) {
          if (angular.isDate(curr) && angular.isDate(curr) && curr !== prev) {
            var mc = uiCalendarConfig.calendars['kisCalendar'];
            if (angular.isDefined(mc)) {
              uiCalendarConfig.calendars['kisCalendar'].fullCalendar(
                'changeView',
                'agendaDay'
              );
              uiCalendarConfig.calendars['kisCalendar'].fullCalendar(
                'gotoDate',
                curr
              );
            }
          }
        });

        /**
         * [localiseEvent localise and highlight event]
         *
         * @param {[type]}
         *            date [description]
         * @param {[type]}
         *            idControle [description]
         * @return {[type]} [description]
         */
        scope.localiseEvent = function(date, idControle) {
          uiCalendarConfig.calendars['kisCalendar'].fullCalendar(
            'changeView',
            'agendaDay'
          );
          uiCalendarConfig.calendars['kisCalendar'].fullCalendar(
            'gotoDate',
            date
          );

          CalendarFactory.getEventByControl(idControle).then(
            function(res1) {
              $timeout(function() {
                var el = $(
                  FindByAttributeValue('idEvent', res1.data.features[0].id, 'a')
                );
                // scroll jusqu'au controle
                angular.element('.fc-time-grid-container.fc-scroller').animate(
                  {
                    scrollTop: el.position().top - 25,
                  },
                  1000,
                  function() {
                    el.addClass('highlightEvent');
                    $timeout(function() {
                      el.removeClass('highlightEvent');
                    }, 7000);
                  }
                );
              });
            },
            function() {
              require('toastr').error(
                'Erreur lors de la récupération du calendrier, est-il activé pour le portail ?',
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
            }
          );
        };

        /**
         * [verifyIfEventExists verifier si event existe par verification de
         * date de passage du controle]
         *
         * @return {[type]} [description]
         */
        scope.verifyIfEventExists = function() {
          var exists = false;
          for (var i = 0; i < scope.ctrlDossiers.length; i++) {
            if (
              scope.ctrlDossiers[i].ctrl[0].properties.date_passage_rdv != null
            ) {
              exists = true;
              break;
            }
          }
          return exists;
        };

        /**
         * [refreshCtrlsPriseRdv rafraichir la liste des contrôles]
         *
         * @return {[type]} [description]
         */
        scope.refreshCtrlsPriseRdv = function() {
          scope.newCtrls = [];

          var ids = scope.parametresVisites
            ? scope.parametresVisites.dossiers.toString()
            : getDossierListIds().toString();
          AncAppFactory.getActifsControles(ids).then(
            function(res) {
              if (!res.data.features.length) {
                require('toastr').error(
                  'Aucun contrôle n\'est ouvert parmi les dossiers sélectionnés.',
                  '',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
                return;
              }

              var ctrls = res.data.features;
              for (var j = 0; j < ctrls.length; j++) {
                var newctrl = ctrls[j];
                if (scope.currentControles) {
                  scope.currentControles = scope.currentControles.map(controle =>
                    (controle.id !==  newctrl.id) ? controle : newctrl
                  );
                }
                
                for (var k = 0; k < scope.ctrlDossiers.length; k++) {
                  if (
                    scope.ctrlDossiers[k].doss.id ===
                    newctrl.properties.ref_dossier
                  ) {
                    scope.ctrlDossiers[k].ctrl = [newctrl];
                    break;
                  }
                }
              }

              // Trigger refresh to get new date rdv
              if (angular.isDefined(scope.fromControle) && scope.fromControle) {
                scope.reportTree_handle(scope.currentBranch);
              }

              gaDomUtils.removeLocalLoader('.controle_concernes');
            },
            function() {
              gaDomUtils.removeLocalLoader('.controle_concernes');
            }
          );
        };

        scope.$watch(
          'ctrlDossiers',
          function(model) {
            scope.modelAsJson = angular.toJson(model, false);
          },
          false
        );

        $rootScope.$on('gcDataTableGetDataFti', (ev, data) => {
          if (data.params.count()) {
            localStorage.setItem('gcDataTableCount', data.params.count());
          }
        });

        // rdv choisi par defaut
        scope.action = {
          selectedAction: 'rdv',
        };

        var getDossierByRefCtrl = function(ref) {
          var doss;
          for (var j = 0; j < scope.res.length; j++) {
            if (scope.res[j].id === ref) {
              doss = scope.res[j];
              break;
            }
          }
          return doss;
        };

        function addNewControle(avisControleDialog) {
          if (angular.isDefined(avisControleDialog)) {
            avisControleDialog.close();
          }
          var dateSaisie = $filter('date')(
            new Date(),
            'yyyy-MM-ddTHH:mm:ss.sssZ'
          );
          scope.newControle = {
            agent: scope.currentControle.properties.agent,
            date_saisie_controle: dateSaisie,
            est_dernier_controle_cloture: false,
            etat: 'ouvert',
            ref_dossier: scope.currentReport.id,
            reference_filiere: '',
            type: scope.nextControle.data.type,
            date_max: scope.nextControle.data.delai
              ? scope.nextControle.data.dateMax
              : null,
          };
          scope.addControleToDossier(null, true, true);
        }

        ConfigFactory.get('ANC', 'calendar').then(function(res) {
          if (res.data != '') scope.calendarConfig = res.data;
        });

        function avertir(mess) {
          swal({
            title: mess,
            type: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#DD6B55',
          });
        }

        scope.rendezVousIsPossible = function(ctrl) {
          var iEt, et, typeEvent;
          // -- Si pas de configuration:
          // -- pas de contrôle interdit en prise de rendez-vous.
          if (scope.calendarConfig == undefined) return true;

          // -- Recherche du type d'événment correspondant au contrôle
          // -- dans la configuration de l'agenda.
          var res = kisCalendarFactory.getEventFromTypeDeControle(
            ctrl,
            calendarEventTypes
          );
          typeEvent = res.typeEvent;
          for (iEt = 0; iEt < scope.calendarConfig.eventTypes.length; iEt++) {
            et = scope.calendarConfig.eventTypes[iEt];
            if (typeEvent == et.type_id) {
              // -- Le type d'événement correspondant au côontrle est trouvé,
              // -- on sait si le rendez-vous est autorisé ou non pour ce
              // contrôle.
              return et.rdvIsPossible;
            }
          }
          // -- Type de contrôle sans correspondance !!!!!!
          return true;
        };

        function getNumDossier(idDossier) {
          var iDossier;
          for (iDossier = 0; iDossier < scope.res.length; iDossier++) {
            if (scope.res[iDossier].id == idDossier) {
              return scope.res[iDossier].properties.ref_dossier;
            }
          }
          return '?';
        }

        function validateDelaiPriseDeRdv() {
          if (!scope.paramData.delai) {
            require('toastr').success(
              'La valeur du champ délai a été modifiée pour être supérieure ou égale à 60',
              '',
              { positionClass: 'toast-top-right' }
            );
            scope.paramData.delai = 60;
          }
          return true;
        }

        function prepareAndOpenRdvAuto(res, fromControle) {
          var fullMess = '',
            mess;
          var ctrls = res.data.features;
          for (var j = 0; j < ctrls.length; j++) {
            var obj = {
              ctrl: [ctrls[j]],
            };
            // -- Vérifier si le type de contrôle appartient à la liste
            // -- des types d'événements pour lesquels
            // -- un rendez-vous peut être pris.
            if (scope.rendezVousIsPossible(ctrls[j]))
              scope.ctrlDossiers.push(obj);
            else {
              // -- Message des contrôles non autorisés en rendez-vous
              if (fullMess == '')
                fullMess = 'Rendez-vous non autorisé pour le(s) dossier(s):';
              fullMess +=
                '\n- ' + getNumDossier(ctrls[j].properties.ref_dossier);
            }
          }
          if (fullMess != '') avertir(fullMess);
          var doss;
          for (var k = 0; k < scope.ctrlDossiers.length; k++) {
            if (!fromControle) {
              var ref = scope.ctrlDossiers[k].ctrl[0].properties.ref_dossier;
              doss = getDossierByRefCtrl(ref);
            } else {
              doss = angular.copy(scope.currentReport);
            }

            scope.ctrlDossiers[k].doss = doss;
          }
          gaDomUtils.hideGlobalLoader();
          $rootScope.calendar.agentvisible = true;
          if (scope.paramData.agent !== undefined) {
            scope.agentctrl = scope.paramData.agent.login;
          } else {
            scope.paramData.agent = $rootScope.xgos.user.login;
            scope.agentctrl = $rootScope.xgos.user.login;
          }

          if (scope.ctrlDossiers.length != 0) {
            scope.rdvAuto = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/calendrierRdvsAuto2.html',
              id: 'agnda',
              className: 'ngdialog-theme-plain width1200 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
              preCloseCallback: function() {
                $rootScope.$broadcast('kis_calendar_event_changed');
              },
            });
          }
        }

        $rootScope.$on('openEventFromKis', (event, data) => {
          if (!data.controleId) {
            return;
          }
          scope.currentEvent = data.feature;
          scope.actionPriseRdv();
        });

        $rootScope.$on('kis_calendar_destroy', () => {
          scope.currentEvent = undefined;
        });

        /**
         * [actionPriseRdv action prise de rdv automatique]
         *
         * @return {[type]} [description]
         */
        scope.actionPriseRdv = function(fromControle) {
          scope.fromControle = fromControle;
          scope.openParametrageVisites();
          gaDomUtils.showGlobalLoader();
          scope.ctrlDossiers = [];

          if (fromControle) {
            var ids = [scope.currentReport.id];
          } else {
            // depuis liste des dossiers
            var tab = scope.res;
            var ids = [];
            for (var i = 0; i < tab.length; i++) {
              ids.push(tab[i].id);
            }
          }

          var promise = AncAppFactory.getActifsControles(ids).then(function(
            res
          ) {
            // creation depuis workflow lorsqu'on vient de cloturer un controle
            if (
              res.data.features != undefined &&
              !res.data.features.length &&
              fromControle &&
              scope.nextControle &&
              scope.nextControle.data
            ) {
              var ans = confirm(
                'Voulez-vous créer le prochain contrôle de type ' +
                  scope.nextControle.data.type +
                  '?'
              );
              if (ans) {
                addNewControle(avisControleDialog);
              }
              gaDomUtils.hideGlobalLoader();
              return;

              // erreur aucun controle, depuis la liste des dossiers
            } else if (!res.data.features.length && !fromControle) {
              require('toastr').error(
                'Aucun contrôle n\'est ouvert parmi les dossiers sélectionnés.',
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
              gaDomUtils.hideGlobalLoader();
              return;
            } else {
              prepareAndOpenRdvAuto(res, fromControle);
            }
          });
        };

        scope.openMapFilter = function() {
          var tabDossiers = [];
          for (var i = 0; i < scope.res.length; i++) {
            tabDossiers.push(scope.res[i].id);
          }

          scope.ftidoss = scope.dossierFTI;
          var dialogPositionDossiers = ngDialog.open({
            template: 'js/XG/widgets/ancapp/main/views/map_filter.html',
            className: 'ngdialog-theme-plain height700 nopadding',
            closeByDocument: false,
            showClose: true,
            scope: scope,
          });
        };

        scope.result = {};

        /**
         * [executeAction switch actions sur les dossiers selectionnes]
         *
         * @return {[type]} [description]
         */
        if (angular.isDefined(scope.activeRdv) && !scope.activeRdv) {
          scope.action = { selectedAction: 'map' };
        }

        /**
         * Changement en masse du statut des dossiers
         */
        let dossierStatutDialog;
        let preUpdateStatutDialog;
        let filesToUpdateData = [];

        scope.changeStatutDossiersEnMasse = function(dossier) {
          scope.multiDossiersUpdate = false;
          filesToUpdateData = [];
          if (!angular.isDefined(dossier)) {
            filesToUpdateData = scope.res;
            dossier = scope.res[0];
            scope.multiDossiersUpdate = filesToUpdateData.length > 1;
          } else {
            filesToUpdateData.push(dossier);
          }

          scope.reportData = angular.copy(dossier);
          scope.apptype = 'anc';
          scope.newDossierStatut = {
            date_raccordement: $filter('date')(
              new Date(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            ),
          };
          dossierStatutDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.statut.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            preCloseCallback: (closeFromUpdateStatus)=>{
              if(closeFromUpdateStatus){
                scope.res.length = 0;
              }
            }
          });
        };

        /**
         * update le statut du dossier apres confirmation
         */

        scope.pre_updateDossierStatut = function() {
          scope.newReference = false;
          scope.reference = {};
          scope.dossiersToUpdate = [];

          for (var i = 0; i < filesToUpdateData.length; i++) {
            var dossierToPush = angular.copy(filesToUpdateData[i]);
            dossierToPush.nomDossierBac = dossierToPush.properties.ref_dossier;
            scope.dossiersToUpdate.push(dossierToPush);
          }
          ApplicationFactory.get().then(function() {
            scope.bacApp = ApplicationFactory.resources.applications.filter(
              function(x) {
                return x.type === 'BacApp';
              }
            )[0];

            preUpdateStatutDialog = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.report.statut.confirm.html',
              className:
                'ngdialog-theme-plain width600 nopadding miniclose error_dialog',
              closeByDocument: false,
              scope: scope,
            });
          });
        };

        /**
         * updateDossiersStatut TODO refactoriser!!
         */
        scope.updateDossiersStatut = function() {
          let dossiersIds = scope.dossiersToUpdate
            .map(function(dossier) {
              return dossier.id;
            })
            .join(',');

          if (scope.newDossierStatut.etat_dossier === 'raccorde') {
            if (scope.bacApp) {
              checkDossierBacNexistePas().then(function() {
                AncAppFactory.updatestatutdossiers(
                  dossiersIds,
                  scope.newDossierStatut.etat_dossier,
                  $filter('date')(
                    scope.newDossierStatut.date_raccordement,
                    'yyyy-MM-ddTHH:mm:ss.sssZ'
                  )

                ).then(function() {
                  require('toastr').success(
                    'Etat des dossiers changé pour "' +
                      $filter('translate')(
                        'ancapp.report.status.' +
                          scope.newDossierStatut.etat_dossier
                      ) +
                      '"',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                  preUpdateStatutDialog.close();
                  dossierStatutDialog.close(true);
                  scope.refreshReports(0);
                });
              });
            } else {
              AncAppFactory.updatestatutdossiers(
                dossiersIds,
                scope.newDossierStatut.etat_dossier,
                $filter('date')(
                  scope.newDossierStatut.date_raccordement,
                  'yyyy-MM-ddTHH:mm:ss.sssZ'
                )
              ).then(function() {
                require('toastr').success(
                  'Etat des dossiers changé pour "' +
                    $filter('translate')(
                      'ancapp.report.status.' +
                        scope.newDossierStatut.etat_dossier
                    ) +
                    '"',
                  '',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
                preUpdateStatutDialog.close();
                dossierStatutDialog.close(true);
                scope.refreshReports(0);
              });
            }
          } else {
            let dossiersWithoutControls = [];
            let dossiersEncours = [];
            if (scope.newDossierStatut.etat_dossier === 'en_cours') {
              scope.dossiersToUpdate.forEach((element) => {
                if (angular.equals(element.properties.dernierControle, {})
                  && (!element.properties.prochain_controle
                    || element.properties.prochain_controle === '')) {
                  dossiersWithoutControls.push(element.id);
                } else {
                  dossiersEncours.push(element.id);
                }
              });
              dossiersIds = dossiersEncours.join(',');
            }
            AncAppFactory.updatestatutdossiers(
              dossiersIds,
              scope.newDossierStatut.etat_dossier,
              undefined
            ).then(function() {
              if (dossiersWithoutControls.length > 0) {
                AncAppFactory.updatestatutdossiers(
                  dossiersWithoutControls.join(','),
                  'ouvert',
                  undefined
                ).then(function() {
                  updateFinished(
                    (dossiersEncours.length
                      ? $filter('translate')(
                        'ancapp.report.status.' +
                            scope.newDossierStatut.etat_dossier
                      ) + '" et "'
                      : '') +
                      $filter('translate')('ancapp.report.status.ouvert')
                  );
                });
              } else {
                updateFinished(
                  $filter('translate')(
                    'ancapp.report.status.' +
                      scope.newDossierStatut.etat_dossier
                  )
                );
              }
            });

            function updateFinished(newStatus) {
              require('toastr').success(
                'Etat des dossiers changé pour "' + newStatus + '"',
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
              preUpdateStatutDialog.close();
              dossierStatutDialog.close(true);
              scope.refreshReports(0);
            }
          }
        };

        scope.dialogsClose = function() {
          preUpdateStatutDialog.close();
          dossierStatutDialog.close();
          scope.refreshReports(1);
        };

        /**
         * checkDossierBacNexistePas
         */
        var checkDossierBacNexistePas = function() {
          var def = $q.defer();
          var checkReferences = [];
          scope.dossiersToUpdate.forEach(function(dossier) {
            
            dossier.properties.ref_dossier = dossier.nomDossierBac;
            dossier.properties.date_raccordement =
              scope.newDossierStatut.date_raccordement;
            dossier.properties.date_etat_raccordement =
              scope.newDossierStatut.date_raccordement;
            dossier.properties.etat_raccordement = 'Raccordé';
            checkReferences.push(dossier);
          });

          BacAppFactory.checkdossiersamereference(
            gaJsUtils.setNewFeatureCollection(checkReferences),
            scope.bacApp.name
          ).then(
            function(res) {
              scope.refDossierBacExisteDeja = {};
              if (res.data) {
                scope.refDossierBacExisteDeja[res.data] = true;
              }

              if (Object.keys(scope.refDossierBacExisteDeja).length > 0) {
                require('toastr').error(
                  'Un dossier portant ce nom (' +
                    res.data +
                    ') existe déjà dans l\'application BAC',
                  '',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
                def.reject();
              } else {
                // creation du dossier bac et resolve defer
                // TODO faire ca proprement dans un webservice
                // qui insere egalement les relations parcelles,
                // personne, etc...
                var dossierBacFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
                  AncAppFactory.appCfg.main.datastore,
                  'kis_bac_dossier'
                );
                // on conserve les attributs qui existent aussi
                // dans bac_app_dossier
                var bacAttrs = dossierBacFti.attributes.map(function(x) {
                  return x.name;
                });
                
                var addBacDossierPromises = [];

                checkReferences.forEach(function(x) {
                  for (var i in x.properties) {
                    if (i !== 'ref_dossier') {
                      if (dossierBacFti == null || bacAttrs.indexOf(i) === -1)
                        delete x.properties[i];
                    }
                  }

                  x.properties.dossier_anc = x.id;
                  delete x.id;
                  delete x.nomDossierBac;

                  x.properties.etat_dossier = 'ouvert';
                  x.properties.date_creation = $filter('date')(
                    new Date(),
                    'yyyy-MM-ddTHH:mm:ss.sssZ'
                  );
                  
                  const promises = [
                    BacAppFactory.adddossier(
                      gaJsUtils.setNewFeatureCollection(x),
                      scope.bacApp.name),
                    AncAppFactory.getdossier(x.properties.dossier_anc)
                  ]
                  // une fois que le dossier est enregistr en BAC, on y rajoute le proprio et le locataire
                  $q.all(promises).then((result) => {
                      const resultgetDossierAnc = result[1].data.features[0].properties;
                      let ref_dossier_bac;
                      if (Array.isArray(result) && result.length > 0 && Array.isArray(result[0].data) && result[0].data.length > 0){
                        ref_dossier_bac = result[0].data[0].rid;
                      }
                      if (ref_dossier_bac && resultgetDossierAnc) {
                        BacAppFactory.appCfg = { main: {}, appName: scope.bacApp.name };
                        if (resultgetDossierAnc.locataires.length !== 0){
                          BacAppFactory.addpersonnetodossier('locataires',ref_dossier_bac, resultgetDossierAnc.locataires[0].id,null, null,scope.bacApp.name)
                        }
                        if (resultgetDossierAnc.proprietaires.length !== 0){
                          BacAppFactory.addpersonnetodossier('proprietaires',ref_dossier_bac, resultgetDossierAnc.proprietaires[0].id,null, null, scope.bacApp.name)
                        }
                      }       
                  })
                 
                });

                $q.all(addBacDossierPromises).then(
                  function(res) {
                    def.resolve();
                  },
                  function(res) {
                    def.reject();
                  }
                );
              }
            },
            function() {
              def.reject();
            }
          );

          return def.promise;
        };

        scope.executeAction = function() {
          if (scope.action.selectedAction === 'rdv' && scope.priseRDV.active) {
            scope.actionPriseRdv();
          }
          if (scope.action.selectedAction === 'map') {
            scope.openMapFilter();
          }
          if (scope.action.selectedAction === 'change_status') {
            scope.changeStatutDossiersEnMasse();
          }
        };

        scope.refreshTable = function() {
          scope.listeDossiersWhere = '1=1';
          scope.refreshReports();
        };

        /**
         * [deleteCtrlDoss supprimer un controle de la liste des controles a
         * planifier]
         *
         * @param {[type]}
         *            index [description]
         * @return {[type]} [description]
         */
        scope.deleteCtrlDoss = function(index) {
          scope.ctrlDossiers.splice(index, 1);
        };

        /*
         * --------------------- Requêtes paramétrées ------------------------
         */

        if (
          AncAppFactory.appCfg.main.properties.requests &&
          AncAppFactory.appCfg.main.properties.requests.active
        ) {
          scope.requetes_actives = AncAppFactory.appCfg.main.properties.requests.list.filter(
            function(x) {
              return x.active === true;
            }
          );
        }

        if (
          AncAppFactory.appCfg.main.properties.requests &&
          AncAppFactory.appCfg.main.properties.requests.customDefaults &&
          AncAppFactory.appCfg.main.properties.requests.customDefaults.active
        ) {
          scope.showCustomDefaultRequests = true;
        }

        /**
         * setResultatElastic
         */
        scope.setResultatElastic = function(result, fti) {
          scope.resultatElastic = result;
          scope.resfti = fti;
        };

        $rootScope.$on('testTestResultTable', function(event, data) {
          scope.reqSqlFti = data.resultData.result.featureTypeInfo;
          scope.exect = data.resultData;
        });

        scope.allRequestsVisible = false;
        scope.toggleAllRequests = function() {
          scope.allRequestsVisible = !scope.allRequestsVisible;
          $rootScope.$broadcast('toggleAllAncRequests', {
            v: scope.allRequestsVisible,
          });
        };

        /* -- affichage des infos relatives à la facturation ? -- */
        scope.displayFacturationControle =
          gaJsUtils.checkNestedProperty(
            'appCfg.main.properties.dolibarr.active',
            AncAppFactory
          ) === true;

        scope.getUrlFactureDolibarr = function(id) {
          return {
            url:
              AncAppFactory.appCfg.main.properties.dolibarr.url +
              'compta/facture/card.php?facid=' +
              id,
            pdf:
              AncAppFactory.appCfg.main.properties.dolibarr.url +
              'compta/facture/card.php?facid=' +
              id,
          };
        };

        scope.dolibarOrOmega = function() {
          var config = AncAppFactory.appCfg.main.properties.dolibarr;
          if (
            config.active == true &&
            config.facturationTierce.active == true &&
            config.facturationTierce.interface.type === 'omega'
          ) {
            scope.dolibarOrOmega = 'OMEGA';
          } else {
            scope.dolibarOrOmega = 'DOLIBAR';
          }
        };

        scope.dolibarOrOmega();

        scope.getAndCheckStatusFacture = function(idFacture) {
          var factureCheckStatusOmega = {
            idFacture: idFacture,
            datastore: AncAppFactory.appCfg.main.datastore,
          };
          OmegaFactory.getAndCheckStatusFactureOmega(
            factureCheckStatusOmega
          ).then(function(res) {
            if (res.data) {
              scope.statusFacture = res.data.status;
            }
          });
        };

        scope.hasRdv = function() {
          var hasPassage = scope.ctrlDossiers.filter(function(item) {
            return (
              angular.isDefined(item.ctrl[0].properties.date_passage_rdv) &&
              item.ctrl[0].properties.date_passage_rdv != null
            );
          });
          if (hasPassage.length) return true;
        };

        $rootScope.$on('refresh_bkp_vidange', function(event, data) {
          scope.bkpVdata = data;
        });

        scope.$on('updateCleanData', function(event, data, string) {
          if (angular.isDefined(scope.checkDiffCdata))
            gaJsUtils.setNestedProperty(string, scope, angular.copy(data));
        });

        /** gestion omega */
        var recherchePointConsommationModal, applyPointConsoDataModal;
        scope.openRecherchepointconsommationDialog = function() {
          scope.omegaFilters = {
            nom_prenom: true,
            adresse_complete: true,
            commune: false,
            numero_compteur: true,
            ref_point_conso: true,
            mode_Widget: true,
            show_table: true,
          };
          scope.openRecherchePCDialog();
        }
        scope.openRecherchepointconsommationRafraichirDialog = function() {
          scope.omegaFilters = {
            nom_prenom: false,
            adresse_complete: false,
            commune: false,
            numero_compteur: false,
            ref_point_conso: true,
            mode_Widget: false,
            show_table: true,
            multiple_selection : false,
          };
          scope.omegaQueryParams = {};
          scope.omegaQueryParams.numeroPointConsommation = scope.currentReport.properties.numero_point_conso_omega;
          scope.openRecherchePCDialog();
        }
        scope.openRecherchePCDialog = function () {
          scope.omegaVariable = 'OmegaAnc';
          scope.resultatSelectionOmega = {};
          scope.resultOmega = '';
          recherchePointConsommationModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.recherchepointconsommation.html',
            className: 'ngdialog-theme-plain width1200 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };
        /**
         * addOmegaPersonneToDossier
         *
         * @param {*}
         *            omegaPersonne
         * @param {*}
         *            type
         * @param {*}
         *            personneAttributes
         */
        var addOmegaPersonneToDossier = function(
          feat,
          type
        ) {
          let def = $q.defer();
          var typeMapping =
            type === 'occupant' ? 'locataires' : 'proprietaires';
            if (typeof feat == 'object') {
              const featKeys = Object.keys(feat);
              if (feat.featPersonneActuel && Array.isArray(feat.featPersonneActuel.features)) {
                const feature = feat.featPersonneActuel.features[0];
                if (feature.properties) {
                  // Verifie si la personne est déjà dans la base
                  AncAppFactory.checkIfPersonneAlreadyInTheDatabase(feature.properties.id_tiers_omega).then((res)=>{
                    // La personne est déja dans la base alors on update ces infos
                    let updateOrCreate = "";
                    if (res.data === true) {
                      updateOrCreate =  "update";
                    } else if (res.data === false) {
                      updateOrCreate =  "create";
                    }
                    // recupere l id de la personne courante dans le dossier
                    AncAppFactory.getIdCurrentPersonneCourant(scope.currentReport.id, type).then((resultIdCourant)=>{
                      // ajoute la personne dans la base
                      AncAppFactory.addpersonne(feature,type,scope.currentReport.id,updateOrCreate).then(
                        function(res) {
                          // si la date de début est presente , on la met
                          if (feature.properties.id_tiers_omega) {
                            // id de la personne 
                            AncAppFactory.getPersonneId(feature.properties.id_tiers_omega).then((result)=>{
                              if (result.data) {
                                // ajoute la nouvelle personne au dossier
                                AncAppFactory.addpersonnetodossier(typeMapping,scope.currentReport.id,result.data,
                                  feature.properties.debut ? feature.properties.debut : Date.now(),'omega', 'omega',
                                  feature.properties.fin ? feature.properties.fin : null).then(()=>{

                                    if (resultIdCourant.data != "") {
                                      const typePersonne =
                                      type === 'proprietaire' ? 'ce propriétaire' : 'cet occupant';
                                      let ans = confirm(
                                        'Êtes-vous sûr de vouloir archiver ' +
                                          typePersonne +
                                          ' du dossier ?'
                                      );
                                      if (ans) {
                                        const typeToSend =
                                        type === 'proprietaire' ? 'proprietaires' : 'locataires';
                                        // retire l'ancienne personne
                                        gaDomUtils.showGlobalLoader();
                                        AncAppFactory.removepersonneencoursfromdossier(typeToSend,scope.currentReport.id,resultIdCourant.data,null,feature.properties.debut ? feature.properties.debut : Date.now()).then(()=>{
                                          gaDomUtils.hideGlobalLoader()
                                          scope.saveReport();
                                          def.resolve();
                                        },((err)=>{
                                          require('toastr').error(
                                            'Une erreur s\'est produite'
                                          );
                                          gaDomUtils.hideGlobalLoader()
                                          def.reject();
                                        }))
                                      } else {
                                        scope.saveReport();
                                        def.resolve();
                                      } 
                                    } else {
                                      scope.saveReport();
                                      def.resolve();
                                    }
                                     
                                })
                              }
                            })
                          }
                          
                        },
                        function(err) {
                          require('toastr').error(
                            'Une erreur s\'est produite lors de l\'ajout d\'une personne Omega (' +
                              type +
                              ').',
                            'Erreur'
                          );
                          def.reject();
                        }
                      );

                    },((err)=>{
                      require('toastr').error(
                        'Une erreur s\'est produite'
                      );
                      def.reject();
                    }))
                  },((err)=>{
                    require('toastr').error(
                      'Une erreur s\'est produite'
                    );
                    def.reject();
                  }))
                }
              }
          }
          return def.promise;
        };

        /**
         * applyPointConsoData
         */
        scope.applyPointConsoData = function () { 
          var ans = confirm(
            'Êtes-vous certain de vouloir appliquer ces informations au dossier ?'
          );
          if (ans) {
            var personneFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
              AncAppFactory.appCfg.main.datastore,
              'kis_anc_personne'
            );
            var personneAttributes = personneFti.attributes.map(function (x) {
              return x.name;
            });

            recherchePointConsommationModal.close();
            applyPointConsoDataModal.close();
            
            if (scope.currentReport.properties) {
              scope.currentReport.properties.numero_point_conso_omega = scope.omegaToApply.pc___id
              scope.currentReport.properties.id_point_conso_omega = scope.omegaToApply.pc___idPconso
            } 

            // id point consommation
            /*
            scope.currentReport.properties.ode =
              scope.omegaToApply.pc___id;
              */
            // adresse dossier
            if (scope.paramsOmegaDataToApply.adresse) {
              // Annulation du code postal si celui-ci a une taille de plus de 6
              // Dans les locataires Histo
              if (Array.isArray(scope.omegaToApply.locatairesHistos)) {
                if (scope.omegaToApply.locatairesHistos.length > 0) {
                  scope.omegaToApply.locatairesHistos.forEach((locataire) => {
                    if (locataire.locataireHisto___adresse_cp.length > 5) {
                      locataire.locataireHisto___adresse_ville = locataire.locataireHisto___adresse_cp + "  "+locataire.locataireHisto___adresse_ville
                      locataire.locataireHisto___adresse_cp = "";
                    }
                  })
                }
              }
              // Dans les proprio Histo
              if (Array.isArray(scope.omegaToApply.proprietairesHistos)) {
                if (scope.omegaToApply.proprietairesHistos.length > 0) {
                  scope.omegaToApply.proprietairesHistos.forEach((proprio) => {
                    if (proprio.proprietaireHisto___adresse_cp.length > 5) {
                      proprio.proprietaireHisto___adresse_ville =proprio.proprietaireHisto___adresse_cp + " "+proprio.proprietaireHisto___adresse_ville ;
                      proprio.proprietaireHisto___adresse_cp = "";
                    }
                  })
                }
              }
              // Pour l'occupant actuel
              if (scope.omegaToApply.occupant___adresse_cp) {
                if (scope.omegaToApply.occupant___adresse_cp.length > 5) {
                  scope.omegaToApply.occupant___adresse_ville = scope.omegaToApply.occupant___adresse_cp+" "+scope.omegaToApply.occupant___adresse_ville;
                  scope.omegaToApply.occupant___adresse_cp = "";
                }
              }
              // Pour le proprio actuel
              if (scope.omegaToApply.proprietaire___adresse_cp) {
                if (scope.omegaToApply.proprietaire___adresse_cp.length > 5) {
                  scope.omegaToApply.proprietaire___adresse_ville = scope.omegaToApply.proprietaire___adresse_cp+"  "+scope.omegaToApply.proprietaire___adresse_ville;
                  scope.omegaToApply.proprietaire___adresse_cp = "";
                }
              }
              // Pour le cp
              if (scope.omegaToApply.pc___adresse_cp) {
                if (scope.omegaToApply.pc___adresse_cp.length > 5) {
                  scope.omegaToApply.pc___adresse_ville =  scope.omegaToApply.pc___adresse_cp +" "+scope.omegaToApply.pc___adresse_ville;
                  scope.omegaToApply.pc___adresse_cp = "";
                }
              }

              for (var i in scope.currentReport.properties) {
                if (i.indexOf('adresse_') === 0) {
                  delete scope.currentReport.properties[i];
                  if (angular.isDefined(scope.omegaToApply['pc___' + i])) {
                    scope.currentReport.properties[i] =
                      scope.omegaToApply['pc___' + i];
                  }
                }
              }
              scope.currentReportTitle = $sce.trustAsHtml(
                ancBacTools.setDossierFullname(
                  scope.currentReport,
                  'anc',
                  initCopyReportButton,
                  $location
                )
              );
            }
            // position
            if (scope.paramsOmegaDataToApply.position) {
              var oCoords = scope.omegaSelectedObject.geometry.coordinates;
              var nCoords = ol.proj.transform(
                [oCoords[1], oCoords[0]],
                'EPSG:4326',
                'EPSG:3857'
              );
              var feature = new ol.format.GeoJSON().writeFeatureObject(
                new ol.Feature({
                  geometry: new ol.geom.Point(nCoords),
                })
              );

              $timeout(function () {
                scope.currentReport.geometry = feature.geometry;
              });

              $rootScope.$broadcast('positionSetFromDossier', {
                geometry: feature.geometry,
              });
            }
            /**************************************************************************************
             * Enregistrement du propriétaire courant et de l'historique des propriétaires
             *************************************************************************************/
            /**
             * Liste des attributs des données des personnes + d'Historique des personnes
             */
            const personneHistoryAttributes = personneAttributes.concat([
              'courant',
              'est_redevable',
              'fin',
              'debut',
            ]);
          
            /**
             * Données de l'historique des propriétaires
             */
            const featHistoProprietaires = extractDonneesHistoriquePersonnes(
              personneHistoryAttributes,
              'proprietairesHistos'
            );
            /**
             * Données de propriétaire en cours
             */
            const featProprietaireActuel = extractDonneesHistoriquePersonnes(
              personneHistoryAttributes,
              'proprietaire'            
            );
            /**
             * Données propriétaires paramétre de Service
             */
            const featDataProprietaire = {
              featHistoPersonnes: featHistoProprietaires
                ? featHistoProprietaires
                : {},
               featPersonneActuel: featProprietaireActuel
                ? featProprietaireActuel
                : {},
            };
            /**************************************************************************************
             * Enregistrement de l'occupant en cours et de l'historique des locataires
             *************************************************************************************/
            /**
             * Données de l'historique des locataires
             */
            const featHistoLocataires = extractDonneesHistoriquePersonnes(
              personneHistoryAttributes,
              'locatairesHistos'
            );
            /**
             * Données de l'occupant en cours
             */
            const featLocataireActuel = extractDonneesHistoriquePersonnes(
              personneHistoryAttributes,
              'occupant'
            );
            /**
             * Données locataires passés comme paramétre de Service
             */
            // si le locataire est present dans les données récupérées
            const featDataLocataire = {                      
              featHistoPersonnes: featHistoLocataires
                ? featHistoLocataires
                : {},
              featPersonneActuel: featLocataireActuel
                ? featLocataireActuel
                : {},
            };

            const featDataPersonneHisto = {
              featHistoPersonnes: featHistoLocataires
                ? featHistoLocataires
                : {},
              featPersonneActuel: featLocataireActuel
                ? featLocataireActuel
                : {},
            };
            
            // ajout du proprietaire omega au dossier
            if (scope.paramsOmegaDataToApply.proprietaire) {
               addOmegaPersonneToDossier(featDataProprietaire, 'proprietaire').then(()=>{
                if (scope.paramsOmegaDataToApply.occupant) {
                  addOmegaPersonneToDossier(featDataLocataire, 'occupant');
                }
               })
             }

          }
          scope.saveReport();
        };
        /**************************************************************************************
         * Parse des données des personnes Omega
         *************************************************************************************/
        /**
         * Parse des données d'Historique des personnes
         *
         * @param {Object} personneHistoryAttributes les attributs de la personne et histo
         * @param {String} type type de la personne concernée : Propriétaire / Occupant
         *
         * @returns properties des données d'Historique des personnes
         */
        const extractDonneesHistoriquePersonnes = (
          personneHistoryAttributes,
          type
        ) => {
          const feats = [];
          let i = 0;
          /**
           * Les données d'Historique des proprietaires/Locataires
           * ou
           * Les données des personnes des proprietaires/Locataires
           */
            if (
              scope.omegaToApply &&
              (type === 'occupant' || type === 'proprietaire')
            ) {
              const personne = parseDataAttributesPersonneOmega(
                type,
                personneHistoryAttributes,
                scope.omegaToApply
              );
              feats[i] = personne;
              i = i + 1;
            } else if (
              scope.omegaToApply[type] &&
              (type === 'locatairesHistos' || type === 'proprietairesHistos')
            ) {
              for (let personneHisto of scope.omegaToApply[type]) {
                const personne = parseDataAttributesPersonneOmega(
                  type,
                  personneHistoryAttributes,
                  personneHisto
                );
                if (
                  personne &&
                  personne.properties &&
                  personne.properties.id_tiers_omega
                ) {
                  if (personne.properties) {
                    // le proprietaire que l'on rapatrie d omega est toujours redevable
                    personne.properties.est_redevable = true;
                  }
                  feats[i] = personne;
                  i = i + 1;
                }
              }
            }
          /**
           * Le return
           */
          if (feats.length != 0) {
            return {
              type: 'FeatureCollection',
              totalFeatures: i,
              features: feats,
            };
          }
        };

        /**
         * Parse des données des personnes et des Historique des personnes
         *
         * @param {String} type type de la personne : Prop / Occupant / Historique des personnes
         * @param {Object} personneHistoryAttributes les attributs de la personne + histo
         * @param {Object} personneOmegaDataHisto  des données de l'historique des proprietaires
         *
         * @returns properties des données des personnes
         */
        const parseDataAttributesPersonneOmega = (
          type,
          personneHistoryAttributes,
          personneOmegaDataHisto
        ) => {
          let feat = { properties: {} };
          /**
           * Données Personne ou Histo à parser ?
           */
          let omegaDatas = '';
          let keyPrefixeData = '';
          if (type === 'proprietairesHistos') {
            omegaDatas = personneOmegaDataHisto;
            keyPrefixeData = 'proprietaireHisto';
          } else if (type === 'locatairesHistos') {
            omegaDatas = personneOmegaDataHisto;
            keyPrefixeData = 'locataireHisto';
          } else {
            omegaDatas = scope.omegaToApply;
            keyPrefixeData = type;
          }

          /**
           * Récupération de tous les données de Personne , sauf l'adresse
           */
          for (let i in omegaDatas) {
            if (
              personneHistoryAttributes.indexOf(i.replace(keyPrefixeData + '___', '')) !==
              -1
            ) {
              if (
                i != keyPrefixeData + '___' + 'adresse_num_rue' &&
                i != keyPrefixeData + '___' + 'adresse_num_rue_extra'
              ) {
                feat.properties[i.replace(keyPrefixeData + '___', '')] = omegaDatas[i];
              }
            }
          }
          /**
           * Récupération de l'adresse compléte
           */
          const attkeyAdresseComplete = keyPrefixeData + '___adresseComplete';
          if (feat.properties.adresse_complement) {
            feat.properties.adresse_complement =
              feat.properties.adresse_complement +
              '\n' +
              omegaDatas[attkeyAdresseComplete + '2'];
          }
          if (
            omegaDatas &&
            attkeyAdresseComplete &&
            omegaDatas[attkeyAdresseComplete]
          ) {
            feat.properties.adresse_rue = omegaDatas[attkeyAdresseComplete];
          }
          return feat.properties.id_tiers_omega ? feat : {};
        }; 
        /**
         * selection d'un point de conso omega
         */
        scope.pointConsoSelectionne = function(selection) {
          scope.omegaSelectedObject = selection;
          scope.omegaToApply = selection.properties;

          scope.paramsOmegaDataToApply = {
            adresse: true,
            position:
              angular.isDefined(selection.geometry) &&
              selection.geometry !== null,
            proprietaire: angular.isDefined(
              selection.properties.proprietaire___id_tiers_omega
            ),
            occupant: angular.isDefined(
              selection.properties.occupant___id_tiers_omega
            ),
          };
          if (!scope.paramsOmegaDataToApply.proprietaire) {
            require('toastr').error(
              'Alimentation de dossier impossible: '
              +'le propriétaire n\'est pas renseigné. Veuillez le renseigner dans Omega avant toute création de dossier'
              ,'Erreur'
            );
          } else {
            scope.omegaRedevable =
              scope.omegaToApply.proprietaire_id_tiers_omega ===
              scope.omegaToApply.occupant_id_tiers_omega
                ? 'proprietaire'
                : 'occupant';

            applyPointConsoDataModal = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.apply_point_consommation.html',
              className: 'ngdialog-theme-plain width600 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
            });
          }
        };

        scope.openAttachmentsDialog = function(obj) {
          scope.currentReport = obj;
          scope.dossierAttachmentData = {
            id: obj.id,
            featuretype: 'kis_anc_dossier',
            attachmentsNo: angular.isDefined(
              ancBacTools.getCurrentDossierAttachmentsInfos(
                scope.doss,
                scope.currentReport
              )
            )
              ? ancBacTools.getCurrentDossierAttachmentsInfos(
                scope.doss,
                scope.currentReport
              ).dossierAttachmentsNo
              : 0,
          };

          initializeArrays();
          prepareFilieres();

          ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.report.dossier.attachments.html',
            className:
              'ngdialog-theme-plain width1200 height700 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            preCloseCallback: function() {
              scope.currentReport = {};
            },
          });

          function initializeArrays() {
            scope.listCtrlFiliereDocumentsLies.filieres = [];
            scope.listCtrlFiliereDocumentsLies.controles = [];
            scope.listCtrlFiliereDocumentsLies.vidanges = [];
            scope.listCtrlFiliereDocumentsLies.cahiers = [];
            scope.currentFilieres = undefined;
            scope.currentControles = undefined;
            scope.currentVidanges = undefined;
            scope.currentCahiers = undefined;
            scope.currentControlesFacturesAnnuelles = undefined;
            scope.documentsCheckedForMail = [];
          }

          function prepareFilieres() {
            QueryFactory.data(
              filiereFti.uid,
              'ref_dossier=\'' + scope.currentReport.id + '\''
            ).then(function(res) {
              scope.currentFilieres = gaJsUtils.sortByFeatureId(
                res.data.features,
                'desc'
              );

              scope.currentFilieres.forEach(function(f, idx) {
                f.attachmentsNo = ancBacTools.getCurrentDossierAttachmentsInfos(
                  scope.doss,
                  scope.currentReport
                ).filieresAttachments[f.id];

                var toPushF = {
                  label:
                    f.properties.nom +
                    (f.properties.etat === 'active' ? ' (filière active)' : ''),
                  attachmentData: {
                    id: f.id,
                    featuretype: 'kis_anc_dossier_filiere',
                    feature: f,
                  },
                };
                scope.listCtrlFiliereDocumentsLies.filieres.push(toPushF);
                if (f.properties.etat === 'active') {
                  scope.currentFiliereShowFiles = toPushF;
                }
              });
              prepareControles();
            });
          }

          function prepareControles() {
            AncAppFactory.getcontroles(scope.currentReport.id).then(function (
              res
            ) {
              scope.currentControles = gaJsUtils.sortByFeatureId(
                res.data.features,
                'desc'
              );
              scope.currentControles.forEach(function (c, idx) {
                var ctrlLabel = AncAppFactory.getControleName(
                  c.properties.type,
                  c.properties.date_passage
                );
                c.attachmentsNo = ancBacTools.getCurrentDossierAttachmentsInfos(
                  scope.doss,
                  scope.currentReport
                ).controlesAttachments[c.id];
                var toPushC = {
                  label:
                    ctrlLabel +
                    (c.properties.etat === 'ouvert'
                      ? ' (contrôle en cours)'
                      : ''),
                  attachmentData: {
                    id: c.id,
                    featuretype: 'kis_anc_dossier_controle',
                    feature: c,
                  },
                };
                scope.listCtrlFiliereDocumentsLies.controles.push(toPushC);
                if (c.properties.etat === 'ouvert') {
                  scope.currentCtrlShowFiles = toPushC;
                }
              });
              if (AncAppFactory.appCfg.main.properties.formVidange) {
                prepareVidanges();
              } else if (
                scope.currentReport.properties.filiere_sup_20_eh === true
              ) {
                prepareCahiers();
              } else {
                scope.fillDossierAttachmentsTab();
              }
            });
          }
          function prepareVidanges() {
            QueryFactory.data(
              scope.vidangeFormFti.uid,
              'ref_dossier=\'' + scope.currentReport.id + '\''
            ).then(function(res) {
              scope.currentVidanges = gaJsUtils.sortByFeatureId(
                res.data.features,
                'desc'
              );

              scope.currentVidanges.forEach(function(f, idx) {
                f.attachmentsNo = ancBacTools.getCurrentDossierAttachmentsInfos(
                  scope.doss,
                  scope.currentReport
                ).vidangesAttachments[f.id];

                var toPushV = {
                  label:
                    'Vidange ' +
                    $filter('date', 'dd.MM.yyyy')(f.properties.date_creation) +
                    (f.properties.etat === 'actif' ? ' (vidange active)' : ''),
                  attachmentData: {
                    id: f.id,
                    featuretype: 'kis_anc_vidange_formulaire',
                    feature: f,
                  },
                };

                scope.listCtrlFiliereDocumentsLies.vidanges.push(toPushV);
                if (f.properties.etat === 'actif') {
                  scope.currentVidangesShowFiles = toPushV;
                }
              });
              if (scope.currentReport.properties.filiere_sup_20_eh === true) {
                prepareCahiers();
              } else {
                scope.fillDossierAttachmentsTab();
              }
            });
          }

          function prepareCahiers() {
            QueryFactory.data(
              cahierFti.uid,
              'ref_dossier=\'' + scope.currentReport.id + '\''
            ).then(function(res) {
              scope.currentCahiers = gaJsUtils.sortByFeatureId(
                res.data.features,
                'desc'
              );

              scope.currentCahiers.forEach(function(f, idx) {
                f.attachmentsNo = ancBacTools.getCurrentDossierAttachmentsInfos(
                  scope.doss,
                  scope.currentReport
                ).cahiersAttachments[f.id];
                var toPushC = {
                  label:
                    f.properties.nom +
                    (f.properties.etat === 'actif' ? ' (cahier actif)' : ''),
                  attachmentData: {
                    id: f.id,
                    featuretype: 'kis_anc_dossier_cahier_de_vie',
                    feature: f,
                  },
                };

                scope.listCtrlFiliereDocumentsLies.cahiers.push(toPushC);
                if (f.properties.etat === 'actif') {
                  scope.currentCahiersShowFiles = toPushC;
                }
              });
              scope.fillDossierAttachmentsTab();
            });
          }
        };

        scope.dossierSpecialActions = [
          {
            class: 'btn btn-default btn-xs',
            icone: 'fa fa-paperclip ancBacDossierListAttachmentsButton',
            text: 'Documents du dossier',
            buttonLabel:
              '\' (\' + obj.properties.attachmentsInfos.totalAttachmentsNo + \')\'',
            buttonLabelIsExpression: true,
            callFunction: scope.openAttachmentsDialog,
          },
        ];

        scope.$watch(
          'currentFilieres',
          function(newValue) {
            if (angular.isDefined(scope.currentFilieres)) {
              scope.updateDocumentsLabel(
                scope.currentFilieres,
                'filieres',
                'filiereId',
                'documents_filiere',
                'Documents liés'
              );
              ancBacTools.recalculateDocumentsNoforTab(
                scope.doss,
                scope.currentReport,
                scope.documentLiesTousTabs,
                scope.currentFilieres,
                'filières',
                'Filières',
                'filieresAttachments'
              );
              scope.recalculateDocumentsNo();
            }
          },
          true
        );

        scope.$watch(
          'currentCahiers',
          function(newValue) {
            if (angular.isDefined(scope.currentCahiers)) {
              scope.updateDocumentsLabel(
                scope.currentCahiers,
                'cahiers_de_vie',
                'cahierId',
                'documents_cahier_de_vie',
                'Documents liés'
              );
              ancBacTools.recalculateDocumentsNoforTab(
                scope.doss,
                scope.currentReport,
                scope.documentLiesTousTabs,
                scope.currentCahiers,
                'cahiers_de_vie',
                'Cahiers de vie',
                'cahiersAttachments'
              );
              scope.recalculateDocumentsNo();
            }
          },
          true
        );

        scope.$watch(
          'currentControles',
          function(newValue) {
            if (angular.isDefined(scope.currentControles)) {
              scope.updateDocumentsLabel(
                scope.currentControles,
                'controles',
                'controleId',
                'documents_controle',
                'Documents du contrôle'
              );
              ancBacTools.recalculateDocumentsNoforTab(
                scope.doss,
                scope.currentReport,
                scope.documentLiesTousTabs,
                scope.currentControles,
                'controles',
                'Contrôles',
                'controlesAttachments'
              );
              scope.recalculateDocumentsNo();
            }
          },
          true
        );

        scope.$watch(
          'currentVidanges',
          function(newValue) {
            if (angular.isDefined(scope.currentVidanges)) {
              scope.updateDocumentsLabel(
                scope.currentVidanges,
                'vidanges',
                'vidangeId',
                'documents_vidange',
                'Documents'
              );
              ancBacTools.recalculateDocumentsNoforTab(
                scope.doss,
                scope.currentReport,
                scope.documentLiesTousTabs,
                scope.currentVidanges,
                'vidanges',
                'Vidanges',
                'vidangesAttachments'
              );
              scope.recalculateDocumentsNo();
            }
          },
          true
        );

        scope.$watch(
          'dossierAttachmentData',
          function(newValue) {
            let currentDossierAttachmentsInfos = ancBacTools.getCurrentDossierAttachmentsInfos(
              scope.doss,
              scope.currentReport
            );
            if (
              scope.dossierAttachmentData != null &&
              currentDossierAttachmentsInfos != null
            ) {
              currentDossierAttachmentsInfos.dossierAttachmentsNo =
                scope.dossierAttachmentData.attachmentsNo;
              ancBacTools.updateTabLabel(
                scope.documentLiesTousTabs,
                'dossier',
                'Dossier',
                scope.dossierAttachmentData.attachmentsNo
              );
              scope.recalculateDocumentsNo();
            }
          },
          true
        );

        scope.updateDocumentsLabel = function(
          sourceElements,
          mainIdentifier,
          idName,
          documentsIdentifier,
          documentsLabel
        ) {
          if (angular.isDefined(sourceElements)) {
            let mainElement = scope.reportTree.find(function(element) {
              return element.identifier === mainIdentifier;
            });
            if (angular.isDefined(mainElement)) {
              sourceElements.forEach(function(item) {
                if (angular.isDefined(mainElement.children)) {
                  let childElement = mainElement.children.find(function(
                    element
                  ) {
                    return element[idName] === item.id;
                  });
                  if (angular.isDefined(childElement)) {
                    let documentsElement = childElement.children.find(function(
                      element
                    ) {
                      return element.identifier === documentsIdentifier;
                    });
                    if (angular.isDefined(documentsElement)) {
                      documentsElement.label =
                        documentsLabel +
                        ' (' +
                        (angular.isDefined(item.attachmentsNo)
                          ? item.attachmentsNo
                          : 0) +
                        ')';
                    }
                  }
                }
              });
            }
          }
        };

        scope.updateAllTabsLabels = function() {
          if (angular.isDefined(scope.currentFilieres)) {
            ancBacTools.recalculateDocumentsNoforTab(
              scope.doss,
              scope.currentReport,
              scope.documentLiesTousTabs,
              scope.currentFilieres,
              'filières',
              'Filières',
              'filieresAttachments'
            );
          }
          if (angular.isDefined(scope.currentCahiers)) {
            ancBacTools.recalculateDocumentsNoforTab(
              scope.doss,
              scope.currentReport,
              scope.documentLiesTousTabs,
              scope.currentCahiers,
              'cahiers_de_vie',
              'Cahiers de vie',
              'cahiersAttachments'
            );
          }
          if (angular.isDefined(scope.currentControles)) {
            ancBacTools.recalculateDocumentsNoforTab(
              scope.doss,
              scope.currentReport,
              scope.documentLiesTousTabs,
              scope.currentControles,
              'controles',
              'Contrôles',
              'controlesAttachments'
            );
          }
          if (angular.isDefined(scope.currentVidanges)) {
            ancBacTools.recalculateDocumentsNoforTab(
              scope.doss,
              scope.currentReport,
              scope.documentLiesTousTabs,
              scope.currentVidanges,
              'vidanges',
              'Vidange',
              'vidangesAttachments'
            );
          }
          scope.recalculateDocumentsNo();
        };

        scope.recalculateDocumentsNo = function() {
          let currentDossierAttachmentsInfos = ancBacTools.getCurrentDossierAttachmentsInfos(
            scope.doss,
            scope.currentReport
          );
          if (angular.isDefined(currentDossierAttachmentsInfos)) {
            currentDossierAttachmentsInfos.totalAttachmentsNo = 0;
            addValue(currentDossierAttachmentsInfos.filieresAttachmentsNo);
            addValue(currentDossierAttachmentsInfos.cahiersAttachmentsNo);
            addValue(currentDossierAttachmentsInfos.controlesAttachmentsNo);
            addValue(currentDossierAttachmentsInfos.vidangesAttachmentsNo);
            addValue(currentDossierAttachmentsInfos.dossierAttachmentsNo);
            let documentsElement = scope.reportTree.find(function(element) {
              return element.identifier === 'documents_dossier';
            });
            if (angular.isDefined(documentsElement)) {
              documentsElement.label =
                'Documents du dossier (' +
                currentDossierAttachmentsInfos.totalAttachmentsNo +
                ')';
            }

            function addValue(value) {
              if (angular.isDefined(value) && !isNaN(value)) {
                currentDossierAttachmentsInfos.totalAttachmentsNo += value;
              }
            }
          }
        };

        scope.checkboxChanged = function(featureId, document, isChecked) {
          ancBacTools.checkboxChanged(
            scope.documentsCheckedForMail,
            featureId,
            document,
            isChecked
          );
        };

        scope.getSelectedCheckboxes = function(featureId) {
          let documentsForFeature = scope.documentsCheckedForMail.filter(
            (element) => element.featureId === featureId
          );
          return documentsForFeature.map((element) => element.document);
        };

        scope.prepareDocumentsForMail = function() {
          let featureTypeInfos = [];
          featureTypeInfos.push({
            featureType: 'kis_anc_dossier',
            folder: 'Dossier',
            hasSubfolders: false,
          });
          featureTypeInfos.push({
            featureType: 'kis_anc_dossier_filiere',
            folder: 'Filières',
            features: scope.listCtrlFiliereDocumentsLies.filieres,
            hasSubfolders: true,
          });
          featureTypeInfos.push({
            featureType: 'kis_anc_dossier_controle',
            folder: 'Contrôles',
            features: scope.listCtrlFiliereDocumentsLies.controles,
            hasSubfolders: true,
          });
          featureTypeInfos.push({
            featureType: 'kis_anc_dossier_cahier_de_vie',
            folder: 'Cahiers de vie',
            features: scope.listCtrlFiliereDocumentsLies.cahiers,
            hasSubfolders: true,
          });
          featureTypeInfos.push({
            featureType: 'kis_anc_vidange_formulaire',
            folder: 'Vidanges',
            features: scope.listCtrlFiliereDocumentsLies.vidanges,
            hasSubfolders: true,
          });
          let documentsInfos = {
            documentsCheckedForMail: scope.documentsCheckedForMail,
            featureTypeInfos: featureTypeInfos,
          };
          ancBacTools.prepareDocumentsForMail(documentsInfos);
        };

        function getDossierListIds() {
          return (scope.ctrlDossiers || []).map(
            (dossier) => dossier && dossier.doss.id
          );
        }

        function extractDateToDatePassageSelonTypeCtrl() {
          let dateToInsert = 'date_controle';
          if (scope.currentControle.properties.type === 'FO0') {
            dateToInsert = 'date_demande';
          } else {
            if (scope.currentControle.properties.type === 'Ponctuel') {
              dateToInsert = 'date_intervention';
            }
          }
          return dateToInsert;
        }

        /**
         * Calcule de la date maximun pour effectuer le prochain controle
         * 
         * @param {date} date_passage date de passage de controle 
         * @param {date} date_controle date de controle
         * @param {date} date_avis date de l'application de l'avis responsable
         * @param {number} delai delai pour le prochain controle
         * 
         * @returns date max de prochain controle
         */
         const calcDateMax = (date_passage, date_controle, date_avis, delai) => {
          // Determination de la date de controle a prendre , date passage , sinon date controle , sinon date de l'avis
          const date_base_string =
            date_passage != null
              ? date_passage
              : date_controle != null
              ? date_controle
              : date_avis;
          // Parse de la date
          const dateMax = new Date(Date.parse(date_base_string));
          // Rajouter le delai
          dateMax.setDate(dateMax.getDate() + delai);
          return dateMax;
        };
        
        scope.changeFileFilterButton = (newValue)=>{
          scope.dossierFilterBtn.v = scope.dossierFilterBtn.v !== newValue
            ? newValue
            : scope.dossierFilterBtn.v;
          filesToUpdateData.length = 0;
          scope.res.length = 0;
        };

        scope.calculeDateRdv = (needToSaveDossier) => {
          if (
            scope.cdata &&
            scope.cdata.datesDossier &&
            scope.cdata.datesDossier.date_controle_rdv &&
            scope.currentReport.properties.date_prochain_controle !==
              scope.cdata.datesDossier.date_controle
          ) {
            scope.currentReport.properties.date_prochain_controle = angular.equals(
              scope.cdata.datesDossier.date_controle_rdv,
              {}
            )
              ? null
              : $filter('date')(
                scope.cdata.datesDossier.date_controle_rdv,
                'yyyy-MM-ddTHH:mm:ss.sssZ'
              );
            needToSaveDossier = true;
          }
          return needToSaveDossier;
        };
        // Ceci est supprimé pour éviter la relecture de la date de rdv du contrôle selectionné et son transfert automatique sur la date de rdv contrôle
        /*
        scope.$watch(
          'cdata.datesDossier.date_controle_rdv',
          function (newValue) {
            let needToSaveDossier = false;
            needToSaveDossier   = scope.calculeDateRdv(needToSaveDossier);
            if (needToSaveDossier) {
              scope.saveReport();
            }
          },
          true
        );
        */

        //******************************************************************************************* */
        // La facturation Annuelle
        //******************************************************************************************* */
        /**
         * get Controles Facturation Annuelle Data
         */
        scope.getControlesFacturationAnnuelleData = () => {
          AncAppFactory.getControlesFacturationAnnuelleData(scope.currentReport.id).then(
            (res) => {
              scope.currentControlesFacturesAnnuelles = res.data;
            },
            () => {
              require('toastr').error(
                $filter('translate')('facturationAnnuelle.getAll.error'),
                '',
                { positionClass: 'toast-bottom-left' }
              );
              gaDomUtils.hideGlobalLoader();
            }
          );
        };
        /**
          * Supprimer une écheance de la facturation annuelle
          */
        scope.removeLinkWithAnnualInvoice = (controleFactureAnnuelle) => {
          AncAppFactory.removeLinkWithAnnualInvoice(controleFactureAnnuelle,scope.currentReport.id).then(
            (res) => {
              require('toastr').success(
                $filter('translate')('facturationAnnuelle.remove.succes'),
                '',
                { positionClass: 'toast-bottom-left' }
              );
              gaDomUtils.hideGlobalLoader();
              /**
               * Refresh des données de la facturation annuelle , apres suppression ligne
              */
              scope.currentControlesFacturesAnnuelles = res.data;
            },
            () => {
              require('toastr').error(
                $filter('translate')('facturationAnnuelle.remove.error'),
                '',
                { positionClass: 'toast-bottom-left' }
              );
              gaDomUtils.hideGlobalLoader();
            }
          );
        };
        /**
         * Arreter la facturation des contrôles dans le mm dossier , suite à la création
         * d'un nouveau
         *
         * @param {*} typeNewCtrl
         * @param {*} referenceDossier
         */
        scope.updateControlesArreterFacturationAnnuelle = (typeNewCtrl) => {
          // Récupération de la liste des ctrls , a mettre a jour en arrettant la facturation annuelle
          let controlesArretAnnualisation =
          scope.returnCtrlsAArreterFacturationAnnuelle(typeNewCtrl);
          if (controlesArretAnnualisation.length > 0) {
            let pdata = {
              controlesArretAnnualisation: [],
            };
            let controlesArretAnnualisationTypes = [];
            for (const controleArretAnnualisation of controlesArretAnnualisation) {
              pdata.controlesArretAnnualisation.push(
                controleArretAnnualisation.id
              );
              controlesArretAnnualisationTypes.push(
                controleArretAnnualisation.properties.type
              );
            }
            /**
             * Message d'information
             */
            require('toastr').info(
              'La création de ce nouveau contrôle : ' +
                typeNewCtrl +
                ' , entraînera l’arrêt de la facturation annuelle, pour les contrôles suivants :' +
                controlesArretAnnualisationTypes.join(', ')
            );

            AncAppFactory.updateControlesArreterFacturationAnnuelle(pdata).then(
              function (res) {
                require('toastr').success(
                  $filter('translate')('facturationAnnuelle.stop.success'),
                  '',
                  { positionClass: 'toast-bottom-left' }
                );
                gaDomUtils.hideGlobalLoader();
              },
              function (err) {
                require('toastr').error(
                  $filter('translate')('facturationAnnuelle.stop.error'),
                  'Erreur',
                  { positionClass: 'toast-bottom-left' }
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /**
         * verification Si le type de nouveau Control à creer est parmis la configuration
         * d'arret d'annualisation d'un autre controle
         *
         * @param {*} typeCtrl
         * @returns
         */
        scope.returnCtrlsAArreterFacturationAnnuelle = (typeCtrl) => {
          let controlesArretAnnualisation = [];
          let ctrlsAnnualise = scope.loadConfigFacturationAnnualise();
          for (const ctrlAnnualise of ctrlsAnnualise) {
            for (const typeCtrlConditionArretAnunualisation of ctrlAnnualise.typeCtrlsConditionArretAnnualisation) {
              // verification si le type de nouveau controle , existe comme condition d'arret de facturation annuelle
              // pour un autre type de controle
              if (typeCtrlConditionArretAnunualisation == typeCtrl) {
                for (const currentControle of scope.currentControles) {
                  // verification si un des controles encours de dossier, est en facturation annuelle et doit etre
                  // arretée suite à la création de ce nouveau controle.
                  if(currentControle.properties && currentControle.properties.type == ctrlAnnualise.type && currentControle.properties.statut_facture == 'FACTURE_ANNUELLE_EN_COURS') {
                    controlesArretAnnualisation.push(currentControle);
                  }
                }
              }
            }
          }
          return controlesArretAnnualisation;
        };
        /**
         * load Configuration de la Facturation Annualiseé
         * @returns
         */
        scope.loadConfigFacturationAnnualise = () => {
          let ctrlAnnualise = [];
          // Récupération de la confuguration des templates de facturation
          scope.periodesCfg = angular.copy(
            AncAppFactory.appCfg.main.periodesCfg
          );

          if (scope.periodesCfg && scope.periodesCfg.templates) {
            // Récupération des templates Annualisés
            const templatesAnnualise = scope.periodesCfg.templates.filter(
              (template) =>
                template.parameters &&
                template.parameters.annualisation &&
                template.parameters.annualisation.active
            );
            // Récupération des controles Annualisés
            for (const template of templatesAnnualise) {
              for (const [key, value] of Object.entries(template.controles)) {
                if (value.selected) {
                  let ctrl = {};
                  ctrl.typeCtrlsConditionArretAnnualisation=[];
                  ctrl.type = key;
                  if(template.parameters.annualisation.controlesArrets){
                    for (const controleArret in template.parameters.annualisation.controlesArrets) {
                      if(template.parameters.annualisation.controlesArrets[controleArret].selected){
                        ctrl.typeCtrlsConditionArretAnnualisation.push(controleArret);
                      }
                    }
                  }
                  ctrlAnnualise.push(ctrl);
                }
              }
            }
          }
          return ctrlAnnualise;
        };
      },
    };
  };

  listeDossiers.$inject = [
    'AncAppFactory',
    'BacAppFactory',
    'ApplicationFactory',
    'FeatureTypeFactory',
    '$filter',
    '$rootScope',
    'ngDialog',
    'gaDomUtils',
    'FeatureHistoryFactory',
    '$timeout',
    'QueryFactory',
    'EditFactory',
    '$sce',
    'DocumentFactory',
    '$q',
    'CalendarFactory',
    'gaJsUtils',
    'UsersFactory',
    '$location',
    'FeatureAttachmentFactory',
    'uiCalendarConfig',
    '$interval',
    'ancBacTools',
    'DataStoreFactory',
    'ConfigFactory',
    'kisCalendarFactory',
    'OmegaFactory',
    'dateUtils',
    'HtmlUtils',
    'gclayers'
  ];
  return listeDossiers;
});


