'use strict';
define(function() {
  /**
   * 03/2018 Positionnement du dossier dans ANC / BAC
   */
  var ancBacPositionDossier = function(
    AncAppFactory,
    BacAppFactory,
    gaJsUtils,
    $timeout,
    $http,
    GoogleMapsFactory,
    gaDomUtils,
    FeatureTypeFactory,
    QueryFactory,
    ogcFactory,
    $q,
    $rootScope,
    ParametersFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_position_dossier.html',
      restrict: 'E',
      scope: {
        apptype: '=',
        dossier: '=',
      },
      link: function(scope) {
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;
        var draw;
        var parcellesCfg = CurrentAppFactory.appCfg.main.parcellesCfg;
        var parcelleFields = parcellesCfg.fields;
        var parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          parcellesCfg.emplacement
        );

        var spancOrSpac = scope.apptype == 'anc' ? 'SPANC' : 'SPAC';

        var dossierFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          'kis_' + scope.apptype + '_dossier'
        );

        scope.requests = [];

        scope.typeParcelleFields = {};
        if (parcellesFti != null) {
          parcellesFti.attributes.forEach(function(attr) {
            var numOrSecOrCom = '';
            if (
              attr.name == parcelleFields.numero
                ? (numOrSecOrCom = 'numero')
                : attr.name == parcelleFields.section
                ? (numOrSecOrCom = 'section')
                : attr.name == parcelleFields.commune
                ? (numOrSecOrCom = 'commune')
                : null
            ) {
              scope.typeParcelleFields[numOrSecOrCom] = attr.type;
            }
          });
        }

        scope.adresses = {};
        scope.parcelles = {};

        var _container = document.getElementById('abpd_popup');
        var _closer = document.getElementById('abpd_popup-closer');

        _closer.onclick = function() {
          overlay.setPosition(undefined);
          _closer.blur();
          return false;
        };

        var overlay = new ol.Overlay({
          element: _container,
          autoPan: true,
          autoPanAnimation: {
            duration: 250,
          },
        });

        scope.fullScreen = false;

        // type de webservice d'interrogation des adresses
        scope.service = 'ban';
        if (
          CurrentAppFactory.appCfg.main.properties.serviceLocalisationDossier
            .url
        ) {
          if (
            CurrentAppFactory.appCfg.main.properties.serviceLocalisationDossier
              .type == 'ban'
          )
            scope.service = 'ban';
        }

        scope.dessinEnCours = false;
        scope.searchModes = [
          {
            id: 'adresse',
            alias: 'Adresse',
          },
          {
            id: 'parcelles',
            alias: 'Parcelles',
          },
        ];
        scope.currentSearchMode = {
          v: 'adresse',
        };

        // When on map app do not add these layers
        scope.featuresConfig =
          window.location.href.indexOf('/map') === -1
            ? CurrentAppFactory.appCfg.main.mapConfiguration.featuresConfig
            : {};

        // --------------- init icon & map
        // --- icon
        var posDossierFeature = new ol.Feature({
          geometry: new ol.geom.Point([0, 0]),
        });

        var posStyle = new ol.style.Style({
          image: new ol.style.Icon({
            anchor: [0.5, 0.5],
            anchorXUnits: 'fraction',
            anchorYUnits: 'fraction',
            src: 'img/anc/dossier.png',
          }),
        });

        var posDossierSource = new ol.source.Vector({
          features: [posDossierFeature],
        });
        var posDossierLayer = new ol.layer.Vector({
          source: posDossierSource,
          zIndex: 999,
        });

        // --- parcelle
        var parcelleFeature = new ol.Feature({
          geometry: new ol.geom.MultiPolygon([[[0, 0, 0, 0]]]),
        });

        var parcelleStyle = new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: 'blue',
            width: 3,
          }),
          fill: new ol.style.Fill({
            color: 'rgba(0, 0, 255, 0.1)',
          }),
        });

        var parcelleSource = new ol.source.Vector({
          features: [parcelleFeature],
        });
        var parcelleLayer = new ol.layer.Vector({
          source: parcelleSource,
          zIndex: 1,
        });
        // --- map
        const mapView = new ol.View({
            projection: 'EPSG:3857',
            center: [594374.331946, 5459152.92713],
          });
        const map = new ol.Map({
            layers: [
              new ol.layer.Tile({
                source: new ol.source.OSM({
                  url: 'https://{a-c}.tile.openstreetmap.org/{z}/{x}/{y}.png',
                  crossOrigin: null,
                  zIndex: 0,
                }),
              }),
              posDossierLayer,
              parcelleLayer,
            ],
            interactions: [],
            target: 'pos_dossier',
            controls: [],
            overlays: [overlay],
            view: mapView,
          });

        // --------------------------------------------------

        var getDossierCenter = function() {
          if (
            angular.isUndefined(scope.dossier.geometry) ||
            angular.isUndefined(scope.dossier.geometry.coordinates)
          ) {
            return undefined;
          }
          var x = scope.dossier.geometry.coordinates[0],
            y;
          // multipoints
          if (angular.isArray(x)) {
            y = x[1];
            x = x[0];
          } else {
            y = scope.dossier.geometry.coordinates[1];
          }

          return [x, y];
        };

        /**
         * positionDossierData
         */

        var setPosDossierData = function(reset) {
          // reset
          scope.posDossierData = {
            position: {
              checked: false,
              value: false,
            },
            adresse: {
              checked: false,
              value: false,
              label: '',
            },
            parcelle: {
              checked: false,
              value: false,
              label: '',
            },
          };
          // set
          if (!reset) {
            if (
              angular.isDefined(scope.dossier.geometry) &&
              scope.dossier.geometry != null
            ) {
              scope.posDossierData.position = {
                checked: true,
                value: getDossierCenter(),
              };
            }
          }
        };
        setPosDossierData();

        /**
         * toggleFullScreen et interactions
         */

        var _interactions = [
          new ol.interaction.DragRotate(),
          new ol.interaction.DoubleClickZoom(),
          new ol.interaction.DragPan(),
          new ol.interaction.PinchRotate(),
          new ol.interaction.PinchZoom(),
          new ol.interaction.KeyboardPan(),
          new ol.interaction.KeyboardZoom(),
          new ol.interaction.MouseWheelZoom(),
          new ol.interaction.DragZoom(),
        ];

        scope.toggleFullScreen = function() {
          scope.fullScreen = !scope.fullScreen;
          if (scope.fullScreen) {
            _interactions.map(function(x) {
              map.addInteraction(x);
            });
          } else {
            _interactions.map(function(x) {
              map.removeInteraction(x);
            });
            overlay.setPosition(undefined);
            scope.dessinEnCours = false;
            map.removeInteraction(draw);

            if (angular.isDefined(scope.dossier.geometry)) {
              $timeout(function() {
                mapView.setCenter(getDossierCenter());
              });
            }
          }

          $timeout(function() {
            map.updateSize();
            map.render();
            map.renderSync();
          });
        };
        /**
         * Une parcelle est choisie
         *
         * @param {*}
         *            p
         */
        var selectParcelle = function(p) {
          // set parcelle
          scope.posDossierData.parcelle.checked = true;
          scope.posDossierData.parcelle.label =
            p.properties[parcelleFields.commune] +
            ' ' +
            p.properties[parcelleFields.section] +
            ' ' +
            p.properties[parcelleFields.numero];
          scope.posDossierData.parcelle.value = p;

          // dessine la geometrie
          if (angular.isDefined(p.geometry)) {
            $timeout(function() {
              if (p.geometry.type == 'MultiPolygon') {
                parcelleFeature
                  .getGeometry()
                  .setCoordinates(p.geometry.coordinates);
              } else {
                parcelleFeature
                  .getGeometry()
                  .setCoordinates([p.geometry.coordinates]);
              }
              parcelleFeature.setStyle(parcelleStyle);
            });
          }
        };

        /**
         * getParcellesAtPosition
         *
         * @param {*}
         *            coords
         */
        var getParcellesAtPosition = function(coords) {
          var x = coords[0],
            y = coords[1],
            leftX = x - 1,
            rightX = x + 1,
            bottomY = y - 1,
            topY = y + 1;

          var promise = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            parcellesFti.uid,
            'json',
            'EPSG:3857',
            'INTERSECTS(geom, POLYGON((' +
              leftX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              bottomY +
              ')))'
          );
          promise.then(
            function(res) {
              console.log(res);
            },
            function(e) {
              console.log('err', e);
            }
          );

          return promise;
        };

        /**
         * positionChoosen
         *
         * @param {*}
         *            chosenCoords
         * @param {*}
         *            refreshAdresse
         * @param {*}
         *            refreshParcelle
         * @param {*}
         *            zoomToFeature
         */
        var positionChoosen = function(
          chosenCoords,
          refreshAdresse,
          refreshParcelle,
          zoomToFeature
        ) {
          console.log(chosenCoords);

          scope.placeMarkerAtPosition(chosenCoords);
          overlay.setPosition(chosenCoords);

          $timeout(function() {
            var animateTo = {
              duration: 500,
              center: chosenCoords,
            };
            if (zoomToFeature || mapView.getZoom() < 16) animateTo.zoom = 20;
            mapView.animate(animateTo);
          }, 100);

          scope.posDossierData.position.value = chosenCoords;
          scope.posDossierData.position.checked = true;

          // maj adresse
          if (refreshAdresse) {
            // unset adresse
            scope.posDossierData.adresse.checked = false;
            scope.posDossierData.adresse.label = '';
            scope.posDossierData.adresse.value = false;

            var newPosCoords = ol.proj.transform(
              chosenCoords,
              mapView.getProjection().getCode(),
              'EPSG:4326'
            );

            var url = gaJsUtils.getUrlReverseGeocoder(
              newPosCoords,
              scope.service
            );
            if (
              CurrentAppFactory.appCfg.main.properties
                .serviceLocalisationDossier.url &&
              !CurrentAppFactory.appCfg.main.properties
                .serviceLocalisationDossier.defaultReverseGeocoder
            ) {
              if (
                CurrentAppFactory.appCfg.main.properties
                  .serviceLocalisationDossier.type == 'ban'
              ) {
                url = url.replace(
                  'https://api-adresse.data.gouv.fr/',
                  CurrentAppFactory.appCfg.main.properties
                    .serviceLocalisationDossier.url
                );
              }
            }
            console.log('ancBacPositionDossier geocode : ' + url);
            // Action en cours
            gaDomUtils.showGlobalLoader();

            var promise = $http.get(url);
            promise.then(
              function(res) {
                JSON.stringify(res);
                var newRes = gaJsUtils.transformGeocoderRes(res, scope.service);

                if (
                  newRes.data.features.length &&
                  angular.isDefined(newRes.data.features['0'].properties.label)
                ) {
                  scope.adresses = {
                    newRes: {
                      value: newRes.data.features['0'].properties.label,
                    },
                  };
                  scope.posDossierData.adresse.label =
                  fixBisTerAdresse(newRes.data.features['0'].properties.label);
                  scope.posDossierData.adresse.value =
                    newRes.data.features['0'].properties;
                   scope.posDossierData.adresse.value.housenumber =
                   fixBisTerAdresse(newRes.data.features['0'].properties.housenumber);
                  scope.posDossierData.adresse.checked = true;
                }
                // Sortir d'action en cours
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                console.log("erreur lors de la recup de l'adresse");
                gaDomUtils.hideGlobalLoader();
              }
            );
          }

          if (refreshParcelle && parcellesFti.geographic) {
            // unset parcelle
            scope.posDossierData.parcelle.checked = false;
            scope.posDossierData.parcelle.label = '';
            scope.posDossierData.parcelle.value = false;

            getParcellesAtPosition(chosenCoords).then(function(res) {
              if (res.data.features.length)
                selectParcelle(res.data.features[0]);
            });
          }
        };
        /**
         * toggleDrawPosition
         */
        scope.toggleDrawPosition = function() {
          scope.dessinEnCours = !scope.dessinEnCours;

          if (scope.dessinEnCours) {
            // add interaction
            draw = new ol.interaction.Draw({
              source: posDossierSource,
              type: 'Point',
              maxPoints: 1,
            });

            draw.set('gctype', 'kis');
            draw.set('interaction', 'Draw');
            draw.set('widget', 'ancBacPositionDossier');

            map.addInteraction(draw);
          } else {
            map.removeInteraction(draw);
          }

          // on drawend
          draw.on('drawend', function(evt) {
            positionChoosen(
              evt.feature.getGeometry().getCoordinates(),
              1,
              1,
              0
            );
          });
        };

        /**
         * placeMarkerAtPosition
         *
         * @param {*}
         *            coords
         */
        scope.placeMarkerAtPosition = function(coords) {
          posDossierSource.clear();
          posDossierFeature = new ol.Feature({
            geometry: new ol.geom.Point(coords),
          });
          posDossierSource.addFeature(posDossierFeature);
          posDossierFeature.setStyle(posStyle);
        };

        scope.getDisplayNameForParcelle = function(parcelle) {
          return (
            parcelle.properties[parcelleFields.section] +
            ' ' +
            parcelle.properties[parcelleFields.numero] +
            ' ' +
            parcelle.properties[parcelleFields.commune]
          );
        };

        var searchTimeout;

        var getParcellesCanceler = $q.defer();
        var getParcellesResolved = false;
        var getParcellesCancel = function() {
          getParcellesCanceler.resolve('http call aborted');
        };

        /**
         * getInformationsFromParcelles
         *
         * @param {*}
         *            search
         */
        scope.getInformationsFromParcelles = function(search) {
          if (getParcellesResolved) getParcellesCancel();

          getParcellesCanceler = $q.defer();
          getParcellesResolved = true;

          if (searchTimeout) $timeout.cancel(searchTimeout);

          if (search == '' || search == undefined) {
            return false;
          }

          let searchQuery = '';

          Object.keys(scope.typeParcelleFields).forEach(function(baseAttr) {
            if (angular.isDefined(scope.parcelles[baseAttr])) {
              if (scope.typeParcelleFields[baseAttr] == 'java.lang.String') {
                searchQuery.length == 0
                  ? (searchQuery = '' + getQueryParcelleLikeCondition(baseAttr))
                  : (searchQuery +=
                      ' AND ' + getQueryParcelleLikeCondition(baseAttr));
              } else {
                searchQuery.length == 0
                  ? (searchQuery =
                      '' + getQueryParcelleEqualCondition(baseAttr))
                  : (searchQuery +=
                      ' AND ' + getQueryParcelleEqualCondition(baseAttr));
              }
            }
          });

          console.log(searchQuery);

          return (searchTimeout = $timeout(function() {
            var postdata = {
              filter: searchQuery,
              page: '1',
              count: '8',
              sort: '',
              mapCrs: map
                .getView()
                .getProjection()
                .getCode(),
            };

            var promise = $http({
              method: 'POST',
              url:
                '/services/{portalid}/query/' +
                parcellesFti.uid +
                '/data?f=json',
              data: postdata,
              timeout: getParcellesCanceler.promise,
            });
            return promise.then(function(res) {
              if (res) {
                getParcellesResolved = false;
                scope.result = res.data.features;
                scope.result.forEach(function(parcelle) {
                  parcelle.properties.fullName =
                    parcelle.properties[parcelleFields.commune] +
                    ' ' +
                    parcelle.properties[parcelleFields.section] +
                    ' ' +
                    parcelle.properties[parcelleFields.numero];
                });
                if (scope.result.length) {
                  scope.hideResult = false;
                }
              }
            });
          }, 200));
        };

        const getQueryParcelleLikeCondition = baseAttr =>
          parcelleFields[baseAttr] +
          " ILIKE '%" +
          scope.parcelles[baseAttr] +
          "%'";

        const getQueryParcelleEqualCondition = baseAttr =>
          parcelleFields[baseAttr] + ' = ' + scope.parcelles[baseAttr];

        scope.getRequeteByName = function(search) {
          var requetes = scope.requests.filter(function(x) {
            return x.name.toLowerCase().indexOf(search.toLowerCase()) !== -1;
          });
          return requetes;
        };

        /**
         * getInformationsFromAddress
         *
         * @param {*}
         *            address
         */
        scope.getInformationsFromAddress = function(address) {
          let url;
          const lat = CurrentAppFactory.appCfg.main.parcellesCfg.lat;
          const long = CurrentAppFactory.appCfg.main.parcellesCfg.lon;
          let reversedCoordLocFeats;
          if (scope.service === 'nominatim')
            url =
              'https://nominatim.openstreetmap.org/?format=json&addressdetails=1&q=' +
              address;
          else if (scope.service === 'ban') {
            url =
              'https://api-adresse.data.gouv.fr/search/?q=' +
              address;
              /* we removed parameters because the API returns errors if limit > 100
              +'&autocomplete=0&limit=200'*/
            if (lat && long) {
              url += '&lat=' + lat + '&lon=' + long;
              $http
                .get(
                  'https://api-adresse.data.gouv.fr/reverse/?lon=' +
                    long +
                    '&lat=' +
                    lat
                )
                .then(function(response) {
                  reversedCoordLocFeats = response.data.features;
                });
            }
            if (
              CurrentAppFactory.appCfg.main.properties
                .serviceLocalisationDossier.url
            ) {
              if (
                CurrentAppFactory.appCfg.main.properties
                  .serviceLocalisationDossier.type == 'ban'
              ) {
                url = url.replace(
                  'https://api-adresse.data.gouv.fr/',
                  CurrentAppFactory.appCfg.main.properties
                    .serviceLocalisationDossier.url
                );
              }
            }
          }

          if (searchTimeout) $timeout.cancel(searchTimeout);

          if (address == '' || address == undefined) {
            return [];
          }

          return (searchTimeout = $timeout(function() {
            return $http.get(url).then(function(res) {
              if (scope.service === 'nominatim') {
                for (var i = 0; i < res.data.length; i++) {
                  res.data[i].value = scope.normalizeInput(
                    res.data[i].display_name
                  );
                  res.data[i].label = fixBisTerAdresse(res.data[i].display_name);
                }
              } else if (scope.service === 'ban') {
                if (lat && long) {
                  res.data = res.data.features.filter(feature =>
                    feature.properties.context.includes(
                      reversedCoordLocFeats[0].properties.context
                    )
                  );
                  res.data.forEach(feature => {
                    feature.value = scope.normalizeInput(
                      feature.properties.label
                    );
                    feature.label = fixBisTerAdresse(feature.properties.label);
                  });
                } else {
                  res.data = res.data.features;
                  for (let index = 0; index < res.data.length; index++) {
                    res.data[index].value = scope.normalizeInput(
                      res.data[index].properties.label
                    );
                    res.data[index].label = fixBisTerAdresse(res.data[index].properties.label);
                  }
                }
              }
              return res.data;
            });
          }, 200));
        };

        /**
         * resetPositionDossier
         */
        scope.resetPositionDossier = function() {
          scope.adresses.res = '';
          scope.parcelles.res = '';
          scope.dessinEnCours = false;
          scope.parcelles = {};
          scope.result = [];
          scope.hideResult = true;
          map.removeInteraction(draw);

          if (!scope.dossier.geometry) {
            posDossierSource.clear();
            parcelleFeature.setStyle(false);
            posDossierFeature.setStyle(false);

            setPosDossierData(1);
            overlay.setPosition(undefined);
          }
        };

        scope.hideResult = true;
        scope.setResult = function(value, picked) {
          scope.hideResult = true;

          if (angular.isDefined(value)) {
            Object.keys(parcelleFields).forEach(function(attr) {
              scope.parcelles[attr] = value.properties[parcelleFields[attr]];
            });
          }
          scope.selectValue(value, picked);
        };

        scope.selectValue = function(value, picked) {
          var coords = false;

          // parcelle
          if (
            angular.isDefined(picked.type) &&
            picked.type == 'Feature' &&
            angular.isDefined(picked.id) &&
            picked.id.startsWith(parcellesCfg.emplacement)
          ) {
            selectParcelle(picked);
            // si geometrique on met aussi a jour le point
            if (angular.isDefined(picked.geometry)) {
              $timeout(function() {
                positionChoosen(
                  parcelleFeature
                    .getGeometry()
                    .getInteriorPoints()
                    .getPoint(0)
                    .getCoordinates(),
                  1,
                  0,
                  1
                );
              });
            }
            // dossier
          } else {
            var adresse = scope.adresses.res;
            if (adresse != undefined) {
              var geom = [];
              // set adresse
              scope.posDossierData.adresse.checked = true;
              if (scope.service === 'ban') {
                scope.posDossierData.adresse.label = fixBisTerAdresse(adresse.properties.label);
                geom = adresse.geometry.coordinates;
                adresse = adresse.properties;
                adresse.housenumber = fixBisTerAdresse(adresse.housenumber);
              } else if (scope.service === 'nominatim') {
                scope.posDossierData.adresse.label = fixBisTerAdresse(adresse.display_name);
                geom.push(adresse.lat);
                geom.push(adresse.lon);
                adresse = adresse.address;
                adresse.housenumber = fixBisTerAdresse(adresse.housenumber);
              }

              scope.posDossierData.adresse.value = adresse;

              if (scope.service == 'nominatim') {
                if (geom.length) {
                  coords = GoogleMapsFactory.latLngTocoordinates(
                    {
                      lat: parseFloat(geom[0]),
                      lng: parseFloat(geom[1]),
                    },
                    'EPSG:3857'
                  );
                }
              } else if (scope.service == 'ban') {
                if (geom.length) {
                  coords = GoogleMapsFactory.latLngTocoordinates(
                    {
                      lat: parseFloat(geom[1]),
                      lng: parseFloat(geom[0]),
                    },
                    'EPSG:3857'
                  );
                }
              }
              $timeout(function() {
                positionChoosen(coords, 0, 1, 1);
              });
            }
          }
        };

        scope.normalizeInput = function(input) {
          let charMap = {
            à: 'a',
            â: 'a',
            é: 'e',
            è: 'e',
            ê: 'e',
            ë: 'e',
            ï: 'i',
            î: 'i',
            ô: 'o',
            ö: 'o',
            û: 'u',
            ù: 'u',
            ç: 'c',
          };
          $.each(charMap, (unnormalizedChar, normalizedChar) => {
            var regex = new RegExp(unnormalizedChar, 'gi');
            input = input.replace(regex, normalizedChar);
          });
          return fixBisTerAdresse(input);
        };
        /**
         * Rajouter un esapce avant le (bis, ter, A, B) ,dans le housenumber
         *
         * @param {*} input
         */
        const fixBisTerAdresse = (input) => {
          if (input && input.length > 0) {
            // récupération de numéor de voie
            const adresseNumero = input.split(' ')[0];
            //Rajouter un esapce avant le bis /ter
            if (adresseNumero && adresseNumero.length > 0) {
              if (adresseNumero.includes('bis')) {
                input = input.replace('bis', ' bis');
              } else if (adresseNumero.includes('ter')) {
                input = input.replace('ter', ' ter');
              } else if (adresseNumero.includes('A')) {
                input = input.replace('A', ' A');
              } else if (adresseNumero.includes('B')) {
                input = input.replace('B', ' B');
              }
            }
          }
          return input;
        };

        // selection effective de l'adresse
        scope.$on('$typeahead.select', function(value, picked) {
          scope.selectValue(value, picked);
        });

        /**
         * appliquer_position_dossier
         *
         * @param {*}
         *            feature
         * @param {*}
         *            coord
         * @param {*}
         *            type
         */
        var appliquer_position_dossier = function(feature, def) {
          console.log('appliquer_position_dossier');
          scope.dossier.geometry = feature.geometry;
          gaDomUtils.hideGlobalLoader();
          def.resolve();
        };

        /**
         * preAppliquerPositionDossier
         */
        var preAppliquerPositionDossier = function() {
          var def = $q.defer();

          var feature = new ol.format.GeoJSON().writeFeatureObject(
            new ol.Feature({
              geometry: new ol.geom.Point(scope.posDossierData.position.value),
            })
          );

          if (parcellesFti.geographic == true) {
            gaDomUtils.showGlobalLoader();
            getParcellesAtPosition(feature.geometry.coordinates).then(
              function(res) {
                if (res.data.features.length) {
                  var typeGeometrieParcelles =
                    res.data.features[0].geometry.type;
                  if (
                    typeGeometrieParcelles != 'MultiPolygon' &&
                    typeGeometrieParcelles != 'Polygon'
                  ) {
                    console.log(
                      "ERREUR : le type de géométrie des parcelles n'est pas supporté ()"
                    );
                  } else {
                    res.data.features.forEach(function(parcelle) {
                      var cql_filter = '',
                        coords_parcelle =
                          parcelle.geometry.type == 'MultiPolygon'
                            ? parcelle.geometry.coordinates[0][0]
                            : parcelle.geometry.coordinates[0];

                      for (var i = 0; i < coords_parcelle.length; i++) {
                        if (i == coords_parcelle.length - 1) {
                          cql_filter +=
                            coords_parcelle[i][0] + ' ' + coords_parcelle[i][1];
                        } else {
                          cql_filter +=
                            coords_parcelle[i][0] +
                            ' ' +
                            coords_parcelle[i][1] +
                            ',';
                        }
                      }

                      ogcFactory
                        .getfeaturespost(
                          'INTERSECTS(geom, POLYGON((' + cql_filter + ')))',
                          dossierFti.uid,
                          'EPSG:3857'
                        )
                        .then(
                          function(res) {
                            if (res.data.features.length) {
                              // verif
                              // si
                              // deja
                              // pas
                              // deja
                              // associe
                              // à un
                              // dossier
                              // sauf
                              // si
                              // dossier
                              // en
                              // cours....
                              var reponse = 1;
                              if (
                                res.data.features[0].id !== scope.dossier.id
                              ) {
                                reponse = confirm(
                                  'Le dossier ' +
                                    res.data.features[0].properties
                                      .ref_dossier +
                                    " est déjà sur cette parcelle!\nVoulez-vous l'associer à ce dossier également ?"
                                );
                              }
                              if (reponse) {
                                appliquer_position_dossier(feature, def);
                              } else {
                                gaDomUtils.hideGlobalLoader();
                              }
                            } else {
                              appliquer_position_dossier(feature, def);
                            }
                          },
                          function() {
                            def.reject();
                            require('toastr').error(
                              'Erreur lors de la récupération des parcelles à cette adresse (2).'
                            );
                            gaDomUtils.hideGlobalLoader();
                          }
                        );
                    });
                  }
                } else {
                  appliquer_position_dossier(feature, def);
                }
              },
              function() {
                def.reject();
                require('toastr').error(
                  'Erreur lors de la récupération des parcelles à cette adresse.'
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else {
            appliquer_position_dossier(feature, def);
          }

          return def.promise;
        };

        /**
         * appliquerAdresseDossier
         */
        var appliquerAdresseDossier = function() {
          // reset adresse actuelle
          [
            'adresse_num_rue',
            'adresse_rue',
            'adresse_ville',
            'adresse_pays',
            'adresse_cp',
            'adresse_complement',
            'adresse_batiment',
            'adresse_appt',
            'adresse_etage',
            'adresse_escalier',
            'adresse_bp',
            'adresse_num_rue_extra',
            'coordinates_x',
            'coordinates_y',
          ].forEach(function(x) {
            delete scope.dossier.properties[x];
          });

          // nominatim
          var binding = {};
          if (scope.service === 'nominatim') {
            binding = {
              adresse_num_rue: 'house_number',
              adresse_rue: 'road',
              // adresse_ville: "city", gere plus bas
              adresse_pays: 'country',
              adresse_cp: 'postcode',
            };
          } else if (scope.service === 'ban') {
            binding = {
              adresse_num_rue: 'housenumber',
              adresse_rue: 'street',
              // adresse_ville: "city", gere plus bas
              adresse_pays: 'country',
              adresse_cp: 'postcode',
            };
          }

          for (var i in binding) {
            if (scope.posDossierData.adresse.value[binding[i]]) {
              if (scope.posDossierData.adresse.value.type === 'street') {
                scope.dossier.properties.adresse_rue =
                  scope.posDossierData.adresse.value.name;
              }
              if (binding[i] === 'housenumber') {
                if (isNaN(scope.posDossierData.adresse.value[binding[i]])) {
                  var arrayRue = fixBisTerAdresse(scope.posDossierData.adresse.value[
                    binding[i]
                  ]).split(' ', 2);
                  scope.dossier.properties.adresse_num_rue = arrayRue[0];
                  scope.dossier.properties.adresse_num_rue_extra = arrayRue[1];
                } else {
                  scope.dossier.properties[i] =
                    scope.posDossierData.adresse.value[binding[i]];
                }
              } else {
                scope.dossier.properties[i] =
                  scope.posDossierData.adresse.value[binding[i]];
              }
            }
          }
          if (scope.dossier.properties.adresse_rue == undefined && scope.posDossierData.adresse.value.locality != undefined) {
            scope.dossier.properties.adresse_complement = scope.posDossierData.adresse.value.locality
          }

          // verif sur la ville
          var listeDesVillesActives = '';
          if (scope.apptype == 'anc') {
            listeDesVillesActives = CurrentAppFactory.appCfg.main.infosSpancListeVillesCfg.filter(
              function(x) {
                return x.gere_spanc;
              }
            );
          } else {
            listeDesVillesActives = CurrentAppFactory.appCfg.main.extra.infosSassListeVillesCfg.filter(
              function(x) {
                return x.gere_sass;
              }
            );
          }

          // alerte si ville pas connue
          var villeCorrespondance = scope.posDossierData.adresse.value['city']
            ? angular.copy(scope.posDossierData.adresse.value['city'])
            : false;
          if (listeDesVillesActives.length && villeCorrespondance) {
            var hits = listeDesVillesActives.filter(function(x) {
              return x.value.toLowerCase() == villeCorrespondance.toLowerCase();
            });
            // aucune correspondance directe (lowercase)
            if (!hits.length) {
              // tentative avec levenshtein
              var hitsLev = listeDesVillesActives
                .filter(function(x) {
                  x.lev = gaJsUtils.levenshtein(x.value, villeCorrespondance);
                  return x.lev > 0.6;
                })
                .sort(function(a, b) {
                  return a.lev > b.lev ? -1 : b.lev > a.lev ? 1 : 0;
                });

              // rien > 0.6 avec levenshtein
              if (!hitsLev.length) {
                require('toastr').error(
                  'Aucune correspondance avec une commune gérée par le ' +
                    spancOrSpac +
                    " n'a pu être établie avec la commune <b> " +
                    villeCorrespondance +
                    "</b>.<br/><br/><b>L'adresse du dossier n'a pas été mise à jour</b>",
                  'Attention',
                  {
                    closeButton: true,
                    timeOut: '0',
                    extendedTimeOut: '0',
                  }
                );
                villeCorrespondance = null;
              } else {
                require('toastr').warning(
                  'Aucune correspondance directe avec une commune gérée par le ' +
                    spancOrSpac +
                    " n'a pu être établie avec la commune <b> " +
                    villeCorrespondance +
                    '.</b><br/><br/>' +
                    'Cependant la commune <b>' +
                    hitsLev[0].value +
                    '</b> semble correspondre et a été sélectionnée.',
                  'Information',
                  {
                    closeButton: true,
                    timeOut: '0',
                    extendedTimeOut: '0',
                  }
                );
                villeCorrespondance = hitsLev[0].value;
              }
            } else {
              villeCorrespondance = hits[0].value;
            }
          }
          if (villeCorrespondance)
            scope.dossier.properties.adresse_ville = villeCorrespondance;
          /**
           * MAJ des cordonéees de dossier
           */
          if (
            scope.apptype === 'bac' &&
            scope.posDossierData.position &&
            scope.posDossierData.position.value &&
            scope.posDossierData.position.value[0] &&
            scope.posDossierData.position.value[1]
          ) {
            scope.dossier.properties.coordinates_x =
              scope.posDossierData.position.value[0];
            scope.dossier.properties.coordinates_y =
              scope.posDossierData.position.value[1];
          }
        };

        /**
         * Update position dossier
         */
        scope.updatePositionDossier = function() {
          var updateDossier = [];

          if (scope.posDossierData.adresse.checked) {
            // maj infos dossier
            appliquerAdresseDossier();
          }

          if (scope.posDossierData.position.checked) {
            // maj adresse
            updateDossier.push(preAppliquerPositionDossier());
          }

          if (scope.posDossierData.parcelle.checked) {
            $timeout(function() {
              $rootScope.$broadcast('addParcelleToDossier', {
                element: {
                  type: 'habitation',
                  parcelle: scope.posDossierData.parcelle.value,
                  idDossier: scope.dossier.id,
                },
                savedOnSaveCurrentReport: true,
              });
            });
          }

          if (updateDossier.length) {
            $q.when(updateDossier.length ? $q.all(updateDossier) : 1).then(
              function() {
                $rootScope.$broadcast('saveCurrentReport', {});
                scope.posDossierData.set = true;
              },
              function(e) {
                console.log('erreur update dossier', e);
              }
            );
          }

          scope.dessinEnCours = false;
          map.removeInteraction(draw);
        };

        var showTheDossierPosition = function() {
          var dossierCenter = getDossierCenter();
          mapView.setCenter(dossierCenter);
          mapView.setZoom(18);
          scope.placeMarkerAtPosition(dossierCenter);
          return dossierCenter;
        };

        scope.$on('positionSetFromDossier', function(value, data) {
          scope.dossier.geometry = data.geometry;
          showTheDossierPosition();
        });

        // --------- init pos dossier --------------
        // si position du dossier connu
        if (
          angular.isDefined(scope.dossier.geometry) &&
          scope.dossier.geometry != null
        ) {
          var dossierCenter = showTheDossierPosition();
          if (parcellesFti != null && parcellesFti.geographic) {
            getParcellesAtPosition(dossierCenter).then(function(res) {
              if (res.data.features.length)
                selectParcelle(res.data.features[0]);
            });
          }
        } else {
          var defaultBbox = gaJsUtils.checkNestedProperty(
            'mapConfiguration.bbox',
            CurrentAppFactory.appCfg.main
          );
          if (defaultBbox !== false) {
            console.log(defaultBbox);
            mapView.fit(defaultBbox, map.getSize());
          }
        }

        // hack pour afficher la carte
        // KIS-1801 la carte ne s'affichait que lors de la première ouverture d'un dossier.
        $timeout(() => {
            map.updateSize();
            map.render();
            map.renderSync();
        }, 400);
        $timeout(() => {
            map.updateSize();
            map.render();
            map.renderSync();
        }, 2000);

        scope.map = map;
      },
    };
  };

  ancBacPositionDossier.$inject = [
    'AncAppFactory',
    'BacAppFactory',
    'gaJsUtils',
    '$timeout',
    '$http',
    'GoogleMapsFactory',
    'gaDomUtils',
    'FeatureTypeFactory',
    'QueryFactory',
    'ogcFactory',
    '$q',
    '$rootScope',
    'ParametersFactory',
  ];
  return ancBacPositionDossier;
});
