'use strict';
define(function() {
  function asArray(obj) {
    return Array.isArray(obj) ? obj : [obj];
  }

  var ancBacMapConfiguration = function(
    BacAppFactory,
    AncAppFactory,
    FeatureTypeFactory,
    mbtilesService,
    $filter,
    gcStyleFactory,
    gaDomUtils,
    SelectManager,
    $interval,
    $rootScope,
    gcInteractions,
    SridFactory,
    processFactory,
    sldUtils,
    $location,
    ngDialog,
    gaUrlUtils,
    ngTableParams,
    gclayers,
    $timeout,
    ParametersFactory,
    ApplicationFactory,
    gaJsUtils,
    extendedNgDialog,
    StyleFactory
  ) {
    var x2js = sldUtils.x2js;
    var getProp = gaJsUtils.checkNestedProperty;

    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_map_configuration.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;

        scope.availableMap = [];
        scope.mapAppConfig = {};
        scope.featCana = {};
        ApplicationFactory.get().then(function(res) {
          if (angular.isUndefined(scope.mapAppConfig)) scope.mapAppConfig = {};
          if (res.data != '') {
            res.data.forEach(function(app, i) {
              if (app.type === 'MapApp') {
                scope.availableMap.push(app);
              }

              if (
                angular.isDefined(
                  CurrentAppFactory.appCfg.main.properties.selected_map_app
                )
              ) {
                if (
                  app.uid ===
                  CurrentAppFactory.appCfg.main.properties.selected_map_app.uid
                )
                  scope.mapAppConfig.app = i;
              }
            });
          }

          scope.bkpMapAppConfig = angular.copy(scope.mapAppConfig);
        });

        if ($rootScope.xgos.isroot == true) {
          scope.isroot = $rootScope.xgos.isroot;
        }

        /**
         *  Load Carte Cfg
         */
        var loadMapConfig = function() {
          scope.featuresConfigLength = 0;
          scope.bbox = angular.copy(
            CurrentAppFactory.appCfg.main.mapConfiguration.bbox
          );
          scope.featCana = angular.copy(
            CurrentAppFactory.appCfg.main.mapConfiguration.featCana
          );
          scope.canaVectorielle = angular.copy(
            CurrentAppFactory.appCfg.main.mapConfiguration.canaVectorielle
          );

          scope.bkpBbox = angular.copy(
            CurrentAppFactory.appCfg.main.mapConfiguration.bbox
          );
          scope.bkpFeatCana = angular.copy(
            CurrentAppFactory.appCfg.main.mapConfiguration.featCana
          );
          scope.bkpcanaVectorielle = angular.copy(
            CurrentAppFactory.appCfg.main.mapConfiguration.canaVectorielle
          );

          if (
            angular.isDefined(
              CurrentAppFactory.appCfg.main.mapConfiguration.canaVectorielle
            )
          )
            scope.ftiCana = FeatureTypeFactory.getFeatureByUid(
              'kis_anc_efx_canalisations'
            );
          // .then(function (res) {
          //         if(res.data)
          //             scope.ftiCana = res.data
          //     });

          var tmpFeaturesConfig = angular.copy(
            CurrentAppFactory.appCfg.main.mapConfiguration.featuresConfig
          );
          if (!tmpFeaturesConfig) tmpFeaturesConfig = {};

          // nettoyage de la config si le composant n'existe plus
          var featureUids = FeatureTypeFactory.resources.featuretypes.map(
            function(r) {
              return r.uid;
            }
          );
          for (var uid in tmpFeaturesConfig) {
            // composant n'existe plus
            if (!~featureUids.indexOf(uid)) {
              console.log('composant ' + uid + " n'existe plus");
              delete tmpFeaturesConfig[uid];
            }
            if (
              angular.isDefined(tmpFeaturesConfig[uid]) &&
              tmpFeaturesConfig[uid].split('-', 2).length != 2
            ) {
              if (tmpFeaturesConfig[uid] === '1') {
                tmpFeaturesConfig[uid] = '1-1';
              } else if (tmpFeaturesConfig[uid] === '0')
                tmpFeaturesConfig[uid] = '0-0';
            }
          }
          scope.featuresConfig = tmpFeaturesConfig;
          scope.bkpFeaturesConfig = angular.copy(tmpFeaturesConfig);

          scope.all_features = [];
          scope.all_linear_feat = [];
          // develop purpose
          //scope.all_linear_feat =  angular.copy(FeatureTypeFactory.resources.featuretypes);
          FeatureTypeFactory.resources.featuretypes.forEach(function(f) {
            if (f.published == true && f.geographic == true) {
              // pas ce qui commence par kis_anc_ef
              if (!~f.name.indexOf('kis_anc_ef')) {
                scope.all_features.push(f);
                // Ce qui représente un linéaire
                if (
                  angular.isDefined(f.typeInfo) &&
                  ~f.typeInfo.indexOf('LINE')
                ) {
                  scope.all_linear_feat.push(f);
                }
              }
            }
          });

          // set sort
          var keys = Object.keys(scope.featuresConfig);
          scope.featuresConfigLength = keys.length;

          for (var j = 0; j < keys.length; j++) {
            for (var i = 0; i < scope.all_features.length; i++) {
              if (keys[j] == scope.all_features[i].uid) {
                var currentFeature = scope.all_features[i];
                scope.all_features.splice(i, 1);
                scope.all_features.splice(j, 0, currentFeature);
              }
            }
          }
        };

        loadMapConfig();

        var testIfModified = function(tmpData, tmpNewData) {
          var cleanData = gaJsUtils.removeEmpty(tmpData, true);
          var cleanNewData = gaJsUtils.removeEmpty(tmpNewData, true);

          if (JSON.stringify(cleanData) != JSON.stringify(cleanNewData)) {
            return true;
          } else {
            return false;
          }
        };

        scope.$on('checkIfDirtyMapCfg', function() {
          scope.enregistrerMapConfig(null, true);
        });

        /**
         * enregistrerMapConfig
         * @param bbox
         */
        scope.enregistrerMapConfig = function(bbox, checkDirty) {
          var setConfirm = false;
          var ans;
          var setOrder = [];
          scope.all_features.forEach(function(key) {
            if (
              angular.isDefined(scope.featuresConfig[key.uid]) &&
              scope.featuresConfig[key.uid].startsWith('1')
            ) {
              var name = key.uid;
              var value = scope.featuresConfig[key.uid];
              var obj = {};
              obj[name] = value;
              setOrder.push(obj);
            }
          });

          scope.featuresConfig = {};
          for (var uid in setOrder)
            scope.featuresConfig[Object.keys(setOrder[uid])] =
              setOrder[uid][Object.keys(setOrder[uid])];

          // compare object to trigger automated saving
          if (angular.isDefined(checkDirty) && checkDirty == true) {
            var oldFeatures =
              JSON.stringify(
                CurrentAppFactory.appCfg.main.mapConfiguration.featuresConfig
              ) == '{}'
                ? ''
                : JSON.stringify(
                    CurrentAppFactory.appCfg.main.mapConfiguration
                      .featuresConfig
                  );

            var currentFeatures =
              JSON.stringify(scope.featuresConfig) == '{}'
                ? ''
                : JSON.stringify(scope.featuresConfig);

            if (
              scope.apptype == 'anc' &&
              (testIfModified(scope.configCanas, scope.bkpConfigCana) ||
                testIfModified(scope.choixGeocoder, scope.bkpChoixGeocoder) ||
                testIfModified(scope.infosGeocoder, scope.bkpInfosGeocoder) ||
                testIfModified(scope.mapAppConfig, scope.bkpMapAppConfig) ||
                testIfModified(scope.bbox, scope.bkpBbox) ||
                testIfModified(scope.featCana, scope.bkpFeatCana) ||
                testIfModified(
                  scope.canaVectorielle,
                  scope.bkpcanaVectorielle
                ) ||
                testIfModified(scope.featuresConfig, scope.bkpFeaturesConfig))
            ) {
              setConfirm = true;
            }

            if (setConfirm)
              ans = confirm(
                'Des données ne sont pas sauvegardées. Voulez-vous les enregistrer ?'
              );
          }

          //normal click or confirm == true, save configuration
          if (
            (angular.isUndefined(checkDirty) && angular.isUndefined(ans)) ||
            (checkDirty && ans)
          ) {
            CurrentAppFactory.appCfg.main.mapConfiguration.featCana =
              scope.featCana;
            CurrentAppFactory.appCfg.main.mapConfiguration.featuresConfig =
              scope.featuresConfig;
            CurrentAppFactory.appCfg.main.mapConfiguration.bbox = scope.bbox;
            CurrentAppFactory.appCfg.main.mapConfiguration.canaVectorielle =
              scope.canaVectorielle;
            if (scope.apptype == 'anc') {
              AncAppFactory.appCfg.main.properties.configCanas =
                scope.configCanas;
              scope.bkpConfigCana = angular.copy(
                AncAppFactory.appCfg.main.properties.configCanas
              );
            }

            if (
              angular.isDefined(scope.mapAppConfig) &&
              angular.isDefined(scope.mapAppConfig.app) &&
              angular.isDefined(scope.availableMap) &&
              scope.availableMap.length
            ) {
              CurrentAppFactory.appCfg.main.properties.selected_map_app =
                scope.availableMap[scope.mapAppConfig.app];
              delete CurrentAppFactory.appCfg.main.properties.selected_map_app
                .roles;
            }
            CurrentAppFactory.appCfg.main.properties.geocoder =
              scope.infosGeocoder;

            CurrentAppFactory.updateAppCfg().then(() => {
              if (scope.apptype == 'anc') { 
                CurrentAppFactory.updateCanalGeoServerStyle(
                  scope.configCanas.liste
                );
              }
              loadMapConfig();
            });
          } else if (setConfirm && typeof ans !== 'undefined' && !ans) {
            loadMapConfig();
          }
        };

        // scope.activerRepresentationVectorielleCana = function () {
        //     gaDomUtils.showGlobalLoader();
        //     var setTypeCana = []
        //     if(angular.isDefined(scope.configCanas) && scope.configCanas.liste.length > 0) {
        //         scope.configCanas.liste.forEach(function (cana){
        //             if(cana.lib != "") {
        //                 if(angular.isUndefined(cana.color))
        //                     cana.color = "#000000";
        //                 var x = {}; x[cana.lib] = cana.color
        //                 setTypeCana.push(x);
        //             }
        //         });

        //         AncAppFactory.setrepresentationcanavectorielle(setTypeCana).then(function (res) {
        //             if(res.data) {
        //                 scope.canaVectorielle = true;
        //                 FeatureTypeFactory.get().then( function (res) {
        //                     if(res.data) {
        //                         var majFeatureTypeCana = res.data;
        //                         majFeatureTypeCana.forEach(function (feat) {
        //                             if(feat.uid == "kis_anc_efx_canalisations") {
        //                                 scope.ftiCana = feat;
        //                             }
        //                         });
        //                          if(angular.isDefined(scope.ftiCana) && scope.ftiCana != null) {
        //                         // $timeout(function  () {
        //                             scope.loadSLD();
        //                             gaDomUtils.hideGlobalLoader();
        //                             scope.enregistrerMapConfig()
        //                         // });
        //                         }
        //                     }
        //                 });

        //                 CurrentAppFactory.appCfg.main.mapConfiguration.canaVectorielle = true;
        //                 require('toastr').success("Représentation vectorielle des canalisations activées.", '', {
        //                     positionClass: 'toast-bottom-left'
        //                 });
        //             } else {
        //                 require('toastr').error("Erreur à l'activation de la représentation vectorielle des canalisations.", '', {
        //                     positionClass: 'toast-bottom-left'
        //                 });
        //             }
        //         });
        //     } else {
        //         require('toastr').error("Il n'existe pas de représentation des canalisations.", '', {
        //             positionClass: 'toast-bottom-left'
        //         });
        //     }
        // };

        /**
         * Return a simple object for the uniqvalues list
         * @param color
         * @returns {{}}
         */
        var getSimpleObjectForUniqValues = function(color) {
          var object = {};
          object = x2js.xml_str2json(
            '<LineSymbolizer>' +
              '<Stroke>' +
              '<CssParameter name="stroke">#' +
              color +
              '</CssParameter>' +
              '</Stroke>' +
              '</LineSymbolizer>'
          );

          return object;
        };

        /**
         * Reset the JSON
         */
        var resetJsonSld = function() {
          // reset JSON SLD
          scope.jsonSLD = {
            StyledLayerDescriptor: {
              NamedLayer: {
                UserStyle: {
                  FeatureTypeStyle: {
                    Rule: [],
                  },
                },
              },
            },
          };
          scope.rules = [];
          scope.textSymbolizer = [];
          //setLabelizedAttributeTabs();
          prepareSLD();
        };

        /**
         * preparethesld to be translated into xml
         */
        var prepareSLD = function() {
          if (!scope.jsonSLD || !scope.rules) {
            return;
          }

          // set the rules (force as an array)
          var datacopy = angular.copy(scope.rules);

          // add the text symbolizer if any
          if (Array.isArray(scope.textSymbolizer)) {
            datacopy = datacopy.concat(scope.textSymbolizer);
          }

          scope.jsonSLD.StyledLayerDescriptor.NamedLayer.UserStyle.FeatureTypeStyle.Rule = datacopy;

          // extraData

          if (scope.mode.chosen === 'category') {
            if (Object.keys(scope.xgosExtraData).length > 0) {
              scope.jsonSLD.StyledLayerDescriptor.NamedLayer.xgos =
                scope.xgosExtraData;
            }
          }

          sldUtils.cleanSLD(scope.jsonSLD);
          console.log(scope.jsonSLD);
          scope.sld = x2js.json2xml_str(scope.jsonSLD);
        };

        var extractSLDdata = function(data, fromEditor) {
          // Check SLD validity
          scope.jsonSLD = x2js.xml_str2json(data);
          var layer = getProp(
            'StyledLayerDescriptor.NamedLayer',
            scope.jsonSLD
          );
          var fts = getProp('UserStyle.FeatureTypeStyle', layer);
          console.log(fts);

          if (typeof fts !== 'object') {
            alert(
              $filter('translate')('model.styles.editor.malformed') +
                (fromEditor
                  ? '\n' +
                    $filter('translate')('model.styles.editor.cancel_edit')
                  : '')
            );
            resetJsonSld();
            return false; // Extraction failed
          }
          scope.sld = data;

          // Extract Rules and TextSymbolizers
          scope.textSymbolizer = [];
          scope.rules = asArray(fts.Rule).filter(function(rule) {
            if (rule.TextSymbolizer) {
              scope.textSymbolizer.push(rule);
              return false; // Remove it
            }
            if (rule.Title == 'Représentation par défaut') return false;
            // Other items must be arrays
            Object.keys(rule).forEach(function(i) {
              rule[i] = asArray(rule[i]);
            });
            return true;
          });

          var compareObject = getSimpleObjectForUniqValues('');

          return true; // Extraction successful
        };

        scope.loadSLD = function() {
          if (scope.ftiCana != null) {
            StyleFactory.get(scope.ftiCana.defaultStyle).then(function(res) {
              scope.isNewStyle = false;
              extractSLDdata(res.data);
            });
          }
        };
        if (scope.canaVectorielle) scope.loadSLD();

        scope.openSldEditor = function() {
          scope.currlayer = { fti: scope.ftiCana };
          if (!scope.currlayer.style && scope.currlayer.fti.defaultStyle)
            scope.currlayer.style = scope.currlayer.fti.defaultStyle;
          scope.simpleInterface = true;

          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/popoverSldEditor.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: true,
            title: $filter('translate')('model.styles.editor.title'),
          });
        };

        var extractCanaList = function(list, from_sld, to_extract) {
          var titleArray = [];
          if (list.length) {
            list.forEach(function(cana) {
              if (
                from_sld &&
                cana.Title[0] != 'Représentation par défaut' &&
                to_extract == 'lib'
              ) {
                titleArray.push(cana.Title[0]);
              } else if (
                from_sld &&
                cana.Title[0] != 'Représentation par défaut' &&
                to_extract == 'color'
              ) {
                try {
                  if (angular.isDefined(cana.LineSymbolizer)) {
                    titleArray.push(
                      cana.LineSymbolizer[0].Stroke.CssParameter[0].__text
                    );
                  }
                } catch (e) {}
              } else if (from_sld == false) {
                titleArray.push(cana[to_extract]);
              }
            });

            return titleArray;
          }
        };

        var compareSimpleArrayAndGetDiff = function(
          iter,
          compare,
          index,
          color
        ) {
          var obj = [];
          iter.forEach(function(str, i) {
            if (!color) {
              if (str != 'undefined' && compare.indexOf(str) == -1) {
                obj.push(index == true ? i : str);
              }
            } else {
              if (str != 'undefined' && str !== compare[i]) {
                obj.push(index == true ? i : str);
              }
            }
          });

          return obj;
        };

        scope.$on('updateListeStyleCana', function(event, data) {
          //-1 for default representation
          var listArray = extractCanaList(
            scope.configCanas.liste,
            false,
            'lib'
          );
          var listArraySld = extractCanaList(data, true, 'lib');
          var toRemove = compareSimpleArrayAndGetDiff(listArray, listArraySld);
          //var commonKeys = compareSimpleArrayAndGetDiff(listArray, listArraySld);
          var toAdd = compareSimpleArrayAndGetDiff(listArraySld, listArray);

          var setNewConfigCana = [];

          scope.configCanas.liste.forEach(function(cana, i) {
            if (toRemove.indexOf(cana.lib) == -1) {
              setNewConfigCana.push(cana);
            }
          });

          var listArrayC = extractCanaList(
            scope.configCanas.liste,
            false,
            'color'
          );
          var listArraySldC = extractCanaList(data, true, 'color');
          var toModify = compareSimpleArrayAndGetDiff(
            listArraySldC,
            listArrayC,
            true,
            true
          );

          scope.configCanas.liste.forEach(function(cana, i) {
            if (toModify.indexOf(i) == -1) {
              cana.color = listArraySldC[i];
            }
          });

          data.forEach(function(sld) {
            if (
              toAdd.indexOf(sld.Title[0]) > -1 &&
              sld.Title[0] != 'Représentation par défaut'
            ) {
              var color = '#000000';
              if (
                angular.isDefined(sld.LineSymbolizer[0].Stroke.CssParameter[0])
              ) {
                if (
                  angular.isDefined(
                    sld.LineSymbolizer[0].Stroke.CssParameter[0].__text
                  )
                ) {
                  color = sld.LineSymbolizer[0].Stroke.CssParameter[0].__text;
                }
              }

              var cana = { lib: sld.Title[0], color: color };
              setNewConfigCana.push(cana);
            }
          });

          if (toAdd.length >= 1 || toRemove.length >= 1) {
            scope.configCanas.liste = setNewConfigCana;
            scope.loadSLD();
          }
          if (toModify.length >= 1) scope.loadSLD();
          require('toastr').success('Style(s) enregistré(s).', '', {
            positionClass: 'toast-bottom-left',
          });
        });

        scope.moveItem = function(index, direction) {
          if (direction == 'up')
            swapItems(scope.all_features, index, index - 1);
          if (direction == 'down')
            swapItems(scope.all_features, index, index + 1);
        };
        var swapItems = function(arr, index1, index2) {
          arr[index1] = arr.splice(index2, 1, arr[index1])[0];
          return arr;
        };

        scope.toggleVisibility = function(index, f) {
          var uid = scope.all_features[index].uid;
          if (
            scope.featuresConfig[uid] === null ||
            angular.isUndefined(scope.featuresConfig[uid])
          )
            scope.featuresConfig[uid] = '0';

          if (
            scope.featuresConfig[uid] ||
            scope.featuresConfig[uid].split('-', 2)[1] == ''
          )
            scope.featuresConfig[uid] += '-1';

          scope.featuresConfig[uid].split('-', 2)[1] === '0'
            ? (scope.featuresConfig[uid] =
                scope.featuresConfig[uid].split('-', 2)[0] + '-1')
            : (scope.featuresConfig[uid] =
                scope.featuresConfig[uid].split('-', 2)[0] + '-0');
          console.log(scope.featuresConfig);
        };

        scope.afficheCarte = {};
        scope.featuresConfigLength = 0;
        scope.setValueAffichage = function(uid) {
          scope.featuresConfigLength = 0;
          var affiche = false;
          if (angular.isDefined(scope.featuresConfig[uid])) {
            if (scope.featuresConfig[uid].split('-', 2).length == 1) {
              scope.featuresConfig[uid] === '0'
                ? (scope.featuresConfig[uid] = '1-0')
                : (scope.featuresConfig[uid] = '0-0');
            } else
              scope.featuresConfig[uid].split('-', 2)[0] === '0'
                ? (scope.featuresConfig[uid] = '1-1')
                : (scope.featuresConfig[uid] = '0-0');
          } else scope.featuresConfig[uid] = '1-1';

          if (scope.featuresConfig[uid].startsWith('1'))
            scope.afficheCarte[uid] = true;

          Object.keys(scope.afficheCarte).forEach(function(x) {
            if (scope.afficheCarte[x] == true) scope.featuresConfigLength += 1;
          });
        };
        Object.keys(scope.featuresConfig).forEach(function(couche) {
          if (scope.featuresConfig[couche].startsWith('1'))
            scope.afficheCarte[couche] = true;
          scope.featuresConfigLength += 1;
        });

        /**
         * toggle composant liste des composants affichés sur la carte
         * refeshFeaturesConfigTable
         * @param value
         * @param index
         */
        scope.refeshFeaturesConfigTable = function(value, index) {
          // scope.afficheCarte[uid] = false;
          var currentFeature = scope.all_features[index];
          var new_index = 0;
          Object.keys(scope.featuresConfig).forEach(function(key) {
            if (scope.featuresConfig[key] == false) {
              delete scope.featuresConfig[key];
            }
            // else { new_index++; }
          });

          // set sort
          // if (value) {
          //     scope.all_features.splice(index, 1);
          //     scope.all_features.splice(new_index - 1, 0, currentFeature);
          // } else {
          //     scope.all_features.splice(index, 1);
          //     scope.all_features.splice(new_index, 0, currentFeature);
          // }
        };

        /////// AJOUT MBTILE
        ///

        var Level_zero = 156543.03390625;
        var zoom_levels = [];
        for (var i = 0; i < 40; i++) {
          zoom_levels.push(156543.03390625 / Math.pow(2, i));
        }

        scope.tabs = [
          {
            title: $filter('translate')('importExportMBTILES.export'),
          },
          {
            title: $filter('translate')('importExportMBTILES.process'),
          },
        ];

        scope.widgetName =
          'export-mbtiles-' + Math.floor(Math.random() * 10000000);
        scope.mbtiles = {
          ftis: [],
          applyFilter: false,
          bbox: {
            minx: undefined,
            miny: undefined,
            maxx: undefined,
            maxy: undefined,
          },
          fromCurrentSelection: false,
          ftiuids: {},
          activeTab: 0,
          version: '1.3.0',
          format: 'image/png',
          srid: 'EPSG:3857',
          minzoom: 0,
          maxzoom: 15,
          openstreetmap: false,
          transparent: $filter('translate')('common.yes'),
          runonbackground: true,
          zoominit: 15,
          createboth: false,
        };

        scope.transparency = [
          $filter('translate')('common.yes'),
          $filter('translate')('common.no'),
        ];

        scope.srids = SridFactory.sridsList;

        function setExtent(extent) {
          scope.mbtiles.bbox = {
            minx: Math.round(extent[0] * 1000000) / 1000000,
            miny: Math.round(extent[1] * 1000000) / 1000000,
            maxx: Math.round(extent[2] * 1000000) / 1000000,
            maxy: Math.round(extent[3] * 1000000) / 1000000,
          };
        }

        if (
          $rootScope.xgos &&
          $rootScope.xgos.mouseposition &&
          $rootScope.xgos.mouseposition.srid &&
          $rootScope.xgos.mouseposition.srid.name &&
          $rootScope.xgos.mouseposition.srid.name.indexOf('EPSG:') !== -1
        ) {
          scope.mbtiles.srid = $rootScope.xgos.mouseposition.srid.name;
          if ($rootScope.xgos.mouseposition.srid.description) {
            proj4.defs(
              $rootScope.xgos.mouseposition.srid.name,
              $rootScope.xgos.mouseposition.srid.description
            );
            scope.sriddescription =
              $rootScope.xgos.mouseposition.srid.description;
          }
        }

        $timeout(function() {
          scope.all_features.map(function(x) {
            if (x && x.geographic && x.name)
              scope.mbtiles.ftis.push({
                name: x.name,
                alias: x.alias,
                style: x.defaultStyle,
                uid: x.uid,
                opacity: x.opacity,
                cql_filter: x.cql_filter,
                type: 'g2c',
              });
          });
          /*gclayers.getOperationalLayerESRI().map(function(x){
                     if ( x.fti && x.fti.geographic && x.fti.name )
                     scope.mbtiles.ftis.push({ name : x.fti.name ,
                     alias : x.fti.alias,
                     style : x.fti.defaultStyle,
                     uid : x.fti.uid,
                     opacity : x.opacity,
                     cql_filter : x.cql_filter,
                     type : "esri",
                     wfs : x.fti.wfs,
                     wms : x.fti.wms
                     });
                     });*/
        }, 2000);

        scope.getFeatureFromCatalogue = function() {
          scope.mbtiles.ftis = [];
          gclayers.getOperationalLayerg2c().map(function(x) {
            if (x.fti && x.fti.geographic && x.fti.name)
              scope.mbtiles.ftis.push({
                name: x.fti.name,
                alias: x.fti.alias,
                style: x.fti.defaultStyle,
                uid: x.fti.uid,
                opacity: x.opacity,
                cql_filter: x.cql_filter,
                selected: x.visible,
                type: 'g2c',
              });
          });
          gclayers.getOperationalLayerESRI().map(function(x) {
            if (x.fti && x.fti.geographic && x.fti.name)
              scope.mbtiles.ftis.push({
                name: x.fti.name,
                alias: x.fti.alias,
                style: x.fti.defaultStyle,
                uid: x.fti.uid,
                opacity: x.opacity,
                cql_filter: x.cql_filter,
                selected: x.visible,
                type: 'esri',
                wfs: x.fti.wfs,
                wms: x.fti.wms,
              });
          });
        };

        scope.initSelection = function() {
          scope.mbtiles.ftis.map(function(x) {
            x.selected = false;
          });
        };

        scope.getZoomFromMap = function(type) {
          switch (type) {
            case 'init':
              scope.mbtiles.zoominit = scope.map.getView().getZoom();
              break;
            default:
              scope.mbtiles.maxzoom = scope.map.getView().getZoom();
              break;
          }
        };

        scope.changedSrid = function(srid) {
          if (srid.indexOf('EPSG:') !== -1 && !ol.proj.get(srid))
            SridFactory.getbycode(srid).then(function(res) {
              scope.sriddescription = res.data;
              proj4.defs(srid, res.data);
            });
        };

        scope.getMapExtent = function() {
          var extent = scope.bbox; //scope.map.getView().calculateExtent(scope.map.getSize());
          //var extentproj = ol.proj.transformExtent(extent , "3857" , scope.mbtiles.srid );
          setExtent(extent);
          scope.mbtiles.fromCurrentSelection = false;
        };

        var dragBoxStyle = gcStyleFactory.getStyle('selectrectangle');
        scope.dragBox = new ol.interaction.DragBox({
          type: 'Polygon',
          style: dragBoxStyle,
        });
        scope.dragBox.set('gctype', 'kis');
        scope.dragBox.set('interaction', 'Select');
        scope.dragBox.set('widget', 'mbtiles');

        scope.dragBox.on('boxend', function() {
          var extent = scope.dragBox.getGeometry().getExtent();
          var extentproj = ol.proj.transformExtent(
            extent,
            scope.map
              .getView()
              .getProjection()
              .getCode(),
            scope.mbtiles.srid
          );
          setExtent(extentproj);
          scope.dragBox.setActive(false);
          scope.map.removeInteraction(scope.dragBox);
          scope.addedddragbox = false;
          scope.mbtiles.fromCurrentSelection = false;
        });

        scope.dragBox.setActive(false);
        scope.addedddragbox = false;
        scope.selectArea = function() {
          if (!scope.addedddragbox) {
            scope.dragBox.setActive(true);
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            scope.map.addInteraction(scope.dragBox);
            scope.addedddragbox = true;
          } else {
            scope.dragBox.setActive(false);
            scope.map.removeInteraction(scope.dragBox);
            scope.addedddragbox = false;
          }
        };

        scope.selectionCourante = function() {
          try {
            gaDomUtils.showGlobalLoader();
            scope.mbtiles.fromCurrentSelection = true;
            var featureCollection = SelectManager.getfeatures();
            var ftisnames = scope.mbtiles.ftis.map(function(x) {
              x.selected = false;
              return x.name;
            });
            featureCollection.features.map(function(x) {
              var ind = ftisnames.indexOf(x.id.split('.')[0]);
              if (ind !== -1) scope.mbtiles.ftis[ind].selected = true;
            });
            var extent = SelectManager.getExtent();
            var extentproj = ol.proj.transformExtent(
              extent,
              scope.map
                .getView()
                .getProjection()
                .getCode(),
              scope.mbtiles.srid
            );
            setExtent(extentproj);
            scope.dragBox.setActive(false);
            scope.addedddragbox = false;
            scope.mbtiles.applyFilter = true;
            gaDomUtils.hideGlobalLoader();
          } catch (e) {
            gaDomUtils.hideGlobalLoader();
            scope.mbtiles.fromCurrentSelection = false;
            require('toastr').error(
              $filter('translate')('itv.correspondance.nofeatureselected')
            );
          }
        };

        scope.selectionPersonalise = function() {
          scope.mbtiles.fromCurrentSelection = false;
        };
        var TYPE = 'mbtiles';
        function getResponseFile(d) {
          switch (d.etat) {
            case 'FINISHED':
              scope.refreshList();
              scope.getFile(d);
              break;
            case 'FAILED':
              require('toastr').error(d.reason);
              break;
          }
        }

        var getMbtilesParametersg2c = function(mbtiles) {
          var LAYERS = gclayers
            .getOperationalLayerg2c()
            .map(function(x) {
              if (x.fti && x.fti.name) return x.fti.name;
            })
            .filter(function(x) {
              if (x) return x;
            });

          var mbtilesnames = [];
          var layersuids = [];
          var mbtileslayers = mbtiles.ftis
            .map(function(x) {
              if (x.selected && x.type === 'g2c') {
                mbtilesnames.push(x.name);
                layersuids.push(x.uid);
                return x;
              }
            })
            .filter(function(x) {
              if (x) return x;
            });

          var layers = [],
            styles = [],
            opacity = [],
            cql_filter = [],
            gcqlfilter = '';
          var j = angular.isDefined(mbtiles.minzoom) ? mbtiles.minzoom : 0;
          var maxzoom = angular.isDefined(mbtiles.maxzoom)
            ? mbtiles.maxzoom
            : 15;
          while (j <= maxzoom) {
            var resolution = zoom_levels[j];
            var ll = [],
              ss = [],
              oo = [],
              cc = [],
              gg = '';
            for (var i = 0; i < mbtilesnames.length; i++) {
              var ind = LAYERS.indexOf(mbtilesnames[i]);
              if (ind !== -1) {
                var gccatalogue = gclayers.getOperationalLayerg2c()[ind];
                var minResolution = gccatalogue.getMinResolution();
                var maxResolution = gccatalogue.getMaxResolution();
                if (
                  angular.isUndefined(resolution) ||
                  (resolution <= maxResolution && resolution >= minResolution)
                ) {
                  var x = mbtileslayers[i];
                  ll.push(x.name);

                  if (x.style) ss.push(x.style);
                  else ss.push('');

                  if (x.opacity) oo.push(x.opacity);
                  else oo.push('1');

                  if (x.cql_filter) {
                    cc.push(x.cql_filter);
                  } else {
                    cc.push('1=1');
                  }
                }
              }
            }
            layers.push(ll.join(','));
            styles.push(ss.join(','));
            opacity.push(oo.join(','));
            cql_filter.push(cc.join(';'));
            j++;
          }

          var sendata = {
            layers: layers,
            styles: styles,
            opacity: opacity,
            cql_filter: cql_filter,
            gcqlfilter: gcqlfilter,
            layersuids: layersuids.join(','),
            type: 'g2c',
          };
          return sendata;
        };

        var getMbtilesParametersEsri = function(mbtiles) {
          var esriLayers = [];
          var urlsesri = [];
          var wfssesri = [];
          var LAYERS = gclayers
            .getOperationalLayerESRI()
            .map(function(x) {
              if (x.fti && x.fti.name) {
                if (urlsesri.indexOf(x.fti.wms) === -1) {
                  urlsesri.push(x.fti.wms);
                  wfssesri.push(x.fti.wfs);
                }
                return x.fti.name;
              }
            })
            .filter(function(x) {
              if (x) return x;
            });

          for (var index = 0; index < urlsesri.length; index++) {
            var mbtilesnames = [];
            var layersuids = [];
            var mbtileslayers = mbtiles.ftis
              .map(function(x) {
                if (
                  x.selected &&
                  x.type === 'esri' &&
                  x.wms === urlsesri[index]
                ) {
                  mbtilesnames.push(x.name);
                  layersuids.push(x.uid);
                  return x;
                }
              })
              .filter(function(x) {
                if (x) return x;
              });

            var layers = [],
              styles = [],
              opacity = [],
              cql_filter = [],
              gcqlfilter = '';
            var j = angular.isDefined(mbtiles.minzoom) ? mbtiles.minzoom : 0;
            var maxzoom = angular.isDefined(mbtiles.maxzoom)
              ? mbtiles.maxzoom
              : 15;
            while (j <= maxzoom) {
              var resolution = zoom_levels[j];
              var ll = [],
                ss = [],
                oo = [],
                cc = [],
                gg = '';
              for (var i = 0; i < mbtilesnames.length; i++) {
                var ind = LAYERS.indexOf(mbtilesnames[i]);
                if (ind !== -1) {
                  var gccatalogue = gclayers.getOperationalLayerESRI()[ind];
                  var minResolution = gccatalogue.getMinResolution();
                  var maxResolution = gccatalogue.getMaxResolution();
                  if (
                    angular.isUndefined(resolution) ||
                    (resolution <= maxResolution && resolution >= minResolution)
                  ) {
                    var x = mbtileslayers[i];
                    ll.push(x.name);

                    if (x.style) ss.push(x.style);
                    else ss.push('');

                    if (x.opacity) oo.push(x.opacity);
                    else oo.push('1');

                    if (x.cql_filter) {
                      cc.push(x.cql_filter);
                    } else {
                      cc.push('1=1');
                    }
                  }
                }
              }
              layers.push(ll.join(','));
              styles.push(ss.join(','));
              opacity.push(oo.join(','));
              cql_filter.push(cc.join(';'));
              j++;
            }

            var sendata = {
              layers: layers,
              styles: styles,
              opacity: opacity,
              cql_filter: cql_filter,
              layersuids: layersuids.join(','),
              type: 'esri',
              wms: urlsesri[index],
              wfs: wfssesri[index],
            };
            esriLayers.push(sendata);
          }
          return esriLayers;
        };

        scope.validName = function(name) {
          return /^[A-Za-z0-9-_]+$/.test(name);
        };

        scope.exportMBTILES = function(mbtiles) {
          scope.mbtiles.filename = scope.mbtiles.filename.trim();

          if (
            !(
              scope.mbtiles.bbox.maxx > scope.mbtiles.bbox.minx &&
              scope.mbtiles.bbox.maxy > scope.mbtiles.bbox.miny
            )
          ) {
            require('toastr').error(
              $filter('translate')('importExportMBTILES.messages.badbbox')
            );
            return;
          }

          var ext = [
            mbtiles.bbox.minx,
            mbtiles.bbox.miny,
            mbtiles.bbox.maxx,
            mbtiles.bbox.maxy,
          ];
          var extentproj3857 = ol.proj.transformExtent(
            ext,
            mbtiles.srid,
            'EPSG:3857'
          );
          var extentproBuffer = [
            extentproj3857[0] - 1,
            extentproj3857[1] + 1,
            extentproj3857[2] + 1,
            extentproj3857[3] - 1,
          ];
          var extentproj = ol.proj.transformExtent(
            extentproBuffer,
            'EPSG:3857',
            mbtiles.srid
          );
          var sendata = {
            format: mbtiles.format,
            version: mbtiles.version,
            minzoom: angular.isDefined(mbtiles.minzoom) ? mbtiles.minzoom : 0,
            maxzoom: angular.isDefined(mbtiles.maxzoom) ? mbtiles.maxzoom : 15,
            bbox:
              extentproj[0] +
              ',' +
              extentproj[1] +
              ',' +
              extentproj[2] +
              ',' +
              extentproj[3],
            crs: mbtiles.srid,
            filename: mbtiles.filename,
            transparent:
              mbtiles.transparent === $filter('translate')('common.yes')
                ? true
                : false,
            openstreetmap: mbtiles.openstreetmap,
            zoom: mbtiles.zoominit,
          };

          var sendatag2c = getMbtilesParametersg2c(mbtiles);
          var sendataesri = getMbtilesParametersEsri(mbtiles);
          sendata.g2c = sendatag2c;
          sendata.esri = sendataesri;
          var layersuids = [];
          if (sendatag2c && sendatag2c.layersuids.replace(',', ''))
            layersuids = sendatag2c.layersuids.split(',');
          if (sendataesri) {
            for (var zz = 0; zz < sendataesri.length; zz++) {
              if (
                sendataesri[zz] &&
                sendataesri[zz].layersuids &&
                sendataesri[zz].layersuids.replace(',', '')
              )
                layersuids = layersuids.concat(
                  sendataesri[zz].layersuids.split(',')
                );
            }
          }
          sendata.layersuids = layersuids.join(',');

          if (scope.mbtiles.ftis.length > 0) {
            if (sendata.maxzoom > 18 || sendata.maxzoom > 18)
              require('toastr').info(
                $filter('translate')('importExportMBTILES.messages.time')
              );

            //if ( !scope.mbtiles.createboth )
            var promise = mbtilesService.exportMBTILES(sendata);
            /*else
                         promise = geopackageService.exportGeopackageMbtiles(sendata , TYPE);*/

            if (scope.mbtiles.runonbackground) {
              gaDomUtils.showPreciseLocalLoader('.' + scope.widgetName);
              promise.then(
                function(res) {
                  if (res.data.etat === 'RUNNING') {
                    if (res.data.creation)
                      res.data.creation = $filter('date')(
                        new Date(res.data.creation),
                        'dd MMM yyyy HH:mm'
                      );
                    if (res.data.type.indexOf('/') !== -1) res.data.both = true;
                    else res.data.both = false;
                    scope.currentProcess.push(res.data);
                    scope.tableParamsProcessus.reload();
                    require('toastr').info(
                      $filter('translate')(
                        'importExportMBTILES.runningonbackground'
                      )
                    );
                    gaDomUtils.removeLocalLoader('.' + scope.widgetName);
                  } else {
                    require('toastr').error(res.data.reason);
                    gaDomUtils.removeLocalLoader('.' + scope.widgetName);
                  }
                },
                function(res) {
                  require('toastr').error(res.data.message);
                  gaDomUtils.removeLocalLoader('.' + scope.widgetName);
                }
              );
            } else {
              gaDomUtils.showPreciseLocalLoader('.' + scope.widgetName);
              promise.then(
                function(res) {
                  if (res.data.etat === 'RUNNING') {
                    if (res.data.creation)
                      res.data.creation = $filter('date')(
                        new Date(res.data.creation),
                        'dd MMM yyyy HH:mm'
                      );
                    scope.currentProcess.push(res.data);
                    scope.tableParamsProcessus.reload();
                    var stop = $interval(function() {
                      if (res.data.creation)
                        res.data.creation = new Date(
                          res.data.creation
                        ).getTime();
                      if (res.data.end)
                        res.data.end = new Date(res.data.end).getTime();
                      delete res.data.both;
                      mbtilesService.getProgression(res.data).then(
                        function(res) {
                          if (
                            res.data.etat === 'FINISHED' &&
                            res.data.progress === 100
                          ) {
                            $interval.cancel(stop);
                            getResponseFile(res.data);
                            gaDomUtils.removeLocalLoader(
                              '.' + scope.widgetName
                            );
                          } else if (res.data.etat === 'FAILED') {
                            $interval.cancel(stop);
                            gaDomUtils.removeLocalLoader(
                              '.' + scope.widgetName
                            );
                            require('toastr').error(
                              $filter('translate')(
                                'importExportMBTILES.messages.nombtiles'
                              )
                            );
                          }
                        },
                        function() {
                          gaDomUtils.removeLocalLoader('.' + scope.widgetName);
                          $interval.cancel(stop);
                          require('toastr').error(
                            $filter('translate')(
                              'importExportMBTILES.messages.nombtiles'
                            )
                          );
                        }
                      );
                    }, 10000);
                  } else {
                    require('toastr').error(res.data.reason);
                    gaDomUtils.removeLocalLoader('.' + scope.widgetName);
                  }
                },
                function(res) {
                  require('toastr').error(res.data.message);
                  gaDomUtils.removeLocalLoader('.' + scope.widgetName);
                }
              );
            }
          } else {
            require('toastr').error(
              $filter('translate')('importExportMBTILES.messages.noftis')
            );
          }
        };

        processFactory.getProcessByUsertype(TYPE).then(function(res) {
          scope.currentProcess = res.data;
          scope.tableParamsProcessus = new ngTableParams(
            {
              page: 1, // show first page
              count: 5, // count per page
            },
            {
              total: 0, // length of data
              counts: [5, 10, 15],
              getData: function($defer, params) {
                var displayedTab = scope.currentProcess.slice(
                  (params.page() - 1) * params.count(),
                  params.page() * params.count()
                );

                params.total(scope.currentProcess.length); // set total for recalc pagination

                if (
                  params.page() != 1 &&
                  scope.currentProcess.length == params.count()
                ) {
                  params.page(params.page() - 1);
                }
                $defer.resolve(displayedTab);
              },
            }
          );
        });

        scope.refreshList = function() {
          gaDomUtils.showGlobalLoader();
          processFactory.getProcessByUsertype(TYPE).then(
            function(res) {
              scope.currentProcess = res.data;
              scope.tableParamsProcessus.reload();
              gaDomUtils.hideGlobalLoader();
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.getQrCode = function(rapport) {
          var mobhost =
            $location.protocol() +
            '://' +
            $location.host() +
            ':' +
            $location.port();
          var appname = localStorage.getItem('app');
          if ($location.search().app) {
            appname = $location.search().app;
          }
          scope.mobqrcode =
            '/services/' +
            $rootScope.xgos.portal.uid +
            '/process/qrcode?name=' +
            appname +
            '&token=' +
            gaUrlUtils.encodeUriQuery(localStorage.getItem('auth_token')) +
            '&url=' +
            mobhost +
            '&uid=' +
            rapport.uid;
          scope.titleqrcode =
            $filter('translate')('process.process.qrmbtiles') +
            ' ' +
            rapport.file;
          ngDialog.open({
            template: 'js/XG/widgets/mapapp/main/views/barecode.html',
            className: 'ngdialog-theme-plain width300 miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.deleteProcess = function(rapport) {
          swal(
            {
              title: $filter('translate')('importExportMBTILES.sure'),
              //text: "You will not be able to recover this imaginary file!",
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: false,
            },
            function(isConfirm) {
              if (isConfirm) {
                processFactory.deleteProcess(rapport).then(
                  function(res) {
                    var index;
                    for (var i = 0; i < scope.currentProcess.length; i++) {
                      if (scope.currentProcess[i].uid === rapport.uid) {
                        index = i;
                        break;
                      }
                    }
                    scope.currentProcess.splice(index, 1);
                    scope.tableParamsProcessus.reload();
                    swal({
                      title: $filter('translate')(
                        'importExportMBTILES.deleted'
                      ),
                      text: $filter('translate')(
                        'importExportMBTILES.pdeleted'
                      ),
                      type: 'success',
                      showCancelButton: false,
                      showConfirmButton: false,
                      timer: 1000,
                    });
                  },
                  function() {
                    require('toastr').error(
                      $filter('translate')('process.process.processnotavailabe')
                    );
                  }
                );
              }
            }
          );
        };

        scope.zooms = [];
        for (var i = 0; i <= 31; i++) {
          scope.zooms.push(i);
        }

        scope.getFile = function(rapport) {
          if (rapport.type.split('/').length === 1)
            window.open(
              '/services/' +
                $rootScope.xgos.portal.uid +
                '/mbtiles/getFile?f=json&uid=' +
                rapport.uid +
                '&etat=' +
                rapport.etat +
                '&file=' +
                rapport.file +
                '&type=' +
                rapport.type +
                '&token=' +
                encodeURIComponent(localStorage.getItem('auth_token'))
            );
          else {
            window.open(
              '/services/' +
                $rootScope.xgos.portal.uid +
                '/geopackage/getZipFile?f=json&uid=' +
                rapport.uid +
                '&etat=' +
                rapport.etat +
                '&file=' +
                rapport.file +
                '&type=mbtiles&token=' +
                encodeURIComponent(localStorage.getItem('auth_token'))
            );
          }
        };

        scope.$on('openTools_imexMbtiles', function(event, arg) {
          scope.getMapExtent();
        });

        scope.$on('closeTools_imexMbtiles', function(event, arg) {
          scope.dragBox.setActive(false);
          scope.addedddragbox = false;
          scope.map.removeInteraction(scope.dragBox);
        });

        /*
                 CONFIGURATION DES CANAS
                 */
        scope.configCanas =
          scope.apptype == 'anc'
            ? angular.copy(AncAppFactory.appCfg.main.properties.configCanas)
            : {};
        scope.bkpConfigCana = angular.copy(scope.configCanas);

        /**
         * removeConfigCanaLine
         */
        scope.removeConfigCanaLine = function(index) {
          var ans = confirm('Supprimer cette représentation ?');
          if (ans) scope.configCanas.liste.splice(index, 1);
        };

        /**
         * addConfigCanaLine
         */
        scope.addConfigCanaLine = function() {
          console.log(scope.configCanas);
          scope.configCanas.liste.push({ lib: '', color: '#000000' });
        };

        /**
         * Change geocoder
         */
        var setInfosGeocoder = function() {
          if (CurrentAppFactory.appCfg.main.properties.geocoderActive) {
            scope.choixGeocoder =
              CurrentAppFactory.appCfg.main.properties.geocoderActive;
            scope.bkpChoixGeocoder = angular.copy(scope.choixGeocoder);
          }

          if (CurrentAppFactory.appCfg.main.properties.geocoder) {
            scope.infosGeocoder =
              CurrentAppFactory.appCfg.main.properties.geocoder;
            scope.bkpInfosGeocoder = angular.copy(
              CurrentAppFactory.appCfg.main.properties.geocoder
            );
          }
        };
        setInfosGeocoder();

        scope.activeOnlyOne = function(id) {
          scope.infosGeocoder.forEach(function(geo) {
            if (geo.id != id) geo.active = false;
          });
        };
      },
    };
  };

  ancBacMapConfiguration.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    'FeatureTypeFactory',
    'mbtilesService',
    '$filter',
    'gcStyleFactory',
    'gaDomUtils',
    'SelectManager',
    '$interval',
    '$rootScope',
    'gcInteractions',
    'SridFactory',
    'processFactory',
    'sldUtils',
    '$location',
    'ngDialog',
    'gaUrlUtils',
    'ngTableParams',
    'gclayers',
    '$timeout',
    'ParametersFactory',
    'ApplicationFactory',
    'gaJsUtils',
    'extendedNgDialog',
    'StyleFactory',
  ];
  return ancBacMapConfiguration;
});
