'use strict';
define(function() {
  var ancBacDossierEtablissement = function(
    BacAppFactory,
    EditFactory,
    ngDialog,
    gaDomUtils,
    FeatureTypeFactory,
    $filter,
    $rootScope
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_dossier_etablissement.html',
      restrict: 'EA',
      scope: {
        dossier: '=',
        apptype: '=',
      },
      link: function(scope) {
        /********************************************************************************
         *   BacAppFactory
         * ********************************************************************************/
        scope.etablissementFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          BacAppFactory.appCfg.main.datastore,
          scope.apptype == 'bac'
            ? 'kis_bac_etablissement'
            : 'kis_bac_etablissement'
        );

        /*******************************************************************************
         *   Modals Management
         ********************************************************************************/
        /**
         *search tous les etablissements
         */
        var seachEtablissementModal;
        scope.openSearchEtablissementModal = function() {
          scope.selectedEtablissement = { data: [] };
          scope.etablissementWhere = '1=1';
          seachEtablissementModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.etablissement.search.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };
        /**
         *Modal Add etablissement
         */
        var addEtablissementModal;
        scope.openAddEtablissementModal = function(add) {
          if (add) {
            delete scope.etablissementInfos;
          }
          addEtablissementModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.etablissement.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         *Modal get historique etablissement
         */
        var addEtablissementHistoModal;
        scope.openEtablissementHistoModal = function() {
          scope.currentEditHisto = {};
          scope.gethistoEtablissementDossier();
          addEtablissementHistoModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.etablissement.historique.html',
            className: 'ngdialog-theme-plain width1000 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };
        /*******************************************************************************
         *   Data Management
         ********************************************************************************/
        /**
         *   get historique des etablissements du Dossier
         */
        scope.gethistoEtablissementDossier = function() {
          if (scope.dossier && scope.dossier.id) {
            BacAppFactory.gethistoEtablissementDossier(scope.dossier.id).then(
              function(res) {
                scope.etablissementHistorique = res.data;
              },
              function(res) {
                require('toastr').error(res.data);
              }
            );
          }
        };

        /**
         *   get l'etablissement du Dossier
         */
        scope.getEtablissementbyIdDossier = function() {
          if (scope.dossier && scope.dossier.id) {
            BacAppFactory.getEtablissementbyIdDossier(
              scope.apptype,
              scope.dossier.id
            ).then(
              function(res) {
                if (
                  res &&
                  res.data &&
                  res.data.features[0] &&
                  res.data.features[0].properties
                ) {
                  if (!scope.dossier.properties) {
                    scope.dossier.properties = {};
                  }
                  scope.dossier.properties.etablissement =
                    res.data.features[0].properties;
                  scope.dossier.properties.etablissement.id =
                    res.data.features[0].id;
                  scope.etablissements = { data: [] };
                  scope.etablissements.data = res.data.features;
                }
              },
              function(res) {
                require('toastr').error(res.data);
              }
            );
          }
        };
        scope.getEtablissementbyIdDossier();
        /**
         *   get l'etablissement by Id
         */
        scope.getEtablissementbyId = function(etablissementId) {
          if (etablissementId) {
            BacAppFactory.getEtablissementbyId(
              scope.apptype,
              etablissementId
            ).then(
              function(res) {
                if (
                  res &&
                  res.data &&
                  res.data.features[0] &&
                  res.data.features[0].properties
                ) {
                  scope.etablissementHisto = res.data.features[0].properties;
                  scope.etablissementHisto.id = res.data.features[0].id;
                }
              },
              function(res) {
                require('toastr').error(res.data);
              }
            );
          }
        };

        /**
         * Save etablissement ou update
         */
        scope.saveEtablissement = function() {
          var etablissementProperties = {};
          let idEtablissement = '';
          let create = true;
          if (
            scope.dossier &&
            scope.dossier.id &&
            scope.dossier.properties &&
            scope.dossier.properties.etablissement
          ) {
            etablissementProperties = scope.dossier.properties.etablissement;
            if (scope.dossier.properties.etablissement.id) {
              create = false;
              idEtablissement = scope.dossier.properties.etablissement.id;
              delete etablissementProperties.debut;
            }
            var featureCollection = {
              type: 'FeatureCollection',
              features: [],
            };
            gaDomUtils.showGlobalLoader();
            featureCollection.features.push({
              type: 'Feature',
              properties: etablissementProperties,
            });
            BacAppFactory.addOrUpdateEtablissement(
              featureCollection,
              idEtablissement,
              scope.dossier.id,
              BacAppFactory.appCfg.appname
            ).then(
              function(res) {
                if (res && res.data) {
                  if (!scope.dossier.properties) {
                    scope.dossier.properties = {};
                  }
                  if (!scope.dossier.properties.etablissement) {
                    scope.dossier.properties.etablissement = etablissementProperties;
                  }
                  if (res && res.data && res.data.id)
                    scope.dossier.properties.etablissement.id = res.data.id;
                }
                if (create) {
                  require('toastr').success('Etablissement enregistré');
                } else {
                  require('toastr').success('Etablissement mise à jour');
                }
                /**
                 * Refresh Liste des dossiers
                 */
                $rootScope.$broadcast('saveCurrentReport');
                gaDomUtils.hideGlobalLoader();
                /**
                 * Close Modal
                 */
                addEtablissementModal.close();
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(res.data);
              }
            );
          } else {
            require('toastr').error(
              'des Données manquantes pour la création établissement'
            );
          }
        };
        /**
         * Choisir et aplliquer un etablissement sur un dossier
         */
        scope.chosirEtablissement = function(selectedEtablissement) {
          if (
            selectedEtablissement &&
            selectedEtablissement.data[0] &&
            selectedEtablissement.data[0].id &&
            scope.dossier &&
            scope.dossier.id
          ) {
            let idEtablissement = selectedEtablissement.data[0].id;
            let refDossier = scope.dossier.id;
            BacAppFactory.choisirEtablissementForDossier(
              idEtablissement,
              refDossier
            ).then(
              function(res) {
                seachEtablissementModal.close();
                scope.dossier.properties.etablissement =
                  selectedEtablissement.data[0].properties;
                scope.dossier.properties.etablissement.id =
                  selectedEtablissement.data[0].id;
                require('toastr').success('Etablissement Associé');
              },
              function(res) {
                require('toastr').error(res.data);
              }
            );
          } else {
            require('toastr').error(
              'Des Données manquantes pour Associer Etablissement'
            );
          }
        };
        /**
         * supprimer Etablissement Choisie sur un dossier
         */
        scope.supprimerEtablissementChoisie = function() {
          var r = confirm(
            'Êtes-vous sûr de vouloir supprimer la liaison entre cet établissement et le dossier ?'
          );
          if (r == true) {
            let idEtablissement = scope.dossier.properties.etablissement.id;
            let refDossier = scope.dossier.id;
            gaDomUtils.showGlobalLoader();
            if (idEtablissement && refDossier) {
              BacAppFactory.removeEtablissementfromdossier(
                idEtablissement,
                refDossier
              ).then(
                function(res) {
                  delete scope.dossier.properties.etablissement;
                  gaDomUtils.hideGlobalLoader();
                  require('toastr').success('Etablissement supprimé');
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  require('toastr').error(res.data);
                }
              );
            } else {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                'Des données manquantes pour la supression Etablissement'
              );
            }
          }
        };

        /**
         * show Modal Infos Etablissement
         */
        scope.showModalInfosEtablissement = function(etablissementId) {
          gaDomUtils.showGlobalLoader();

          if (etablissementId) {
            BacAppFactory.getEtablissementbyId(
              scope.apptype,
              etablissementId
            ).then(
              function(res) {
                if (
                  res &&
                  res.data &&
                  res.data.features[0] &&
                  res.data.features[0].properties
                ) {
                  scope.etablissementInfos = res.data.features[0].properties;
                  scope.etablissementInfos.id = res.data.features[0].id;
                  scope.openAddEtablissementModal();
                  gaDomUtils.hideGlobalLoader();
                }
              },
              function(res) {
                require('toastr').error(res.data);
              }
            );
          }
        };
        /**
         * supprimer ligne d'historique de l'"tablissement Choisie sur un dossier
         */
        scope.removeHisto = function(histo, index) {
          var typeToDelete = histo.featureEtablissement.id.replace(
            /[^a-z_]/gi,
            ''
          );
          var ans = confirm(
            "Êtes-vous sur de vouloir supprimer cette ligne d'historique ?"
          );
          if (ans) {
            BacAppFactory.removeEtablissement(
              BacAppFactory.appCfg.appname,
              histo.featureEtablissement.id
            ).then(function(res) {
              $rootScope.$broadcast('saveCurrentReport');
              scope.etablissementHistorique.splice(index, 1);
              require('toastr').success("Ligne d'historique supprimée");
            });
          }
        };
        /**
         * Edit ligne d'historique de l'"tablissement Choisie sur un dossier
         */
        var formatDate = function(dateSource) {
          var date;
          if (dateSource) {
            date = moment(dateSource);
            date = date.toISOString();
            date = $filter('date')(date, 'yyyy-MM-ddTHH:mm:ss.sssZ');
          }
          return date;
        };
        scope.currentEditHisto = [];
        scope.edithisto = function(index) {
          scope.currentEditHisto[index] = true;
        };
        scope.updateHisto = function(histo, index) {
          let idEtablissement = histo.featureEtablissement.id;
          let etablissementProperties = histo.featureEtablissement.properties;
          /**
           *Format Dates
           */
          etablissementProperties.debut = formatDate(
            histo.infoBacEtablissement.debut
          );
          etablissementProperties.fin = formatDate(
            histo.infoBacEtablissement.fin
          );
          /**
           * Setter Id Etablissement
           */
          etablissementProperties.id = idEtablissement;

          var featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };
          gaDomUtils.showGlobalLoader();
          featureCollection.features.push({
            type: 'Feature',
            properties: etablissementProperties,
          });
          BacAppFactory.addOrUpdateEtablissement(
            featureCollection,
            idEtablissement,
            scope.dossier.id,
            BacAppFactory.appCfg.appname
          ).then(
            function(res) {
              if (res && res.data) {
                require('toastr').success('Historique mis à jour');
                delete scope.currentEditHisto[index];
                gaDomUtils.hideGlobalLoader();
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(res.data);
            }
          );
        };
      },
    };
  };
  ancBacDossierEtablissement.$inject = [
    'BacAppFactory',
    'EditFactory',
    'ngDialog',
    'gaDomUtils',
    'FeatureTypeFactory',
    '$filter',
    '$rootScope',
  ];
  return ancBacDossierEtablissement;
});
