'use strict';
define(function() {
  var ancBacDocumentConfiguration = function(
    BacAppFactory,
    AncAppFactory,
    gaDomUtils,
    ngDialog
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_document_configuration.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        console.log(scope.apptype);

        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;
        //GET CONFIG

        var loadConfig = function() {
          scope.appname = BacAppFactory.appCfg.appname || '';
          scope.dashboardCfg = angular.copy(
            CurrentAppFactory.appCfg.main.dashboardCfg
          );
        };

        loadConfig();

        scope.$on('checkIfDirtyDocumentCfg', function() {
          scope.savedashboardCfg(true);
        });

        if (!scope.dashboardCfg) {
          scope.dashboardCfg = [];
        }

        scope.typesRapports = [
          {
            key: 'modele',
            label:
              '<i class="fa fa-file-word-o fileprw"></i> Modèle du portail',
          },
          {
            key: 'static',
            label: '<i class="fa fa-file-pdf-o fileprw"></i> Rapport statique',
          },
          {
            key: 'jasper',
            label: '<i class="fa fa-file-code-o fileprw"></i> Rapport Jasper',
          },
        ];

        // get anc docs
        scope.ancdocs = {};

        /**
         * getDashboardDocs
         * @param type
         */
        scope.getDashboardDocs = function(type) {
          console.log(type);
          AncAppFactory.listdashboarddocs(type).then(function(res) {
            scope.ancdocs[type] = res.data;
          });
        };
        scope.getDashboardDocs('static');
        scope.getDashboardDocs('jasper');

        /**
         * resetDashboardFichier
         * @param dashboardfile
         */
        scope.resetDashboardFichier = function(dashboardfile) {
          delete dashboardfile.fichier;
        };

        /**
         * deleteDashboardDoc
         * @param dashboardfile
         */
        scope.deleteDashboardDoc = function(dashboardfile) {
          var ans = confirm(
            'Êtes-vous certain de vouloir supprimer cet élément ?'
          );
          if (ans) {
            gaDomUtils.showGlobalLoader();

            AncAppFactory.removedashboarddoc(
              dashboardfile.type,
              dashboardfile.fichier
            ).then(
              function() {
                require('toastr').success('Rapport supprimé');
                gaDomUtils.hideGlobalLoader();
                scope.getDashboardDocs(dashboardfile.type);
                scope.resetDashboardFichier(dashboardfile);
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /**
         * uploadDashboardDoc
         * @param type
         */
        var uploadDashboardDialog;
        scope.uploadDashboardDoc = function(type) {
          scope.uploadType = type;
          uploadDashboardDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/admin/modals/modal.addstaticfile.html',
            className: 'ngdialog-theme-plain nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
          uploadDashboardDialog.closePromise.then(function(data) {
            scope.getDashboardDocs(scope.uploadType);
          });
        };

        scope.addNewRapport = function() {
          scope.dashboardCfg.push({
            type: 'modele',
          });
        };

        /*
                 GET LIST FILES
                 */

        scope.savedashboardCfg = function(checkDirty) {
          if (angular.isDefined(checkDirty) && checkDirty) {
            var oldConfig = angular.isDefined(
              CurrentAppFactory.appCfg.main.dashboardCfg
            )
              ? CurrentAppFactory.appCfg.main.dashboardCfg
              : '';
            var newConfig =
              angular.isDefined(scope.dashboardCfg) &&
              Object.keys(scope.dashboardCfg).length > 0
                ? scope.dashboardCfg
                : '';

            if (!angular.equals(newConfig, oldConfig))
              var ans = confirm(
                'Des données ne sont pas sauvegardées. Voulez-vous les enregistrer ?'
              );
          }

          if (angular.isUndefined(checkDirty) || (checkDirty && ans)) {
            CurrentAppFactory.appCfg.main.dashboardCfg = scope.dashboardCfg;
            gaDomUtils.showGlobalLoader();
            CurrentAppFactory.updateAppCfg().then(function() {
              gaDomUtils.hideGlobalLoader();
            });
          } else if (checkDirty && !ans) {
            loadConfig();
          }
        };

        scope.addDashboard = function(newDashboard) {
          scope.dashboardCfg.push(newDashboard);
          uploadDashboardDialog.close();
        };

        scope.removeDashboard = function(index) {
          var r = confirm('Êtes-vous sûr de vouloir supprimer ?');
          if (r == true) {
            scope.dashboardCfg.splice(index, 1);
          }
        };
      },
    };
  };

  ancBacDocumentConfiguration.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    'gaDomUtils',
    'ngDialog',
  ];
  return ancBacDocumentConfiguration;
});
