'use strict';
define(function () {
  var ancBacControleCommonLogic = function (
    BacAppFactory,
    AncAppFactory,
    $timeout,
    FeatureTypeFactory,
    QueryFactory,
    ngDialog,
    EditFactory,
    $rootScope,
    gaJsUtils,
    CalendarFactory,
    $filter,
    $q,
    HtmlUtils
  ) {
    return {
      restrict: 'EA',
      link: function (scope, elt, attrs, ctrl) {
        let apptype = attrs.apptype ? attrs.apptype : 'anc';
        const CurrentAppFactory =
          apptype === 'anc' ? AncAppFactory : BacAppFactory;
        scope.isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(
          navigator.userAgent
        );
        scope.parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          CurrentAppFactory.appCfg.main.parcellesCfg.emplacement
        );
        scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          CurrentAppFactory.appCfg.main.entreprisesCfg.emplacement
        );
        scope.proprietaireFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          apptype === 'anc'
            ? 'kis_anc_dossier_proprietaire'
            : 'kis_bac_dossier_proprietaire'
        );
        scope.demandeurFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          'kis_anc_demandeur'
        );

        scope.etablissementFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          scope.apptype == 'bac'
            ? 'kis_bac_etablissement'
            : 'kis_bac_etablissement'
        );
        scope.priseRDV = CurrentAppFactory.appCfg.main.properties.priseRdv;
        scope.titleForm = CurrentAppFactory.appCfg.main.controleCfg;

        scope.typeProprietaire = scope.proprietaireFti.attributes.filter(
          (att) => {
            return att.name == 'type_proprietaire';
          }
        )[0];

        scope.hasSomethingInAdress = () => {
          scope.disableCopyAdress = true;
          if (scope.currentReport) {
            Object.keys(scope.currentReport.properties).forEach((prop) => {
              if (prop.startsWith('adresse')) {
                if (
                  scope.currentReport.properties[prop] &&
                  scope.currentReport.properties[prop] != '' &&
                  scope.currentReport.properties[prop] != ' '
                ) {
                  scope.disableCopyAdress = false;
                }
              }
            });
          }
        };

        scope.copyDate = () => {
          if (
            scope.cdata.datesDossier.date_controle_rdv &&
            scope.cdata.datesDossier.date_controle !== {}
          ) {
            scope.cdata.datesDossier.date_controle =
              scope.cdata.datesDossier.date_controle_rdv;
          }
        };

        scope.displayFeed = false;

        scope.$on('toggleDisplayFeeder', () => {
          if (!scope.isMobile) {
            scope.displayFeed = !scope.displayFeed;

            if (!scope.displayFeed) {
              $('.feederKey').parent().remove();
              $('.feederKey').remove();
            } else {
              //setup every signets
              addAllSignets();
              $('span.feederKey').on('click', function() {
                HtmlUtils.clickOnFeederKey(this);
              });
            }
          }
        });

        function addAllSignets() {
          $('.ctrlForm input')
            .not($('.ancControleFiliere').find('input'))
            .not($('.table-signet').find('input'))
            .not("input[ng-model='res[attributeToSet]']")
            .each(function() {
              let value = '';
              let model = $(this).attr('ng-model');
              let found = false;
              if (!model) {
                return;
              }

              if (model.split('.')[0] === 'res') {
                let prevElem = $(this).prev();
                model = prevElem.attr('data-for');
                found = true;
              } else {
                if (model.split('.')[1] === 'res') {
                  const prevElem = $(this).prev();
                  model = prevElem.attr('data-for');
                  found = true;
                }
              }

              if (model === 'result[att.name]') {
                let date = $(this).closest('div[javautildate]');
                model = date.attr('data-ng-model');
                found = true;
              }

              if (!model) {
                return;
              }
              if (
                $(this).attr('type') === 'text' ||
                $(this).attr('type') === 'number'
              ) {
                if (model && model.length > 6) {
                  model = model.substring(6, model.length);
                  value = '#{' + model + '}';
                  found = true;
                }
              }
              if ($(this).attr('type') === 'checkbox') {
                model = model.substring(6, model.length);
                value = '#{' + model + '-CB-1}';
                found = true;
              }
              if ($(this).attr('type') === 'radio') {
                model = model.substring(6, model.length);
                let valueRadio = $(this).attr('value');
                value = '#{' + model + '-CB-' + valueRadio + '}';
                found = true;
              }
              HtmlUtils.addSignet(this, found, value);
            });

          $('.ctrlForm textarea')
            .not($('.ancElementFiliere').find('textarea'))
            .not($('.table-signet').find('textarea'))
            .not("textarea[ng-model='result[att.name]']")
            .each(function() {
              let model = $(this).attr('ng-model');
              if (!model) {
                return;
              }
              if (model.split('.')[0] === 'res') {
                model = $(this.previousElementSibling).attr('data-for');
              } else {
                if (model.split('.')[1] === 'res') {
                  model = $(this)
                    .prev()
                    .attr('data-for');
                }
              }
              if (!model) {
                return;
              }
              model = model.substring(6, model.length);
              const value = '#{' + model + '}';
              HtmlUtils.addSignet(this, true, value);
            });

          $('.ctrlForm [form-field]')
            .not($('.ancControleFiliere').children())
            .not($('.table-signet').find('[form-field]'))
            .each(function() {
              let value = '';
              let model = '';
              if ($(this).attr('data-ng-model') !== undefined) {
                model = $(this).attr('data-ng-model');
              } else {
                if ($(this).attr('ng-model') !== undefined) {
                  model = $(this).attr('ng-model');
                } else {
                  if (
                    $(this).attr('fieldModel') !== undefined &&
                    $(this).attr('fieldAttribute') !== undefined
                  ) {
                    model =
                      $(this).attr('fieldModel') +
                      '.' +
                      $(this).attr('fieldAttribute');
                  }
                }
              }
              if (!model) {
                return;
              }
              if (model.split('[')[0] === 'res') {
                const prevElem = $(this).closest('div[form-field]');
                model = prevElem.attr('data-ng-model');
                model = model.substring(6, model.length);
                value = '#{' + model + '}';
              } else {
                if (model.split('.')[1] === 'res') {
                  let prevElem = $(this).closest('div[form-field]');
                  model = prevElem.attr('data-ng-model');
                  model = model.substring(6, model.length);
                  value = '#{' + model + '}';
                } else {
                  model = model.substring(6, model.length);
                  value = '#{' + model + '}';
                }
              }
              HtmlUtils.addSignet(this, true, value);
            });

          $('.ctrlForm select')
            .not($('.table-signet').find('select'))
            .not("select[ng-model='res[attributeToSet]']")
            .each(function() {
              let value = '';
              let model = $(this).attr('ng-model');
              if (!model) {
                return;
              }
              if (model.split('.')[0] === 'cdata') {
                model = model.substring(6, model.length);
                value = '#{' + model + '}';
              }
              if (model && model.split('.')[0] === 'res') {
                const prevElem = $(this.previousElementSibling);
                model = prevElem.attr('data-for');
                if (model) {
                  model = model.substring(6, model.length);
                  value = '#{' + model + '}';
                }
              } else {
                if (model && model.split('.')[1] === 'res') {
                  const prevElem = $(this.previousElementSibling);
                  model = prevElem.attr('data-for');
                  if (model) {
                    model = model.substring(6, model.length);
                    value = '#{' + model + '}';
                  }
                }
              }

              if (!model) {
                model = $(this)
                  .closest('anc-civilite')
                  .attr('res');
                model = model.substring(6, model.length);
                value = '#{' + model + '}';
              }

              if (model) {
                HtmlUtils.addSignet(this, true, value);
              }
            });

          // Create etiquette from fti-name and attribute-name attributes
          $('.ctrlForm .ancControleFiliere [form-field]').each(function() {
            const jHtmlElement = $(this);
            const ftiName = jHtmlElement.attr('fti-name');
            if (ftiName) {
              let model = 'ef-' + ftiName.substring(11, ftiName.length) + '-';
              model += jHtmlElement.data('signet-attribute');
              const value = '#{' + model + '-v}';
              HtmlUtils.addSignet(this, true, value);
            }
          });

          $('.table-signet').each(function() {
            let signetName = $(this).data('signet-name');
            if (signetName) {
              const fullSignetName = '#{kis_bac-tableau_' + signetName + '}';
              HtmlUtils.addSignet(this, true, fullSignetName);
            }
          });
        }

        scope.ctrl_clos = false;
        const watchCurrentControle = scope.$watch('currentControle', (cc) => {
          if (cc) {
            console.log(cc);
            scope.disableRdv = cc.properties.etat == 'clos' ? true : false;
            scope.ctrl_clos = cc.properties.etat == 'clos';
            scope.allowChangementAvis = cc.properties.etat != 'clos';

            //send type of control FO1, FO2 etc
            $rootScope.$broadcast('typeOfControl', cc.properties.type);
          }
        });

        // reopenControle
        scope.$on('reopenControle', () => {
          scope.ctrl_clos = false;
        });
        scope.$on('bloqueChangementAvis', () => {
          scope.ctrl_clos = true;
          scope.allowChangementAvis = false;
        });

        if (!scope.cdata.info_generales) {
          scope.cdata.info_generales = {
            proprietaire: {},
            locataire: {},
            dossier: {},
          };
        }

        scope.display = {
          demandeur: 'reduced',
          installateur: 'reduced',
          concepteur: 'reduced',
          spanc: 'reduced',
          entreprise_publique: 'reduced',
          entreprise_privee: 'reduced',
          maitre_oeuvre: 'reduced',
          personne_presente: 'reduced',
          maitrise_oeuvre: 'reduced',
          maitre_ouvrage: 'reduced',
          rabattement_nappe: 'reduced',
          gestionnaire: 'reduced',
        };

        /* -------------------------------------------------------------------------
                 ctrlCfgValid
                 */
        scope.restrictionsConfig = {
          sort: {
            type: 'ASC',
          },
        };

        /* -------------------------------------------------------------------------
                 ctrlCfgValid
                 */
        scope.ctrlCfgValid = { values: {} };
        scope.incompleteForm = () => {
          let vals = scope.ctrlCfgValid.values;
          if (!scope.cdata.conformite) {
            return 1;
          }
          // heure de la date est mise à 8h si égale à minuit
          const adjustTimeIfMidnight = (date)=> {
            if (date) {
              const dateObj = new Date(date);
              if (dateObj.getHours() === 0 && dateObj.getMinutes() === 0) {
                date = dateObj.setHours(8, 0, 0);
              }
            }
            return date
          }
          scope.cdata.datesDossier.date_controle = adjustTimeIfMidnight(scope.cdata.datesDossier.date_controle)
          scope.cdata.datesDossier.date_rdv = adjustTimeIfMidnight(scope.cdata.datesDossier.date_rdv)

          return (
            (vals.obligatoire > 0 &&
              vals.filled_obligatoire < vals.obligatoire) ||
            !scope.cdata.conformite.valeur ||
            !scope.cdata.conformite.responsable ||
            !scope.cdata.datesDossier.date_avis
          );
        };

        //Initializing values for Superficie totale de la parcelle en m² in controle
        // if there is an existing parcelle
        scope.initializeSuperficieTotale = () => {
          if (!scope.currentReport.properties.parcelleHabitation) {
            return;
          }
          if (scope.cdata.caracteristique_terrain === undefined) {
            scope.cdata.caracteristique_terrain = {};
          }
          if (scope.cdata.caracteristiques_terrain === undefined) {
            scope.cdata.caracteristiques_terrain = {};
          }

          if (scope.parcellesFti != null) {
            QueryFactory.get(
              scope.parcellesFti.uid,
              scope.currentReport.properties.parcelleHabitation.id
            )
              .then((res) => {
                if (
                  res.data !== undefined &&
                  res.data.features[0] !== undefined &&
                  res.data.features[0].properties !== undefined
                ) {
                  scope.cdata.caracteristique_terrain.superficie =
                    scope.cdata.caracteristique_terrain.superficie ||
                    res.data.features[0].properties.surface ||
                    res.data.features[0].properties.supf;

                  scope.cdata.caracteristiques_terrain.parcelle =
                    scope.cdata.caracteristiques_terrain.parcelle ||
                    res.data.features[0].properties.surface ||
                    res.data.features[0].properties.supf;
                }
              })
              .catch((e) => {
                e.stack;
              });
          }
        };

        scope.initializeSuperficieTotale();

        /* -------------------------------------------------------------------------
                 MODIFICATION DU FORMULAIRE, POUR PROPOSITION D'ENREGISTREMENT DES MODIFS
                 */
        // var dataLoaded = false;
        var watchCdata;
        $timeout(() => {
          scope.$on('checkDirty', (v, data, newData) => {
            //Break two ways binding to compare
            var tmpData = angular.copy(data);
            var tmpNewData = angular.copy(newData);

            //Delete key that can change onload
            //Specific control
            if (tmpData && tmpData.caracteristiques_install) {
              delete tmpData.caracteristiques_install;
            }
            if (tmpNewData.caracteristiques_install) {
              delete tmpNewData.caracteristiques_install;
            }
            if (
              gaJsUtils.checkNestedProperty('general.taille_filiere', tmpData)
            ) {
              delete tmpData.general.taille_filiere;
            }
            if (
              gaJsUtils.checkNestedProperty(
                'general.taille_filiere',
                tmpNewData
              )
            ) {
              delete tmpNewData.general.taille_filiere;
            }

            //Remove all empty object
            var cleanData = gaJsUtils.removeEmpty(tmpData, true);
            var cleanNewData = gaJsUtils.removeEmpty(tmpNewData, true);

            //Compare ONLY data
            if (!angular.equals(cleanData, cleanNewData) && !scope.ctrl_clos) {
              scope.$emit('ancCtrlFormIsDirty', {});
            }
          });
        });

        scope.fillCaracteristiquesDeLHabitation = (event) => {
          if (event) {
            event.preventDefault();
            event.stopPropagation();
          }
          const currentReportProps =
            angular.copy(scope.currentReport.properties) || {};
          let caracteristiques_hab = angular.copy(
            scope.cdata.caracteristiques_hab
          );
          caracteristiques_hab = Object.assign(caracteristiques_hab, {
            type_habitation:
              currentReportProps.type_habitation ||
              caracteristiques_hab.type_habitation,
            date_filiere_anc:
              $filter('date')(
                currentReportProps.date_filiere_anc,
                'dd-MM-yyyy'
              ) || caracteristiques_hab.date_filiere_anc,
            annee_logement:
              currentReportProps.annee_logement ||
              caracteristiques_hab.annee_logement,
            consomeau:
              currentReportProps.consomeau || caracteristiques_hab.consomeau,
            neh: currentReportProps.neh || caracteristiques_hab.neh,
            nbchambre:
              currentReportProps.nbchambre || caracteristiques_hab.nbchambre,
            nombre_logement:
              currentReportProps.nombre_logement ||
              caracteristiques_hab.nombre_logement,
            nboccupant:
              currentReportProps.nboccupant || caracteristiques_hab.nboccupant,
            nbpiece: currentReportProps.nbpiece || caracteristiques_hab.nbpiece,
            occupannu:
              currentReportProps.occupannu || caracteristiques_hab.occupannu,
            vacant:
              Number(currentReportProps.vacant).toString() ||
              caracteristiques_hab.vacant,
            comment:currentReportProps.caracteristiques_site_comment||'',
          });
          scope.cdata.caracteristiques_hab = caracteristiques_hab;
        };

        /* -------------------------------------------------------------------------
                 Adresse du dossier
                 */
        scope.fillAdresseDossier = (destRes) => {
          const dest = destRes || 'dossier';

          if (!scope.cdata.info_generales[dest]) {
            scope.cdata.info_generales[dest] = {};
          }

          if (!scope.cdata.caracteristiques_hab) {
            scope.cdata.caracteristiques_hab = {};
          }

          console.log(scope.currentReport.properties);
          [
            'adresse_num_rue',
            'adresse_num_rue_extra',
            'adresse_rue',
            'adresse_cp',
            'adresse_ville',
            'num_tel',
            'email',
            'adresse_complement',
            'adresse_bp',
            'adresse_pays',
            'adresse_batiment',
            'adresse_appt',
            'adresse_etage',
            'adresse_escalier',
            'coordinates_x',
            'coordinates_y',
          ].forEach((k) => {
            if (scope.currentReport.properties[k]) {
              if (
                scope.apptype === 'anc' &&
                (k === 'coordinates_x' || k === 'coordinates_y')
              ) {
                delete scope.currentReport.properties[k];
              } else {
                scope.cdata.info_generales[dest][k] = angular.copy(
                  scope.currentReport.properties[k]
                );
              }
            }
          });

          if (
            scope.currentControle.properties.type != 'FO1' &&
            apptype == 'anc'
          ) {
            if (scope.currentReport.properties.annee_construction) {
              scope.cdata.caracteristiques_hab.annee_logement = angular.copy(
                scope.currentReport.properties.annee_construction
              );
            }
          }
          if ($rootScope.xgos.sector == 'bac' && scope.cdata.info_generales.dossier.adresse_ville) {
            function selectionFiltreVille(element ) {
              return element.gere_sass && element.value == scope.cdata.info_generales.dossier.adresse_ville ;
            }
            let ville = BacAppFactory.appCfg.main.extra.infosSassListeVillesCfg.filter(selectionFiltreVille);
            if(ville && ville[0]){
              scope.majCodeInsee(ville[0]);
            }
          }
        };

        /* ------------------------------------------------------------------------- 
                 FILL PARCELLE
                 */

        var parcellesCfg = CurrentAppFactory.appCfg.main.parcellesCfg;
        var parcelleFields = parcellesCfg.fields;
        /**
         * get information parcelle
         * @param type
         */

        var selectParcelleModal;
        var openDialogSelectParcelle = (type) => {
          scope.parcelleToShowOnDialog = type;

          scope.selectedParcelle = {};
          selectParcelleModal = ngDialog.open({
            template:
              'js/XG/widgets/bacapp/main/views/modals/modal.select_parcelle.html',
            className: 'ngdialog-theme-plain width350 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.chooseParcelle = () => {
          selectParcelleModal.close();
          if (
            scope.selectedParcelle.index &&
            !isNaN(scope.selectedParcelle.index)
          ) {
            CurrentAppFactory.getparcelle(
              scope.currentReport.properties[scope.parcelleToShowOnDialog][
                scope.selectedParcelle.index
              ].id
            ).then((res) => {
              const p = res.data.features[0];
              console.log(p);
              scope.cdata.info_generales[scope.parcelleToShowOnDialog] = {
                section: p.properties[parcelleFields.section],
                numero: p.properties[parcelleFields.numero],
                superficie: p.properties[parcelleFields.surface],
              };
            });
          }
        };

        scope.fillParcelle = (type) => {
          if (scope.currentReport.properties[type] instanceof Array) {
            if (scope.currentReport.properties[type].length === 1) {
              CurrentAppFactory.getparcelle(
                scope.currentReport.properties[type][0].id
              ).then((res) => {
                const p = res.data.features[0];
                scope.cdata.info_generales[type] = {
                  section: p.properties[parcelleFields.section],
                  numero: p.properties[parcelleFields.numero],
                  superficie: p.properties[parcelleFields.surface],
                };
              });
            } else {
              if (!scope.currentReport.properties[type].length) {
                require('toastr').warning(
                  'Aucune parcelle reliée au dossier.',
                  '',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
              } else {
                openDialogSelectParcelle(type);
              }
            }
          } else {
            if (scope.currentReport.properties[type]) {
              CurrentAppFactory.getparcelle(
                scope.currentReport.properties[type].id
              ).then((res) => {
                const p = res.data.features[0];
                scope.cdata.info_generales[type] = {
                  section: p.properties[parcelleFields.section],
                  numero: p.properties[parcelleFields.numero],
                  superficie: p.properties[parcelleFields.surface],
                };
              });
            } else {
              require('toastr').warning(
                'Aucune parcelle reliée au dossier.',
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
            }
          }
        };

        /**
         *fill Etablissement Data on instruction
         */
        scope.fillEtablissementData = () => {
          if (!scope.cdata.info_generales) {
            scope.cdata.info_generales = {};
          }
          if (scope.currentReport.properties.etablissement) {
            if (scope.currentReport.properties.etablissement.nom) {
              scope.cdata.info_generales.nom_etablissement =
                scope.currentReport.properties.etablissement.nom;
            }
            if (scope.currentReport.properties.etablissement.siret) {
              scope.cdata.info_generales.siret_etablissement =
                scope.currentReport.properties.etablissement.siret;
            }
          }
        };

        /**
         *fill Etablissement Activites Data on instruction
         */
        scope.fillEtablissementActiviteData = () => {
          if (scope.currentReport.properties.activite_principale) {
            scope.cdata.activite_principale =
              scope.currentReport.properties.activite_principale;
          }
          if (scope.currentReport.properties.activite_secondaire) {
            scope.cdata.activite_secondaire =
              scope.currentReport.properties.activite_secondaire;
          }
          if (scope.currentReport.properties.details_icpe) {
            scope.cdata.details_icpe =
              scope.currentReport.properties.details_icpe;
          }
        };

        scope.typeProprietaire = scope.proprietaireFti.attributes.filter(
          (att) => {
            return att.name == 'type_proprietaire';
          }
        )[0];

        scope.getInfosPersonne = (id_personne, type_personne, closedialog) => {
          let type = 'proprietaire';
          if (type_personne === 'locataires') {
            type = 'locataire';
          } else {
            if (type_personne.indexOf('pers_present_ctrl') == 0) {
              type = 'pers_present_ctrl';
            }
          }

          if (
            !gaJsUtils.checkNestedProperty(
              'info_generales.' + type,
              scope.cdata
            )
          ) {
            gaJsUtils.setNestedProperty(
              'info_generales.' + type,
              scope.cdata,
              {}
            );
          }

          if (
            gaJsUtils.checkNestedProperty(
              'info_generales.' + type + '.type',
              scope.cdata
            )
          ) {
            delete scope.cdata.info_generales[type]['type'];
          }

          CurrentAppFactory.getpersonne(id_personne).then((res) => {
            var pers = res.data.features[0];

            for (let k in pers.properties) {
              if (k === 'nom_complement') {
                scope.cdata.info_generales.proprietaire.nom_conjoint =
                  pers.properties[k];
              } else {
                scope.cdata.info_generales[type][k] = pers.properties[k];
              }
            }

            // recup aussi equivalent redevance et type proprietaire
            if (
              type == 'proprietaire' ||
              type_personne == 'pers_present_ctrl_prop'
            ) {
              var proprietaireFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
                CurrentAppFactory.appCfg.main.datastore,
                apptype == 'bac'
                  ? 'kis_bac_dossier_proprietaire'
                  : 'kis_anc_dossier_proprietaire'
              );

              QueryFactory.data(
                proprietaireFti.uid,
                "ref_dossier = '" +
                  scope.currentReport.id +
                  "' " +
                  "AND id_personne = '" +
                  pers.id +
                  "' " +
                  "AND courant='true'"
              ).then((res) => {
                if (res.data.features.length) {
                  const p = res.data.features[0].properties;
                  scope.cdata.info_generales[type][
                    'est_redevable'
                  ] = p.est_redevable ? '1' : false;

                  if (type === 'pers_present_ctrl') {
                    scope.cdata.info_generales[type]['type'] = getValueType(
                      'proprietaire',
                      p.type_proprietaire
                    );
                  } else {
                    scope.cdata.info_generales[type]['type_proprietaire'] =
                      '' + p.type_proprietaire;
                  }
                  scope.cdata.datesDossier = scope.cdata.datesDossier || {};
                  scope.cdata.datesDossier["debut_proprietaire"] = ''
                    + (p.debut || "");
                  scope.cdata.datesDossier["fin_proprietaire"] = ''
                    + (p.fin || "");
                }
              });
            }
            if (closedialog) {
              pickPersDialog.close();
            }
          });
        };

        const getValueType = (type, value) => {
          let fti;
          let indexAttr;
          let res;

          if (type === 'demandeur') {
            fti = scope.demandeurFti;
          }

          if (type === 'proprietaire') {
            fti = scope.proprietaireFti;
          }

          fti.attributes.forEach((attr, i) => {
            if (attr.name.indexOf('type') == 0) {
              indexAttr = i;
            }
          });

          res = fti.attributes[indexAttr].restrictions[0].listofValues[value]
            ? fti.attributes[indexAttr].restrictions[0].listofValues[value]
            : null;

          return res;
        };

        scope.fillAdresseProp = () => {
          console.log(scope.currentReport);
          for (var k in scope.currentReport.properties) {
            if (k.indexOf('adresse_') == 0) {
              scope.cdata.info_generales.proprietaire[k] =
                scope.currentReport.properties[k];
            }
          }
        };

        let pickPersDialog;
        scope.preFillPersonne = (type_personne) => {
          let type = type_personne;

          if (type_personne === 'pers_present_ctrl_prop') {
            type_personne = 'proprietaires';
          } else {
            if (type_personne === 'pers_present_ctrl_loc') {
              type_personne = 'locataires';
            } else {
              if (type_personne === 'pers_present_ctrl_dem') {
                type_personne = 'demandeur';
              }
            }
          }

          if (type_personne !== 'demandeur') {
            if (scope.currentReport.properties[type_personne].length == 1) {
              scope.getInfosPersonne(
                scope.currentReport.properties[type_personne][0].id,
                type
              );
            } else {
              if (type_personne === 'proprietaires') {
                scope.pickedProprietaire = {};
                pickPersDialog = ngDialog.open({
                  template:
                    'js/XG/widgets/ancapp/main/views/controle/modals/modal.pick.proprietaire.html',
                  className:
                    'ngdialog-theme-plain width600 nopadding miniclose',
                  closeByDocument: false,
                  scope: scope,
                });
              }
            }
          } else {
            if (type_personne === 'demandeur') {
              scope.cdata.info_generales.demandeur;
              for (let k in scope.cdata.info_generales.demandeur) {
                if (k === 'nom_complement') {
                  scope.cdata.info_generales.proprietaire.nom_conjoint =
                    scope.cdata.info_generales.demandeur[k];
                } else {
                  if (k === 'type') {
                    type = getValueType(
                      'demandeur',
                      scope.cdata.info_generales.demandeur[k]
                    );
                    scope.cdata.info_generales.pers_present_ctrl[k] = type;
                  } else {
                    scope.cdata.info_generales.pers_present_ctrl[k] =
                      scope.cdata.info_generales.demandeur[k];
                  }
                }
              }
            }
          }
        };
            
    /**
     * Initialisation des données de "FONCTIONNEMENT ET IMPACT DU DISPOSITIF", de la grille de conformité 
     * avec les données techniques des dossiers 
     */
    const fillGrilleConformite = () => {
      let editData = false;
      if (!scope.cdata.grille) {
        scope.cdata.grille = {
          conc: {},
        };
      }
      if (scope.currentReport.properties.enjeusan) {
        if (
          !scope.cdata.grille.conc.enjeusan ||
          scope.currentReport.properties.enjeusan !==
            scope.cdata.grille.conc.enjeusan
        ) {
          scope.cdata.grille.conc.enjeusan =
            scope.currentReport.properties.enjeusan;
          editData = true;
        }
      }
      if (scope.currentReport.properties.enjeuenv) {
        if (
          !scope.cdata.grille.conc.enjeuenv ||
          scope.currentReport.properties.enjeuenv !==
            scope.cdata.grille.conc.enjeuenv
        ) {
          scope.cdata.grille.conc.enjeuenv =
            scope.currentReport.properties.enjeuenv;
          editData = true;
        }
      }
      if (editData) {
        $rootScope.$broadcast('save_controle_detail');
      }
    };
    fillGrilleConformite();

        /* -------------------------------------------------------------------------
                 ENTREPRISE PICKER
                 */

        let pickInstallateurDialog;
        scope.prePickInstallateur = (type) => {
          if (!scope.entreprisesFti) {
            scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
              AncAppFactory.appCfg.main.datastore,
              scope.entreprisesCfg.emplacement
            );
          }

          if (type === 'entreprise_publique' || type === 'entreprise_privee') {
            scope.selectedTypeEntreprise = type;
            type = 'entreprise';
          }

          scope.displayAttributesEntreprise = [];
          scope.entreprisesFti.attributes.forEach((att) => {
            if (
              ~[
                'nom',
                'type',
                'siret',
                'num_tel',
                'num_port',
                'fax',
                'email',
                'adresse_num_rue',
                'adresse_num_rue_extra',
                'adresse_rue',
                'adresse_ville',
                'adresse_cp',
                'adresse_bp',
                'adresse_pays',
                'adresse_batiment',
                'adresse_appt',
                'adresse_etage',
                'adresse_escalier',
                'adresse_complement',
                'actif',
              ].indexOf(att.name)
            ) {
              if (att.name === 'type') {
                scope.displayAttributesEntreprise.splice(0, 0, att);
              } else {
                scope.displayAttributesEntreprise.push(att);
              }
            }
          });

          scope.typeEntreprise = type;
          scope.selectEntrepriseFilter = 'type =';
          switch (type) {
            case 'concepteur': {
              scope.selectEntrepriseFilter += '1';
              break;
            }
            case 'installateur': {
              scope.selectEntrepriseFilter += '2';
              break;
            }
            case 'spanc': {
              scope.selectEntrepriseFilter += '4';
              break;
            }
            case 'spac': {
              scope.selectEntrepriseFilter += '6';
              break;
            }
          }
          // seulement les entreprises actives
          if (typeof userAndroid !== 'undefined') {
            scope.selectEntrepriseFilter += " AND actif = 'true' ";
          } else {
            scope.selectEntrepriseFilter += ' AND actif = true ';
          }

          if (type == 'gestionnaire') {
            scope.selectEntrepriseFilter = "actif = 'true'";
          }

          pickInstallateurDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/controle/modals/modal.pick.entreprise.html',
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /*
                 Ajouter une entreprise
                 */
        var addEntrepriseDialog;

        scope.ouvrirEntrepriseDialog = (typeEntreprise) => {
          scope.type = typeEntreprise;
          scope.currentEntreprise = {
            properties: {
              type: typeEntreprise,
              actif: true,
            },
          };
          scope.forceType = true;
          scope.forceActif = true;

          addEntrepriseDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.entreprise.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.saveEntreprise = () => {
          const featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };

          featureCollection.features.push({
            type: 'Feature',
            properties: scope.currentEntreprise.properties,
          });
          EditFactory.add(scope.entreprisesFti.uid, featureCollection).then(
            () => {
              require('toastr').success('Enregistré');
              addEntrepriseDialog.close();
            }
          );

          // Si concepteur
          if (scope.currentEntreprise.properties.type === '1') {
            scope.cdata.general.concepteur = scope.currentEntreprise.properties;
          }

          // Si intallateur
          if (scope.currentEntreprise.properties.type === '2') {
            scope.cdata.general.installateur =
              scope.currentEntreprise.properties;
          }

          // Si SPANC
          if (scope.currentEntreprise.properties.type === '4') {
            scope.cdata.service_controle = scope.currentEntreprise.properties;
          }

          // Si SPAC
          if (scope.currentEntreprise.properties.type === '6') {
            scope.cdata.service_controle = scope.currentEntreprise.properties;
          }
        };

        scope.entreprisesCfg = CurrentAppFactory.appCfg.main.entreprisesCfg;

        if (scope.entreprisesCfg) {
          scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            CurrentAppFactory.appCfg.main.datastore,
            scope.entreprisesCfg.emplacement
          );
        }

        scope.getInfosEntreprise = (entreprise) => {
          if (scope.typeEntreprise === 'installateur') {
            scope.cdata.general.installateur = entreprise[0].properties;
          } else {
            if (scope.typeEntreprise === 'concepteur') {
              scope.cdata.general.concepteur = entreprise[0].properties;
            } else {
              if (scope.typeEntreprise === 'spanc') {
                scope.cdata.service_controle = entreprise[0].properties;
              } else {
                if (scope.typeEntreprise === 'spac') {
                  scope.cdata.service_controle = entreprise[0].properties;
                } else {
                  if (scope.typeEntreprise === 'gestionnaire') {
                    scope.cdata.info_generales.gestionnaire =
                      entreprise[0].properties;
                  } else {
                    scope.cdata.general.installateur =
                      entreprise[0].properties.nom +
                      ' ; ' +
                      entreprise[0].properties.siret;
                  }
                }
              }
            }
          }
          pickInstallateurDialog.close();
        };

        /**
         * Afficher/cacher les informations de l'entreprise
         */

        scope.toggleDisplayEntreprise = (type) => {
          switch (type) {
            case 'installateur': {
              scope.display.installateur =
                scope.display.installateur === 'full' ? 'reduced' : 'full';
              break;
            }
            case 'concepteur': {
              scope.display.concepteur =
                scope.display.concepteur === 'full' ? 'reduced' : 'full';
              break;
            }
            case 'spanc': {
              scope.display.spanc =
                scope.display.spanc === 'full' ? 'reduced' : 'full';
              break;
            }
            case 'spac': {
              scope.display.spanc =
                scope.display.spac == 'full' ? 'reduced' : 'full';
              break;
            }
            case 'gestionnaire': {
              scope.display.gestionnaire =
                scope.display.gestionnaire === 'full' ? 'reduced' : 'full';
              break;
            }
          }
        };

        /**
         * entrepriseNotSet
         */

        scope.entrepriseNotSet = (type) => {
          if (!scope.cdata.general) {
            scope.cdata.general = {};
          }
          if (!scope.cdata.travaux && apptype !== 'anc') {
            scope.cdata.travaux = {};
          }
          if (!scope.cdata.info_generales) {
            scope.cdata.info_generales = {};
          }
          switch (type) {
            case 'installateur': {
              return (
                !scope.cdata.general.installateur ||
                !Object.keys(scope.cdata.general.installateur).length
              );
            }
            case 'concepteur': {
              return (
                !scope.cdata.general.concepteur ||
                !Object.keys(scope.cdata.general.concepteur).length
              );
            }
            case 'spanc': {
              return (
                !scope.cdata.general.spanc ||
                !Object.keys(scope.cdata.general.spanc).length
              );
            }
            case 'spac': {
              return (
                !scope.cdata.general.spanc ||
                !Object.keys(scope.cdata.general.spanc).length
              );
            }
            case 'gestionnaire': {
              return (
                !scope.cdata.info_generales.gestionnaire ||
                !Object.keys(scope.cdata.info_generales.gestionnaire).length
              );
            }
          }
        };

        /**
         * unlinkEntreprise
         */

        scope.unlinkEntreprise = (type) => {
          switch (type) {
            case 'installateur': {
              if (scope.cdata.general.installateur) {
                delete scope.cdata.general.installateur;
              }
              break;
            }
            case 'concepteur': {
              if (scope.cdata.general.concepteur) {
                delete scope.cdata.general.concepteur;
              }
              break;
            }
            case 'spanc': {
              if (scope.cdata.service_controle) {
                delete scope.cdata.service_controle;
              }
              break;
            }
            case 'spac': {
              if (scope.cdata.service_controle) {
                delete scope.cdata.service_controle;
              }
              break;
            }
            case 'gestionnaire': {
              if (scope.cdata.info_generales.gestionnaire) {
                delete scope.cdata.info_generales.gestionnaire;
              }
              break;
            }
          }
        };

        /* -------------------------------------------------------------------------
                 Miscellaneous
                 */

        /**
         * unlinkStatut
         */
        scope.unlinkStatut = () => {
          if (scope.cdata.general.statut_rdv) {
            delete scope.cdata.general.statut_rdv;
          }
        };

        /**
         * Set display
         */
        let addDisplayDemandeur = scope.$on(
          'addDisplayDemandeur',
          (event, name) => {
            if (name.value !== '') {
              scope.display[name.value] = 'reduced';
            }
          }
        );

        /**
         * Afficher / Cacher les informations du demandeur
         */
        let toggleDisplayDemandeur = $rootScope.$on(
          'toggleDisplayDemandeur',
          (event, data, type) => {
            if (type) {
              scope.display[type] =
                scope.display[type] == 'full' ? 'reduced' : 'full';
            }
            scope.display.demandeur =
              scope.display.demandeur == 'full' ? 'reduced' : 'full';
          }
        );

        let toggleDisplayBuereauEtudes = (event, expanded) => {
          scope.display.bureauDeEtudes = expanded ? 'full' : 'reduced';
        };

        scope.$on('toggleDisplayBureau', toggleDisplayBuereauEtudes);
        scope.display.bureauDeEtudes = 'reduced';

        let toggleDisplaySpanc = $rootScope.$on('toggleDisplaySpanc', () => {
          scope.display.spanc =
            scope.display.spanc == 'full' ? 'reduced' : 'full';
        });

        scope.toggleDisplayPersonnePresente = () => {
          if (!scope.display.personne_presente) {
            scope.display.personne_presente = 'reduced';
          } else {
            scope.display.personne_presente =
              scope.display.personne_presente === 'full' ? 'reduced' : 'full';
          }
        };

        scope.cleanPersonnePresente = () => {
          let ans = confirm(
            'Êtes-vous sur de vouloir supprimer la personne présente lors du contrôle ?'
          );
          if (ans) {
            scope.cdata.info_generales.pers_present_ctrl = {};
          }
        };

        /**
         * demandeurNotSet
         */
        scope.demandeurNotSet = () => {
          return (
            !scope.cdata.info_generales.demandeur ||
            !Object.keys(scope.cdata.info_generales.demandeur).length
          );
        };

        scope.reinitObjectIfHide = (object) => {
          if (object === 'modif' && scope.cdata.modif.aucune != 1) {
            if (Array.isArray(object)) {
              object.forEach((key) => {
                if (gaJsUtils.checkNestedProperty(key, scope.cdata)) {
                  gaJsUtils.setNestedProperty(key, scope.cdata, null);
                }
              });
            } else {
              if (object !== 'modif.aucune') {
                if (gaJsUtils.checkNestedProperty(object, scope.cdata))
                  gaJsUtils.setNestedProperty(object, scope.cdata, null);
              }
            }
          } else {
            return;
          }
        };

        //SPECIFIC BAC-------------------------------------------------------------
          scope.calculeInseeAndDateDubAu = (forceRefresh) => {
            if (!scope.cdata.demande_autorisation_urbanisme) {
              scope.cdata.demande_autorisation_urbanisme = {};
            }
            if (forceRefresh) {
              scope.cdata.demande_autorisation_urbanisme.insee = '';
            }
            if (
              apptype === 'bac' &&
              (scope.currentControle.properties.type === 'DUB' ||
                scope.currentControle.properties.type === 'DAU')
            ) {
              if (
                scope.currentReport.properties.parcelleHabitation &&
                scope.currentReport.properties.parcelleHabitation.length > 0
              ) {
                QueryFactory.get(
                  scope.parcellesFti.uid,
                  scope.currentReport.properties.parcelleHabitation[0].id
                ).then((res) => {
                  if (res.data) {
                    if (parcelleFields && parcelleFields.insee) {
                      if (
                        !res.data.features[0].properties[parcelleFields.insee]
                      ) {
                        require('toastr').warning(
                          'Le champ ' +
                            parcelleFields.insee +
                            " est null ou n'existe pas sur la table parcelles."
                        );
                      } else {
                        scope.cdata.demande_autorisation_urbanisme.insee =
                          res.data.features[0].properties[parcelleFields.insee];
                      }
                    }
                    getYear(forceRefresh);
                  }
                }).catch(err => {
                  const message = 'Récupération impossible des données de la parcelle .';
                  require('toastr').error(message, '', {
                    positionClass: 'toast-bottom-left',
                  });
                });
              } else {
                require('toastr').warning(
                  "Le code insee ne peut être récupéré ou mis à jour. Aucune parcelle n'est associée au dossier"
                );
              }
            }
          };
        const getYear = (forceRefresh) => {
          if (scope.cdata.demande_autorisation_urbanisme) {
            if (
              !scope.cdata.demande_autorisation_urbanisme.annee ||
              forceRefresh
            ) {
              scope.cdata.demande_autorisation_urbanisme.annee = new Date()
                .getFullYear()
                .toString()
                .substr(-2);
            }
          }
        };
        scope.calculeInseeAndDateDubAu(false);
        
        
        scope.$on('communeAdresseChange', (event, ville) => {
          if (
            scope.currentControle.properties.type === 'DUB' ||
            scope.currentControle.properties.type === 'DAU'
          ) {
            scope.majCodeInsee(ville);
          }
        });
        scope.majCodeInsee = (ville) => {
          let confirmation = false;
          let inseeExist = true;
          if (
            scope.cdata.demande_autorisation_urbanisme &&
            scope.cdata.demande_autorisation_urbanisme.insee
          ) {
            confirmation = confirm(
              'Le dossier possède déjà un code insee ' +
                scope.cdata.demande_autorisation_urbanisme.insee +
                ' , Êtes-vous sûr de vouloir le mettre à jour ?'
            );
          } else {
            inseeExist = false;
          }
          if (!inseeExist || confirmation)
            if (ville && ville.insee) {
              scope.cdata.demande_autorisation_urbanisme.insee =
                ville.insee;
              require('toastr').success('Code insee MAJ');
            } else {
              require('toastr').warning(
                "Le code insee ne peut être récupéré. La ville choisie n'a pas de code insee"
              );
            }
        };


        scope.getTitleForm = () => {
          scope.title = '';
          scope.titleForm.map((ctrlCfg) => {
            if (scope.currentControle.properties.type === ctrlCfg.type) {
              scope.title = ctrlCfg.label;
            }
          });
        };
        scope.getTitleForm();

        //--------------------------------------------------------------------------

        // cleanup
        scope.$on('$destroy', () => {
          if (watchCdata) {
            watchCdata();
          }
          watchCurrentControle();
          toggleDisplayDemandeur();
          toggleDisplaySpanc();
        });

        scope.preFillReferent = () => {
          if (scope.currentReport && scope.currentReport.id) {
            CurrentAppFactory.getEtablissementbyIdDossier(
              scope.apptype,
              scope.currentReport.id
            ).then(
              (res) => {
                if (
                  res &&
                  res.data &&
                  res.data.features[0] &&
                  res.data.features[0].properties
                ) {
                  scope.cdata.info_generales.referent =
                    res.data.features[0].properties;
                }
              },
              (res) => {
                require('toastr').error(res);
              }
            );
          }
        };
      },
    };
  };

  ancBacControleCommonLogic.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    '$timeout',
    'FeatureTypeFactory',
    'QueryFactory',
    'ngDialog',
    'EditFactory',
    '$rootScope',
    'gaJsUtils',
    'CalendarFactory',
    '$filter',
    '$q',
    'HtmlUtils',
  ];
  return ancBacControleCommonLogic;
});

