'use strict';
define(function() {
  var ancBacConfigurationRequeteJson = function(
    BacAppFactory,
    AncAppFactory,
    gaDomUtils,
    $q,
    FeatureTypeFactory,
    $rootScope
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_configuration_requete_json.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
        relation: '=',
        fakeJsonFti: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        // -----------------------------
        // gestion des attributs des controles json
        // -----------------------------
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;
        scope.typesControle = CurrentAppFactory.appCfg.main.controleCfg;

        var getNbctrlFilter = function(relation) {
          var nb = 0;
          if (!angular.isDefined(relation)) return nb;

          for (var i in relation.controle_json_filters.types)
            if (relation.controle_json_filters.types[i].selected == true) nb++;
          return nb;
        };

        scope.allCtrlFilterToggled = {
          v: getNbctrlFilter() == scope.typesControle.length,
        };

        /**
         * toggleAllCtrlFilter
         * @param {*} r
         */
        scope.toggleAllCtrlFilter = function(r) {
          if (scope.allCtrlFilterToggled.v) {
            scope.typesControle.map(function(x) {
              r.controle_json_filters.types[x.type] = {
                selected: true,
              };
            });
          } else {
            r.controle_json_filters.types = {};
          }
        };

        /**
         * Vérifie que le filtre sur controle anc comprend au moins une rule de type rule
         * @param {*} relation
         * @RB desactivé pour le moment pour que le bloc soit tjrs visible puisqu'il sert à restreindre le type aussi
         */
        scope.hasControleAttributeRule = function(relation) {
          if (
            relation.filters &&
            relation.filters.length &&
            relation.selectGlobaladvancedFti == scope.controleAlias
          ) {
            return relation.filters.filter(function(x) {
              return x.choice == 'rule';
            }).length;
          }
          return false;
        };

        /**
         * refreshAttributsCtrlJson
         * Retourne la liste des attributs des controles json dispo selon les types de ctrl choisis
         * @param {*} r
         */
        scope.refreshAttributsCtrlJson = function(r) {
          // console.log(r);

          gaDomUtils.showGlobalLoader();
          scope.nbAttributsSelectionnables = false;

          var attributesFinal = [];
          var toGet = [];
          for (var i in r.controle_json_filters.types) {
            if (r.controle_json_filters.types[i].selected == true) {
              var elem = CurrentAppFactory.appCfg.main.controleCfg.filter(
                function(x) {
                  return x.type == i;
                }
              );
              if (elem.length)
                toGet.push(
                  CurrentAppFactory.getBuildedFakeCtrlReponseFtiForElasticSearch(
                    elem[0].type
                  )
                );
            }
          }

          var alreadyPushed = {};

          // build fake fti ctrl
          //console.log(r.selectGlobaladvancedFti);

          var index = FeatureTypeFactory.resources.featuretypes
            .map(function(x) {
              return x.name;
            })
            .indexOf(
              scope.apptype === 'bac'
                ? 'kis_bac_dossier_controle'
                : 'kis_anc_dossier_controle'
            );
          var fakeFti = angular.copy(
            FeatureTypeFactory.resources.featuretypes[index]
          );

          // console.log(fakeFti);

          fakeFti.attributes
            .filter(function(y) {
              // remove type qui est géré par le bloc Données des controles (elasticfilter.js ) ?
              return y;
            })
            .map(function(x) {
              x.category = 'Métadonnées';
              x.prefixedAlias = x.alias;
              x.htmlPrefixedAlias = x.alias;
            });

          if (toGet.length) {
            $q.all(toGet).then(
              function(res) {
                for (var i in res) {
                  //    var currentCtrlType =
                  res[i].attributes.map(function(att) {
                    if (!angular.isDefined(alreadyPushed[att.name])) {
                      att.typesConcernes = [res[i].ctrlType];
                      attributesFinal.push(att);
                      // ne pas push plusieurs fois la meme chose
                      alreadyPushed[att.name] = attributesFinal.length - 1;
                    } else {
                      attributesFinal[
                        alreadyPushed[att.name]
                      ].typesConcernes.push(res[i].ctrlType);
                      // concerne par tous les types selectionnes
                    }
                    // push (F01, F02, etc..) dans le prefixedAlias
                    // ne pas mettre plusieurs fois les attributs existants
                  });
                }

                attributesFinal = attributesFinal.filter(function(x) {
                  // meme attribut peut etre utilise plusieurs fois dans le controle
                  x.typesConcernes = x.typesConcernes.filter(function(
                    value,
                    index,
                    self
                  ) {
                    return self.indexOf(value) === index;
                  });

                  if (x.typesConcernes.length == toGet.length) {
                    // niet
                    x.htmlPrefixedAlias =
                      "<span class='alias'>" + x.prefixedAlias + '<span>';
                  } else {
                    var typesConcernes = x.typesConcernes
                      .map(function(x) {
                        return "<span class='ctrls'>" + x + '</span>';
                      })
                      .join('');

                    x.htmlPrefixedAlias =
                      typesConcernes +
                      "<span class='alias'>" +
                      x.prefixedAlias +
                      '<span>';
                    // x.prefixedAlias =  x.typesConcernes + x.prefixedAlias;
                  }

                  // on ne push que si present dans tous les types de controle OU rule='all'
                  return (
                    r.controle_json_filters.rule == 'all' ||
                    x.typesConcernes.length == toGet.length
                  );
                });

                scope.nbAttributsSelectionnables = attributesFinal.length;

                for (var i in attributesFinal) {
                  var toPush = attributesFinal[i];
                  //toPush.alias = "json_" + toPush.alias;
                  toPush.isCtrJsonAttribute = true;
                  fakeFti.attributes.push(toPush);
                }

                scope.fakeJsonFti = fakeFti;

                gaDomUtils.hideGlobalLoader();
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else {
            scope.fakeJsonFti = fakeFti;
          }

          $rootScope.$broadcast('setCurrentFakeJsonControle', {
            fti: fakeFti,
          });

          gaDomUtils.hideGlobalLoader();
        };

        // FINIR ICI SEMBLE FAIRE BUGGER LE CHARTDATA
        // init
        if (!angular.isDefined(scope.relation.controle_json_filters)) {
          scope.relation.controle_json_filters = {
            rule: 'common',
            types: {},
          };
        }
        // au chargement d'une requete existante, il faut recocher les attributs sélectionnés
        scope.refreshAttributsCtrlJson(scope.relation);
      },
    };
  };

  ancBacConfigurationRequeteJson.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    'gaDomUtils',
    '$q',
    'FeatureTypeFactory',
    '$rootScope',
  ];
  return ancBacConfigurationRequeteJson;
});
