'use strict';
define(function() {
  var ancTemplatesFacturation = function(
    AncAppFactory,
    BacAppFactory,
    ngDialog,
    FeatureTypeFactory,
    gaJsUtils,
    $filter,
    $q,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_templates_facturation.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
        periodesCfg: '=',
        periodeFilter: '=',
      },
      link: function(scope) {
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;
        scope.controletype = CurrentAppFactory.appCfg.main.controleCfg;

        if (!angular.isDefined(scope.periodesCfg.templates))
          scope.periodesCfg.templates = [];

        scope.typesControle = CurrentAppFactory.appCfg.main.controleCfg;
        var templateFacturationDialog, pfid;
        scope.currTemplate = {};

        scope.vidangesActives =
          scope.apptype == 'anc' &&
          AncAppFactory.appCfg.main.properties.formVidange == true;

        var dossierFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          scope.apptype == 'anc' ? 'kis_anc_dossier' : 'kis_bac_dossier'
        );

        const controleFtiName =
          scope.apptype == 'anc'
            ? 'kis_anc_dossier_controle'
            : 'kis_bac_dossier_controle';

        var controleFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          controleFtiName
        );

        var vidangeFormulaireFTI;
        if (scope.apptype == 'anc') {
          vidangeFormulaireFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            'kis_anc_vidange_formulaire'
          );
        }

        scope.choixDebiteur = [
          {
            value: 'proprietaire',
            label: 'Propriétaire',
          },
          {
            value: 'locataire',
            label: 'Occupant',
          },
          {
            value: 'demandeur',
            label: 'Demandeur',
          },
        ];

        scope.choixStatutRDV = CurrentAppFactory.getChoixStatutRDV();
        scope.choixStatutRDV.unshift({
          value: 'present',
          label: 'Présent',
        });

        /**
         * retourne le libelleDebiteur
         */
        scope.libelleDebiteur = function(label) {
          var deb = scope.choixDebiteur.filter(function(y) {
            return y.value == label;
          })[0];
          return deb ? deb.label : '';
        };

        /**
         * getElasticFilter
         */
        var getElasticFilter = function(
          fti,
          forElasticRule,
          attrname,
          guid,
          operand,
          value
        ) {
          // attribut
          var attr = fti.attributes.filter(function(x) {
            return x.name == attrname;
          })[0];

          // filtre
          var filter = {
            choice: 'rule',
            guid: guid,
            // "attr": attr,
            attr: 'attribute_to_retrieve:' + fti.name + ':' + attrname,
            showAllValues: true,
            name: attrname,
            type: attr.type,
            att: attr.alias,
            operand: operand,
          };

          // value
          if (value !== false) filter.value = value;

          // ajout des cles attributesaliases et selectedfti attendus par
          // elasticRule
          if (forElasticRule) {
            filter.selectedfti = angular.copy(fti);
            filter.attributesaliases = angular
              .copy(fti)
              .attributes.map(function(x) {
                return x.alias;
              });
          }

          return filter;
        };

        /**
         * Mise à jour de la requete elastic à la soumission du formulaire
         */
        var setElasticQuery = function() {
          if (scope.apptype == 'anc') {
            // Facturation des controles
            if (angular.isDefined(scope.currTemplate['controles'])) {
              var query = {
                user: 'root',
                relations: [
                  {
                    selectGlobaladvancedFti: controleFTI.alias,
                    filters: [
                      // jointure avec la table kis_anc_dossier
                      {
                        choice: 'relation',
                        attr: {},
                        selectedfti: 'fti_to_retrieve:kis_anc_dossier_controle',
                        choices: ['Contient'],
                        choicesdone: $filter('translate')(
                          'elastic.search.anc.contient'
                        ),
                        relation: 'REL_DOSSIER_CONTROLE',
                        filters: [],
                        alias: 'Dossier ANC',
                        selectGlobaladvancedFti: 'Dossier ANC',
                        relation_DOSSIER_CONTROLE_choosen:
                          'fti_to_retrieve:kis_anc_dossier',
                      },
                      // jointure avec le json
                      {
                        choice: 'relation',
                        attr: {},
                        selectedfti: 'fti_to_retrieve:kis_anc_dossier_controle',
                        choices: ['Contient'],
                        choicesdone: $filter('translate')(
                          'elastic.search.anc.contient'
                        ),
                        relation: 'REL_DOSSIER_CONTROLE',
                        filters: scope.currTemplate.extraCriterias
                          .filter(
                            extraCriteria =>
                              extraCriteria.filter.attr.isCtrJsonAttribute
                          )
                          .map(extraCriteria => extraCriteria.filter),
                        alias: 'controle json',
                        selectGlobaladvancedFti: 'controle json',
                        relation_DOSSIER_CONTROLE_choosen:
                          'fti_to_retrieve:kis_anc_dossier_controle_reponse',
                      },
                      // ne doit pas etre déjà facturé
                      getElasticFilter(
                        controleFTI,
                        false,
                        'statut_facture',
                        'factu_statut_facture',
                        'notEquals',
                        'facture'
                      ),
                      // type
                      getElasticFilter(
                        controleFTI,
                        false,
                        'type',
                        'factu_type_controle',
                        'include',
                        Object.keys(scope.currTemplate.controles)
                          .filter(function(k, i) {
                            return (
                              scope.currTemplate.controles[k].selected === true
                            );
                          })
                          .join(',')
                      ),
                      // date de debut et de fin (mis a jour avec le bon champ
                      // sasie/passage/avis lors de la generation des
                      // factures)
                      getElasticFilter(
                        controleFTI,
                        false,
                        'date_saisie_controle',
                        'factu_date_debut',
                        'gte',
                        false
                      ),
                      getElasticFilter(
                        controleFTI,
                        false,
                        'date_saisie_controle',
                        'factu_date_fin',
                        'lte',
                        false
                      ),
                    ],
                    jointure: true,
                  },
                ],
                jointure: [
                  {
                    type: 'master',
                    fti: 'fti_to_retrieve:kis_anc_dossier_controle',
                    filters: [
                      {
                        type: 'ANC',
                        fti: 'fti_to_retrieve:kis_anc_dossier___selected',
                        ancjointure: true,
                        jointurenmtype: 'getOnlyFirstline',
                      },
                      {
                        type: 'ANC',
                        fti:
                          'fti_to_retrieve:kis_anc_dossier_controle_reponse___selected',
                        ancjointure: true,
                        jointurenmtype: 'getOnlyFirstline',
                      },
                    ],
                  },
                ],
              };
              // champ statut
              if (scope.currTemplate.statut_rdv) {
                let statutFilter = getElasticFilter(
                  controleFTI,
                  false,
                  'statut_rdv',
                  'factu_statut_rdv',
                  'equals',
                  scope.currTemplate.statut_rdv
                );
                /**
                 * Si le statut de rdv egale 'present' , il faut inclure dans la recherche les 
                 * les controles avec le statut rdv null
                 */
                if (scope.currTemplate.statut_rdv === 'present') {
                  statutFilter.operand = 'statut_rdv_present';
                }
                query.relations[0].filters.push(statutFilter);
              }
              // champ 'est_dernier_controle_cloture'
              if (
                scope.currTemplate &&
                scope.currTemplate.parameters &&
                scope.currTemplate.parameters.annualisation &&
                scope.currTemplate.parameters.annualisation.active &&
                scope.currTemplate.parameters.annualisation.dernierControlClos
              ) {
                let estDernierCtrlFilter = getElasticFilter(
                  controleFTI,
                  false,
                  'est_dernier_controle_cloture',
                  'factu_est_dernier_controle_cloture',
                  'equals',
                  'true'
                );
                query.relations[0].filters.push(estDernierCtrlFilter);
              }              
            }

            // Facturation des vidanges
            if (angular.isDefined(scope.currTemplate['vidanges'])) {
              var query = {
                user: 'root',
                relations: [
                  {
                    selectGlobaladvancedFti: 'Vidanges',
                    filters: [
                      // jointure avec la table kis_anc_dossier
                      {
                        choice: 'relation',
                        attr: {},
                        selectedfti:
                          'fti_to_retrieve:kis_anc_vidange_formulaire',
                        choices: ['Contient'],
                        choicesdone: $filter('translate')(
                          'elastic.search.anc.contient_vidange'
                        ),
                        relation: 'REL_DOSSIER_VIDANGE',
                        filters: [],
                        alias: 'Dossier ANC',
                        selectGlobaladvancedFti: 'Dossier ANC',
                        relation_DOSSIER_VIDANGE_choosen:
                          'fti_to_retrieve:kis_anc_dossier',
                      },
                      // jointure avec le json
                      {
                        choice: 'relation',
                        attr: {},
                        selectedfti:
                          'fti_to_retrieve:kis_anc_vidange_formulaire',
                        choices: ['Contient'],
                        choicesdone: $filter('translate')(
                          'elastic.search.anc.contient_vidange'
                        ),
                        relation: 'REL_DOSSIER_CONTROLE',
                        filters: [],
                        alias: 'controle json',
                        selectGlobaladvancedFti: 'controle json',
                        relation_DOSSIER_VIDANGE_choosen:
                          'fti_to_retrieve:kis_anc_vidange_formulaire_reponse',
                      },
                      // ne doit pas etre déjà facturé
                      getElasticFilter(
                        vidangeFormulaireFTI,
                        false,
                        'statut_facture',
                        'factu_statut_facture',
                        'notEquals',
                        'facture'
                      ),

                      // date de debut et de fin (mis a jour avec le bon champ
                      // sasie/passage/avis lors de la generation des
                      // factures)
                      getElasticFilter(
                        vidangeFormulaireFTI,
                        false,
                        'date_controle',
                        'factu_date_debut',
                        'gte',
                        false
                      ),
                      getElasticFilter(
                        vidangeFormulaireFTI,
                        false,
                        'date_controle',
                        'factu_date_fin',
                        'lte',
                        false
                      ),
                    ],
                    jointure: true,
                  },
                ],
                jointure: [
                  {
                    type: 'master',
                    fti: 'fti_to_retrieve:kis_anc_vidange_formulaire',
                    filters: [
                      {
                        type: 'ANC',
                        fti: 'fti_to_retrieve:kis_anc_dossier___selected',
                        ancjointure: true,
                        jointurenmtype: 'getOnlyFirstline',
                      },
                      {
                        type: 'ANC',
                        fti:
                          'fti_to_retrieve:kis_anc_vidange_formulaire_reponse',
                        ancjointure: true,
                        jointurenmtype: 'getOnlyFirstline',
                      },
                    ],
                  },
                ],
              };
            }
          }

          if (scope.apptype == 'bac') {
            // Facturation des controles
            if (angular.isDefined(scope.currTemplate['controles'])) {
              var query = {
                user: 'root',
                relations: [
                  {
                    selectGlobaladvancedFti: controleFTI.alias,
                    filters: [
                      // jointure avec la table kis_anc_dossier
                      {
                        choice: 'relation',
                        attr: {},
                        selectedfti: 'fti_to_retrieve:kis_bac_dossier_controle',
                        choices: ['Contient'],
                        choicesdone: $filter('translate')(
                          'elastic.search.anc.contient'
                        ),
                        relation: 'REL_DOSSIER_CONTROLE',
                        filters: [],
                        alias: 'Dossier BAC',
                        selectGlobaladvancedFti: 'Dossier BAC',
                        relation_DOSSIER_CONTROLE_choosen:
                          'fti_to_retrieve:kis_bac_dossier',
                      },
                      // jointure avec le json
                      {
                        choice: 'relation',
                        attr: {},
                        selectedfti: 'fti_to_retrieve:kis_bac_dossier_controle',
                        choices: ['Contient'],
                        choicesdone: $filter('translate')(
                          'elastic.search.anc.contient'
                        ),
                        relation: 'REL_DOSSIER_CONTROLE',
                        filters: scope.currTemplate.extraCriterias
                          .filter(
                            extraCriteria =>
                              extraCriteria.filter.attr.isCtrJsonAttribute
                          )
                          .map(extraCriteria => extraCriteria.filter),
                        alias: 'controle json',
                        selectGlobaladvancedFti: 'controle json',
                        relation_DOSSIER_CONTROLE_choosen:
                          'fti_to_retrieve:kis_bac_dossier_controle_reponse',
                      },
                      // ne doit pas etre déjà facturé
                      getElasticFilter(
                        controleFTI,
                        false,
                        'statut_facture',
                        'factu_statut_facture',
                        'notEquals',
                        'facture'
                      ),
                      // type
                      getElasticFilter(
                        controleFTI,
                        false,
                        'type',
                        'factu_type_controle',
                        'include',
                        Object.keys(scope.currTemplate.controles)
                          .filter(function(k, i) {
                            return (
                              scope.currTemplate.controles[k].selected === true
                            );
                          })
                          .join(',')
                      ),
                      // date de debut et de fin (mis a jour avec le bon champ
                      // sasie/passage/avis lors de la generation des
                      // factures)
                      getElasticFilter(
                        controleFTI,
                        false,
                        'date_saisie_controle',
                        'factu_date_debut',
                        'gte',
                        false
                      ),
                      getElasticFilter(
                        controleFTI,
                        false,
                        'date_saisie_controle',
                        'factu_date_fin',
                        'lte',
                        false
                      ),
                    ],
                    jointure: true,
                  },
                ],
                jointure: [
                  {
                    type: 'master',
                    fti: 'fti_to_retrieve:kis_bac_dossier_controle',
                    filters: [
                      {
                        type: 'ANC',
                        fti: 'fti_to_retrieve:kis_bac_dossier___selected',
                        ancjointure: true,
                        jointurenmtype: 'getOnlyFirstline',
                      },
                      {
                        type: 'ANC',
                        fti:
                          'fti_to_retrieve:kis_bac_dossier_controle_reponse___selected',
                        ancjointure: true,
                        jointurenmtype: 'getOnlyFirstline',
                      },
                    ],
                  },
                ],
              };
              // champ statut de rdv 
              if (scope.currTemplate.statut_rdv) {
                let statutFilter = getElasticFilter(
                  controleFTI,
                  false,
                  'statut_rdv',
                  'factu_statut_rdv',
                  'equals',
                  scope.currTemplate.statut_rdv
                );
                /**
                 * Si le statut de rdv egale 'present' , il faut inclure dans la recherche les 
                 * les controles avec le statut rdv null
                 */
                if (scope.currTemplate.statut_rdv === 'present') {
                  statutFilter.operand = 'statut_rdv_present';
                }
                query.relations[0].filters.push(statutFilter);
              }
            }
          }

          if (angular.isDefined(query)) {
            // notion de clos
            if (
              gaJsUtils.checkNestedProperty(
                'parameters.onlyClosedCtrl',
                scope.currTemplate
              ) == true
            ) {
              query.relations[0].filters.splice(
                2,
                0,
                getElasticFilter(
                  controleFTI,
                  false,
                  'etat',
                  'factu_etat',
                  'equals',
                  'clos'
                )
              );
            }

            if (scope.currTemplate.extraCriterias.length) {
              scope.currTemplate.extraCriterias.map(function(x, index) {
                if (x.filter.guid == 'extrafactu_dossier') {
                  query.relations[0].filters[0].filters.push(
                    'extra_to_retrieve:' + index
                  );
                } else {
                  query.relations[0].filters.push('extra_to_retrieve:' + index);
                }
              });
            }
          }

          console.log('Query finale : ');
          console.log(query);
          console.log(JSON.stringify(query));
          return query;
        };

        /**
         * editTemplateFacturationDialog
         *
         * @param {*}
         *            index
         */
        let choixPeriodeDialog ;
        scope.editTemplateFacturationDialog = function (index) {
          let templateFacturation = scope.getTemplateByPeriode(scope.periodeFilter) ;            
          scope.modeleCfgTab.activeTab = 0;
          let ans = false;
          if (!index && index != 0) {
            if (
              scope.periodesCfg.periodes &&
              scope.periodesCfg.periodes.length > 1
              &&(!templateFacturation  || templateFacturation.length == 0 )
            ) {
              ans = confirm(
                "Voulez-vous copier les modèles d'une période précédente ? ."
              );
              if (ans) {
                scope.dupliquerFacturation = false;
                scope.dupliquerTemplate = true;
                choixPeriodeDialog = ngDialog.open({
                  template:
                    'js/XG/widgets/ancapp/main/views/modals/modal.choixPeriode.html',
                  className:
                    'ngdialog-theme-plain width1000 miniclose nopadding',
                  closeByDocument: false,
                  scope: scope,
                });
              } else {
                pfid = -1;
                scope.currTemplate = {
                  statut_rdv: 'present',
                  extraCriterias: [],
                  periode: angular.copy(scope.periodeFilter),
                };
              }
            } else {
              pfid = -1;
              scope.currTemplate = {
                statut_rdv: 'present',
                extraCriterias: [],
                periode: angular.copy(scope.periodeFilter),
              };
            }
          } else {
            pfid = index;
            var tpl = angular.copy(scope.periodesCfg.templates[index]);
            retrieveFiltersFromRelations(tpl);
            expandExtraCriterias(tpl.extraCriterias);
            scope.currTemplate = tpl;
            setControlAttributes();
            switch (tpl.associations.type) {
              case 'simple':
                scope.modeleCfgTab.activeTab = 0;
                break;
              case 'avance':
                scope.modeleCfgTab.activeTab = 1;
                break;
              case 'modele':
                scope.modeleCfgTab.activeTab = 2;
                break;
            }
          }
          if (index || (!index && !ans)) {
            templateFacturationDialog = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.template.facturation.html',
              className: 'ngdialog-theme-plain width1000 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
            });
          }
        };


        /**
         * getTarificationByPeriode
         * 
         * @param {*} period
         */
        scope.getTemplateByPeriode = function (period) {
          return scope.periodesCfg.templates.filter(
            (template) => template.periode == period
          );
        };

        scope.copierTarificationModele = function (periodeChoisiKey) {
          let tarificationACopier = [];
          scope.periodesCfg.templates.forEach(function (element) {
            if (element.periode == periodeChoisiKey) {
              let newTarification = angular.copy(element);
              newTarification.periode = angular.copy(scope.periodeFilter);
              tarificationACopier.push(newTarification);
            }
          });
          if (!tarificationACopier || tarificationACopier.length == 0) {
            require('toastr').warning(
              $filter('translate')('facturation.templateVide')
            );
          } else {
            tarificationACopier.forEach(function (element) {
              scope.periodesCfg.templates.push(element);
              // on a besoin dans un premier temps de trouver le nom du service 
              // de l'ancienne periode pour pouvoir ensuite trouver l'id du service
              // de la nouvelle periode
              const serviceOldPeriod = scope.periodesCfg.tarification.find(
                service => service.dolibarrId == element.associations.services);
              let serviceNom;
              if (serviceOldPeriod){
                serviceNom = serviceOldPeriod.nom
              };
              const serviceNewPeriod = scope.periodesCfg.tarification.find(
                service => serviceNom != undefined
                        && service.nom.includes(serviceNom) 
                        && service.periode == element.periode);
              if (serviceNewPeriod){
                element.associations.services = serviceNewPeriod.dolibarrId;
              }
            });
          }
          choixPeriodeDialog.close();
        };

        /**
         * Filtre de la liste des elements de facturation via filtre de periode
         * eventuel (periodeFilter) byPeriodeFilter
         */
        scope.byPeriodeFilter = function(c) {
          return (
            !angular.isDefined(scope.periodeFilter) ||
            scope.periodeFilter == c.periode
          );
        };

        /**
         * compacteExtraCriterias permet de stocker une version plus courte
         */
        var compacteExtraCriterias = function(extraCriterias) {
          if (angular.isDefined(extraCriterias)) {
            extraCriterias
              .filter(
                extraCriteria => !extraCriteria.filter.attr.isCtrJsonAttribute
              )
              .map(function(x) {
                if (x.filter) {
                  var ftiname = x.filter.selectedfti.name;
                  // reduction du fti
                  if (x.filter.selectedfti)
                    x.filter.selectedfti = 'fti_to_retrieve:' + ftiname;
                  // reduction des aliases
                  if (x.filter.attributesaliases)
                    x.filter.attributesaliases =
                      'attributesaliases_to_retrieve:' + ftiname;
                  // attribute
                  if (x.filter.attr)
                    x.filter.attr =
                      'attribute_to_retrieve:' + ftiname + ':' + x.filter.name;
                }
                return x;
              });
          }
        };

        var retrieveFiltersFromRelations = template => {
          if (template && template.elasticQuery) {
            (template.elasticQuery.relations || []).forEach(relation => {
              relation.filters.forEach(filter => {
                if (filter.choice === 'relation') {
                  template.extraCriterias = template.extraCriterias.concat(
                    (filter.filters || [])
                      .filter(
                        relationFilter => relationFilter.choice === 'rule'
                      )
                      .map(relationFilter =>
                        Object.assign({
                          fid: relationFilter.selectedfti.uid,
                          filter: Object.assign(relationFilter, {
                            selectedfti:
                              'fti_to_retrieve:' +
                              relationFilter.selectedfti.uid,
                            attr:
                              'attribute_to_retrieve:' +
                              relationFilter.attr.alias,
                          }),
                        })
                      )
                  );
                  filter.filters = filter.filters.filter(
                    relationFilter => relationFilter.choice !== 'rule'
                  );
                }
              });
            });
          }
        };

        /**
         * expandExtraCriterias permet de retrouver la version originale
         *
         * @TODO : remplacer par AncSearchFactory.unPackRequest
         * @param {*}
         *            extraCriterias
         */
        var expandExtraCriterias = function(extraCriterias) {
          if (angular.isDefined(extraCriterias)) {
            extraCriterias.map(function(x) {
              if (x.filter) {
                // recuperation du fti
                if (
                  x.filter.selectedfti &&
                  x.filter.selectedfti.indexOf('fti_to_retrieve:') !== -1
                ) {
                  console.log('filter for fti to retrieve!!!', x.filter);
                  var ftiUid = x.filter.selectedfti.split(':')[1];
                  x.filter.selectedfti = angular.copy(
                    FeatureTypeFactory.getFeatureByNameAndDatastore(
                      CurrentAppFactory.appCfg.main.datastore,
                      ftiUid
                    )
                  );
                }
                // recuperation des attributes aliases
                if (
                  x.filter.attributesaliases &&
                  x.filter.attributesaliases.indexOf(
                    'attributesaliases_to_retrieve:'
                  ) !== -1
                ) {
                  var ftiUid = x.filter.attributesaliases.split(':')[1];
                  var fti = angular.copy(
                    FeatureTypeFactory.getFeatureByNameAndDatastore(
                      CurrentAppFactory.appCfg.main.datastore,
                      ftiUid
                    )
                  );
                  x.filter.attributesaliases = fti.attributes.map(function(x) {
                    return x.alias;
                  });
                }
                // attribute
                if (
                  x.filter.attr &&
                  x.filter.attr.indexOf('attribute_to_retrieve:') !== -1
                ) {
                  var splitted = x.filter.attr.split(':');
                  var ftiUid = splitted[1];
                  var attrName = splitted[2];
                  var fti = angular.copy(
                    FeatureTypeFactory.getFeatureByNameAndDatastore(
                      CurrentAppFactory.appCfg.main.datastore,
                      ftiUid
                    )
                  );
                  x.filter.attr = (fti.attributes || []).filter(function(x) {
                    return x.name == attrName;
                  })[0];
                }
              }
              return x;
            });
          }
        };

        /**
         * saveTemplateFacturation
         */
        scope.saveTemplateFacturation = function () {
          // Vider la configuration de Annualisation , dans le k ou desactive cette option
          viderConfigurationAnnualisation();

          scope.currTemplate.elasticQuery = setElasticQuery();

          var tosave = angular.copy(scope.currTemplate);
          // compacte les parties extraCriterias et elasticQuery qui sont trop
          // longues et prennent une place folle dans la config
          compacteExtraCriterias(tosave.extraCriterias);

          tosave.extraCriterias = tosave.extraCriterias.filter(
            extraCriteria => !extraCriteria.filter.attr.isCtrJsonAttribute
          );

          if (pfid == -1) {
            scope.periodesCfg.templates.push(tosave);
          } else {
            scope.periodesCfg.templates[pfid] = tosave;
          }

          templateFacturationDialog.close();
        };
        /**
         * Vider la configuration de Annualisation , dans le k ou desactive cette option
         */
        var viderConfigurationAnnualisation = function () {
          if (
            scope.currTemplate &&
            scope.currTemplate.parameters &&
            scope.currTemplate.parameters.annualisation
          ) {
            if (!scope.currTemplate.parameters.annualisation.active) {
              scope.currTemplate.parameters.annualisation = {};
            } else {
              if (
                !scope.currTemplate.parameters.annualisation.historiqueAnnuite
              ) {
                scope.currTemplate.parameters.annualisation.historiqueAnnuite = false;
              }
              if (
                !scope.currTemplate.parameters.annualisation.dernierControlClos
              ) {
                scope.currTemplate.parameters.annualisation.dernierControlClos = false;
              }
            }
          }
        };

        /**
         * supprimerFacturationTemplate
         *
         * @param {*}
         *            index
         */
        scope.supprimerFacturationTemplate = function(index) {
          var r = confirm('Êtes-vous certain de vouloir supprimer ce modèle ?');
          if (r == true) {
            scope.periodesCfg.templates.splice(index, 1);
          }
        };

        // ---------------------------------------
        // Criteres supplementaires element de facturation
        // ---------------------------------------

        var critereCtrl;
        var critereFiliere;
        if (scope.apptype == 'bac') {
          critereCtrl = {
            key: 'kis_bac_dossier_controle',
            label: 'Instructions',
          };
          critereFiliere = {
            key: 'kis_anc_dossier_filiere',
            label: 'Filière des dossiers',
          };
        } else {
          critereCtrl = {
            key: 'kis_anc_dossier_controle',
            label: 'Contrôle',
          };
          critereFiliere = {
            key: 'kis_bac_dossier_filiere',
            label: 'Filière des dossiers',
          };
        }

        scope.criteriasOrigines = [
          {
            key: 'kis_anc_dossier',
            label: 'Dossier',
          },
          critereCtrl,
        ]
          .map(featureType =>
            Object.assign(featureType, { category: 'Général' })
          )
          .concat(
            FeatureTypeFactory.resources.featuretypes
              .filter(
                featureType =>
                  featureType.name.startsWith('kis_anc_ef_') &&
                  featureType.inElasticSearch &&
                  featureType.attributes.length
              )
              .map(featureType => ({
                key: featureType.name,
                label: featureType.alias,
                category: 'Éléments de filière',
              }))
          );
        scope.controleUid =
          scope.apptype == 'bac'
            ? 'kis_bac_dossier_controle'
            : 'kis_anc_dossier_controle';
        scope.availableFields = {
          dossier: FeatureTypeFactory.getFeatureByNameAndDatastore(
            CurrentAppFactory.appCfg.main.datastore,
            'kis_anc_dossier'
          ).attributes,
          controle: FeatureTypeFactory.getFeatureByNameAndDatastore(
            CurrentAppFactory.appCfg.main.datastore,
            scope.controleUid
          ).attributes,
        };

        console.log('Facturation featuretype resource');

        var isOmegaFactu = false;
        if (
          CurrentAppFactory.appCfg.main.properties.dolibarr.facturationTierce
            .active &&
          CurrentAppFactory.appCfg.main.properties.dolibarr.facturationTierce
            .interface.type == 'omega'
        ) {
          isOmegaFactu = true;
        }

        scope.modeleCfgTab = [
          {
            title: 'Configuration simple',
          },
        ];

        if (!isOmegaFactu) {
          scope.modeleCfgTab.push(
            {
              title: 'Configuration avancée',
            },
            {
              title: 'Configuration prédéfinie',
            }
          );
        }

        scope.configurationsPredefinies = [];
        /**
         * setAssociationsType
         */
        scope.setAssociationsType = function(type) {
          if (angular.isUndefined(scope.currTemplate.associations))
            scope.currTemplate.associations = {};

          scope.currTemplate.associations.type = type;
          if (type == 'simple') {
            delete scope.currTemplate.associations.modele;
            delete scope.currTemplate.associations.configuration;
          }
          if (type == 'modele') {
            delete scope.currTemplate.associations.services;
            delete scope.currTemplate.associations.configuration;
          }
          if (type == 'avance') {
            delete scope.currTemplate.associations.modele;
            delete scope.currTemplate.associations.services;
          }
        };

        /**
         * canSaveTemplateFacturation wheteher you can save the template
         */
        scope.canSaveTemplateFacturation = function() {
          let ct = scope.currTemplate;
          let hasControles =
            ct.controles &&
            Object.keys(ct.controles).filter(function(k, i) {
              return ct.controles[k].selected === true;
            }).length;

          if (scope.vidangesActives) {
            var hasVidanges =
              ct.vidanges &&
              Object.keys(ct.vidanges).filter(function(k, i) {
                return ct.vidanges[k].selected === true;
              }).length;
          }

          return (
            gaJsUtils.checkNestedProperty('associations.type', ct) !== false &&
            ct.periode &&
            ct.nom &&
            ct.statut_rdv &&
            ct.debiteur &&
            (hasControles || hasVidanges) &&
            (!ct.parameters ||
              !ct.parameters.annualisation ||
              !ct.parameters.annualisation.active ||
              (ct.parameters.annualisation.active &&
                ct.parameters.annualisation.annuite))
          );
        };

        /**
         * resetTypeCtrlVidange Permet de reset les vidanges selectionnees quand
         * on choisit un controle et inversement
         *
         * @param {*}
         *            type
         */
        scope.resetTypeCtrlVidange = function(type) {
          delete scope.currTemplate[type];
          // quand vidages est choisi
          if (type == 'controles') {
            scope.currTemplate.statut_rdv = 'present';
            scope.currTemplate.debiteur = 'proprietaire';
          }
        };
        scope.forceTypeCtrlVidange = function(type) {
          if (
            type in (scope.currTemplate.controles || []) &&
            scope.currTemplate.controles[type].selected == false
          ) {
            delete scope.currTemplate.controles[type];
          }
          $timeout(() => {
            setControlAttributes();
          });
        };
        setControlAttributes();

        scope.restrictionDebiteurs = function(x) {
          if (angular.isDefined(scope.currTemplate['vidanges'])) {
            return x.value != 'demandeur';
          }
          return true;
        };

        /**
         * addExtraCriteria
         *
         */
        scope.addExtraCriteria = function() {
          if(!scope.currTemplate.extraCriterias){
            scope.currTemplate.extraCriterias = [];
          }
          scope.currTemplate.extraCriterias.push({
            fid: 'kis_anc_dossier',
            filter: getElasticFilter(
              dossierFTI,
              true,
              'ref_dossier',
              'extrafactu_dossier',
              'equals'
            ),
          });
        };

        scope.resetCriteria = function(crit, index) {
          crit.filter.group = false;
          if (crit.fid == 'kis_anc_dossier') {
            crit.filter = getElasticFilter(
              dossierFTI,
              true,
              'ref_dossier',
              'extrafactu_dossier',
              'equals'
            );
          } else if (crit.fid == scope.controleUid) {
            crit.filter = getElasticFilter(
              controleFTI,
              true,
              'agent',
              'extrafactu_controle',
              'equals'
            );
            crit.filter.group = true;
            setControlAttributes();
          } else {
            const feature = FeatureTypeFactory.resources.featuretypes.find(
              featureType => featureType.name === crit.fid
            );
            crit.filter = getElasticFilter(
              feature,
              true,
              (feature.attributes[0] || {}).name,
              'extrafactu_' + crit.fid,
              'equals'
            );
          }
        };
        /**
         * removeExtraCriteria
         */
        scope.removeExtraCriteria = function(index) {
          scope.currTemplate.extraCriterias.splice(index, 1);
        };

        /**
         * getControlesConcernesParTemplate
         *
         * @param {*}
         *            x
         */
        scope.getControlesConcernesParTemplate = function(x) {
          if (!x.controles) {
            if (x.vidanges) return 'Vidanges';
            return 'aucun';
          }
          return Object.keys(x.controles)
            .filter(function(k, i) {
              return x.controles[k].selected === true;
            })
            .join(', ');
        };

        /**
         * displayServiceForPicker
         */
        scope.displayServiceForPicker = function(x) {
          var txt = '<b>' + x.nom + '</b>';
          if (x.description) txt += '<br/><small>' + x.description + '</small>';
          return txt;
        };
        /**
         * displayServiceForCfg
         *
         * @param {*}
         *            x
         */
        scope.displayServiceForCfg = function(x) {
          var txt = x.nom;
          if (x.identifiant) txt = x.identifiant + ' ' + x.nom;
          return txt;
        };

        /** configuration avancee * */
        /**
         * addServiceToConfiguration
         */
        scope.addServiceToConfiguration = function() {
          if (
            angular.isUndefined(scope.currTemplate.associations.configuration)
          ) {
            scope.currTemplate.associations.configuration = [];
          }
          scope.currTemplate.associations.configuration.push({});
        };
        /**
         * deleteServiceFromConfiguration
         *
         * @param {*}
         *            index
         */
        scope.deleteServiceFromConfiguration = function(index) {
          scope.currTemplate.associations.configuration.splice(index, 1);
        };
        /**
         * moveItem
         *
         * @param {*}
         *            index
         * @param {*}
         *            direction
         */
        scope.moveItem = function(index, direction) {
          if (
            (index == 0 && direction == 'up') ||
            (index ==
              scope.currTemplate.associations.configuration.length - 1 &&
              direction == 'down')
          )
            return false;
          var newIndex = direction == 'up' ? index - 1 : index + 1;
          scope.currTemplate.associations.configuration.splice(
            index,
            0,
            scope.currTemplate.associations.configuration.splice(newIndex, 1)[0]
          );
        };
        /**
         * setMajoration
         *
         * @param {*}
         *            item
         */
        scope.setMajoration = function(item) {
          if (item.majoration) {
            delete item.majoration;
          } else {
            item.majoration = [{}];
          }
        };

        scope.addServiceToMajoration = function(majoration) {
          if (!angular.isDefined(majoration.services)) majoration.services = [];
          majoration.services.push({});
        };
        scope.deleteServiceFromMajoration = function(majoration, index) {
          majoration.services.splice(index, 1);
        };
        function setControlAttributes() {
          let promises = Object.keys(scope.currTemplate.controles || {})
            .filter(
              controlName => scope.currTemplate.controles[controlName].selected
            )
            .map(controlName =>
              CurrentAppFactory.getBuildedFakeCtrlReponseFtiForElasticSearch(
                controlName
              )
            );
          const isControle = (Array.isArray(scope.currTemplate.extraCriterias)
             && scope.currTemplate.extraCriterias.length > 0
             && scope.currTemplate.extraCriterias[0].fid === scope.controleUid);
          if (isControle) {
            promises.push(FeatureTypeFactory.getFeatureByUid(
                scope.apptype == 'bac' ? 'kis_bac_listes_deroulantes_controles': 'kis_anc_listes_deroulantes_controles')
                );
            }
          $q.all(promises).then((results = []) => {
            results = (Array.isArray(results) && results) || [];
            const intersectedAttributes = {};
            const attrs = {};
            // put data from kis_anc_listes_deroulantes_controles in a separate variable
            const listesDeroulantesControles = isControle ? results.pop(): undefined;
            results.forEach((control, index) => {
              (control.attributes || []).forEach(attribute => {
                intersectedAttributes[attribute.name] =
                  intersectedAttributes[attribute.name] || [];
                if (
                  intersectedAttributes[attribute.name].indexOf(index) === -1
                ) {
                  intersectedAttributes[attribute.name].push(index);
                  attrs[attribute.name] = attribute;
                }
              });
            });
            if (
              scope.currTemplate &&
              Array.isArray(scope.currTemplate.extraCriterias)
            ) {
              scope.currTemplate.extraCriterias.forEach(extraCriteria => {
                if (extraCriteria.fid === scope.controleUid) {
                  extraCriteria.filter.selectedfti = Object.assign(
                    angular.copy(controleFTI),
                    {
                      attributes: angular
                        .copy(controleFTI.attributes)
                        .map(attribute =>
                          Object.assign(attribute, {
                            category: 'Metadonees',
                            prefixedAlias: attribute.alias,
                          })
                        )
                        .concat(
                          Object.keys(attrs)
                            .filter(
                              attr =>
                                intersectedAttributes[attr].length ===
                                results.length
                            )
                            .map(attr =>
                              Object.assign(attrs[attr], {
                                isCtrJsonAttribute: true,
                              })
                            )
                        ),
                    }
                  );

                  // le marquer comme fake fti pour éviter qu'il soit recharger et effacer
                  extraCriteria.filter.selectedfti.isFakeFti = true;
                  // supprimer les duplication de "date_prochain_controle_preconise"
                  const attributDateProchainControle = extraCriteria.filter.selectedfti.attributes.find(
                      it => it.name === "date_prochain_controle_preconise")
                  extraCriteria.filter.selectedfti.attributes = extraCriteria.filter.selectedfti.attributes.filter(
                    it => it.name != "date_prochain_controle_preconise")
                  extraCriteria.filter.selectedfti.attributes.push(attributDateProchainControle);

                  // alimenter les restrictions des champs du controle
                  for (let attributeWithRestriction of listesDeroulantesControles.attributes) {
                    let indexOfAttributeInFakeFti = extraCriteria.filter.selectedfti.attributes.findIndex(
                      attributeInFakeFti => 
                        attributeInFakeFti.name.indexOf(attributeWithRestriction.name) > -1 
                        && attributeInFakeFti.alias===attributeWithRestriction.alias
                      );
                    // if we didn't find the index by name we search by alias
                    if (indexOfAttributeInFakeFti < 0) {
                      indexOfAttributeInFakeFti = extraCriteria.filter.selectedfti.attributes.findIndex(
                        attributeInFakeFti => {
                          const pathOfAttribute = attributeInFakeFti.name.split('.');
                          if (Array.isArray(pathOfAttribute) && pathOfAttribute.length > 0) {
                            const attributeName = pathOfAttribute.pop();
                            return attributeWithRestriction.name === attributeName;
                          }
                          // attributeInFakeFti.alias.toLowerCase() === attributeWithRestriction.alias.toLowerCase()
                          return false;
                        });
                    }
                    if (indexOfAttributeInFakeFti > -1) {
                      extraCriteria.filter.selectedfti.attributes[indexOfAttributeInFakeFti].restrictions = attributeWithRestriction.restrictions;
                    }
                  }
                  extraCriteria.filter.attributesaliases = extraCriteria.filter.selectedfti.attributes.map(
                    attribute => attribute.alias
                  );
                }
              });
            }
          });
        }
      },
    };
  };

  ancTemplatesFacturation.$inject = [
    'AncAppFactory',
    'BacAppFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'gaJsUtils',
    '$filter',
    '$q',
    '$timeout',
  ];
  return ancTemplatesFacturation;
});
