'use strict';
define(function() {
  var ancSubventionLogic = function(
    $compile,
    $filter,
    AncAppFactory,
    $timeout,
    FeatureTypeFactory,
    QueryFactory,
    ngDialog,
    EditFactory,
    $rootScope,
    gaJsUtils
  ) {
    return {
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.display = {
          subvention: 'reduced',
        };
        var getEntreprisevData = function() {
          scope.vdata = {};
          scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            AncAppFactory.appCfg.main.entreprisesCfg.emplacement
          );
          QueryFactory.get(
            scope.entreprisesFti.uid,
            scope.currentBranch.subvention.properties.id_entreprise
          ).then(function(res) {
            scope.vdata.subvention = angular.isDefined(res.data.features[0])
              ? res.data.features[0].properties
              : null;
          });
        };
        getEntreprisevData();
        /* -------------------------------------------------------------------------
         * ENTREPRISE PICKER
         */
        var pickInstallateurDialog;
        scope.prePickInstallateur = function(type) {
          if (angular.isUndefined(scope.entreprisesFti)) {
            scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
              AncAppFactory.appCfg.main.datastore,
              scope.entreprisesCfg.emplacement
            );
          }

          scope.displayAttributesEntreprise = [];
          scope.entreprisesFti.attributes.forEach(function(att) {
            if (
              ~[
                'nom',
                'type',
                'siret',
                'num_tel',
                'num_port',
                'fax',
                'email',
                'adresse_num_rue',
                'adresse_num_rue_extra',
                'adresse_rue',
                'adresse_ville',
                'adresse_cp',
                'adresse_bp',
                'adresse_pays',
                'adresse_batiment',
                'adresse_appt',
                'adresse_etage',
                'adresse_escalier',
                'adresse_complement',
                'actif',
              ].indexOf(att.name)
            ) {
              if (att.name === 'type') {
                scope.displayAttributesEntreprise.splice(0, 0, att);
              } else {
                scope.displayAttributesEntreprise.push(att);
              }
            }
          });

          scope.typeEntreprise = type;
          scope.selectEntrepriseFilter = 'type =';
          if (type == 'organismeFinanceur') scope.selectEntrepriseFilter += '9';

          // seulement les entreprises actives
          if (typeof userAndroid !== 'undefined')
            scope.selectEntrepriseFilter +=
              " AND actif = 'true' AND nom IS NOT NULL ";
          else {
            scope.selectEntrepriseFilter +=
              ' AND actif = true AND nom IS NOT NULL ';
          }

          pickInstallateurDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/controle/modals/modal.pick.entreprise.html',
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /*
         * Ajouter une entreprise
         */
        var addEntrepriseDialog;
        scope.ouvrirEntrepriseDialog = function(typeEntreprise) {
          scope.type = typeEntreprise;
          scope.currentEntreprise = {
            properties: {
              type: typeEntreprise,
              actif: true,
            },
          };
          scope.forceType = true;
          scope.forceActif = true;

          addEntrepriseDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.entreprise.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.saveEntreprise = function() {
          var featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };

          featureCollection.features.push({
            type: 'Feature',
            properties: scope.currentEntreprise.properties,
          });
          EditFactory.add(scope.entreprisesFti.uid, featureCollection).then(
            function(res) {
              require('toastr').success('Enregistré', '', {
                positionClass: 'toast-bottom-left',
              });

              scope.currentBranch.subvention.properties.id_entreprise =
                res.data.create['0'].id;

              addEntrepriseDialog.close();
            }
          );

          // Si subvention
          if (scope.currentEntreprise.properties.type === '9')
            scope.vdata.subvention = scope.currentEntreprise.properties;
        };

        /*
         * Changement entreprise
         */
        scope.entreprisesCfg = AncAppFactory.appCfg.main.entreprisesCfg;

        if (scope.entreprisesCfg) {
          scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            scope.entreprisesCfg.emplacement
          );
        }

        scope.getInfosEntreprise = function(entreprise) {
          if (scope.typeEntreprise === 'organismeFinanceur') {
            scope.vdata.subvention = entreprise[0].properties;
            scope.currentBranch.subvention.properties.id_entreprise =
              entreprise[0].id;
          }

          pickInstallateurDialog.close();
        };

        /**
         * Afficher/cacher les informations de l'entreprise
         */

        scope.toggleDisplayEntreprise = function(type) {
          if (type === 'organismeFinanceur') {
            scope.display.subvention =
              scope.display.subvention == 'full' ? 'reduced' : 'full';
          }
        };

        /**
         * entrepriseNotSet
         */
        scope.entrepriseNotSet = function(type) {
          if (type == 'organismeFinanceur') {
            return !angular.isDefined(scope.vdata.subvention);
          }
        };
        scope.$on('refreshSubventionTree', function(v, i) {
          scope.currentBranch.subvention = i.branch.subvention;
          getEntreprisevData();
        });

        /**
         * unlinkEntreprise
         */

        scope.unlinkEntreprise = function(type) {
          if (
            type == 'organismeFinanceur' &&
            angular.isDefined(scope.vdata.subvention)
          )
            delete scope.vdata.subvention;
          if (
            angular.isDefined(scope.display.subvention) &&
            scope.display.subvention === 'full'
          )
            scope.display.subvention = 'reduced';
          if (
            angular.isDefined(scope.currentBranch.subvention) &&
            angular.isDefined(scope.currentBranch.subvention.properties)
          )
            scope.currentBranch.subvention.properties.id_entreprise = null;
        };

        /**
         * sauvegarde formulaire de vidange
         */
        scope.saveSubventionDetail = function() {
          AncAppFactory.updateSubvention(scope.currentBranch.subvention).then(
            function() {
              require('toastr').success('Mise à jour', '', {
                positionClass: 'toast-bottom-left',
              });
            },
            function() {
              require('toastr').error('Echec de mise à jour', '', {
                positionClass: 'toast-bottom-left',
              });
            }
          );
        };
      },
    };
  };

  ancSubventionLogic.$inject = [
    '$compile',
    '$filter',
    'AncAppFactory',
    '$timeout',
    'FeatureTypeFactory',
    'QueryFactory',
    'ngDialog',
    'EditFactory',
    '$rootScope',
    'gaJsUtils',
  ];
  return ancSubventionLogic;
});
