'use strict';
define(function() {
  var ancOccupantControle = function(
    FeatureTypeFactory,
    AncAppFactory,
    BacAppFactory,
    ngDialog,
    gaDomUtils,
    FeatureHistoryFactory,
    $rootScope,
    $filter,
    CommonFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_occupant_controle.html',
      restrict: 'AE',
      scope: {
        currentReport: '=',
        data: '=',
        apptype: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        var apptype = angular.isDefined(attrs.apptype) ? attrs.apptype : 'anc';
        var CurrentAppFactory =
          apptype == 'anc' ? AncAppFactory : BacAppFactory;

        /*
         *add locataire depuis proprietaire
         */
        var pickPersDialog;
        scope.setPropAsOccupant = function() {
          if (scope.currentReport.properties.proprietaires.length === 1) {
            scope.getInfosPersonne(
              scope.currentReport.properties.proprietaires[0].id
            );
            gaDomUtils.showGlobalLoader();
          } else {
            scope.pickedProprietaire = {};
            pickPersDialog = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/controle/modals/modal.pick.proprietaire.html',
              className: 'ngdialog-theme-plain width600 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
            });
          }
        };

        /*
         * Récup info du locataire
         */
        scope.getInfosPersonne = function(id) {
          CurrentAppFactory.addpersonnetodossier(
            'locataires',
            scope.currentReport.id,
            id
          ).then(
            function(res) {
              if (res.data.features) {
                const locataire = CommonFactory.createPersonFromFirstFeature(res.data.features);

                scope.data.info_generales.locataire =
                  res.data.features[0].properties;
                $rootScope.$broadcast('addPropAsLoc', locataire);

                gaDomUtils.hideGlobalLoader();

                require('toastr').success('Personne associée au dossier', '', {
                  positionClass: 'toast-bottom-left',
                });

                if (pickPersDialog) pickPersDialog.close();

                openHistoriqueLoc();
              } else {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(
                  'Echec de récupération de la personne '
                );
              }
            },
            function(res) {
              if (pickPersDialog) pickPersDialog.close();
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        var modalHistorique;
        var openHistoriqueLoc = function() {
          AncAppFactory.gethistopersonnesdossier(
            'locataires',
            scope.currentReport.id
          ).then(function(res) {
            if (res) {
              scope.historiqueLoc = res.data.filter(function(feat) {
                return feat.feature.properties.courant == true;
              });

              modalHistorique = ngDialog.open({
                template:
                  'js/XG/widgets/ancapp/main/views/controle/modals/modal.occupant_controle.historique.html',
                className: 'ngdialog-theme-plain width600 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
              });
            }
          });
        };

        /*
         * HISTORIQUE
         */

        scope.currentEditHisto = {};
        scope.edithisto = function(histo, index) {
          scope.currentEditHisto[index] = true;
        };

        scope.closehisto = function(index) {
          delete scope.currentEditHisto[index];
        };

        scope.updatehisto = function(histo, index) {
          var removePersonFromDossier = false;
          histo.feature.properties.debut = formatDate(
            histo.feature.properties.debut
          );
          if (histo.feature.properties.fin) {
            histo.feature.properties.fin = formatDate(
              histo.feature.properties.fin
            );
            if (histo.feature.properties.courant == true) {
              removePersonFromDossier = true;
              histo.feature.properties.courant = false;
            }
          }

          delete scope.currentEditHisto[index];
          var type = histo.feature.id;

          if (histo.feature.id.indexOf('locataire') != -1) type = 'locataires';

          var FeatureCollection = {
            type: 'FeatureCollection',
            features: [histo.feature],
          };

          gaDomUtils.showGlobalLoader();
          CurrentAppFactory.updatepersonhistory(FeatureCollection, type).then(
            function(res) {
              $rootScope.$broadcast('refreshDossierPersonne');
              $rootScope.$broadcast(
                'refreshDatePersonne',
                histo.feature.properties.id_personne
              );
              gaDomUtils.hideGlobalLoader();

              if (modalHistorique) modalHistorique.close();
            },
            function(res) {
              if (modalHistorique) modalHistorique.close();
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        var formatDate = function(dateSource) {
          var date;
          if (dateSource) {
            date = moment(dateSource);
            date = date.toISOString();
            date = $filter('date')(date, 'yyyy-MM-ddTHH:mm:ss.sssZ');
          }
          return date;
        };
      },
    };
  };

  ancOccupantControle.$inject = [
    'FeatureTypeFactory',
    'AncAppFactory',
    'BacAppFactory',
    'ngDialog',
    'gaDomUtils',
    'FeatureHistoryFactory',
    '$rootScope',
    '$filter',
    'CommonFactory'
  ];
  return ancOccupantControle;
});
