'use strict';
define(function() {
  var ancElementFiliere = function(
    FeatureTypeFactory,
    AncAppFactory,
    QueryFactory,
    EditFactory,
    gaDomUtils,
    $rootScope,
    $timeout,
    ngDialog,
    gaJsUtils,
    ancBacTools
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_element_filiere.html',
      restrict: 'EA',
      scope: {
        idFiliere: '=?',
        featureUid: '=', // element filiere featuretypeinfo uid
        elementFiliereData: '=?', // elementFiliereData (feature de la table
        // de relation entre filiere et element :
        // kis_anc_dossier_filiere_element),
        element: '=?',
        typeControle: '=?',
        typeControleNom: '=?',
        controleClos: '=?',
        vidanges: '=?',
        controleCommentConfig: '=?',
        affichageConfig: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        // permet de deployer indivuellement un element réduit (dans controle)
        scope.selfExpanded = { v: 0 };

        var toggleControleEfDisplayMode = $rootScope.$on(
          'toggleControleEfDisplayMode',
          function(event, data) {
            if (data.mode == 'reduced') {
              scope.selfExpanded = { v: 0 };
            }
          }
        );

        if (angular.isUndefined(scope.element)) scope.element = {};

        if (angular.isUndefined(scope.typeControle)) {
          scope.typeControle = false;
        }

        if (angular.isDefined(scope.vidanges) && scope.vidanges != false) {
          console.log(scope.vidanges);
        }

        if (angular.isDefined(scope.controleCommentConfig))
          console.log(scope.controleCommentConfig);

        // v2 utilisation des templates (si existante).
        scope.template = false;

        var elementHasComment = function() {
          if (
            gaJsUtils.checkNestedProperty(
              'controleCommentConfig.commentaires.' + scope.fti.name,
              scope
            )
          ) {
            if (
              Object.keys(
                scope.controleCommentConfig.commentaires[scope.fti.name]
              ).length > 0
            )
              return true;
          }
          return false;
        };

        scope.toggleAncEf = {
          v: true,
        };

        // Réactiver modification des éléments de filières si réouverture du
        // contrôle
        $rootScope.$on('reopenControle', function(event) {
          scope.toggleAncEf.v = false;
          $timeout(function() {
            scope.toggleAncEf.v = true;
          });
        });

        // var checkForCommentaries = false;
        // if(angular.isDefined(scope.fti))
        // checkForCommentaries = elementHasComment();

        /**
         * creation de l'objet fieldData passé aux form-field Notamment utilisé
         * pour transformer les oui/non/ne sait pas en radioboxes
         */
        scope.getAttrFieldData = function(attr) {
          var obj = { disabled: scope.controleClos };

          if (attr.restrictions.length) {
            if (angular.isDefined(attr.restrictions[0].listofValues)) {
              // force le sort par odre alphabetique
              obj.config = {
                sort: {
                  type: 'alpha',
                },
              };

              if (Object.keys(attr.restrictions[0].listofValues).length == 3) {
                if (
                  attr.restrictions[0].listofValues[0] == 'Non' &&
                  attr.restrictions[0].listofValues[1] == 'Oui' &&
                  attr.restrictions[0].listofValues[3] == '?'
                ) {
                  obj.inputcfg = 'listvalueEfAnc';

                  // Oui / Non / ?
                  obj.config.sort.order = 'DESC';
                }
              }
            }
          }

          if (
            elementHasComment() &&
            angular.isDefined(attr) &&
            attr.type == 'java.lang.String' &&
            attr.size > 250
          ) {
            // checkIfHasComment
            if (
              angular.isDefined(
                scope.controleCommentConfig.commentaires[scope.fti.name][
                  attr.name
                ]
              )
            ) {
              if (
                scope.controleCommentConfig.commentaires[scope.fti.name][
                  attr.name
                ].length > 0
              )
                obj.commentaires =
                  scope.controleCommentConfig.commentaires[scope.fti.name][
                    attr.name
                  ];
            }
          }

          return obj;
        };

        /*
         * Reglementaire ANC
         */
        scope.pickedReglementaire = { v: '' };
        var getReglementaire = function() {
          AncAppFactory.getreglementaire(scope.fti.name).then(function(res) {
            scope.modelesReglementaires = res.data.elements;
            scope.modelesReglementairesNames = res.data.elements.map(function(
              x
            ) {
              return x.name;
            });
          });
        };

        /**
         * /** formatTplAtt Renvoie l'alias de l'attribut dont a que le nom dans
         * la template
         *
         * @param gd
         * @returns {*}
         */
        var formatTplAtt = function(gd) {
          if (gd) {
            var att = scope.fti.attributes.filter(function(a) {
              return a.name == gd;
            });
            // console.log(att[0].alias);
            if (!att.length) return;
            gd = {
              name: gd,
              alias: att[0].alias,
            };
            // console.log(gd);
          }
          return gd;
        };

        /**
         * check template and set it if existing
         */
        var setTemplate = function() {
          scope.specificTemplate = false;
          scope.showExpand = true;

          if (
            angular.isDefined(scope.elementFiliereData) &&
            angular.isDefined(scope.elementFiliereData.properties.typeControle)
          ) {
            scope.typeControle =
              scope.elementFiliereData.properties.typeControle;
            scope.showExpand = false;
          }

          // seulement dans le cas des controles
          if (!scope.typeControle || !angular.isDefined(scope.fti)) return;

          // retrieve cfg
          var tplz = angular.copy(AncAppFactory.getElementsFiliereTemplates());

          if (angular.isDefined(tplz[scope.fti.uid])) {
            let typeControl = '';
            let cfg;
            // retrieve aliases
            if ($rootScope.typeOfControl !== undefined) {
              typeControl = $rootScope.typeOfControl;
            } else if (
              angular.isDefined(
                scope.elementFiliereData.properties.typeControle
              )
            ) {
              typeControl = scope.elementFiliereData.properties.typeControle;
            }
            //-- Transformer le FO3_mutation en FO3 et le FO4_mutation en FO4
            //-- pour utiliser le même modèle de filiére
            //-- dans le cas de la vente que dans le cas du contrôle normal.
            if (typeControl.substr(3) == '_mutation')
              typeControl = typeControl.substr(0, 3);
            cfg = tplz[scope.fti.uid][typeControl];

            if (cfg) {
              var hasItems = false;

              cfg.map(function(grp) {
                grp.items.map(function(item) {
                  if (item.gauche) {
                    hasItems = true;
                    item.gauche = formatTplAtt(item.gauche);
                  }
                  if (item.droite) {
                    hasItems = true;
                    item.droite = formatTplAtt(item.droite);
                  }
                });
              });

              cfg.hasOneColumn = false;

              if (
                AncAppFactory.appCfg.main.properties
                  .elementsFiliereDisplayMode &&
                AncAppFactory.appCfg.main.properties.elementsFiliereDisplayMode[
                  scope.fti.uid
                ] !== undefined &&
                AncAppFactory.appCfg.main.properties.elementsFiliereDisplayMode[
                  scope.fti.uid
                ][typeControl] !== undefined
              ) {
                cfg.hasOneColumn =
                  AncAppFactory.appCfg.main.properties.elementsFiliereDisplayMode[
                    scope.fti.uid
                  ][typeControl];
              }

              if (hasItems) {
                scope.specificTemplate = cfg;
              }
            }
          }
        };

        scope.resetModelButton = false;

        scope.hasProperties = groupe =>
          groupe.items.find(
            currentItem => currentItem.gauche || currentItem.droite
          );

        /**
         * fillFromModele
         *
         * @param modele
         */
        scope.fillFromModele = function(modele) {
          console.log(modele);

          var pickedReglementaire;
          scope.modelesReglementaires.forEach(function(v) {
            if (v.name == scope.pickedReglementaire.v) {
              pickedReglementaire = v;
            }
          });

          var attributeReglementaire = [];
          var checkRestrict = [];
          var toCompare = [];

          Object.keys(pickedReglementaire.properties).forEach(function(x) {
            attributeReglementaire.push(x);
          });

          // retrieve ftid from name
          if (angular.isUndefined(scope.featureUid))
            scope.featureUid = scope.fti.uid;

          var modelefti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            scope.featureUid
          );

          var fti = angular.copy(modelefti);
          attributeReglementaire.forEach(function(attReg) {
            modelefti.attributes.forEach(function(attFti, i) {
              if (
                attFti.name == attReg &&
                (attFti.name != 'id_filiere' || attFti.name != 'filiere_active')
              ) {
                checkRestrict.push(i);
              }
            });
          });

          checkRestrict.forEach(function(i) {
            if (modelefti.attributes[i].restrictions.length > 0) {
              toCompare.push(fti.attributes[i]);
            }
          });

          toCompare.forEach(function(attFti, i) {
            Object.keys(attFti.restrictions[0].listofValues).forEach(function(
              att
            ) {
              var valueToCompare = attFti.restrictions[0].listofValues[att];

              if (
                gaJsUtils.slugify(valueToCompare) ==
                gaJsUtils.slugify(pickedReglementaire.properties[attFti.name])
              ) {
                pickedReglementaire.properties[attFti.name] = att;
              } else {
                console.log(pickedReglementaire.properties[attFti.name]);
                delete attFti.restrictions[0].listofValues[att];
              }
            });

            if (angular.equals(attFti.restrictions[0].listofValues, {})) {
              delete pickedReglementaire.properties[attFti.name];
            }
          });

          if (pickedReglementaire && pickedReglementaire.properties) {
            for (var i in pickedReglementaire.properties) {
              scope.element.properties[i] = pickedReglementaire.properties[i];
            }
          }
          scope.resetModelButton = true;
        };

        /**
         * remove Modele
         */
        scope.removeModele = function() {
          scope.resetModelButton = false;
          var attsElement = Object.keys(scope.element.properties);
          for (var i = 0; i < attsElement.length; i++) {
            if (
              scope.element.properties[attsElement[i]] &&
              scope.element.properties[attsElement[i]] != null
            ) {
              if (typeof scope.element.properties[attsElement[i]] == 'string') {
                scope.element.properties[attsElement[i]] = '';
              } else {
                scope.element.properties[attsElement[i]] = null;
              }
            }
          }
          scope.pickedReglementaire.v = '';
        };

        scope.attrDatas = {};
        var setAttrsData = function() {
          for (var i in scope.fti.attributes) {
            scope.attrDatas[scope.fti.attributes[i].name] =
              scope.fti.attributes[i];
          }
        };

        // receive type of control FO1, FO2 etc
        scope.$on('typeOfControl', function(event, data) {
          $rootScope.typeOfControl = data;
        });

        // new element filiere
        var watchfeatureUid = scope.$watch('featureUid', function(uid) {
          if (angular.isUndefined(uid)) return;
          scope.fti = FeatureTypeFactory.getFeatureByUid(uid);
          if (scope.fti != null) {
            getReglementaire();
            setAttrsData();

            if ($rootScope.typeOfControl !== undefined) {
              if ($rootScope.typeOfControl == 'FO1') scope.typeControle = 'FO1';
              else scope.typeControle = true;
              setTemplate();
            }
          }
        });

        // element filiere existant
        var watchelementFiliereData = scope.$watch(
          'elementFiliereData',
          function(data) {
            if (angular.isUndefined(data)) return;
            scope.fti = FeatureTypeFactory.getFeatureByUid(
              data.properties.feature_uid
            );
            getReglementaire();
            setTemplate();
            setAttrsData();

            QueryFactory.get(
              data.properties.feature_uid,
              data.properties.feature_id
            ).then(function(res) {
              scope.element = res.data.features.length
                ? res.data.features[0]
                : false;

              scope.bkpToCompare = angular.copy(scope.element);
            });
          }
        );

        // /*
        // -------------------------------------------------------------------------
        // MODIFICATION DE L'ELEMENT, POUR PROPOSITION D'ENREGISTREMENT DES
        // MODIFS
        // */
        // //

        var deregCheckDirtyElement = $rootScope.$on(
          'check_dirty_element',
          function(event) {
            // Prevent bubbling effect
            if (angular.isDefined(scope.bkpToCompare)) {
              // Remove all empty object
              var cleanData = gaJsUtils.removeEmpty(scope.element);
              var cleanNewData = gaJsUtils.removeEmpty(scope.bkpToCompare);

              // Compare ONLY data
              if (!angular.equals(cleanData, cleanNewData)) {
                var ans = confirm(
                  'Voulez-vous sauvegarder les modifications apportées à l\'élément "' +
                    scope.fti.alias +
                    '" ?'
                );
                if (ans) scope.updateElement();
                $timeout(function() {
                  scope.$emit('resolve_change_element');
                });
              } else {
                $timeout(function() {
                  scope.$emit('resolve_change_element');
                });
              }
            }
          }
        );

        /**
         * updateElement
         */
        scope.updateElement = function() {
          scope.bkpToCompare = angular.copy(scope.element);
          gaDomUtils.showGlobalLoader();
          scope.feats = {
            type: 'FeatureCollection',
            features: [scope.element],
          };
          EditFactory.updatespecifiedproperties(
            scope.elementFiliereData.properties.feature_uid,
            scope.feats
          ).then(function(res) {
            AncAppFactory.updateelementfiliere(
              scope.elementFiliereData.id,
              scope.elementFiliereData.properties.feature_uid,
              scope.elementFiliereData.properties.feature_id,
              scope.elementFiliereData.properties.id_filiere
            ).then(function() {
              $timeout(function() {
                // maj manuelle du geojson
                $rootScope.$broadcast('maj_representation_filiere', {
                  fid: scope.idFiliere,
                });
              });

              $rootScope.$broadcast('doNotResetCtrl', {
                resetCtrl: true,
              });

              gaDomUtils.hideGlobalLoader();
              // require('toastr').success("Élement de filière mis à jour.");
              require('toastr').success('Élement de filière mis à jour.', '', {
                positionClass: 'toast-bottom-left',
              });
            });
          });
        };

        /**
         * removeElementFiliere
         */
        scope.removeSelfElementFiliere = function() {
          var ans = confirm(
            'Êtes-vous certain de vouloir supprimer cet élément de filière ?'
          );
          if (ans) {
            gaDomUtils.showGlobalLoader();

            var ft = FeatureTypeFactory.getFeatureByUid(
              scope.elementFiliereData.properties.feature_uid
            );

            if (
              scope.elementFiliereData.properties !== undefined &&
              scope.elementFiliereData.properties.typeControle !== undefined
            ) {
              scope.typeControle = false;
            }

            // AncAppFactory.removeelementfromfiliere(element_filiere.id,
            // ft.name, element_filiere.properties.feature_id).then(function ()
            // {
            AncAppFactory.removeelementfromfiliere(
              scope.elementFiliereData.id,
              scope.elementFiliereData.properties.feature_uid,
              scope.elementFiliereData.properties.feature_id
            ).then(function() {
              $timeout(function() {
                // scope.currentFiliere.elements.splice(index, 1);
                // maj manuelle du geojson
                $rootScope.$broadcast('maj_representation_filiere', {
                  fid: scope.idFiliere,
                });
                $rootScope.$broadcast('suppressionElementFiliere', {
                  filiereId: scope.idFiliere,
                });
                $rootScope.$broadcast('updateInstallTab', {
                  currentElementFiliere: {
                    element: scope.elementFiliereData,
                    select_filiere: scope.typeControle ? false : true,
                  },
                });
              });

              $rootScope.$broadcast('resetDossierArborescence', {
                doNotResetCtrl: scope.typeControle ? true : false,
              });

              gaDomUtils.hideGlobalLoader();
            });
          }
        };

        scope.attributeDisplayCondition = function(
          attribute,
          linkedTo,
          withoutControle
        ) {
          let allControles;
          if (scope.typeControleNom == undefined)
            allControles = AncAppFactory.appCfg.main.controleCfg;
          else allControles = [{ type: scope.typeControleNom }];
          return ancBacTools.attributeDisplayCondition(
            scope.typeControle,
            allControles,
            attribute,
            linkedTo,
            withoutControle
          );
        };

        // can be vidanged ? (ce mot n'existe absolument pas)
        scope.canBeVidanged = false;
        scope.nbVidangesExistantes = 0;
        scope.nbVidangesExistantesPourElement = 0;

        if (
          scope.typeControle &&
          AncAppFactory.appCfg.main.properties.vidangesCfg.formulaires.indexOf(
            scope.typeControle
          ) !== -1 &&
          AncAppFactory.appCfg.main.properties.vidangesCfg.elements_filiere.indexOf(
            scope.elementFiliereData.properties.feature_uid
          ) !== -1
        ) {
          scope.canBeVidanged = true;

          if (angular.isDefined(scope.vidanges) && scope.vidanges !== false) {
            scope.nbVidangesExistantes = scope.vidanges.length;
            scope.nbVidangesExistantesPourElement = scope.vidanges.filter(
              vidange =>
                vidange.id_element_filiere ===
                scope.elementFiliereData.properties.feature_id
            ).length;
          }
        }

        var vidangeDialog;
        scope.openVidangesDialog = function() {
          vidangeDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.vidange.element.filiere.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.$on('updateNbElemVidange', function(event, vidanges) {
          scope.nbVidangesExistantes = vidanges.length;
          scope.nbVidangesExistantesPourElement = vidanges.filter(
            vidange =>
              vidange.id_element_filiere ===
              scope.elementFiliereData.properties.feature_id
          ).length;
          scope.vidanges = vidanges;
        });

        // cleanup
        scope.$on('$destroy', function() {
          watchelementFiliereData();
          watchfeatureUid();
          toggleControleEfDisplayMode();
          deregCheckDirtyElement();
        });
      },
    };
  };

  ancElementFiliere.$inject = [
    'FeatureTypeFactory',
    'AncAppFactory',
    'QueryFactory',
    'EditFactory',
    'gaDomUtils',
    '$rootScope',
    '$timeout',
    'ngDialog',
    'gaJsUtils',
    'ancBacTools',
  ];
  return ancElementFiliere;
});
