'use strict';
define(function() {
  var ancDossierAutorisationUrba = function(
    FeatureTypeFactory,
    AncAppFactory,
    QueryFactory,
    gaDomUtils,
    gaJsUtils,
    EditFactory,
    $q,
    $timeout,
    $rootScope,
    BacAppFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_dossier_autorisation_urba.html',
      restrict: 'EA',
      scope: {
        dossier: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        if ($rootScope.xgos.sector !== 'map')
          var CurrentAppFactory =
            $rootScope.xgos.sector == 'bac' ? BacAppFactory : AncAppFactory;
        else
          var CurrentAppFactory =
            $rootScope.xgos.sub_sector == 'bac' ? BacAppFactory : AncAppFactory;

        if (CurrentAppFactory.appCfg.main!=null) {
          scope.demandeUrbaFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            CurrentAppFactory.appCfg.main.datastore,
            CurrentAppFactory == BacAppFactory
              ? 'kis_bac_demande_autorisation_urbanisme'
              : 'kis_anc_demande_autorisation_urbanisme'
          );
        }

        scope.apptype = $rootScope.xgos.sector == 'bac' ? 'bac' : 'anc';

        scope.showComments = scope.apptype === 'anc';

        if ($rootScope.xgos.sector == 'map')
          scope.apptype = $rootScope.xgos.sub_sector;

        /**
         * refreshDemandes
         */
        let refreshDemandes = () => {
          const filter = "id_parcelle IN ('" + parcelles.join("','") + "')";
          if (scope.demandeUrbaFti!=null) {
            QueryFactory.data(
              scope.demandeUrbaFti.uid,
              filter
            ).then((res) => {
              //       console.log(res)
              scope.demandesDossier = angular.copy(
                res.data.features
              );
              const tmpDemande = {
                id: 0,
                properties: {
                  id_parcelle: parcelles[0],
                },
              };
              scope.demandesDossier.push(tmpDemande);
            });
          }
        };
        var parcelles = [];

        /**
         * setParcelles
         * @param refresh
         */
        var setParcelles = function(refresh) {
          // console.log('setParcelles!');

          parcelles = [];
          var props = scope.dossier.properties;

          scope.demandesParcelles = [];

          if (
            props !== undefined &&
            props.parcelleFiliere !== undefined &&
            props.parcelleFiliere != null
          ) {
            // si pas un tableau (une seule parcelle dans les anciennes versions d'ANC), transforme en tableau
            var toAdd = angular.isArray(props.parcelleFiliere)
              ? props.parcelleFiliere
              : [props.parcelleFiliere];
            toAdd.forEach(function(t) {
              parcelles.push(t.id);
              scope.demandesParcelles.push(angular.copy(t));
            });
          }
          if (
            props !== undefined &&
            props.parcelleHabitation !== undefined &&
            props.parcelleHabitation !== null
          ) {
            // si pas un tableau (une seule parcelle dans les anciennes versions d'ANC), transforme en tableau
            var toAdd2 = angular.isArray(props.parcelleHabitation)
              ? props.parcelleHabitation
              : [props.parcelleHabitation];
            toAdd2.forEach(function(t) {
              if (parcelles.indexOf(t.id) == -1) {
                parcelles.push(t.id);
                scope.demandesParcelles.push(angular.copy(t));
              }
            });
          }

          if (refresh) refreshDemandes();
        };
        setParcelles(1);

        // modification des parcelles du dossier (add/remove)
        scope.$on('modificationParcellesDossier', function(v, i) {
          $timeout(function() {
            setParcelles(1);
          }, 1000);
        });

        /**
         * saveCfg
         */
        scope.saveCfg = function() {
          var newfeats = [];
          var feats = [];
          for (var idp in scope.demandesDossier) {
            // reconversion int
            if (scope.demandesDossier[idp].id == 0) {
              var toInsert = angular.copy(scope.demandesDossier[idp]);
              delete toInsert.id;
              // insere pas les features vides
              if (Object.keys(toInsert.properties).length > 1) {
                newfeats.push(toInsert);
              }
            } else {
              feats.push(angular.copy(scope.demandesDossier[idp]));
            }
          }

          gaDomUtils.showGlobalLoader();

          var requests = [];
          if (newfeats.length)
            requests.push(
              EditFactory.add(
                scope.demandeUrbaFti.uid,
                gaJsUtils.setNewFeatureCollection(newfeats),
                ''
              )
            );
          if (feats.length)
            requests.push(
              EditFactory.update(
                scope.demandeUrbaFti.uid,
                gaJsUtils.setNewFeatureCollection(feats),
                ''
              )
            );

          $q.all(requests).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              refreshDemandes(1);
              require('toastr').success(
                "Demandes d'autorisation d'urbanisme mises à jour"
              );
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                "Erreur lors de la mise à jour des demandes d'autorisation d'urbanisme."
              );
            }
          );
        };

        /**
         * deleteDocument
         * @param $index
         */
        scope.deleteDocument = function($index) {
          var ans = confirm(
            'Êtes-vous certain de vouloir supprimer cette demande ?'
          );
          if (ans) {
            gaDomUtils.showGlobalLoader();
            EditFactory.remove(
              scope.demandeUrbaFti.uid,
              scope.demandesDossier[$index].id
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                refreshDemandes(1);
                require('toastr').success(
                  "Demande d'autorisation d'urbanisme supprimée."
                );
              },
              function() {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(
                  'Erreur lors de la suppression de la demande.'
                );
              }
            );
          }
        };
      },
    };
  };

  ancDossierAutorisationUrba.$inject = [
    'FeatureTypeFactory',
    'AncAppFactory',
    'QueryFactory',
    'gaDomUtils',
    'gaJsUtils',
    'EditFactory',
    '$q',
    '$timeout',
    '$rootScope',
    'BacAppFactory',
  ];
  return ancDossierAutorisationUrba;
});
