'use strict';
define(function() {
  var ancControleFiliere = function(
    AncAppFactory,
    FeatureTypeFactory,
    QueryFactory,
    gaDomUtils,
    $rootScope,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_controle_filiere.html',
      restrict: 'EA',
      scope: {
        filieresData: '=', // filieresData
        idDossier: '=',
        controleData: '=', // controleData
        typeControle: '=', // typeControle
        controleClos: '=?',
        filiereActive: '=?', // filiereActive,
        allowChangementAvis: '=?', // allowChangementAvis => toggle
        // recup element filiere active
        propertiesControle: '=?',
        controlecommentconfig: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.display = {
          mode: 'reduced',
        };

        // recuperation de toutes les vidanges associées à ce dossier
        // @RB @FINIR
        AncAppFactory.getvidangesdossier(scope.idDossier).then(function(res) {
          if (res.data) scope.vidangesData = res.data;
          else scope.vidangesData = true;
        });

        /**
         * toggleDisplayMode
         */
        scope.toggleDisplayMode = function() {
          scope.display.mode =
            scope.display.mode == 'full' ? 'reduced' : 'full';
          $rootScope.$broadcast('toggleControleEfDisplayMode', {
            mode: scope.display.mode,
          });
        };

        var elementFiliereFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_dossier_filiere_element'
        );

        /**
         * Récupération et affichage des éléments de filière
         *
         * @param showAlert
         *            showAlert
         * @param resetData
         *            resetData reset la collection
         * @param ajoutId
         *            (add seulement le derniere element sans tout
         *            reset)
         */
        scope.setCurrentElementsFiliere = function(
          showAlert,
          resetData,
          ajoutId
        ) {
          var ans = 1;

          if (scope.controleData && scope.controleData.elements && showAlert) {
            ans = confirm(
              'Êtes-vous certain de vouloir mettre à jour avec les éléments de la filière en cours ?'
            );
          }
          if (!ans) {
            return;
          } // User doesn't agree

          scope.controleData = scope.controleData || {
            idFiliere: false,
            elements: [],
          };

          if (resetData) {
            scope.controleData = {
              idFiliere: false,
              elements: [],
            };
          }

          gaDomUtils.showLocalLoader('.currentPage');

          if (scope.controleData.idFiliere === false) {
            scope.controleData.idFiliere = angular.copy(
              scope.propertiesControle.reference_filiere
            );
          }

          QueryFactory.data(
            elementFiliereFti.uid,
            `id_filiere='${scope.controleData.idFiliere}'`
          ).then(res => {
            var feats = AncAppFactory.sortElementsFiliere(
              res.data.features,
              'dossier'
            );

            if (resetData) {
              for (var i in feats) {
                scope.controleData.elements.push({
                  link: feats[i],
                  data: {},
                });
              }
            } else {
              var pos = feats
                .map(f => f.properties.feature_id)
                .indexOf(ajoutId);

              // ajoute seulement le dernier
              // element
              scope.controleData.elements.splice(pos, 0, {
                link: feats[pos],
                data: {},
              });
            }
            $timeout(() => $rootScope.$broadcast('updateInstallTab'), 0);

            gaDomUtils.removeLocalLoader('.currentPage');
          });
        };

        scope.setCurrentElementsFiliere(0, 1);

        if (!angular.isDefined(scope.controleData)) {
          scope.controleData = {
            idFiliere: false,
            elements: [],
          };
        } else {
          scope.controleData.elements = AncAppFactory.sortElementsFiliere(
            scope.controleData.elements,
            'controle'
          );
          scope.currentFiliere = scope.controleData.idFiliere;
        }

        // ajout d'un element de filiere, on refresh seulement le nouvel
        // element
        var ajoutElementFiliere = $rootScope.$on(
          'ajoutElementFiliere',
          function(event, data) {
            if (angular.isDefined(data.filiereId)) {
              scope.setCurrentElementsFiliere(0, data.reset, data.element_id);
            }
            if (scope.currentElementsFiliereslength >= 0) {
              scope.currentElementsFiliereslength =
                scope.currentElementsFiliereslength + 1;
            }
          }
        );
        var suppressionElementFiliere = $rootScope.$on(
          'suppressionElementFiliere',
          function(event, data) {
            if (angular.isDefined(data.filiereId)) {
              scope.setCurrentElementsFiliere(0, 1);
            }
            if (scope.currentElementsFiliereslength > 0) {
              scope.currentElementsFiliereslength =
                scope.currentElementsFiliereslength - 1;
            }
          }
        );

        // cleanup
        scope.$on('$destroy', function() {
          ajoutElementFiliere();
          suppressionElementFiliere();
        });
        /**
         * getCurrentElementsFiliere
         */
        scope.getCurrentElementsFiliere = function() {
          if (scope.filieresData && scope.filieresData.length) {
            for (var i = 0; i < scope.filieresData.length; i++) {
              let filiere = scope.filieresData[i];
              if (
                filiere.id === scope.propertiesControle.reference_filiere &&
                filiere.elements
              ) {
                scope.currentElementsFiliereslength = filiere.elements.length;
              }
            }
          }
          if (!scope.currentElementsFiliereslength) {
            scope.currentElementsFiliereslength = 0;
          }
        };
        scope.getCurrentElementsFiliere();
      },
    };
  };

  ancControleFiliere.$inject = [
    'AncAppFactory',
    'FeatureTypeFactory',
    'QueryFactory',
    'gaDomUtils',
    '$rootScope',
    '$timeout',
  ];
  return ancControleFiliere;
});
