'use strict';
define(function() {
  var ancCheckCommentaire = function($compile, ngDialog, $timeout) {
    return {
      restrict: 'EA',
      scope: {
        controleCommentConfig: '=controlecommentconfig',
        ctrlCloture: '=?',
      },

      link: function(scope, elt, attrs, ctrl) {
        var jq = angular.element(elt);

        scope.$on('reopenControle', function(v, i) {
          scope.ctrlCloture = false ? false : true;
        });

        $timeout(function() {
          if (
            angular.isDefined(scope.controleCommentConfig) &&
            angular.isDefined(scope.controleCommentConfig.commentaires)
          )
            scope.commentArray = scope.controleCommentConfig.commentaires;

          jq.ready(function() {
            var data = jq.attr('ng-model');
            //console.log(data);

            for (var key in scope.commentArray) {
              if (data === key && scope.commentArray[key] != []) {
                var template =
                  '<button ng-click="openCommentDialog(\'' +
                  key +
                  '\')" ng-disabled="ctrlCloture" class="btn btn-default btn-sm"><i class="fa fa-commenting-o" ></i></button>';
                // else
                //     var template = '<button ng-click="openCommentDialog(\''+key+'\')" class="btn btn-default btn-sm"><i class="fa fa-commenting-o" ></i></button>';
                var compileTemplate = $compile(template)(scope);

                jq.parent().append(compileTemplate);
              }
            }
          });
        });

        var checkCommentDialog;
        scope.openCommentDialog = function(item) {
          scope.element = {};
          scope.idAlreadySelected = [];

          if (
            scope.commentArray[item] != '' &&
            angular.isDefined(scope.commentArray[item])
          ) {
            scope.currentComment = scope.commentArray[item];
          }
          checkCommentDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/directives/anc_check_commentaire.html',
            className: 'ngdialog-theme-plain width1000 miniclose nopadding',
            scope: scope,
          });
        };

        var putComment = [];
        scope.chooseComment = function() {
          var textarea = angular.element(elt[0]);
          scope.idAlreadySelected.forEach(function(c) {
            putComment.push(Object.values(c));
          });
          // if(scope.currentComment.selected)
          //     putComment.push(scope.currentComment.selected);

          if (textarea.val() != '') {
            putComment.splice(0, 0, textarea.val()).join('\n');
          }
          var toPush = putComment.join('\n').toString();

          $timeout(function() {
            try {
              scope.$apply(function() {
                textarea.val(toPush).triggerHandler('change');
              });
            } catch (err) {}
          }, 0);

          checkCommentDialog.close();
          scope.currentComment.selected = {};
          putComment = [];
        };

        scope.mouseOverComment = function(id) {
          var commentHover = angular.element(
            document.querySelector('#comment_' + id)
          );
          if (!commentHover.hasClass('bg-primary'))
            commentHover.addClass('bg-info');
        };

        scope.mouseOutComment = function(id) {
          var commentHover = angular.element(
            document.querySelector('#comment_' + id)
          );
          commentHover.removeClass('bg-info');
        };

        scope.clickComment = function(id, comment) {
          var commentSelected = angular.element(
            document.querySelector('#comment_' + id)
          );
          var toCheck = 'element_' + id;

          if (angular.isDefined(scope.element[toCheck]))
            delete scope.element[toCheck];
          else scope.element[toCheck] = true;

          if (commentSelected.hasClass('bg-info'))
            commentSelected.removeClass('bg-info');

          if (commentSelected.hasClass('bg-primary')) {
            commentSelected.removeClass('bg-primary');
            scope.idAlreadySelected.forEach(function(elt, i) {
              if (Object.keys(elt) == id) {
                scope.idAlreadySelected.splice(i, 1);
              }
            });
          } else {
            commentSelected.addClass('bg-primary');
            var obj = {};
            obj[id] = comment;
            scope.idAlreadySelected.push(obj);
          }
        };
      },
    };
  };

  ancCheckCommentaire.$inject = ['$compile', 'ngDialog', '$timeout'];
  return ancCheckCommentaire;
});
