'use strict';

define(() => {
  const importParcelleMapCtrl = function(scope, $timeout) {
    let parcelleFeature, parcelleLayer;

    onInit();

    function onInit() {
      if (!scope.ngDialogData || !scope.ngDialogData.parcelle) {
        scope.closeThisDialog(false);
        return;
      }
      if (!setParcelleLayer()) {
        return;
      }

      $timeout(() => {
        initMap();
      }, 100);
    }

    function setParcelleLayer() {
      if (
        !scope.ngDialogData.parcelle.coordonnees ||
        !scope.ngDialogData.parcelle.coordonnees.geometry.coordinates
      ) {
        return false;
      }
      parcelleFeature = new ol.Feature({
        geometry: new ol.geom.MultiPolygon(
          scope.ngDialogData.parcelle.coordonnees.geometry.coordinates
        ),
      });

      const parcelleStyle = new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'blue',
          width: 3,
        }),
        fill: new ol.style.Fill({
          color: 'rgba(0, 0, 255, 0.1)',
        }),
      });

      parcelleFeature.setStyle(parcelleStyle);

      const parcelleSource = new ol.source.Vector({
        features: [parcelleFeature],
      });
      parcelleLayer = new ol.layer.Vector({
        source: parcelleSource,
      });
      return true;
    }

    function initMap() {
      const mapView = new ol.View({
        projection:
          'EPSG:' + (scope.ngDialogData.parcelle.typeProjection || '3857'),
        center: ol.extent.getCenter(parcelleFeature.getGeometry().getExtent()),
        zoom: 16,
      });
      const map = new ol.Map({
        layers: [
          new ol.layer.Tile({
            source: new ol.source.OSM({
              url: 'https://{a-c}.tile.openstreetmap.org/{z}/{x}/{y}.png',
              crossOrigin: null,
            }),
          }),
          parcelleLayer,
        ],
        target: 'kis-parcelle-map',
        controls: [new ol.control.FullScreen(), new ol.control.Zoom()],
        view: mapView,
      });
      scope.map = map;
      scope.map
        .getView()
        .fit(parcelleFeature.getGeometry().getExtent(), map.getSize());
      scope.map.getView().setZoom(map.getView().getZoom() - 2);
    }
  };

  importParcelleMapCtrl.$inject = ['$scope', '$timeout'];
  return importParcelleMapCtrl;
});
