'use strict';

define(function() {
  /*
   * configMobileCtrl
   */
  var configMobileCtrl = function(
    $scope,
    BacAppFactory,
    AncAppFactory,
    gaDomUtils,
    $q,
    FeatureTypeFactory,
    $rootScope,
    ngDialog,
    $filter,
    gcWMS,
    $http,
    gcStyleFactory,
    gaUrlUtils,
    $interval,
    $timeout,
    gclayers,
    ngTableParams,
    PortalsFactory
  ) {
    $scope.tabs = [
      {
        title: 'Generation de la tournée',
      },
      {
        title: 'Synchronisation des tournées',
      },
    ];
    $scope.soustabs = [
      {
        title: 'Filtre sur la carte',
      },
      {
        title: 'Filtre sur la liste des dossiers',
      },
      {
        title: 'Ajout de la tournée',
      },
    ];

    $scope.agent = {};
    $scope.tournees = {};
    var CurrentAppFactory = !AncAppFactory.appCfg.main
      ? BacAppFactory
      : AncAppFactory;
    $scope.typeOfAppANC = CurrentAppFactory == AncAppFactory;
    var typeName = CurrentAppFactory == AncAppFactory ? 'anc' : 'bac';
    // tri si role specifié
    var role = CurrentAppFactory == AncAppFactory ? 'ANC_agent' : 'BAC_agent';
    var currentuserCorrectRole =
      $rootScope.xgos.user.roles
        .map(function(g) {
          return g.name;
        })
        .indexOf(role) !== -1;
    $scope.communes = [''];
    $scope.tabs.activeTab = 0;
    $scope.soustabs.activeTab = 0;

    $scope.tourneeDebl =
      "( tournee = 'FALSE' OR tournee IS NULL ) AND etat_dossier = 'en_cours'";
    $scope.resSelectDataTab = [];
    $scope.selected_data = {
      list: [],
    };
    $scope.controletype = CurrentAppFactory.appCfg.main.controleCfg;
    var tabCommunes = CurrentAppFactory.appCfg.main.infosSpancListeVillesCfg;
    if (angular.isDefined(tabCommunes)) {
      tabCommunes.forEach(function(comm) {
        $scope.communes.push(comm.value);
      });
    }
    $scope.dossierFti = angular.copy(
      FeatureTypeFactory.getFeatureByNameAndDatastore(
        CurrentAppFactory.appCfg.main.datastore,
        'kis_' + typeName + '_dossier'
      )
    );

    $scope.validName = function(name) {
      return /^[A-Za-z0-9-_]+$/.test(name);
    };

    var dragBoxStyle = gcStyleFactory.getStyle('selectrectangle');

    $scope.filter = {
      date_prochain_controle_aft: null,
      date_prochain_controle_bef: null,
      adresse_ville: null,
    };
    $scope.cql_filter = $scope.tourneeDebl;
    $scope.setFilter = function(f) {
      var mFilter = [];
      $scope.cql_filter = $scope.tourneeDebl;
      if (
        $scope.filter.adresse_ville != null &&
        $scope.filter.adresse_ville != ''
      ) {
        mFilter.push("adresse_ville = '" + $scope.filter.adresse_ville + "'");
      }

      if ($scope.filter.date_prochain_controle_bef != null) {
        mFilter.push(
          'date_prochain_controle BEFORE ' +
            $scope.filter.date_prochain_controle_bef
        );
      }

      if ($scope.filter.date_prochain_controle_aft != null) {
        mFilter.push(
          'date_prochain_controle AFTER ' +
            $scope.filter.date_prochain_controle_aft
        );
      }
      if (mFilter.length > 0) {
        $scope.cql_filter = mFilter.join(' AND ');
      }
      var params = $scope.layerwms.getSource().getParams();
      params.CQL_FILTER = $scope.cql_filter;
      $scope.layerwms.getSource().updateParams(params);
    };

    $scope.$on('changeSelectedDossier', function(e, data) {
      $scope.$broadcast('updateFromConfigCtrl', {});
      $scope.resSelectDataTab = data;
    });

    $scope.resetFilter = function(f) {
      $scope.cql_filter = $scope.tourneeDebl;
      //var mFilter = [];

      //$scope.cql_filter = mFilter.join(' AND ');

      var params = $scope.layerwms.getSource().getParams();
      params.CQL_FILTER = $scope.cql_filter;
      $scope.layerwms.getSource().updateParams(params);
      $scope.filter.date_prochain_controle_bef = null;
      $scope.filter.date_prochain_controle_aft = null;
      $scope.filter.adresse_ville = '';
    };

    /**
     * htmlform2angular
     * @param ctrl
     * @returns {p.promise|{then, fail, end}}
     */
    var htmlform2angular = function(ctrl) {
      var p = $q.defer();

      // get ctrl main file
      gaDomUtils.showGlobalLoader();
      var ctrlName = ctrl.template.replace('.html', '');
      CurrentAppFactory.getControlesHTML(ctrlName, typeName).then(
        function(res) {
          var files = res;
          CurrentAppFactory.htmlformtoangular2(files, ctrl.type).then(
            function(r) {
              p.resolve();
              gaDomUtils.hideGlobalLoader();
            },
            function() {
              p.reject();
              gaDomUtils.hideGlobalLoader();
            }
          );
        },
        function() {
          require('toastr').error(
            "Une erreur s'est produite lors de la récupération données du formulaire " +
              ctrlName +
              '.'
          );
          p.reject();
          gaDomUtils.hideGlobalLoader();
        }
      );

      return p.promise;
    };
    function inArray(elt, tab) {
      var count = tab.length;
      for (var i = 0; i < count; i++) {
        if (tab[i] === elt) {
          return true;
        }
      }
      return false;
    }
    $scope.getTabIds = function(tab) {
      var tabIds = [];
      tab.forEach(function(doss) {
        tabIds.push(doss.id);
      });
      return tabIds;
    };

    /**
     * when resSelectDataTab (datatable selection) is changed, 
     * keep tmptournee (map selection + result) up to date
     */
    $scope.$watch('resSelectDataTab', function () {
      if ($scope.soustabs.activeTab == 1) {
        // when a file is selected
        $scope.resSelectDataTab.forEach(function (dossier) {
          if ($scope.tmptournee.dossiers == undefined) {
            $scope.tmptournee.dossiers = {};
          }
          if ($scope.tmptournee.dossiers.list == undefined) {
            $scope.tmptournee.dossiers.list = [];
          }
          var ids = new Array();
          if ($scope.tmptournee.dossiers.list.length != 0) {
            ids = $scope.getTabIds($scope.tmptournee.dossiers.list);
          }

          if (!inArray(dossier.id, ids)) {
            $scope.tmptournee.dossiers.list.push(dossier);
            $scope.addFeatureSelect(dossier);
          }
        });

        // when a file is unselected
        var found = -1;
        var index = -1;
        $scope.tmptournee.dossiers.list.forEach(function (dossier) {
          found = $scope.resSelectDataTab
            .map(function (o) {
              return o.id;
            })
            .indexOf(dossier.id);

          if (found == -1) {
            index = $scope.tmptournee.dossiers.list.indexOf(dossier);
            $scope.removeFeatureSelect(dossier);
            $scope.tmptournee.dossiers.list.splice(index, 1);
          }
        });
        $scope.tableParams.reload();
      }
      //console.log($scope.resSelectDataTab);
    });

    /**
     * prepareFormulaires
     * @param idx
     */
    $scope.prepareFormulaires = function(idx) {
      if (!idx) idx = 0;
      htmlform2angular($scope.controletype[idx]).then(function() {
        $scope.prepareFormulaires(idx + 1);
      });
    };

    $scope.getmobileforms = function() {
      CurrentAppFactory.getmobileforms();
    };

    $scope.$watch(
      'tmptournee.user',
      function(newval) {
        if (newval)
          CurrentAppFactory.getAllTournees($scope.tmptournee.user.login).then(
            function(data) {
              $scope.nomTourns = [];
              var tourns = data.data;
              for (var i = 0; i < tourns.features.length; i++) {
                $scope.nomTourns.push(tourns.features[i].properties.nom);
              }
            }
          );
      },
      1
    );

    $scope.tmptournee = {
      dossiers: {
        list: [],
      },
    };
    if (currentuserCorrectRole) {
      $scope.agent.user = $rootScope.xgos.user;
      $scope.tmptournee.user = $rootScope.xgos.user;
    }

    /**
     * Paramètres du tableau listant les règles associées au currentfeaturetype passé à cette directive
     */
    $scope.tableParams = new ngTableParams(
      {
        page: 1, // show first page
        count: 10, // count per page
      },
      {
        total: 0, // length of data
        getData: function($defer, params) {
          var displayedTab = $scope.tmptournee.dossiers.list.slice(
            (params.page() - 1) * params.count(),
            params.page() * params.count()
          );

          params.total($scope.tmptournee.dossiers.list.length); // set total for recalc pagination
          $defer.resolve(displayedTab);
        },
      }
    );

    /**
     * setTourneee
     */
    ($scope.setTourneee = function() {
      var id_dossiers = $scope.tmptournee.dossiers.list.map(function(x) {
        return x.id;
      });
      var mTournee = {
        tournee: {
          type: 'FeatureCollection',
          features: [
            {
              type: 'Feature',
              properties: {
                nom: $scope.tmptournee.nom,
                createur: $rootScope.xgos.user.login,
                date_creation: $filter('date')(
                  new Date(),
                  'yyyy-MM-ddTHH:mm:ss.sssZ'
                ),
                agent: $scope.tmptournee.user.login,
                bloquer: true,
              },
            },
          ],
        },
        dossiers: id_dossiers,
      };
      if (!inArray($scope.tmptournee.nom, $scope.nomTourns)) {
        gaDomUtils.showGlobalLoader();

        CurrentAppFactory.addtournee(mTournee).then(
          function(res) {
            gaDomUtils.hideGlobalLoader();
            //require('toastr').success(id_dossiers.length + (id_dossiers.length>1 ? " dossiers ajoutés " : " dossier ajouté ") + '  à la tournée de '+$scope.tmptournee.nom+' (agent : '+$scope.tmptournee.user.name+')');
            var params = $scope.layerwms.getSource().getParams();
            params.CQL_FILTER = $scope.cql_filter;
            $scope.layerwms.getSource().updateParams(params);
            var callback = function(isConfirm) {
              if (isConfirm) {
                var userName = $scope.tmptournee.user.login;
                var tournee_name = $scope.tmptournee.nom;
                $scope.tmptournee.dossiers.list = [];
                $scope.tableParams.reload();
                gaDomUtils.showGlobalLoader();
                CurrentAppFactory.getMobileTournee(userName, tournee_name).then(
                  function(res) {
                    if (!$scope.intervalProg) {
                      $scope.intervalProg = $interval(function() {
                        CurrentAppFactory.getMobileTourneeProgression(
                          userName,
                          tournee_name
                        ).then(
                          function(res) {
                            if (
                              res &&
                              res.data &&
                              res.status === 200 &&
                              res.data === 'completed'
                            ) {
                              $interval.cancel($scope.intervalProg);
                              $scope.intervalProg = undefined;
                              swal({
                                title: 'Tournée générée',
                                text:
                                  'La tournée ' +
                                  tournee_name +
                                  ' a été générée. Vous pouvez à présent la télécharger sur votre application mobile.',
                                type: 'success',
                                showCancelButton: false,
                              });
                              gaDomUtils.hideGlobalLoader();
                            } else if (
                              res &&
                              res.data &&
                              res.status === 200 &&
                              res.data === 'running'
                            ) {
                              console.log(
                                'Progression tournée ' +
                                  tournee_name +
                                  ' est en cours'
                              );
                            } else {
                              gaDomUtils.hideGlobalLoader();
                            }
                          },
                          function(res) {
                            //require('toastr').error("Erreur de génération de la tournée " + tournee_name);
                            swal({
                              title: 'Génération de la tournée',
                              text:
                                'Erreur de génération de la tournée ' +
                                tournee_name,
                              type: 'error',
                              showCancelButton: false,
                            });
                            gaDomUtils.hideGlobalLoader();
                            $interval.cancel($scope.intervalProg);
                            $scope.intervalProg = undefined;
                          }
                        );
                      }, 5000);
                    } else {
                      swal({
                        title: 'Information',
                        text:
                          'Une autre tournée est en cours de génération. Veuillez lancer la tournée ' +
                          tournee_name +
                          " dans l'onglet synchronisation tournée.",
                        type: 'info',
                        showCancelButton: false,
                      });
                      gaDomUtils.hideGlobalLoader();
                    }
                  },
                  function() {
                    swal({
                      title: 'Génération de la tournée',
                      text:
                        'Erreur de génération de la tournée ' + tournee_name,
                      type: 'error',
                      showCancelButton: false,
                    });
                    gaDomUtils.hideGlobalLoader();
                  }
                );
              } else {
                $timeout(function() {
                  swal({
                    title: 'Attention',
                    text:
                      'Générer la tournée ' +
                      $scope.tmptournee.nom +
                      " dans l'onglet synchronisation tournée avant de la télécharger sur l'application mobile",
                    type: 'warning',
                    showCancelButton: false,
                  });
                  $scope.tmptournee.dossiers.list = [];
                  $scope.tableParams.reload();
                }, 1000);
              }
            };
            swal(
              {
                title: 'Information',
                text: 'Voulez-vous générer la tournée maintenant ?',
                type: 'info',
                showCancelButton: true,
                confirmButtonColor: '#5cb85c',
                confirmButtonText: 'oui',
                cancelButtonText: 'non',
                closeOnConfirm: true,
                closeOnCancel: true,
              },
              callback
            );
          },
          function() {
            swal({
              title: 'Génération de la tournée',
              text: 'Création de la tournée a échoué',
              type: 'error',
              showCancelButton: false,
            });
            gaDomUtils.hideGlobalLoader();
            $scope.tmptournee.dossiers.list = [];
            $scope.tableParams.reload();
            var params = $scope.layerwms.getSource().getParams();
            params.CQL_FILTER = $scope.cql_filter;
            $scope.layerwms.getSource().updateParams(params);
          }
        );
      } else {
        require('toastr').error(
          ' Ce nom existe déja, veuillez choisir un autre nom'
        );
      }
    }),
      /**
       * refreshReports
       * @param noselfrefresh
       */
      ($scope.refreshDossTourn = function() {
        $timeout(function() {
          $rootScope.$broadcast('refreshDatatable', {
            uid: $scope.dossierFti.uid,
          });
          gclayers.refreshlayerByid($scope.dossierFti.uid, $scope.map);
        }, 1000);
      });

    // init map
    $scope.selectSource = new ol.source.Vector({
      format: new ol.format.GeoJSON(),
    });
    $scope.selectLayer = new ol.layer.Vector({
      source: $scope.selectSource,
    });

    $scope.addFeatureSelect = function(f) {
      var format = new ol.format.GeoJSON();
      var feat = format.readFeature(f);
      $scope.selectSource.addFeature(feat);
      $rootScope.$broadcast('addselectedLine', f);
    };

    $scope.removeFeatureSelect = function(f) {
      //var format = new ol.format.GeoJSON()
      var feat = $scope.selectSource.getFeatureById(f.id);
      $scope.selectSource.removeFeature(feat);
    };
    $scope.removeSelect = function(dindex, dossier) {
      $scope.tmptournee.dossiers.list.splice(dindex, 1);
      $scope.removeFeatureSelect(dossier);
      $scope.tableParams.reload();
    };
    $scope.localiseSelect = function(dindex, dossier) {
      var feat = $scope.selectSource.getFeatureById(dossier.id);
      if (feat.getGeometry()) {
        $scope.tabs.activeTab = 0;
        $scope.map
          .getView()
          .fit(feat.getGeometry().getExtent(), $scope.map.getSize());
      } else {
        require('toastr').info("Ce dossier n'a pas été localisé.");
      }
    };

    $scope.map = new ol.Map({
      layers: [
        new ol.layer.Tile({
          source: new ol.source.OSM(),
        }),
      ],
      target: 'tournee_map',
      view: new ol.View({}),
    });
    $scope.map
      .getView()
      .fit(
        CurrentAppFactory.appCfg.main.mapConfiguration.bbox,
        $scope.map.getSize()
      );

    var dossierFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
      CurrentAppFactory.appCfg.main.datastore,
      'kis_' + typeName + '_dossier'
    );
    dossierFti.cql_filter = $scope.cql_filter;
    $scope.layerwms = gcWMS.getOlLayerFromFeaturetypeInfo(dossierFti);

    $scope.map.addLayer($scope.layerwms);
    $scope.map.addLayer($scope.selectLayer);

    var params = $scope.layerwms.getSource().getParams();
    params.CQL_FILTER = $scope.cql_filter;
    $scope.layerwms.getSource().updateParams(params);

    // selection dossiers
    var pointer = new ol.interaction.Draw({
      type: 'Point',
      style: new ol.style.Style({}),
      condition: function(e) {
        return true; //always return true but need to set whether shift key is pressed or not
      },
    });
    $scope.selectFunctionTest = function() {
      /**
       * [condition description]
       * @param  {[type]} evt)   {                                                                         scope.altKeyPressed [description]
       * @param  {[type]} style: dragBoxStyle         } [description]
       * @return {[type]}        [description]
       */
      $scope.dragBox = new ol.interaction.DragBox({
        condition: function(evt) {
          //console.log(evt.originalEvent.altKey);
          // scope.altKeyPressed = evt.originalEvent.altKey;
          //MacEnvironments don't get here because the event is not
          //recognized as mouseEvent on Mac by the google closure.
          //We have to use the apple key on those devices
          return evt.originalEvent.ctrlKey || $scope.dragBox.getActive();
        },
        style: dragBoxStyle,
      });

      $scope.map.addInteraction($scope.dragBox);
      $scope.dragBox.on('boxstart', function(evt) {
        console.log('boxstart');
      });

      $scope.dragBox.on('boxend', function(evt) {
        var geometryExtent = $scope.dragBox.getGeometry().getExtent();

        var leftX = geometryExtent[0];
        var bottomY = geometryExtent[1];

        var rightX = geometryExtent[2];
        var topY = geometryExtent[3];

        //var catchments_url = '/geoserver/'+PortalsFactory.getPortalId()+'/ows?service=WFS&version=1.0.0&request=GetFeature&typeName='+ filter +'&outputformat=json&srsName='+map.getView().getProjection().getCode()+'&bbox=' + scope.dragBox.getGeometry().getExtent() +','+map.getView().getProjection().getCode();

        var catchments_url =
          '/services/' +
          PortalsFactory.getPortalId() +
          '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' +
          gaUrlUtils.encodeUriQuery($scope.dossierFti.uid) +
          '&outputformat=json&srsName=' +
          $scope.map
            .getView()
            .getProjection()
            .getCode() +
          '&cql_filter=' +
          gaUrlUtils.encodeUriQuery($scope.cql_filter) +
          ' AND INTERSECTS(geom, POLYGON((' +
          leftX +
          ' ' +
          bottomY +
          ',' +
          rightX +
          ' ' +
          bottomY +
          ',' +
          rightX +
          ' ' +
          topY +
          ',' +
          leftX +
          ' ' +
          topY +
          ',' +
          leftX +
          ' ' +
          bottomY +
          ')))';

        var promise = $http.get(catchments_url);
        promise.then(function(res) {
          var dossiers = res.data.features;
          if (dossiers.length) {
            //AncAppFactory.getdossier(refdossiers.join(','))
            var tabids = [];
            dossiers.forEach(function(dossier) {
              tabids.push(dossier.id);
            });
            CurrentAppFactory.getdossier(tabids.join(',')).then(function(res) {
              var dossiers2 = res.data.features;
              //console.log(res.data.features);

              dossiers2.forEach(function(dossier) {
                // seulement si pas déjà présent
                var dindex = $scope.tmptournee.dossiers.list
                  .map(function(x) {
                    return x.id;
                  })
                  .indexOf(dossier.id);
                if (dindex == -1) {
                  //$scope.tmptournee.dossiers.list.push(dossier);
                  //AncAppFactory.getdossier(dossier.id).then(function (res) {
                  //if (res.data.features[0]) {
                  //cope.editReport(res.data.features[0], false, false);
                  $scope.tmptournee.dossiers.list.push(dossier);
                  $scope.resSelectDataTab.push(dossier);
                  $scope.addFeatureSelect(dossier);
                  $scope.tableParams.reload();
                  $scope.dragBox.setActive(false);

                  //}
                  //})
                  //$scope.resSelectDataTab.push(dossier);
                  //$scope.addFeatureSelect(dossier);
                } else {
                  $scope.dragBox.setActive(false);
                  $scope.tmptournee.dossiers.list.splice(dindex, 1);
                  $scope.removeFeatureSelect(dossier);
                }

                $scope.tableParams.reload();
              });
            });
            // $scope.tableParams.reload();
          } else {
            $scope.dragBox.setActive(false);
          }
        });
      });

      //$scope.map.addInteraction($scope.dragBox);

      ///selection par bouton

      //console.log($scope.selectedTest);
    };

    $scope.map.addInteraction(pointer);
    // drawend
    pointer.on('drawend', function(evt) {
      var feature = new ol.format.GeoJSON().writeFeatureObject(evt.feature);

      var x = feature.geometry.coordinates[0];
      var y = feature.geometry.coordinates[1];

      var leftX = x - 5;
      var rightX = x + 5;
      var bottomY = y - 5;
      var topY = y + 5;

      $http
        .get(
          '/services/' +
            PortalsFactory.getPortalId() +
            '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' +
            $scope.dossierFti.uid +
            '&outputformat=json&srsName=' +
            $scope.map
              .getView()
              .getProjection()
              .getCode() +
            '&cql_filter=' +
            gaUrlUtils.encodeUriQuery($scope.cql_filter) +
            ' AND INTERSECTS(geom, POLYGON((' +
            leftX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            bottomY +
            ')))'
        )
        .then(function(res) {
          var dossiers = res.data.features;
          if (dossiers.length) {
            dossiers.forEach(function(dossier) {
              // seulement si pas déjà présent
              var dindex = $scope.tmptournee.dossiers.list
                .map(function(x) {
                  return x.id;
                })
                .indexOf(dossier.id);
              if (dindex == -1) {
                $scope.tmptournee.dossiers.list.push(dossier);

                $scope.resSelectDataTab.push(dossier);
                $scope.addFeatureSelect(dossier);
              } else {
                $scope.tmptournee.dossiers.list.splice(dindex, 1);
                $scope.removeFeatureSelect(dossier);
              }

              //console.log(dossier.id);
              /* $rootScope.$broadcast('toggleDatatableFeature', {
                                uid: dossierFti.uid,
                                id : dossier.id
                            });*/
            });
            $scope.tableParams.reload();
          }
        });
    });

    $scope.removeAllDossier = function() {
      var callback = function(res) {
        if (res) {
          $scope.tmptournee.dossiers.list = [];
          $scope.selectSource.clear();
          $scope.resSelectDataTab = [];
          $rootScope.$broadcast('emptyDatatableResult');
          $scope.tableParams.reload();
        }
      };
      swal(
        {
          title: 'Attention',
          text: 'Êtes vous sûr de vouloir vider cette sélection ?',
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: 'red',
          confirmButtonText: 'oui',
          cancelButtonText: 'non',
          closeOnConfirm: true,
          closeOnCancel: true,
        },
        callback
      );
    };

    /**
     * Synchronisation mobile
     */

    $scope.setQrCodeSrc = function() {
      console.log($scope.agent.user);
      if (angular.isDefined($scope.agent.user)) {
        $scope.mqrcode = CurrentAppFactory.getqrcodetournee(
          $scope.agent.user.login
        );
        // console.log($scope.mqrcode);
      }
    };
    $scope.removetourFromList = function(id) {
      for (var i = 0; i < $scope.tournees.features.length; i++) {
        if (id == $scope.tournees.features[i].id) {
          $scope.tournees.features.splice(i, 1);
        }
      }
    };
    $scope.checkIfDate = function(key, value) {
      if (key.indexOf('date_') == 0) {
        return $filter('date')(value, 'dd/MM/yyyy HH:mm');
      } else return value;
    };

    $scope.debloqueTournee = function(tourn) {
      $scope.tournee = tourn;
      if (
        tourn &&
        tourn.properties &&
        tourn.properties.date_export &&
        !tourn.properties.date_reimport &&
        tourn.properties.bloquer
      ) {
        swal(
          {
            title:
              "La tournée a été exporté.  Si vous débloquez la tournée, vous ne pourrez plus l'utiliser. " +
              'Êtes vous sûr de vouloir continuer ?',
            //text: "You will not be able to recover this imaginary file!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: $filter('translate')('common.yes'),
            cancelButtonText: $filter('translate')('common.no'),
            closeOnConfirm: true,
          },
          function(isConfirm) {
            if (isConfirm) {
              $scope.tournee.properties.bloquer = !$scope.tournee.properties
                .bloquer;
              CurrentAppFactory.debloquetournee(
                $scope.tournee.id,
                $scope.tournee.properties.bloquer
              ).then(
                function(res) {
                  if ($scope.tournee.properties.bloquer)
                    require('toastr').success('tournée bloquée');
                  else require('toastr').success('tournée debloquée');
                },
                function() {
                  require('toastr').error('erreur');
                }
              );
            }
          }
        );
      } else if (
        tourn &&
        tourn.properties &&
        tourn.properties.date_reimport &&
        !tourn.properties.date_synchronisation &&
        tourn.properties.bloquer
      ) {
        swal(
          {
            title:
              "La tournée n'a pas été synchronisé. Si vous débloquez la tournée, vous ne pourrez plus l'utiliser. " +
              'Êtes vous sûr de vouloir continuer ?',
            //text: "You will not be able to recover this imaginary file!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: $filter('translate')('common.yes'),
            cancelButtonText: $filter('translate')('common.no'),
            closeOnConfirm: true,
          },
          function(isConfirm) {
            if (isConfirm) {
              $scope.tournee.properties.bloquer = !$scope.tournee.properties
                .bloquer;
              CurrentAppFactory.debloquetournee(
                $scope.tournee.id,
                $scope.tournee.properties.bloquer
              ).then(
                function(res) {
                  if ($scope.tournee.properties.bloquer)
                    require('toastr').success('tournée bloquée');
                  else require('toastr').success('tournée debloquée');
                },
                function() {
                  require('toastr').error('erreur');
                }
              );
            }
          }
        );
      } else {
        swal(
          {
            title:
              "Si vous débloquez la tournée, vous ne pourrez plus l'utiliser. " +
              'Êtes vous sûr de vouloir continuer ?',
            //text: "You will not be able to recover this imaginary file!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: $filter('translate')('common.yes'),
            cancelButtonText: $filter('translate')('common.no'),
            closeOnConfirm: true,
          },
          function(isConfirm) {
            if (isConfirm) {
              $scope.tournee.properties.bloquer = !$scope.tournee.properties
                .bloquer;
              CurrentAppFactory.debloquetournee(
                $scope.tournee.id,
                $scope.tournee.properties.bloquer
              ).then(
                function(res) {
                  if ($scope.tournee.properties.bloquer)
                    require('toastr').success('tournée bloquée');
                  else require('toastr').success('tournée debloquée');
                },
                function() {
                  require('toastr').error('erreur');
                }
              );
            }
          }
        );
      }
    };

    var showListeDossiers;
    $scope.getDossiersTournee = function(tournee) {
      gaDomUtils.showGlobalLoader();
      CurrentAppFactory.getDossiersTournee(tournee.id).then(
        function(res) {
          $scope.ids = res.data;
          $scope.tournee = tournee;
          try {
            if (showListeDossiers) showListeDossiers.close();
          } catch (e) {
            e.stack;
          }
          showListeDossiers = ngDialog.open({
            title: 'Liste des dossiers de la tournée ' + tournee.name,
            template:
              'js/XG/widgets/' +
              typeName +
              'app/main/views/listedossierstournee.html',
            className: 'ngdialog-theme-plain width95pct miniclose',
            closeByDocument: false,
            scope: $scope,
          });
          gaDomUtils.hideGlobalLoader();
        },
        function() {
          gaDomUtils.hideGlobalLoader();
          require('toastr').error('erreur');
        }
      );
    };

    $scope.generateTournee = function(tournee) {
      $scope.tournee = tournee;
      if (!$scope.intervalProg) {
        if (
          tournee &&
          tournee.properties &&
          tournee.properties.nom &&
          tournee.properties.agent
        ) {
          var userName = tournee.properties.agent;
          var tournee_name = tournee.properties.nom;
          gaDomUtils.showGlobalLoader();
          CurrentAppFactory.getMobileTournee(userName, tournee_name).then(
            function(res) {
              //require('toastr').info("Génération de la tournée " + tournee_name + " est lancée");
              if (!$scope.intervalProg) {
                $scope.intervalProg = $interval(function() {
                  CurrentAppFactory.getMobileTourneeProgression(
                    userName,
                    tournee_name
                  ).then(
                    function(res) {
                      if (
                        res &&
                        res.data &&
                        res.status === 200 &&
                        res.data === 'completed'
                      ) {
                        $interval.cancel($scope.intervalProg);
                        swal({
                          title: 'Tournée générée',
                          text:
                            'La tournée ' +
                            tournee_name +
                            ' a été générée. Vous pouvez à présent la télécharger sur votre application mobile.',
                          type: 'success',
                          showCancelButton: false,
                        });
                        $scope.tournee.properties.bloquer = true;
                        $scope.intervalProg = undefined;
                        gaDomUtils.hideGlobalLoader();
                      } else if (
                        res &&
                        res.data &&
                        res.status === 200 &&
                        res.data === 'running'
                      ) {
                        console.log(
                          'Progression tournée ' +
                            tournee_name +
                            ' est en cours'
                        );
                      }
                    },
                    function(res) {
                      swal({
                        title: 'Génération de la tournée',
                        text:
                          'Erreur de génération de la tournée ' + tournee_name,
                        type: 'error',
                        showCancelButton: false,
                      });
                      $interval.cancel($scope.intervalProg);
                      $scope.intervalProg = undefined;
                      gaDomUtils.hideGlobalLoader();
                    }
                  );
                }, 5000);
              } else {
                swal({
                  title: 'Information',
                  text:
                    'Une autre tournée est en cours de génération. Veuillez lancer la tournée une fois celle-ci sera terminé.',
                  type: 'info',
                  showCancelButton: false,
                });
                gaDomUtils.hideGlobalLoader();
              }
            },
            function() {
              swal({
                title: 'Génération de la tournée',
                text: 'Erreur de génération de la tournée ' + tournee_name,
                type: 'error',
                showCancelButton: false,
              });
              gaDomUtils.hideGlobalLoader();
            }
          );
        } else {
          swal({
            title: 'Génération de la tournée',
            text: 'Les propriétés de la tournée ne sont pas renseignées.',
            type: 'error',
            showCancelButton: false,
          });
        }
      } else {
        swal({
          title: 'Information',
          text:
            'Une autre tournée est en cours de génération. Veuillez lancer la tournée une fois celle-ci sera terminé.',
          type: 'info',
          showCancelButton: false,
        });
      }
    };

    $scope.deleteTournee = function(id) {
      swal(
        {
          title: 'Etes vous sûr de vouloir supprimer cette tournée ?',
          //text: "You will not be able to recover this imaginary file!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#DD6B55',
          confirmButtonText: $filter('translate')('common.yes'),
          cancelButtonText: $filter('translate')('common.no'),
          closeOnConfirm: true,
        },
        function(isConfirm) {
          if (isConfirm) {
            CurrentAppFactory.removetournee(id).then(
              function(res) {
                require('toastr').success('tournée supprimée');
                $scope.removetourFromList(id);
              },
              function() {
                require('toastr').error('erreur');
              }
            );
          }
        }
      );
    };

    $scope.setDateSynchro = function(id) {
      for (var i = 0; i < $scope.tournees.features.length; i++) {
        if (id == $scope.tournees.features[i].id) {
          $scope.tournees.features[i].properties.date_synchronisation = $filter(
            'date'
          )(new Date(), 'yyyy-MM-ddTHH:mm:ss.sssZ');
          $scope.tournees.features[i].properties.synchronise_par =
            $rootScope.xgos.user.login;
        }
      }
    };

    $scope.verifySynchro = function(id) {
      var date;
      var synch;
      for (var i = 0; i < $scope.tournees.features.length; i++) {
        if (id == $scope.tournees.features[i].id) {
          date = $scope.tournees.features[i].properties.date_synchronisation;
          synch = $scope.tournees.features[i].properties.synchronise_par;
        }
      }
      return [date, synch];
    };
    $scope.refreshTourneeList = function() {
      if (angular.isDefined($scope.agent.user) && $scope.agent.user) {
        CurrentAppFactory.getAllTournees($scope.agent.user.login).then(function(
          data
        ) {
          $scope.tournees = data.data;
          $scope.tournees.features = $scope.tournees.features.sort(function(
            a,
            b
          ) {
            if (a.properties.date_creation < b.properties.date_creation)
              return 1;
            if (a.properties.date_creation > b.properties.date_creation)
              return -1;
          });
        });
      }
    };
    /*

         */
    $scope.synchroniseTournee = function(tournee) {
      $scope.tournee = tournee;
      var name = tournee.properties.nom;
      var id = tournee.id;
      //$filter('date')(new Date(), "yyyy-MM-ddTHH:mm:ss.sssZ")
      var date_synch = $scope.verifySynchro(id);
      if (date_synch[0] !== null || date_synch[1] !== null) {
        swal(
          {
            title: $filter('translate')('mobile.reSynchroTourneeConfirmationTitle'),
            text: $filter('translate')('mobile.reSynchroTourneeConfirmationText'),
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: $filter('translate')('common.yes'),
            cancelButtonText: $filter('translate')('common.no'),
            closeOnConfirm: true,
          },
          function(isConfirm) {
            if (isConfirm) {
              gaDomUtils.showGlobalLoader();
              // gaDomUtils.setGlobalLoaderScaleBar(1, 100);
              CurrentAppFactory.synchrotournee(name, id).then(
                function(res) {
                  if (res.data) {
                    var uid = res.data;
                    if (!$scope.intervalProg) {
                      $scope.intervalProg = $interval(function() {
                        CurrentAppFactory.synchroTourneeProgression(uid).then(
                          function(res) {
                            // gaDomUtils.setGlobalLoaderScaleBar(res.data, 100);
                            if (
                              res &&
                              res.data &&
                              res.status === 200 &&
                              res.data === 100
                            ) {
                              $interval.cancel($scope.intervalProg);
                              swal({
                                title: 'Tournée synchronisée',
                                text:
                                  'La tournée ' + name + ' a été synchronisée.',
                                type: 'success',
                                showCancelButton: false,
                              });
                              $scope.tournee.properties.bloquer = false;
                              $scope.intervalProg = undefined;
                              //require('toastr').success('tournée synchronisée');
                              $scope.setDateSynchro(id);
                              gaDomUtils.hideGlobalLoader();
                            } else if (
                              res &&
                              res.data &&
                              res.status === 200 &&
                              res.data === 0
                            ) {
                              //require('toastr').info("Synchronisation tournée "+ name +" est en cours");
                            } else if (
                              res &&
                              res.data &&
                              res.status === 200 &&
                              res.data === -1
                            ) {
                              swal({
                                title: 'Tournée synchronisée',
                                text:
                                  'Erreur de synchronisation de la tournée ' +
                                  name,
                                type: 'error',
                                showCancelButton: false,
                              });
                              $interval.cancel($scope.intervalProg);
                              $scope.intervalProg = undefined;
                              gaDomUtils.hideGlobalLoader();
                            }
                          },
                          function(res) {
                            require('toastr').error(
                              'Erreur de synchronisation de la tournée ' + name
                            );
                            $interval.cancel($scope.intervalProg);
                            $scope.intervalProg = undefined;
                            gaDomUtils.hideGlobalLoader();
                          }
                        );
                      }, 5000);
                    } else {
                      swal({
                        title: 'Information',
                        text:
                          'Une autre tournée est en cours de synchronisation. Veuillez lancer la tournée une fois celle-ci sera terminé.',
                        type: 'info',
                        showCancelButton: false,
                      });
                      gaDomUtils.hideGlobalLoader();
                    }
                  }
                },
                function() {
                  swal({
                    title: 'Tournée synchronisée',
                    text: 'Erreur de synchronisation de la tournée ' + name,
                    type: 'error',
                    showCancelButton: false,
                  });
                  gaDomUtils.hideGlobalLoader();
                }
              );
            }
          }
        );
      } else {
        swal(
          {
            title: 'Êtes-vous sûr de vouloir lancer la synchronisation ? ',
            //text: "You will not be able to recover this imaginary file!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: $filter('translate')('common.yes'),
            cancelButtonText: $filter('translate')('common.no'),
            closeOnConfirm: true,
          },
          function(isConfirm) {
            if (isConfirm) {
              gaDomUtils.showGlobalLoader();
              // gaDomUtils.setGlobalLoaderScaleBar(1, 100);
              var name = $scope.tournee.properties.nom;
              var id = $scope.tournee.id;
              CurrentAppFactory.synchrotournee(name, id).then(
                function(res) {
                  if (res.data) {
                    var uid = res.data;
                    if (!$scope.intervalProg) {
                      $scope.intervalProg = $interval(function() {
                        CurrentAppFactory.synchroTourneeProgression(uid).then(
                          function(res) {
                            // gaDomUtils.setGlobalLoaderScaleBar(res.data, 100);
                            if (
                              res &&
                              res.data &&
                              res.status === 200 &&
                              res.data === 100
                            ) {
                              $interval.cancel($scope.intervalProg);
                              swal({
                                title: 'Synchronisation',
                                text:
                                  'La tournée ' + name + ' a été synchronisée.',
                                type: 'success',
                                showCancelButton: false,
                              });
                              $scope.intervalProg = undefined;
                              //require('toastr').success('tournée synchronisée');
                              $scope.setDateSynchro(id);
                              gaDomUtils.hideGlobalLoader();
                              $scope.refreshTourneeList();
                            } else if (
                              res &&
                              res.data &&
                              res.status === 200 &&
                              res.data === 0
                            ) {
                              //require('toastr').info("Synchronisation tournée "+ name +" est en cours");
                            } else if (
                              res &&
                              res.data &&
                              res.status === 200 &&
                              res.data === -1
                            ) {
                              swal({
                                title: 'Synchronisation',
                                text:
                                  'Synchronisation de la tournée ' +
                                  name +
                                  ' a échouée',
                                type: 'error',
                                showCancelButton: false,
                              });
                              $interval.cancel($scope.intervalProg);
                              $scope.intervalProg = undefined;
                              gaDomUtils.hideGlobalLoader();
                            }
                          },
                          function(res) {
                            swal({
                              title: 'Synchronisation',
                              text:
                                'Synchronisation de la tournée ' +
                                name +
                                ' a échouée',
                              type: 'error',
                              showCancelButton: false,
                            });
                            $interval.cancel($scope.intervalProg);
                            $scope.intervalProg = undefined;
                            gaDomUtils.hideGlobalLoader();
                          }
                        );
                      }, 5000);
                    } else {
                      swal({
                        title: 'Information',
                        text:
                          'Une autre tournée est en cours de synchronisation. Veuillez lancer la tournée une fois celle-ci sera terminé.',
                        type: 'info',
                        showCancelButton: false,
                      });
                      gaDomUtils.hideGlobalLoader();
                    }
                  }
                },
                function() {
                  swal({
                    title: 'Tournée synchronisée',
                    text: 'Erreur de synchronisation de la tournée ' + name,
                    type: 'error',
                    showCancelButton: false,
                  });
                  gaDomUtils.hideGlobalLoader();
                }
              );
            }
          }
        );
      }
    };

    $scope.$watch(
      'agent',
      function() {
        $scope.refreshTourneeList();
        //  $scope.setQrCodeSrc();
      },
      1
    );
  };

  configMobileCtrl.$inject = [
    '$scope',
    'BacAppFactory',
    'AncAppFactory',
    'gaDomUtils',
    '$q',
    'FeatureTypeFactory',
    '$rootScope',
    'ngDialog',
    '$filter',
    'gcWMS',
    '$http',
    'gcStyleFactory',
    'gaUrlUtils',
    '$interval',
    '$timeout',
    'gclayers',
    'ngTableParams',
    'PortalsFactory',
  ];
  return configMobileCtrl;
});
