'use strict';
define([
  'angular',
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',

  'toastr',
  'ol3js',
], function(angular) {
  // Generate module tierce
  var module = angular.module('gc_tiercefunctions_service', []);

  module.provider('gcTierceFunctions', function() {
    /*
     * Definition the $get function
     */
    this.$get = function(
      gcSelect,
      gcStyleFactory,
      $http,
      $q,
      SelectManager,
      gcPopup,
      gclayers,
      FeatureTypeFactory,
      $translate,
      QueryFactory,
      ngDialog,
      EditFactory,
      zoomService,
      tierceService,
      GeometryFactory,
      ConfigFactory,
      ogcFactory,
      GoogleGeocodeFactory,
      $rootScope,
      kisGeocodageFactory,
      PortalsFactory
    ) {
      var _isDebug = true;
      var bdd_oracle = true;

      /**
       * Constants events open/close menu tierce widget
       */
      var ZONE_ASSOCIATION_ADD_EVENT = 'zone_association_add_event';
      var CURAGE_ASSOCIATION_ADD_EVENT = 'curage_association_add_event';

      var SECONDS = 5;

      /*
       * Definition the tierces functions
       */
      var tierceFunctions = function() {
        var POINT = 'point';
        var POLYGON = 'polygon';
        var RECTANGLE = 'rectangle';

        var FORMULAIRES_PREFIX = 'formulaires';

        var _map;
        var _scope;
        var _ngTableParams;
        var _selectedFeature;
        var _curage_listenEvent;

        /**
         * Main function called from TierceDirective when the data model change (in tiercewidget.html)
         *
         * @param thedata : data containts data and methods names
         * @param map : map
         * @param scope * scopt
         * @param ngTableParams : ng tables params
         */
        this.excuteFunction = function(thedata, map, scope, ngTableParams) {
          _scope = scope;
          _map = map;
          _ngTableParams = ngTableParams;
          _scope.kisgeocodage = [];
          if (
            $rootScope.xgos.portal.parameters.kisgeocodage &&
            $rootScope.xgos.portal.parameters.kisgeocodage.length > 0
          ) {
            _scope.kisgeocodage =
              $rootScope.xgos.portal.parameters.kisgeocodage;
          }

          var method = thedata.method;
          var data = thedata.data;

          debug('--> Function : ' + method);
          debug('--> data : ' + JSON.stringify(data));

          switch (method) {
            case 'localiseAdresse': {
              if (bdd_oracle) {
                var voieCouche = data['voieLayer'].toUpperCase();
                var arrondissementCouche = data[
                  'arrondissementLayer'
                ].toUpperCase();
                var communeCouche = data['communeLayer'].toUpperCase();
                var gouvernoratCouche = data['gouvernoratLayer'].toUpperCase();
              } else {
                var voieCouche = data['voieLayer'];
                var gouvernoratCouche = data['gouvernoratLayer'];
                var communeCouche = data['communeLayer'];
                var arrondissementCouche = data['arrondissementLayer'];
              }

              var voieObjets = data['voieField'];
              var communeObjets = data['communeField'];
              var arrondissementObjets = data['arrondissementField'];
              var gouvernoratObjets = data['gouvernoratField'];

              /*localiseAdresse(voieCouche, voieObjets, arrondissementCouche, arrondissementObjets,
                                        communeCouche, communeObjets, gouvernoratCouche, gouvernoratObjets);*/
              var adress =
                voieObjets.value +
                ' ' +
                communeObjets.value +
                ' ' +
                gouvernoratObjets.value;
              localiseAdressByGeocoder(adress);

              break;
            }
            case 'localiseObjet': {
              if (bdd_oracle) {
                var nomCouche = data['nomCouche'].toUpperCase();
                var nomChamp = data['nomChamp'].toUpperCase();
              } else {
                var nomCouche = data['nomCouche'];
                var nomChamp = data['nomChamp'];
              }
              var valeurChamp = data['valeurChamp'];
              var estIdentifiant = data['estIdentifiant'];

              localiseObjet(nomCouche, nomChamp, valeurChamp, estIdentifiant);
              break;
            }
            case 'appliquerSelectionObjets': {
              if (bdd_oracle) {
                var nomCouche = data['layer'].toUpperCase();
              } else {
                var nomCouche = data['layer'];
              }
              var valeursObjets = data['values'];

              appliquerSelectionObjets(nomCouche, valeursObjets);
              break;
            }
            case 'selectionnerObjetPourMaj': {
              if (bdd_oracle) {
                var layerName = data['layer'].toUpperCase();
              } else {
                var layerName = data['layer'];
              }
              var selectionType = data['selectionType'];
              var valeursObjets = data['values'];
              var loadSelection = data['loadSelection'];

              _scope.activeSelect = true;

              selectionnerObjetPourMaj(
                layerName,
                selectionType,
                valeursObjets,
                loadSelection
              );
              break;
            }
            case 'creerObjet': {
              var selectionType = data['selectionType'];
              if (bdd_oracle) {
                var layerName = data['layer'].toUpperCase();
              } else {
                var layerName = data['layer'];
              }
              var valeursObjets = data['values'];

              _scope.activeSelect = true;

              creerObjet(layerName, valeursObjets, selectionType);
              break;
            }

            case 'creerZoneProjet': {
              var selectionType = data['selectionType'];
              if (bdd_oracle) {
                var layerName = data['layer'].toUpperCase();
              } else {
                var layerName = data['layer'];
              }
              var valeursObjets = data['values'];

              _scope.activeSelect = true;

              creerZoneProjet(layerName, valeursObjets, selectionType);
              break;
            }

            case 'creerPlanningCurage': {
              var cibleCouche = data['targetLayer'];
              var cibleObjets = data['targetField'];
              var layerName = data['layer'];
              var valeursObjets = data['values'];

              _scope.activeSelect = true;

              creerPlanningCurage(
                layerName,
                valeursObjets,
                cibleCouche,
                cibleObjets
              );
              break;
            }

            case 'supprimerPlanningCurage': {
              if (bdd_oracle) {
                var layerName = data['layer'].toUpperCase();
              } else {
                var layerName = data['layer'];
              }

              supprimerPlanningCurage(layerName);
              break;
            }

            case 'creerBonsTravaux': {
              if (bdd_oracle) {
                var layerName = data['layer'].toUpperCase();
                var cibleCouche = data['targetLayer'];
              } else {
                var cibleCouche = data['targetLayer'];
                var layerName = data['layer'];
              }
              var cibleObjets = data['targetField'];
              var valeursObjets = data['values'];

              creerBonsTravaux(
                layerName,
                valeursObjets,
                cibleCouche,
                cibleObjets
              );
              break;
            }
            case 'creerObjetDepuisFormulaire': {
              creerObjetDepuisFormulaire(data);
              break;
            }

            case 'consulterObjetDepuisFormulaire': {
              if (bdd_oracle) {
                var nomCouche = data['layer'].toUpperCase();
              } else {
                var nomCouche = data['layer'];
              }
              var valeursObjets = data['values'];
              var form = data['form'];

              consulterObjetDepuisFormulaire(nomCouche, valeursObjets, form);
              break;
            }

            // Test local functions
            case 'setData': {
              setData(data);
              break;
            }
            case 'getData': {
              getData(data);
              break;
            }
            case 'zoomPlus': {
              zoomPlus(_map);
              break;
            }
            // end functions test

            default: {
              $translate('tierce.functionIsNotDefined').then(function(res) {
                require('toastr').error(method + ': ' + res);
              });
              break;
            }
          }
        };

        /* =========================================================================
                         * Private business functions
                         ========================================================================= */

        function zoomPlus(map) {
          //zoomService.zoom(map);
        }

        // For test
        function getData(arg1) {
          debug('Getting data in controller for the input param : ' + arg1);

          var result = 'Hello ' + arg1;
          debug(result);
          alert(result);

          return result;
        }

        // For test
        function setData(arg1) {
          debug('Getting data in controller for the input param : ' + arg1);

          var result = 'Hello ' + arg1;
          debug(result);
          alert(result);

          return result;
        }

        /**
         * Centrer la carte sur l’élément voie et  le mettre en evidence
         * La recherche se fait sur les couches données en paramètres respectivement
         *
         * @param voieCouche
         * @param voieObjets
         * @param arrondissementCouche
         * @param arrondissementObjets
         * @param communeCouche
         * @param communeObjets
         * @param gouvernoratCouche
         * @param gouvernoratObjets
         */
        function localiseAdresse(
          voieCouche,
          voieObjets,
          arrondissementCouche,
          arrondissementObjets,
          communeCouche,
          communeObjets,
          gouvernoratCouche,
          gouvernoratObjets
        ) {
          debug(
            'Couche voie : ' +
              voieCouche +
              ', objets voie :' +
              JSON.stringify(voieObjets) +
              'Couche arrondissement : ' +
              arrondissementCouche +
              ', objets arrondissement :' +
              JSON.stringify(arrondissementObjets) +
              'Couche commune : ' +
              communeCouche +
              ', objets commune :' +
              JSON.stringify(communeObjets) +
              'gouvernorat voie : ' +
              gouvernoratCouche +
              ', objets gouvernorat :' +
              JSON.stringify(gouvernoratObjets)
          );

          // Search in order by voie and if no result, search by arrondissement after by commune and fouvernorat
          localiseAdresseByLayer(voieCouche, voieObjets).then(function(res) {
            if (!res) {
              localiseAdresseByLayer(
                arrondissementCouche,
                arrondissementObjets
              ).then(function(res) {
                if (!res) {
                  localiseAdresseByLayer(communeCouche, communeObjets).then(
                    function(res) {
                      if (!res) {
                        localiseAdresseByLayer(
                          gouvernoratCouche,
                          gouvernoratObjets
                        ).then(function(res) {
                          if (!res) {
                            $translate('tierce.noObjectFound').then(function(
                              res
                            ) {
                              require('toastr').error(res);
                            });
                          }
                        });
                      }
                    }
                  );
                }
              });
            }
          });

          removeHightLightFeatureAfterSeconde(SECONDS);
        }

        function localiseAdressByGeocoder(adress) {
          var urls = [];
          _scope.kisgeocodage.forEach(function(geocodage) {
            // if (geocodage.value == true) {
            urls.push(geocodage.url);
            var promise = kisGeocodageFactory.search(geocodage.url, adress);
            promise.then(function(res) {
              //scope.wait = false;
              var adressResults = res.data.features;
              for (var i = 0; i < adressResults.length; i++) {
                var aResult = adressResults[0];
                var anAdress = {
                  address: {
                    state: aResult.properties.city,
                  },
                  display_name: aResult.properties.label,
                  lat: aResult.geometry.coordinates[1],
                  lon: aResult.geometry.coordinates[0],
                };
                //scope.adress.push(anAdress);
              }
              anAdress.origin = geocodage.label;
              var formerCenter = _map.getView().getCenter();
              var myLong = Number(anAdress.lon);
              var lat = Number(anAdress.lat);
              var mapCode = _map
                .getView()
                .getProjection()
                .getCode();
              var projetedCoord = ol.proj.transform(
                [myLong, lat],
                'EPSG:4326',
                mapCode
              );
              _map.getView().setCenter(projetedCoord);
              require('toastr').success(anAdress.display_name);
            });
            //}
          });
        }

        /**
         * Localiser l'adresse par nom de couche
         *
         * @param layerName
         * @param valuesObj
         */
        function localiseAdresseByLayer(layerName, valuesObj) {
          debug(
            'Couche : ' + layerName + ', objets :' + JSON.stringify(valuesObj)
          );

          var defer = $q.defer();

          if (!layerName || !valuesObj) {
            defer.resolve(false);
            return defer.promise;
          }

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          if (!fid) {
            $translate('tierce.noLayerFound').then(function(res) {
              require('toastr').error(layerName + ' : ' + res);
            });

            defer.resolve(false);
            return defer.promise;
          }

          var whereClause = buildSimpleWhereClause(valuesObj);
          debug('Where clause : ' + whereClause);

          var promise = getObjectsByClauseWhere(fid, whereClause);

          promise.then(function(res) {
            if (
              res.data.features == undefined ||
              res.data.features.length == 0
            ) {
              /*
                                     $translate('tierce.noObjectFound').then(function (res) {
                                     require('toastr').error(res);
                                     });
                                     */
              defer.resolve(false);
            } else {
              var feature = res.data.features[0];
              hightLightFeature(feature);
              zoomAndCenterOnFeature(feature);

              defer.resolve(true);
            }
          });

          return defer.promise;
        }

        /**
         * Centrer la carte sur l’objet donnée en paramètre et le mettre en evidence
         *
         * @param layerName
         * @param propertyName
         * @param propertyValue
         * @param isIdentifier
         */
        function localiseObjet(
          layerName,
          propertyName,
          propertyValue,
          isIdentifier
        ) {
          debug(
            'Couche : ' +
              layerName +
              ', nomChamp : ' +
              propertyName +
              ', valeurChamp : ' +
              propertyValue +
              ', identifiant : ' +
              isIdentifier
          );

          var promise;
          var featureId;

          if (isIdentifier) {
            featureId = layerName + '.' + propertyValue;
          } else {
            featureId = propertyValue;
          }

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          if (!fid) {
            $translate('tierce.noLayerFound').then(function(res) {
              require('toastr').error(layerName + ' : ' + res);
            });

            return;
          }
          if (isIdentifier && isIdentifier == true) {
            promise = QueryFactory.get(
              fid,
              featureId,
              _map
                .getView()
                .getProjection()
                .getCode()
            );
          } else {
            var tmpvalue = propertyValue;
            if (propertyValue.substr(0, 1) != "'") {
              if (isNaN(propertyValue)) tmpvalue = "'" + tmpvalue + "'";
            }
            if (bdd_oracle) {
              var whereClause = propertyName + '=' + tmpvalue;
            } else {
              var whereClause = propertyName.toLowerCase() + '=' + tmpvalue;
            }
            var crs = _map
              .getView()
              .getProjection()
              .getCode();
            promise = QueryFactory.pdata(fid, whereClause, crs);
          }

          promise.then(function(res) {
            if (
              res.data.features == undefined ||
              res.data.features.length == 0
            ) {
              $translate('tierce.noObjectFound').then(function(res) {
                require('toastr').info(res);
              });
            } else {
              var feature = res.data.features[0];
              hightLightFeature(feature);
              zoomAndCenterOnFeature(feature);
              removeHightLightFeatureAfterSeconde(SECONDS);
            }
          });
        }

        /**
         * Selectionner un objet puis mettre à jour ses attributs donnés en paramètres
         *
         * @param layerName
         * @param selectionType
         * @param valeursObjets
         */
        function selectionnerObjetPourMaj(
          layerName,
          selectionType,
          valeursObjets,
          loadSelection
        ) {
          debug(
            'Couche : ' +
              layerName +
              ', valeurs : ' +
              JSON.stringify(valeursObjets) +
              ', Selection type : ' +
              selectionType
          );

          // Confirm popup update ?
          ngDialog
            .openConfirm({
              template:
                'js/XG/widgets/mapapp/tiercewidget/views/updateFeaturesModal.html',
              className: 'ngdialog-theme-plain',
              closeByDocument: false,
              scope: _scope,
            })
            .then(
              function(value) {
                debug('resolved:' + value);
              },
              function(reason) {
                debug('rejected:' + reason);

                if (reason == undefined) {
                  spacialSelectAndUpdateObjects(
                    layerName,
                    valeursObjets,
                    selectionType,
                    loadSelection
                  );
                }
              }
            );
        }

        /**
         * Faire une selection grahique des objets puis les affichers sous forme de tableau
         *
         * @param layerName
         * @param valeursObjets
         */
        function appliquerSelectionObjets(layerName, valeursObjets) {
          debug(
            'Couche : ' +
              layerName +
              ', Valeurs: ' +
              JSON.stringify(valeursObjets)
          );

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          if (!fid) {
            $translate('tierce.noLayerFound').then(function(res) {
              require('toastr').error(layerName + ' : ' + res);
            });

            return;
          }

          var whereClause = buildWhereClause(valeursObjets);
          var promise = getObjectsByClauseWhere(fid, whereClause);

          promise.then(function(res) {
            if (
              res.data.features == undefined ||
              res.data.features.length == 0
            ) {
              $translate('tierce.noObjectFound').then(function(res) {
                require('toastr').error(res);
              });
            } else {
              zoomOnObjects(res.data);
            }
          });
        }

        /**
         * Creer l'objet intervention dans SIG
         *
         * @param layerName
         * @param features
         * @param selectionType
         */
        function creerObjet(layerName, features, selectionType) {
          debug(
            'Couche : ' + layerName + ', Valeurs: ' + JSON.stringify(features)
          );

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          if (!fid) {
            $translate('tierce.noLayerFound').then(function(res) {
              require('toastr').error(layerName + ' : ' + res);
            });

            return;
          }

          if (!selectionType) {
            selectionType = POINT;
          }

          debug('Start selection with ' + selectionType + ' ...');

          switch (selectionType.toLowerCase()) {
            case RECTANGLE: {
              break;
            }
            case POINT: {
              createPointObjectAndDisplayObject(layerName, features);
              break;
            }
            case POLYGON: {
              break;
            }
            default: {
              $translate('tierce.selectionTypeIsNotDefined').then(function(
                res
              ) {
                require('toastr').error(selectionType + ': ' + res);
              });
              break;
            }
          }
        }

        /**
         * Créer une zone de projet, le centré et affecter ses valeurs puis ouvrir la fiche intervention
         *
         * @param layerName
         * @param features
         * @param selectionType
         */
        function creerZoneProjet(layerName, features, selectionType) {
          debug(
            'Couche : ' + layerName + ', Valeurs: ' + JSON.stringify(features)
          );

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          if (!fid) {
            $translate('tierce.noLayerFound').then(function(res) {
              require('toastr').error(layerName + ' : ' + res);
            });

            return;
          }

          if (!selectionType) {
            selectionType = POLYGON;
          }

          debug('Start selection with ' + selectionType + ' ...');

          switch (selectionType.toLowerCase()) {
            case RECTANGLE: {
              // Not implemented
              break;
            }
            case POINT: {
              // Not implemented
              break;
            }
            case POLYGON: {
              createZoneInterventionAndDisplayObject(layerName, features);
              break;
            }
            default: {
              $translate('tierce.selectionTypeIsNotDefined').then(function(
                res
              ) {
                require('toastr').error(selectionType + ': ' + res);
              });
              break;
            }
          }
        }

        /**
         * Créer l'objet intervention pour les bobn sde travaux puis centrer l'intervention sur la carte
         *
         * @param layerName
         * @param objectsValues
         * @param targetLayerName
         * @param targetValues
         */
        function creerBonsTravaux(
          layerName,
          objectsValues,
          targetLayerName,
          targetValues
        ) {
          debug(
            'Couche : ' +
              layerName +
              ', Valeurs: ' +
              JSON.stringify(
                objectsValues +
                  'Couche : ' +
                  targetLayerName +
                  ', cible objets :' +
                  JSON.stringify(targetValues)
              )
          );

          createIntervention(
            layerName,
            objectsValues,
            targetLayerName,
            targetValues
          );
        }

        /**
         * Créer l'objet intervention pour le curage par un buffer autour de la rue
         *
         * @param layerName
         * @param objectsValues
         * @param targetLayerName
         * @param targetValues
         */
        function creerPlanningCurage(
          layerName,
          objectsValues,
          targetLayerName,
          targetValues
        ) {
          debug(
            'Couche : ' +
              layerName +
              ', Valeurs: ' +
              JSON.stringify(
                objectsValues +
                  'Couche : ' +
                  targetLayerName +
                  ', cible objets :' +
                  JSON.stringify(targetValues)
              )
          );

          createIntervention(
            layerName,
            objectsValues,
            targetLayerName,
            targetValues
          );
        }

        /**
         * Créer un buffer autour de l'objet et inserer les objets dans la base de données
         *
         * @param layerName
         * @param features
         * @param assocLayerName
         * @param assocObjecrts
         */
        function generateBufferAndCreateObjectsInDadabase(
          layerName,
          features,
          assocLayerName,
          assocObjecrts
        ) {
          /*
           * Generate buffer from assoc features
           */
          var assocFeatures = assocObjecrts.features;
          var geometry = [];

          angular.forEach(assocFeatures, function(feature) {
            geometry.push(feature.geometry);
          });
          debug('Geometry : ' + JSON.stringify(geometry));

          var distance = getBufferInfo(_scope.config, 'distance', 0.1);
          var type = getBufferInfo(_scope.config, 'type', 'ROUND');

          _curage_listenEvent = _scope.$on(
            CURAGE_ASSOCIATION_ADD_EVENT,
            function(event, data) {
              createAssociatedIntervObjects(event, data);
            }
          );

          GeometryFactory.unionandbuffer(geometry, type, distance).then(
            function(res) {
              var intervFeature = {
                geometry: res.data,
              };

              // Add buffer to drawen layer (curage)
              var parser = new ol.format.GeoJSON();
              var vectorSource = gclayers.getDrawLayer().getSource();
              var geoJsonfeature = parser.readFeature(intervFeature);
              vectorSource.addFeature(geoJsonfeature);

              _selectedFeature = geoJsonfeature;
              createCurageObjectInDataBaseAndSentEvent(
                layerName,
                features,
                res.data,
                assocLayerName,
                assocObjecrts
              );
            }
          );
        }

        /**
         * Supprimer l'ensemble des objets interventions "curage"
         *
         * @param layerName
         */
        function supprimerPlanningCurage(layerName) {
          _scope.layerName = layerName;

          // Confirm popup for delete ?
          ngDialog
            .openConfirm({
              template:
                'js/XG/widgets/mapapp/tiercewidget/views/removeFeaturesModal.html',
              className: 'ngdialog-theme-plain',
              closeByDocument: false,
              scope: _scope,
            })
            .then(
              function(value) {
                debug('resolved:' + value);
              },
              function(reason) {
                debug('rejected:' + reason);

                if (reason == undefined) {
                  removePlanningCurage(layerName);
                }
              }
            );
        }

        /**
         * Centrer sur les rues données, affecter leurs valeurs puis ouvrir la fiche intervention
         *
         * @param data
         */
        function creerObjetDepuisFormulaire(data) {
          debug('Data : ' + JSON.stringify(data));

          if (data) {
            var formName = data.hasOwnProperty('form') ? data.form.name : '';
            if (!formName) {
              $translate('tierce.formNotExit').then(function(res) {
                require('toastr').error(res);
              });

              return;
            }

            var formData = { properties: data.form.properties };
            var templateUrl =
              'js/XG/widgets/mapapp/tiercewidget/views/tierceForm.html';
            var formDirectory = getDirectoryFromPath(formName);
            var reelFormName = getFileFromPath(formName);
            if (!reelFormName) {
              console.error(
                'The path : ' +
                  formName +
                  ' : does not containts dir and file, we take so : ' +
                  formName
              );
              reelFormName = formName;
            }
            var formFile = reelFormName + '.form';

            loadAndDisplayFormFile(
              formDirectory,
              formFile,
              templateUrl,
              formData
            );
          }
        }

        /**
         * Charger et afficher le formulaire
         *
         * @param formDirectory
         * @param formFileName
         * @param template
         * @param formData
         */
        function loadAndDisplayFormFile(
          formDirectory,
          formFileName,
          template,
          formData
        ) {
          if (!formDirectory || !formFileName) {
            console.log('Form Directory/File is null');
            return;
          }

          ConfigFactory.get(formDirectory, formFileName).then(
            function(res) {
              if (res.data != '') {
                _scope.currentTemplateForm = res.data;

                _scope.newObj = {};
                if (bdd_oracle) {
                  var pData = angular.copy(formData['properties']);
                  for (var p in pData) {
                    if (p !== p.toUpperCase()) {
                      var pu = p.toUpperCase();
                      formData['properties'][pu] = pData[p];
                      delete formData['properties'][p];
                    }
                  }
                }
                _scope.newObj.current = formData;

                console.info(
                  'Form file is loaded , data : ' +
                    JSON.stringify(_scope.newObj.current)
                );

                var dialog = tierceService.open({
                  scope: _scope,
                  title: formFileName,
                  template: template,
                  showClose: true,
                  onclose: function() {
                    console.log('It is colosed !');
                  },
                });
              } else {
                console.error(
                  formDirectory + ' or ' + formFileName + ' does not exist !'
                );
              }
            },
            function(reason) {
              console.error(
                'An error is occured when loading form file: ' + reason
              );
            }
          );
        }

        /**
         * Consulter l'objet
         *
         * @param layerName
         * @param valeursObjets
         * @param form
         */
        function consulterObjetDepuisFormulaire(
          layerName,
          valeursObjets,
          form
        ) {
          //_scope.test(data);

          debug(
            'Couche : ' +
              layerName +
              ', Valeurs: ' +
              JSON.stringify(valeursObjets)
          );

          if (!form) {
            $translate('tierce.formNotExit').then(function(res) {
              require('toastr').error(res);
            });

            return;
          }

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          if (!fid) {
            $translate('tierce.noLayerFound').then(function(res) {
              require('toastr').error(layerName + ' : ' + res);
            });

            return;
          }

          var whereClause = buildWhereClause(valeursObjets);
          console.log('--> where : ' + whereClause);
          var promise = getObjectsByClauseWhere(fid, whereClause);

          promise.then(function(res) {
            if (
              res.data.features == undefined ||
              res.data.features.length == 0
            ) {
              $translate('tierce.noObjectFound').then(function(res) {
                require('toastr').error(res);
              });
            } else {
              debug('Data : ' + JSON.stringify(res.data));

              var formName = form.name;
              var formData = res.data.features[0];
              var templateUrl =
                'js/XG/widgets/mapapp/tiercewidget/views/tierceForm.html';
              var formDirectory = getDirectoryFromPath(formName);
              var reelFormName = getFileFromPath(formName);
              if (!reelFormName) {
                console.error(
                  'The path : ' +
                    formName +
                    ' : does not containts dir and file, we take so : ' +
                    formName
                );
                reelFormName = formName;
              }
              var formFile = reelFormName + '.form';

              loadAndDisplayFormFile(
                formDirectory,
                formFile,
                templateUrl,
                formData
              );
            }
          });
        }

        /* =========================================================================
                         * Private utils functions
                         ========================================================================= */

        /**
         *
         * @param features
         */
        function spacialSelect(layerName) {
          debug('Start selection ...');

          // A normal select interaction to handle click
          var select = new ol.interaction.Select();
          select.set('gctype', 'kis');
          select.set('interaction', 'select');
          select.set('widget', 'Tierce');
          _map.addInteraction(select);

          // Start Select Event
          var dragBox = new ol.interaction.DragBox({
            /*
                                 condition: function(evt) {
                                 return evt.originalEvent.ctrlKey||_scope.isActive ;
                                 },
                                 */
            style: gcStyleFactory.getStyle('selectrectangle'),
          });
          dragBox.set('gctype', 'kis');
          dragBox.set('interaction', 'select');
          dragBox.set('widget', 'Tierce');
          // Add dragBox interaction
          _map.addInteraction(dragBox);

          // Event on end select
          dragBox.on('boxend', function(evt) {
            var res = FeatureTypeFactory.getFeatureUidByName(layerName);

            // Get dragBox extent
            var geometryExtent = dragBox.getGeometry().getExtent();

            var leftX = geometryExtent[0];
            var bottomY = geometryExtent[1];
            var rightX = geometryExtent[2];
            var topY = geometryExtent[3];

            var spatialClause =
              'INTERSECTS(geom, POLYGON((' +
              leftX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              bottomY +
              ')))';
            //var catchments_url = '/geoserver/'+PortalsFactory.getPortalId()+'/ows?service=WFS&version=1.0.0&request=GetFeature&typeName='+ filter +'&outputformat=json&srsName='+map.getView().getProjection().getCode()+'&bbox=' + scope.dragBox.getGeometry().getExtent() +','+map.getView().getProjection().getCode();
            var promise = ogcFactory.getfeatures(
              'GetFeature',
              'WFS',
              '1.0.0',
              res,
              'json',
              _map
                .getView()
                .getProjection()
                .getCode(),
              spatialClause
            );

            // URL to gert objets
            /*var url = '/services/' + PortalsFactory.getPortalId() + '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' + res +
                                    '&outputformat=json&srsName=' + _map.getView().getProjection().getCode() +
                                    '&cql_filter=INTERSECTS(geom, POLYGON((' + leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' + rightX + ' ' + topY + ',' +
                                    leftX + ' ' + topY + ',' + leftX + ' ' + bottomY + ')))';

                                var promise = $http.get(url);*/
            var promise2 = promise.then(function(res) {
              displayFeaturesInPopup(res.data);
            });

            promise2.then(function(res) {
              _map.removeInteraction(dragBox);
            });
          });
        }

        /**
         * Selection spatiale et mise à jour les objets dans la base
         *
         * @param layerName
         * @param features
         * @param selectionType
         * @param loadSelection
         */
        function spacialSelectAndUpdateObjects(
          layerName,
          features,
          selectionType,
          loadSelection
        ) {
          if (!selectionType) {
            selectionType = POINT;
          }

          debug('Start selection with ' + selectionType + ' ...');

          switch (selectionType.toLowerCase()) {
            case RECTANGLE: {
              rectangeSelectAndUpdateObjects(
                layerName,
                features,
                loadSelection
              );
              break;
            }
            case POINT: {
              pointSelectAndUpdateObjects(layerName, features, loadSelection);
              break;
            }
            case POLYGON: {
              polygonSelectAndUpdateObjects(layerName, features, loadSelection);
              break;
            }
            default: {
              $translate('tierce.selectionTypeIsNotDefined').then(function(
                res
              ) {
                require('toastr').error(selectionType + ': ' + res);
              });
              break;
            }
          }
        }

        /**
         * Selection par rectangle et mise à jour des objets dans la base
         *
         * @param layerName
         * @param features
         * @param loadSelection
         */
        function rectangeSelectAndUpdateObjects(
          layerName,
          features,
          loadSelection
        ) {
          updateCursor('pointer');

          // A normal select interaction to handle click
          //var select = new ol.interaction.Select();
          //_map.addInteraction(select);

          // Start Select Event
          var dragBox = new ol.interaction.DragBox({
            /*
                                 condition: function(evt) {
                                 return evt.originalEvent.ctrlKey||_scope.isActive ;
                                 },
                                 */
            style: gcStyleFactory.getStyle('selectrectangle'),
          });

          dragBox.set('gctype', 'kis');
          dragBox.set('interaction', 'select');
          dragBox.set('widget', 'Tierce');

          // Add dragBox interaction
          _map.addInteraction(dragBox);

          // Event on end select
          dragBox.on('boxend', function(evt) {
            var res = FeatureTypeFactory.getFeatureUidByName(layerName);

            // Get rectangle extent
            var geometryExtent = dragBox.getGeometry().getExtent();

            var leftX = geometryExtent[0];
            var bottomY = geometryExtent[1];
            var rightX = geometryExtent[2];
            var topY = geometryExtent[3];

            /*
             * URL to get intersection objects with the rectangle selection
             */

            var spatialClause =
              'INTERSECTS(geom, POLYGON((' +
              leftX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              bottomY +
              ')))';
            //var catchments_url = '/geoserver/'+PortalsFactory.getPortalId()+'/ows?service=WFS&version=1.0.0&request=GetFeature&typeName='+ filter +'&outputformat=json&srsName='+map.getView().getProjection().getCode()+'&bbox=' + scope.dragBox.getGeometry().getExtent() +','+map.getView().getProjection().getCode();
            var promise = ogcFactory.getfeatures(
              'GetFeature',
              'WFS',
              '1.0.0',
              res,
              'json',
              _map
                .getView()
                .getProjection()
                .getCode(),
              spatialClause
            );

            /*var url = '/services/' + PortalsFactory.getPortalId() + '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' + res +
                                    '&outputformat=json&srsName=' + _map.getView().getProjection().getCode() +
                                    '&cql_filter=INTERSECTS(geom, POLYGON((' + leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' + rightX + ' ' + topY + ',' +
                                    leftX + ' ' + topY + ',' + leftX + ' ' + bottomY + ')))';

                                var promise = $http.get(url);*/
            var promise2 = promise.then(function(res) {
              //zoomOnObjects(res.data);
              if (loadSelection == true) {
                SelectManager.addFeaturesFromGeojson(res.data);
              }
              updateObjectsInDataBase(features, res.data.features, layerName);
              _map.removeInteraction(dragBox);
            });
          });
        }

        /**
         * election par polygon et mise à jour des objets dans la base
         *
         * @param layerName
         * @param features
         * @param loadSelection
         */
        function polygonSelectAndUpdateObjects(
          layerName,
          features,
          loadSelection
        ) {
          var drawinteraction = new ol.interaction.Draw({
            source: gclayers.getDrawLayer().getSource(),
            type: 'Polygon',
          });

          drawinteraction.set('gctype', 'kis');
          drawinteraction.set('interaction', 'Draw');
          drawinteraction.set('widget', 'Tierce');

          _map.addInteraction(drawinteraction);

          // on start draw
          drawinteraction.on('drawstart', function(evt) {
            debug('drawstart');
          });

          // on end draw
          drawinteraction.on('drawend', function(evt) {
            var format = new ol.format.GeoJSON();

            var feature = format.writeFeatureObject(evt.feature);
            var geometry = feature.geometry;

            // Get polygon extent
            var coords = geometry.coordinates;
            var polyCoords = new ol.geom.Polygon(coords, 'XY');

            var wktObj = new ol.format.WKT();
            var wktStr = wktObj.writeGeometry(polyCoords);

            var spatialClause = 'INTERSECTS(geom, ' + wktStr + ')';

            var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
            var crs = _map
              .getView()
              .getProjection()
              .getCode();

            /*
             * URL to get intersection objects with the polygon selection
             */
            QueryFactory.pdata(fid, spatialClause, crs).then(function(res) {
              if (loadSelection == true) {
                SelectManager.addFeaturesFromGeojson(res.data);
              }
              updateObjectsInDataBase(features, res.data.features, layerName);
              _map.removeInteraction(drawinteraction);
            });
          });
        }

        /**
         * Selection par point et mise à jour des objets dans la base
         *
         * @param layerName
         * @param features
         */
        function pointSelectAndUpdateObjects(
          layerName,
          features,
          loadSelection
        ) {
          var drawinteraction = new ol.interaction.Draw({
            source: gclayers.getDrawLayer().getSource(),
            type: 'Point',
          });

          drawinteraction.set('gctype', 'kis');
          drawinteraction.set('interaction', 'Draw');
          drawinteraction.set('widget', 'Tierce');

          _map.addInteraction(drawinteraction);

          // on start draw
          drawinteraction.on('drawstart', function(evt) {
            debug('drawstart');
          });

          // on end draw
          drawinteraction.on('drawend', function(evt) {
            var format = new ol.format.GeoJSON();
            var feature = format.writeFeatureObject(evt.feature);

            // Get point extent
            var geomtry = feature.geometry;
            var x = geomtry.coordinates[0];
            var y = geomtry.coordinates[1];

            var view = _map.getView();
            var resolution = view.getResolution();

            // var pointExtent = [x, y , x, y];
            if (resolution != 'undefined') {
              var leftX = x - 5 * resolution;
              var rightX = x + 5 * resolution;
              var bottomY = y - 5 * resolution;
              var topY = y + 5 * resolution;
            } else {
              var leftX = x - 5;
              var rightX = x + 5;
              var bottomY = y - 5;
              var topY = y + 5;
            }

            var fid = FeatureTypeFactory.getFeatureUidByName(layerName);

            /*
             * URL to get intersection objects with the point selection
             */

            var spatialClause =
              'INTERSECTS(geom, POLYGON((' +
              leftX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              bottomY +
              ')))';
            //var catchments_url = '/geoserver/'+PortalsFactory.getPortalId()+'/ows?service=WFS&version=1.0.0&request=GetFeature&typeName='+ filter +'&outputformat=json&srsName='+map.getView().getProjection().getCode()+'&bbox=' + scope.dragBox.getGeometry().getExtent() +','+map.getView().getProjection().getCode();
            var promise = ogcFactory.getfeatures(
              'GetFeature',
              'WFS',
              '1.0.0',
              fid,
              'json',
              _map
                .getView()
                .getProjection()
                .getCode(),
              spatialClause
            );

            /*var url = '/services/' + PortalsFactory.getPortalId() + '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' + res +
                                    '&outputformat=json&srsName=' + _map.getView().getProjection().getCode() +
                                    '&cql_filter=INTERSECTS(geom, POLYGON((' + leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' + rightX + ' ' + topY + ',' +
                                    leftX + ' ' + topY + ',' + leftX + ' ' + bottomY + ')))';

                                var promise = $http.get(url);*/

            /*var url = '/services/' + PortalsFactory.getPortalId() + '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' + fid +
                                    '&outputformat=json&srsName=' + _map.getView().getProjection().getCode() +
                                    '&cql_filter=INTERSECTS(geom, POLYGON((' + leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' + rightX + ' ' + topY + ',' + leftX + ' ' + topY + ',' + leftX + ' ' + bottomY + ')))';

                                var promise = $http.get(url);*/
            promise.then(function(res) {
              //displayFeaturesInPopup(res.data);
              //zoomOnObjects(res.data);
              if (loadSelection == true) {
                SelectManager.addFeaturesFromGeojson(res.data);
              }
              updateObjectsInDataBase(features, res.data.features, layerName);
              _map.removeInteraction(drawinteraction);
            });
          });
        }

        /**
         * Afficher les features dans une fenetre
         *
         * @param features
         */
        function displayFeaturesInPopup(features) {
          if (!features) {
            debug('No feature are found');
            return;
          }

          SelectManager.addFeaturesFromGeojson(features);

          if (_scope.pop) {
            _scope.pop.destroy();
          }

          _scope.pop = gcPopup.open({
            scope: _scope,
            title: 'Informations : ',
            content: '<div selectfeaturetreewidget></div>',
            showClose: true,
            onclose: function() {
              SelectManager.clear();
            },
          });
        }

        /**
         * Récupérer les objets par la clause where
         *
         * @param fid
         * @param whereClause
         */
        function getObjectsByClauseWhere(fid, whereClause) {
          debug('fid : ' + fid + ', Where clause : ' + whereClause);

          return QueryFactory.data(
            fid,
            whereClause,
            _map
              .getView()
              .getProjection()
              .getCode(),
            '',
            ''
          );
        }

        /**
         *
         * @param theFeature
         */
        function hightLightFeature(theFeature) {
          if (!theFeature) {
            return;
          }

          var geom = theFeature.geometry;

          var feature = null;
          switch (geom.type) {
            case 'Point': {
              feature = new ol.Feature({
                geometry: new ol.geom.Point(geom.coordinates),
              });
              break;
            }
            case 'MultiPoint': {
              feature = new ol.Feature({
                geometry: new ol.geom.MultiPoint(geom.coordinates),
              });
              break;
            }
            case 'LineString': {
              feature = new ol.Feature({
                geometry: new ol.geom.LineString(geom.coordinates),
              });
              break;
            }
            case 'MultiLineString': {
              feature = new ol.Feature({
                geometry: new ol.geom.MultiLineString(geom.coordinates),
              });
              break;
            }

            case 'Polygon': {
              feature = new ol.Feature({
                geometry: new ol.geom.Polygon(geom.coordinates),
              });
              break;
            }
            case 'MultiPolygon': {
              feature = new ol.Feature({
                geometry: new ol.geom.MultiPolygon(geom.coordinates),
              });
              break;
            }
          }

          // Getting evidence of the object
          if (_scope.highLigtedFeature != undefined) {
            _scope.highLigtedFeature = gclayers.removehighLightFeatures(
              _scope.highLigtedFeature
            );
          }

          gclayers.addhighLightFeature(feature);
          _scope.highLigtedFeature = feature;
        }

        /**
         * Zoom et centre sur la feature
         *
         * @param theFeature
         */
        function zoomAndCenterOnFeature(theFeature) {
          if (!theFeature) {
            return;
          }

          var feature = null;
          var geom = theFeature.geometry;

          switch (geom.type) {
            case 'Point': {
              feature = new ol.Feature({
                geometry: new ol.geom.Point(geom.coordinates),
              });
              break;
            }
            case 'MultiPoint': {
              feature = new ol.Feature({
                geometry: new ol.geom.MultiPoint(geom.coordinates),
              });
              break;
            }
            case 'LineString': {
              feature = new ol.Feature({
                geometry: new ol.geom.LineString(geom.coordinates),
              });
              break;
            }
            case 'MultiLineString': {
              feature = new ol.Feature({
                geometry: new ol.geom.MultiLineString(geom.coordinates),
              });
              break;
            }
            case 'Polygon': {
              feature = new ol.Feature({
                geometry: new ol.geom.Polygon(geom.coordinates),
              });
              break;
            }
            case 'MultiPolygon': {
              feature = new ol.Feature({
                geometry: new ol.geom.MultiPolygon(geom.coordinates),
              });
              break;
            }
          }

          // Get extent to center map on feature
          var extent = feature.getGeometry().getExtent();

          if (extent) {
            var center = ol.extent.getCenter(extent);
            _map.getView().setCenter(center);
          } else {
            console.log('Error : Extent is null');
          }

          // Get zoom from config and zoom map
          var zoom = 0;
          if (
            _scope.config.hasOwnProperty('zoom') &&
            _scope.config['zoom'] != ''
          ) {
            zoom = _scope.config['zoom'];
          } else {
            zoom = 14;
          }

          _map.getView().setZoom(zoom);
        }

        /**
         * Zoom sur les objets
         *
         * @param objects
         */
        function zoomOnObjects(objects) {
          if (!objects) {
            return;
          }

          if (objects.length == 1) {
            hightLightFeature(objects.features[0]);
            return;
          }

          SelectManager.addFeaturesFromGeojson(objects);

          // Center the map to the object and add highLight
          var ext = SelectManager.getExtent();
          var x = (ext[2] + ext[0]) / 2;
          var y = (ext[3] + ext[1]) / 2;

          _map.getView().setCenter([x, y]);

          // Get zoom from config
          var zoom = 14;
          if (
            _scope.config.hasOwnProperty('zoom') &&
            _scope.config['zoom'] != ''
          ) {
            zoom = _scope.config['zoom'];
          }

          _map.getView().setZoom(zoom);
        }

        /**
         * Contruite la clause where
         *
         * @param objects
         */
        function buildWhereClause(objects) {
          var whereClause = '';

          for (var i = 0; i < objects.features.length; i++) {
            var feature = objects.features[i];
            whereClause = whereClause.concat(' ( ');

            for (var key in feature) {
              var objValue = feature[key];
              debug('key : ' + key + ', value : ' + objValue);

              if (isObject(objValue) && key == 'properties') {
                for (var property in objValue) {
                  var value = objValue[property];
                  debug('property : ' + property + ', value : ' + value);
                  if (bdd_oracle) {
                    if (isNaN(value)) {
                      whereClause = whereClause
                        .concat(property.toUpperCase())
                        .concat('=')
                        .concat("'")
                        .concat(value)
                        .concat("'");
                    } else {
                      whereClause = whereClause
                        .concat(property.toUpperCase())
                        .concat('=')
                        .concat(value);
                    }
                  } else {
                    if (isNaN(value)) {
                      whereClause = whereClause
                        .concat(property.toLowerCase())
                        .concat('=')
                        .concat("'")
                        .concat(value)
                        .concat("'");
                    } else {
                      whereClause = whereClause
                        .concat(property.toLowerCase())
                        .concat('=')
                        .concat(value);
                    }
                  }

                  whereClause = whereClause.concat(' AND ');
                }
              }
            }
            var index = whereClause.lastIndexOf('AND');
            // Remove last AND if any
            if (index > 0) {
              whereClause = whereClause.substring(0, index);
            }
            whereClause = whereClause = whereClause.concat(') OR ');
          }

          var index = whereClause.lastIndexOf('OR');
          // Remove last OR if any
          if (index > 0) {
            whereClause = whereClause.substring(0, index);
          }

          return whereClause;
        }

        /**
         * Construire la clause where
         *
         * @param object
         */
        function buildWhereClause2(object) {
          var whereClause = '';

          if (bdd_oracle) {
            var field = object['field'].toUpperCase();
          } else {
            var field = object['field'];
          }
          var values = object['values'];

          for (var i = 0; i < values.length; i++) {
            var value = values[i];

            if (isNaN(value)) {
              whereClause = whereClause
                .concat(field)
                .concat('=')
                .concat("'")
                .concat(value)
                .concat("'");
            } else {
              whereClause = whereClause
                .concat(field)
                .concat('=')
                .concat(value);
            }
            whereClause = whereClause.concat(' OR ');
          }

          var index = whereClause.lastIndexOf('OR');
          if (index > 0) {
            whereClause = whereClause.substring(0, index);
          }

          return whereClause;
        }

        /**
         * Contruire la clause where
         *
         * @param object
         */
        function buildSimpleWhereClause(object) {
          var whereClause = '';
          if (bdd_oracle) {
            var field = object['field'].toUpperCase();
          } else {
            var field = object['field'];
          }
          var value = object['value'];
          var reg = new RegExp("'", 'g');
          value = value.replace(reg, "''");
          if (isNaN(value)) {
            whereClause = whereClause
              .concat(field)
              .concat('=')
              .concat("'")
              .concat(value)
              .concat("'");
          } else {
            whereClause = whereClause
              .concat(field)
              .concat('=')
              .concat(value);
          }

          return whereClause;
        }

        /**
         * Contruire la clause where de la table association
         *
         * @param objectValue
         */
        function buildAssociationWhereClause(objectValue) {
          var whereClause = '';

          var featA = getAssocLayerInfo(_scope.config, 'feata', 'feata');
          var idA = getAssocLayerInfo(_scope.config, 'ida', 'ida');
          var featD = getAssocLayerInfo(_scope.config, 'featd', 'featd');
          var idD = getAssocLayerInfo(_scope.config, 'idd', 'idd');
          var relName = getAssocLayerInfo(_scope.config, 'relname', 'rel_name');

          whereClause = whereClause
            .concat(featA)
            .concat('=')
            .concat("'")
            .concat(objectValue[featA])
            .concat("'");

          return whereClause;
        }

        /**
         * Mise à jour des features dans la base
         *
         * @param srcFeatures
         * @param destFeatures
         * @param layerName
         */
        function updateObjectsInDataBase(srcFeatures, destFeatures, layerName) {
          var srcFeature = srcFeatures.features[0];

          debug('Src feature : ' + JSON.stringify(srcFeature));
          debug('Dest Features : ' + JSON.stringify(destFeatures));

          if (
            !srcFeature ||
            srcFeature.length == 0 ||
            !destFeatures ||
            destFeatures.length == 0
          ) {
            $translate('tierce.noObjectFound').then(function(res) {
              require('toastr').info(res);
              updateCursor('');
            });

            return;
          }

          updateObject(srcFeature, destFeatures);

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          var crs = _scope.map
            .getView()
            .getProjection()
            .getCode();

          var featureCollection = {};
          featureCollection.type = 'FeatureCollection';
          featureCollection.features = destFeatures;

          debug('--> result : ' + JSON.stringify(featureCollection));

          EditFactory.update(fid, featureCollection, crs).then(function(res) {
            debug('Update is done in database');
          });

          $translate('tierce.uptodateIsDone').then(function(res) {
            require('toastr').info(res);
            updateCursor('');
          });
        }

        /**
         * Création de la feature dans la base
         *
         * @param feature
         * @param layerName
         */
        function createObjectInDataBaseAndDisplayCore(feature, layerName) {
          debug('Feature : ' + JSON.stringify(feature));

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          var crs = _scope.map
            .getView()
            .getProjection()
            .getCode();

          var featureCollection = {};
          featureCollection.type = 'FeatureCollection';
          featureCollection.features = [feature];

          debug(
            '--> Create object in DB : ' + JSON.stringify(featureCollection)
          );
          EditFactory.add(fid, featureCollection, crs).then(function(res) {
            debug('Object is done in database');

            if (res.status == 200) {
              var result = res.data;

              if (result.errors.length > 0) {
                $translate('tierce.createObjectFailed').then(function(res) {
                  require('toastr').error(res + ': ' + result.errors[0]);
                });
                return;
              } else {
                var newId = result.create[0].id;
                debug('New id : ' + newId);
                displayFeatureInDialog(feature, layerName);

                $translate('tierce.createIsDone').then(function(res) {
                  require('toastr').info(res);
                });
              }
            } else {
              debug('An error was occured when creating object in Dadabase');
              if (result.errors.length > 0) {
                $translate('tierce.errorOccured').then(function(res) {
                  require('toastr').error(res);
                });
                return;
              }
            }
          });
        }

        /**
         * Mettre à jour de feature dest à partir de feature src
         *
         * @param srcFeaures
         * @param destFeatures
         */
        function updateObject(srcFeaures, destFeatures) {
          debug('Src Features: ' + JSON.stringify(srcFeaures));
          debug('Dest Features : ' + JSON.stringify(destFeatures));

          var len = destFeatures.length;

          for (var i = 0; i < len; i++) {
            var feature = destFeatures[i];

            for (var key in feature) {
              var destObjValue = feature[key];
              debug(
                'key : ' + key + ', destValue : ' + JSON.stringify(destObjValue)
              );

              if (isObject(destObjValue) && key == 'properties') {
                var srcProperties = srcFeaures.properties;

                for (var property in destObjValue) {
                  var destValue = destObjValue[property];
                  if (bdd_oracle) {
                    var p = property.toLowerCase();
                  }
                  if (srcProperties.hasOwnProperty(p)) {
                    var srcValue = srcProperties[p];

                    // Update dest property value
                    destObjValue[p.toUpperCase()] = srcValue;
                  }
                }
              }
            }
          }
          debug('--> Result Features : ' + JSON.stringify(destFeatures));
        }

        /**
         * Créer  le feature dans la base et afficher le
         *
         * @param layerName
         * @param features
         */
        function createPointObjectAndDisplayObject(layerName, features) {
          var drawinteraction = new ol.interaction.Draw({
            source: gclayers.getDrawLayer().getSource(),
            type: 'Point',
          });

          drawinteraction.set('gctype', 'kis');
          drawinteraction.set('interaction', 'Draw');
          drawinteraction.set('widget', 'Tierce');

          _map.addInteraction(drawinteraction);

          // on start draw
          drawinteraction.on('drawstart', function(evt) {
            debug('drawstart');
          });

          // on end draw
          drawinteraction.on('drawend', function(evt) {
            var format = new ol.format.GeoJSON();
            var feature = format.writeFeatureObject(evt.feature);
            feature.properties = features.features[0].properties;

            createObjectInDataBaseAndDisplayCore(feature, layerName);

            _map.removeInteraction(drawinteraction);
          });
        }

        /**
         * Afficher le feature
         *
         * @param feature
         * @param layerName
         */
        function displayFeatureInDialog(feature, layerName) {
          if (feature && feature.properties) {
            var properties = feature.properties;

            var propertiesObj = [];
            angular.forEach(properties, function(value, key) {
              debug(key + ': ' + value);

              propertiesObj.push({ name: key, value: value });
            });

            _scope.tableTierce = new _ngTableParams(
              {
                page: 1, // show first page
                count: 4, // count per page
              },
              {
                counts: [], // hide page counts control
                total: 0, // length of data

                getData: function($defer, params) {
                  var displayedTab = propertiesObj.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                  );

                  params.total(propertiesObj.length); // set total for recal pagination
                  $defer.resolve(displayedTab);
                },
              }
            );

            var dialog = tierceService.open({
              scope: _scope,
              title: layerName,
              template:
                'js/XG/widgets/mapapp/tiercewidget/views/featureTable.html',
              showClose: true,
              onclose: function() {
                SelectManager.clear();

                // Remove the drawen feature
                var source = gclayers.getDrawLayer().getSource();
                source.removeFeature(_selectedFeature);
              },
            });
          }
        }

        /**
         *
         * @param config
         * @param target
         * @param defaultValue
         */
        function getAssocLayerInfo(config, target, defaultValue) {
          return getTargetConfigInfo(
            config,
            'association',
            target,
            defaultValue
          );
        }

        /**
         *
         * @param config
         * @param target
         * @param defaultValue
         */
        function getBufferInfo(config, target, defaultValue) {
          return getTargetConfigInfo(config, 'buffer', target, defaultValue);
        }

        /**
         *
         * @param config
         * @param target1
         * @param target2
         * @param defaultValue
         */
        function getTargetConfigInfo(config, target1, target2, defaultValue) {
          var result = '';

          if (defaultValue) {
            result = defaultValue;
          }

          if (!config || !target1 || !target2) {
            return result;
          }

          if (config.hasOwnProperty(target1)) {
            var object = config[target1];

            if (object.hasOwnProperty(target2) && object[target2] != '') {
              result = object[target2];
            }
          }

          return result;
        }

        /**
         * Créer la zonr d'intervention et afficher la
         *
         * @param layerName
         * @param features
         */
        function createZoneInterventionAndDisplayObject(layerName, features) {
          /*
           * Create the main object
           */
          var drawinteraction = new ol.interaction.Draw({
            source: gclayers.getDrawLayer().getSource(),
            type: 'Polygon',
          });

          drawinteraction.set('gctype', 'kis');
          drawinteraction.set('interaction', 'Draw');
          drawinteraction.set('widget', 'Tierce');

          _map.addInteraction(drawinteraction);

          // on start draw
          drawinteraction.on('drawstart', function(evt) {
            debug('drawstart');

            _scope.$on(ZONE_ASSOCIATION_ADD_EVENT, function(event, data) {
              createAssociatedIntervObjects(event, data);
            });
          });

          // on end draw
          drawinteraction.on('drawend', function(evt) {
            var format = new ol.format.GeoJSON();

            var feature = format.writeFeatureObject(evt.feature);
            _selectedFeature = evt.feature;
            var geometry = feature.geometry;

            // Get polygon extent
            var coords = geometry.coordinates;
            var polyCoords = new ol.geom.Polygon(coords, 'XY');

            var wktObj = new ol.format.WKT();
            var wktStr = wktObj.writeGeometry(polyCoords);

            var spatialClause = 'INTERSECTS(geom, ' + wktStr + ')';
            var selectedFids = gclayers.getSelectFilterasStringuid(_map);

            if (!selectedFids) {
              $translate('tierce.noLayerIsSelected').then(function(res) {
                require('toastr').error(res);
              });
              _map.removeInteraction(drawinteraction);

              return;
            }

            var crs = _map
              .getView()
              .getProjection()
              .getCode();

            // Add geometry
            features.features[0].geometry = geometry;

            /*
             * Get intersection objects with the polygon selection
             */
            QueryFactory.pmultidata(selectedFids, spatialClause, crs).then(
              function(res) {
                SelectManager.addFeaturesFromGeojson(res.data[0]);

                var assocObjecrts;
                if (res.data.features) {
                  assocObjecrts = res.data.features;
                } else {
                  assocObjecrts = res.data;
                }
                createZoneObjectInDataBaseAndSentEvent(
                  features,
                  assocObjecrts,
                  layerName
                );
                _map.removeInteraction(drawinteraction);
              }
            );
          });
        }

        /**
         * Créer la zone d'intervention dans la base et envoyer un event
         *
         * @param mainFeature
         * @param assocFeatures
         * @param layerName
         */
        function createZoneObjectInDataBaseAndSentEvent(
          mainFeature,
          assocFeatures,
          layerName
        ) {
          debug('Creating zone intervention ...');

          // Create zone object in DB
          debug('Feature : ' + JSON.stringify(mainFeature));
          debug('Features associations : ' + JSON.stringify(assocFeatures));

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          var crs = _scope.map
            .getView()
            .getProjection()
            .getCode();

          EditFactory.add(fid, mainFeature, crs).then(function(res) {
            debug('Object is done in table : ' + layerName);

            if (res.status == 200) {
              var result = res.data;

              if (result.errors.length > 0) {
                $translate('tierce.createObjectFailed').then(function(res) {
                  require('toastr').error(res + ': ' + result.errors[0]);
                });
                return;
              } else {
                var newId = result.create[0].id;
                debug('New id : ' + newId);

                displayFeatureInDialog(mainFeature.features[0], layerName);

                // Sent event to creation zone association objects
                _scope.$broadcast(ZONE_ASSOCIATION_ADD_EVENT, {
                  mainFeature: mainFeature,
                  mainLayerName: layerName,
                  mainId: newId,
                  assocFeatures: assocFeatures,
                });

                $translate('tierce.createIsDone').then(function(res) {
                  require('toastr').info(res);
                });
              }
            } else {
              debug('An error was occured when creating object in Dadabase');
              if (result.errors.length > 0) {
                $translate('tierce.errorOccured').then(function(res) {
                  require('toastr').error(res);
                });
                return;
              }
            }
          });
        }

        /**
         * Créer la zone curage dans la base et envoyer un event
         *
         * @param layerName
         * @param mainFeature
         * @param geometry
         * @param assocLayerName
         * @param assocFeatures
         */
        function createCurageObjectInDataBaseAndSentEvent(
          layerName,
          mainFeature,
          geometry,
          assocLayerName,
          assocFeatures
        ) {
          debug('Creating curage intervention ...');

          debug('Main feature : ' + JSON.stringify(mainFeature));
          debug('Main geometry : ' + JSON.stringify(geometry));
          debug('Associated features : ' + JSON.stringify(assocFeatures));

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          if (!fid) {
            $translate('tierce.noLayerFound').then(function(res) {
              require('toastr').error(layerName + ' : ' + res);
            });

            return;
          }

          mainFeature.features[0].geometry = geometry;

          debug('Main feature : ' + JSON.stringify(mainFeature));

          // Create curage object in DB
          var crs = _scope.map
            .getView()
            .getProjection()
            .getCode();

          EditFactory.add(fid, mainFeature, crs).then(function(res) {
            debug('Object curage is created in database');

            if (res.status == 200) {
              var result = res.data;

              if (result.errors.length > 0) {
                $translate('tierce.createObjectFailed').then(function(res) {
                  require('toastr').error(res + ': ' + result.errors[0]);
                });
                return;
              } else {
                var newId = result.create[0].id;

                debug('New id : ' + newId);

                displayFeatureInDialog(mainFeature.features[0], layerName);

                // Sent event to creation curage association objects
                _scope.$broadcast(CURAGE_ASSOCIATION_ADD_EVENT, {
                  mainFeature: mainFeature,
                  mainLayerName: layerName,
                  mainId: newId,
                  assocLayerName: assocLayerName,
                  assocFeatures: [assocFeatures],
                });

                $translate('tierce.createIsDone').then(function(res) {
                  require('toastr').info(res);
                });
              }
            } else {
              debug('An error was occured when creating object in Dadabase');
              if (result.errors.length > 0) {
                $translate('tierce.errorOccured').then(function(res) {
                  require('toastr').error(res);
                });
                return;
              }
            }
          });
        }

        /**
         * Créer l'intervention dans la base
         *
         * @param event
         * @param data
         */
        function createAssociatedIntervObjects(event, data) {
          debug('---> Event : ' + event.name);

          debug('---> Data received : ' + JSON.stringify(data));
          debug('Creating objects association ...');

          var mainFeature = data.mainFeature;
          var mainLayerName = data.mainLayerName;
          var mainId = data.mainId;
          var assocFeatures = data.assocFeatures[0].features;

          if (!assocFeatures || assocFeatures.length == 0) {
            console.log('No objects associated are found');

            return;
          }

          var featA = getAssocLayerInfo(_scope.config, 'feata', 'feata');
          var idA = getAssocLayerInfo(_scope.config, 'ida', 'ida');
          var featD = getAssocLayerInfo(_scope.config, 'featd', 'featd');
          var idD = getAssocLayerInfo(_scope.config, 'idd', 'idd');
          var relName = getAssocLayerInfo(_scope.config, 'relname', 'rel_name');

          // Create the relation objects in association table
          var features = [];
          for (var i = 0; i < assocFeatures.length; i++) {
            var assocFeature = assocFeatures[i];
            var assocObjId = assocFeature['id'];

            // Get assoc layer name
            var assocLayerName = assocObjId;
            var index = assocLayerName.lastIndexOf('.');
            if (index > 0) {
              assocLayerName = assocLayerName.substring(0, index);
            }

            var feature = {};
            var properties = {};
            properties[featD] = FeatureTypeFactory.getFeatureUidByName(
              mainLayerName
            );
            properties[idD] = mainId;

            properties[featA] = FeatureTypeFactory.getFeatureUidByName(
              assocLayerName
            );
            properties[idA] = assocObjId;

            properties[relName] = mainLayerName + '-' + assocLayerName;

            feature.type = 'feature';
            feature.properties = properties;

            features.push(feature);
          }

          createAssociatedObjects(features);

          // Remove the event
          if (event.name == CURAGE_ASSOCIATION_ADD_EVENT) {
            // Unregister the event CURAGE_ASSOCIATION_ADD_EVENT
            _curage_listenEvent();
          }
        }

        /**
         * Create the relation objects in association table
         *
         * @param features
         */
        function createAssociatedObjects(features) {
          debug('Create assoc object : ' + JSON.stringify(features));

          var tableName = getAssocLayerInfo(
            _scope.config,
            'layername',
            'CAJ_REL_AR'
          );

          var fid = FeatureTypeFactory.getFeatureUidByName(tableName);
          var crs = _scope.map
            .getView()
            .getProjection()
            .getCode();

          var featureCollection = {};
          featureCollection.type = 'FeatureCollection';
          featureCollection.features = features;

          debug(
            '--> Create object in DB : ' + JSON.stringify(featureCollection)
          );

          EditFactory.add(fid, featureCollection, crs).then(function(res) {
            debug('Assoc objects are done in database');

            if (res.status == 200) {
              var result = res.data;

              if (result.errors.length > 0) {
                $translate('tierce.createObjectFailed').then(function(res) {
                  require('toastr').error(res + ': ' + result.errors[0]);
                });
                return;
              } else {
                var newId = result.create[0].id;
                debug('Assoc object new id : ' + newId);

                $translate('tierce.createIsDone').then(function(res) {
                  require('toastr').info(res);
                });
              }
            } else {
              debug('An error was occured when creating object in Dadabase');
              if (result.errors.length > 0) {
                $translate('tierce.errorOccured').then(function(res) {
                  require('toastr').error(res);
                });
                return;
              }
            }
          });
        }

        /**
         * Supprimer le curage
         *
         * @param layerName
         */
        function removePlanningCurage(layerName) {
          debug('Couche : ' + layerName);

          var fid = FeatureTypeFactory.getFeatureUidByName(layerName);
          if (!fid) {
            $translate('tierce.noLayerFound').then(function(res) {
              require('toastr').error(layerName + ' : ' + res);
            });

            return;
          }

          // Remove objects
          EditFactory.deleteWhere(fid, '1=1').then(function(res) {
            debug('Delete objects is done in database');

            if (res.status == 200) {
              var result = res.data;

              if (result.errors.length > 0) {
                $translate('tierce.removeObjectsFailed').then(function(res) {
                  require('toastr').error(res + ': ' + result.errors[0]);
                });

                return;
              } else {
                $translate('tierce.removeObjectsSucces').then(function(res) {
                  require('toastr').info(res);
                });

                removeLayerAssociatedObjects(layerName);
                return;
              }
            }
          });
        }

        /**
         * Supprimer les objets dans la table d'association
         *
         * @param layerName
         */
        function removeLayerAssociatedObjects(layerName) {
          debug('Deleting associated objects to layer : ' + layerName);

          var featA = getAssocLayerInfo(_scope.config, 'feata', 'feata');
          var idA = getAssocLayerInfo(_scope.config, 'ida', 'ida');
          var featD = getAssocLayerInfo(_scope.config, 'featd', 'featd');
          var idD = getAssocLayerInfo(_scope.config, 'idd', 'idd');
          var relName = getAssocLayerInfo(_scope.config, 'relname', 'rel_name');
          var tableName = getAssocLayerInfo(
            _scope.config,
            'layername',
            'CAJ_REL_AR'
          );

          var objectAssocValue = {};
          objectAssocValue[featD] = FeatureTypeFactory.getFeatureUidByName(
            layerName
          );

          var whereClause = buildAssociationWhereClause(objectAssocValue);
          debug('Where clause : ' + whereClause);

          var fid = FeatureTypeFactory.getFeatureUidByName(tableName);
          // Remove objects
          EditFactory.deleteWhere(fid, whereClause).then(function(res) {
            debug('Delete objects is done in database');

            if (res.status == 200) {
              var result = res.data;

              if (result.errors.length > 0) {
                $translate('tierce.removeObjectsFailed').then(function(res) {
                  require('toastr').error(res + ': ' + result.errors[0]);
                });

                return;
              } else {
                $translate('tierce.removeObjectsSucces').then(function(res) {
                  require('toastr').info(res);
                });
              }
            } else {
              debug('An error was occured when deleting object from Dadabase');
              if (result.errors.length > 0) {
                $translate('tierce.errorOccured').then(function(res) {
                  require('toastr').error(res);
                });
                return;
              }
            }
          });
        }

        /**
         *
         * @param val
         */
        function isObject(val) {
          if (val === null) {
            return false;
          }
          return typeof val === 'object';
        }

        /**
         * Log
         *
         * @param msg
         */
        function debug(msg) {
          if (_isDebug && msg) {
            console.log(msg);
          }
        }

        /**
         * Créer une intervention
         *
         * @param layerName
         * @param objectsValues
         * @param targetLayerName
         * @param targetValues
         */
        function createIntervention(
          layerName,
          objectsValues,
          targetLayerName,
          targetValues
        ) {
          debug(
            'Couche : ' +
              layerName +
              ', Valeurs: ' +
              JSON.stringify(
                objectsValues +
                  'Couche : ' +
                  targetLayerName +
                  ', cible objets :' +
                  JSON.stringify(targetValues)
              )
          );

          var targetFid = FeatureTypeFactory.getFeatureUidByName(
            targetLayerName
          );
          if (!targetFid) {
            $translate('tierce.noLayerFound').then(function(res) {
              require('toastr').error(layerName + ' : ' + res);
            });

            return;
          }

          var whereClause = buildWhereClause2(targetValues);
          debug('Where clause : ' + whereClause);

          // Get target objects
          var promise = getObjectsByClauseWhere(targetFid, whereClause);

          promise.then(function(res) {
            if (
              res.data.features == undefined ||
              res.data.features.length == 0
            ) {
              $translate('tierce.noObjectFound').then(function(res) {
                require('toastr').error(res);
              });
            } else {
              debug('Objects found: ' + JSON.stringify(res.data));
              generateBufferAndCreateObjectsInDadabase(
                layerName,
                objectsValues,
                targetLayerName,
                res.data
              );
            }
          });
        }

        function removeHightLightFeature() {
          if (_scope.highLigtedFeature != undefined) {
            _scope.highLigtedFeature = gclayers.removehighLightFeatures(
              _scope.highLigtedFeature
            );
          }
        }

        function removeHightLightFeatureAfterSeconde(timeInsec) {
          var timeFct = setTimeout(removeHightLightFeature, timeInsec * 1000);
        }

        function updateCursor(cursor) {
          var element = _map.getTargetElement();
          element.style.cursor = cursor;
        }

        function getDirectoryFromPath(path, delimeter) {
          if (!path) {
            return path;
          }
          if (!delimeter) {
            delimeter = '.';
          }

          return path.split([delimeter])[0];
        }

        function getFileFromPath(path, delimeter) {
          if (!path) {
            return path;
          }
          if (!delimeter) {
            delimeter = '.';
          }

          return path.split([delimeter])[1];
        }
      };

      return new tierceFunctions();
    }; // End $get
    this.$get.$inject = [
      'gcSelect',
      'gcStyleFactory',
      '$http',
      '$q',
      'SelectManager',
      'gcPopup',
      'gclayers',
      'FeatureTypeFactory',
      '$translate',
      'QueryFactory',
      'ngDialog',
      'EditFactory',
      'zoomService',
      'tierceService',
      'GeometryFactory',
      'ConfigFactory',
      'ogcFactory',
      'GoogleGeocodeFactory',
      '$rootScope',
      'kisGeocodageFactory',
      'PortalsFactory',
    ];
  });

  return module;
});
