'use strict';
define([
  'angular',
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',

  'toastr',
  'ol3js',
], function(angular) {
  // Generate module tierce
  var module = angular.module('gc_restriction_provider', []);

  module.provider('gcRestrictionProvider', function() {

    var last_message_time = new Date();

    /*
     * Definition the $get function
     */
    this.$get = function($filter, $rootScope, $http) {
      function updateDate() {
        last_message_time = new Date();
      }

      function lastMessageInMinute() {

        var now = new Date();
        var diffSec = parseInt(
          (Math.abs(now.getTime() - last_message_time.getTime()) / 1000) % 60
        );

        if (diffSec >= 2) return true;
        else return false;
      }

      function lastMessageInSeconde() {
        var now = new Date();
        var diffSec = parseInt(
          (Math.abs(now.getTime() - last_message_time.getTime()) / 1000) % 60
        );

        if (diffSec >= 2) return true;
        else return false;
      }

      function hasRestriction() {
        if (
          $rootScope.xgos.user.restriction &&
          $rootScope.xgos.user.restriction.name &&
          $rootScope.xgos.user.restriction.modes
        )
          return true;
        else return false;
      }

      function hasRestrictionEdition() {
        if (
          $rootScope.xgos.user.restriction &&
          $rootScope.xgos.user.restriction.name &&
          $rootScope.xgos.user.restriction.modes &&
          $rootScope.xgos.user.restriction.modes.edition
        )
          return true;
        else return false;
      }

      function hasRestrictionQuery() {
        if (
          $rootScope.xgos.user.restriction &&
          $rootScope.xgos.user.restriction.name &&
          $rootScope.xgos.user.restriction.modes &&
          $rootScope.xgos.user.restriction.modes.query
        )
          return true;
        else return false;
      }

      function hasRestrictionViewer() {
        if (
          $rootScope.xgos.user.restriction &&
          $rootScope.xgos.user.restriction.name &&
          $rootScope.xgos.user.restriction.modes &&
          $rootScope.xgos.user.restriction.modes.viewer
        )
          return true;
        else return false;
      }


      function GeometryInRestriction(o, crs, useMode) {
        return $http.post(
          '/services/{portalid}/restrictions/geometry/geometryInRestriction?f=json&crs=' + crs + '&useMode=' + useMode,o
        );
      }


      function showErrorMessage() {
        if (angular.isUndefined(last_message_time)||lastMessageInMinute()) {
          updateDate();
          var errorMsg =
            '<h4>Info</h4> ' +
            $filter('translate')('rights.restriction.map.cause');
          errorMsg +=
            '<br/><h4>Details</h4>  ' +
            $filter('translate')('rights.restriction.map.details');
          require('toastr').info(errorMsg);
        }
      }

      function showDetailsErrorMessage(result) {

        if (
          (result.data.message || result.data.details) && (angular.isUndefined(last_message_time) || lastMessageInMinute())
        ) {
          updateDate();
          var errorMsg =
            '<h4>Info</h4> ' + $filter('translate')(result.data.message);
          if (result.data.details) {
            errorMsg +=
              '<br/><h4>Details</h4>  ' +
              $filter('translate')(result.data.details[0]);
          }
          require('toastr').info(errorMsg);
        }
      }

      function createGeometryFromExtent(extent) {
        var leftX = extent[0];
        var bottomY = extent[1];

        var rightX = extent[2];
        var topY = extent[3];
        return {
          type: 'Polygon',
          coordinates: [
            [leftX, bottomY],
            [rightX, bottomY],
            [rightX, topY],
            [leftX, topY],
            [leftX, bottomY],
          ],
        };
      }

      return {
        hasRestriction: hasRestriction,
        hasRestrictionEdition: hasRestrictionEdition,
        hasRestrictionQuery: hasRestrictionQuery,
        hasRestrictionViewer: hasRestrictionViewer,
        GeometryInRestriction: GeometryInRestriction,
        showErrorMessage: showErrorMessage,
        showDetailsErrorMessage: showDetailsErrorMessage,
        createGeometryFromExtent: createGeometryFromExtent,
        updateDate: updateDate,
        lastMessageInMinute: lastMessageInMinute,
        lastMessageInSeconde: lastMessageInSeconde,
      };
    };
    this.$get.$inject = ['$filter', '$rootScope', '$http'];
  });

  return module;
});
