'use strict';
define([
  'angular',
  'ol3js',

  'modules/tools/controllers/BuilderCtrl',
  'modules/tools/controllers/TrackerCtrl',
  'modules/tools/controllers/DocumentCtrl',
  'modules/tools/controllers/CalendarCtrl',
  'modules/tools/controllers/ActionsCtrl',
  'modules/tools/controllers/AtlasCtrl',
  'modules/tools/controllers/MajicEdigeoCtrl',
  'modules/tools/controllers/EdigeoCtrl',
  'modules/tools/controllers/MajicCtrl',
  'modules/tools/controllers/EdigeoComponentSuffixCtrl',
  'modules/tools/controllers/PortalMonitoringCtrl',
  'modules/tools/controllers/CheckUpCtrl',
  'modules/tools/controllers/ReportCtrl',


  'modules/tools/services/CalendarFactory',
  'modules/tools/services/AlertFactory',
  'modules/tools/services/TaskFactory',
  'modules/tools/services/ActionsFactory',
  'modules/tools/services/AtlasFactory',
  'modules/tools/services/CheckUpFactory',

  'modules/tools/directives/atlasCartographique',
  'modules/tools/directives/addReport',
  'modules/tools/directives/edigeo',
  'modules/tools/directives/majic',
  'modules/tools/directives/edigeoComponentList',
  'modules/tools/directives/edigeoCommuneList',
  'modules/tools/directives/edigeoComponentSuffix',
], function(
  angular,
  ol3js,
  BuilderCtrl,
  TrackerCtrl,
  DocumentCtrl,
  CalendarCtrl,
  ActionsCtrl,
  AtlasCtrl,
  MajicEdigeoCtrl,
  EdigeoCtrl,
  MajicCtrl,
  EdigeoComponentSuffixCtrl,
  PortalMonitoringCtrl,
  CheckUpCtrl,
  ReportCtrl,
  CalendarFactory,
  AlertFactory,
  TaskFactory,
  ActionsFactory,
  AtlasFactory,
  CheckUpFactory,
  atlasCartographique,
  addReport,
  edigeo,
  majic,
  edigeoComponentList,
  edigeoCommuneList,
  edigeoComponentSuffix
) {
  // Module
  var tools = angular.module('tools', ['mgcrea.ngStrap']);

  // Services
  tools.factory('CalendarFactory', CalendarFactory);
  tools.factory('AlertFactory', AlertFactory);
  tools.factory('TaskFactory', TaskFactory);
  tools.factory('ActionsFactory', ActionsFactory);
  tools.factory('AtlasFactory', AtlasFactory);
  tools.factory('CheckUpFactory', CheckUpFactory);

  // Controllers
  tools.controller('TrackerCtrl', TrackerCtrl);
  tools.controller('BuilderCtrl', BuilderCtrl);
  tools.controller('DocumentCtrl', DocumentCtrl);
  tools.controller('ActionsCtrl', ActionsCtrl);
  tools.controller('AtlasCtrl', AtlasCtrl);
  tools.controller('MajicEdigeoCtrl', MajicEdigeoCtrl);
  tools.controller('EdigeoCtrl', EdigeoCtrl);
  tools.controller('MajicCtrl', MajicCtrl);
  tools.controller('EdigeoComponentSuffixCtrl', EdigeoComponentSuffixCtrl);
  tools.controller('PortalMonitoringCtrl', PortalMonitoringCtrl);
  tools.controller('CheckUpCtrl', CheckUpCtrl);
  tools.controller('ReportCtrl', ReportCtrl);

  // Directives
  tools.directive('atlasCartographique', atlasCartographique);
  tools.directive('addReport', addReport);
  tools.directive('edigeo', edigeo);
  tools.directive('edigeoComponentList', edigeoComponentList);
  tools.directive('edigeoCommuneList', edigeoCommuneList);
  tools.directive('edigeoComponentSuffix', edigeoComponentSuffix);
  tools.directive('majic', majic);

  tools.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/builder/', {
        templateUrl: 'js/XG/modules/tools/views/builder.html',
        controller: BuilderCtrl,
      });
      $routeProvider.when('/calendar/', {
        templateUrl: 'js/XG/modules/tools/views/calendar.html',
        controller: CalendarCtrl,
      });

      $routeProvider.when('/tracker/', {
        templateUrl: 'js/XG/modules/tools/views/tracker.html',
        controller: TrackerCtrl,
      });
      $routeProvider.when('/documents/', {
        templateUrl: 'js/XG/modules/tools/views/documents.html',
        controller: DocumentCtrl,
      });
      $routeProvider.when('/reports/', {
        templateUrl: 'js/XG/modules/tools/views/reports.html',
        controller: ReportCtrl,
      });
      $routeProvider.when('/actions/', {
        templateUrl: 'js/XG/modules/tools/views/actions.html',
        controller: ActionsCtrl,
      });
      $routeProvider.when('/atlas/', {
        templateUrl: 'js/XG/modules/tools/views/atlas.html',
        controller: AtlasCtrl,
        resolve: { // Make sure translate is loaded in order to display translated types
          loadedTranslate: ['$translate', ($translate) => $translate('init').catch(() => true)]
        }
      });
      $routeProvider.when('/majicedigeo/', {
        templateUrl: 'js/XG/modules/tools/views/majicedigeo.html',
        controller: MajicEdigeoCtrl,
      });
      $routeProvider.when('/portal_monitoring/', {
        templateUrl: 'js/XG/modules/tools/views/portal_monitoring.html',
        controller: PortalMonitoringCtrl,
      });
      $routeProvider.when('/checkUp/', {
        templateUrl: 'js/XG/modules/tools/views/checkUp.html',
        controller: CheckUpCtrl,
      });
    },
  ]);
  return tools;
});
