/////////////////////////////////////////////////////////////
// Gestion de la configuration des règles métiers.
/////////////////////////////////////////////////////////////
'use strict';
define(function() {
  var gcelement = function($filter, $rootScope, AtlasFactory) {
    return {
      templateUrl:
        'js/XG/modules/tools/views/directives/atlasCartographique.html',
      restrict: 'E',
      scope: {
        currentatlasressource: '=currentAtlasRessource',
      },
      link: function(scope) {
        scope.types = [
          $filter('translate')('model.featuretypes.actions.JasperModel'),
          $filter('translate')('model.featuretypes.actions.StaticModel'),
        ];

        scope.currentatlasressource.pagedegarde =
          scope.currentatlasressource.pagedegarde || {};
        scope.currentatlasressource.pagedefin =
          scope.currentatlasressource.pagedefin || {};
        scope.initialPrintModel = scope.currentatlasressource.printModel;
        //-- Il faut affecter le printModel aprés avoir construit les options
        //-- du select, sans quoi le modèle d'impression initial n'apparaît 
        //-- comme sélectionné, soit comme modèle courant de l'atlas.
        //-- Donc on sauvegarde le modèle courant, et on le met à blanc,
        //-- pour le positionner une fois la liste des valeurs possibles construite.
        scope.currentatlasressource.printModel = '';

        AtlasFactory.getAtlasModel($rootScope.xgos.portal.uid + '.json').then(
          function(res) {
            if (res.data.etat === 'fini') {
              var data = res.data.data;
              scope.printModels = [];
              if (Object.keys(data.layouts).length > 0) {
                for (var i = 0; i < Object.keys(data.layouts).length; i++) {
                  var model = Object.keys(data.layouts)[i];
                  var containVariable = false;
                  try {
                    var d = data.layouts[model].mainPage.items;
                    d.map(function(item) {
                      angular.forEach(item, function(value, key) {
                        if (
                          value.toString().includes('${') &&
                          [
                            'scale',
                            'date',
                            'rotation',
                            'pagenum',
                            'pagetot',
                            'now',
                            'configdir',
                          ].indexOf(
                            value
                              .toString()
                              .split('{')[1]
                              .split('}')[0]
                              .toLowerCase()
                              .split(' ')[0]
                          ) === -1
                        )
                          containVariable = true;
                      });
                    });
                    if (!containVariable) {
                      scope.printModels.push(model);
                    }
                  } catch (e) {
                    console.log('no main page or items');
                  }
                }
                //-- La liste des valeurs possible du SELECT est construite,
                //-- on peut affecter la valeur courante du modèle de l'atlas
                //-- afin qu'il apparaisse.
                scope.currentatlasressource.printModel =
                  scope.initialPrintModel;
              } else {
                require('toastr').error($filter('translate')('atlas.nomodel'));
              }
            }
          }
        );

        /*PrintModelFactory.getmodellist().then(function (res) {
                    scope.printModels = res.data.map(function(x){return x.name;});
                });*/
      },
    };
  };

  gcelement.$inject = ['$filter', '$rootScope', 'AtlasFactory'];
  return gcelement;
});
