/**
 *
 */
'use strict';
define(function() {
  /**
   * Tracker Ctrl
   * @param $scope
   * @constructor
   */
  var TrackerCtrl = function($scope, LogTrackerFactory, ngTableParams) {
    LogTrackerFactory.getSize().then(function(res) {
      console.log(res.data);
      $scope.size = parseInt(res.data);
    });

    // init get
    $scope.tableParams = new ngTableParams(
      { page: 1, count: 10 },
      {
        total: 0,
        getData: function($defer, params) {
          var page = params.page();
          var count = params.count();
          LogTrackerFactory.getlogs('', null, page, count).then(function(res) {
            //params.total(res.data.totalFeatures);

            params.total($scope.size);
            $defer.resolve(res.data.features);
          });
        },
      }
    );
  };

  TrackerCtrl.$inject = ['$scope', 'LogTrackerFactory', 'ngTableParams'];
  return TrackerCtrl;
});
