'use strict';

/**
 * @ngdoc controller
 * @name modules.tools.controllers:MajicCtrl
 * @description
 * The MajicCtrl controller
 */
define(function() {
  var MajicCtrl = function(
    $scope,
    $filter,
    ImportExportFactory,
    DataStoreFactory,
    processFactory,
    $interval,
    gaDomUtils,
    FeatureAttachmentFactory,
    $timeout,
    $http
  ) {
    var TYPE = 'load majic';

    $scope.dialogContent =
      '<div>Confirmez vous la suppresion de [!!1!!] ?</div>';
    $scope.dialogContent += '<div>';
    $scope.dialogContent +=
      "  <button ng-click='removeAttachedFile()'>Oui</button>";
    $scope.dialogContent +=
      "  <button ng-click='cancelRemoveAttachedFile()'>Non</button>";
    $scope.dialogContent += '</div>';

    let dataFromZip = null;

    $scope.initFileMajic = function(inputFile, aFile) {
      if (aFile === undefined) {
        $scope.lastFile = inputFile.files[0];
      }

      else {
        if ($scope.lastFileByType == undefined) $scope.lastFileByType = {};
        $scope.lastFileByType[aFile.type] = inputFile.files[0];
      }
      //inputFile.value = null;
    };

    $scope.initFileMajic2 = (inputFile, aFile) => {
      if (aFile === undefined) {
        $scope.lastFile = inputFile.files[0];
      }
      else {
        if ($scope.lastFileByType == undefined) $scope.lastFileByType = {};
        $scope.lastFileByType[aFile.type] = inputFile.files[0];
       
      }
     
    };


    $scope.uploadMajicFile1 = function(theFile, layername, id) {
      FeatureAttachmentFactory.uploadFile(theFile, layername, id).then(
        function(res) {
          $scope.wait = false;
          $timeout(function() {
            gaDomUtils.hideGlobalLoader();
          }, 750);
          $scope.getAlreadyUploadedFiles();
        },
        function() {
          gaDomUtils.hideGlobalLoader();
          $scope.getAlreadyUploadedFiles();
        }
      );
    };

    $scope.uploadMajicFile = function(aFile) {
      let chosenFile, layername;
      if (aFile.type == 'zipfile') chosenFile = $scope.lastFile;
      else if (
        $scope.lastFileByType != undefined &&
        $scope.lastFileByType[aFile.type] != undefined
      )
        chosenFile = $scope.lastFileByType[aFile.type];

      if (chosenFile != undefined) {
        $scope.fileToUploadName = chosenFile.name;
        $scope.wait = true;
        gaDomUtils.showGlobalLoader();
        var idfile = Date.now();
        if (aFile.type != 'zipfile') {
          //-- Cas fichier par fichier
          idfile = aFile.type;
          layername = 'majic';
        }
        //-- Cas du dossier compressé contenant toutes les communes.
        else layername = 'majic_zip';

        if (aFile.type != 'zipfile')
          //-- Un seul fichier par tpe de fichier (par exemple,un seul fichier bati)
          //-- donc on supprimes les ficheir préexistant pour ce type de fichier.
          FeatureAttachmentFactory.removeall(layername, idfile).then(
            function() {
              $scope.uploadMajicFile1(chosenFile, layername, idfile);
            }
          );
        //-- Plusieurs fichier ZIP peuvent être chargés, on ne passe pas par l'étape de suppression.'
        else $scope.uploadMajicFile1(chosenFile, layername, idfile);
      }
    };

    $scope.uploadMajicZipFile = function() {
      var aFile = {};
      aFile.type = 'zipfile';
      $scope.uploadMajicFile(aFile);
    };

    let firstStep = "not ok ";

    $scope.loadDataStores = function() {
      DataStoreFactory.get().then(function(res) {
        $scope.dbselector = {};
        if (res.data.length != 0) {
          $scope.datasources = res.data;
          $scope.dbselector.object = res.data;
          if (res.data.length == 1) $scope.dbselector.choice = res.data[0].name;
          else $scope.dbselector.choice = '';
        }
      });
    };

    $scope.refreshList = function() {
      gaDomUtils.showGlobalLoader();
      processFactory.getProcessByUsertype(TYPE).then(
        function(res) {
          $scope.currentProcess = res.data;
          //$scope.tableParamsProcessus.reload();
          gaDomUtils.hideGlobalLoader();
        },
        function() {
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    $scope.getResponseFile = function(d) {
      switch (d.etat) {
        case 'FINISHED':
          $scope.refreshList();
          break;
        case 'FAILED':
          require('toastr').error(d.reason);
          break;
      }
    };

    $scope.setProgressBar = function(value) {
      var elt = document.getElementById('majic_pb');
      elt.style.width = '' + value + '%';
    };

    $scope.setLogButtons = function(data) {
      var logElts;
      if ($scope.logs == undefined) $scope.logs = {};
      $scope.logs.errors = undefined;
      $scope.logs.warnings = undefined;
      if (data.extraInfos != undefined)
        for (var ilog = 1; ilog < data.extraInfos.length; ilog++) {
          logElts = data.extraInfos[ilog].split(':');
          $scope.logs[logElts[0]] = logElts[1];
        }
    };

    $scope.setProgressBar = function(value) {
      var elt = document.getElementById('majic_pb');
      var iStart = 15;
      if ($scope.pbValuePrec == value) $scope.pbSameValueSince++;
      else $scope.pbSameValueSince = 0;
      $scope.pbValuePrec = value;
      elt.style.width = '' + value + '%';
      $scope.pbValue = '' + value + '%';
      if (
        ++$scope.pbSameValueSince >= iStart &&
        $scope.pbSameValueSince <= iStart + 2
      )
        elt.style.backgroundColor = '#45f';
      else if (
        $scope.pbSameValueSince >= iStart + 3 &&
        $scope.pbSameValueSince <= iStart + 4
      )
        elt.style.backgroundColor = '#67f';
      else if (
        $scope.pbSameValueSince >= iStart + 5 &&
        $scope.pbSameValueSince <= iStart + 6
      )
        elt.style.backgroundColor = '#45f';
      else if ($scope.pbSameValueSince > iStart + 6) {
        elt.style.backgroundColor = '#67f';
        $scope.pbSameValueSince = 0;
      }
    };

    $scope.setStep = function(data, finishedOrFailed) {
      var iLastStepDone, iStep;
      var step;

      $scope.setProgressBar(data.progress);
      if (data.extraInfo != undefined) step = data.extraInfo.toLowerCase();
      else step = 'creationbase';
      $scope.setProgressBar(data.progress);
      if (data.extraInfo == undefined || step == 'creationbase')
        iLastStepDone = -1;
      else if (step == 'listecommunes') iLastStepDone = 0;
      else if (step == 'bati') iLastStepDone = 1;
      else if (step == 'nonbati') iLastStepDone = 2;
      else if (step == 'pdl') iLastStepDone = 3;
      else if (step == 'prop') iLastStepDone = 4;
      else if (step == 'fantoir') iLastStepDone = 5;

      if (finishedOrFailed == 'launching') {
        for (iStep = 0; iStep < $scope.loadingSteps.length; iStep++) {
          $scope.loadingSteps[iStep].status = 'waiting';
          $scope.loadingSteps[iStep].statusLbl = $filter('translate')(
            'tools.majicedigeo.edigeo.waiting'
          );
          $scope.loadingSteps[iStep].errorMessage = '';
        }
      } else if (finishedOrFailed == 'finished') {
        for (iStep = 0; iStep < $scope.loadingSteps.length; iStep++) {
          $scope.loadingSteps[iStep].status = 'done';
          $scope.loadingSteps[iStep].statusLbl = $filter('translate')(
            'tools.majicedigeo.edigeo.done'
          );
        }
      } else if (finishedOrFailed == 'failed') {
        $scope.loadingSteps[iLastStepDone + 1].status = 'failed';
        $scope.loadingSteps[iLastStepDone + 1].statusLbl = $filter('translate')(
          'tools.majicedigeo.edigeo.failed'
        );
        $scope.loadingSteps[iLastStepDone + 1].errorMessage = data.errorMessage;
      } else {
        for (iStep = 0; iStep <= iLastStepDone; iStep++) {
          $scope.loadingSteps[iStep].status = 'done';
          $scope.loadingSteps[iStep].statusLbl = $filter('translate')(
            'tools.majicedigeo.edigeo.done'
          );
        }
        $scope.loadingSteps[iLastStepDone + 1].status = 'running';
        $scope.loadingSteps[iLastStepDone + 1].statusLbl = $filter('translate')(
          'tools.majicedigeo.edigeo.running'
        );
      }
      $scope.setLogButtons(data);
    };

    /**
     *     Suppression de tous les fichiers EDIGEO chargés sur le serveur.
     *  Cette fonction est appelée quand la conversion s'est terminée avec succés.
     */
    $scope.cleanMajicFiles = function() {
      var iFile, idProp, fileList, layername;
      var fileCnt = 0;

      if ($scope.radMajicSource.choice == 'zippedfolder') {
        layername = 'majic_zip';
        idProp = 'attachmentObjectId';
        fileList = $scope.majicZipFiles;
      } else {
        layername = 'majic';
        idProp = 'type';
        fileList = $scope.majicFiles;
      }

      //-- Dans le cas où on a chargé les données depuis un ZIP des fichiers Majic,
      //-- on supprime le dit fichier ZIP.
      for (iFile = 0; iFile < fileList.length; iFile++) {
        FeatureAttachmentFactory.removeall(
          layername,
          fileList[iFile][idProp]
        ).then(function() {
          //-- Quand on vient de supprimer le dernier ficheir, on rafraichit la liste.
          if (++fileCnt >= fileList.length) $scope.getAlreadyUploadedFiles();
        });
      }
    };

    $scope.getPrefixes = function() {
      var iPref,
        ret = '';

      for (iPref = 0; iPref < $scope.majicPrefixes.length; iPref++) {
        if (ret.length != 0) ret += '_sep_';
        ret +=
          $scope.majicPrefixes[iPref].id +
          '_eq_' +
          $scope.majicPrefixes[iPref].value;
      }

      return ret;
    };

    /**
     *     Fonction qui appel selon un interval de temps adaptif
     *  le service qui consulte l'état d'avancement de l'intégration.
     *
     *  resdata0: description du processus lancé.
     *  intervalSec:  Interval d'appel du service en MilliSecondes.
     */

    $scope.checkProcessProgression = function(resdata0, intervalSec) {
      if (intervalSec == undefined) intervalSec = 750;
      $scope.intervalCounter = 0;
      var stop = $interval(function() {
        $scope.intervalCounter++;
        if (resdata0.creation)
          resdata0.creation = new Date(resdata0.creation).getTime();
        if (resdata0.end) resdata0.end = new Date(resdata0.end).getTime();
        ImportExportFactory.getProgressionEdigeo(resdata0).then(
          function(res) {
            if (res.data.etat === 'FINISHED' && res.data.progress === 100) {
              $interval.cancel(stop);
              $scope.getResponseFile(res.data);
              $scope.setStep(res.data, 'finished');
              $scope.cleanMajicFiles();
              //-- Un petit délai pour laisser le 100% de la barre de progression visible un instant.
              $timeout(function() {
                $scope.conversionStopped(res.data);
              }, 3500);
            } else if ($scope.loadingLaunched && res.data.etat === 'FAILED') {
              $interval.cancel(stop);
              //                                require('toastr').error($filter('translate')('tools.majicedigeo.edigeo.noedigeoloading'));
              require('toastr').error(res.data.errorMessage);
              $scope.setStep(res.data, 'failed');
              $scope.conversionStopped(res.data);
            } else {
              //-- Toujours en train de tourner
              $scope.setStep(res.data);
              if ($scope.intervalCounter > 100 && intervalSec < 90000) {
                //-- Au plus c'est long, au moins on va interroger
                //-- le serveur fréquemment sur l'état d'avancement.
                $interval.cancel(stop);
                $scope.checkProcessProgression(resdata0, 2 * intervalSec);
                $scope.intervalCounter = 0;
              }
            }
          },
          () => {
            if ($scope.loadingLaunched) {
              gaDomUtils.removeLocalLoader('.' + $scope.widgetName);
              $interval.cancel(stop);
              require('toastr').error(
                $filter('translate')('tools.majicedigeo.edigeo.noedigeoloading')
              );
              $scope.conversionIsRunning = false;
            }
          }
        );
      }, intervalSec);
    };

 
    $scope.loadMajicIntoDb = () => {
      let suppresspreviousdata = document.getElementById("cancelorReplace").checked;
     
      let replace = '',
        typeope;

      $scope.loadingLaunched = true;
      $scope.setCurrentLoadDescription(new Date());
      if ($scope.replace == '1') {
         replace = '_replace';
      }  

      /*
      * http://127.0.0.1/services/kisf627b691-f98c-4f3a-8caf-7fe9c1b89611/
      *        loading/loadEdigeo?communes=13016&typedonneesentree=web&datasource=edg_tests
      *
      *    Le code département est nécessaire dans le cas ou des fichiers EDIGEO sont upmoadés
      *  car cette information n'est pas disponible dans les fichiers fournis.'
      */
   
      const selectedDatabaseObject = $scope.dbselector.object.find(element => element.name === $scope.dbselector.choice.name);
    
     
      typeope = 'majic_' + $scope.radMajicSource.choice + replace;
      $scope.newProgressBar = true;

    
      ImportExportFactory.loadMajic(
        selectedDatabaseObject.database,
        selectedDatabaseObject.host,
        selectedDatabaseObject.user,
        selectedDatabaseObject.password,
        selectedDatabaseObject.schema,
        selectedDatabaseObject.port,
        typeope,
        $scope.getPrefixes(),
        ($scope.departementcode.choice1).toString(),
        ($scope.datalot.choice1).toString(),
        suppresspreviousdata,
        parseInt($scope.dataformat.choice1),
        parseInt($scope.datayear.choice1),
        selectedDatabaseObject.name
    
      ).then((res) => {
        if (res.data){
          if (res.data[1] === "0"){
            require('toastr').success($filter('translate')('tools.majicedigeo.majic.importok'))
          } else {
            require('toastr').error($filter('translate')('tools.majicedigeo.majic.importerror'))
          }
        }
       $scope.newProgressBar = false
      
      });
      $scope.departementcode.choice1 = '';
      $scope.datalot.choice1 = '';        
    };



    $scope.setPrevLoadDescription = function(
      datedebut,
      datefin,
      etat,
      errmess
    ) {
      if (etat == 'FAILED'){
        $scope.previousLoadDescription = 'Echec du dernier chargement.  ';
      }
      else { $scope.previousLoadDescription = 'Succés du dernier chargement.  ';
    }

      if ($scope.radMajicSource.choice == 'web') {
        $scope.previousLoadDescription +=
          'Chargement précédent: Fichiers indépendants';
      }
      else { 
        $scope.previousLoadDescription += 'Chargement précédent : Fichier ZIP ';
      }
      if ($scope.replace == '1') {
        $scope.previousLoadDescription += ' en mode remplacement ';
      }
      else{ $scope.previousLoadDescription += ' en mode ajout ';
    }
      $scope.previousLoadDescription +=
        ' dans la base de données ' + $scope.dbselector.choice;
      $scope.previousLoadDescription2 =
        'Commencé le ' +
        datedebut.toLocaleDateString() +
        ' à ' +
        datedebut.toLocaleTimeString();
      $scope.previousLoadDescription3 =
        'Finit le ' +
        datefin.toLocaleDateString() +
        ' à ' +
        datefin.toLocaleTimeString();
      if (etat == 'FAILED') {
        $scope.previousLoadDescription4 = 'Erreur: ' + errmess;
      }
      else {
        $scope.previousLoadDescription4 = '';
    }
    };

    $scope.setCurrentLoadDescription = function(datedebut) {
      if ($scope.radMajicSource.choice == 'onefilebytype')
        $scope.loadDescription =
          'Chargement des données Majic par fichiers indépendant ';
      else
        $scope.loadDescription = 'Chargement des données Majic du fichier ZIP ';
      if ($scope.replace == '1')
        $scope.loadDescription += ' en mode remplacement ';
      else $scope.loadDescription += ' en mode ajout ';
      $scope.loadDescription +=
        ' dans la base de données ' + $scope.dbselector.choice;
      $scope.loadDescription2 =
        'Commencé le ' +
        datedebut.toLocaleDateString() +
        ' à ' +
        datedebut.toLocaleTimeString();
    };

    $scope.readInfoFromExtraInfo = function(
      extraInfo,
      datedebut,
      datefin,
      etat,
      errmess
    ) {
      if (extraInfo != undefined) {
        var currentLoad = JSON.parse(
          extraInfo.replace(/'/g, '"').replace(/\\/g, '/')
        );
        if (currentLoad.typedonneesentree.indexOf('zippedfolder') == -1)
          $scope.radMajicSource.choice = 'zippedfolder';
        else $scope.radMajicSource.choice = 'onefilebytype';
        if (currentLoad.typedonneesentree.indexOf('replace') == -1)
          $scope.replace = '0';
        else $scope.replace = '1';
        $scope.dbselector.choice = currentLoad.datasource;
      }
      if (datefin == undefined)
        //-- Pas de date de fin donc le process tourne toujours.
        $scope.setCurrentLoadDescription(datedebut);
      //-- Date de fin fournie donc le process est terminé.
      else $scope.setPrevLoadDescription(datedebut, datefin, etat, errmess);
    };

    /**
     *     La conversion est finie, on affiche l'état de ce dernier traitement.
     */

    $scope.conversionStopped = function(resdata) {
      var d1, d2, etat, ei;

      $scope.conversionIsRunning = false;
      d1 = new Date(resdata.creation);
      d2 = new Date(resdata.end);
      etat = resdata.etat;
      if (resdata.extraInfos != null) ei = resdata.extraInfos[1];
      else ei = undefined;
      $scope.readInfoFromExtraInfo(ei, d1, d2, etat, resdata.errorMessage);
    };

    $scope.getExistingProcesses = function() {
      var ts = 0,
        indOfLast = -1;
      var d1;

      processFactory.getProcessByUsertype(TYPE).then(function(res) {
        var ind;
        $scope.currentProcess = res.data;
        if (res.data != undefined && res.data.length != 0) {
          for (ind = 0; ind < res.data.length; ind++) {
            if (res.data[ind].etat == 'RUNNING') {
              $scope.conversionIsRunning = $scope.loadingLaunched = true;
              if (res.data[ind].both != undefined) delete res.data[ind].both;
              $scope.checkProcessProgression(res.data[ind]);
              d1 = new Date(res.data[ind].creation);
              $scope.readInfoFromExtraInfo(res.data[ind].extraInfos[1], d1);
            } else {
              if (res.data[ind].creation > ts) {
                ts = res.data[ind].creation;
                indOfLast = ind;
              }
            }
          }
          if (!$scope.conversionIsRunning && indOfLast != -1)
            $scope.conversionStopped(res.data[indOfLast]);
        }
      });
    };

    $scope.prepareLoadingSteps = function() {
      $scope.loadingSteps = [];
    };

    $scope.getFmtValPos2 = function(val) {
      if (val.length == 1) val = '0' + val;
      return val;
    };

    $scope.getFmtDate = function(dd) {
      var fmtDate;

      fmtDate = $scope.getFmtValPos2('' + dd.getDate()) + '/';
      fmtDate += $scope.getFmtValPos2('' + (1 + dd.getMonth())) + '/';
      fmtDate += dd.getFullYear() + ' ';
      fmtDate += $scope.getFmtValPos2('' + dd.getHours()) + ':';
      fmtDate += $scope.getFmtValPos2('' + dd.getMinutes()) + ':';
      fmtDate += $scope.getFmtValPos2('' + dd.getSeconds());

      return fmtDate;
    };

    $scope.getFmtDate = function(dd) {
      var fmtDate;

      fmtDate = $scope.getFmtValPos2('' + dd.getDate()) + '/';
      fmtDate += $scope.getFmtValPos2('' + (1 + dd.getMonth())) + '/';
      fmtDate += dd.getFullYear() + ' ';
      fmtDate += $scope.getFmtValPos2('' + dd.getHours()) + ':';
      fmtDate += $scope.getFmtValPos2('' + dd.getMinutes()) + ':';
      fmtDate += $scope.getFmtValPos2('' + dd.getSeconds());

      return fmtDate;
    };

    /**
     *    Demande au serveur de nous donner la liste des fichiers MAJIC chargés.
     * Il y a deux familles de fichiers, les fichiers ZIP et les fichiers MAJIC individuels.
     * Les fichiers ZIP contiennent une arborescence qui à un moment donné donne accés
     * aux fichiers bati, non bati, pdl, prop, et éventuellement fantoir de chaque commune.
     * Les fichiers MAJICC individuels sont chacun des fichiers descriptifs
     * du bati, du non bati, des propriétaires, des pdl et de fantoir.
     */
    $scope.getAlreadyUploadedFiles = function() {
      if ($scope.edigeoFiles == undefined) $scope.edigeoFiles = [];
      for (var ii2 = 0; ii2 < $scope.majicFiles.length; ii2++)
        $scope.majicFiles[ii2].name = '';

      ImportExportFactory.getUploadedMajic().then(function(res) {
        var dd;
        $scope.majicZipFiles.splice(0, $scope.majicZipFiles.length);
        if (res.data.length != undefined) {
          for (var ii = 0; ii < res.data.length; ii++) {
            if (res.data[ii].type == 'majic_zip') {
              dd = res.data[ii].date;
              res.data[ii].attachmentObjectId = dd;
              res.data[ii].date = $scope.getFmtDate(new Date(dd));
              $scope.majicZipFiles.push(res.data[ii]);
            } else
              for (var ii2 = 0; ii2 < $scope.majicFiles.length; ii2++) {
                if ($scope.majicFiles[ii2].type == res.data[ii].type) {
                  $scope.majicFiles[ii2].name = res.data[ii].name;
                  break;
                }
              }
          }
        }
      });
    };

    $scope.defineListOfFiles = function() {
      $scope.majicFiles = [];
      $scope.majicFiles.push({ type: 'bati', typelbl: 'Bâti', name: '' });
      $scope.majicFiles.push({
        type: 'non_bati',
        typelbl: 'Non Bâti',
        name: '',
      });
      $scope.majicFiles.push({ type: 'pdl', typelbl: 'PDL', name: '' });
      $scope.majicFiles.push({
        type: 'proprietaires',
        typelbl: 'Propriétaire',
        name: '',
      });
      $scope.majicFiles.push({
        type: 'fantoir',
        typelbl: 'Fantoir',
        name: '',
      });

      $scope.majicZipFiles = [];

      $scope.majicPrefixes = [];
      $scope.majicPrefixes.push({ id: 'bati', value: 'BATI' });
      $scope.majicPrefixes.push({ id: 'non_bati', value: 'NBAT' });
      $scope.majicPrefixes.push({ id: 'pdl', value: 'PDLL' });
      $scope.majicPrefixes.push({ id: 'proprietaires', value: 'PROP' });
      $scope.majicPrefixes.push({ id: 'fantoir', value: 'FANR' });
    };

    $scope.init = () => {
      $scope.newProgressBar = false;
      $scope.yearsForFormat = [{value: 2011}, {value: 2012}, {value:2013}, {value: 2014}, {value: 2015}, {value: 2016}, {value: 2017},
       {value: 2018}, {value:2019},{value: 2020}, {value:  2021}]

       $scope.yearsForData = [{value: 2011}, {value: 2012}, {value:2013}, {value: 2014}, {value: 2015}, {value: 2016}, {value: 2017},
        {value: 2018}, {value:2019},{value: 2020}, {value:  2021}, {value:  2022}]
   
      $scope.scriptSql = ''
     
      $scope.conversionIsRunning = false;
      $scope.replace = '1';
      $scope.departementcode; 
      $scope.datalot;
      $scope.datayear; 
      $scope.dataformat; 
    
      $scope.departementcode1;
      $scope.datalot1; 

      $scope.departementcode2; 
      $scope.datalot2; 
      
      $scope.radMajicSource = {};
      $scope.radMajicSource.choice = 'zippedfolder';

      $scope.defineListOfFiles();
      $scope.loadDataStores();
      $scope.getAlreadyUploadedFiles();
    };


    $scope.conversionIsDisabled = () => {

      if ($scope.conversionDisabledCause === undefined){

        $scope.conversionDisabledCause = [];
      }
      else {
        $scope.conversionDisabledCause.splice(
          0,
          $scope.conversionDisabledCause.length
        );
      }

      if (
        $scope.dbselector === undefined ||
        $scope.dbselector.choice === undefined ||
        $scope.dbselector.choice.length === 0
      )

        $scope.conversionDisabledCause.push(
          $filter('translate')('tools.majicedigeo.edigeo.nodatabaseselected')
        );

        if (
          !$scope.departementcode || !$scope.departementcode.choice1
        )
          $scope.conversionDisabledCause.push(
            $filter('translate')('tools.majicedigeo.majic.nodepartementdatagiven')
          );
  
        if (
          $scope.datalot === undefined || $scope.datalot.choice1 === undefined 
        )
          $scope.conversionDisabledCause.push(
            $filter('translate')('tools.majicedigeo.majic.nodatalotgiven')
          );
  

      if ($scope.radMajicSource.choice == 'zippedfolder') {
        if ($scope.majicZipFiles.length == 0){
          $scope.conversionDisabledCause.push('Fichier compressé absent.');
      }
        var p = $scope.majicPrefixes;
        for (var ii = 0; ii < p.length; ii++) {
          if (p[ii].value.length === 0){
            $scope.conversionDisabledCause.push(
              'Il manque le préfixe pour les fichiers de type ' + p[ii].id + '.'
            );
        }
        }
        
      } 

      return (
        $scope.conversionDisabledCause.length != 0 || $scope.conversionIsRunning
      );
    };

    $scope.downloadLogs = function(url) {
      window.open(url);
    };

    $scope.isRecommendedFilePrefix = (type) => {
      for (let i=0; i<majicPrefixes.length; i++){
        if (majicPrefixes[i].id == type && majicPrefixes[i].choice == type){
          return true;
        }
      }
      return false;
    }


    $scope.removeUploadedFile = function(aFile) {
      FeatureAttachmentFactory.removeall(
        'majic_zip',
        aFile.attachmentObjectId
      ).then(function() {
        $scope.getAlreadyUploadedFiles();
      });
    };

    $scope.init();
  };

  MajicCtrl.$inject = [
    '$scope',
    '$filter',
    'ImportExportFactory',
    'DataStoreFactory',
    'processFactory',
    '$interval',
    'gaDomUtils',
    'FeatureAttachmentFactory',
    '$timeout',
  ];
  return MajicCtrl;
});
