'use strict';

/**
 * @ngdoc controller
 * @name modules.authentication.controller:EdigeoComponentSuffixCtrl
 * @description
 * The EdigeoComponentSuffixCtrl controller
 */
define(function() {
  let EdigeoComponentSuffixCtrl = function($scope, gaJsUtils) {
    $scope.initYears = function() {
      let x;
      const y = gaJsUtils.getCurrentYear();
      $scope.years = [];
      for (let iYear = 0; iYear < 10; iYear++) {
        x = y - iYear;
        $scope.years.push({ value: x });
      }
    };
    $scope.init = function() {
      $scope.mode = 'list';
      $scope.initYears();
      $scope.$watch('yearFromList', function() {
        $scope.edigeoComponents.suffix = $scope.yearFromList;
      });
      $scope.$watch('mode', function() {
        if ($scope.mode === 'list')
          $scope.edigeoComponents.suffix = $scope.yearFromList;
      });
      $scope.$watch('edigeoComponents.suffix', function() {
        let suffix = $scope.edigeoComponents.suffix;
        if (gaJsUtils.isNumeric(suffix)) {
          $scope.yearFromList = parseInt(suffix);
        }
      });
    };

    $scope.init();
  };

  EdigeoComponentSuffixCtrl.$inject = ['$scope', 'gaJsUtils'];
  return EdigeoComponentSuffixCtrl;
});
