'use strict';

/**
 * @ngdoc controller
 * @name modules.authentication.controller:CalendarCtrl
 * @description
 * The CalendarCtrl controller
 */
define(function() {
  var CalendarCtrl = function(
    $scope,
    $rootScope,
    CalendarFactory,
    $filter,
    gaDomUtils,
    $timeout,
    gaJsUtils
  ) {
    // init
    $scope.eventTypes = [];
    $scope.newEventType = { type: '' };

    /**
     * getEventTypes and return a promise
     * @returns {*}
     */
    const getEventTypes = function() {
      return CalendarFactory.geteventtypes().then(function(res) {
        $scope.eventTypes = CalendarFactory.resources.event_types;
        CalendarFactory.fixEventTypesColor($scope.eventTypes);
        getTimeType();
      });
    };
    getEventTypes();

    /**
     * add Event Type
     */
    $scope.addEventType = function() {
      // nom unique
      var exists = false;
      $scope.eventTypes.forEach(function(et) {
        if (et.properties.type == $scope.newEventType.type) exists = true;
      });

      if (exists) {
        alert(
          $filter('translate')('portals.calendar.event_type.already_exists')
        );
        return;
      }

      var ans = confirm(
        $filter('translate')('portals.calendar.event_type.confirm_add')
      );
      if (ans) {
        gaDomUtils.showGlobalLoader();

        var pdata = {
          type: 'FeatureCollection',
          features: [
            {
              type: 'Feature',
              properties: {
                type_id: $scope.eventTypes.length,
                type: $scope.newEventType.type,
                restrict_move_event: $scope.newEventType.restrict_move_event,
                default_color: $scope.newEventType.default_color,
                alias: $scope.newEventType.alias,
                alerte1: calcul(
                  $scope.newEventType.alerte1_type,
                  $scope.newEventType.alerte1
                ),
                alerte2: calcul(
                  $scope.newEventType.alerte2_type,
                  $scope.newEventType.alerte2
                ),
                alerte3: calcul(
                  $scope.newEventType.alerte3_type,
                  $scope.newEventType.alerte3
                ),
              },
            },
          ],
        };

        CalendarFactory.addeventtype(pdata).then(
          function() {
            getEventTypes().then(function() {
              //getTimeType();
              $scope.newEventType = { type: '' };
              gaDomUtils.hideGlobalLoader();
            });
          },
          function(res) {
            console.log('err');
            gaDomUtils.hideGlobalLoader();
          }
        );
      }
    };

    $scope.editEventTypeLine = {};
    var svgType;
    var currentId;
    /**
     * (de)active eventype edition
     * @param idx
     */
    $scope.editETLine = function(idx) {
      if (currentId && currentId != idx) {
        $scope.eventTypes[currentId] = angular.copy(svgType);
        $scope.editEventTypeLine = {};
        getTimeType();
        resetAlertValue(currentId);
      }
      currentId = idx;
      var tmp = {};
      tmp[idx] = !$scope.editEventTypeLine[idx];
      $scope.editEventTypeLine = tmp;
      $scope.eventTypes[idx].properties.alerte1 = $scope.renderValue(
        $scope.eventTypes[idx].properties.alerte1,
        $scope.eventTypes[idx].properties.alerte1_type
      );
      $scope.eventTypes[idx].properties.alerte2 = $scope.renderValue(
        $scope.eventTypes[idx].properties.alerte2,
        $scope.eventTypes[idx].properties.alerte2_type
      );
      $scope.eventTypes[idx].properties.alerte3 = $scope.renderValue(
        $scope.eventTypes[idx].properties.alerte3,
        $scope.eventTypes[idx].properties.alerte3_type
      );
      svgType = angular.copy($scope.eventTypes[idx]);
    };

    /**
     * Supprime le type d'évènement
     * @param idx
     */
    $scope.removeEventType = (idx) => {
      if(confirm($filter('translate')('common.confirmDelete'))) {
        CalendarFactory.removeeventtype($scope.eventTypes[idx].id).then(
            () => {
              $scope.eventTypes.splice(idx, 1);
              require('toastr').success(
                  $filter('translate')('common.successDelete'));
            },
            () => {
              require('toastr').error(
                  $filter('translate')('common.failDelete'));
            }
        );
      }
    };

    /**
     * cancel eventype edition
     */
    $scope.cancelETLine = function(idx) {
      $timeout(function() {
        $scope.eventTypes[idx] = svgType;
        $scope.editEventTypeLine = {};
        getTimeType();
        resetAlertValue(idx);
        currentId = false;
      });
    };

    var resetAlertValue = function(idx) {
      $scope.eventTypes[idx].properties.alerte1 = calcul(
        $scope.eventTypes[idx].properties.alerte1_type,
        $scope.eventTypes[idx].properties.alerte1
      );
      $scope.eventTypes[idx].properties.alerte2 = calcul(
        $scope.eventTypes[idx].properties.alerte2_type,
        $scope.eventTypes[idx].properties.alerte2
      );
      $scope.eventTypes[idx].properties.alerte3 = calcul(
        $scope.eventTypes[idx].properties.alerte3_type,
        $scope.eventTypes[idx].properties.alerte3
      );
    };

    /**
     *
     * @param $index
     */
    $scope.updateEventType = function($index) {
      $scope.eventTypes[$index].properties.alerte1 = calcul(
        $scope.eventTypes[$index].properties.alerte1_type,
        $scope.eventTypes[$index].properties.alerte1
      );
      $scope.eventTypes[$index].properties.alerte2 = calcul(
        $scope.eventTypes[$index].properties.alerte2_type,
        $scope.eventTypes[$index].properties.alerte2
      );
      $scope.eventTypes[$index].properties.alerte3 = calcul(
        $scope.eventTypes[$index].properties.alerte3_type,
        $scope.eventTypes[$index].properties.alerte3
      );
      delete $scope.eventTypes[$index].properties.alerte1_type;
      delete $scope.eventTypes[$index].properties.alerte2_type;
      delete $scope.eventTypes[$index].properties.alerte3_type;
      gaDomUtils.showGlobalLoader();
      CalendarFactory.updateeventtype($scope.eventTypes[$index]).then(function(
        res
      ) {
        getTimeType();
        gaDomUtils.hideGlobalLoader();
        $scope.editEventTypeLine = {};
        currentId = false;
      });
    };

    /**
     * toggleCalendar
     */
    $scope.toggleCalendar = function() {
      $scope.calendar.visible = !$scope.calendar.visible;
    };

    /**
     * checkbox
     * @type {*[]}
     */
    $scope.alertDelaiTypes = [
      /*{
            id: 's',
            label: 'secondes'
        },*/ {
        id: 'm',
        label: 'minute(s)',
      },
      {
        id: 'h',
        label: 'heure(s)',
      },
      {
        id: 'd',
        label: 'jour(s)',
      },
      {
        id: 'w',
        label: 'semaine(s)',
      },
      {
        id: 'mth',
        label: 'mois',
      },
    ];

    /**
     * calcul seconde
     * @param type
     * @param value
     * @returns {*}
     */
    var calcul = function(type, value) {
      if (type == 'm') {
        value = value * 60;
      } else if (type == 'h') {
        value = value * 60 * 60;
      } else if (type == 'd') {
        value = value * 60 * 60 * 24;
      } else if (type == 'w') {
        value = value * 60 * 60 * 24 * 7;
      } else if (type == 'mth') {
        value = value * 60 * 60 * 24 * 30;
      }
      if (value == 0) {
        value = null;
      }
      return value;
    };

    /**
     * render value
     * @param value
     * @param type
     * @returns {*}
     */
    $scope.renderValue = function(value, type) {
      if (type == 'mth') {
        value = value / (60 * 60 * 24 * 30);
      } else if (type == 'w') {
        value = value / (60 * 60 * 24 * 7);
      } else if (type == 'd') {
        value = value / (60 * 60 * 24);
      } else if (type == 'h') {
        value = value / (60 * 60);
      } else if (type == 'm') {
        value = value / 60;
      }
      if (value == 0 || value == '0') {
        value = '';
      }
      return value;
    };

    /**
     * render att name
     * @param type
     * @returns {*}
     */
    $scope.renderAttName = function(value, type) {
      var val = $scope.renderValue(value, type);

      if (type == 'w') {
        if (val > 1) {
          type = 'semaines';
        } else {
          type = 'semaine';
        }
      } else if (type == 'd') {
        if (val > 1) {
          type = 'jours';
        } else {
          type = 'jour';
        }
      } else if (type == 'h') {
        if (val > 1) {
          type = 'heures';
        } else {
          type = 'heure';
        }
      } else if (type == 'm') {
        if (val > 1) {
          type = 'minutes';
        } else {
          type = 'minute';
        }
      } else if (type == 's') {
        if (val > 1) {
          type = 'secondes';
        } else {
          type = 'seconde';
        }
        //type = 'secondes';
      } else if (type == 'mth') {
        type = 'mois';
      }

      if (!value || value == 0) {
        type = '';
      }
      return type;
    };

    /**
     * get type of alert
     */
    var getTimeType = function() {
      if ($scope.eventTypes && $scope.eventTypes.length) {
        for (var i = 0; i < $scope.eventTypes.length; i++) {
          var tab = ['alerte1', 'alerte2', 'alerte3'];
          var att = ['alerte1_type', 'alerte2_type', 'alerte3_type'];
          for (var j = 0; j < tab.length; j++) {
            if (
              $scope.eventTypes[i].properties[tab[j]] % (30 * 24 * 60 * 60) ==
                0 &&
              $scope.eventTypes[i].properties[tab[j]]
            ) {
              $scope.eventTypes[i].properties[att[j]] = 'mth';
            } else if (
              $scope.eventTypes[i].properties[tab[j]] % (7 * 24 * 60 * 60) ==
                0 &&
              $scope.eventTypes[i].properties[tab[j]]
            ) {
              $scope.eventTypes[i].properties[att[j]] = 'w';
            } else if (
              $scope.eventTypes[i].properties[tab[j]] % (24 * 60 * 60) == 0 &&
              $scope.eventTypes[i].properties[tab[j]]
            ) {
              $scope.eventTypes[i].properties[att[j]] = 'd';
            } else if (
              $scope.eventTypes[i].properties[tab[j]] % (60 * 60) == 0 &&
              $scope.eventTypes[i].properties[tab[j]]
            ) {
              $scope.eventTypes[i].properties[att[j]] = 'h';
            } else if (
              $scope.eventTypes[i].properties[tab[j]] % 60 == 0 &&
              $scope.eventTypes[i].properties[tab[j]]
            ) {
              $scope.eventTypes[i].properties[att[j]] = 'm';
            } else if (
              $scope.eventTypes[i].properties[tab[j]] == null ||
              !$scope.eventTypes[i].properties[tab[j]]
            ) {
              $scope.eventTypes[i].properties[att[j]] = 'h';
            }
          }
        }
      }
    };

    $scope.removeAlert = function(index, name) {
      $scope.eventTypes[index].properties[name] = null;
    };

    if (
      gaJsUtils.checkNestedProperty(
        'portal.parameters.calendar.active',
        $rootScope.xgos
      )
    ) {
      CalendarFactory.getcalendarworkhours().then(function(res) {
        if (res.data.features.length) {
          $scope.workhours = res.data.features;
          $scope.workhours.sort(function(a, b) {
            return a.weekday - b.weekday;
          });
          $scope.workhours = $scope.workhours.map(day => {
            if (day.properties.active == true) {
              day.properties.am_start = new Date(day.properties.am_start);
              day.properties.am_end = new Date(day.properties.am_end);
              day.properties.pm_start = new Date(day.properties.pm_start);
              day.properties.pm_end = new Date(day.properties.pm_end);
            }
            return day;
          });
        } else {
          var features = [];
          for (var i = 0; i < 7; i++) {
            if (i <= 1) {
              features.push({
                type: 'Feature',
                properties: {
                  weekday: 6 - i,
                  active: false,
                },
              });
            } else {
              features.push({
                type: 'Feature',
                properties: {
                  weekday: 6 - i,
                  am_start: $filter('date')(
                    moment(new Date())
                      .hours(9)
                      .minutes(0)
                      .toDate(),
                    'yyyy-MM-ddTHH:mm:ss.sssZ'
                  ),
                  am_end: $filter('date')(
                    moment(new Date())
                      .hours(12)
                      .minutes(0)
                      .toDate(),
                    'yyyy-MM-ddTHH:mm:ss.sssZ'
                  ),
                  pm_start: $filter('date')(
                    moment(new Date())
                      .hours(14)
                      .minutes(0)
                      .toDate(),
                    'yyyy-MM-ddTHH:mm:ss.sssZ'
                  ),
                  pm_end: $filter('date')(
                    moment(new Date())
                      .hours(17)
                      .minutes(0)
                      .toDate(),
                    'yyyy-MM-ddTHH:mm:ss.sssZ'
                  ),
                  active: true,
                },
              });
            }
          }
          /**
           * add WorkHours
           */
          CalendarFactory.addcalendarworkhours({
            type: 'FeatureCollection',
            features: features,
          }).then(() => {
            $scope.workhours = features.reverse();
          });
        }
      });
    }

    $scope.renderWeekdayLabel = function(x) {
      if (x == 0) return $filter('translate')('calendar.config.mon');
      if (x == 1) return $filter('translate')('calendar.config.tue');
      if (x == 2) return $filter('translate')('calendar.config.wed');
      if (x == 3) return $filter('translate')('calendar.config.thur');
      if (x == 4) return $filter('translate')('calendar.config.fri');
      if (x == 5) return $filter('translate')('calendar.config.sat');
      if (x == 6) return $filter('translate')('calendar.config.sun');
    };

    /**
     * update WorkHours
     */
    $scope.saveWorkHours = function() {
      var ans = confirm($filter('translate')('calendar.config.confim'));
      if (ans) {
        var FeatureCollection = {
          type: 'FeatureCollection',
          features: angular.copy($scope.workhours).map(day => {
            day.properties.am_start = day.properties.am_start && moment(day.properties.am_start).utc().format('YYYY-MM-DDTHH:mm:ss.SSSZZ');
            day.properties.am_end = day.properties.am_end && moment(day.properties.am_end).utc().format('YYYY-MM-DDTHH:mm:ss.SSSZZ');
            day.properties.pm_start = day.properties.pm_start && moment(day.properties.pm_start).utc().format('YYYY-MM-DDTHH:mm:ss.SSSZZ');
            day.properties.pm_end = day.properties.pm_end && moment(day.properties.pm_end).utc().format('YYYY-MM-DDTHH:mm:ss.SSSZZ');
            return day;
          }),
        };
        gaDomUtils.showGlobalLoader();
        CalendarFactory.updatecalendarworkhours(FeatureCollection).then(
          function(res) {
            gaDomUtils.hideGlobalLoader();
          },
          function(res) {
            gaDomUtils.hideGlobalLoader();
          }
        );
      }
    };

    /**
     * copy
     * @param x
     */
    $scope.copyWorkHours = function(x) {
      $scope.workhours.forEach(function(day) {
        if (day.properties.active == true) {
          day.properties.am_start = new Date(x.properties.am_start);
          day.properties.am_end = new Date(x.properties.am_end);
          day.properties.pm_start = new Date(x.properties.pm_start);
          day.properties.pm_end = new Date(x.properties.pm_end);
        }
      });
    };

    $scope.user = {};
    /**
     * transfertEvent
     * @param from
     * @param to
     * @param date_from
     * @param date_to
     */
    $scope.transfertEvent = function(from, to, date_from, date_to) {
      date_from = $filter('date')(
        moment(new Date(date_from))
          .hours(0)
          .minutes(0)
          .toDate(),
        'yyyy-MM-ddTHH:mm:ss.sssZ'
      );
      date_to = $filter('date')(
        moment(new Date(date_to))
          .hours(23)
          .minutes(59)
          .toDate(),
        'yyyy-MM-ddTHH:mm:ss.sssZ'
      );
      var date_start = new Date(date_from).getTime();
      var date_fin = new Date(date_to).getTime();
      gaDomUtils.showGlobalLoader();
      CalendarFactory.transferteventuser(from, to, date_start, date_fin).then(
        function(res) {
          $scope.user = {};
          require('toastr').success('Bien enregistre');
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    /**
     * verify
     * @param type
     */
    $scope.canModifyType = function(type) {
      var res = true;
      if (type && type.indexOf('kis_')) {
        res = false;
      }
      return res;
    };

    /**
     * validNomType
     * @param eventType
     * @returns {boolean}
     */
    $scope.validNomType = function(eventType) {
      var res = false;
      $scope.eventTypes.forEach(function(type) {
        if (type.properties.type == eventType.type) {
          res = true;
        }
      });
      return res;
    };

    /**
     * validUpdateType
     * @param eventType
     * @returns {boolean}
     */
    $scope.validUpdateType = function(eventType) {
      var res = false;
      $scope.eventTypes.forEach(function(type) {
        if (
          type.properties.type == eventType.properties.type &&
          type.id != eventType.id
        ) {
          res = true;
        }
      });
      return res;
    };
  };

  CalendarCtrl.$inject = [
    '$scope',
    '$rootScope',
    'CalendarFactory',
    '$filter',
    'gaDomUtils',
    '$timeout',
    'gaJsUtils',
  ];
  return CalendarCtrl;
});
