'use strict';

/**
 * @ngdoc controller
 * @name modules.authentication.controller:ActionsCtrl
 * @description
 * The ActionsCtrl controller
 */
define(function() {
  var ActionsCtrl = function($scope, ngDialog, ActionsFactory) {
    ActionsFactory.getconf().then(
      function(res) {
        if (res.data.etat === 'fini') {
          $scope.currentResources = res.data.data;
          ActionsFactory.setActions(res.data.data);
        } else {
          console.info('no config');
        }
      },
      function() {
        console.info('no config');
      }
    );

    $scope.addAction = function() {
      $scope.editMode = 'add';
      $scope.edit_resource = { id: Math.floor(Math.random() * 10000) };
      $scope.currentFormData = angular.copy($scope.edit_resource);
      ngDialog.open({
        template: 'js/XG/modules/tools/views/modals/modal.actions.html',
        className: 'ngdialog-theme-plain width1000',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.updateAction = function() {
      $scope.editMode = 'update';
      $scope.currentFormData = angular.copy($scope.edit_resource);
      ngDialog.open({
        template: 'js/XG/modules/tools/views/modals/modal.actions.html',
        className: 'ngdialog-theme-plain width1000',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.removeAction = function() {
      $scope.currentResources.splice($scope.selected_resource_index, 1);
      ActionsFactory.saveconf($scope.currentResources).then(function(res) {
        if (res.data.etat === 'fini') {
          ActionsFactory.setActions($scope.currentResources);
          console.info('suppression success');
        } else {
          console.info('no config');
        }
      });
    };

    $scope.addActionToActions = function(currentFormData) {
      if (angular.isUndefined($scope.currentResources))
        $scope.currentResources = [];
      switch ($scope.editMode) {
        case 'add':
          $scope.currentResources.push(currentFormData);
          break;
        case 'update':
          for (var i = 0; i < $scope.currentResources.length; i++) {
            if ($scope.currentResources[i].id === currentFormData.id) {
              $scope.currentResources[i] = angular.copy(currentFormData);
              break;
            }
          }
          break;
      }
      ActionsFactory.saveconf($scope.currentResources).then(function(res) {
        if (res.data.etat === 'fini') {
          ActionsFactory.setActions($scope.currentResources);
          console.info('success save actions globales');
        } else {
          console.info('no config');
        }
      });
      return true;
    };

    $scope.refreshDocumentsList = function() {
      refreshList();
    };

    $scope.editListCfg = {
      dataModule: 'tools',
      resource_type: 'actions',
      cols: ['type', 'name'],
      addFunction: $scope.addAction,
      editFunction: $scope.updateAction,
      removeFunction: $scope.removeAction,
    };

    /**
     * [refreshList description]
     * @return {[type]} [description]
     */
    var refreshList = function() {
      $scope.currentResources = [];
      ActionsFactory.getconf().then(
        function(res) {
          if (res.data.etat === 'fini') {
            $scope.currentResources = res.data.data;
            ActionsFactory.setActions(res.data.data);
          } else {
            console.info('no config');
          }
        },
        function() {
          console.info('no config');
        }
      );
    };

    setTimeout(function() {}, 500);
  };

  ActionsCtrl.$inject = ['$scope', 'ngDialog', 'ActionsFactory'];
  return ActionsCtrl;
});
