/**
 *
 */
'use strict';
define(function() {
  /**
   * Portals Ctrl
   * @param $scope
   * @param $rootScope
   * @param $window
   * @param $translate
   * @param PortalsFactory
   * @constructor
   * @param DataStoreFactory
   */
  var LogsCtrl = function(
    $scope,
    $rootScope,
    $window,
    $translate,
    $filter,
    RootFactory,
    DataStoreFactory,
    gaDomUtils,
    CalendarFactory,
    $timeout,
    gaJsUtils,
    AlertHpoFactory,
    ngTableParams
  ) {
    $scope.total = 10;
    $scope.files = [];
    $scope.files_paths = {};
    RootFactory.get().then(
      function(res) {
        if (res.data) {
          $scope.files_paths = res.data;
          $scope.files = Object.keys($scope.files_paths);
        } else {
          AlertHpoFactory.showErrorMessage(res);
        }
      },
      function(res) {
        AlertHpoFactory.showErrorMessage(res);
      }
    );

    $scope.tableParams = new ngTableParams(
      {
        page: 1,
        count: $scope.total,
        data: [],
      },
      {
        total: 0,
        counts: null,
        data: [],
        getData: function($defer, params) {
          if (
            $scope.files_paths &&
            $scope.file &&
            $scope.files_paths[$scope.file]
          ) {
            gaDomUtils.showGlobalLoader();
            RootFactory.getFileContent(
              $scope.files_paths[$scope.file],
              $scope.total,
              params.page()
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res.data) {
                  params.total(res.data.realLength);
                  $defer.resolve(res.data.lines);
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                  $defer.resolve([]);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
                $defer.resolve([]);
              }
            );
          } else {
            $defer.resolve([]);
          }
        },
      }
    );

    $scope.changedFile = function() {
      if ($scope.tableParams && $scope.tableParams.reload) {
        $scope.tableParams.count($scope.total);
        $scope.tableParams.page(1);
        $scope.tableParams.reload();
      }
    };

    $scope.changedTotal = function() {
      if ($scope.tableParams && $scope.tableParams.reload) {
        $scope.tableParams.count($scope.total);
        $scope.tableParams.page(1);
        $scope.tableParams.reload();
      }
    };

    setTimeout(function() {
      $scope.maxheight = angular.element('#xgos_main').height() - 70 + 'px';
    }, 500);
  };

  LogsCtrl.$inject = [
    '$scope',
    '$rootScope',
    '$window',
    '$translate',
    '$filter',
    'RootFactory',
    'DataStoreFactory',
    'gaDomUtils',
    'CalendarFactory',
    '$timeout',
    'gaJsUtils',
    'AlertHpoFactory',
    'ngTableParams',
  ];
  return LogsCtrl;
});
