'use strict';
define(function() {
  var ExtraAuthenticationFactory = function($http) {
    var ExtraAuthenticationFactory = {};
    /**
     * Class : ExtraAuthenticationFactory
     * Factory WebServices
     */

    var resources = {
      extra_authentications: []
    };

    /**
     * Function: connectiontest
     */
    function connectiontest(senddata) {
      return $http.post(
        '/services/{portalid}/model/extra_authentication/connectionTest?f=json',
        senddata
      );
    }

    /**
     * Function: add
     */
    function add(senddata) {
      var promise = $http.post(
        '/services/{portalid}/model/extra_authentication/add?f=json',
        senddata
      );
      promise.then(function(res) {
        resources.extra_authentications.push(res.data);
      });
      return promise;
    }

    /**
     * Function: remove
     */
    function remove(id) {
      var promise = $http.get(
        '/services/{portalid}/model/extra_authentication/remove?f=json' +
          '&id=' +
          id
      );
      promise.then(function(res) {
        var deleteIndex = resources.extra_authentications
          .map(function(x) {
            return x.uid;
          })
          .indexOf(id);
        resources.extra_authentications.splice(deleteIndex, 1);
      });
      return promise;
    }
    /**
     * Function: update
     */
    function update(senddata) {
      var promise = $http.post(
        '/services/{portalid}/model/extra_authentication/update?f=json',
        senddata
      );
      promise.then(function(res) {
        var replaceIndex = resources.extra_authentications
          .map(function(x) {
            return x.uid;
          })
          .indexOf(senddata.uid);
        resources.extra_authentications[replaceIndex] = res.data;
      });
      return promise;
    }

    /**
     * Function: get
     */
    function get() {
      var promise = $http.get(
        '/services/{portalid}/model/extra_authentication/get?f=json'
      );
      promise.then(function(res) {
        resources.extra_authentications = res.data;
      });
      return promise;
    }

    /**
     * Function: getbyid
     */
    function getbyid(id) {
      return $http.get(
        '/services/{portalid}/model/extra_authentication/getbyid?f=json' +
          '&id=' +
          id
      );
    }

    /**
     * Function: getattributes
     */
    function getattributes(senddata) {
      return $http.post(
        '/services/{portalid}/model/extra_authentication/getAttributes?f=json',
        senddata
      );
    }

    /**
     * Function: getusers
     */
    function getusers(senddata) {
      return $http.post(
        '/services/{portalid}/model/extra_authentication/getUsers?f=json',
        senddata
      );
    }

    /**
     * Function: importusers
     */
    function importusers(senddata) {
      return $http.post(
        '/services/{portalid}/model/extra_authentication/importUsers?f=json',
        senddata
      );
    }

    /**
     * Function: getGroups
     */
    function getGroups(id) {
      return $http.get(
        '/services/{portalid}/model/extra_authentication/getgrouplist?f=json' +
          '&uid=' +
          id
      );
    }

    /**
     * Function: getGroups
     */
    function getGroupMembers(id, groupCn, filter) {
      if (filter == undefined) {
        filter = '';
      }
      return $http.get(
        '/services/{portalid}/model/extra_authentication/getgroupmembers?f=json' +
          '&uid=' +
          id +
          '&groupcn=' +
          groupCn +
          '&filter=' +
          filter
      );
    }

    return {
      ExtraAuthenticationFactory: ExtraAuthenticationFactory,
      resources: resources,
      add: add,
      get: get,
      remove: remove,
      update: update,
      connectiontest: connectiontest,
      getattributes: getattributes,
      getusers: getusers,
      getbyid: getbyid,
      importusers: importusers,
      getGroups: getGroups,
      getGroupMembers: getGroupMembers,
    };
  };
  ExtraAuthenticationFactory.$inject = ['$http'];
  return ExtraAuthenticationFactory;
});
