'use strict';
define(function() {
  var ElasticFactory = function($http, $q) {
    var ElasticFactory = {};
    /**
     * Class : ElasticFactory
     * Factory WebServices
     */

    /**
     * Function: indexall
     */
    function indexall() {
      var promise = $http.get('/services/{portalid}/elastic/indexall?');

      return promise;
    }

    /**
     * Function: createIndex
     */
    function createIndex() {
      var promise = $http.get(
        '/services/{portalid}/elastic/create/simple/index?'
      );

      return promise;
    }

    /**
     * Function: deleteIndex
     */
    function deleteIndex(portalid) {
      var promise = $http.get(
        '/services/' + portalid + '/elastic/delete/simple/index?'
      );

      return promise;
    }

    /**
     * Function: createType
     * @param {string} ftiname
     */
    function createType(ftiname) {
      var promise = $http.get(
        '/services/{portalid}/elastic/create/simple/type?' + 'type=' + ftiname
      );

      return promise;
    }

    /**
     * Function: createTypeByJsonData
     * @param {string} name from fti
     * @param {object} sendata
     */
    function createTypeByJsonData(ftiname, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/create/simple/type?' + 'type=' + ftiname,
        sendata
      );

      return promise;
    }

    /**
     * Function: createCompleteType
     * @param {string} ftiname
     * @param {string} crs
     * @param {fastIndex} fastIndex utilisation du bulk et d'autres strategies pour augmenter la vitesse d'indexation
     */
    function createCompleteType(ftiname, crs, fastIndex) {
      fastIndex = fastIndex || false;

      var promise = $http.get(
        '/services/{portalid}/elastic/create/complete/type?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs +
          '&fastIndex=' +
          fastIndex
      );

      return promise;
    }

    /**
     * Function: updateTypebyJson
     * @param {string} ftiname
     * @param {object} sendata
     */
    function updateTypebyJson(ftiname, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/update/simple/type?' + 'type=' + ftiname,
        sendata
      );

      return promise;
    }

    /**
     * Function: updateType
     * @param {string} ftiname
     */
    function updateType(ftiname) {
      var promise = $http.get(
        '/services/{portalid}/elastic/update/simple/type?' + 'type=' + ftiname
      );

      return promise;
    }

    /**
     * Function: addDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {object} sendata
     */
    function addDocument(ftiname, crs, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/add/simple/document?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs,
        sendata
      );

      return promise;
    }

    /**
     * Function: addMultipleDocuments
     * @param {string} ftiname
     * @param {string} crs
     * @param {object} sendata
     */
    function addMultipleDocuments(ftiname, crs, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/add/multiple/document?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs,
        sendata
      );

      return promise;
    }

    /**
     * Function: updateDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {object} sendata
     */
    function updateDocument(ftiname, crs, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/update/simple/document?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs,
        sendata
      );

      return promise;
    }

    /**
     * Function: updatemultipleDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {object} sendata
     */
    function updatemultipleDocument(ftiname, crs, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/update/multiple/document?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs,
        sendata
      );

      return promise;
    }

    /**
     * Function: getDocument
     * @param {string} ftiname
     * @param {String} uid
     */
    function getDocument(ftiname, uid) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/simple/document?' +
          'type=' +
          ftiname +
          '&uid=' +
          uid
      );

      return promise;
    }

    /**
     * Function: getMultipleDocument
     * @param {string} ftiname
     * @param {string} uids , "uid,uid,uid"
     */
    function getMultipleDocument(ftiname, uids) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/multiple/document?' +
          'type=' +
          ftiname +
          '&uids=' +
          uids
      );

      return promise;
    }

    /**
     * Function: deleteDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {String} uid
     */
    function deleteDocument(ftiname, crs, uid) {
      var promise = $http.get(
        '/services/{portalid}/elastic/delete/simple/document?' +
          'type=' +
          ftiname +
          '&uid=' +
          uid
      );

      return promise;
    }

    /**
     * Function: deleteMultipleDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {String} uid
     */
    function deleteMultipleDocument(ftiname, uids) {
      var promise = $http.get(
        '/services/{portalid}/elastic/delete/multiple/document?' +
          'type=' +
          ftiname +
          '&uids=' +
          uids
      );

      return promise;
    }

    /**
     * Function: deleteAllDocument
     * @param {string} ftiname
     */
    function deleteAllDocument(ftiname) {
      var promise = $http.get(
        '/services/{portalid}/elastic/delete/all/document?' + 'type=' + ftiname
      );

      return promise;
    }

    /**
     * Function: searchInType
     * @param {string} ftiname
     * @param {string} format , geojson ou json
     */
    function searchInType(ftiname, format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/search/in/type?' +
          'type=' +
          ftiname +
          '&format=' +
          format+
          '&srid=' +
          srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: searchInTypeAnc
     * @param {string} ftiname
     * @param {string} format , geojson ou json
     */
    function searchInTypeAnc(ftiname, format, sendata, saveOriginalProperties) {
      // defer promise so we can apply the specific behavior
      console.log(sendata.searchquery);

      var def = $q.defer(),
        promise = $http.post(
          '/services/{portalid}/elastic/search/in/typeanc?' +
            'type=' +
            ftiname +
            '&format=' +
            format,
          sendata
        );

      var needToRemapDossierControlNames =
        angular.isDefined(sendata.liaisons) &&
        sendata.liaisons.length &&
        sendata.liaisons.filter(function(x) {
          return (
            x.child == 'kis_anc_dossier_controle_reponse' ||
            x.child == 'kis_bac_dossier_controle_reponse'
          );
        }).length;

      promise.then(
        function(res) {
          // comportement specifique kis_anc/bac_dossier_controle_reponse
          // on remplace les a.b.c.d du json des controles par un alias
          // @TODO : devrait etre fait cote serveur
          if (needToRemapDossierControlNames && res.data.totalFeatures > 0) {
            // console.log(sendata.opts);
            //  console.log(res.data);
            // garde une copie des attributs non modifiées
            if (saveOriginalProperties) {
              res.data.features.map(function(x) {
                x.originalProperties = angular.copy(x.properties);
              });
            }

            var cible =
              sendata.opts[
                angular.isDefined(sendata.opts.kis_anc_dossier_controle_reponse)
                  ? 'kis_anc_dossier_controle_reponse'
                  : 'kis_bac_dossier_controle_reponse'
              ];

            var tmp = cible.fti.attributes,
              attributesReference = {},
              attributsUtilises = res.data.fti.attributes.map(function(x) {
                return x.name;
              });

            var uniqAliases = {};
            for (var a in tmp) {
              if (attributsUtilises.indexOf(tmp[a].name) == -1) continue;
              // creation d'un index avec compteur pour le cas ou plusieurs attributs ont le meme alias...
              // sans quoi on doublonne les valeurs lors du remplacement dans la reponse
              if (!angular.isDefined(uniqAliases[tmp[a].alias])) {
                attributesReference[tmp[a].name] = tmp[a].alias;
                uniqAliases[tmp[a].alias] = 0;
              } else {
                uniqAliases[tmp[a].alias] = uniqAliases[tmp[a].alias] + 1;
                attributesReference[tmp[a].name] =
                  '(' + uniqAliases[tmp[a].alias] + ') ' + tmp[a].alias;
              }
            }

            // remplace dans le fti + dans les reponses
            for (var k in res.data.fti.attributes) {
              var attrName = res.data.fti.attributes[k].name;
              // si contient un ".", c'est sans doute une chaine de la reponse controle
              if (attrName.indexOf('.') != -1) {
                var _ref = attributesReference[attrName];
                res.data.fti.attributes[k].name = _ref;

                for (var i in res.data.features) {
                  for (var j in res.data.features[i].properties) {
                    if (j == attrName) {
                      res.data.features[i].properties[_ref] =
                        res.data.features[i].properties[j];
                      delete res.data.features[i].properties[j];
                    }
                  }
                }
              }
            }
          }

          // fin comportement specifique kis_anc_dossier_controle_reponse
          def.resolve(res);

          // service level logic if any
        },
        function() {
          def.reject();
        }
      );

      return def.promise;
    }

    /**
     * Function: searchInTypes
     * @param {string} ftiname
     * @param {string} format , geojson ou json
     */
    function searchInTypes(ftinames, format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/search/in/types?' +
          'types=' +
          ftinames +
          '&format=' +
          format+
          '&srid=' +
          srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: searchInIndex
     * @param {string} ftiname
     * @param {string} format , geojson ou json
     */
    function searchInIndex(format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/search/in/index?' + 'format=' + format+ '&srid=' + srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: searchInIndex
     * @param {string} format , geojson ou json
     */
    function advancedSearch(format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/advanced/search?' + 'format=' + format+ '&srid=' + srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: relationalSearch
     * @param {string} format , geojson ou json
     */
    function relationalSearch(format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/relational/search?' + 'format=' + format+ '&srid=' + srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: saveConfig
     * @param {string} format , geojson ou json
     */
    function saveConfig(filename, app, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/save/config?app=' +
          app +
          '&filename=' +
          filename,
        sendata
      );

      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function getConfig(app) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/config?app=' + app
      );

      return promise;
    }

    /**
     * Function: saveConfig
     * @param {string} format , geojson ou json
     */
    function saveRelationalConfig(filename, app, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/save/relational/config?app=' +
          app +
          '&filename=' +
          filename,
        sendata
      );

      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function getRelationalConfig(app) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/relational/config?app=' + app
      );

      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function deleteSavedFile(app, fname) {
      var promise = $http.get(
        '/services/{portalid}/elastic/delete/saved/file?app=' +
          app +
          '&filename=' +
          fname
      );

      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function getProgression() {
      var promise = $http.get('/services/{portalid}/elastic/get/progression?');

      return promise;
    }

    /**
     * Function: getprogressiondetaillee
     */
    function getprogressiondetaillee(index, type) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/progressionDetaillee?f=json' +
          '&index=' +
          index +
          '&type=' +
          type
      );

      return promise;
    }

    /**
     * Function: search
     */
    function search(senddata, types, f) {
      var promise = $http.post(
        '/services/{portalid}/elastic/search?' + '&types=' + types + '&f=' + f,
        senddata
      );

      return promise;
    }

    /**
     * Function: elastic
     */
    function elastic(ftid) {
      var promise = $http.get(
        '/services/{portalid}/elastic/indexes?f=json' + '&ftid=' + ftid
      );

      return promise;
    }

    /**
     * Function: createTypeByJsonData
     * @param {string} name from fti
     * @param {object} sendata
     */
    function getSuggestions(query, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/suggester/index?' + 'suggestion=' + query,
        sendata
      );

      return promise;
    }

    /**
     * Function: createTypeByJsonData
     * @param {string} name from fti
     * @param {object} sendata
     */
    function getSuggestionsFromTypes(query, sendata, types) {
      var promise = $http.post(
        '/services/{portalid}/elastic/suggester/types?' +
          'suggestion=' +
          query +
          '&types=' +
          types,
        sendata
      );

      return promise;
    }

    /**
     * Function: createTypeByJsonData
     * @param {string} name from fti
     * @param {object} sendata
     */
    function getSuggestionsFromType(query, sendata, types, field) {
      var promise = $http.post(
        '/services/{portalid}/elastic/suggester/in/type?' +
          'suggestion=' +
          query +
          '&type=' +
          types +
          '&field=' +
          field,
        sendata
      );

      return promise;
    }

    function cleanFieldValue(filter) {
      filter.value = undefined;
      filter.newvalue = undefined;
      filter.newValueUtil = {};
      filter.key = {};
      filter.restrictedValue = {}
    }

    return {
      ElasticFactory: ElasticFactory,

      indexall: indexall,
      createIndex: createIndex,
      deleteIndex: deleteIndex,
      createType: createType,
      createTypeByJsonData: createTypeByJsonData,
      createCompleteType: createCompleteType,
      updateTypebyJson: updateTypebyJson,
      updateType: updateType,
      addDocument: addDocument,
      addMultipleDocuments: addMultipleDocuments,
      updateDocument: updateDocument,
      updatemultipleDocument: updatemultipleDocument,
      getDocument: getDocument,
      getMultipleDocument: getMultipleDocument,
      deleteDocument: deleteDocument,
      deleteMultipleDocument: deleteMultipleDocument,
      deleteAllDocument: deleteAllDocument,
      searchInType: searchInType,
      searchInTypeAnc: searchInTypeAnc,
      searchInTypes: searchInTypes,
      searchInIndex: searchInIndex,
      advancedSearch: advancedSearch,
      relationalSearch: relationalSearch,
      saveConfig: saveConfig,
      getConfig: getConfig,
      saveRelationalConfig: saveRelationalConfig,
      getRelationalConfig: getRelationalConfig,
      deleteSavedFile: deleteSavedFile,
      getProgression: getProgression,
      getprogressiondetaillee: getprogressiondetaillee,
      search: search,
      elastic: elastic,
      getSuggestions: getSuggestions,
      getSuggestionsFromTypes: getSuggestionsFromTypes,
      getSuggestionsFromType: getSuggestionsFromType,
      cleanFieldValue: cleanFieldValue,
    };
  };
  ElasticFactory.$inject = ['$http', '$q'];
  return ElasticFactory;
});
