'use strict';
/**
 * @ngdoc service
 * @name modules.authentication.service:AuthFactory
 * @description
 * The authentication factory
 */
define(function() {
  var processFactory = function($http, $rootScope, $filter) {
    var resources = { process: {} };

    function reloadAllProcess() {
      var promise = $http.get('/services/{portalid}/process/reload/all?f=json');
      promise.then(
        function(res) {
          resources.process = res.data;
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function reloadProcessByPortal() {
      var promise = $http.get(
        '/services/{portalid}/process/reload/portal?f=json'
      );
      promise.then(
        function(res) {
          if (res.data && res.data.length > 0)
            res.data.map(function(x) {
              //                        if ( x.creation )
              //                            x.creation = $filter('date')(new Date(x.creation) , 'dd MMM yyyy HH:mm');
              //                        if ( x.end )
              //                            x.end = $filter('date')(new Date(x.end) , 'dd MMM yyyy HH:mm');
              if (x.type.indexOf('/') !== -1) x.both = true;
              else x.both = false;
            });
          resources.process[$rootScope.xgos.portal.uid] = res.data;
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getPortal() {
      var promise = $http.get('/services/{portalid}/process/get/portal?f=json');
      promise.then(
        function(res) {
          if (res.data && res.data.length > 0)
            res.data.map(function(x) {
              //                        if ( x.creation )
              //                            x.creation = $filter('date')(new Date(x.creation) , 'dd MMM yyyy HH:mm');
              //                        if ( x.end )
              //                            x.end = $filter('date')(new Date(x.end) , 'dd MMM yyyy HH:mm');
              if (x.type.indexOf('/') !== -1) x.both = true;
              else x.both = false;
            });
          resources.process[$rootScope.xgos.portal.uid] = res.data;
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getAll() {
      var promise = $http.get('/services/{portalid}/process/get/all?f=json');
      promise.then(
        function(res) {
          resources.process = res.data;
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function addProcess(sendata) {
      //            if ( sendata.creation )
      //                sendata.creation = new Date(sendata.creation).getTime();
      //            if ( sendata.end )
      //                sendata.end = new Date(sendata.end).getTime();
      //
      delete sendata.both;
      var promise = $http.post(
        '/services/{portalid}/process/add/process?f=json',
        sendata
      );
      promise.then(
        function(res) {},
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function updateProcess(sendata) {
      //            if ( sendata.creation )
      //                sendata.creation = new Date(sendata.creation).getTime();
      //            if ( sendata.end )
      //                sendata.end = new Date(sendata.end).getTime();
      //
      //            if ( sendata.exportg )
      //                sendata.exportg = new Date(sendata.exportg).getTime();
      //            if ( sendata.importg )
      //                sendata.importg = new Date(sendata.importg).getTime();
      //            if ( sendata.synchrog )
      //                sendata.synchrog = new Date(sendata.synchrog).getTime();
      delete sendata.both;
      var promise = $http.post(
        '/services/{portalid}/process/update/process?f=json',
        sendata
      );
      promise.then(
        function(res) {},
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function deleteProcess(sendata) {
      //            if ( sendata.creation )
      //                sendata.creation = new Date(sendata.creation).getTime();
      //            if ( sendata.end )
      //                sendata.end = new Date(sendata.end).getTime();
      delete sendata.both;
      var promise = $http.post(
        '/services/{portalid}/process/delete/process?f=json',
        sendata
      );
      promise.then(
        function(res) {},
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getProcessByUid(uid) {
      var promise = $http.get(
        '/services/{portalid}/process/get/process/uid?f=json&uid=' + uid
      );
      promise.then(
        function(res) {
          //                if ( res.data.creation )
          //                    res.data.creation = $filter('date')(new Date(res.data.creation) , 'dd MMM yyyy HH:mm');
          //                if ( res.data.end )
          //                    res.data.end = $filter('date')(new Date(res.data.end) , 'dd MMM yyyy HH:mm');
          if (res.data.type.indexOf('/') !== -1) res.data.both = true;
          else res.data.both = false;
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getProcessByName(name) {
      var promise = $http.get(
        '/services/{portalid}/process/get/process/name?f=json&name=' + name
      );
      promise.then(
        function(res) {
          //                if ( res.data.creation )
          //                    res.data.creation = $filter('date')(new Date(res.data.creation) , 'dd MMM yyyy HH:mm');
          //                if ( res.data.end )
          //                    res.data.end = $filter('date')(new Date(res.data.end) , 'dd MMM yyyy HH:mm');
          if (res.data.type.indexOf('/') !== -1) res.data.both = true;
          else res.data.both = false;
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getProcessByType(type) {
      var promise = $http.get(
        '/services/{portalid}/process/get/process/type?f=json&type=' + type
      );
      promise.then(
        function(res) {
          if (res.data && res.data.length > 0)
            res.data.map(function(x) {
              //                        if ( x.creation )
              //                            x.creation = $filter('date')(new Date(x.creation) , 'dd MMM yyyy HH:mm');
              //                        if ( x.end )
              //                            x.end = $filter('date')(new Date(x.end) , 'dd MMM yyyy HH:mm');
              if (x.type.indexOf('/') !== -1) x.both = true;
              else x.both = false;
            });
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getProcessByUser(user) {
      var promise = $http.get(
        '/services/{portalid}/process/get/process/user?f=json&user=' + user
      );
      promise.then(
        function(res) {
          if (res.data && res.data.length > 0)
            res.data.map(function(x) {
              //                        if ( x.creation )
              //                            x.creation = $filter('date')(new Date(x.creation) , 'dd MMM yyyy HH:mm');
              //                        if ( x.end )
              //                            x.end = $filter('date')(new Date(x.end) , 'dd MMM yyyy HH:mm');
              if (x.type.indexOf('/') !== -1) x.both = true;
              else x.both = false;
            });
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getProcessByNametype(name, type) {
      var promise = $http.get(
        '/services/{portalid}/process/get/process/user?f=json&name=' +
          name +
          '&type=' +
          type
      );
      promise.then(
        function(res) {
          //                if ( res.data.creation )
          //                    res.data.creation = $filter('date')(new Date(res.data.creation) , 'dd MMM yyyy HH:mm');
          //                if ( res.data.end )
          //                    res.data.end = $filter('date')(new Date(res.data.end) , 'dd MMM yyyy HH:mm');
          if (res.data.type.indexOf('/') !== -1) res.data.both = true;
          else res.data.both = false;
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getProcessByUsertype(type) {
      var promise = $http.get(
        '/services/{portalid}/process/get/process/usertype?f=json&type=' + type
      );
      promise.then(
        function(res) {
          if (res.data && res.data.length > 0)
            res.data.map(function(x) {
              if (x && x.type) {
                x.both = x.type.includes('/');
              }
            });
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getProcessByUserSpecial(types) {
      var promise = $http.get(
        '/services/{portalid}/process/get/process/usertypespecial?f=json&types=' +
          types
      );
      promise.then(
        function(res) {
          if (res.data && Object.keys(res.data).length > 0) {
            for (var i = 0; i < Object.keys(res.data).length; i++) {
              if (
                res.data[Object.keys(res.data)[i]] &&
                res.data[Object.keys(res.data)[i]].length > 0
              )
                res.data[Object.keys(res.data)[i]].map(function(x) {
                  if (x) {
                    x.both = x.type.includes('/');
                  }
                });
            }
          }
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    /**
     * Récupère plusieurs processus du même type
     * @param {string} names noms des processus séparés par une virgule
     * @param {string} type type des processus
     * @return {Promise}
     */
    const getProcessesByNametype = (names, type) => {
      return $http.get('/services/{portalid}/process/processesByNameType?f=json'
          + '&names=' + names
          + '&type=' + type
      );
    };

    return {
      resources: resources,
      reloadAllProcess: reloadAllProcess,
      reloadProcessByPortal: reloadProcessByPortal,
      getPortal: getPortal,
      getAll: getAll,
      addProcess: addProcess,
      updateProcess: updateProcess,
      deleteProcess: deleteProcess,
      getProcessByUid: getProcessByUid,
      getProcessByName: getProcessByName,
      getProcessByType: getProcessByType,
      getProcessByUser: getProcessByUser,
      getProcessByNametype: getProcessByNametype,
      getProcessByUsertype: getProcessByUsertype,
      getProcessByUserSpecial: getProcessByUserSpecial,
      getProcessesByNametype: getProcessesByNametype
    };
  };

  processFactory.$inject = ['$http', '$rootScope', '$filter'];
  return processFactory;
});
