/**
 *
 */
'use strict';
if (
  !define(function() {
    /**
     * Builder Ctrl
     * @param $scope
     * @constructor
     * @param $rootScope
     * @param ngDialog
     * @param ApplicationFactory
     * @param ConfigFactory
     * @param $filter
     * @param FeatureTypeFactory
     */
    var ProcessCtrl = function(
      $scope,
      processFactory,
      $rootScope,
      ngDialog,
      $filter,
      gaDomUtils,
      $location,
      gaUrlUtils
    ) {
      var TYPE = 'docx';
      processFactory.getProcessByType(TYPE).then(function(res) {
        $scope.currentResources = res.data;
      });

      $scope.refreshList = function() {
        gaDomUtils.showGlobalLoader();
        processFactory.getProcessByType(TYPE).then(
          function(res) {
            $scope.currentResources = res.data;
            gaDomUtils.hideGlobalLoader();
          },
          function() {
            gaDomUtils.hideGlobalLoader();
          }
        );
      };

      $scope.checkLicenceCorrecte = function() {
        processFactory.CheckLicenceUploaded().then(
          function(res) {
            if (res.data === 'true') {
              processFactory.validerLicence().then(
                function(res) {
                  processFactory.reloadRepository().then(
                    function(res) {
                      processFactory.getAllLicences().then(function(res) {
                        $scope.currentResources = [
                          processFactory.getLicence($rootScope.xgos.portal.uid),
                        ];
                        if (
                          processFactory.getLicence(
                            $rootScope.xgos.portal.uid
                          ) &&
                          processFactory.getLicence($rootScope.xgos.portal.uid)
                            .type !== 'free'
                        )
                          processFactory.checkLicence(
                            processFactory.getLicence(
                              $rootScope.xgos.portal.uid
                            )
                          );
                        $scope.tableParams.reload();
                      });
                    },
                    function() {
                      console.error('erreur de reload');
                    }
                  );
                },
                function() {
                  console.error('erreur de copy');
                }
              );
            } else {
              require('toastr').error(
                $filter('translate')('process.process.processnotavailabe')
              );
            }
          },
          function() {
            require('toastr').error(
              $filter('translate')('process.process.processnotavailabe')
            );
          }
        );
      };

      $scope.showInfo = function() {
        ngDialog.open({
          template: 'js/XG/modules/process/views/info0.process.html',
          className: 'ngdialog-theme-plain  width400 height50 miniclose',
          closeByDocument: false,
          scope: $scope,
        });
      };

      $scope.deleteProcess = function() {
        processFactory.deleteProcess($scope.edit_resource).then(
          function(res) {
            var index;
            for (var i = 0; i < $scope.currentResources.length; i++) {
              if ($scope.currentResources[i].uid === $scope.edit_resource.uid) {
                index = i;
                break;
              }
            }
            $scope.currentResources.splice(index, 1);
          },
          function() {
            require('toastr').error(
              $filter('translate')('process.process.processnotavailabe')
            );
          }
        );
      };

      $scope.getFile = function() {
        if ($scope.edit_resource.type.split('/').length === 1)
          window.open(
            '/services/' +
              $rootScope.xgos.portal.uid +
              '/documents/getFileProcess?f=json&uid=' +
              $scope.edit_resource.uid +
              '&token=' +
              encodeURIComponent(localStorage.getItem('auth_token'))
          );
      };

      $scope.editListCfg = {
        dataModule: 'docxprocess',
        resource_type: 'docxprocess',
        cols: [
          'uid',
          'etat',
          'progress',
          'file',
          'user',
          'creation',
          'end',
          'total',
          'taille',
        ],
        removeFunction: $scope.deleteProcess,
        editFunction: $scope.showInfo,
        addResourceButton: false,
        colsFunction: {
          both: 'booleanToCheck',
        },
        extraGlobalActions: [
          {
            icon: "<i class='fa fa-refresh'></i>",
            label: 'common.featuretypes.refresh',
            fn: $scope.refreshList,
          },
        ],
        extraActions: [
          {
            icon: "<i class='fa fa-download'></i>",
            label: 'common.featuretypes.refresh',
            fn: $scope.getFile,
            disableCondition: 'download',
          },
        ],
      };
    };

    ProcessCtrl.$inject = [
      '$scope',
      'processFactory',
      '$rootScope',
      'ngDialog',
      '$filter',
      'gaDomUtils',
      '$location',
      'gaUrlUtils',
    ];
    return ProcessCtrl;
  })
) {
}
