'use strict';
define(function() {
  var objectinput = function(ngDialog) {
    return {
      restrict: 'AE',
      templateUrl: 'js/XG/modules/print/views/directives/objectInput.html',
      scope: {
        res: '=res',
      },

      link: function(scope) {
        if (angular.isUndefined(scope.res)) scope.res = [];
        scope.hostcurrent = {};
        scope.tabs = [
          {
            title: 'print.config.form.hosts.tablocal',
            content:
              'js/XG/modules/print/views/modals/modal.config.localhosts.html',
          },
          {
            title: 'print.config.form.hosts.tabadress',
            content:
              'js/XG/modules/print/views/modals/modal.config.dnshosts.html',
          },
          {
            title: 'rights.roles.title',
            content:
              'js/XG/modules/print/views/modals/modal.config.iphosts.html',
          },
        ];
        scope.tabs.activeTab = 0;

        /**
         * Add a line
         */
        scope.addLine = function() {
          //Rénitialisation de l'objet
          scope.hostcurrent = {};
          var addDialog = ngDialog.open({
            template: 'js/XG/modules/print/views/modals/modal.config.tabs.html',
            classname: 'ngdialog-theme-plain width800',
            closebydocument: false,
            scope: scope,
          });
        };

        scope.editHost = function() {
          if (angular.isUndefined(scope.res)) scope.res = [];
          switch (scope.tabs.activeTab) {
            case 0: //DNS
              scope.hostcurrent.class =
                'org.mapfish.print.config.LocalHostMatcher';
              scope.hostcurrent.output =
                'localhost : ' + scope.hostcurrent.dummy;
              break;
            case 1: //
              scope.hostcurrent.class =
                'org.mapfish.print.config.DnsHostMatcher';
              scope.hostcurrent.output = scope.hostcurrent.host.concat(
                ':' + scope.hostcurrent.port
              );
              break;
            case 2:
              scope.hostcurrent.class =
                'org.mapfish.print.config.AdressHostMatcher';
              scope.hostcurrent.output = scope.hostcurrent.ip;
              break;
          }
          scope.res.push(angular.copy(scope.hostcurrent));
        };
        /**
         * Delete a line
         * @param index
         */
        scope.deleteLine = function(index) {
          scope.res.splice(index, 1);
        };
      },
    };
  };

  objectinput.$inject = ['ngDialog'];
  return objectinput;
});
