'use strict';
define(function() {
  var guiEditor = function($timeout) {
    return {
      restrict: 'AE',
      templateUrl: 'js/XG/modules/print/views/directives/guiEditor.html',
      scope: {
        jsonmodel: '=jsonmodel',
        gridmanager: '=gridmgr',
        selectmanager: '=selectmgr',
        drawmanager: '=drawmgr',
        pagemanager: '=pagemgr',
      },
      link: function(scope, elt, attrs, ctrl) {
        if (angular.isUndefined(scope.selectmanager)) {
          scope.selectmanager = {
            currentlySelected: null,
            selectedIndex: -1,
          };
        }

        // GRID MANAGEMENT
        scope.gridmanager.lock = false;

        scope.gridmanager.snap = function() {
          scope.gridmanager.lock = !scope.gridmanager.lock;

          if (scope.gridmanager.lock) {
            scope.jsonmodel.elements.forEach(function(element, index, array) {
              if (
                element.type != 'pageBlock' &&
                scope.pagemanager.getpage(element.id) ==
                  scope.pagemanager.activePage.id
              ) {
                var newx = element.data.absoluteX / 5;
                newx = Math.round(newx) * 5;
                var newy = element.data.absoluteY / 5;
                newy = Math.round(newy) * 5;
                element.data.absoluteY = newy;
                element.data.absoluteX = newx;
              }
            });
          } else {
          }
        };

        /*
         * Drawing Functions
         */

        // Stage Initialisation
        scope.drawmanager.stage = new createjs.Stage('myCan');
        //$scope.drawMgr.stage = new createjs.Stage(this.(".myCan").get(0));

        /*
              scope.draw = function(){
                     //Easel canvas test function
                     scope.drawmanager.stage.removeAllChildren();
                     if(scope.jsonmodel !== null)
                       if(!angular.isUndefined(scope.jsonmodel.elements))
                         scope.jsonmodel.elements.forEach(function(element, index, array){
                          if(element.type != "pageBlock" && scope.pagemanager.getpage(element.id) == scope.pagemanager.activePage.id)
                          {
                          //scope.redraw(element);
                          var color = (!angular.isUndefined(element.render.color)) ? 
                          element.render.color : "red";
                          var rect = new createjs.Shape();
                         rect.graphics.beginFill(color).dr(element.data.absoluteX, element.data.absoluteY, element.render.w, element.render.h);
                          rect.name=element.type + " " +element.id;

                          scope.drawmanager.shapelisteners(rect)
                          
                          rect.on("mousedown", function(evt) {
                            scope.selectmanager.select(element, element.id, 1);
                          });

                          rect.on("click", function(evt) {
                            scope.selectmanager.select(element, element.id, 1);
                           scope.$apply();
                            scope.drawmanager.stage.update();
                          });
                          scope.drawmanager.stage.addChild(rect);
                           scope.drawmanager.stage.update();
                         }
                      }); // forEach end
            };*/

        if (!angular.isUndefined(scope.jsonmodel.elements)) {
          scope.jsonmodel.elements.forEach(function(element, index, array) {
            scope.pagemanager.refresh(element);
          });

          //scope.pagemanager.refresh(scope.pagemanager.activePage);
        }

        scope.$watch(
          'jsonmodel',
          function(newval, oldval) {
            if (newval != null) {
              if (
                !angular.isUndefined(newval.elements) &&
                !angular.isUndefined(oldval.elements)
              ) {
                newval.elements.forEach(function(element, index, array) {
                  if (element != oldval.elements[index]) {
                    scope.drawmanager.redraw(element);
                  }
                });
              }
            }
          },
          true
        );
      },
    };
  };

  guiEditor.$inject = ['$timeout'];
  return guiEditor;
});
