'use strict';
define(function() {
  var textBlock = function() {
    return {
      restrict: 'AE',
      templateUrl: 'js/XG/modules/print/views/directives/blocks/textBlock.html',
      //controllerAs: 'ModelGUICtrl',
      scope: {
        pagemanager: '=pagemanager',
        selectmanager: '=selectmgr',
      },
      link: function(scope) {
        scope.newBlock = function() {
          var block = {
            label: 'TextBlock',
            type: 'textBlock',
            render: {
              color: '#90000c',
              w: 120,
              h: 120,
            },
            data: {
              absoluteX: 0,
              absoluteY: 0,
              class: 'org.mapfish.print.config.layout.TextBlock',
              font: 'Helvetica',
              fontSize: 12,
              fontEncoding: 'Cp1252',
              fontColor: 'black',
              spacingAfter: 0,
              align: 'LEFT',
              vertAlign: 'TOP',
              backgroundColor: '#FFFFFF',
              width: '120',
              height: '120',
              borderSize: '0',
              text: 'TEXTE',
            },
          };
          scope.selectmanager.add(block);

          scope.$broadcast('printTextBlockEvent');
        };
      },
    };
  };

  textBlock.$inject = [];
  return textBlock;
});
