'use strict';
define(function() {
  var legendBlock = function() {
    return {
      restrict: 'AE',
      templateUrl:
        'js/XG/modules/print/views/directives/blocks/legendBlock.html',
      //controllerAs: 'ModelGUICtrl',
      scope: {
        pagemanager: '=pagemanager',
        selectmanager: '=selectmgr',
      },
      link: function(scope) {
        scope.newBlock = function() {
          var block = {
            label: 'Legende',
            type: 'legendBlock',
            render: {
              color: '#400044',
              w: 250,
              h: 250,
            },
            data: {
              absoluteX: 0,
              absoluteY: 0,
              class: 'org.mapfish.print.config.layout.LegendsBlock',
              backgroundColor: '#FFFFFF',
              borders: false,
              horizontalAlignment: 'center',
              maxWidth: 250,
              maxHeight: 250,
              textMaxWidth: 100,
              textPadding: '0 0 0 5',
              iconPadding: '0 0 0 0',
              defaultScale: 1,
              inline: true,
              classIndentation: 0,
              layerSpaceBefore: 5,
              layerSpace: 0,
              classSpace: 1,
              themeFont: 'Helvetica',
              themeFontSize: 14,
              layerFont: 'Helvetica',
              layerFontSize: 12,
              classFont: 'Helvetica',
              classFontSize: 10,
              fontEncoding: 'Cp1252',
              scaleForAllIcons: 1.5,
              //                        "iconMaxWidth": 100,
              //                        "iconMaxHeight": 5,
              iconMaxWidth: 20,
              iconMaxHeight: 20,
              columnNumber: 2,
              spacingAfter: 10,
              overflowPolitic: 'shrink',
              inlineWhenSimple: false,
            },
          };
          scope.selectmanager.add(block);
        };

        scope.delBlock = function() {
          scope.deletefct();
        };
      },
    };
  };

  legendBlock.$inject = [];
  return legendBlock;
});
