'use strict';
define(function() {
  var variablesAttr = function(PrintModelFactory) {
    return {
      restrict: 'AE',
      templateUrl:
        'js/XG/modules/print/views/directives/guieditor/variables.html',
      scope: {
        pagemanager: '=pagemanager',
      },
      link: function(scope) {
        scope.variables = [];

        var getJsonModelName = function() {
          var scopep;
          scopep = scope.$parent;
          while (
            scopep != null &&
            (scopep.jsonmodel == undefined ||
              scopep.jsonmodel.elements.length == 0)
          )
            scopep = scopep.$parent;
          if (scopep == null) {
            scopep = scope.$parent;
            while (scopep != null && scopep.selected_resource == undefined)
              scopep = scopep.$parent;
          } else return scopep.jsonmodel.name;
          if (scopep != null && scopep.selected_resource.name != undefined)
            return scopep.selected_resource.name;
          else return 'noname';
        };

        scope.fac_resources = PrintModelFactory.resources;
        PrintModelFactory.getVariablesNames(getJsonModelName()).then(
          function(data) {
            if (data) {
              console.log('Variable loaded : ' + JSON.stringify(data));
              /*
                            scope.variables = data;
                            var pageMgr = scope.$parent.pagemanager;
                            for (var iVar=scope.variables.length-1;iVar>=0;iVar--)
                                 if (!pageMgr.variableExists(scope.variables[iVar].key))
                                    {
                                     scope.variables.splice(iVar,1);
                                     PrintModelFactory.resources.configVariables.splice(iVar,1);
                                    }
                                    */
              PrintModelFactory.resources.deletedVariables = [];
            } else {
              console.log('No variables');
            }
          },
          function(data) {
            require('toastr').info(data);
          }
        );

        /**
         * Delete a line
         * @param index
         */
        scope.deleteLine = function(index) {
          PrintModelFactory.resources.deletedVariables.push(
            scope.variables[index]
          );
          console.log(
            'tail : ' +
              JSON.stringify(PrintModelFactory.resources.deletedVariables)
          );

          scope.variables.splice(index, 1);
        };
      },
    };
  };

  variablesAttr.$inject = ['PrintModelFactory'];

  return variablesAttr;
});
