'use strict';
define(function() {
  var textAttr = function(
    $translate,
    PrintModelFactory,
    SharedFactory,
    ngDialog
  ) {
    return {
      restrict: 'AE',
      templateUrl:
        'js/XG/modules/print/views/directives/blocks/blocksConf/textAttr.html',
      scope: {
        res: '=res',
      },
      link: function(scope) {
        var DATE_VALUE = '${now dd.MM.yyyy}';
        var SCALE_VALUE = '1: ${scale}';

        var currentVariables;

        scope.textBorderSizesArray = ['0', '1', '2', '3', '4'];
        scope.fontSizesArray = [
          8,
          9,
          10,
          11,
          12,
          14,
          16,
          18,
          20,
          22,
          24,
          26,
          28,
          36,
          48,
          72,
        ];
        scope.textTypeArray = getTextLables();
        scope.displayText = true;
        scope.fontsArray = PrintModelFactory.fontsNames;
        var initialText = scope.res.data.text;

        // Reset select type text
        scope.$on('printTextBlockEvent', function() {
          scope.textType = '';
        });

        if (angular.equals(initialText, DATE_VALUE)) {
          scope.textType = scope.textTypeArray[1]; // DATE
          initialText = '';
        } else if (angular.equals(initialText, SCALE_VALUE)) {
          scope.textType = scope.textTypeArray[2]; // ECHELLE
          initialText = '';
        }

        scope.$watch('res.render.w', function(newval, oldval) {
          if (newval != oldval) scope.res.data.width = newval;
        });

        scope.$watch('res.render.h', function(newval, oldval) {
          if (newval != oldval) scope.res.data.height = newval;
        });

        /*
                scope.ngB('res.data.text', function (newval, oldval) {
                    if (newval != oldval) {
                        updateConfigVariables(newval, oldval);
                    }
                });
                */

        scope.displayTextInput = function() {
          var selectedTextType = scope.textType;
          //require('toastr').info(selectedTextType);

          if (!angular.equals(selectedTextType, '')) {
            switch (selectedTextType.toUpperCase()) {
              case 'LIBRE':
                if (
                  !angular.equals(initialText, DATE_VALUE) &&
                  !angular.equals(initialText, SCALE_VALUE)
                ) {
                  scope.res.data.text = initialText;
                }
                break;

              case 'DATE':
                scope.res.data.text += DATE_VALUE;
                break;

              case 'ECHELLE':
                scope.res.data.text += SCALE_VALUE;
                break;
            }
          }
        };

        scope.updateConfigVariables = function() {
          var ind, variable;
          var index2;
          var prevVariables;
          var variables = PrintModelFactory.getDollarVariables(
            scope.res.data.text
          );

          prevVariables = PrintModelFactory.getLastVariablesText();
          if (prevVariables == undefined) prevVariables = [];
          PrintModelFactory.setTextBlockFlag(true);
          currentVariables = angular.copy(variables);

          //-- Recherche des variables retirées (modifié = rétiré + ajouté) dans la zone de texte.
          for (ind = 0; ind < prevVariables.length; ind++) {
            if (variables.indexOf(prevVariables[ind]) == -1) {
              //-- Suppression d'ne variable qui n'existe plus (probablement renommée).
              index2 = searchVariableInArray(
                prevVariables[ind],
                PrintModelFactory.resources.configVariables
              );
              removeVariableFromArray(
                index2,
                PrintModelFactory.resources.configVariables
              );
            }
            PrintModelFactory.setLastVariablesText(currentVariables);
          }

          for (ind = 0; ind < variables.length; ind++) {
            variable = variables[ind];
            if (variable && !PrintModelFactory.isReservedVariable(variable)) {
              //-- La variable n'est pas un mot réservé
              var index = searchVariableInArray(
                variable,
                PrintModelFactory.resources.configVariables
              );
              console.log('currentVariables: ' + variable);
              if (index == -1) {
                //-- Il faut ajouter la variable dans la liste
                if (
                  !angular.isArray(PrintModelFactory.resources.configVariables)
                ) {
                  //-- Le tableau liste de variables n'est pas encore défini, on l'instancie.
                  PrintModelFactory.resources.configVariables = [];
                }
                //-- Ajout de la variable dans la liste.
                PrintModelFactory.resources.configVariables.push(
                  PrintModelFactory.buildVariable(variable, '')
                );
              }
            }
          }
          PrintModelFactory.setLastVariablesText(currentVariables);
        };

        scope.showTextAttrHelp = function() {
          var template;
          template =
            'js/XG/modules/print/views/directives/blocks/blocksHelp/textAttrHelp.html';
          ngDialog.open({
            template: template,
            plain: false,
            scope: scope,
            className: 'ngdialog-theme-plain width600',
          });
        };

        function getTextLables() {
          var labels = [];
          $translate('print.blocks_attributes.text_attributes.free').then(
            function(res) {
              labels[0] = res;
            }
          );
          $translate('print.blocks_attributes.text_attributes.date').then(
            function(res) {
              labels[1] = res;
            }
          );
          $translate('print.blocks_attributes.text_attributes.scale').then(
            function(res) {
              labels[2] = res;
            }
          );

          return labels;
        }

        function searchVariableInArray(text, arrayObj) {
          var index = -1;
          var found = false;

          if (text && arrayObj) {
            text = text.replace('${', '').replace('}', '');

            for (var i = 0; i < arrayObj.length; i++) {
              if (arrayObj[i].key == text) {
                index = i;
                break;
              }
            }
          }

          return index;
        }

        function removeVariableFromArray(index, arrayObj) {
          if (index > -1 && arrayObj) {
            arrayObj.splice(index, 1);
          }
        }

        function printArray(arrayObj) {
          console.log('Size = ' + arrayObj.length);
          for (var i = 0; i < arrayObj.length; i++) {
            angular.forEach(arrayObj[i], function(value, key) {
              console.log(key + ' : ' + value);
            });
          }
        }
      },
    };
  };

  textAttr.$inject = [
    '$translate',
    'PrintModelFactory',
    'SharedFactory',
    'ngDialog',
  ];
  return textAttr;
});
