/**
 *
 */
'use strict';
define(function() {
  /**
   * imeiCtrl
   * @param $scope
   * @param $window
   * @param $location
   * @param ApplicationFactory
   * @param RolesFactory
   * @constructor
   */
  var imeiCtrl = function(
    $scope,
    $window,
    $location,
    RolesFactory,
    ngDialog,
    $timeout,
    $filter,
    OdkFactory,
    $http
  ) {
    $scope.newimei = false;

    var refreshList = function() {
      $scope.currentResources = [];

      OdkFactory.getlistimei().then(
        function(res) {
          /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
          $scope.currentResources = res.data;

          //refreshList();
        },
        function(res) {
          require('toastr');
        }
      );
    };
    $scope.editImei = function() {
      if ($scope.newimei) {
        OdkFactory.addimei($scope.edit_resource).then(function(res) {
          /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
          //$scope.currentResources = res.data;

          refreshList();
        });
      } else {
        OdkFactory.updateimei(
          $scope.edit_resource.ID,
          $scope.edit_resource
        ).then(function(res) {
          /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
          //$scope.currentResources = res.data;

          refreshList();
        });
      }
    };

    $scope.options = ['DEMANDE', 'ACTIF'];
    $scope.buildereditImei = function(loadTemplate) {
      $scope.newimei = false;
      ngDialog.open({
        template: 'js/XG/modules/odk/views/modals/modal.imei.html',
        className: 'ngdialog-theme-plain  height300  miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };
    $scope.builderImei = function(loadTemplate) {
      $scope.edit_resource = {};
      $scope.newimei = true;
      ngDialog.open({
        template: 'js/XG/modules/odk/views/modals/modal.imei.html',
        className: 'ngdialog-theme-plain  height300 miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.removeImei = function() {
      OdkFactory.deleteimei($scope.edit_resource.ID).then(function(res) {
        /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
        //$scope.currentResources = res.data;

        refreshList();
      });
    };

    $scope.editListCfg = {
      dataModule: 'odk',
      resource_type: 'imei',
      cols: ['IMEI', 'NAME', 'MODELE', 'NUMERO', 'DATE', 'VERSION', 'STATUT'],
      colsFunction: {
        DATE: 'datetoshow',
      },
      addFunction: $scope.builderImei,
      editFunction: $scope.buildereditImei,
      removeFunction: $scope.removeImei,
    };

    OdkFactory.getlistimei().then(function(res) {
      /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
      $scope.currentResources = res.data;

      //refreshList();
    });
  };

  imeiCtrl.$inject = [
    '$scope',
    '$window',
    '$location',
    'RolesFactory',
    'ngDialog',
    '$timeout',
    '$filter',
    'OdkFactory',
    '$http',
  ];
  return imeiCtrl;
});
