'use strict';
define(() =>{
  let ObjectFilesFactory = ($http,$q,$rootScope,gaJsUtils, $filter) => {
    /**
     * Function: create objectFiles table if not exist
     */
    function createObjectFilesTableIfNotExit(mainDb) {
      return $http.get('/services/{portalid}/objectFiles/createTableIfNotExit?f=json&mainDb='+mainDb);
    }
    /**
     * Function: getByUid
     */
    function getByUid(mainDb, uid) {
      return $http.get('/services/{portalid}/objectFiles/getByUid?f=json&mainDb='+mainDb+'&uid='+uid);
    }
    /**
     * Function: getAllObjectFiles
     */
     function getAll(mainDb) {
      return $http.get('/services/{portalid}/objectFiles/getAll?f=json&mainDb='+mainDb);
    }
    /**
     * Function: addOrUpdate objectFiles
     */
    function addOrUpdate(mainDb,senddata,isNewResource) {
      return $http.post('/services/{portalid}/objectFiles/add?f=json&mainDb='+mainDb+'&isNewResource='+!!isNewResource,senddata);
    }
    /**
     * Function: remove association
     */
     function remove(mainDb,id) {
      return $http.get('/services/{portalid}/objectFiles/remove?f=json&mainDb='+mainDb+'&id='+id);
    }
    /**
     * function getObjectFilesFiltredByAuthorizedAttributes
     */
    function getObjectFilesFiltredByAuthorizedAttributes(uid,authorizedAttributes) {
      let def = $q.defer();
      if(gaJsUtils.notNullAndDefined($rootScope.xgos, 'portal.parameters.mainDB')){
        let mainDb = $rootScope.xgos.portal.parameters.mainDB;
        getByUid(mainDb, uid).then(res => {
          if(res.data && res.data.active) {
            let configurationTab = res.data;
            if (Array.isArray(authorizedAttributes)) {
              for (const tab of configurationTab.configuration){
                tab.fields = tab.fields.filter(att => 
                  authorizedAttributes.findIndex(authFeat => authFeat.name === att.name) !== -1
                )
              }
            }
            def.resolve(configurationTab);
          } else {
            // l'absence de fiche-objet n'est pas une erreur
            // une fiche-objet n'est pas obligatoire pour voir les attributs d'un objet de composant
            console.info('getObjectFilesFiltredByAuthorizedAttributes : aucune fiche-objet ' + res.data.active ? 'configurée' : 'publiée');
            def.resolve();
          }
        },(error) => {
          def.reject(error.data);
        });
      } else {
        def.reject($filter('translate')('model.objectFiles.noMainDB'));
      }
      return def.promise;
    }
    return {
      createObjectFilesTableIfNotExit:createObjectFilesTableIfNotExit,
      getAll:getAll,
      getByUid:getByUid,
      addOrUpdate:addOrUpdate,
      remove:remove,
      getObjectFilesFiltredByAuthorizedAttributes:getObjectFilesFiltredByAuthorizedAttributes
    };
  };
  ObjectFilesFactory.$inject = ['$http', '$q', '$rootScope','gaJsUtils', '$filter'];
  return ObjectFilesFactory;
});
