'use strict';
define(() =>{
  var DataDictionaryFactory = ($http) => {

    /**
     * Function: getConfig
     */
    const getConfig = () => {
      return $http.get('/services/{portalid}/dataDictionary/getConfig?f=json')
    }
    /**
     * Function: saveConfig
     * Méthode obsolète depuis KIS-3385 et la sauvegarde de la configuration lors de l'export CSV
     */
     const saveConfig = (config) => {
      return $http.post('/services/{portalid}/dataDictionary/saveConfig?f=json',config);
    };
    /**
     * Exporte les csv du dictionnaire (structure données + propriétés composants).
     * Exécute saveConfig côté serveur pour éviter 2 appels API
     * @param {object[]} config liste des composants concernés par l'export du dictionnaire
     * @param {number} encoding identifiant numérique de l'encodage de texte du portail
     * @return {Promise} contient les noms des fichiers csv
     */
    const exportCSV = (config, encoding) => {
      return $http.post('/services/{portalid}/dataDictionary/exportCSV?f=json' + (encoding != null ? ('&encoding=' + encoding) : ''), config);
    };

    return {
      getConfig:getConfig,
      saveConfig: saveConfig,
      exportCSV:exportCSV
    };
  };

  DataDictionaryFactory.$inject = ['$http'];
  return DataDictionaryFactory;
});
