'use strict';
define(function() {
  var BaseMapFactory = function($http, gaUrlUtils) {
    var BaseMapFactory = {};
    /**
     * Class : BaseMapFactory
     * Factory WebServices
     */
    var resources = { basemaps: [] };

    /**
     * Function: add
     */
    function add(senddata) {
      var promise = $http.post(
        '/services/{portalid}/basemap/add?f=json',
        senddata
      );
      promise.then(function(res) {
        // service level logic if any
        resources.basemaps.push(res.data);
      });
      return promise;
    }
    /**
     * Function: remove
     */
    function remove(name) {
      var urlFileName = gaUrlUtils.encodeUriQuery(name);
      var promise = $http.get(
        '/services/{portalid}/basemap/remove?f=json' + '&name=' + urlFileName
      );
      promise.then(function(res) {
        var deleteIndex = resources.basemaps
          .map(function(x) {
            return x.name;
          })
          .indexOf(name);
        resources.basemaps.splice(deleteIndex, 1);
      });
      return promise;
    }
    /**
     * Function: get
     */
    function get() {
      var promise = $http.get('/services/{portalid}/basemap/get?f=json');
      promise.then(function(res) {
        resources.basemaps = res.data;
      });
      return promise;
    }
    /**
     * Function: update
     */
    function update(senddata, oldname) {
      var promise = $http.post(
        '/services/{portalid}/basemap/update?f=json&oldname=' + oldname,
        senddata
      );
      promise.then(function(res) {
        oldname = oldname.length == 0?res.data.name:oldname;
        var deleteIndex = resources.basemaps
          .map(function(x) {
            return x.name;
          })
          .indexOf(oldname);
        //-- Quand oldname est vide deleteIndex vaut -1
        //-- et il ne faut pas tenter de remplacer l'ancien fond de plan
        //-- par le nouveau, cela aboutirait à l'avoir en double dans la liste.
        if (deleteIndex != -1) {
          resources.basemaps.splice(deleteIndex, 1, res.data);
        }
        console.log(res);
        // service level logic if any
      });
      return promise;
    }
    /**
     * Function: update all
     */
    function updateAll(senddata) {
      var promise = $http.post(
        '/services/{portalid}/basemap/updateAll?f=json',
        senddata
      );
      promise.then(function(res) {
        resources.basemaps = res.data;
      });
      return promise;
    }
    
    return {
      BaseMapFactory: BaseMapFactory,
      resources: resources,
      add: add,
      remove: remove,
      get: get,
      update: update,
      updateAll:updateAll,
    };
  };
  BaseMapFactory.$inject = ['$http', 'gaUrlUtils'];
  return BaseMapFactory;
});
