/////////////////////////////////////////////////////////////
// Gestion de la configuration des règles métiers.
/////////////////////////////////////////////////////////////
'use strict';
define(function() {
  var gcelement = function($filter, ngTableParams) {
    return {
      templateUrl:
        'js/XG/modules/model/views/directives/featuretypeactionsUrl.html',
      restrict: 'E',
      scope: {
        currentFormData: '=currentformdata',
        fti: '=fti',
        allActionsNames: '=allactionsnames',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.currentFormData.actionType = $filter('translate')(
          'model.featuretypes.actions.url'
        );
        scope.currentFormData.typeInfo = 'URL';

        if (angular.isUndefined(scope.currentFormData.parameters))
          scope.currentFormData.parameters = [];

        var names = [];
        scope.attributesAliases = scope.fti.attributes.map(function(x) {
          names.push(x.name);
          return x.alias;
        });
        /**
         * Paramètres du tableau listant les règles associées au currentfeaturetype passé à cette directive
         */
        scope.tableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.currentFormData.parameters.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              params.total(scope.currentFormData.parameters.length); // set total for recalc pagination
              $defer.resolve(displayedTab);
            },
          }
        );

        scope.attributChanged = function(rapport) {
          if (
            rapport.saisieMode ===
              $filter('translate')(
                'model.featuretypes.actions.saisieAttribut'
              ) ||
            rapport.typeInfo === 'saisieAttribut'
          ) {
            var idx = scope.attributesAliases.indexOf(rapport.attribute);
            rapport.value = names[idx];
          }
        };

        scope.addParameter = function() {
          scope.currentFormData.parameters.push({
            id: Math.floor(Math.random() * 10000),
          });
          scope.tableParams.reload();
        };

        scope.removeParameter = function(idx) {
          scope.currentFormData.parameters.splice(idx, 1);
          scope.tableParams.reload();
        };

        scope.saisieModes = [
          $filter('translate')('model.featuretypes.actions.saisieAttribut'),
          $filter('translate')('model.featuretypes.actions.saisieUtilisateur'),
          $filter('translate')('model.featuretypes.actions.saisieStatic'),
        ];

        scope.changedParameters = function(rapport) {
          switch (rapport.saisieMode) {
            case $filter('translate')(
              'model.featuretypes.actions.saisieAttribut'
            ):
              rapport.typeInfo = 'saisieAttribut';
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieUtilisateur'
            ):
              rapport.typeInfo = 'saisieUtilisateur';
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieStatic'
            ):
              rapport.typeInfo = 'saisieStatic';
              break;
          }
        };
      },
    };
  };

  gcelement.$inject = ['$filter', 'ngTableParams'];
  return gcelement;
});
