'use strict';
define(function() {
  var gcelement = function($filter, gaJsUtils) {
    return {
      templateUrl:
        'js/XG/modules/model/views/directives/featuretypeactionsIsDetail.html',
      restrict: 'E',
      scope: {
        currentFormData: '=currentformdata',
        fti: '=fti',
      },
      link: function(scope) {
        if (scope.currentFormData.properties == null)
          scope.currentFormData.properties = {};

        if (!angular.isDefined(scope.currentFormData.properties.is_detail_cfg))
          scope.currentFormData.properties.is_detail_cfg = {
            parent: {
              fields: [{}],
            },
            self: {
              fields: [],
            },
          };

        scope.translateAlias = function(attr, fti) {
          return gaJsUtils.translateAttributeAlias(attr.name, fti);
        };

        scope.addFieldToBloc = bloc => {
          scope.currentFormData.properties.is_detail_cfg[bloc].fields.push({});
        };
        scope.removeFieldFromBloc = (idx, bloc) => {
          scope.currentFormData.properties.is_detail_cfg[bloc].fields.splice(
            idx,
            1
          );
        };

        scope.diComponent = {};
        scope.diftipicked = function(changedByUser) {
          if (!scope.diComponent.x) return;

          // reset config
          if (changedByUser)
            scope.currentFormData.properties.is_detail_cfg.self.fields = [];
          scope.currentFormData.properties.is_detail_cfg.di_fti =
            scope.diComponent.x.uid;
        };

        scope.currentFormData.actionType = $filter('translate')(
          'model.featuretypes.actions.is_detail'
        );
        scope.currentFormData.typeInfo = 'IS_DETAIL';
      },
    };
  };

  gcelement.$inject = ['$filter', 'gaJsUtils'];
  return gcelement;
});
