'use strict';
define(function() {
  var featuretypePreview = function(
    gcWMS,
    FeatureTypeFactory,
    gaJsUtils,
    DataStoreFactory,
    gcMapUtils
  ) {
    return {
      templateUrl:
        'js/XG/modules/model/views/directives/featuretypePreview.html',
      restrict: 'EA',
      scope: {
        previewfti: '=',
        previewftis: '=',
        basemap: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        function getEsriWMSParams(typeNames, opacityValue, filtert,ogcid) {
          var dynamicLayers = [];
          for (var i = 0; i < typeNames.length; i++) {
            var dynamicLayerEntry = {
              id: typeNames[i],
              source: {
                type: 'mapLayer',
                mapLayerId: ogcid,
              },
            };
            var filter = filtert[i];
            if (filter != null && filter != '1=1')
              dynamicLayerEntry.definitionExpression = filter;
            var opacity = opacityValue[i];
            if (opacity != null)
              dynamicLayerEntry.drawingInfo = {
                transparency: opacity == 1 ? 0 : 100 - opacity * 100,
              };
            dynamicLayers.push(dynamicLayerEntry);
          }
          return {
            dynamicLayers: angular.toJson(dynamicLayers),
            tiled: true,
            tilesorigin: '-20037508.342789236,-20037508.342789236',
            type: 'esri',
            bboxSR: '3857'
          };
        }

        var generateWmsLayer = function(params, options, tiled) {
          options.toto = 'titi';
          var layer =
            tiled == undefined || tiled
              ? generateTiledWmsLayer(params, options)
              : generateImageWmsLayer(params, options);
          if (options.directUrl) layer.set('directUrl', options.directUrl);

          return layer;
        };

        var generateTiledWmsLayer = function(params, options) {
          options = options || {};
          var attributions;
          var source, layer;
          if (options.gctype == 'esri') {
            source = new olkis.KISTileArcGISRest({
              params: params,
              url: options.url,
              crossOrigin: 'anonymous',
              extent: options.extent,
              attributions: attributions,
              ratio: options.ratio || 1,
            });
            /*
             * source.getRequestUrl_ = function(tileCoord, tileSize,
             * tileExtent, pixelRatio, projection, params) {
             * console.log("GET REQUEST URL"); var urls = this.urls;
             * if (!urls) { return undefined; } // ArcGIS Server
             * only wants the numeric portion of the projection ID.
             * var srid = projection.getCode().split(':').pop();
             * params['SIZE'] = tileSize[0] + ',' + tileSize[1];
             * params['BBOX'] = tileExtent.join(','); params['DPI'] =
             * Math.round( params['DPI'] ? params['DPI'] *
             * pixelRatio : 90 * pixelRatio ); var url; if
             * (urls.length == 1) { url = urls[0]; } else { var
             * index = ol.math.modulo(ol.tilecoord.hash(tileCoord),
             * urls.length); url = urls[index]; } var modifiedUrl =
             * url .replace(/MapServer\/?$/, 'MapServer/export')
             * .replace(/ImageServer\/?$/,
             * 'ImageServer/exportImage'); return
             * ol.uri.appendParams(modifiedUrl, params); };
             */
          } else
            source = new ol.source.TileWMS({
              params: params,
              url: options.url,
              extent: options.extent,
              attributions: attributions,
              ratio: options.ratio || 1,
            });
          if (angular.isDefined(params.STYLES)) {
            layer = new ol.layer.Tile({
              id: options.layerinWMS,
              url: options.url,
              type: 'WMS',
              layersg: params.LAYERS,
              opacity: options.opacity,
              visible: options.visible,
              attribution: options.attribution,
              fti: options.fti,
              style: params.STYLES,
              name: options.name,
              source: source,
            });
          } else {
            layer = new ol.layer.Tile({
              id: options.layerinWMS,
              url: options.url,
              type: 'WMS',
              layersg: params.LAYERS,
              opacity: options.opacity,
              visible: options.visible,
              attribution: options.attribution,
              fti: options.fti,
              // style: params.STYLES,
              name: options.name,
              source: source,
            });
          }
          layer.preview = options.preview;
          layer.displayInLayerManager = !layer.preview;
          layer.label = options.label;
          return layer;
        };

        function getFtiDataStore(fti) {
          if (
            DataStoreFactory.resources &&
            DataStoreFactory.resources.datastores
          )
            for (
              var i = 0;
              i < DataStoreFactory.resources.datastores.length;
              i++
            ) {
              var dataStore = DataStoreFactory.resources.datastores[i];
              if (fti.storeName == dataStore.name) return dataStore;
            }

          return null;
        }

        function getLinkUrl(dataStore) {
          if (dataStore.useproxy && dataStore.proxykey)
            return '../esriproxy/' + dataStore.proxykey + '/MapServer';
          else dataStore.url;
        }

        function getEsriInfo(previewfti) {
          var wmsLink,
            fti = previewfti;
          var ftiDataStore = getFtiDataStore(previewfti);
          wmsLink = ftiDataStore ? getLinkUrl(ftiDataStore) : fti.wms;
          return {
            url: wmsLink,
            directurl: ftiDataStore ? ftiDataStore.url : fti.wms,
            tiled: ftiDataStore ? ftiDataStore.tiled : fti.isTiledMap,
          };
        }

        function getEsriLayer(previewfti) {
          var l,
            mme = {
              fti: previewfti,
            };
          mme.theme = 'preview';

          l = gcWMS.getOlLayerFromMapModelElement(mme);
          var wmsParams,
            tiled = true,
            esriInfo = getEsriInfo(previewfti);
          var layerinWMS = [l];
          var reflayerinWMS = [l];
          wmsParams = getEsriWMSParams([mme.fti.name], 1, [null],mme.fti.ogcId);
          var wmsOptions = {
            url: esriInfo.url,
            directUrl: esriInfo.directurl,
            layerinWMS: {
              mode: 'WMS',
              refLayer: reflayerinWMS,
              type: 'GROUP',
              activeLayer: layerinWMS,
              indexWms: 0,
              rejected: [],
            },
            grouptype: 'GROUP,' + 0,
            gctype: 'esri',
          };
          l = generateWmsLayer(wmsParams, wmsOptions, tiled);
          return l;
        }

        function addpreviewTomap (previewfti,previewftis) {
          if (previewftis) {
            previewfti = previewftis[0];
          }
          FeatureTypeFactory.getExtent(
            previewfti.uid, map.getView().getProjection().getCode()
          ).then((res) => {
            var bbox = res.data;
            map.getView().fit(bbox, map.getSize());
            var l;
            if (previewfti.type == 'esri') {
              console.log(
                'ATTENTION :: GET projection from esri fti data store and use it in the view'
              );
              //-- On a besoin du datasource pour ArcGIS (la clef qui défini
              //-- la connexion est à mettre dans l'url de demande de carte)
              DataStoreFactory.get().then(() => {
                l = getEsriLayer(previewfti);
                map.addLayer(l);
              });
            } else {
              l = gcWMS.getOlLayerFromFeaturetypeInfo(previewfti);
              if (previewftis) {
                scope.previewLayer = l;
                scope.src = l.getSource();
                scope.src.updateParams({
                  LAYERS: previewftis.map((fti) => fti.name).join(','),
                  STYLES: previewftis.map((fti) => fti.defaultStyle).join(',')
                });
              }
              map.addLayer(l);
            }
          },
          function(data) {
            require('toastr').info(data);
          }
          );
        }


        let source;
        if(!scope.basemap || scope.basemap === 'osm'){
          source = new ol.source.OSM();
        } else {
          source = new ol.source.XYZ({
            url:'http://{1-4}.basemaps.cartocdn.com/'+scope.basemap+'/{z}/{x}/{y}.png',
          });
        }
        const viewOptions = {
          center: [0, 0],
          zoom: 2
        };
        if(angular.isDefined(scope.previewftis)) {
          viewOptions.projection = scope.previewftis[0].srid;
        }
        else if (angular.isDefined(scope.previewfti)) {
          viewOptions.projection = scope.previewfti.srid;
        }


        let mapconfig = {
          layers: [
            new ol.layer.Tile({
              source: source,
            })
          ],
          target: 'previewmap',
          view: new ol.View(viewOptions),
          ol3Logo: false,
        };
        // active le zoom seulement avec le bouton alt
        if(angular.isDefined(scope.previewftis)){
          mapconfig.interactions = ol.interaction.defaults({mouseWheelZoom: false}).extend([gcMapUtils.altZoomInteraction()]);
        }
        var map = new ol.Map(mapconfig);

        if (angular.isDefined(scope.previewfti)) {
          addpreviewTomap (scope.previewfti);
        } else if(scope.previewftis){
          addpreviewTomap (null, scope.previewftis);
        }

        scope.$on('changeLayerVisibility', function(event, layer) {
          if (scope.previewftis) {
            const ftis = scope.previewftis.filter((fti) => fti.visible);
            if (ftis.length === 0) {
              scope.previewLayer.setVisible(false);
            }
            else {
              scope.previewLayer.setVisible(true);
              scope.src.updateParams({
                LAYERS: ftis.map((fti) => fti.name).join(','),
                STYLES: ftis.map((fti) => fti.defaultStyle).join(',')
              });
            }
          }
          else {
            const wfsLayer = findWfslayer(layer.name);
            if (wfsLayer) {
              wfsLayer.setVisible(layer.visible);
            }
          }
        });

        let findWfslayer = (name) => {
          let wfsLayer = 0;
          map.getLayers().forEach(function(lyr) {
            if (name == lyr.get('name')) {
              wfsLayer = lyr;
            }
          });
          return wfsLayer;
        };
      },
    };
  };

  featuretypePreview.$inject = [
    'gcWMS',
    'FeatureTypeFactory',
    'gaJsUtils',
    'DataStoreFactory',
    'gcMapUtils'
  ];
  return featuretypePreview;
});
