/**
 *
 */
 'use strict';
 define(() => {
   /**
    * ObjectFilesCtrl
    */
   var ObjectFilesCtrl = function(
     $scope,
     $rootScope,
     $filter,
     ObjectFilesFactory,
     gaDomUtils,
     $timeout,
     FeatureTypeFactory,
     gaJsUtils
   ) {

      /**
       * supression de la fiche d'objet
       */
      $scope.remove = () => {
        ObjectFilesFactory.remove($scope.mainDataBase, $scope.edit_resource.ID).then(()=>{
          refreshList();
        });
      };
      // paramètre de l'edit list
      $scope.editListCfg = {
        dataModule: 'model',
        resource_type: 'objectFiles',
        cols: ['name', 'alias'],
        removeFunction: $scope.remove,
        deleteConfirmTextSpecial:'model.objectFiles.deleteMsg'
      };

      // évite une erreur si on édite une fiche avant l'arrivée des fti
      $scope.ftis = [];

      FeatureTypeFactory.get().then(
        featureTypes => {
            $scope.ftis = featureTypes;
            $scope.ftisAvailable = angular.copy($scope.ftis);
          }
      );
      $scope.dualBoxData = {
        id: 'objectFiles',
        leftData: [],
        leftDisplayAttribute: 'alias',
        rightData: [],
        rightDisplayAttribute: 'alias',
        leftTitle: 'model.objectFiles.dualBoxTitleLeft',
        rightTitle: 'model.objectFiles.dualBoxTitleRight',
        source: 'right',
        tabs:'left'
      };
      /**
       * à chaque selection d'un composant, on met à jour le dualBox
       */
      $scope.updateDualListBox = () =>{
        $scope.edit_resource.configuration = [];
        let rightData = $scope.edit_resource.selectfti&&$scope.edit_resource.selectfti.attributes?
                                        angular.copy($scope.edit_resource.selectfti.attributes):[]
        $scope.$broadcast('setDualListBoxContent', {
          id: 'objectFiles',
          leftData: $scope.edit_resource.configuration,
          rightData: rightData
        });
      };
      /**
       * verifier si la valeur est déjà existante dans l'array
       */
      let valueExistInTab = (leftData,value) => {
        let found = false;
        leftData.forEach(tab=>{
          if(tab.fields.findIndex(att => value.name === att.name)>=0){
            found = true;
            return;
          }
        })
        return found;
      };
      $scope.$on('data_modal', () =>{
        $scope.edit_resource.selectfti = $scope.ftis.find((fti)=>fti.uid==$scope.edit_resource.uid);
        $scope.ftisAvailable.push($scope.edit_resource.selectfti);
        let leftData = $scope.edit_resource.configuration?$scope.edit_resource.configuration:[];
        let rightData = [];
        //enlever les valeurs du left de la partie droite
        if($scope.edit_resource.selectfti && $scope.edit_resource.selectfti.attributes){
          angular.copy($scope.edit_resource.selectfti.attributes).forEach(att =>{
            if(!valueExistInTab(leftData,att)){
              rightData.push(att);
            }
          })
        }
        // @rse dualBoxData.tabs = 'left'...
        // Cela serait mieux un boolean car la conception des tabs est figée et ne peut être appliquée que sur la partie gauche.
        // (incapacité constatée dans le HTML au minimum, dualListBox.html)
        $scope.dualBoxData = {
          id: 'objectFiles',
          leftData: leftData,
          leftDisplayAttribute: 'alias',
          rightData: rightData,
          rightDisplayAttribute: 'alias',
          leftTitle: 'model.objectFiles.dualBoxTitleLeft',
          rightTitle: 'model.objectFiles.dualBoxTitleRight',
          source: 'right',
          tabs:'left'
        };
      });
      /**
       *vérifié s'il y a une base de donnée comme principale
       *dans le cas inverse, on peut rien faire! on affiche un erreur
       */
      let checkIfmainDataBaseExist = () => {
        if($scope.mainDataBase){
          gaDomUtils.showGlobalLoader();
          ObjectFilesFactory.createObjectFilesTableIfNotExit($scope.mainDataBase).then(()=>{
            gaDomUtils.hideGlobalLoader();
          },() =>{
            swal({
              title: $filter('translate')('model.objectFiles.createTableError'),
              type: 'error',
              showCancelButton: false,
              time: 600,
            });
            gaDomUtils.hideGlobalLoader();
          });
          return true;
        }else{
            swal({
              title: $filter('translate')('model.objectFiles.noMainDB'),
              type: 'error',
              showCancelButton: false,
              time: 600,
            });
          return false;
        }
      }
      /**
       * rafraichir les fiches d'objet et les ftis/ftiAvailable 
       */
      let refreshList = () =>{
        if($scope.mainDataBase){
          ObjectFilesFactory.getAll($scope.mainDataBase).then((res) => {
            $scope.currentResources = res.data;
            gaJsUtils.sortDataByNameIgnoreCase(res.data);
            $scope.ftisAvailable = [];
            if (Array.isArray($scope.ftis)) {
              for (const fti of $scope.ftis) {
                if(!$scope.currentResources.some(currentResource => currentResource.name === fti.name)){
                  $scope.ftisAvailable.push(fti);
                }
              }
            }
            gaJsUtils.sortDataByNameIgnoreCase($scope.ftisAvailable);
          });
        }
      }
      $timeout(()=>{
        if($rootScope.xgos.portal && $rootScope.xgos.portal.parameters && 
          $rootScope.xgos.portal.parameters.mainDB){
            $scope.mainDataBase = $rootScope.xgos.portal.parameters.mainDB;
        }
        checkIfmainDataBaseExist();
        refreshList();
      })
      /**
       * mettre à jour/ ajouter une fiche d'objet
       */
      $scope.editObjectFiles = () => {
        // init filter pour garder les bons valeur du leftdata et rightdata
        $scope.$broadcast('initFilter');
        $timeout(()=>{

          // KIS-3157: enregistre le déplacement d'onglets
          $scope.edit_resource.configuration = $scope.dualBoxData.leftData;

          ObjectFilesFactory.addOrUpdate($scope.mainDataBase, $scope.edit_resource, $scope.isNewResource).then(()=>{
            $scope.isNewResource = false;
            refreshList();
          });
        });
      };
      /**
       * supprimer une fiche d'objet
       */
      $scope.removeObjectFiles = () => {
        ObjectFilesFactory.remove($scope.mainDataBase, $scope.edit_resource.ID).then(()=>{
          refreshList();
        });
      };
      /**
       * disable bouton ajout
       */
      $scope.disableAddButton = () => {
        if($scope.edit_resource.selectfti && $scope.dualBoxData.leftData && $scope.dualBoxData.leftData.length>0){
          for(const data of $scope.dualBoxData.leftData){
            if(data.fields && data.fields.length>0){
              return false;
            }
          };
          return true;
        }else{
          return true;
        }
      }

      $scope.$on('ngDialog.closed', () => {
        if($scope.edit_resource && $scope.edit_resource.uid){
          const index = $scope.ftisAvailable.findIndex(fti => fti.uid === $scope.edit_resource.uid);
          if(index>=0){
            $scope.ftisAvailable.splice(index, 1);
          }
        }
      });
    }
 
   ObjectFilesCtrl.$inject = [
     '$scope',
     '$rootScope',
     '$filter',
     'ObjectFilesFactory',
     'gaDomUtils',
     '$timeout',
     'FeatureTypeFactory',
     'gaJsUtils'
   ];
   return ObjectFilesCtrl;
 });
