'use strict';
/**
 * @ngdoc service
 * @name modules.authentication.service:AuthFactory
 * @description
 * The authentication factory
 */
define(function() {
  var licenceFactory = function($http, $rootScope, $filter, $timeout) {
    var resources = { licences: {} };

    function getLicenceParams(portalid) {
      var promise = $http.get('/services/{portalid}/licence/getlicence?f=json');
      promise.then(
        function(res) {
          resources.licences[portalid] = res.data;
        },
        function(res) {
          if (res.data === 'error.licence.file.inexist') {
            console.info('no info file');
            resources.licences[portalid] = {
              type: 'free',
            };
          } else {
            console.info('unable to parse licence , contact admin');
            resources.licences[portalid] = {
              type: 'free',
            };
          }
        }
      );
      return promise;
    }

    function getAllLicences() {
      var promise = $http.get(
        '/services/{portalid}/licence/getalllicence?f=json'
      );
      promise.then(
        function(res) {
          resources.licences = res.data;
        },
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function CheckLicenceUploaded() {
      var promise = $http.get(
        '/services/{portalid}/licence/checklicence?f=json&lang=en'
      );
      promise.then(
        function(res) {},
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function removeuploaded() {
      var promise = $http.get(
        '/services/{portalid}/licence/removeuploaded?f=json'
      );
      promise.then(
        function(res) {},
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function reloadRepository() {
      var promise = $http.get('/services/tools/reload?f=json');
      promise.then(
        function(res) {},
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function validerLicence() {
      var promise = $http.get(
        '/services/{portalid}/licence/validerLicence?f=json'
      );
      promise.then(
        function(res) {},
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function cancreateapp() {
      var promise = $http.get(
        '/services/{portalid}/licence/cancreateapp?f=json'
      );
      promise.then(
        function(res) {},
        function(res) {
          console.error(res.data);
        }
      );
      return promise;
    }

    function getLicence(portalid) {
      return resources.licences[portalid];
    }

    function differenceInDays(d1, d2) {
      var diffMs = d2.getTime() - d1.getTime();
      return Math.ceil(diffMs / (1000 * 3600 * 24));
    }

    function differenceInMinutes(d1, d2) {
      var diffMs = d2.getTime() - d1.getTime();
      return Math.ceil(diffMs / (1000 * 3600));
    }

    Date.prototype.addDays = function(days) {
      this.setDate(this.getDate() + parseInt(days));
      return this;
    };

    function setLicenceDemo(licence) {
      var actualDate = new Date();

      if (licence.start_date && licence.start_date !== '*') {
        var date_start_split = licence.start_date.split('-');
        var start_date = new Date(
          parseInt(date_start_split[2]),
          parseInt(date_start_split[1]) - 1,
          parseInt(date_start_split[0])
        );
        if (!isNaN(start_date)) {
          var diffS = differenceInDays(start_date, actualDate);
          var diffSM = differenceInMinutes(start_date, actualDate);
          if (start_date && diffS < 0) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = Math.abs(diffS);
            $rootScope.xgos.licence.message =
              '  ' +
              $filter('translate')('reject.user.startsatdemo') +
              $rootScope.xgos.licence.delay +
              ' ' +
              $filter('translate')('elastic.search.day');
            return;
          } else if (start_date && diffS === 0 && diffSM < 0) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = Math.abs(diffSM);
            $rootScope.xgos.licence.message =
              '  ' +
              $filter('translate')('reject.user.startsatdemo') +
              $rootScope.xgos.licence.delay +
              ' ' +
              $filter('translate')('elastic.search.hours');
            return;
          }
        }
      }

      if (licence.end_date && licence.end_date !== '*') {
        var date_split = licence.end_date.split('-');
        var end_date = new Date(
          parseInt(date_split[2]),
          parseInt(date_split[1]) - 1,
          parseInt(date_split[0])
        );
        if (!isNaN(end_date)) {
          var diffD = differenceInDays(actualDate, end_date);
          if (end_date && diffD < 60 && diffD >= 30) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = diffD;
            $rootScope.xgos.licence.color = 'warning';
            $rootScope.xgos.licence.message =
              '  ' +
              $filter('translate')('reject.user.demolicence') +
              $rootScope.xgos.licence.delay +
              ' ' +
              $filter('translate')('elastic.search.day');
          } else if (end_date && diffD <= 1 && diffD >= 0) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = diffD;
            $rootScope.xgos.licence.color = 'danger';
            $rootScope.xgos.licence.message =
              '  ' + $filter('translate')('reject.user.licenceexpiretodaydemo');
          } else if (end_date && diffD < 0) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = diffD;
            $rootScope.xgos.licence.color = 'danger';
            var date = $filter('date')(end_date, 'dd MMM yyyy');
            $rootScope.xgos.licence.message =
              '  ' +
              $filter('translate')('reject.user.licence.expireedemo') +
              ' ' +
              date;
          }
        }
      }
    }

    function setLicenceElse(licence) {
      var actualDate = new Date();

      if (licence.start_date && licence.start_date !== '*') {
        var date_start_split = licence.start_date.split('-');
        var start_date = new Date(
          parseInt(date_start_split[2]),
          parseInt(date_start_split[1]) - 1,
          parseInt(date_start_split[0])
        );
        if (!isNaN(start_date)) {
          var diffS = differenceInDays(start_date, actualDate);
          var diffSM = differenceInMinutes(start_date, actualDate);
          if (start_date && diffS < 0) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = Math.abs(diffS);
            $rootScope.xgos.licence.color = 'warning';
            $rootScope.xgos.licence.message =
              '  ' +
              $filter('translate')('reject.user.startsat') +
              $rootScope.xgos.licence.delay +
              ' ' +
              $filter('translate')('elastic.search.day');
            return;
          } else if (start_date && diffS === 0 && diffSM < 0) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = Math.abs(diffSM);
            $rootScope.xgos.licence.color = 'warning';
            $rootScope.xgos.licence.message =
              '  ' +
              $filter('translate')('reject.user.startsat') +
              $rootScope.xgos.licence.delay +
              ' ' +
              $filter('translate')('elastic.search.minutes');
            return;
          }
        }
      }

      if (licence.end_date && licence.end_date !== '*') {
        var date_split = licence.end_date.split('-');
        var end_date = new Date(
          parseInt(date_split[2]),
          parseInt(date_split[1]) - 1,
          parseInt(date_split[0])
        );
        if (!isNaN(end_date)) {
          var diffD = differenceInDays(actualDate, end_date);
          if (end_date && diffD < 30 && diffD > 1) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = diffD;
            $rootScope.xgos.licence.color = 'warning';
            $rootScope.xgos.licence.message =
              '  ' +
              $filter('translate')('reject.user.licenceexpire') +
              $rootScope.xgos.licence.delay +
              ' ' +
              $filter('translate')('elastic.search.day');
          } else if (end_date && diffD <= 1 && diffD >= 0) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = diffD;
            $rootScope.xgos.licence.color = 'danger';
            $rootScope.xgos.licence.message =
              '  ' + $filter('translate')('reject.user.licenceexpiretoday');
          } else if (end_date && diffD < 0 && diffD >= -30) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = Math.abs(diffD);
            $rootScope.xgos.licence.color = 'danger';
            var blockedday = new Date(end_date);
            blockedday.setDate(blockedday.getDate() + 30);
            var date = $filter('date')(end_date, 'dd MMM yyyy');
            $rootScope.xgos.licence.message =
              '  ' +
              $filter('translate')('reject.user.licence.expired') +
              ' ' +
              date +
              '.  ' +
              $filter('translate')('reject.user.licence.blocked') +
              ' ' +
              $filter('date')(blockedday, 'dd MMM yyyy');
          } else if (end_date && diffD < -30) {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.delay = Math.abs(diffD);
            $rootScope.xgos.licence.color = 'danger';
            var date = $filter('date')(end_date, 'dd MMM yyyy');
            $rootScope.xgos.licence.message =
              '  ' +
              $filter('translate')('reject.user.licence.expired') +
              ' ' +
              date;
          }
        }
      }
    }

    function checkLicence(licence) {
      $timeout(function() {
        try {
          if (licence.type === 'no licence') {
            $rootScope.xgos.licence.type = licence.type;
            $rootScope.xgos.licence.lastmonth = true;
            $rootScope.xgos.licence.color = 'danger';
            $rootScope.xgos.licence.message =
              '  ' + $filter('translate')('licence.licence.nolicence');
          } else if (licence.type === 'demo') {
            setLicenceDemo(licence);
          } else {
            setLicenceElse(licence);
          }
        } catch (e) {
          console.error(e);
        }
      }, 500);
    }

    return {
      resources: resources,
      getLicenceParams: getLicenceParams,
      getAllLicences: getAllLicences,
      getLicence: getLicence,
      checkLicence: checkLicence,
      CheckLicenceUploaded: CheckLicenceUploaded,
      removeuploaded: removeuploaded,
      validerLicence: validerLicence,
      reloadRepository: reloadRepository,
      canCreateApp: cancreateapp,
    };
  };

  licenceFactory.$inject = ['$http', '$rootScope', '$filter', '$timeout'];
  return licenceFactory;
});
